//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// サウンドの OpenBSD sndio ドライバ
//

#pragma once

#include "sounddriver.h"
#include <sndio.h>

class SoundDriverSndIO : public SoundDriver
{
	using inherited = SoundDriver;
 public:
	explicit SoundDriverSndIO(HostDevice *hostdev_);
	~SoundDriverSndIO() override;

	bool InitDriver(bool startup = true) override;

	void Write(const int16 *) override;

	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	void Close();

	sio_hdl *sio {};
};
