//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// autofd
//

#pragma once

#include <unistd.h>

// 自動変数みたいな生存期間を持つディスクリプタ
class autofd
{
 public:
	autofd() {
		fd = -1;
	}
	autofd(int fd_) {
		fd = fd_;
	}

	~autofd() {
		Close();
	}

	autofd& operator=(int fd_) {
		fd = fd_;
		return *this;
	}
	operator int() const {
		return fd;
	}

	// 明示的にクローズする
	int Close() {
		int rv = 0;
		if (Valid()) {
			rv = close(fd);
			fd = -1;
		}
		return rv;
	}

	// fd が有効なら true を返す
	bool Valid() const {
		return (fd >= 0);
	}

 private:
	int fd;
};
