//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// ホストサウンドのドライバ(基本クラス)
//

#pragma once

#include "driver.h"

class SoundDriver : public Driver
{
	using inherited = Driver;

 protected:
	SoundDriver(HostDevice *hostdev_, const char *drivername_);
 public:
	~SoundDriver() override;

	bool InitDriver(bool startup = true) override;

	// ブロックをホストに出力する。
	virtual void Write(const int16 *blk) = 0;

 protected:
	uint freq {};
	uint32 blkbytes {};
};
