//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// サブウィンドウ
//

#pragma once

#include "wxnono.h"

class WXTextScreen;

// サブウィンドウ
//
// メインウィンドウのメニューから表示されて、表示されてる間チェック状態を
// 維持するタイプのウィンドウ。クローズ処理が共通に必要なだけで、中身に
// ついては関与していない。
class WXSubWindow : public wxFrame
{
	using inherited = wxFrame;
 public:
	static const int DEFAULT_STYLE =
		(wxDEFAULT_FRAME_STYLE | wxFRAME_FLOAT_ON_PARENT)
		& ~wxMAXIMIZE_BOX
		& ~wxRESIZE_BORDER;

 public:
	WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name,
		int style);
	WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name)
		: WXSubWindow(parent, id, name, DEFAULT_STYLE) { }
	~WXSubWindow() override;

	// フォントサイズ変更
	virtual void FontChanged();

	void Fit() override;
	bool Layout() override;

 protected:
	// 自前レイアウト方式を使うことを宣言する。
	void SetMyLayout();

	// 自前レイアウト方式のサイズに関する情報を取得する。
	virtual bool GetMySizeHints(wxSize *newsz, wxSize *minsz, wxSize *maxsz,
		wxSize *incsz);

	// 自前レイアウト。
	// false を返したら子コントロールを配置してよい。
	bool MyLayout();

	// Sizer のためにオリジナルのほうのレイアウトを呼ぶ場合に使う。
	bool BaseLayout() { return inherited::Layout(); }

 private:
	void OnClose(wxCloseEvent& event);

	wxSize DoMySizeHints();

	// 自前レイアウト方式用。
	bool my_layout {};			// 自前方式を使う場合は true
	bool my_layout_pass2 {};	// 1パス目/2パス目の区別用。
	wxSize prev_border {};		// 前回のウィンドウマネージャ装飾サイズ

	wxDECLARE_EVENT_TABLE();
};
