import {
  addAlignmentToDoc,
  align,
  breakParent,
  conditionalGroup,
  cursor,
  dedent,
  dedentToRoot,
  fill,
  group,
  hardline,
  hardlineWithoutBreakParent,
  ifBreak,
  indent,
  indentIfBreak,
  join,
  label,
  line,
  lineSuffix,
  lineSuffixBoundary,
  literalline,
  literallineWithoutBreakParent,
  markAsRoot,
  softline,
  trim,
} from "./builders/index.js";
import { printDocToString } from "./printer/printer.js";
import {
  canBreak,
  findInDoc,
  mapDoc,
  removeLines,
  replaceEndOfLine,
  stripTrailingHardline,
  traverseDoc,
  willBreak,
} from "./utilities/index.js";

export const builders = {
  join,
  line,
  softline,
  hardline,
  literalline,
  group,
  conditionalGroup,
  fill,
  lineSuffix,
  lineSuffixBoundary,
  cursor,
  breakParent,
  ifBreak,
  trim,
  indent,
  indentIfBreak,
  align,
  addAlignmentToDoc,
  markAsRoot,
  dedentToRoot,
  dedent,
  hardlineWithoutBreakParent,
  literallineWithoutBreakParent,
  label,
  // TODO: Remove this in v4
  concat: (parts) => parts,
};
export const printer = { printDocToString };
export const utils = {
  willBreak,
  traverseDoc,
  findInDoc,
  mapDoc,
  removeLines,
  stripTrailingHardline,
  replaceEndOfLine,
  canBreak,
};
