
/*--------------------------------------------------------------------*/
/*--- begin                                           genoffsets.c ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, a dynamic binary instrumentation
   framework.

   Copyright (C) 2004-2015 OpenWorks LLP
      info@open-works.net

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.

   The GNU General Public License is contained in the file COPYING.

   Neither the names of the U.S. Department of Energy nor the
   University of California nor the names of its contributors may be
   used to endorse or promote products derived from this software
   without prior written permission.
*/

#include <stdio.h>

/* A program which generates the macros found in pub/libvex_guest_offsets.h.
   Considerations for cross-compiliation are not needed since the offsets
   should not change when compiled on different architectures.
*/

#include "../pub/libvex_basictypes.h"
#include "../pub/libvex_guest_x86.h"
#include "../pub/libvex_guest_amd64.h"
#include "../pub/libvex_guest_ppc32.h"
#include "../pub/libvex_guest_ppc64.h"
#include "../pub/libvex_guest_arm.h"
#include "../pub/libvex_guest_arm64.h"
#include "../pub/libvex_guest_s390x.h"
#include "../pub/libvex_guest_mips32.h"
#include "../pub/libvex_guest_mips64.h"
#include "../pub/libvex_guest_tilegx.h"
#include "../pub/libvex_guest_riscv64.h"

#undef guest_LR

#define VG_STRINGIFZ(__str)  #__str
#define VG_STRINGIFY(__str)  VG_STRINGIFZ(__str)

#define my_offsetof(__type,__field) (&((__type*)0)->__field)

#ifdef _WIN64
#define GENOFFSET(_structUppercase,_structLowercase,_fieldname)  \
      printf("#define OFFSET_%s_%s %#llx\n", \
      VG_STRINGIFY(_structLowercase), \
      VG_STRINGIFY(_fieldname), \
         (long long)(my_offsetof(VexGuest##_structUppercase##State, \
          guest_##_fieldname)) \
   )
#else
#define GENOFFSET(_structUppercase,_structLowercase,_fieldname)  \
      printf("#define OFFSET_%s_%s %#lx\n", \
      VG_STRINGIFY(_structLowercase), \
      VG_STRINGIFY(_fieldname), \
         (long)(my_offsetof(VexGuest##_structUppercase##State, \
          guest_##_fieldname)) \
   )
#endif


int main(int argc, char **argv)
{
   // x86
   GENOFFSET(X86,x86,EAX);
   GENOFFSET(X86,x86,ECX);
   GENOFFSET(X86,x86,EDX);
   GENOFFSET(X86,x86,EBX);
   GENOFFSET(X86,x86,ESP);
   GENOFFSET(X86,x86,EBP);
   GENOFFSET(X86,x86,ESI);
   GENOFFSET(X86,x86,EDI);
   GENOFFSET(X86,x86,CC_OP);
   GENOFFSET(X86,x86,CC_DEP1);
   GENOFFSET(X86,x86,CC_DEP2);
   GENOFFSET(X86,x86,CC_NDEP);
   GENOFFSET(X86,x86,DFLAG);
   GENOFFSET(X86,x86,IDFLAG);
   GENOFFSET(X86,x86,ACFLAG);
   GENOFFSET(X86,x86,EIP);
   GENOFFSET(X86,x86,FPREG);
   GENOFFSET(X86,x86,FPTAG);
   GENOFFSET(X86,x86,FPROUND);
   GENOFFSET(X86,x86,FC3210);
   GENOFFSET(X86,x86,FTOP);
   GENOFFSET(X86,x86,SSEROUND);
   GENOFFSET(X86,x86,XMM0);
   GENOFFSET(X86,x86,XMM1);
   GENOFFSET(X86,x86,XMM2);
   GENOFFSET(X86,x86,XMM3);
   GENOFFSET(X86,x86,XMM4);
   GENOFFSET(X86,x86,XMM5);
   GENOFFSET(X86,x86,XMM6);
   GENOFFSET(X86,x86,XMM7);
   GENOFFSET(X86,x86,CS);
   GENOFFSET(X86,x86,DS);
   GENOFFSET(X86,x86,ES);
   GENOFFSET(X86,x86,FS);
   GENOFFSET(X86,x86,GS);
   GENOFFSET(X86,x86,SS);
   GENOFFSET(X86,x86,LDT);
   GENOFFSET(X86,x86,GDT);
   GENOFFSET(X86,x86,EMNOTE);
   GENOFFSET(X86,x86,CMSTART);
   GENOFFSET(X86,x86,CMLEN);
   GENOFFSET(X86,x86,NRADDR);
   GENOFFSET(X86,x86,SC_CLASS);
   GENOFFSET(X86,x86,IP_AT_SYSCALL);

   // amd64
   GENOFFSET(AMD64,amd64,RAX);
   GENOFFSET(AMD64,amd64,RBX);
   GENOFFSET(AMD64,amd64,RCX);
   GENOFFSET(AMD64,amd64,RDX);
   GENOFFSET(AMD64,amd64,RSI);
   GENOFFSET(AMD64,amd64,RDI);
   GENOFFSET(AMD64,amd64,RSP);
   GENOFFSET(AMD64,amd64,RBP);
   GENOFFSET(AMD64,amd64,R8);
   GENOFFSET(AMD64,amd64,R9);
   GENOFFSET(AMD64,amd64,R10);
   GENOFFSET(AMD64,amd64,R11);
   GENOFFSET(AMD64,amd64,R12);
   GENOFFSET(AMD64,amd64,R13);
   GENOFFSET(AMD64,amd64,R14);
   GENOFFSET(AMD64,amd64,R15);
   GENOFFSET(AMD64,amd64,RIP);
   GENOFFSET(AMD64,amd64,IP_AT_SYSCALL);
   GENOFFSET(AMD64,amd64,RAX);
   GENOFFSET(AMD64,amd64,RCX);
   GENOFFSET(AMD64,amd64,RDX);
   GENOFFSET(AMD64,amd64,RBX);
   GENOFFSET(AMD64,amd64,RSP);
   GENOFFSET(AMD64,amd64,RBP);
   GENOFFSET(AMD64,amd64,RSI);
   GENOFFSET(AMD64,amd64,RDI);
   GENOFFSET(AMD64,amd64,R8);
   GENOFFSET(AMD64,amd64,R9);
   GENOFFSET(AMD64,amd64,R10);
   GENOFFSET(AMD64,amd64,R11);
   GENOFFSET(AMD64,amd64,R12);
   GENOFFSET(AMD64,amd64,R13);
   GENOFFSET(AMD64,amd64,R14);
   GENOFFSET(AMD64,amd64,R15);
   GENOFFSET(AMD64,amd64,CC_OP);
   GENOFFSET(AMD64,amd64,CC_DEP1);
   GENOFFSET(AMD64,amd64,CC_DEP2);
   GENOFFSET(AMD64,amd64,CC_NDEP);
   GENOFFSET(AMD64,amd64,DFLAG);
   GENOFFSET(AMD64,amd64,RIP);
   GENOFFSET(AMD64,amd64,ACFLAG);
   GENOFFSET(AMD64,amd64,IDFLAG);
   GENOFFSET(AMD64,amd64,FS_CONST);
   GENOFFSET(AMD64,amd64,SSEROUND);
   GENOFFSET(AMD64,amd64,YMM0);
   GENOFFSET(AMD64,amd64,YMM1);
   GENOFFSET(AMD64,amd64,YMM2);
   GENOFFSET(AMD64,amd64,YMM3);
   GENOFFSET(AMD64,amd64,YMM4);
   GENOFFSET(AMD64,amd64,YMM5);
   GENOFFSET(AMD64,amd64,YMM6);
   GENOFFSET(AMD64,amd64,YMM7);
   GENOFFSET(AMD64,amd64,YMM8);
   GENOFFSET(AMD64,amd64,YMM9);
   GENOFFSET(AMD64,amd64,YMM10);
   GENOFFSET(AMD64,amd64,YMM11);
   GENOFFSET(AMD64,amd64,YMM12);
   GENOFFSET(AMD64,amd64,YMM13);
   GENOFFSET(AMD64,amd64,YMM14);
   GENOFFSET(AMD64,amd64,YMM15);
   GENOFFSET(AMD64,amd64,YMM16);
   GENOFFSET(AMD64,amd64,CR0);
   GENOFFSET(AMD64,amd64,CR1);
   GENOFFSET(AMD64,amd64,CR2);
   GENOFFSET(AMD64,amd64,CR3);
   GENOFFSET(AMD64,amd64,CR4);
   GENOFFSET(AMD64,amd64,CR5);
   GENOFFSET(AMD64,amd64,CR6);
   GENOFFSET(AMD64,amd64,CR7);
   GENOFFSET(AMD64,amd64,CR8);
   GENOFFSET(AMD64,amd64,CR9);
   GENOFFSET(AMD64,amd64,CR10);
   GENOFFSET(AMD64,amd64,CR11);
   GENOFFSET(AMD64,amd64,CR12);
   GENOFFSET(AMD64,amd64,CR13);
   GENOFFSET(AMD64,amd64,CR14);
   GENOFFSET(AMD64,amd64,CR15);
   GENOFFSET(AMD64,amd64,FTOP);
   GENOFFSET(AMD64,amd64,FPREG);
   GENOFFSET(AMD64,amd64,FPTAG);
   GENOFFSET(AMD64,amd64,FPROUND);
   GENOFFSET(AMD64,amd64,FC3210);
   GENOFFSET(AMD64,amd64,EMNOTE);
   GENOFFSET(AMD64,amd64,CMSTART);
   GENOFFSET(AMD64,amd64,CMLEN);
   GENOFFSET(AMD64,amd64,NRADDR);
   GENOFFSET(AMD64,amd64,SC_CLASS);
   GENOFFSET(AMD64,amd64,GS_CONST);
   GENOFFSET(AMD64,amd64,IP_AT_SYSCALL);
   GENOFFSET(AMD64,amd64,CS);
   GENOFFSET(AMD64,amd64,DS);
   GENOFFSET(AMD64,amd64,ES);
   GENOFFSET(AMD64,amd64,FS);
   GENOFFSET(AMD64,amd64,GS);
   GENOFFSET(AMD64,amd64,SS);

   // ppc32
   GENOFFSET(PPC32,ppc32,GPR0);
   GENOFFSET(PPC32,ppc32,GPR1);
   GENOFFSET(PPC32,ppc32,GPR2);
   GENOFFSET(PPC32,ppc32,GPR3);
   GENOFFSET(PPC32,ppc32,GPR4);
   GENOFFSET(PPC32,ppc32,GPR5);
   GENOFFSET(PPC32,ppc32,GPR6);
   GENOFFSET(PPC32,ppc32,GPR7);
   GENOFFSET(PPC32,ppc32,GPR8);
   GENOFFSET(PPC32,ppc32,GPR9);
   GENOFFSET(PPC32,ppc32,GPR10);
   GENOFFSET(PPC32,ppc32,GPR11);
   GENOFFSET(PPC32,ppc32,GPR12);
   GENOFFSET(PPC32,ppc32,GPR13);
   GENOFFSET(PPC32,ppc32,GPR14);
   GENOFFSET(PPC32,ppc32,GPR15);
   GENOFFSET(PPC32,ppc32,GPR16);
   GENOFFSET(PPC32,ppc32,GPR17);
   GENOFFSET(PPC32,ppc32,GPR18);
   GENOFFSET(PPC32,ppc32,GPR19);
   GENOFFSET(PPC32,ppc32,GPR20);
   GENOFFSET(PPC32,ppc32,GPR21);
   GENOFFSET(PPC32,ppc32,GPR22);
   GENOFFSET(PPC32,ppc32,GPR23);
   GENOFFSET(PPC32,ppc32,GPR24);
   GENOFFSET(PPC32,ppc32,GPR25);
   GENOFFSET(PPC32,ppc32,GPR26);
   GENOFFSET(PPC32,ppc32,GPR27);
   GENOFFSET(PPC32,ppc32,GPR28);
   GENOFFSET(PPC32,ppc32,GPR29);
   GENOFFSET(PPC32,ppc32,GPR30);
   GENOFFSET(PPC32,ppc32,GPR31);
   GENOFFSET(PPC32,ppc32,VSR0);
   GENOFFSET(PPC32,ppc32,VSR1);
   GENOFFSET(PPC32,ppc32,VSR2);
   GENOFFSET(PPC32,ppc32,VSR3);
   GENOFFSET(PPC32,ppc32,VSR4);
   GENOFFSET(PPC32,ppc32,VSR5);
   GENOFFSET(PPC32,ppc32,VSR6);
   GENOFFSET(PPC32,ppc32,VSR7);
   GENOFFSET(PPC32,ppc32,VSR8);
   GENOFFSET(PPC32,ppc32,VSR9);
   GENOFFSET(PPC32,ppc32,VSR10);
   GENOFFSET(PPC32,ppc32,VSR11);
   GENOFFSET(PPC32,ppc32,VSR12);
   GENOFFSET(PPC32,ppc32,VSR13);
   GENOFFSET(PPC32,ppc32,VSR14);
   GENOFFSET(PPC32,ppc32,VSR15);
   GENOFFSET(PPC32,ppc32,VSR16);
   GENOFFSET(PPC32,ppc32,VSR17);
   GENOFFSET(PPC32,ppc32,VSR18);
   GENOFFSET(PPC32,ppc32,VSR19);
   GENOFFSET(PPC32,ppc32,VSR20);
   GENOFFSET(PPC32,ppc32,VSR21);
   GENOFFSET(PPC32,ppc32,VSR22);
   GENOFFSET(PPC32,ppc32,VSR23);
   GENOFFSET(PPC32,ppc32,VSR24);
   GENOFFSET(PPC32,ppc32,VSR25);
   GENOFFSET(PPC32,ppc32,VSR26);
   GENOFFSET(PPC32,ppc32,VSR27);
   GENOFFSET(PPC32,ppc32,VSR28);
   GENOFFSET(PPC32,ppc32,VSR29);
   GENOFFSET(PPC32,ppc32,VSR30);
   GENOFFSET(PPC32,ppc32,VSR31);
   GENOFFSET(PPC32,ppc32,VSR32);
   GENOFFSET(PPC32,ppc32,VSR33);
   GENOFFSET(PPC32,ppc32,VSR34);
   GENOFFSET(PPC32,ppc32,VSR35);
   GENOFFSET(PPC32,ppc32,VSR36);
   GENOFFSET(PPC32,ppc32,VSR37);
   GENOFFSET(PPC32,ppc32,VSR38);
   GENOFFSET(PPC32,ppc32,VSR39);
   GENOFFSET(PPC32,ppc32,VSR40);
   GENOFFSET(PPC32,ppc32,VSR41);
   GENOFFSET(PPC32,ppc32,VSR42);
   GENOFFSET(PPC32,ppc32,VSR43);
   GENOFFSET(PPC32,ppc32,VSR44);
   GENOFFSET(PPC32,ppc32,VSR45);
   GENOFFSET(PPC32,ppc32,VSR46);
   GENOFFSET(PPC32,ppc32,VSR47);
   GENOFFSET(PPC32,ppc32,VSR48);
   GENOFFSET(PPC32,ppc32,VSR49);
   GENOFFSET(PPC32,ppc32,VSR50);
   GENOFFSET(PPC32,ppc32,VSR51);
   GENOFFSET(PPC32,ppc32,VSR52);
   GENOFFSET(PPC32,ppc32,VSR53);
   GENOFFSET(PPC32,ppc32,VSR54);
   GENOFFSET(PPC32,ppc32,VSR55);
   GENOFFSET(PPC32,ppc32,VSR56);
   GENOFFSET(PPC32,ppc32,VSR57);
   GENOFFSET(PPC32,ppc32,VSR58);
   GENOFFSET(PPC32,ppc32,VSR59);
   GENOFFSET(PPC32,ppc32,VSR60);
   GENOFFSET(PPC32,ppc32,VSR61);
   GENOFFSET(PPC32,ppc32,VSR62);
   GENOFFSET(PPC32,ppc32,VSR63);
   GENOFFSET(PPC32,ppc32,CIA);
   GENOFFSET(PPC32,ppc32,LR);
   GENOFFSET(PPC32,ppc32,CTR);
   GENOFFSET(PPC32,ppc32,XER_SO);
   GENOFFSET(PPC32,ppc32,XER_OV);
   GENOFFSET(PPC32,ppc32,XER_CA);
   GENOFFSET(PPC32,ppc32,XER_BC);
   GENOFFSET(PPC32,ppc32,CR0_321);
   GENOFFSET(PPC32,ppc32,CR0_0);
   GENOFFSET(PPC32,ppc32,CR1_321);
   GENOFFSET(PPC32,ppc32,CR1_0);
   GENOFFSET(PPC32,ppc32,CR2_321);
   GENOFFSET(PPC32,ppc32,CR2_0);
   GENOFFSET(PPC32,ppc32,CR3_321);
   GENOFFSET(PPC32,ppc32,CR3_0);
   GENOFFSET(PPC32,ppc32,CR4_321);
   GENOFFSET(PPC32,ppc32,CR4_0);
   GENOFFSET(PPC32,ppc32,CR5_321);
   GENOFFSET(PPC32,ppc32,CR5_0);
   GENOFFSET(PPC32,ppc32,CR6_321);
   GENOFFSET(PPC32,ppc32,CR6_0);
   GENOFFSET(PPC32,ppc32,CR7_321);
   GENOFFSET(PPC32,ppc32,CR7_0);
   GENOFFSET(PPC32,ppc32,FPROUND);
   GENOFFSET(PPC32,ppc32,DFPROUND);
   GENOFFSET(PPC32,ppc32,C_FPCC);
   GENOFFSET(PPC32,ppc32,VRSAVE);
   GENOFFSET(PPC32,ppc32,VSCR);
   GENOFFSET(PPC32,ppc32,EMNOTE);
   GENOFFSET(PPC32,ppc32,CMSTART);
   GENOFFSET(PPC32,ppc32,CMLEN);
   GENOFFSET(PPC32,ppc32,NRADDR);
   GENOFFSET(PPC32,ppc32,NRADDR_GPR2);
   GENOFFSET(PPC32,ppc32,REDIR_SP);
   GENOFFSET(PPC32,ppc32,REDIR_STACK);
   GENOFFSET(PPC32,ppc32,IP_AT_SYSCALL);
   GENOFFSET(PPC32,ppc32,SPRG3_RO);
   GENOFFSET(PPC32,ppc32,TFHAR);
   GENOFFSET(PPC32,ppc32,TEXASR);
   GENOFFSET(PPC32,ppc32,TFIAR);
   GENOFFSET(PPC32,ppc32,PPR);
   GENOFFSET(PPC32,ppc32,TEXASRU);
   GENOFFSET(PPC32,ppc32,PSPB);

   // ppc64
   GENOFFSET(PPC64,ppc64,GPR0);
   GENOFFSET(PPC64,ppc64,GPR1);
   GENOFFSET(PPC64,ppc64,GPR2);
   GENOFFSET(PPC64,ppc64,GPR3);
   GENOFFSET(PPC64,ppc64,GPR4);
   GENOFFSET(PPC64,ppc64,GPR5);
   GENOFFSET(PPC64,ppc64,GPR6);
   GENOFFSET(PPC64,ppc64,GPR7);
   GENOFFSET(PPC64,ppc64,GPR8);
   GENOFFSET(PPC64,ppc64,GPR9);
   GENOFFSET(PPC64,ppc64,GPR10);
   GENOFFSET(PPC64,ppc64,GPR11);
   GENOFFSET(PPC64,ppc64,GPR12);
   GENOFFSET(PPC64,ppc64,GPR13);
   GENOFFSET(PPC64,ppc64,GPR14);
   GENOFFSET(PPC64,ppc64,GPR15);
   GENOFFSET(PPC64,ppc64,GPR16);
   GENOFFSET(PPC64,ppc64,GPR17);
   GENOFFSET(PPC64,ppc64,GPR18);
   GENOFFSET(PPC64,ppc64,GPR19);
   GENOFFSET(PPC64,ppc64,GPR20);
   GENOFFSET(PPC64,ppc64,GPR21);
   GENOFFSET(PPC64,ppc64,GPR22);
   GENOFFSET(PPC64,ppc64,GPR23);
   GENOFFSET(PPC64,ppc64,GPR24);
   GENOFFSET(PPC64,ppc64,GPR25);
   GENOFFSET(PPC64,ppc64,GPR26);
   GENOFFSET(PPC64,ppc64,GPR27);
   GENOFFSET(PPC64,ppc64,GPR28);
   GENOFFSET(PPC64,ppc64,GPR29);
   GENOFFSET(PPC64,ppc64,GPR30);
   GENOFFSET(PPC64,ppc64,GPR31);
   GENOFFSET(PPC64,ppc64,VSR0);
   GENOFFSET(PPC64,ppc64,VSR1);
   GENOFFSET(PPC64,ppc64,VSR2);
   GENOFFSET(PPC64,ppc64,VSR3);
   GENOFFSET(PPC64,ppc64,VSR4);
   GENOFFSET(PPC64,ppc64,VSR5);
   GENOFFSET(PPC64,ppc64,VSR6);
   GENOFFSET(PPC64,ppc64,VSR7);
   GENOFFSET(PPC64,ppc64,VSR8);
   GENOFFSET(PPC64,ppc64,VSR9);
   GENOFFSET(PPC64,ppc64,VSR10);
   GENOFFSET(PPC64,ppc64,VSR11);
   GENOFFSET(PPC64,ppc64,VSR12);
   GENOFFSET(PPC64,ppc64,VSR13);
   GENOFFSET(PPC64,ppc64,VSR14);
   GENOFFSET(PPC64,ppc64,VSR15);
   GENOFFSET(PPC64,ppc64,VSR16);
   GENOFFSET(PPC64,ppc64,VSR17);
   GENOFFSET(PPC64,ppc64,VSR18);
   GENOFFSET(PPC64,ppc64,VSR19);
   GENOFFSET(PPC64,ppc64,VSR20);
   GENOFFSET(PPC64,ppc64,VSR21);
   GENOFFSET(PPC64,ppc64,VSR22);
   GENOFFSET(PPC64,ppc64,VSR23);
   GENOFFSET(PPC64,ppc64,VSR24);
   GENOFFSET(PPC64,ppc64,VSR25);
   GENOFFSET(PPC64,ppc64,VSR26);
   GENOFFSET(PPC64,ppc64,VSR27);
   GENOFFSET(PPC64,ppc64,VSR28);
   GENOFFSET(PPC64,ppc64,VSR29);
   GENOFFSET(PPC64,ppc64,VSR30);
   GENOFFSET(PPC64,ppc64,VSR31);
   GENOFFSET(PPC64,ppc64,VSR32);
   GENOFFSET(PPC64,ppc64,VSR33);
   GENOFFSET(PPC64,ppc64,VSR34);
   GENOFFSET(PPC64,ppc64,VSR35);
   GENOFFSET(PPC64,ppc64,VSR36);
   GENOFFSET(PPC64,ppc64,VSR37);
   GENOFFSET(PPC64,ppc64,VSR38);
   GENOFFSET(PPC64,ppc64,VSR39);
   GENOFFSET(PPC64,ppc64,VSR40);
   GENOFFSET(PPC64,ppc64,VSR41);
   GENOFFSET(PPC64,ppc64,VSR42);
   GENOFFSET(PPC64,ppc64,VSR43);
   GENOFFSET(PPC64,ppc64,VSR44);
   GENOFFSET(PPC64,ppc64,VSR45);
   GENOFFSET(PPC64,ppc64,VSR46);
   GENOFFSET(PPC64,ppc64,VSR47);
   GENOFFSET(PPC64,ppc64,VSR48);
   GENOFFSET(PPC64,ppc64,VSR49);
   GENOFFSET(PPC64,ppc64,VSR50);
   GENOFFSET(PPC64,ppc64,VSR51);
   GENOFFSET(PPC64,ppc64,VSR52);
   GENOFFSET(PPC64,ppc64,VSR53);
   GENOFFSET(PPC64,ppc64,VSR54);
   GENOFFSET(PPC64,ppc64,VSR55);
   GENOFFSET(PPC64,ppc64,VSR56);
   GENOFFSET(PPC64,ppc64,VSR57);
   GENOFFSET(PPC64,ppc64,VSR58);
   GENOFFSET(PPC64,ppc64,VSR59);
   GENOFFSET(PPC64,ppc64,VSR60);
   GENOFFSET(PPC64,ppc64,VSR61);
   GENOFFSET(PPC64,ppc64,VSR62);
   GENOFFSET(PPC64,ppc64,VSR63);
   GENOFFSET(PPC64,ppc64,CIA);
   GENOFFSET(PPC64,ppc64,LR);
   GENOFFSET(PPC64,ppc64,CTR);
   GENOFFSET(PPC64,ppc64,XER_SO);
   GENOFFSET(PPC64,ppc64,XER_OV);
   GENOFFSET(PPC64,ppc64,XER_CA);
   GENOFFSET(PPC64,ppc64,XER_BC);
   GENOFFSET(PPC64,ppc64,CR0_321);
   GENOFFSET(PPC64,ppc64,CR0_0);
   GENOFFSET(PPC64,ppc64,CR1_321);
   GENOFFSET(PPC64,ppc64,CR1_0);
   GENOFFSET(PPC64,ppc64,CR2_321);
   GENOFFSET(PPC64,ppc64,CR2_0);
   GENOFFSET(PPC64,ppc64,CR3_321);
   GENOFFSET(PPC64,ppc64,CR3_0);
   GENOFFSET(PPC64,ppc64,CR4_321);
   GENOFFSET(PPC64,ppc64,CR4_0);
   GENOFFSET(PPC64,ppc64,CR5_321);
   GENOFFSET(PPC64,ppc64,CR5_0);
   GENOFFSET(PPC64,ppc64,CR6_321);
   GENOFFSET(PPC64,ppc64,CR6_0);
   GENOFFSET(PPC64,ppc64,CR7_321);
   GENOFFSET(PPC64,ppc64,CR7_0);
   GENOFFSET(PPC64,ppc64,FPROUND);
   GENOFFSET(PPC64,ppc64,DFPROUND);
   GENOFFSET(PPC64,ppc64,C_FPCC);
   GENOFFSET(PPC64,ppc64,VRSAVE);
   GENOFFSET(PPC64,ppc64,VSCR);
   GENOFFSET(PPC64,ppc64,EMNOTE);
   GENOFFSET(PPC64,ppc64,CMSTART);
   GENOFFSET(PPC64,ppc64,CMLEN);
   GENOFFSET(PPC64,ppc64,NRADDR);
   GENOFFSET(PPC64,ppc64,NRADDR_GPR2);
   GENOFFSET(PPC64,ppc64,REDIR_SP);
   GENOFFSET(PPC64,ppc64,REDIR_STACK);
   GENOFFSET(PPC64,ppc64,IP_AT_SYSCALL);
   GENOFFSET(PPC64,ppc64,SPRG3_RO);
   GENOFFSET(PPC64,ppc64,TFHAR);
   GENOFFSET(PPC64,ppc64,TEXASR);
   GENOFFSET(PPC64,ppc64,TFIAR);
   GENOFFSET(PPC64,ppc64,PPR);
   GENOFFSET(PPC64,ppc64,TEXASRU);
   GENOFFSET(PPC64,ppc64,PSPB);

   // arm
   GENOFFSET(ARM,arm,R0);
   GENOFFSET(ARM,arm,R1);
   GENOFFSET(ARM,arm,R2);
   GENOFFSET(ARM,arm,R3);
   GENOFFSET(ARM,arm,R4);
   GENOFFSET(ARM,arm,R5);
   GENOFFSET(ARM,arm,R6);
   GENOFFSET(ARM,arm,R7);
   GENOFFSET(ARM,arm,R8);
   GENOFFSET(ARM,arm,R9);
   GENOFFSET(ARM,arm,R10);
   GENOFFSET(ARM,arm,R11);
   GENOFFSET(ARM,arm,R12);
   GENOFFSET(ARM,arm,R13);
   GENOFFSET(ARM,arm,R14);
   GENOFFSET(ARM,arm,R15T);
   GENOFFSET(ARM,arm,CC_OP);
   GENOFFSET(ARM,arm,CC_DEP1);
   GENOFFSET(ARM,arm,CC_DEP2);
   GENOFFSET(ARM,arm,CC_NDEP);
   GENOFFSET(ARM,arm,QFLAG32);
   GENOFFSET(ARM,arm,GEFLAG0);
   GENOFFSET(ARM,arm,GEFLAG1);
   GENOFFSET(ARM,arm,GEFLAG2);
   GENOFFSET(ARM,arm,GEFLAG3);
   GENOFFSET(ARM,arm,EMNOTE);
   GENOFFSET(ARM,arm,CMSTART);
   GENOFFSET(ARM,arm,CMLEN);
   GENOFFSET(ARM,arm,NRADDR);
   GENOFFSET(ARM,arm,IP_AT_SYSCALL);
   GENOFFSET(ARM,arm,D0);
   GENOFFSET(ARM,arm,D1);
   GENOFFSET(ARM,arm,D2);
   GENOFFSET(ARM,arm,D3);
   GENOFFSET(ARM,arm,D4);
   GENOFFSET(ARM,arm,D5);
   GENOFFSET(ARM,arm,D6);
   GENOFFSET(ARM,arm,D7);
   GENOFFSET(ARM,arm,D8);
   GENOFFSET(ARM,arm,D9);
   GENOFFSET(ARM,arm,D10);
   GENOFFSET(ARM,arm,D11);
   GENOFFSET(ARM,arm,D12);
   GENOFFSET(ARM,arm,D13);
   GENOFFSET(ARM,arm,D14);
   GENOFFSET(ARM,arm,D15);
   GENOFFSET(ARM,arm,D16);
   GENOFFSET(ARM,arm,D17);
   GENOFFSET(ARM,arm,D18);
   GENOFFSET(ARM,arm,D19);
   GENOFFSET(ARM,arm,D20);
   GENOFFSET(ARM,arm,D21);
   GENOFFSET(ARM,arm,D22);
   GENOFFSET(ARM,arm,D23);
   GENOFFSET(ARM,arm,D24);
   GENOFFSET(ARM,arm,D25);
   GENOFFSET(ARM,arm,D26);
   GENOFFSET(ARM,arm,D27);
   GENOFFSET(ARM,arm,D28);
   GENOFFSET(ARM,arm,D29);
   GENOFFSET(ARM,arm,D30);
   GENOFFSET(ARM,arm,D31);
   GENOFFSET(ARM,arm,FPSCR);
   GENOFFSET(ARM,arm,TPIDRURO);
   GENOFFSET(ARM,arm,ITSTATE);

   // arm64
   GENOFFSET(ARM64,arm64,X0);
   GENOFFSET(ARM64,arm64,X1);
   GENOFFSET(ARM64,arm64,X2);
   GENOFFSET(ARM64,arm64,X3);
   GENOFFSET(ARM64,arm64,X4);
   GENOFFSET(ARM64,arm64,X5);
   GENOFFSET(ARM64,arm64,X6);
   GENOFFSET(ARM64,arm64,X7);
   GENOFFSET(ARM64,arm64,X8);
   GENOFFSET(ARM64,arm64,X9);
   GENOFFSET(ARM64,arm64,X10);
   GENOFFSET(ARM64,arm64,X11);
   GENOFFSET(ARM64,arm64,X12);
   GENOFFSET(ARM64,arm64,X13);
   GENOFFSET(ARM64,arm64,X14);
   GENOFFSET(ARM64,arm64,X15);
   GENOFFSET(ARM64,arm64,X16);
   GENOFFSET(ARM64,arm64,X17);
   GENOFFSET(ARM64,arm64,X18);
   GENOFFSET(ARM64,arm64,X19);
   GENOFFSET(ARM64,arm64,X20);
   GENOFFSET(ARM64,arm64,X21);
   GENOFFSET(ARM64,arm64,X22);
   GENOFFSET(ARM64,arm64,X23);
   GENOFFSET(ARM64,arm64,X24);
   GENOFFSET(ARM64,arm64,X25);
   GENOFFSET(ARM64,arm64,X26);
   GENOFFSET(ARM64,arm64,X27);
   GENOFFSET(ARM64,arm64,X28);
   GENOFFSET(ARM64,arm64,X29);
   GENOFFSET(ARM64,arm64,X30);
   GENOFFSET(ARM64,arm64,XSP);
   GENOFFSET(ARM64,arm64,PC);
   GENOFFSET(ARM64,arm64,CC_OP);
   GENOFFSET(ARM64,arm64,CC_DEP1);
   GENOFFSET(ARM64,arm64,CC_DEP2);
   GENOFFSET(ARM64,arm64,CC_NDEP);
   GENOFFSET(ARM64,arm64,TPIDR_EL0);
   GENOFFSET(ARM64,arm64,Q0);
   GENOFFSET(ARM64,arm64,Q1);
   GENOFFSET(ARM64,arm64,Q2);
   GENOFFSET(ARM64,arm64,Q3);
   GENOFFSET(ARM64,arm64,Q4);
   GENOFFSET(ARM64,arm64,Q5);
   GENOFFSET(ARM64,arm64,Q6);
   GENOFFSET(ARM64,arm64,Q7);
   GENOFFSET(ARM64,arm64,Q8);
   GENOFFSET(ARM64,arm64,Q9);
   GENOFFSET(ARM64,arm64,Q10);
   GENOFFSET(ARM64,arm64,Q11);
   GENOFFSET(ARM64,arm64,Q12);
   GENOFFSET(ARM64,arm64,Q13);
   GENOFFSET(ARM64,arm64,Q14);
   GENOFFSET(ARM64,arm64,Q15);
   GENOFFSET(ARM64,arm64,Q16);
   GENOFFSET(ARM64,arm64,Q17);
   GENOFFSET(ARM64,arm64,Q18);
   GENOFFSET(ARM64,arm64,Q19);
   GENOFFSET(ARM64,arm64,Q20);
   GENOFFSET(ARM64,arm64,Q21);
   GENOFFSET(ARM64,arm64,Q22);
   GENOFFSET(ARM64,arm64,Q23);
   GENOFFSET(ARM64,arm64,Q24);
   GENOFFSET(ARM64,arm64,Q25);
   GENOFFSET(ARM64,arm64,Q26);
   GENOFFSET(ARM64,arm64,Q27);
   GENOFFSET(ARM64,arm64,Q28);
   GENOFFSET(ARM64,arm64,Q29);
   GENOFFSET(ARM64,arm64,Q30);
   GENOFFSET(ARM64,arm64,Q31);
   GENOFFSET(ARM64,arm64,QCFLAG);
   GENOFFSET(ARM64,arm64,EMNOTE);
   GENOFFSET(ARM64,arm64,CMSTART);
   GENOFFSET(ARM64,arm64,CMLEN);
   GENOFFSET(ARM64,arm64,NRADDR);
   GENOFFSET(ARM64,arm64,IP_AT_SYSCALL);
   GENOFFSET(ARM64,arm64,FPCR);

   // s390x
   GENOFFSET(S390X,s390x,a0);
   GENOFFSET(S390X,s390x,a1);
   GENOFFSET(S390X,s390x,a2);
   GENOFFSET(S390X,s390x,a3);
   GENOFFSET(S390X,s390x,a4);
   GENOFFSET(S390X,s390x,a5);
   GENOFFSET(S390X,s390x,a6);
   GENOFFSET(S390X,s390x,a7);
   GENOFFSET(S390X,s390x,a8);
   GENOFFSET(S390X,s390x,a9);
   GENOFFSET(S390X,s390x,a10);
   GENOFFSET(S390X,s390x,a11);
   GENOFFSET(S390X,s390x,a12);
   GENOFFSET(S390X,s390x,a13);
   GENOFFSET(S390X,s390x,a14);
   GENOFFSET(S390X,s390x,a15);
   GENOFFSET(S390X,s390x,v0);
   GENOFFSET(S390X,s390x,v1);
   GENOFFSET(S390X,s390x,v2);
   GENOFFSET(S390X,s390x,v3);
   GENOFFSET(S390X,s390x,v4);
   GENOFFSET(S390X,s390x,v5);
   GENOFFSET(S390X,s390x,v6);
   GENOFFSET(S390X,s390x,v7);
   GENOFFSET(S390X,s390x,v8);
   GENOFFSET(S390X,s390x,v9);
   GENOFFSET(S390X,s390x,v10);
   GENOFFSET(S390X,s390x,v11);
   GENOFFSET(S390X,s390x,v12);
   GENOFFSET(S390X,s390x,v13);
   GENOFFSET(S390X,s390x,v14);
   GENOFFSET(S390X,s390x,v15);
   GENOFFSET(S390X,s390x,v16);
   GENOFFSET(S390X,s390x,v17);
   GENOFFSET(S390X,s390x,v18);
   GENOFFSET(S390X,s390x,v19);
   GENOFFSET(S390X,s390x,v20);
   GENOFFSET(S390X,s390x,v21);
   GENOFFSET(S390X,s390x,v22);
   GENOFFSET(S390X,s390x,v23);
   GENOFFSET(S390X,s390x,v24);
   GENOFFSET(S390X,s390x,v25);
   GENOFFSET(S390X,s390x,v26);
   GENOFFSET(S390X,s390x,v27);
   GENOFFSET(S390X,s390x,v28);
   GENOFFSET(S390X,s390x,v29);
   GENOFFSET(S390X,s390x,v30);
   GENOFFSET(S390X,s390x,v31);
   GENOFFSET(S390X,s390x,r0);
   GENOFFSET(S390X,s390x,r1);
   GENOFFSET(S390X,s390x,r2);
   GENOFFSET(S390X,s390x,r3);
   GENOFFSET(S390X,s390x,r4);
   GENOFFSET(S390X,s390x,r5);
   GENOFFSET(S390X,s390x,r6);
   GENOFFSET(S390X,s390x,r7);
   GENOFFSET(S390X,s390x,r8);
   GENOFFSET(S390X,s390x,r9);
   GENOFFSET(S390X,s390x,r10);
   GENOFFSET(S390X,s390x,r11);
   GENOFFSET(S390X,s390x,r12);
   GENOFFSET(S390X,s390x,r13);
   GENOFFSET(S390X,s390x,r14);
   GENOFFSET(S390X,s390x,r15);
   GENOFFSET(S390X,s390x,counter);
   GENOFFSET(S390X,s390x,fpc);
   GENOFFSET(S390X,s390x,IA);
   GENOFFSET(S390X,s390x,SYSNO);
   GENOFFSET(S390X,s390x,CC_OP);
   GENOFFSET(S390X,s390x,CC_DEP1);
   GENOFFSET(S390X,s390x,CC_DEP2);
   GENOFFSET(S390X,s390x,CC_NDEP);
   GENOFFSET(S390X,s390x,NRADDR);
   GENOFFSET(S390X,s390x,CMSTART);
   GENOFFSET(S390X,s390x,CMLEN);
   GENOFFSET(S390X,s390x,IP_AT_SYSCALL);
   GENOFFSET(S390X,s390x,EMNOTE);

   // MIPS32
   GENOFFSET(MIPS32,mips32,r0);
   GENOFFSET(MIPS32,mips32,r1);
   GENOFFSET(MIPS32,mips32,r2);
   GENOFFSET(MIPS32,mips32,r3);
   GENOFFSET(MIPS32,mips32,r4);
   GENOFFSET(MIPS32,mips32,r5);
   GENOFFSET(MIPS32,mips32,r6);
   GENOFFSET(MIPS32,mips32,r7);
   GENOFFSET(MIPS32,mips32,r8);
   GENOFFSET(MIPS32,mips32,r9);
   GENOFFSET(MIPS32,mips32,r10);
   GENOFFSET(MIPS32,mips32,r11);
   GENOFFSET(MIPS32,mips32,r12);
   GENOFFSET(MIPS32,mips32,r13);
   GENOFFSET(MIPS32,mips32,r14);
   GENOFFSET(MIPS32,mips32,r15);
   GENOFFSET(MIPS32,mips32,r16);
   GENOFFSET(MIPS32,mips32,r17);
   GENOFFSET(MIPS32,mips32,r18);
   GENOFFSET(MIPS32,mips32,r19);
   GENOFFSET(MIPS32,mips32,r20);
   GENOFFSET(MIPS32,mips32,r21);
   GENOFFSET(MIPS32,mips32,r22);
   GENOFFSET(MIPS32,mips32,r23);
   GENOFFSET(MIPS32,mips32,r24);
   GENOFFSET(MIPS32,mips32,r25);
   GENOFFSET(MIPS32,mips32,r26);
   GENOFFSET(MIPS32,mips32,r27);
   GENOFFSET(MIPS32,mips32,r28);
   GENOFFSET(MIPS32,mips32,r29);
   GENOFFSET(MIPS32,mips32,r30);
   GENOFFSET(MIPS32,mips32,r31);
   GENOFFSET(MIPS32,mips32,PC);
   GENOFFSET(MIPS32,mips32,HI);
   GENOFFSET(MIPS32,mips32,LO);
   GENOFFSET(MIPS32,mips32,f0);
   GENOFFSET(MIPS32,mips32,f1);
   GENOFFSET(MIPS32,mips32,f2);
   GENOFFSET(MIPS32,mips32,f3);
   GENOFFSET(MIPS32,mips32,f4);
   GENOFFSET(MIPS32,mips32,f5);
   GENOFFSET(MIPS32,mips32,f6);
   GENOFFSET(MIPS32,mips32,f7);
   GENOFFSET(MIPS32,mips32,f8);
   GENOFFSET(MIPS32,mips32,f9);
   GENOFFSET(MIPS32,mips32,f10);
   GENOFFSET(MIPS32,mips32,f11);
   GENOFFSET(MIPS32,mips32,f12);
   GENOFFSET(MIPS32,mips32,f13);
   GENOFFSET(MIPS32,mips32,f14);
   GENOFFSET(MIPS32,mips32,f15);
   GENOFFSET(MIPS32,mips32,f16);
   GENOFFSET(MIPS32,mips32,f17);
   GENOFFSET(MIPS32,mips32,f18);
   GENOFFSET(MIPS32,mips32,f19);
   GENOFFSET(MIPS32,mips32,f20);
   GENOFFSET(MIPS32,mips32,f21);
   GENOFFSET(MIPS32,mips32,f22);
   GENOFFSET(MIPS32,mips32,f23);
   GENOFFSET(MIPS32,mips32,f24);
   GENOFFSET(MIPS32,mips32,f25);
   GENOFFSET(MIPS32,mips32,f26);
   GENOFFSET(MIPS32,mips32,f27);
   GENOFFSET(MIPS32,mips32,f28);
   GENOFFSET(MIPS32,mips32,f29);
   GENOFFSET(MIPS32,mips32,f30);
   GENOFFSET(MIPS32,mips32,f31);
   GENOFFSET(MIPS32,mips32,FIR);
   GENOFFSET(MIPS32,mips32,FCCR);
   GENOFFSET(MIPS32,mips32,FEXR);
   GENOFFSET(MIPS32,mips32,FENR);
   GENOFFSET(MIPS32,mips32,FCSR);
   GENOFFSET(MIPS32,mips32,ULR);
   GENOFFSET(MIPS32,mips32,EMNOTE);
   GENOFFSET(MIPS32,mips32,CMSTART);
   GENOFFSET(MIPS32,mips32,CMLEN);
   GENOFFSET(MIPS32,mips32,NRADDR);
   GENOFFSET(MIPS32,mips32,COND);
   GENOFFSET(MIPS32,mips32,DSPControl);
   GENOFFSET(MIPS32,mips32,ac0);
   GENOFFSET(MIPS32,mips32,ac1);
   GENOFFSET(MIPS32,mips32,ac2);
   GENOFFSET(MIPS32,mips32,ac3);
   GENOFFSET(MIPS32,mips32,CP0_status);
   GENOFFSET(MIPS32,mips32,IP_AT_SYSCALL);

   // MIPS64
   GENOFFSET(MIPS64,mips64,r0);
   GENOFFSET(MIPS64,mips64,r1);
   GENOFFSET(MIPS64,mips64,r2);
   GENOFFSET(MIPS64,mips64,r3);
   GENOFFSET(MIPS64,mips64,r4);
   GENOFFSET(MIPS64,mips64,r5);
   GENOFFSET(MIPS64,mips64,r6);
   GENOFFSET(MIPS64,mips64,r7);
   GENOFFSET(MIPS64,mips64,r8);
   GENOFFSET(MIPS64,mips64,r9);
   GENOFFSET(MIPS64,mips64,r10);
   GENOFFSET(MIPS64,mips64,r11);
   GENOFFSET(MIPS64,mips64,r12);
   GENOFFSET(MIPS64,mips64,r13);
   GENOFFSET(MIPS64,mips64,r14);
   GENOFFSET(MIPS64,mips64,r15);
   GENOFFSET(MIPS64,mips64,r16);
   GENOFFSET(MIPS64,mips64,r17);
   GENOFFSET(MIPS64,mips64,r18);
   GENOFFSET(MIPS64,mips64,r19);
   GENOFFSET(MIPS64,mips64,r20);
   GENOFFSET(MIPS64,mips64,r21);
   GENOFFSET(MIPS64,mips64,r22);
   GENOFFSET(MIPS64,mips64,r23);
   GENOFFSET(MIPS64,mips64,r24);
   GENOFFSET(MIPS64,mips64,r25);
   GENOFFSET(MIPS64,mips64,r26);
   GENOFFSET(MIPS64,mips64,r27);
   GENOFFSET(MIPS64,mips64,r28);
   GENOFFSET(MIPS64,mips64,r29);
   GENOFFSET(MIPS64,mips64,r30);
   GENOFFSET(MIPS64,mips64,r31);
   GENOFFSET(MIPS64,mips64,PC);
   GENOFFSET(MIPS64,mips64,HI);
   GENOFFSET(MIPS64,mips64,LO);
   GENOFFSET(MIPS64,mips64,f0);
   GENOFFSET(MIPS64,mips64,f1);
   GENOFFSET(MIPS64,mips64,f2);
   GENOFFSET(MIPS64,mips64,f3);
   GENOFFSET(MIPS64,mips64,f4);
   GENOFFSET(MIPS64,mips64,f5);
   GENOFFSET(MIPS64,mips64,f6);
   GENOFFSET(MIPS64,mips64,f7);
   GENOFFSET(MIPS64,mips64,f8);
   GENOFFSET(MIPS64,mips64,f9);
   GENOFFSET(MIPS64,mips64,f10);
   GENOFFSET(MIPS64,mips64,f11);
   GENOFFSET(MIPS64,mips64,f12);
   GENOFFSET(MIPS64,mips64,f13);
   GENOFFSET(MIPS64,mips64,f14);
   GENOFFSET(MIPS64,mips64,f15);
   GENOFFSET(MIPS64,mips64,f16);
   GENOFFSET(MIPS64,mips64,f17);
   GENOFFSET(MIPS64,mips64,f18);
   GENOFFSET(MIPS64,mips64,f19);
   GENOFFSET(MIPS64,mips64,f20);
   GENOFFSET(MIPS64,mips64,f21);
   GENOFFSET(MIPS64,mips64,f22);
   GENOFFSET(MIPS64,mips64,f23);
   GENOFFSET(MIPS64,mips64,f24);
   GENOFFSET(MIPS64,mips64,f25);
   GENOFFSET(MIPS64,mips64,f26);
   GENOFFSET(MIPS64,mips64,f27);
   GENOFFSET(MIPS64,mips64,f28);
   GENOFFSET(MIPS64,mips64,f29);
   GENOFFSET(MIPS64,mips64,f30);
   GENOFFSET(MIPS64,mips64,f31);
   GENOFFSET(MIPS64,mips64,FIR);
   GENOFFSET(MIPS64,mips64,FCCR);
   GENOFFSET(MIPS64,mips64,FEXR);
   GENOFFSET(MIPS64,mips64,FENR);
   GENOFFSET(MIPS64,mips64,FCSR);
   GENOFFSET(MIPS64,mips64,CP0_status);
   GENOFFSET(MIPS64,mips64,ULR);
   GENOFFSET(MIPS64,mips64,EMNOTE);
   GENOFFSET(MIPS64,mips64,COND);
   GENOFFSET(MIPS64,mips64,CMSTART);
   GENOFFSET(MIPS64,mips64,CMLEN);
   GENOFFSET(MIPS64,mips64,NRADDR);
   GENOFFSET(MIPS64,mips64,IP_AT_SYSCALL);

   // Tilegx
   GENOFFSET(TILEGX,tilegx,r0);
   GENOFFSET(TILEGX,tilegx,r1);
   GENOFFSET(TILEGX,tilegx,r2);
   GENOFFSET(TILEGX,tilegx,r3);
   GENOFFSET(TILEGX,tilegx,r4);
   GENOFFSET(TILEGX,tilegx,r5);
   GENOFFSET(TILEGX,tilegx,r6);
   GENOFFSET(TILEGX,tilegx,r7);
   GENOFFSET(TILEGX,tilegx,r8);
   GENOFFSET(TILEGX,tilegx,r9);
   GENOFFSET(TILEGX,tilegx,r10);
   GENOFFSET(TILEGX,tilegx,r11);
   GENOFFSET(TILEGX,tilegx,r12);
   GENOFFSET(TILEGX,tilegx,r13);
   GENOFFSET(TILEGX,tilegx,r14);
   GENOFFSET(TILEGX,tilegx,r15);
   GENOFFSET(TILEGX,tilegx,r16);
   GENOFFSET(TILEGX,tilegx,r17);
   GENOFFSET(TILEGX,tilegx,r18);
   GENOFFSET(TILEGX,tilegx,r19);
   GENOFFSET(TILEGX,tilegx,r20);
   GENOFFSET(TILEGX,tilegx,r21);
   GENOFFSET(TILEGX,tilegx,r22);
   GENOFFSET(TILEGX,tilegx,r23);
   GENOFFSET(TILEGX,tilegx,r24);
   GENOFFSET(TILEGX,tilegx,r25);
   GENOFFSET(TILEGX,tilegx,r26);
   GENOFFSET(TILEGX,tilegx,r27);
   GENOFFSET(TILEGX,tilegx,r28);
   GENOFFSET(TILEGX,tilegx,r29);
   GENOFFSET(TILEGX,tilegx,r30);
   GENOFFSET(TILEGX,tilegx,r31);
   GENOFFSET(TILEGX,tilegx,r32);
   GENOFFSET(TILEGX,tilegx,r33);
   GENOFFSET(TILEGX,tilegx,r34);
   GENOFFSET(TILEGX,tilegx,r35);
   GENOFFSET(TILEGX,tilegx,r36);
   GENOFFSET(TILEGX,tilegx,r37);
   GENOFFSET(TILEGX,tilegx,r38);
   GENOFFSET(TILEGX,tilegx,r39);
   GENOFFSET(TILEGX,tilegx,r40);
   GENOFFSET(TILEGX,tilegx,r41);
   GENOFFSET(TILEGX,tilegx,r42);
   GENOFFSET(TILEGX,tilegx,r43);
   GENOFFSET(TILEGX,tilegx,r44);
   GENOFFSET(TILEGX,tilegx,r45);
   GENOFFSET(TILEGX,tilegx,r46);
   GENOFFSET(TILEGX,tilegx,r47);
   GENOFFSET(TILEGX,tilegx,r48);
   GENOFFSET(TILEGX,tilegx,r49);
   GENOFFSET(TILEGX,tilegx,r50);
   GENOFFSET(TILEGX,tilegx,r51);
   GENOFFSET(TILEGX,tilegx,r52);
   GENOFFSET(TILEGX,tilegx,r53);
   GENOFFSET(TILEGX,tilegx,r54);
   GENOFFSET(TILEGX,tilegx,r55);
   GENOFFSET(TILEGX,tilegx,r56);
   GENOFFSET(TILEGX,tilegx,r57);
   GENOFFSET(TILEGX,tilegx,r58);
   GENOFFSET(TILEGX,tilegx,r59);
   GENOFFSET(TILEGX,tilegx,r60);
   GENOFFSET(TILEGX,tilegx,r61);
   GENOFFSET(TILEGX,tilegx,r62);
   GENOFFSET(TILEGX,tilegx,r63);
   GENOFFSET(TILEGX,tilegx,pc);
   GENOFFSET(TILEGX,tilegx,spare);
   GENOFFSET(TILEGX,tilegx,EMNOTE);
   GENOFFSET(TILEGX,tilegx,CMSTART);
   GENOFFSET(TILEGX,tilegx,CMLEN);
   GENOFFSET(TILEGX,tilegx,NRADDR);
   GENOFFSET(TILEGX,tilegx,cmpexch);
   GENOFFSET(TILEGX,tilegx,zero);
   GENOFFSET(TILEGX,tilegx,ex_context_0);
   GENOFFSET(TILEGX,tilegx,ex_context_1);
   GENOFFSET(TILEGX,tilegx,COND);

   // riscv64
   GENOFFSET(RISCV64,riscv64,x0);
   GENOFFSET(RISCV64,riscv64,x1);
   GENOFFSET(RISCV64,riscv64,x2);
   GENOFFSET(RISCV64,riscv64,x3);
   GENOFFSET(RISCV64,riscv64,x4);
   GENOFFSET(RISCV64,riscv64,x5);
   GENOFFSET(RISCV64,riscv64,x6);
   GENOFFSET(RISCV64,riscv64,x7);
   GENOFFSET(RISCV64,riscv64,x9);
   GENOFFSET(RISCV64,riscv64,x9);
   GENOFFSET(RISCV64,riscv64,x10);
   GENOFFSET(RISCV64,riscv64,x11);
   GENOFFSET(RISCV64,riscv64,x12);
   GENOFFSET(RISCV64,riscv64,x13);
   GENOFFSET(RISCV64,riscv64,x14);
   GENOFFSET(RISCV64,riscv64,x15);
   GENOFFSET(RISCV64,riscv64,x16);
   GENOFFSET(RISCV64,riscv64,x17);
   GENOFFSET(RISCV64,riscv64,x18);
   GENOFFSET(RISCV64,riscv64,x19);
   GENOFFSET(RISCV64,riscv64,x20);
   GENOFFSET(RISCV64,riscv64,x21);
   GENOFFSET(RISCV64,riscv64,x22);
   GENOFFSET(RISCV64,riscv64,x23);
   GENOFFSET(RISCV64,riscv64,x24);
   GENOFFSET(RISCV64,riscv64,x25);
   GENOFFSET(RISCV64,riscv64,x26);
   GENOFFSET(RISCV64,riscv64,x27);
   GENOFFSET(RISCV64,riscv64,x28);
   GENOFFSET(RISCV64,riscv64,x29);
   GENOFFSET(RISCV64,riscv64,x30);
   GENOFFSET(RISCV64,riscv64,x31);
   GENOFFSET(RISCV64,riscv64,pc);
   GENOFFSET(RISCV64,riscv64,f0);
   GENOFFSET(RISCV64,riscv64,f1);
   GENOFFSET(RISCV64,riscv64,f2);
   GENOFFSET(RISCV64,riscv64,f3);
   GENOFFSET(RISCV64,riscv64,f4);
   GENOFFSET(RISCV64,riscv64,f5);
   GENOFFSET(RISCV64,riscv64,f6);
   GENOFFSET(RISCV64,riscv64,f7);
   GENOFFSET(RISCV64,riscv64,f9);
   GENOFFSET(RISCV64,riscv64,f9);
   GENOFFSET(RISCV64,riscv64,f10);
   GENOFFSET(RISCV64,riscv64,f11);
   GENOFFSET(RISCV64,riscv64,f12);
   GENOFFSET(RISCV64,riscv64,f13);
   GENOFFSET(RISCV64,riscv64,f14);
   GENOFFSET(RISCV64,riscv64,f15);
   GENOFFSET(RISCV64,riscv64,f16);
   GENOFFSET(RISCV64,riscv64,f17);
   GENOFFSET(RISCV64,riscv64,f18);
   GENOFFSET(RISCV64,riscv64,f19);
   GENOFFSET(RISCV64,riscv64,f20);
   GENOFFSET(RISCV64,riscv64,f21);
   GENOFFSET(RISCV64,riscv64,f22);
   GENOFFSET(RISCV64,riscv64,f23);
   GENOFFSET(RISCV64,riscv64,f24);
   GENOFFSET(RISCV64,riscv64,f25);
   GENOFFSET(RISCV64,riscv64,f26);
   GENOFFSET(RISCV64,riscv64,f27);
   GENOFFSET(RISCV64,riscv64,f28);
   GENOFFSET(RISCV64,riscv64,f29);
   GENOFFSET(RISCV64,riscv64,f30);
   GENOFFSET(RISCV64,riscv64,f31);
}

/*--------------------------------------------------------------------*/
/*--- end                                             genoffsets.c ---*/
/*--------------------------------------------------------------------*/
