# MD022 - Add blank lines around headings

Aliases: `blanks-around-headings`

## What this rule does

Checks that headings have blank lines before and after them to improve readability and document structure.

## Why this matters

- **Better readability**: Blank lines create visual separation, making content easier to scan
- **Clear structure**: Spacing helps readers understand the document hierarchy
- **Consistent rendering**: Many Markdown processors require blank lines for proper formatting
- **Professional appearance**: Well-spaced documents look more polished and organized

## Examples

<!-- rumdl-disable MD022 -->

### ✅ Correct

```markdown
Some introductory text here.

# Main Heading

This is the content under the main heading.

## Subheading

More content follows here.

### Another Section

And even more content.
```

### ❌ Incorrect

```markdown
Some introductory text here.
# Main Heading
This is the content under the main heading.
## Subheading
More content follows here.
### Another Section
And even more content.
```

### 🔧 Fixed

```markdown
Some introductory text here.

# Main Heading

This is the content under the main heading.

## Subheading

More content follows here.

### Another Section

And even more content.
```

<!-- rumdl-enable MD022 -->

## Configuration

### Basic configuration

```toml
[MD022]
lines-above = 1  # Blank lines required above headings (default: 1)
lines-below = 1  # Blank lines required below headings (default: 1)
allowed-at-start = true  # Allow headings at document start without blank line above (default: true)
```

### Per-level configuration

You can specify different spacing requirements for each heading level (h1-h6) using arrays:

```toml
[MD022]
# Different spacing for each level: [h1, h2, h3, h4, h5, h6]
lines-above = [2, 1, 1, 1, 1, 1]  # h1 needs 2 blank lines above, others need 1
lines-below = [1, 1, 1, 0, 0, 0]  # h4-h6 don't need blank lines below
```

Use `-1` to inherit the default value for a specific level:

```toml
[MD022]
lines-above = [-1, 2, 1, 1, 1, 1]  # h1 uses default (1), h2 needs 2 blank lines
lines-below = [1, -1, -1, -1, -1, -1]  # h1 needs 1, others use default
```

This is useful when you want:

- More space before top-level headings for visual separation
- Less space around deeply nested headings
- Different spacing conventions for different document sections

## Automatic fixes

This rule automatically adds the required number of blank lines:

- Before headings (except at the start of a document)
- After headings (except at the end of a document)

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Markdown best practices](https://www.markdownguide.org/basic-syntax/#headings)

## Related rules

- [MD001](md001.md): Use consistent heading levels
- [MD003](md003.md): Use consistent heading style
- [MD023](md023.md): Start headings at the beginning of lines
- [MD041](md041.md): First line should be a top-level heading
