# MD050 - Keep bold text formatting consistent

Aliases: `strong-style`

## What this rule does

Ensures all bold text uses the same style throughout your document - either double asterisks (**) or double underscores (__).

## Why this matters

- **Professional appearance**: Mixed bold styles make documents look unpolished and carelessly edited
- **Reading flow**: Consistent formatting reduces visual distractions for readers
- **Team collaboration**: Standard formatting makes it easier for teams to work together
- **Parser compatibility**: Some Markdown parsers may handle different styles differently

## Examples

<!-- rumdl-disable MD050 -->

### ✅ Correct (consistent asterisks)

```markdown
This text has **bold** formatting.

Another paragraph with **important** text.

Even more **emphasized** content here.
```

### ✅ Correct (consistent underscores)

```markdown
This text has __bold__ formatting.

Another paragraph with __important__ text.

Even more __emphasized__ content here.
```

### ❌ Incorrect (mixed styles)

```markdown
This text has **bold** formatting.

Another paragraph with __important__ text.

Even more **emphasized** content here.
```

### 🔧 Fixed

```markdown
This text has **bold** formatting.

Another paragraph with **important** text.

Even more **emphasized** content here.
```

<!-- rumdl-enable MD050 -->

## Configuration

```toml
[MD050]
style = "consistent"  # Options: "consistent", "asterisk", "underscore"
```

### Style options

- **`consistent`** (default): Use whatever style is most prevalent in your document (in case of a tie, prefers asterisks)
- **`asterisk`**: Always use `**text**` for bold
- **`underscore`**: Always use `__text__` for bold

## Automatic fixes

This rule can automatically fix issues by:

- Converting all bold markers to match your configured style
- When using "consistent", converting all markers to match the most prevalent style

## Differences from markdownlint

**Warning count**: markdownlint reports two warnings per emphasis (one for the opening marker `**`/`__` and one for the closing marker). rumdl reports one warning per emphasis block because:

1. The opening and closing markers are semantically one unit - you cannot fix one without fixing the other
2. Cleaner output - "10 issues" vs "20 issues" for 10 bold words
3. The fix is atomic - the entire emphasis is replaced at once

## Learn more

- [CommonMark strong emphasis specification](https://spec.commonmark.org/0.31.2/#emphasis-and-strong-emphasis)
- [Markdown Guide: Bold](https://www.markdownguide.org/basic-syntax/#bold)

## Related rules

- [MD049 - Keep italic text formatting consistent](md049.md)
- [MD036 - Use proper headings instead of emphasized text](md036.md)
- [MD037 - Remove spaces inside emphasis markers](md037.md)
