# MD057 - Check that file links work

Aliases: `existing-relative-links`

## What this rule does

Verifies that relative links to other files in your documentation actually point to files that exist.
This includes both inline links and reference-style link definitions.

## Why this matters

- **Prevents frustration**: Broken links waste readers' time and damage trust
- **Maintains quality**: Working links show your documentation is well-maintained
- **Aids navigation**: Readers can confidently explore your documentation
- **Catches typos**: Common mistakes in file paths are caught early

## Examples

<!-- rumdl-disable MD057 MD031 MD040 -->

### ✅ Correct

```markdown
[Installation Guide](install.md)          <!-- File exists -->
[Contributing](../CONTRIBUTING.md)        <!-- File exists -->
[GitHub Repo](https://github.com/org/repo) <!-- External URL -->
[Email Us](mailto:help@example.com)       <!-- Email link -->
[Jump to Section](#configuration)         <!-- Same-file anchor -->

<!-- Reference-style links -->
[readme]: ./README.md                     <!-- File exists -->
[external]: https://example.com           <!-- External URL -->
```

### ❌ Incorrect

```markdown
[Missing Doc](does-not-exist.md)           <!-- File doesn't exist -->
[Bad Path](../missing/guide.md)            <!-- Path doesn't exist -->
[Typo in Name](READNE.md)                 <!-- Should be README.md -->
[Wrong Extension](setup.markdown)          <!-- File is setup.md -->

<!-- Reference-style links with missing targets -->
[missing]: ./does-not-exist.md            <!-- File doesn't exist -->
[bad-path]: ../missing/doc.md             <!-- Path doesn't exist -->
```

### 🔧 Fixed

This rule cannot automatically fix broken links because it can't know which file you intended to link to. You must manually:

1. Correct the file path
2. Create the missing file
3. Or remove the broken link

<!-- rumdl-enable MD057 MD031 MD040 -->

## Configuration

This rule has no configuration options.

### Build-Generated Files

Documentation sites often compile markdown files to HTML during build. MD057 automatically
checks if a corresponding markdown source file exists when a link points to a `.html` or
`.htm` file.

For example, `[Guide](guide.html)` will pass if `guide.md` exists, even though `guide.html`
doesn't exist in your source tree.

### Handling Complex Generator Patterns

For documentation generators that place source files in different locations (e.g., mdBook's
`src/` directory), MD057 checks for markdown sources in the same directory as the HTML file.
If your generator uses a different structure, you can disable MD057 for affected directories
using `per-file-ignores`:

```toml
[per-file-ignores]

## mdBook projects - HTML links in book/ point to book/src/*.md sources

"book/**/*.md" = ["MD057"]

## Jekyll projects - HTML links in _posts/ point to generated files

"_posts/**/*.md" = ["MD057"]
"_docs/**/*.md" = ["MD057"]

## Hugo projects - HTML links in content/ point to generated files

"content/**/*.md" = ["MD057"]
```

MD057 will still check for markdown sources in the same directory automatically.
Use `per-file-ignores` only when sources are in different locations.

## Automatic fixes

This rule does not provide automatic fixes. Broken links must be corrected manually by:

- Fixing typos in file names
- Updating paths after moving files
- Creating missing documentation files
- Removing links to deleted files

## Learn more

- [Markdown Guide: Links](https://www.markdownguide.org/basic-syntax/#links)
- [Writing good documentation](https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/)

## Related rules

- [MD051 - Fix broken link fragments](md051.md)
- [MD042 - Ensure links have content](md042.md)
- [MD034 - Format bare URLs properly](md034.md)
