# MD038 - Remove extra spaces in code

Aliases: `no-space-in-code`

## What this rule does

Removes unnecessary spaces between backticks and code content in inline code spans.

## Why this matters

- **Clean formatting**: Extra spaces make code snippets look unpolished
- **Accurate code**: Leading/trailing spaces might be mistaken as part of the code
- **Consistent appearance**: Code should be formatted the same way throughout
- **Better readability**: Clear boundaries between code and regular text

## Examples

<!-- rumdl-disable MD038 -->

### ✅ Correct

Code directly touches the backticks:

```markdown
Use the `print()` function to display output.

Call `getUserName()` to get the current user.

The variable `isEnabled` stores the state.
```

### ❌ Incorrect

Extra spaces inside backticks:

```markdown
Use the ` print()` function to display output.

Call `getUserName() ` to get the current user.

The variable ` isEnabled ` stores the state.
```

### 🔧 Fixed

Spaces removed from edges:

```markdown
Use the `print()` function to display output.

Call `getUserName()` to get the current user.

The variable `isEnabled` stores the state.
```

<!-- rumdl-enable MD038 -->

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule will:

- Remove spaces after opening backticks
- Remove spaces before closing backticks
- Preserve spaces within the code itself
- Handle multiple code spans on the same line

## Learn more

- [CommonMark specification for code spans](https://spec.commonmark.org/0.31.2/#code-spans)

## Related rules

- [MD037 - Spaces inside emphasis markers](md037.md) - Similar rule for bold and italic text
