sayaka ちゃん & sixelv version 3.8.5 (2025/12/30)
=====

sayaka ちゃんはターミナルに特化した Misskey ストリームクライアントです。

* ホームタイムライン、ローカルタイムラインの垂れ流しができます。
* mlterm などの SIXEL 対応ターミナルなら画像も表示できます。
* X68030/25MHz、メモリ12MB でも快適(?)動作。

また、SIXEL 対応ターミナル用の画像ビューワ
sixelv も同梱しています。→ [SIXELV.md](SIXELV.md)

変更点
---
* 3.8.5 (2025/12/30) …
	JPEG-XL (libjxl) に対応。
	適応パレットによる縮小が破綻するケースを修正。
	`--no-progressive` オプションを実装。
	Misskey の MFM `$[ruby]` に暫定対応。
	8色以下での時刻の表示色を調整。
	`--force-blurhash` オプションを実装。
	キャッシュファイル名を調整 (ユーザには影響ありません)。
	WebSocket のエラー処理を修正。
	Mac OS でのビルドに対応。

* 3.8.4 (2025/08/10) …
	HTTP リダイレクトに失敗する場合があったのを修正。
	HTTPS 画像のダウンロードに失敗する場合があったのを修正。

* 3.8.3 (2025/06/29) …
	256 色を固定パレットから適応パレットに変更
	(3.8.2 以前で使用した `~/.sayaka/cache/` は削除してください)。
	アイコンのキャッシュ期間を7日に短縮。
	実績達成(EarnedAchivement)通知に対応。

* 3.8.2 (2025/05/17) …
	libjpeg, libpng, giflib に対応。
	JPEG の YCCK、モノクロなどいくつかの形式に対応 (libjpeg 使用時)。
	SIXEL 出力の背景色を非透過に変更。
	webp 画像がロードできない場合があったのを修正。
	3.8.0 以降一部のキャッシュファイルが削除できていなかったのを修正
	(すでに残っている分は削除されないので `~/.sayaka/cache/` 以下をすべて消すとかしてください)。


必要なもの
---
* C99 compiler
* BSD make (not GNU make)
* pkg-config
	… pkgsrc なら `devel/pkgconf`、Ubuntu なら `pkg-config` です。
* giflib
	… pkgsrc および OpenBSD ports なら `graphics/giflib` です。
	Ubuntu なら `libgif-dev` です。
	なくてもビルド可能です。
* libjpeg
	… pkgsrc および OpenBSD ports なら `graphics/libjpeg`、
	Ubuntu なら `libjpeg8-dev` です。
	なくてもビルド可能です。
* libjxl
	… pkgsrc および OpenBSD ports なら `graphics/libjxl`、
	Ubuntu なら `libjxl-dev` です。
	なくてもビルド可能です。
* libpng
	… pkgsrc および OpenBSD ports なら `graphics/png`、
	Ubuntu なら `libpng-dev` です。
	なくてもビルド可能です。
* libtiff
	… pkgsrc および OpenBSD ports なら `graphics/tiff` です。
	sixelv でのみ使用し、なくてもビルド可能です。
* libwebp
	… pkgsrc および OpenBSD ports なら `graphics/libwebp`、
	Ubuntu なら `libwebp-dev` です。
	なくてもビルド可能です (ただし Misskey は基本 WebP を使います)。
* iconv
	… NetBSD なら OS 標準です。
	OpenBSD ports なら `converters/libiconv` です。
	sayaka でのみ必要です。
* OpenSSL
	… *BSD なら OS 標準です。
	Ubuntu なら `libssl-dev` です。


インストール方法
---
ビルドは以下のようにします。

```
% ./configure [<options>]
% make -DRELEASE sayaka
```

configure のオプションは次のものがあります。
* `--with-giflib=(auto|yes|no)` …
	`auto` なら giflib が見付かれば使用し、見付からなければ内蔵の
	stb_image でデコードします。`no` なら stb_image を使用します。
	デフォルトは `auto` です。
* `--with-libjpeg=(auto|yes|no)` …
	`auto` なら libjpeg が見付かれば使用し、見付からなければ内蔵の
	stb_image でデコードします。`no` なら stb_image を使用します。
	デフォルトは `auto` です。
	stb_image を使う場合デコードできない形式があります。
* `--with-libjxl=(auto|yes|no)` …
	`auto` なら libjxl が見付かれば使用し、見付からなければ使用しません。
	`no` なら JPEG-XL をデコードしません。
	デフォルトは `auto` です。
* `--with-libpng=(auto|yes|no)` …
	`auto` なら libpng が見付かれば使用し、見付からなければ内蔵の
	stb_image でデコードします。`no` なら stb_image を使用します。
	デフォルトは `auto` です。
* `--with-libtiff=(auto|yes|no)` …
	`auto` なら libtiff が見付かれば使用し、見付からなければ使用しません。
	デフォルトは `auto` です。
	TIFF サポートは sixelv のみで、
	sayaka はこのオプションによらず常に使用しません。
* `--with-libwebp=(auto|yes|no)` …
	`auto` なら libwebp が見付かれば使用し、見付からなければ使用しません。
	`no` なら WebP をデコードしません (ただし Misskey は基本 WebP を使います)。
	デフォルトは `yes` です。
* `--with-iconv=(yes|no)` …
	`sixelv` のみビルドするなら `no` にすることは可能です。
* `--with-openssl=(yes|no)` …
	`sixelv` をローカルのファイルでだけ使うなら `no` にすることは可能です。

`make install` はないので、出来上がった `src/sayaka` (実行ファイル) をパスの通ったところにインストールするとかしてください。
ちなみに `make -DRELEASE all` すると、画像ファイルを SIXEL に変換して表示する
`sixelv` というビューアも `src/` の下に出来ます (sayaka の実行には不要です)。


使い方
---
sayaka (ver 3.7 以降) は Misskey にのみ対応しています。

ホームタイムラインと、サーバのローカルタイムラインをサポートしていますが、
指定方法を決めかねているので **現在は仮オプションです。
使い方は将来互換性なく変更になると思います。**

ローカルタイムラインの表示にはサーバを指定します。
これはアカウントを持ってなくても閲覧することが出来ます
(アカウントを持たずにサーバのトップページに行くと見えるあれです)。

```
% sayaka --local --server <servername>
```

ホームタイムラインの表示には Misskey のアクセストークンが必要です。
Misskey の「設定 &gt; API &gt; アクセストークンの発行」から
権限は「アカウントの情報を見る」を有効にして
(今のところこれだけで大丈夫のようですが詳細不明)
発行したトークン文字列をファイルに保存します。
で、以下のようにサーバとトークンを指定します。

```
% sayaka --home --server <servername> --token <tokenfile>
```

なお初回起動時に `~/.sayaka/cache` のディレクトリを作成します。


実装状況
---
* MFM (Markup language For Misskey) の多くは対応予定はありません。
	* メンションは概ね対応しています。
	* ハッシュタグは概ね対応していますが、まだ一部認識出来ないものがあります。
	  (Misskey のハッシュタグが Unicode 正規化を利用しているためです)
	* URL は概ね対応しています。`[link](URL)` 形式は URL 部のみ反応します。
	* `<plain>〜</plain>` タグは対応しています。
	* `:emoji:` は未対応です。
	* 太字、イタリック、引用(`>`)、コードブロック、`<center>`、`<small>`
	には反応しません。そのまま表示します。
	* `$[ruby]` タグに暫定対応しています。
本文中にある、単純なケースのみ対応しています。
	* その他の関数(`$[..]` など) はタグを取り除いて内容のみ表示します。
* アイコンのデコレーションは現状対応予定はありません。
* リアクションは合計数のみ表示しています。
* 同じ投稿が連続した場合の圧縮表示は未対応です。
* 投稿は出来ません。


主なコマンドライン引数
---
* `-c,--color=<mode>` … 色モードを指定します。デフォルトは `256` です。
	* `256` … 適応256色モードです。フルカラー端末向けです。
	* `16` … ANSI 互換の 16色モードです。
	* `8` … RGB 8色モードです。
	* `2` … 画像はモノクロで、テキストはユーザ名のみボールドで表示します。
	* `1` … 画像はモノクロで、テキストは一切エスケープシーケンスによる
		飾り付けを行いません。
	* `gray<N>` … グレー `<N>` 階調です。
		`<N>` は `2` から `256` まで指定できます。
		(ただし SIXEL の色表現は 100階調までしか分解能がありません)
	* `gray` … `gray256` です。

* `--dark` … ダークテーマ (背景色が暗い環境) 用に、
	可能なら明るめの文字色セットを使用します。
	デフォルトでは背景色を自動判別しようとしますが、
	ターミナルが対応していなかったりすると `--light` が選択されます。

* `--force-blurhash` … 画像に Blurhash がある場合は、
	画像をダウンロードせず Blurhash を表示します。

* `-h,--home` … ホームタイムラインモードです。
	`--server` でサーバを、
	`--token` でアクセストークンファイルを指定する必要があります。

* `--light` … ライトテーマ (背景色が明るい環境) 用に、
	可能なら濃いめの文字色セットを使用します。
	デフォルトでは背景色を自動判別しようとしますが、
	ターミナルが対応していなかったりすると自動で選択されます。

* `-l,--local` … ローカルタイムラインモードです。
	`--server` でサーバの指定が必要です。
	アカウントを持ってなくても表示できます。

* `--misskey` … Misskey モードにします。
	現状デフォルトで他の選択肢はないので、指定する必要はありません。

* `--nsfw=<mode>` … Misskey の NSFW (Not Safe For Work、閲覧注意)
	画像の表示方法を指定します。デフォルトは `blur` です。
	* `show` なら元画像を表示します。
	* `blur` ならぼかし表示します。
	* `alt` なら画像は表示せずファイルタイプのみ表示します。
	* `hide` なら NSFW を含むノートそのものを表示しません。

* `-p,--play=<filename>` …
	ストリームの代わりに指定のファイルの内容を再生します。
	`<filename>` が `-` なら標準入力とします。

* `-r,--record=<filename>` …
	ストリームで受信した JSON を `<filename>` に追記します。
	ここで保存したファイルは `--play` コマンドで再生できます。

* `-s,--server=<host>` … Misskey サーバを指定します。

* `--show-cw` … Misskey の CW (Contents Warning、内容を隠す) 付き投稿の
	CW 以降も表示します。

* `--show-image=<mode>` … 画像の表示を制御します。
	デフォルトは `auto` です。
	* `auto` … 自動判別です。
		ターミナルが SIXEL 対応なら画像を出力し、
		非対応なら画像を出力しません。
	* `no` … SIXEL 画像を一切出力しません。
	* `yes` … ターミナルが SIXEL 対応かどうかに関わらず、
		SIXEL 画像を出力します。
		ターミナルが SIXEL を扱えるにも関わらずそれが判別できなかった場合などに
		使えるかも知れません。

* `-t,--token=<file>` … Misskey のアクセストークンが書かれたファイルを
	指定します。


その他のコマンドライン引数
---
* `--ciphers=<ciphers>` … 通信に使用する暗号化スイートを指定します。
	今のところ指定できるのは "RSA" (大文字) のみです。
	2桁MHz級の遅マシンでコネクションがタイムアウトするようなら
	指定してみてください。
	ただしサーバがこのような古い方式を許可していないことは十分考えられます。
	このオプションはメインストリームと画像のダウンロード両方に適用されます。

* `--eaw-a=<n>` … Unicode の East Asian Width が Ambiguous な文字の
	文字幅を 1 か 2 で指定します。デフォルトは 1 です。
	というか通常 1 のはずです。
	ターミナルとフォントも幅が揃ってないとたぶん悲しい目にあいます。

* `--eaw-n=<n>` … Unicode の East Asian Width が Neutral な文字の
	文字幅を 1 か 2 で指定します。デフォルトは 2 です。
	ターミナルとフォントも幅が揃ってないとたぶん悲しい目にあいます。

* `--euc-jp` … 文字コードを EUC-JP に変換して出力します。
	VT382J 等の EUC-JP (DEC漢字) に対応したターミナルで使えます。
	`configure` 時に `--without-iconv` を指定した場合はこの機能は使えません。

* `--font=<W>x<H>` … フォントの幅と高さを `--font 7x14` のように指定します。
	デフォルトではターミナルに問い合わせて取得しますが、
	ターミナルが対応してない場合などは勝手に `7x14` としますので、
	もし違う場合はこの `--font` オプションを使って指定してください。
	アイコンと画像はここで指定したフォントサイズに連動した大きさで表示されます。

* `--ipv4`/`--ipv6` … IPv4/IPv6 のみを使用します。
	このオプションはメインストリームと画像のダウンロード両方に適用されます。

* `--jis` … 文字コードを JIS に変換して出力します。
	NetBSD/x68k コンソール等の JIS に対応したターミナルで使えます。
	`configure` 時に `--without-iconv` を指定した場合はこの機能は使えません。

* `--mathalpha` … Unicode の [Mathematical Alphanumeric Symbols](https://en.wikipedia.org/wiki/Mathematical_Alphanumeric_Symbols)
	を全角英数字に変換します。
	お使いのフォントが Mathematical Alphanumeric Symbols に対応しておらず
	全角英数字なら表示できる人を救済するためです。

* `--max-image-cols=<n>` … 1行に表示する画像の最大数です。
	デフォルトは 0 で、この場合ターミナル幅を超えない限り横に並べて表示します。
	ターミナル幅、フォント幅が取得できないときは 1 として動作します。

* ~~`--max-cont=<n>` … 同一ツイートに対するリツイートが連続した場合に
	表示を簡略化しますが、その上限数を指定します。デフォルトは 10 です。
	0 以下を指定すると簡略化を行いません(従来どおり)。~~
	未復旧です。

* `--no-combine` … `U+20DD`〜`U+20E4` の囲み文字の前にスペースを追加します。
	本来これらは直前の文字を囲み合成する Unicode 文字ですが、
	Twitter では絵文字セレクタとともに利用して安易に文字や数字を強調する
	手段として使われがちです。
	そのため、端末およびフォントによって合成した結果読めないものが
	表示されてしまう環境では、強調された肝心な部分だけが読めないという
	残念なことが起こります。それが場合によってはマシになるかも知れません。

	例えば「半角数字の1をキートップの絵文字で囲んだ文字」は

	| option | display |
	| --- | --- |
	| `--no-combine` なし(デフォルト) | `1⃣`|
	| `--no-combine` あり | `1 ⃣` |

	のように表示されると思います。
	(ブラウザでどう見えるかとご使用の端末でどう見えるかは別なので、
	このファイルを `grep no-combine ./README.md` などで表示してみてください)

* `--no-progressive` … JPEG-XL プログレッシブ画像を表示する際、
	デフォルトでは十分な解像度が得られた時点でデコードを打ち切って表示しますが、
	途中で打ち切らず必ず最終画像までデコードするようにします。

* `--overwrite-cache` … 画像を再表示する際は
	キャッシュファイルがあればキャッシュから読み込みますが、
	これを抑制して常にキャッシュファイルを作り直します。
	開発用です。

* `--progress` … 接続完了までの処理を表示します。
	遅マシン向けですが、あまり意味がないかも知れません。

* `--sixel-or` … SIXEL 画像をより高速な OR モードで出力します。
	端末側も OR モードに対応している必要がありますが、
	検出方法がありません (mlterm は対応しています)。
	また OR モードは構造上透過を扱えないため、
	透過ピクセルを持つ画像はこのオプションを指定しても
	通常モードで動作します。

* `--timeout-image=<msec>` … 画像取得のサーバへの接続タイムアウトを
	ミリ秒単位で設定します。
	0 を指定すると無期限に待ちます。
	デフォルトは `3000` (3秒)です。


ライセンス
---
* sayaka 自体は 2-clause BSD ライセンスです。
* サードパーティライブラリについては [NOTICES.md](NOTICES.md) を参照してください。


更新履歴
---
* 3.8.1 (2024/09/21) …
	リアクション通知、フォロー(された)通知に対応。
	キープアライブを実装。
	コネクション切断時のバックオフリトライを実装。
	透過画像に対応。
	モノクロおよび 8色画像の視認性を向上。
	画像処理および SIXEL 出力を高速化。
	`--overwrite-cache` オプションを実装。
	`--sixel-or` オプション(旧 `--ormode=on`) を復旧。
	v3.8.0 以降、`--local` オプションが引数を要求していたのを修正。
	v3.8.0 以降、縦 6 ピクセル未満の画像が表示できなかったのを修正。

* 3.8.0 (2024/09/04) … C 言語で全面書き直し。
	Misskey ホームタイムラインをサポート。
	リノートのネスト構造に対応。
	モノクロ画像の出力画質を改善。
	NSFW 画像の見た目を公式に近づける。
	`--nsfw=alt` を実装。
	`--color` オプションを調整。
	`--no-color` は `--color=1` に変更。
	`--force-sixel` は `--show-image=yes` に変更。
	`--no-image` は `--show-image=no` に変更。
	`-4`/`-6` は `--ipv4`/`--ipv6` に変更。
	`--play` オプションの仕様を変更。
	`--ormode`、`--palette`、`--x68k` オプションを廃止。
	Twitter 関連の機能と
	`--twitter`、`--full-url`、`--protect`、`--record-all` オプションを廃止。
	mbedTLS サポートは一旦廃止。

* 3.7.7 (2024/08/05) … OpenSSL 版を `--ciphers` オプションに対応。
	Ubuntu でのビルドエラーを修正。
	iconv についてのビルドエラーを修正。
* 3.7.6 (2024/07/14) … `--nsfw` オプションを追加、
	`--show-nsfw` オプションは廃止。
	FreeBSD でのビルドエラーを修正。
* 3.7.5 (2024/03/12) … Misskey ストリームに `--ciphers` オプションが効いて
	いなかったのを修正。画像ダウンロードにも `--ciphers` を適用するよう変更。
* 3.7.4 (2024/03/03) … Linux、OpenBSD でのビルドエラーを修正。
* 3.7.3 (2024/02/23) … Misskey ストリームの死活応答を返せてなかったので対応。
	Blurhash を高速化。
* 3.7.2 (2023/10/19) … WebP 透過画像が表示できていなかったのを修正。
	`--show-cw`、`--show-nsfw` オプションを追加。
	NSFW 画像の表示に対応。
	本文をある程度整形。
	外部インスタンス名を表示。
	接続エラーが起きた時の再接続を実装。
* 3.7.1 (2023/10/09) … WebP 画像が表示できないことがあったのを修正。
	emoji 通知メッセージで無限ループになっていたのを修正。
* 3.7.0 (2023/10/09) … Misskey 対応開始。
	Twitter への接続機能は廃止。
	これに伴い、オプション `--filter`, `--home`, `--no-rest`, `--post`,
	`--token` を廃止。
	オプション `--twitter`, `--misskey`, `--local` を追加。
	オプション `--ngword-*`, `--show-ng` は一旦廃止。
	オプション `--black`/`--white` を `--dark`/`--light` に変更。

* 2023/07/19 … Twitter に接続できなくなりました。
* 3.6.5 (2023/07/09) … `--protect` オプションを復活。
* 3.6.4 (2023/06/11) … 画像ローダをデフォルトで libjpeg, libpng, giflib
	から stb_image に変更。SSL/TLS ライブラリに OpenSSL もサポート。
	OpenBSD/amd64、Ubuntu 22.04 でのビルド修正。
* 3.6.3 (2023/03/26) … ビルドエラーを修正。
* 3.6.2 (2023/03/26) … extended_tweet 対応を復旧。
	`--no-combine` オプションを実装。
* 3.6.1 (2023/03/21) … ゼロ除算を修正。接続間隔を調整。
* 3.6.0 (2023/03/18) … フィルタストリーム廃止に伴い REST API (v1.1) で仮復旧。
	`--reconnect` オプションを廃止。
* 3.5.5 (2023/02/28) … GIF 画像をサポート。
* 3.5.4 (2022/11/08) … `--force-sixel` オプションを実装。
	`--progress` 指定時の表示エンバグ修正。
* 3.5.3 (2022/02/15) … キーワードの複数指定に対応。
	`--mathalpha` オプションを実装。
* 3.5.2 (2021/07/22) … 自動再接続と `--reconnect` オプションを実装。
* 3.5.1 (2021/03/18) … アイコン取得を HTTPS でなく HTTP, HTTPS
	の順で試すよう変更。
	エラー処理をいくつか改善。
* 3.5.0 (2021/03/03) … C++ に移行し vala 版廃止。
	画像は現在のところ JPEG, PNG のみ対応。
	ターミナル背景色の自動取得を実装。
	`--protect`、`--support-evs` オプション廃止。
	`--noimg` オプションを廃止 (`--no-image` に変更)。
	userstream 時代の録画データの再生機能廃止。
* 3.4.6 (2020/11/10) … `--no-image` 指定時のアイコン代わりのマークが
	化ける場合があったのでマークを変更。
* 3.4.5 (2020/05/15) … 表示判定を再実装して
	フォローから非フォローへのリプライが表示されてしまう場合があるのを修正。
	NG ワード判定が漏れるケースがあったのを修正。
	`--record-all` オプションを実装。
* 3.4.4 (2020/05/01) … Linux で SIGWINCH 受信で終了していたのを修正。
	リツイートの連続表示を修正。SIXEL 判定のタイムアウトを延長。
	`--token` オプションの動作を変更。ログ周りを色々修正。
* 3.4.3 (2020/02/15) … 引用ツイートが表示されないケースがあったのを修正。
	SIXEL 対応ターミナルの判別を改善。
* 3.4.2 (2020/02/01) … 2色のターミナルに対応。`--no-color` オプションを実装。
	`--no-image` オプションを用意 (従来の `--noimg` も使用可)。
	SIXEL 非対応ターミナルならアイコンの代わりにマークを表示。
* 3.4.1 (2020/01/12) … 疑似ホームタイムラインの調整。
	SIXEL 非対応ターミナルを自動判別してみる。
* 3.4.0 (2020/01/05) … フィルタストリームによる擬似ホームタイムラインに対応。
* 3.3.3 (2020/01/04) … Linux でのビルドエラーを修正。
* 3.3.2 (2018/01/02) … pkgsrc-2017Q4 (vala-0.38.1以上) でのビルドに対応。
	画像は Content-Type が image/* の時のみ表示するようにしてみる。
	mbedTLS-2.4.2 に更新。
	`--timeout-image` オプションを実装。
* 3.3.1 (2016/12/23) … リソースリークを含むバグ修正。
* 3.3.0 (2016/11/25) … libcurl ではなく mbedTLS に移行してみる。
	`--full-url` オプション、`--progress` オプションを実装。
	`--sixel-cmd` オプション廃止、PHP 版サポート廃止。
	EUC-JP/JIS に変換できない文字の処理を追加。
	画像の高品質化、高速化いろいろ。
* 3.2.2 (2016/09/25) … glib-networking ではなく libcurl に移行してみる。
	`--post` オプション、`--ciphers` オプションを実装。
	extended_tweet の表示に対応。
* 3.2.1 (2016/04/24) … `--filter` オプション、`--record` オプションを実装。
	NGワード編集機能実装。
	「リツイートを非表示」にしたユーザに対応。
	shindanmaker の画像サムネイルに対応。
	Unicode 外字をコード表示。
	連続するリツイート・ふぁぼを圧縮して表示。
* 3.2.0 (2016/02/24) … vala 版サポート。
	画像の横方向への展開サポート (vala 版のみ)。
	SQLite3 データベース廃止 (PHP 版のみ)。
* 3.1.0 (2015/07/26) …
	`--font` オプションの仕様変更。
	VT382(?)など(いわゆる)半角フォントの縦横比が 1:2 でない環境に対応。
	`--noimg` の時に改行が一つ多かったのを修正。
* 3.0.9 (2015/06/14) …
	`--eucjp`、`--protect` オプションを追加しました。
	またコメント付き RT の仕様変更(?)に追従しました。
* 3.0.8 (2015/05/03) …
	`--font` オプションを追加して、画像サイズを連動するようにしました。
* 3.0.7 (2015/04/19) … コメント付き RT の表示に対応してみました。
* 3.0.6 (2014/12/06) … libsixel 1.3 に対応。libsixel 1.3 未満は使えません。
* 3.0.5 (2014/10/23) … 本文を折り返して表示。


。
---
[@isaki68k](https://misskey.io/@isaki68k)
[差入れ](https://www.amazon.co.jp/hz/wishlist/ls/3TXVBRKSKTF31)してもらえると喜びます。
