(* debug-request.sml
 *
 * COPYRIGHT (c) 1990,1991 by John H. Reppy.  See COPYRIGHT file for details.
 *
 * Including this file in the compilation will replace the XRequest structure with
 * one in which the encoding messages are wrapped with error handlers.
 *)

structure DebugXRequest =
  struct

    open XRequest

    fun debug (f, s) x = (f x) handle ex => (
	  CIO.print(implode[
	      "XRequest.", s, ": uncaught exception ", System.exn_name ex, "\n"
	    ]);
	  raise ex)

    val encodeAllocColor = debug (encodeAllocColor, "encodeAllocColor")
    val encodeAllocNamedColor = debug (encodeAllocNamedColor, "encodeAllocNamedColor")
    val encodeAllowEvents = debug (encodeAllowEvents, "encodeAllowEvents")
    val encodeBell = debug (encodeBell, "encodeBell")
    val encodeChangeActivePointerGrab = debug (encodeChangeActivePointerGrab, "encodeChangeActivePointerGrab")
    val encodeChangeGC = debug (encodeChangeGC, "encodeChangeGC")
    val encodeChangeHosts = debug (encodeChangeHosts, "encodeChangeHosts")
    val encodeChangeKeyboardControl = debug (encodeChangeKeyboardControl, "encodeChangeKeyboardControl")
    val encodeChangePointerControl = debug (encodeChangePointerControl, "encodeChangePointerControl")
    val encodeChangeProperty = debug (encodeChangeProperty, "encodeChangeProperty")
    val encodeChangeSaveSet = debug (encodeChangeSaveSet, "encodeChangeSaveSet")
    val encodeChangeWindowAttributes = debug (encodeChangeWindowAttributes, "encodeChangeWindowAttributes")
    val encodeCirculateWindow = debug (encodeCirculateWindow, "encodeCirculateWindow")
    val encodeClearArea = debug (encodeClearArea, "encodeClearArea")
    val encodeCloseFont = debug (encodeCloseFont, "encodeCloseFont")
    val encodeConfigureWindow = debug (encodeConfigureWindow, "encodeConfigureWindow")
    val encodeConvertSelection = debug (encodeConvertSelection, "encodeConvertSelection")
    val encodeCopyArea = debug (encodeCopyArea, "encodeCopyArea")
    val encodeCopyColormapAndFree = debug (encodeCopyColormapAndFree, "encodeCopyColormapAndFree")
    val encodeCopyGC = debug (encodeCopyGC, "encodeCopyGC")
    val encodeCopyPlane = debug (encodeCopyPlane, "encodeCopyPlane")
    val encodeCreateColormap = debug (encodeCreateColormap, "encodeCreateColormap")
    val encodeCreateCursor = debug (encodeCreateCursor, "encodeCreateCursor")
    val encodeCreateGC = debug (encodeCreateGC, "encodeCreateGC")
    val encodeCreateGlyphCursor = debug (encodeCreateGlyphCursor, "encodeCreateGlyphCursor")
    val encodeCreatePixmap = debug (encodeCreatePixmap, "encodeCreatePixmap")
    val encodeCreateWindow = debug (encodeCreateWindow, "encodeCreateWindow")
    val encodeDeleteProperty = debug (encodeDeleteProperty, "encodeDeleteProperty")
    val encodeDestroySubwindows = debug (encodeDestroySubwindows, "encodeDestroySubwindows")
    val encodeDestroyWindow = debug (encodeDestroyWindow, "encodeDestroyWindow")
    val encodeFillPoly = debug (encodeFillPoly, "encodeFillPoly")
    val encodeForceScreenSaver = debug (encodeForceScreenSaver, "encodeForceScreenSaver")
    val encodeFreeColormap = debug (encodeFreeColormap, "encodeFreeColormap")
    val encodeFreeColors = debug (encodeFreeColors, "encodeFreeColors")
    val encodeFreeCursor = debug (encodeFreeCursor, "encodeFreeCursor")
    val encodeFreeGC = debug (encodeFreeGC, "encodeFreeGC")
    val encodeFreePixmap = debug (encodeFreePixmap, "encodeFreePixmap")
    val encodeGetAtomName = debug (encodeGetAtomName, "encodeGetAtomName")
    val encodeGetGeometry = debug (encodeGetGeometry, "encodeGetGeometry")
    val encodeGetImage = debug (encodeGetImage, "encodeGetImage")
    val encodeGetKeyboardMapping = debug (encodeGetKeyboardMapping, "encodeGetKeyboardMapping")
    val encodeGetMotionEvents = debug (encodeGetMotionEvents, "encodeGetMotionEvents")
    val encodeGetProperty = debug (encodeGetProperty, "encodeGetProperty")
    val encodeGetSelectionOwner = debug (encodeGetSelectionOwner, "encodeGetSelectionOwner")
    val encodeGetWindowAttributes = debug (encodeGetWindowAttributes, "encodeGetWindowAttributes")
    val encodeGrabButton = debug (encodeGrabButton, "encodeGrabButton")
    val encodeGrabKey = debug (encodeGrabKey, "encodeGrabKey")
    val encodeGrabKeyboard = debug (encodeGrabKeyboard, "encodeGrabKeyboard")
    val encodeGrabPointer = debug (encodeGrabPointer, "encodeGrabPointer")
    val encodeImageText16 = debug (encodeImageText16, "encodeImageText16")
    val encodeImageText8 = debug (encodeImageText8, "encodeImageText8")
    val encodeInstallColormap = debug (encodeInstallColormap, "encodeInstallColormap")
    val encodeInternAtom = debug (encodeInternAtom, "encodeInternAtom")
    val encodeKillClient = debug (encodeKillClient, "encodeKillClient")
    val encodeListFonts = debug (encodeListFonts, "encodeListFonts")
    val encodeListFontsWithInfo = debug (encodeListFontsWithInfo, "encodeListFontsWithInfo")
    val encodeListInstalledColormaps = debug (encodeListInstalledColormaps, "encodeListInstalledColormaps")
    val encodeListProperties = debug (encodeListProperties, "encodeListProperties")
    val encodeLookupColor = debug (encodeLookupColor, "encodeLookupColor")
    val encodeMapSubwindows = debug (encodeMapSubwindows, "encodeMapSubwindows")
    val encodeMapWindow = debug (encodeMapWindow, "encodeMapWindow")
    val encodeOpenFont = debug (encodeOpenFont, "encodeOpenFont")
    val encodePolyArc = debug (encodePolyArc, "encodePolyArc")
    val encodePolyFillArc = debug (encodePolyFillArc, "encodePolyFillArc")
    val encodePolyFillRectangle = debug (encodePolyFillRectangle, "encodePolyFillRectangle")
    val encodePolyLine = debug (encodePolyLine, "encodePolyLine")
    val encodePolyPoint = debug (encodePolyPoint, "encodePolyPoint")
    val encodePolyRectangle = debug (encodePolyRectangle, "encodePolyRectangle")
    val encodePolySegment = debug (encodePolySegment, "encodePolySegment")
    val encodePolyText16 = debug (encodePolyText16, "encodePolyText16")
    val encodePolyText8 = debug (encodePolyText8, "encodePolyText8")
    val encodePutImage = debug (encodePutImage, "encodePutImage")
    val encodeQueryBestSize = debug (encodeQueryBestSize, "encodeQueryBestSize")
    val encodeQueryColors = debug (encodeQueryColors, "encodeQueryColors")
    val encodeQueryExtension = debug (encodeQueryExtension, "encodeQueryExtension")
    val encodeQueryFont = debug (encodeQueryFont, "encodeQueryFont")
    val encodeQueryPointer = debug (encodeQueryPointer, "encodeQueryPointer")
    val encodeQueryTextExtents = debug (encodeQueryTextExtents, "encodeQueryTextExtents")
    val encodeQueryTree = debug (encodeQueryTree, "encodeQueryTree")
    val encodeRecolorCursor = debug (encodeRecolorCursor, "encodeRecolorCursor")
    val encodeReparentWindow = debug (encodeReparentWindow, "encodeReparentWindow")
    val encodeRotateProperties = debug (encodeRotateProperties, "encodeRotateProperties")
    val encodeSetAccessControl = debug (encodeSetAccessControl, "encodeSetAccessControl")
    val encodeSetClipRectangles = debug (encodeSetClipRectangles, "encodeSetClipRectangles")
    val encodeSetCloseDownMode = debug (encodeSetCloseDownMode, "encodeSetCloseDownMode")
    val encodeSetDashes = debug (encodeSetDashes, "encodeSetDashes")
    val encodeSetFontPath = debug (encodeSetFontPath, "encodeSetFontPath")
    val encodeSetInputFocus = debug (encodeSetInputFocus, "encodeSetInputFocus")
    val encodeSetScreenSaver = debug (encodeSetScreenSaver, "encodeSetScreenSaver")
    val encodeSetSelectionOwner = debug (encodeSetSelectionOwner, "encodeSetSelectionOwner")
    val encodeStoreColors = debug (encodeStoreColors, "encodeStoreColors")
    val encodeStoreNamedColor = debug (encodeStoreNamedColor, "encodeStoreNamedColor")
    val encodeTranslateCoords = debug (encodeTranslateCoords, "encodeTranslateCoords")
    val encodeUngrabButton = debug (encodeUngrabButton, "encodeUngrabButton")
    val encodeUngrabKey = debug (encodeUngrabKey, "encodeUngrabKey")
    val encodeUngrabKeyboard = debug (encodeUngrabKeyboard, "encodeUngrabKeyboard")
    val encodeUngrabPointer = debug (encodeUngrabPointer, "encodeUngrabPointer")
    val encodeUninstallColormap = debug (encodeUninstallColormap, "encodeUninstallColormap")
    val encodeUnmapSubwindows = debug (encodeUnmapSubwindows, "encodeUnmapSubwindows")
    val encodeUnmapWindow = debug (encodeUnmapWindow, "encodeUnmapWindow")
    val encodeWarpPointer = debug (encodeWarpPointer, "encodeWarpPointer")

  end  (* DebugXRequest *)

structure XRequest = DebugXRequest
