/*
 * Copyright (c) 1997-2012 Motonori Nakamura <motonori@wide.ad.jp>
 * Copyright (c) 1997-2012 WIDE Project
 * Copyright (c) 1997-2003 Kyoto University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by WIDE Project and
 *      its contributors.
 * 4. Neither the name of the Project, the University nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: common.h,v 1.71 2012/06/07 05:45:28 motonori Exp $
 */

# include "compat.h"

#if HAVE_PORT_BEFORE_H
# include "port_before.h"
#endif

# include <stdio.h>
# include <unistd.h>
#ifdef EX_OK
/* to avoid macroname collision on SGI box */
#  undef EX_OK
#endif
# include <stdlib.h>
# include <string.h>
# include <time.h>
# include <sys/time.h>
# include <sys/types.h>
# include <ctype.h>
# include <sys/param.h>
# include <sys/resource.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# include <arpa/nameser.h>
# include <sys/stat.h>
# include <setjmp.h>
# include <resolv.h>
# include <netdb.h>
# include <syslog.h>
# include <sysexits.h>
# include <fcntl.h>
# include <signal.h>
# include <errno.h>
#ifndef FD_SET
# include <sys/select.h>
#endif

#ifdef __STDC__
# include <stdarg.h>
# define VA_LOCAL_DECL		va_list ap;
# define VA_START(f)		va_start(ap, f)
# define VA_END			va_end(ap)
#else
# include <varargs.h>
# define VA_LOCAL_DECL		va_list ap;
# define VA_START(f)		va_start(ap)
# define VA_END			va_end(ap)
#endif

/* Missing macro definitions */
#ifndef HFIXEDSZ
# define HFIXEDSZ	12		/* arpa/nameser.h */
#endif
#ifndef QFIXEDSZ
# define QFIXEDSZ	4		/* arpa/nameser.h */
#endif
#ifndef INT16SZ
# define INT16SZ	2		/* arpa/nameser.h */
#endif
#ifndef INT32SZ
# define INT32SZ	4		/* arpa/nameser.h */
#endif
#ifndef INADDR_NONE
# define INADDR_NONE	0xffffffff	/* netinet/in.h */
#endif
#ifndef EX_CONFIG
# define EX_CONFIG	78		/* sysexit.h */
#endif
#ifndef T_AAAA
# define T_AAAA		28		/* IP6 Address */
#endif

#ifndef MAXHOSTNAMELEN
# define MAXHOSTNAMELEN	256		/* sys/param.h */
#endif

#if HAVE_PORT_AFTER_H
# include "port_after.h"
#endif

/* bind8 modification on FreeBSD 2.2.x */
#ifdef NS_NOTIFY_OP
# ifndef NS_UPDATE_OP
#  define NS_UPDATE_OP	5
# endif
#else
# define NS_UPDATE_OP	ns_o_update
#endif
#define GET16	_getshort

/* See conf.h of sendmail to determine size */
#ifdef ultrix
#  define SYSLOG_BUFSIZE	256
#endif
#ifdef sgi
/* how can I detect IRIX 6 ? */
#  define SYSLOG_BUFSIZE	512	/* IRIX 6 only */
#endif
#ifndef SYSLOG_BUFSIZE
#  define SYSLOG_BUFSIZE	1024
#endif


# define LOG_DEFAULT		LOG_LOCAL5
# define LOG_NONE		-1	/* (must be < 0) */
# define LOG_STDERR		-2	/* (must be < 0) */

# define MAXLINE		1024
# define CHUNKSIZE		1024*50
# define SMTPBUFSIZE		2048

#ifndef MAX_SOCK
# define MAX_SOCK		(FD_SETSIZE - 1)
#endif

# define SECONDS		*1
# define MINUTES		*60

# define SMTP_ERROR(x)		(500+x)
# define SMTP_TEMPFAIL(x)	(400+x)

# define RR_ANY			0x01
# define RR_MX			0x02
# define RR_CNAME		0x04
# define RR_A			0x08
# define RR_AAAA		0x10
# define RR_ALL			0x1f

# define MALLOC(x)		((sti.mem += (x)), malloc(x))

struct query_chain {
	char			*request;
	u_char			type;
	u_char			need;
	int			reqlen;
	u_char			try;
	u_char			ns;
	u_char			badns;
	u_char			nocache;
	time_t			time;
	struct dns_stat		*stat;
	struct query_chain	*chain;
	struct query_chain	*next;
	struct query_chain	*prev;
};

/* DNS query history hash entry */
struct dns_stat {
	struct dns_stat		*next;
	char			*name;		/* name for query */
	u_char			rr_sent;
	u_char			rr_need;
	u_char			rr_got;
	u_char			rr_timeout;
	u_char			rr_noex;
	struct mx		*mx;
	struct dns_stat		*cname;
	struct query_chain	*requests;
};

/* alias names for this host to eliminate lower MX hosts */
struct hostalias {
	char			*name;		/* alias name */
	struct hostalias	*next;		/* next alias */
};

/* address information for a host */
struct inetaddr {
	int			domain;		/* INET or INET6 or ... */
	int			len;		/* address length */
	char			*address;	/* address */
	int			stat;		/* error status for TCP */
	struct inetaddr		*next;		/* next address for the host */
};

struct host {
	char			*name;		/* host name */
	struct host		*next;		/* chain just for management */
	struct inetaddr		*addr;		/* top of address list */
	struct inetaddr		*current;	/* working address */
	int			proto;
	int			state;		/* state of SMTP connection */
	time_t			time;
	int			stat;		/* error status for SMTP */
	char			*response;	/* response code of SMTP */
	time_t			start;		/* start time of transaction */
	struct mx		*mx_ref;	/* MX reference list */
	struct host		*hash;		/* host chain in hash table */
};

struct mx {
	char			*name;		/* MX name */
#if 0
	int			stat;		/* error status for A query */
	char			*response;	/* error response */
#endif
	int			pref;		/* preference */
	int			weight;		/* random value for same pref */
	struct host		*host;		/* address information */
	struct mx		*next;		/* next MX */
	struct mx		*mx_ref;	/* MX reference list */
	struct domain		*domain;	/* reverse link to domain */
	long			opt;		/* option in map file */
};

struct host_map {
	char			*name;		/* destination domain */
	char			**arg;		/* way of host lookup */
	struct host_map		*next;		/* map chain */
	struct host_map		*hash;		/* chain in hash table */
};

# define MAPOPT_TRYALLADDR	0001		/* try all addr even if TFAIL */

struct domain {
	char			*name;		/* domain part of mail addr */
	int			stat;		/* error status for MX query */
	char			*response;	/* error response */
	struct mx		*firstmx;	/* first MX */
	struct mx		*curmx;		/* working MX */
	int			checked;	/* temporary local flag */
	struct domain		*next;		/* chain just for management */
	struct recipient	*rcpt_top;	/* recipient list to domain */
	struct recipient	*rcpt_tail;	/* recipient list to domain */
	struct domain		*workchain;	/* domain chain with job */
	struct domain		*hash;		/* domain chain in hash table */
	char			**map_arg;	/* way of host lookup */
	int			rcpts;		/* max recipient count */
};

struct domain_rcpts {
	char			*name;		/* destination domain */
	int			rcpts;		/* count of recipients */
	struct domain_rcpts	*hash;		/* chain in hash table */
};

# define RCPT_NOOP	0
# define RCPT_RETRY	1
# define RCPT_WORK	2
# define RCPT_DONE	3

struct recipient {
	char			*address;	/* mail address */
	char			*notify;	/* NOTIFY= parameter */
	char			*orcpt;		/* ORCPT= parameter */
	int			stat;		/* current status */
	int			result;		/* final result */
	int			again;		/* try the same MX again */
	char			*response;	/* final response */
	struct domain		*domain;	/* domain part */
	struct host		*final;
	struct recipient	*next;		/* next recipient */
	struct recipient	*chain;		/* chain for the same host */
	struct recipient	*dom_chain;	/* chain for the same domain */
};

struct message {
	char			*data;		/* data chunk */
	int			offset;		/* length of this chunk */
	struct message		*next;		/* next chunk */
};

struct envelope {
	char			*sender;	/* sender address */
	char			*envid;		/* ENVID= parameter */
	char			*size;		/* SIZE= parameter */
	char			*body;		/* BODY= parameter */
	char			*ret;		/* RET= parameter */
	char			*mid;		/* Message-Id */
	char			*queueid;	/* queie-id from sendmail */
	int			keepqueueid;	/* no purge flag on queueid */
	int			realsize;	/* size of message */
	struct recipient	*rcpt_list;	/* recipient list */
	struct recipient	*rcpt_tail;	/* tail of recipient list */
	struct recipient	*resp_ptr;	/* LMTP response pointer */
	struct message		*msg;		/* data body */
	struct domain		*work_domain;	/* working domain list */
	struct domain		*work_dom_ptr;	/* working domain pointer */
};

struct connection {
	int			seq;		/* seq. number of this trans. */
	int			socket;		/* socket descriptor */
	char			*inbuf;		/* input buffer */
	int			inlen;		/* data length in input buf */
	char			*outbuf;	/* output buffer */
	int			outlen;		/* data length in output buf */
	int			bufsize;	/* allocated size of buffers */
	struct host		*host;		/* destination host */
	struct recipient	*rcpt;		/* sending recipient */
	struct recipient	*crcpts;	/* current sending recipient */
	struct recipient	*crcptr;	/* current waiting response */
	int			goodrcpt;	/* at least 1 good address */
	int			goodmail;	/* MAIL is OK on PIPELINING */
	int			datasent;	/* DATA sent on PIPELINING */
	struct message		*msg;		/* sending data chunk */
	int			offset;		/* start pos to be sent next */
	int			reuse;		/* this conn. must be reused */
};

struct statinfo {
	int			nrcpt;		/* total recipients */
	int			nqueries;	/* total DNS queries */
	int			nanswers;	/* total DNS answers */
	int			nconnect;	/* total count of connect() */
	int			nquitok;	/* total successful conns */
	int			ntimeout;	/* total timed out conn.s */
	int			ntrans;		/* total transactions */
	int			noktrans;	/* total successful trans. */
	int			nsent;		/* total sent recps */
	int			ndeferred;	/* total deferred recps */
	int			nnsfailed;	/* total recps w/ err. (NS) */
	int			nsmtpfailed;	/* total recps w/ err. (SMTP) */
	int			minsock;	/* min# of used sockets */
	int			maxsock;	/* max# of used sockets */
	int			maxcquery;	/* max# of concurrent queries */
	int			dns_inb;	/* total incoming DNS traffic */
	int			dns_outb;	/* total outgoing DNS traffic */
	int			inbounds;	/* total incoming traffic */
	int			outbounds;	/* total outgoing traffic */
	int			mem;		/* total allocated memory */
	time_t			time_sm_start;	/* start time of sendmail */
	time_t			time_start;	/* start time of delivery */
	time_t			time_mxgot;	/* time all MX got */
	time_t			time_almostfinish;	/* finished time of delivery */
	time_t			time_finish;	/* finished time of delivery */
	time_t			max_delay;	/* longest transaction */
};

# define DEBUG_ADDRESS		0x0001
# define DEBUG_CONNECT		0x0002
# define DEBUG_EVENT		0x0004
# define DEBUG_LMTP		0x0008
# define DEBUG_DNS		0x0010
# define DEBUG_TRANS		0x0020
# define DEBUG_SMTP		0x0040
# define DEBUG_RESUSE		0x0080
# define DEBUG_HASH		0x0100
# define DEBUG_MAP		0x0200
# define DEBUG_ALL		0x03FF
# define DEBUG_NODELIVERY	0x1000
# define DEBUG_QUERYONLY	0x2000

#ifdef INET6			/* flags */
# define SMTP_V4		0x1
# define SMTP_V6		0x2
# define SMTP_V4_FIRST		0x4
# define SMTP_V6_FIRST		0x8
#endif

struct confparam {
#ifdef INET6
	int			inetdom;	/* internet domain */
#endif
	int			v4v6fallback;	/* fallbacking for v4/v6 only */
	int			sd_max;		/* max of socket descriptor */
	int			rcpt_min;	/* recipient lower limit */
	int			sendbufsize;	/* TCP send buffer size */
	int			data_max;	/* max size of message */
	int			src_port;	/* SMTP source port */
	int			cquery_max;	/* MAX concurrent queries */
	int			dst_port;	/* SMTP destination port */
	int			useAfirstMX;	/* use A RR if first MX */
	int			nopipelining;	/* surpress SMTP pipelining */
	int			tryANYfirst;	/* try T_ANY query first */
	int			debug;		/* debug flags */
	int			log_facility;	/* logging facility */
	int			rcpts_trans;	/* recipients per transaction */
	int			domainsep;	/* separated delivery per dom */
	int			parsequeueid;	/* get queue-id info. */
	int			showversion;	/* show version info. */
	int			absentAok;	/* MXs point absent A are OK */
	int			showrecipient;	/* show recipient info. */
	int			smtp_reuse;	/* reuse SMTP connection */
	time_t			t_timeout;	/* total timeout */
	char			*map;		/* path of map file */
	char			*pgateway;	/* name of protocol gateway */
	char			*fallbackmx;	/* name of fallback MX host */
	char			*sourceIP;	/* source address for SMTP */
	char			*src_mod_path;	/* addr. list file to modify */
	char			*src_mod_ptn;	/* modification pattern */
	char			*rcpts_def;	/* path of file definded recipients of domain */
};

union SockAddrUnion {
	struct sockaddr_in	in;
#ifdef INET6
	struct sockaddr_in6	in6;
#endif
};
typedef union SockAddrUnion SockAddr;
