#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5452
#define LARGE_STATE_COUNT 939
#define SYMBOL_COUNT 483
#define ALIAS_COUNT 4
#define TOKEN_COUNT 191
#define EXTERNAL_TOKEN_COUNT 27
#define FIELD_COUNT 44
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 216

enum {
  anon_sym_POUND_BANG = 1,
  aux_sym_shebang_line_token1 = 2,
  sym_comment = 3,
  aux_sym_simple_identifier_token1 = 4,
  aux_sym_simple_identifier_token2 = 5,
  aux_sym_simple_identifier_token3 = 6,
  aux_sym_simple_identifier_token4 = 7,
  anon_sym_nil = 8,
  sym_real_literal = 9,
  sym_integer_literal = 10,
  sym_hex_literal = 11,
  sym_oct_literal = 12,
  sym_bin_literal = 13,
  anon_sym_true = 14,
  anon_sym_false = 15,
  anon_sym_DQUOTE = 16,
  aux_sym_line_str_text_token1 = 17,
  anon_sym_BSLASH = 18,
  anon_sym_u = 19,
  aux_sym__uni_character_literal_token1 = 20,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 21,
  anon_sym_RPAREN = 22,
  sym_raw_str_interpolation_start = 23,
  anon_sym_BSLASH_LPAREN = 24,
  anon_sym_COMMA = 25,
  sym__escaped_identifier = 26,
  anon_sym_COLON = 27,
  anon_sym_BANG = 28,
  anon_sym_LPAREN = 29,
  anon_sym_LBRACK = 30,
  anon_sym_RBRACK = 31,
  anon_sym_DOT = 32,
  anon_sym_Type = 33,
  anon_sym_Protocol = 34,
  anon_sym_QMARK = 35,
  sym__immediate_quest = 36,
  anon_sym_some = 37,
  anon_sym_any = 38,
  anon_sym_AMP = 39,
  anon_sym_async = 40,
  anon_sym_POUNDselector = 41,
  anon_sym_getter_COLON = 42,
  anon_sym_setter_COLON = 43,
  aux_sym_custom_operator_token1 = 44,
  anon_sym_LT = 45,
  anon_sym_GT = 46,
  sym__await_operator = 47,
  anon_sym_POUNDfile = 48,
  anon_sym_POUNDfileID = 49,
  anon_sym_POUNDfilePath = 50,
  anon_sym_POUNDline = 51,
  anon_sym_POUNDcolumn = 52,
  anon_sym_POUNDfunction = 53,
  anon_sym_POUNDdsohandle = 54,
  anon_sym_POUNDcolorLiteral = 55,
  anon_sym_POUNDfileLiteral = 56,
  anon_sym_POUNDimageLiteral = 57,
  anon_sym_LBRACE = 58,
  anon_sym_RBRACE = 59,
  anon_sym_in = 60,
  anon_sym_self = 61,
  anon_sym_super = 62,
  anon_sym_if = 63,
  anon_sym_guard = 64,
  anon_sym_switch = 65,
  anon_sym_case = 66,
  anon_sym_fallthrough = 67,
  anon_sym_do = 68,
  anon_sym_POUNDkeyPath = 69,
  anon_sym_try = 70,
  anon_sym_try_BANG = 71,
  anon_sym_try_QMARK = 72,
  anon_sym_PLUS_EQ = 73,
  anon_sym_DASH_EQ = 74,
  anon_sym_STAR_EQ = 75,
  anon_sym_SLASH_EQ = 76,
  anon_sym_PERCENT_EQ = 77,
  anon_sym_EQ = 78,
  anon_sym_BANG_EQ = 79,
  anon_sym_BANG_EQ_EQ = 80,
  anon_sym_EQ_EQ_EQ = 81,
  anon_sym_LT_EQ = 82,
  anon_sym_GT_EQ = 83,
  anon_sym_is = 84,
  anon_sym_PLUS = 85,
  anon_sym_DASH = 86,
  anon_sym_STAR = 87,
  anon_sym_SLASH = 88,
  anon_sym_PERCENT = 89,
  anon_sym_PLUS_PLUS = 90,
  anon_sym_DASH_DASH = 91,
  anon_sym_TILDE = 92,
  anon_sym_PIPE = 93,
  anon_sym_CARET = 94,
  anon_sym_LT_LT = 95,
  anon_sym_GT_GT = 96,
  sym_statement_label = 97,
  anon_sym_for = 98,
  anon_sym_while = 99,
  anon_sym_repeat = 100,
  sym_throw_keyword = 101,
  anon_sym_return = 102,
  anon_sym_continue = 103,
  anon_sym_break = 104,
  anon_sym_yield = 105,
  anon_sym_POUNDavailable = 106,
  anon_sym_import = 107,
  anon_sym_typealias = 108,
  anon_sym_struct = 109,
  anon_sym_class = 110,
  anon_sym_enum = 111,
  anon_sym_protocol = 112,
  anon_sym_let = 113,
  anon_sym_var = 114,
  anon_sym_func = 115,
  anon_sym_actor = 116,
  anon_sym_extension = 117,
  anon_sym_indirect = 118,
  anon_sym_init = 119,
  anon_sym_SEMI = 120,
  anon_sym_deinit = 121,
  anon_sym_subscript = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  anon_sym__modify = 125,
  anon_sym_prefix = 126,
  anon_sym_infix = 127,
  anon_sym_postfix = 128,
  anon_sym_operator = 129,
  anon_sym_precedencegroup = 130,
  anon_sym_associatedtype = 131,
  anon_sym_AT = 132,
  sym_wildcard_pattern = 133,
  sym_property_behavior_modifier = 134,
  anon_sym_override = 135,
  anon_sym_convenience = 136,
  anon_sym_required = 137,
  anon_sym_nonisolated = 138,
  anon_sym_public = 139,
  anon_sym_private = 140,
  anon_sym_internal = 141,
  anon_sym_fileprivate = 142,
  anon_sym_open = 143,
  anon_sym_mutating = 144,
  anon_sym_nonmutating = 145,
  anon_sym_static = 146,
  anon_sym_dynamic = 147,
  anon_sym_optional = 148,
  anon_sym_final = 149,
  anon_sym_inout = 150,
  anon_sym_ATescaping = 151,
  anon_sym_ATautoclosure = 152,
  anon_sym_weak = 153,
  anon_sym_unowned = 154,
  anon_sym_unowned_LPARENsafe_RPAREN = 155,
  anon_sym_unowned_LPARENunsafe_RPAREN = 156,
  anon_sym_property = 157,
  anon_sym_receiver = 158,
  anon_sym_param = 159,
  anon_sym_setparam = 160,
  anon_sym_delegate = 161,
  sym_directive = 162,
  sym_diagnostic = 163,
  sym_multiline_comment = 164,
  sym_raw_str_part = 165,
  sym_raw_str_continuing_indicator = 166,
  sym_raw_str_end_part = 167,
  sym__semi = 168,
  sym__arrow_operator_custom = 169,
  sym__dot_custom = 170,
  sym__three_dot_operator_custom = 171,
  sym__open_ended_range_operator_custom = 172,
  sym__conjunction_operator_custom = 173,
  sym__disjunction_operator_custom = 174,
  sym__nil_coalescing_operator_custom = 175,
  sym__eq_custom = 176,
  sym__eq_eq_custom = 177,
  sym__plus_then_ws = 178,
  sym__minus_then_ws = 179,
  sym_bang = 180,
  sym__throws_keyword = 181,
  sym__rethrows_keyword = 182,
  sym_default_keyword = 183,
  sym_where_keyword = 184,
  sym_else = 185,
  sym_catch_keyword = 186,
  sym__as_custom = 187,
  sym__as_quest_custom = 188,
  sym__as_bang_custom = 189,
  sym__async_keyword_custom = 190,
  sym_source_file = 191,
  sym_shebang_line = 192,
  sym_simple_identifier = 193,
  sym_identifier = 194,
  sym__basic_literal = 195,
  sym_boolean_literal = 196,
  sym__string_literal = 197,
  sym_line_string_literal = 198,
  sym__line_string_content = 199,
  sym_line_str_text = 200,
  sym_str_escaped_char = 201,
  sym__uni_character_literal = 202,
  sym_multi_line_string_literal = 203,
  sym_raw_string_literal = 204,
  sym_raw_str_interpolation = 205,
  sym__multi_line_string_content = 206,
  sym__interpolation = 207,
  sym__interpolation_contents = 208,
  sym_multi_line_str_text = 209,
  sym_type_annotation = 210,
  sym__possibly_implicitly_unwrapped_type = 211,
  sym__type = 212,
  sym__unannotated_type = 213,
  sym_user_type = 214,
  sym__simple_user_type = 215,
  sym_tuple_type = 216,
  sym_tuple_type_item = 217,
  sym__tuple_type_item_identifier = 218,
  sym_function_type = 219,
  sym_array_type = 220,
  sym_dictionary_type = 221,
  sym_optional_type = 222,
  sym_metatype = 223,
  sym__quest = 224,
  sym_opaque_type = 225,
  sym_existential_type = 226,
  sym_protocol_composition_type = 227,
  sym__expression = 228,
  sym__unary_expression = 229,
  sym_postfix_expression = 230,
  sym_constructor_expression = 231,
  sym_navigation_expression = 232,
  sym__navigable_type_expression = 233,
  sym_open_start_range_expression = 234,
  sym__range_operator = 235,
  sym_open_end_range_expression = 236,
  sym_prefix_expression = 237,
  sym_as_expression = 238,
  sym_selector_expression = 239,
  sym__binary_expression = 240,
  sym_multiplicative_expression = 241,
  sym_additive_expression = 242,
  sym_range_expression = 243,
  sym_infix_expression = 244,
  sym_nil_coalescing_expression = 245,
  sym_check_expression = 246,
  sym_comparison_expression = 247,
  sym_equality_expression = 248,
  sym_conjunction_expression = 249,
  sym_disjunction_expression = 250,
  sym_bitwise_operation = 251,
  sym_custom_operator = 252,
  sym_navigation_suffix = 253,
  sym_call_suffix = 254,
  sym_constructor_suffix = 255,
  sym__constructor_value_arguments = 256,
  sym_type_arguments = 257,
  sym_value_arguments = 258,
  sym_value_argument = 259,
  sym_try_expression = 260,
  sym_await_expression = 261,
  sym_ternary_expression = 262,
  sym__expr_hack_at_ternary_binary_suffix = 263,
  sym_expr_hack_at_ternary_binary_call = 264,
  sym_expr_hack_at_ternary_binary_call_suffix = 265,
  sym_call_expression = 266,
  sym__primary_expression = 267,
  sym_tuple_expression = 268,
  sym_array_literal = 269,
  sym_dictionary_literal = 270,
  sym__dictionary_literal_item = 271,
  sym__special_literal = 272,
  sym__playground_literal = 273,
  sym_lambda_literal = 274,
  sym__lambda_type_declaration = 275,
  sym_capture_list = 276,
  sym_capture_list_item = 277,
  sym_lambda_function_type = 278,
  sym_lambda_function_type_parameters = 279,
  sym_lambda_parameter = 280,
  sym_self_expression = 281,
  sym_super_expression = 282,
  sym__else_options = 283,
  sym_if_statement = 284,
  sym__if_condition_sequence_item = 285,
  sym__if_let_binding = 286,
  sym_guard_statement = 287,
  sym_switch_statement = 288,
  sym_switch_entry = 289,
  sym_switch_pattern = 290,
  sym_do_statement = 291,
  sym_catch_block = 292,
  sym_where_clause = 293,
  sym_key_path_expression = 294,
  sym_key_path_string_expression = 295,
  sym__key_path_component = 296,
  sym__key_path_postfixes = 297,
  sym__try_operator = 298,
  sym__assignment_and_operator = 299,
  sym__equality_operator = 300,
  sym__comparison_operator = 301,
  sym__is_operator = 302,
  sym__additive_operator = 303,
  sym__multiplicative_operator = 304,
  sym_as_operator = 305,
  sym__prefix_unary_operator = 306,
  sym__bitwise_binary_operator = 307,
  sym__postfix_unary_operator = 308,
  sym_directly_assignable_expression = 309,
  sym_statements = 310,
  sym__local_statement = 311,
  sym__top_level_statement = 312,
  sym__block = 313,
  sym__labeled_statement = 314,
  sym_for_statement = 315,
  sym_while_statement = 316,
  sym_repeat_while_statement = 317,
  sym_control_transfer_statement = 318,
  sym__throw_statement = 319,
  sym__optionally_valueful_control_keyword = 320,
  sym_assignment = 321,
  sym_availability_condition = 322,
  sym__availability_argument = 323,
  sym__global_declaration = 324,
  sym__type_level_declaration = 325,
  sym__local_declaration = 326,
  sym__local_property_declaration = 327,
  sym__local_typealias_declaration = 328,
  sym__local_function_declaration = 329,
  sym__local_class_declaration = 330,
  sym_import_declaration = 331,
  sym__import_kind = 332,
  sym_protocol_property_declaration = 333,
  sym_protocol_property_requirements = 334,
  sym_property_declaration = 335,
  sym__modifierless_property_declaration = 336,
  sym__single_modifierless_property_declaration = 337,
  sym_typealias_declaration = 338,
  sym__modifierless_typealias_declaration = 339,
  sym_function_declaration = 340,
  sym__modifierless_function_declaration = 341,
  sym__bodyless_function_declaration = 342,
  sym__modifierless_function_declaration_no_body = 343,
  sym_function_body = 344,
  sym_class_declaration = 345,
  sym__modifierless_class_declaration = 346,
  sym_class_body = 347,
  sym__inheritance_specifiers = 348,
  sym_inheritance_specifier = 349,
  sym__annotated_inheritance_specifier = 350,
  sym_type_parameters = 351,
  sym_type_parameter = 352,
  sym_type_constraints = 353,
  sym_type_constraint = 354,
  sym_inheritance_constraint = 355,
  sym_equality_constraint = 356,
  sym__class_member_separator = 357,
  sym__class_member_declarations = 358,
  sym__function_value_parameters = 359,
  sym__function_value_parameter = 360,
  sym_parameter = 361,
  sym__constructor_function_decl = 362,
  sym__non_constructor_function_decl = 363,
  sym__referenceable_operator = 364,
  sym__equal_sign = 365,
  sym__eq_eq = 366,
  sym__dot = 367,
  sym__arrow_operator = 368,
  sym__three_dot_operator = 369,
  sym__open_ended_range_operator = 370,
  sym__conjunction_operator = 371,
  sym__disjunction_operator = 372,
  sym__nil_coalescing_operator = 373,
  sym__as = 374,
  sym__as_quest = 375,
  sym__as_bang = 376,
  sym__async_keyword = 377,
  sym__async_modifier = 378,
  sym_throws = 379,
  sym_enum_class_body = 380,
  sym_enum_entry = 381,
  sym__enum_entry_suffix = 382,
  sym_enum_type_parameters = 383,
  sym_protocol_declaration = 384,
  sym_protocol_body = 385,
  sym__protocol_member_declarations = 386,
  sym__protocol_member_declaration = 387,
  sym_deinit_declaration = 388,
  sym_subscript_declaration = 389,
  sym_computed_property = 390,
  sym_computed_getter = 391,
  sym_computed_modify = 392,
  sym_computed_setter = 393,
  sym_getter_specifier = 394,
  sym_setter_specifier = 395,
  sym_modify_specifier = 396,
  aux_sym__getter_effects = 397,
  sym_operator_declaration = 398,
  sym_precedence_group_declaration = 399,
  sym_precedence_group_attributes = 400,
  sym_precedence_group_attribute = 401,
  sym_associatedtype_declaration = 402,
  sym_attribute = 403,
  sym__attribute_argument = 404,
  sym__universally_allowed_pattern = 405,
  sym__bound_identifier = 406,
  sym__binding_pattern_no_expr = 407,
  sym__no_expr_pattern_already_bound = 408,
  sym__binding_pattern_with_expr = 409,
  sym__direct_or_indirect_binding = 410,
  sym__binding_pattern_kind = 411,
  sym__possibly_async_binding_pattern_kind = 412,
  sym__binding_kind_and_pattern = 413,
  sym__tuple_pattern_item = 414,
  sym__tuple_pattern = 415,
  sym__case_pattern = 416,
  sym__type_casting_pattern = 417,
  sym__binding_pattern = 418,
  sym_modifiers = 419,
  aux_sym__locally_permitted_modifiers = 420,
  sym_parameter_modifiers = 421,
  sym__non_local_scope_modifier = 422,
  sym__locally_permitted_modifier = 423,
  sym_type_modifiers = 424,
  sym_member_modifier = 425,
  sym_visibility_modifier = 426,
  sym_type_parameter_modifiers = 427,
  sym_function_modifier = 428,
  sym_mutation_modifier = 429,
  sym_property_modifier = 430,
  sym_inheritance_modifier = 431,
  sym_parameter_modifier = 432,
  sym_ownership_modifier = 433,
  aux_sym_source_file_repeat1 = 434,
  aux_sym_identifier_repeat1 = 435,
  aux_sym_line_string_literal_repeat1 = 436,
  aux_sym_multi_line_string_literal_repeat1 = 437,
  aux_sym_raw_string_literal_repeat1 = 438,
  aux_sym__interpolation_contents_repeat1 = 439,
  aux_sym_user_type_repeat1 = 440,
  aux_sym_tuple_type_repeat1 = 441,
  aux_sym_optional_type_repeat1 = 442,
  aux_sym_protocol_composition_type_repeat1 = 443,
  aux_sym_call_suffix_repeat1 = 444,
  aux_sym__constructor_value_arguments_repeat1 = 445,
  aux_sym_type_arguments_repeat1 = 446,
  aux_sym_value_argument_repeat1 = 447,
  aux_sym_tuple_expression_repeat1 = 448,
  aux_sym_array_literal_repeat1 = 449,
  aux_sym_dictionary_literal_repeat1 = 450,
  aux_sym__playground_literal_repeat1 = 451,
  aux_sym__lambda_type_declaration_repeat1 = 452,
  aux_sym_capture_list_repeat1 = 453,
  aux_sym_lambda_function_type_parameters_repeat1 = 454,
  aux_sym_if_statement_repeat1 = 455,
  aux_sym_switch_statement_repeat1 = 456,
  aux_sym_switch_entry_repeat1 = 457,
  aux_sym_do_statement_repeat1 = 458,
  aux_sym_key_path_expression_repeat1 = 459,
  aux_sym__key_path_component_repeat1 = 460,
  aux_sym_statements_repeat1 = 461,
  aux_sym_availability_condition_repeat1 = 462,
  aux_sym__availability_argument_repeat1 = 463,
  aux_sym_protocol_property_requirements_repeat1 = 464,
  aux_sym__modifierless_property_declaration_repeat1 = 465,
  aux_sym__inheritance_specifiers_repeat1 = 466,
  aux_sym_type_parameters_repeat1 = 467,
  aux_sym_type_constraints_repeat1 = 468,
  aux_sym__class_member_declarations_repeat1 = 469,
  aux_sym__function_value_parameters_repeat1 = 470,
  aux_sym_enum_class_body_repeat1 = 471,
  aux_sym_enum_entry_repeat1 = 472,
  aux_sym_enum_type_parameters_repeat1 = 473,
  aux_sym__protocol_member_declarations_repeat1 = 474,
  aux_sym_computed_property_repeat1 = 475,
  aux_sym_precedence_group_attributes_repeat1 = 476,
  aux_sym_attribute_repeat1 = 477,
  aux_sym__attribute_argument_repeat1 = 478,
  aux_sym__attribute_argument_repeat2 = 479,
  aux_sym__tuple_pattern_repeat1 = 480,
  aux_sym_modifiers_repeat1 = 481,
  aux_sym_parameter_modifiers_repeat1 = 482,
  alias_sym_fully_open_range = 483,
  alias_sym_interpolated_expression = 484,
  alias_sym_protocol_function_declaration = 485,
  alias_sym_type_identifier = 486,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_shebang_line_token1] = "shebang_line_token1",
  [sym_comment] = "comment",
  [aux_sym_simple_identifier_token1] = "simple_identifier_token1",
  [aux_sym_simple_identifier_token2] = "simple_identifier_token2",
  [aux_sym_simple_identifier_token3] = "simple_identifier_token3",
  [aux_sym_simple_identifier_token4] = "simple_identifier_token4",
  [anon_sym_nil] = "nil",
  [sym_real_literal] = "real_literal",
  [sym_integer_literal] = "integer_literal",
  [sym_hex_literal] = "hex_literal",
  [sym_oct_literal] = "oct_literal",
  [sym_bin_literal] = "bin_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_line_str_text_token1] = "line_str_text_token1",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_u] = "u",
  [aux_sym__uni_character_literal_token1] = "_uni_character_literal_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_RPAREN] = ")",
  [sym_raw_str_interpolation_start] = "raw_str_interpolation_start",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_COMMA] = ",",
  [sym__escaped_identifier] = "_escaped_identifier",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_Type] = "Type",
  [anon_sym_Protocol] = "Protocol",
  [anon_sym_QMARK] = "\?",
  [sym__immediate_quest] = "\?",
  [anon_sym_some] = "some",
  [anon_sym_any] = "any",
  [anon_sym_AMP] = "&",
  [anon_sym_async] = "async",
  [anon_sym_POUNDselector] = "#selector",
  [anon_sym_getter_COLON] = "getter:",
  [anon_sym_setter_COLON] = "setter:",
  [aux_sym_custom_operator_token1] = "custom_operator_token1",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym__await_operator] = "_await_operator",
  [anon_sym_POUNDfile] = "#file",
  [anon_sym_POUNDfileID] = "#fileID",
  [anon_sym_POUNDfilePath] = "#filePath",
  [anon_sym_POUNDline] = "#line",
  [anon_sym_POUNDcolumn] = "#column",
  [anon_sym_POUNDfunction] = "#function",
  [anon_sym_POUNDdsohandle] = "#dsohandle",
  [anon_sym_POUNDcolorLiteral] = "#colorLiteral",
  [anon_sym_POUNDfileLiteral] = "#fileLiteral",
  [anon_sym_POUNDimageLiteral] = "#imageLiteral",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_in] = "in",
  [anon_sym_self] = "self",
  [anon_sym_super] = "super",
  [anon_sym_if] = "if",
  [anon_sym_guard] = "guard",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_do] = "do",
  [anon_sym_POUNDkeyPath] = "#keyPath",
  [anon_sym_try] = "try",
  [anon_sym_try_BANG] = "try!",
  [anon_sym_try_QMARK] = "try\?",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_is] = "is",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_TILDE] = "~",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [sym_statement_label] = "statement_label",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [sym_throw_keyword] = "throw_keyword",
  [anon_sym_return] = "return",
  [anon_sym_continue] = "continue",
  [anon_sym_break] = "break",
  [anon_sym_yield] = "yield",
  [anon_sym_POUNDavailable] = "#available",
  [anon_sym_import] = "import",
  [anon_sym_typealias] = "typealias",
  [anon_sym_struct] = "struct",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_protocol] = "protocol",
  [anon_sym_let] = "let",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_actor] = "actor",
  [anon_sym_extension] = "extension",
  [anon_sym_indirect] = "indirect",
  [anon_sym_init] = "init",
  [anon_sym_SEMI] = ";",
  [anon_sym_deinit] = "deinit",
  [anon_sym_subscript] = "subscript",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym__modify] = "_modify",
  [anon_sym_prefix] = "prefix",
  [anon_sym_infix] = "infix",
  [anon_sym_postfix] = "postfix",
  [anon_sym_operator] = "operator",
  [anon_sym_precedencegroup] = "precedencegroup",
  [anon_sym_associatedtype] = "associatedtype",
  [anon_sym_AT] = "@",
  [sym_wildcard_pattern] = "wildcard_pattern",
  [sym_property_behavior_modifier] = "property_behavior_modifier",
  [anon_sym_override] = "override",
  [anon_sym_convenience] = "convenience",
  [anon_sym_required] = "required",
  [anon_sym_nonisolated] = "nonisolated",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_internal] = "internal",
  [anon_sym_fileprivate] = "fileprivate",
  [anon_sym_open] = "open",
  [anon_sym_mutating] = "mutating",
  [anon_sym_nonmutating] = "nonmutating",
  [anon_sym_static] = "static",
  [anon_sym_dynamic] = "dynamic",
  [anon_sym_optional] = "optional",
  [anon_sym_final] = "final",
  [anon_sym_inout] = "inout",
  [anon_sym_ATescaping] = "@escaping",
  [anon_sym_ATautoclosure] = "@autoclosure",
  [anon_sym_weak] = "weak",
  [anon_sym_unowned] = "unowned",
  [anon_sym_unowned_LPARENsafe_RPAREN] = "unowned(safe)",
  [anon_sym_unowned_LPARENunsafe_RPAREN] = "unowned(unsafe)",
  [anon_sym_property] = "property",
  [anon_sym_receiver] = "receiver",
  [anon_sym_param] = "param",
  [anon_sym_setparam] = "setparam",
  [anon_sym_delegate] = "delegate",
  [sym_directive] = "directive",
  [sym_diagnostic] = "diagnostic",
  [sym_multiline_comment] = "multiline_comment",
  [sym_raw_str_part] = "raw_str_part",
  [sym_raw_str_continuing_indicator] = "raw_str_continuing_indicator",
  [sym_raw_str_end_part] = "raw_str_end_part",
  [sym__semi] = "_semi",
  [sym__arrow_operator_custom] = "->",
  [sym__dot_custom] = ".",
  [sym__three_dot_operator_custom] = "...",
  [sym__open_ended_range_operator_custom] = "..<",
  [sym__conjunction_operator_custom] = "&&",
  [sym__disjunction_operator_custom] = "||",
  [sym__nil_coalescing_operator_custom] = "\?\?",
  [sym__eq_custom] = "=",
  [sym__eq_eq_custom] = "==",
  [sym__plus_then_ws] = "+",
  [sym__minus_then_ws] = "-",
  [sym_bang] = "bang",
  [sym__throws_keyword] = "_throws_keyword",
  [sym__rethrows_keyword] = "_rethrows_keyword",
  [sym_default_keyword] = "default_keyword",
  [sym_where_keyword] = "where_keyword",
  [sym_else] = "else",
  [sym_catch_keyword] = "catch_keyword",
  [sym__as_custom] = "as",
  [sym__as_quest_custom] = "as\?",
  [sym__as_bang_custom] = "as!",
  [sym__async_keyword_custom] = "async",
  [sym_source_file] = "source_file",
  [sym_shebang_line] = "shebang_line",
  [sym_simple_identifier] = "simple_identifier",
  [sym_identifier] = "identifier",
  [sym__basic_literal] = "_basic_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__string_literal] = "_string_literal",
  [sym_line_string_literal] = "line_string_literal",
  [sym__line_string_content] = "_line_string_content",
  [sym_line_str_text] = "line_str_text",
  [sym_str_escaped_char] = "str_escaped_char",
  [sym__uni_character_literal] = "_uni_character_literal",
  [sym_multi_line_string_literal] = "multi_line_string_literal",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_raw_str_interpolation] = "raw_str_interpolation",
  [sym__multi_line_string_content] = "_multi_line_string_content",
  [sym__interpolation] = "_interpolation",
  [sym__interpolation_contents] = "_interpolation_contents",
  [sym_multi_line_str_text] = "multi_line_str_text",
  [sym_type_annotation] = "type_annotation",
  [sym__possibly_implicitly_unwrapped_type] = "_possibly_implicitly_unwrapped_type",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_user_type] = "user_type",
  [sym__simple_user_type] = "_simple_user_type",
  [sym_tuple_type] = "tuple_type",
  [sym_tuple_type_item] = "tuple_type_item",
  [sym__tuple_type_item_identifier] = "_tuple_type_item_identifier",
  [sym_function_type] = "function_type",
  [sym_array_type] = "array_type",
  [sym_dictionary_type] = "dictionary_type",
  [sym_optional_type] = "optional_type",
  [sym_metatype] = "metatype",
  [sym__quest] = "_quest",
  [sym_opaque_type] = "opaque_type",
  [sym_existential_type] = "existential_type",
  [sym_protocol_composition_type] = "protocol_composition_type",
  [sym__expression] = "_expression",
  [sym__unary_expression] = "_unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_constructor_expression] = "constructor_expression",
  [sym_navigation_expression] = "navigation_expression",
  [sym__navigable_type_expression] = "_navigable_type_expression",
  [sym_open_start_range_expression] = "open_start_range_expression",
  [sym__range_operator] = "_range_operator",
  [sym_open_end_range_expression] = "open_end_range_expression",
  [sym_prefix_expression] = "prefix_expression",
  [sym_as_expression] = "as_expression",
  [sym_selector_expression] = "selector_expression",
  [sym__binary_expression] = "_binary_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_range_expression] = "range_expression",
  [sym_infix_expression] = "infix_expression",
  [sym_nil_coalescing_expression] = "nil_coalescing_expression",
  [sym_check_expression] = "check_expression",
  [sym_comparison_expression] = "comparison_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_conjunction_expression] = "conjunction_expression",
  [sym_disjunction_expression] = "disjunction_expression",
  [sym_bitwise_operation] = "bitwise_operation",
  [sym_custom_operator] = "custom_operator",
  [sym_navigation_suffix] = "navigation_suffix",
  [sym_call_suffix] = "call_suffix",
  [sym_constructor_suffix] = "constructor_suffix",
  [sym__constructor_value_arguments] = "value_arguments",
  [sym_type_arguments] = "type_arguments",
  [sym_value_arguments] = "value_arguments",
  [sym_value_argument] = "value_argument",
  [sym_try_expression] = "try_expression",
  [sym_await_expression] = "await_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym__expr_hack_at_ternary_binary_suffix] = "_expr_hack_at_ternary_binary_suffix",
  [sym_expr_hack_at_ternary_binary_call] = "call_expression",
  [sym_expr_hack_at_ternary_binary_call_suffix] = "call_suffix",
  [sym_call_expression] = "call_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_array_literal] = "array_literal",
  [sym_dictionary_literal] = "dictionary_literal",
  [sym__dictionary_literal_item] = "_dictionary_literal_item",
  [sym__special_literal] = "_special_literal",
  [sym__playground_literal] = "_playground_literal",
  [sym_lambda_literal] = "lambda_literal",
  [sym__lambda_type_declaration] = "_lambda_type_declaration",
  [sym_capture_list] = "capture_list",
  [sym_capture_list_item] = "capture_list_item",
  [sym_lambda_function_type] = "lambda_function_type",
  [sym_lambda_function_type_parameters] = "lambda_function_type_parameters",
  [sym_lambda_parameter] = "lambda_parameter",
  [sym_self_expression] = "self_expression",
  [sym_super_expression] = "super_expression",
  [sym__else_options] = "_else_options",
  [sym_if_statement] = "if_statement",
  [sym__if_condition_sequence_item] = "_if_condition_sequence_item",
  [sym__if_let_binding] = "_if_let_binding",
  [sym_guard_statement] = "guard_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_entry] = "switch_entry",
  [sym_switch_pattern] = "switch_pattern",
  [sym_do_statement] = "do_statement",
  [sym_catch_block] = "catch_block",
  [sym_where_clause] = "where_clause",
  [sym_key_path_expression] = "key_path_expression",
  [sym_key_path_string_expression] = "key_path_string_expression",
  [sym__key_path_component] = "_key_path_component",
  [sym__key_path_postfixes] = "_key_path_postfixes",
  [sym__try_operator] = "_try_operator",
  [sym__assignment_and_operator] = "_assignment_and_operator",
  [sym__equality_operator] = "_equality_operator",
  [sym__comparison_operator] = "_comparison_operator",
  [sym__is_operator] = "_is_operator",
  [sym__additive_operator] = "_additive_operator",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym_as_operator] = "as_operator",
  [sym__prefix_unary_operator] = "_prefix_unary_operator",
  [sym__bitwise_binary_operator] = "_bitwise_binary_operator",
  [sym__postfix_unary_operator] = "_postfix_unary_operator",
  [sym_directly_assignable_expression] = "directly_assignable_expression",
  [sym_statements] = "statements",
  [sym__local_statement] = "_local_statement",
  [sym__top_level_statement] = "_top_level_statement",
  [sym__block] = "_block",
  [sym__labeled_statement] = "_labeled_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_while_statement] = "repeat_while_statement",
  [sym_control_transfer_statement] = "control_transfer_statement",
  [sym__throw_statement] = "_throw_statement",
  [sym__optionally_valueful_control_keyword] = "_optionally_valueful_control_keyword",
  [sym_assignment] = "assignment",
  [sym_availability_condition] = "availability_condition",
  [sym__availability_argument] = "_availability_argument",
  [sym__global_declaration] = "_global_declaration",
  [sym__type_level_declaration] = "_type_level_declaration",
  [sym__local_declaration] = "_local_declaration",
  [sym__local_property_declaration] = "property_declaration",
  [sym__local_typealias_declaration] = "typealias_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__local_class_declaration] = "class_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym__import_kind] = "_import_kind",
  [sym_protocol_property_declaration] = "protocol_property_declaration",
  [sym_protocol_property_requirements] = "protocol_property_requirements",
  [sym_property_declaration] = "property_declaration",
  [sym__modifierless_property_declaration] = "_modifierless_property_declaration",
  [sym__single_modifierless_property_declaration] = "_single_modifierless_property_declaration",
  [sym_typealias_declaration] = "typealias_declaration",
  [sym__modifierless_typealias_declaration] = "_modifierless_typealias_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__modifierless_function_declaration] = "_modifierless_function_declaration",
  [sym__bodyless_function_declaration] = "_bodyless_function_declaration",
  [sym__modifierless_function_declaration_no_body] = "_modifierless_function_declaration_no_body",
  [sym_function_body] = "function_body",
  [sym_class_declaration] = "class_declaration",
  [sym__modifierless_class_declaration] = "_modifierless_class_declaration",
  [sym_class_body] = "class_body",
  [sym__inheritance_specifiers] = "_inheritance_specifiers",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym__annotated_inheritance_specifier] = "_annotated_inheritance_specifier",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_constraints] = "type_constraints",
  [sym_type_constraint] = "type_constraint",
  [sym_inheritance_constraint] = "inheritance_constraint",
  [sym_equality_constraint] = "equality_constraint",
  [sym__class_member_separator] = "_class_member_separator",
  [sym__class_member_declarations] = "_class_member_declarations",
  [sym__function_value_parameters] = "_function_value_parameters",
  [sym__function_value_parameter] = "_function_value_parameter",
  [sym_parameter] = "parameter",
  [sym__constructor_function_decl] = "_constructor_function_decl",
  [sym__non_constructor_function_decl] = "_non_constructor_function_decl",
  [sym__referenceable_operator] = "_referenceable_operator",
  [sym__equal_sign] = "_equal_sign",
  [sym__eq_eq] = "_eq_eq",
  [sym__dot] = "_dot",
  [sym__arrow_operator] = "_arrow_operator",
  [sym__three_dot_operator] = "_three_dot_operator",
  [sym__open_ended_range_operator] = "_open_ended_range_operator",
  [sym__conjunction_operator] = "_conjunction_operator",
  [sym__disjunction_operator] = "_disjunction_operator",
  [sym__nil_coalescing_operator] = "_nil_coalescing_operator",
  [sym__as] = "_as",
  [sym__as_quest] = "_as_quest",
  [sym__as_bang] = "_as_bang",
  [sym__async_keyword] = "_async_keyword",
  [sym__async_modifier] = "_async_modifier",
  [sym_throws] = "throws",
  [sym_enum_class_body] = "enum_class_body",
  [sym_enum_entry] = "enum_entry",
  [sym__enum_entry_suffix] = "_enum_entry_suffix",
  [sym_enum_type_parameters] = "enum_type_parameters",
  [sym_protocol_declaration] = "protocol_declaration",
  [sym_protocol_body] = "protocol_body",
  [sym__protocol_member_declarations] = "_protocol_member_declarations",
  [sym__protocol_member_declaration] = "_protocol_member_declaration",
  [sym_deinit_declaration] = "deinit_declaration",
  [sym_subscript_declaration] = "subscript_declaration",
  [sym_computed_property] = "computed_property",
  [sym_computed_getter] = "computed_getter",
  [sym_computed_modify] = "computed_modify",
  [sym_computed_setter] = "computed_setter",
  [sym_getter_specifier] = "getter_specifier",
  [sym_setter_specifier] = "setter_specifier",
  [sym_modify_specifier] = "modify_specifier",
  [aux_sym__getter_effects] = "_getter_effects",
  [sym_operator_declaration] = "operator_declaration",
  [sym_precedence_group_declaration] = "precedence_group_declaration",
  [sym_precedence_group_attributes] = "precedence_group_attributes",
  [sym_precedence_group_attribute] = "precedence_group_attribute",
  [sym_associatedtype_declaration] = "associatedtype_declaration",
  [sym_attribute] = "attribute",
  [sym__attribute_argument] = "_attribute_argument",
  [sym__universally_allowed_pattern] = "_universally_allowed_pattern",
  [sym__bound_identifier] = "_bound_identifier",
  [sym__binding_pattern_no_expr] = "_binding_pattern_no_expr",
  [sym__no_expr_pattern_already_bound] = "_no_expr_pattern_already_bound",
  [sym__binding_pattern_with_expr] = "pattern",
  [sym__direct_or_indirect_binding] = "_direct_or_indirect_binding",
  [sym__binding_pattern_kind] = "_binding_pattern_kind",
  [sym__possibly_async_binding_pattern_kind] = "_possibly_async_binding_pattern_kind",
  [sym__binding_kind_and_pattern] = "_binding_kind_and_pattern",
  [sym__tuple_pattern_item] = "_tuple_pattern_item",
  [sym__tuple_pattern] = "_tuple_pattern",
  [sym__case_pattern] = "_case_pattern",
  [sym__type_casting_pattern] = "_type_casting_pattern",
  [sym__binding_pattern] = "_binding_pattern",
  [sym_modifiers] = "modifiers",
  [aux_sym__locally_permitted_modifiers] = "_locally_permitted_modifiers",
  [sym_parameter_modifiers] = "parameter_modifiers",
  [sym__non_local_scope_modifier] = "_non_local_scope_modifier",
  [sym__locally_permitted_modifier] = "_locally_permitted_modifier",
  [sym_type_modifiers] = "type_modifiers",
  [sym_member_modifier] = "member_modifier",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_type_parameter_modifiers] = "type_parameter_modifiers",
  [sym_function_modifier] = "function_modifier",
  [sym_mutation_modifier] = "mutation_modifier",
  [sym_property_modifier] = "property_modifier",
  [sym_inheritance_modifier] = "inheritance_modifier",
  [sym_parameter_modifier] = "parameter_modifier",
  [sym_ownership_modifier] = "ownership_modifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_line_string_literal_repeat1] = "line_string_literal_repeat1",
  [aux_sym_multi_line_string_literal_repeat1] = "multi_line_string_literal_repeat1",
  [aux_sym_raw_string_literal_repeat1] = "raw_string_literal_repeat1",
  [aux_sym__interpolation_contents_repeat1] = "_interpolation_contents_repeat1",
  [aux_sym_user_type_repeat1] = "user_type_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_optional_type_repeat1] = "optional_type_repeat1",
  [aux_sym_protocol_composition_type_repeat1] = "protocol_composition_type_repeat1",
  [aux_sym_call_suffix_repeat1] = "call_suffix_repeat1",
  [aux_sym__constructor_value_arguments_repeat1] = "_constructor_value_arguments_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_value_argument_repeat1] = "value_argument_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_array_literal_repeat1] = "array_literal_repeat1",
  [aux_sym_dictionary_literal_repeat1] = "dictionary_literal_repeat1",
  [aux_sym__playground_literal_repeat1] = "_playground_literal_repeat1",
  [aux_sym__lambda_type_declaration_repeat1] = "_lambda_type_declaration_repeat1",
  [aux_sym_capture_list_repeat1] = "capture_list_repeat1",
  [aux_sym_lambda_function_type_parameters_repeat1] = "lambda_function_type_parameters_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_switch_entry_repeat1] = "switch_entry_repeat1",
  [aux_sym_do_statement_repeat1] = "do_statement_repeat1",
  [aux_sym_key_path_expression_repeat1] = "key_path_expression_repeat1",
  [aux_sym__key_path_component_repeat1] = "_key_path_component_repeat1",
  [aux_sym_statements_repeat1] = "statements_repeat1",
  [aux_sym_availability_condition_repeat1] = "availability_condition_repeat1",
  [aux_sym__availability_argument_repeat1] = "_availability_argument_repeat1",
  [aux_sym_protocol_property_requirements_repeat1] = "protocol_property_requirements_repeat1",
  [aux_sym__modifierless_property_declaration_repeat1] = "_modifierless_property_declaration_repeat1",
  [aux_sym__inheritance_specifiers_repeat1] = "_inheritance_specifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_constraints_repeat1] = "type_constraints_repeat1",
  [aux_sym__class_member_declarations_repeat1] = "_class_member_declarations_repeat1",
  [aux_sym__function_value_parameters_repeat1] = "_function_value_parameters_repeat1",
  [aux_sym_enum_class_body_repeat1] = "enum_class_body_repeat1",
  [aux_sym_enum_entry_repeat1] = "enum_entry_repeat1",
  [aux_sym_enum_type_parameters_repeat1] = "enum_type_parameters_repeat1",
  [aux_sym__protocol_member_declarations_repeat1] = "_protocol_member_declarations_repeat1",
  [aux_sym_computed_property_repeat1] = "computed_property_repeat1",
  [aux_sym_precedence_group_attributes_repeat1] = "precedence_group_attributes_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym__attribute_argument_repeat1] = "_attribute_argument_repeat1",
  [aux_sym__attribute_argument_repeat2] = "_attribute_argument_repeat2",
  [aux_sym__tuple_pattern_repeat1] = "_tuple_pattern_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_parameter_modifiers_repeat1] = "parameter_modifiers_repeat1",
  [alias_sym_fully_open_range] = "fully_open_range",
  [alias_sym_interpolated_expression] = "interpolated_expression",
  [alias_sym_protocol_function_declaration] = "protocol_function_declaration",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_shebang_line_token1] = aux_sym_shebang_line_token1,
  [sym_comment] = sym_comment,
  [aux_sym_simple_identifier_token1] = aux_sym_simple_identifier_token1,
  [aux_sym_simple_identifier_token2] = aux_sym_simple_identifier_token2,
  [aux_sym_simple_identifier_token3] = aux_sym_simple_identifier_token3,
  [aux_sym_simple_identifier_token4] = aux_sym_simple_identifier_token4,
  [anon_sym_nil] = anon_sym_nil,
  [sym_real_literal] = sym_real_literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym_hex_literal] = sym_hex_literal,
  [sym_oct_literal] = sym_oct_literal,
  [sym_bin_literal] = sym_bin_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_line_str_text_token1] = aux_sym_line_str_text_token1,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_u] = anon_sym_u,
  [aux_sym__uni_character_literal_token1] = aux_sym__uni_character_literal_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_raw_str_interpolation_start] = sym_raw_str_interpolation_start,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym__escaped_identifier] = sym__escaped_identifier,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_Type] = anon_sym_Type,
  [anon_sym_Protocol] = anon_sym_Protocol,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym__immediate_quest] = anon_sym_QMARK,
  [anon_sym_some] = anon_sym_some,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_POUNDselector] = anon_sym_POUNDselector,
  [anon_sym_getter_COLON] = anon_sym_getter_COLON,
  [anon_sym_setter_COLON] = anon_sym_setter_COLON,
  [aux_sym_custom_operator_token1] = aux_sym_custom_operator_token1,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym__await_operator] = sym__await_operator,
  [anon_sym_POUNDfile] = anon_sym_POUNDfile,
  [anon_sym_POUNDfileID] = anon_sym_POUNDfileID,
  [anon_sym_POUNDfilePath] = anon_sym_POUNDfilePath,
  [anon_sym_POUNDline] = anon_sym_POUNDline,
  [anon_sym_POUNDcolumn] = anon_sym_POUNDcolumn,
  [anon_sym_POUNDfunction] = anon_sym_POUNDfunction,
  [anon_sym_POUNDdsohandle] = anon_sym_POUNDdsohandle,
  [anon_sym_POUNDcolorLiteral] = anon_sym_POUNDcolorLiteral,
  [anon_sym_POUNDfileLiteral] = anon_sym_POUNDfileLiteral,
  [anon_sym_POUNDimageLiteral] = anon_sym_POUNDimageLiteral,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_self] = anon_sym_self,
  [anon_sym_super] = anon_sym_super,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_guard] = anon_sym_guard,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_POUNDkeyPath] = anon_sym_POUNDkeyPath,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_try_BANG] = anon_sym_try_BANG,
  [anon_sym_try_QMARK] = anon_sym_try_QMARK,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [sym_statement_label] = sym_statement_label,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [sym_throw_keyword] = sym_throw_keyword,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_POUNDavailable] = anon_sym_POUNDavailable,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_typealias] = anon_sym_typealias,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_protocol] = anon_sym_protocol,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_actor] = anon_sym_actor,
  [anon_sym_extension] = anon_sym_extension,
  [anon_sym_indirect] = anon_sym_indirect,
  [anon_sym_init] = anon_sym_init,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_deinit] = anon_sym_deinit,
  [anon_sym_subscript] = anon_sym_subscript,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym__modify] = anon_sym__modify,
  [anon_sym_prefix] = anon_sym_prefix,
  [anon_sym_infix] = anon_sym_infix,
  [anon_sym_postfix] = anon_sym_postfix,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_precedencegroup] = anon_sym_precedencegroup,
  [anon_sym_associatedtype] = anon_sym_associatedtype,
  [anon_sym_AT] = anon_sym_AT,
  [sym_wildcard_pattern] = sym_wildcard_pattern,
  [sym_property_behavior_modifier] = sym_property_behavior_modifier,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_convenience] = anon_sym_convenience,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_nonisolated] = anon_sym_nonisolated,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_fileprivate] = anon_sym_fileprivate,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_mutating] = anon_sym_mutating,
  [anon_sym_nonmutating] = anon_sym_nonmutating,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_dynamic] = anon_sym_dynamic,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_inout] = anon_sym_inout,
  [anon_sym_ATescaping] = anon_sym_ATescaping,
  [anon_sym_ATautoclosure] = anon_sym_ATautoclosure,
  [anon_sym_weak] = anon_sym_weak,
  [anon_sym_unowned] = anon_sym_unowned,
  [anon_sym_unowned_LPARENsafe_RPAREN] = anon_sym_unowned_LPARENsafe_RPAREN,
  [anon_sym_unowned_LPARENunsafe_RPAREN] = anon_sym_unowned_LPARENunsafe_RPAREN,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_receiver] = anon_sym_receiver,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_setparam] = anon_sym_setparam,
  [anon_sym_delegate] = anon_sym_delegate,
  [sym_directive] = sym_directive,
  [sym_diagnostic] = sym_diagnostic,
  [sym_multiline_comment] = sym_multiline_comment,
  [sym_raw_str_part] = sym_raw_str_part,
  [sym_raw_str_continuing_indicator] = sym_raw_str_continuing_indicator,
  [sym_raw_str_end_part] = sym_raw_str_end_part,
  [sym__semi] = sym__semi,
  [sym__arrow_operator_custom] = sym__arrow_operator_custom,
  [sym__dot_custom] = anon_sym_DOT,
  [sym__three_dot_operator_custom] = sym__three_dot_operator_custom,
  [sym__open_ended_range_operator_custom] = sym__open_ended_range_operator_custom,
  [sym__conjunction_operator_custom] = sym__conjunction_operator_custom,
  [sym__disjunction_operator_custom] = sym__disjunction_operator_custom,
  [sym__nil_coalescing_operator_custom] = sym__nil_coalescing_operator_custom,
  [sym__eq_custom] = anon_sym_EQ,
  [sym__eq_eq_custom] = sym__eq_eq_custom,
  [sym__plus_then_ws] = anon_sym_PLUS,
  [sym__minus_then_ws] = anon_sym_DASH,
  [sym_bang] = sym_bang,
  [sym__throws_keyword] = sym__throws_keyword,
  [sym__rethrows_keyword] = sym__rethrows_keyword,
  [sym_default_keyword] = sym_default_keyword,
  [sym_where_keyword] = sym_where_keyword,
  [sym_else] = sym_else,
  [sym_catch_keyword] = sym_catch_keyword,
  [sym__as_custom] = sym__as_custom,
  [sym__as_quest_custom] = sym__as_quest_custom,
  [sym__as_bang_custom] = sym__as_bang_custom,
  [sym__async_keyword_custom] = anon_sym_async,
  [sym_source_file] = sym_source_file,
  [sym_shebang_line] = sym_shebang_line,
  [sym_simple_identifier] = sym_simple_identifier,
  [sym_identifier] = sym_identifier,
  [sym__basic_literal] = sym__basic_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__string_literal] = sym__string_literal,
  [sym_line_string_literal] = sym_line_string_literal,
  [sym__line_string_content] = sym__line_string_content,
  [sym_line_str_text] = sym_line_str_text,
  [sym_str_escaped_char] = sym_str_escaped_char,
  [sym__uni_character_literal] = sym__uni_character_literal,
  [sym_multi_line_string_literal] = sym_multi_line_string_literal,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_raw_str_interpolation] = sym_raw_str_interpolation,
  [sym__multi_line_string_content] = sym__multi_line_string_content,
  [sym__interpolation] = sym__interpolation,
  [sym__interpolation_contents] = sym__interpolation_contents,
  [sym_multi_line_str_text] = sym_multi_line_str_text,
  [sym_type_annotation] = sym_type_annotation,
  [sym__possibly_implicitly_unwrapped_type] = sym__possibly_implicitly_unwrapped_type,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_user_type] = sym_user_type,
  [sym__simple_user_type] = sym__simple_user_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_tuple_type_item] = sym_tuple_type_item,
  [sym__tuple_type_item_identifier] = sym__tuple_type_item_identifier,
  [sym_function_type] = sym_function_type,
  [sym_array_type] = sym_array_type,
  [sym_dictionary_type] = sym_dictionary_type,
  [sym_optional_type] = sym_optional_type,
  [sym_metatype] = sym_metatype,
  [sym__quest] = sym__quest,
  [sym_opaque_type] = sym_opaque_type,
  [sym_existential_type] = sym_existential_type,
  [sym_protocol_composition_type] = sym_protocol_composition_type,
  [sym__expression] = sym__expression,
  [sym__unary_expression] = sym__unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_constructor_expression] = sym_constructor_expression,
  [sym_navigation_expression] = sym_navigation_expression,
  [sym__navigable_type_expression] = sym__navigable_type_expression,
  [sym_open_start_range_expression] = sym_open_start_range_expression,
  [sym__range_operator] = sym__range_operator,
  [sym_open_end_range_expression] = sym_open_end_range_expression,
  [sym_prefix_expression] = sym_prefix_expression,
  [sym_as_expression] = sym_as_expression,
  [sym_selector_expression] = sym_selector_expression,
  [sym__binary_expression] = sym__binary_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_infix_expression] = sym_infix_expression,
  [sym_nil_coalescing_expression] = sym_nil_coalescing_expression,
  [sym_check_expression] = sym_check_expression,
  [sym_comparison_expression] = sym_comparison_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_conjunction_expression] = sym_conjunction_expression,
  [sym_disjunction_expression] = sym_disjunction_expression,
  [sym_bitwise_operation] = sym_bitwise_operation,
  [sym_custom_operator] = sym_custom_operator,
  [sym_navigation_suffix] = sym_navigation_suffix,
  [sym_call_suffix] = sym_call_suffix,
  [sym_constructor_suffix] = sym_constructor_suffix,
  [sym__constructor_value_arguments] = sym_value_arguments,
  [sym_type_arguments] = sym_type_arguments,
  [sym_value_arguments] = sym_value_arguments,
  [sym_value_argument] = sym_value_argument,
  [sym_try_expression] = sym_try_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym__expr_hack_at_ternary_binary_suffix] = sym__expr_hack_at_ternary_binary_suffix,
  [sym_expr_hack_at_ternary_binary_call] = sym_call_expression,
  [sym_expr_hack_at_ternary_binary_call_suffix] = sym_call_suffix,
  [sym_call_expression] = sym_call_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_array_literal] = sym_array_literal,
  [sym_dictionary_literal] = sym_dictionary_literal,
  [sym__dictionary_literal_item] = sym__dictionary_literal_item,
  [sym__special_literal] = sym__special_literal,
  [sym__playground_literal] = sym__playground_literal,
  [sym_lambda_literal] = sym_lambda_literal,
  [sym__lambda_type_declaration] = sym__lambda_type_declaration,
  [sym_capture_list] = sym_capture_list,
  [sym_capture_list_item] = sym_capture_list_item,
  [sym_lambda_function_type] = sym_lambda_function_type,
  [sym_lambda_function_type_parameters] = sym_lambda_function_type_parameters,
  [sym_lambda_parameter] = sym_lambda_parameter,
  [sym_self_expression] = sym_self_expression,
  [sym_super_expression] = sym_super_expression,
  [sym__else_options] = sym__else_options,
  [sym_if_statement] = sym_if_statement,
  [sym__if_condition_sequence_item] = sym__if_condition_sequence_item,
  [sym__if_let_binding] = sym__if_let_binding,
  [sym_guard_statement] = sym_guard_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_entry] = sym_switch_entry,
  [sym_switch_pattern] = sym_switch_pattern,
  [sym_do_statement] = sym_do_statement,
  [sym_catch_block] = sym_catch_block,
  [sym_where_clause] = sym_where_clause,
  [sym_key_path_expression] = sym_key_path_expression,
  [sym_key_path_string_expression] = sym_key_path_string_expression,
  [sym__key_path_component] = sym__key_path_component,
  [sym__key_path_postfixes] = sym__key_path_postfixes,
  [sym__try_operator] = sym__try_operator,
  [sym__assignment_and_operator] = sym__assignment_and_operator,
  [sym__equality_operator] = sym__equality_operator,
  [sym__comparison_operator] = sym__comparison_operator,
  [sym__is_operator] = sym__is_operator,
  [sym__additive_operator] = sym__additive_operator,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym_as_operator] = sym_as_operator,
  [sym__prefix_unary_operator] = sym__prefix_unary_operator,
  [sym__bitwise_binary_operator] = sym__bitwise_binary_operator,
  [sym__postfix_unary_operator] = sym__postfix_unary_operator,
  [sym_directly_assignable_expression] = sym_directly_assignable_expression,
  [sym_statements] = sym_statements,
  [sym__local_statement] = sym__local_statement,
  [sym__top_level_statement] = sym__top_level_statement,
  [sym__block] = sym__block,
  [sym__labeled_statement] = sym__labeled_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_while_statement] = sym_repeat_while_statement,
  [sym_control_transfer_statement] = sym_control_transfer_statement,
  [sym__throw_statement] = sym__throw_statement,
  [sym__optionally_valueful_control_keyword] = sym__optionally_valueful_control_keyword,
  [sym_assignment] = sym_assignment,
  [sym_availability_condition] = sym_availability_condition,
  [sym__availability_argument] = sym__availability_argument,
  [sym__global_declaration] = sym__global_declaration,
  [sym__type_level_declaration] = sym__type_level_declaration,
  [sym__local_declaration] = sym__local_declaration,
  [sym__local_property_declaration] = sym_property_declaration,
  [sym__local_typealias_declaration] = sym_typealias_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__local_class_declaration] = sym_class_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym__import_kind] = sym__import_kind,
  [sym_protocol_property_declaration] = sym_protocol_property_declaration,
  [sym_protocol_property_requirements] = sym_protocol_property_requirements,
  [sym_property_declaration] = sym_property_declaration,
  [sym__modifierless_property_declaration] = sym__modifierless_property_declaration,
  [sym__single_modifierless_property_declaration] = sym__single_modifierless_property_declaration,
  [sym_typealias_declaration] = sym_typealias_declaration,
  [sym__modifierless_typealias_declaration] = sym__modifierless_typealias_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__modifierless_function_declaration] = sym__modifierless_function_declaration,
  [sym__bodyless_function_declaration] = sym__bodyless_function_declaration,
  [sym__modifierless_function_declaration_no_body] = sym__modifierless_function_declaration_no_body,
  [sym_function_body] = sym_function_body,
  [sym_class_declaration] = sym_class_declaration,
  [sym__modifierless_class_declaration] = sym__modifierless_class_declaration,
  [sym_class_body] = sym_class_body,
  [sym__inheritance_specifiers] = sym__inheritance_specifiers,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym__annotated_inheritance_specifier] = sym__annotated_inheritance_specifier,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_constraints] = sym_type_constraints,
  [sym_type_constraint] = sym_type_constraint,
  [sym_inheritance_constraint] = sym_inheritance_constraint,
  [sym_equality_constraint] = sym_equality_constraint,
  [sym__class_member_separator] = sym__class_member_separator,
  [sym__class_member_declarations] = sym__class_member_declarations,
  [sym__function_value_parameters] = sym__function_value_parameters,
  [sym__function_value_parameter] = sym__function_value_parameter,
  [sym_parameter] = sym_parameter,
  [sym__constructor_function_decl] = sym__constructor_function_decl,
  [sym__non_constructor_function_decl] = sym__non_constructor_function_decl,
  [sym__referenceable_operator] = sym__referenceable_operator,
  [sym__equal_sign] = sym__equal_sign,
  [sym__eq_eq] = sym__eq_eq,
  [sym__dot] = sym__dot,
  [sym__arrow_operator] = sym__arrow_operator,
  [sym__three_dot_operator] = sym__three_dot_operator,
  [sym__open_ended_range_operator] = sym__open_ended_range_operator,
  [sym__conjunction_operator] = sym__conjunction_operator,
  [sym__disjunction_operator] = sym__disjunction_operator,
  [sym__nil_coalescing_operator] = sym__nil_coalescing_operator,
  [sym__as] = sym__as,
  [sym__as_quest] = sym__as_quest,
  [sym__as_bang] = sym__as_bang,
  [sym__async_keyword] = sym__async_keyword,
  [sym__async_modifier] = sym__async_modifier,
  [sym_throws] = sym_throws,
  [sym_enum_class_body] = sym_enum_class_body,
  [sym_enum_entry] = sym_enum_entry,
  [sym__enum_entry_suffix] = sym__enum_entry_suffix,
  [sym_enum_type_parameters] = sym_enum_type_parameters,
  [sym_protocol_declaration] = sym_protocol_declaration,
  [sym_protocol_body] = sym_protocol_body,
  [sym__protocol_member_declarations] = sym__protocol_member_declarations,
  [sym__protocol_member_declaration] = sym__protocol_member_declaration,
  [sym_deinit_declaration] = sym_deinit_declaration,
  [sym_subscript_declaration] = sym_subscript_declaration,
  [sym_computed_property] = sym_computed_property,
  [sym_computed_getter] = sym_computed_getter,
  [sym_computed_modify] = sym_computed_modify,
  [sym_computed_setter] = sym_computed_setter,
  [sym_getter_specifier] = sym_getter_specifier,
  [sym_setter_specifier] = sym_setter_specifier,
  [sym_modify_specifier] = sym_modify_specifier,
  [aux_sym__getter_effects] = aux_sym__getter_effects,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym_precedence_group_declaration] = sym_precedence_group_declaration,
  [sym_precedence_group_attributes] = sym_precedence_group_attributes,
  [sym_precedence_group_attribute] = sym_precedence_group_attribute,
  [sym_associatedtype_declaration] = sym_associatedtype_declaration,
  [sym_attribute] = sym_attribute,
  [sym__attribute_argument] = sym__attribute_argument,
  [sym__universally_allowed_pattern] = sym__universally_allowed_pattern,
  [sym__bound_identifier] = sym__bound_identifier,
  [sym__binding_pattern_no_expr] = sym__binding_pattern_no_expr,
  [sym__no_expr_pattern_already_bound] = sym__no_expr_pattern_already_bound,
  [sym__binding_pattern_with_expr] = sym__binding_pattern_with_expr,
  [sym__direct_or_indirect_binding] = sym__direct_or_indirect_binding,
  [sym__binding_pattern_kind] = sym__binding_pattern_kind,
  [sym__possibly_async_binding_pattern_kind] = sym__possibly_async_binding_pattern_kind,
  [sym__binding_kind_and_pattern] = sym__binding_kind_and_pattern,
  [sym__tuple_pattern_item] = sym__tuple_pattern_item,
  [sym__tuple_pattern] = sym__tuple_pattern,
  [sym__case_pattern] = sym__case_pattern,
  [sym__type_casting_pattern] = sym__type_casting_pattern,
  [sym__binding_pattern] = sym__binding_pattern,
  [sym_modifiers] = sym_modifiers,
  [aux_sym__locally_permitted_modifiers] = aux_sym__locally_permitted_modifiers,
  [sym_parameter_modifiers] = sym_parameter_modifiers,
  [sym__non_local_scope_modifier] = sym__non_local_scope_modifier,
  [sym__locally_permitted_modifier] = sym__locally_permitted_modifier,
  [sym_type_modifiers] = sym_type_modifiers,
  [sym_member_modifier] = sym_member_modifier,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_type_parameter_modifiers] = sym_type_parameter_modifiers,
  [sym_function_modifier] = sym_function_modifier,
  [sym_mutation_modifier] = sym_mutation_modifier,
  [sym_property_modifier] = sym_property_modifier,
  [sym_inheritance_modifier] = sym_inheritance_modifier,
  [sym_parameter_modifier] = sym_parameter_modifier,
  [sym_ownership_modifier] = sym_ownership_modifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_line_string_literal_repeat1] = aux_sym_line_string_literal_repeat1,
  [aux_sym_multi_line_string_literal_repeat1] = aux_sym_multi_line_string_literal_repeat1,
  [aux_sym_raw_string_literal_repeat1] = aux_sym_raw_string_literal_repeat1,
  [aux_sym__interpolation_contents_repeat1] = aux_sym__interpolation_contents_repeat1,
  [aux_sym_user_type_repeat1] = aux_sym_user_type_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_optional_type_repeat1] = aux_sym_optional_type_repeat1,
  [aux_sym_protocol_composition_type_repeat1] = aux_sym_protocol_composition_type_repeat1,
  [aux_sym_call_suffix_repeat1] = aux_sym_call_suffix_repeat1,
  [aux_sym__constructor_value_arguments_repeat1] = aux_sym__constructor_value_arguments_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_value_argument_repeat1] = aux_sym_value_argument_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_array_literal_repeat1] = aux_sym_array_literal_repeat1,
  [aux_sym_dictionary_literal_repeat1] = aux_sym_dictionary_literal_repeat1,
  [aux_sym__playground_literal_repeat1] = aux_sym__playground_literal_repeat1,
  [aux_sym__lambda_type_declaration_repeat1] = aux_sym__lambda_type_declaration_repeat1,
  [aux_sym_capture_list_repeat1] = aux_sym_capture_list_repeat1,
  [aux_sym_lambda_function_type_parameters_repeat1] = aux_sym_lambda_function_type_parameters_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_switch_entry_repeat1] = aux_sym_switch_entry_repeat1,
  [aux_sym_do_statement_repeat1] = aux_sym_do_statement_repeat1,
  [aux_sym_key_path_expression_repeat1] = aux_sym_key_path_expression_repeat1,
  [aux_sym__key_path_component_repeat1] = aux_sym__key_path_component_repeat1,
  [aux_sym_statements_repeat1] = aux_sym_statements_repeat1,
  [aux_sym_availability_condition_repeat1] = aux_sym_availability_condition_repeat1,
  [aux_sym__availability_argument_repeat1] = aux_sym__availability_argument_repeat1,
  [aux_sym_protocol_property_requirements_repeat1] = aux_sym_protocol_property_requirements_repeat1,
  [aux_sym__modifierless_property_declaration_repeat1] = aux_sym__modifierless_property_declaration_repeat1,
  [aux_sym__inheritance_specifiers_repeat1] = aux_sym__inheritance_specifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_constraints_repeat1] = aux_sym_type_constraints_repeat1,
  [aux_sym__class_member_declarations_repeat1] = aux_sym__class_member_declarations_repeat1,
  [aux_sym__function_value_parameters_repeat1] = aux_sym__function_value_parameters_repeat1,
  [aux_sym_enum_class_body_repeat1] = aux_sym_enum_class_body_repeat1,
  [aux_sym_enum_entry_repeat1] = aux_sym_enum_entry_repeat1,
  [aux_sym_enum_type_parameters_repeat1] = aux_sym_enum_type_parameters_repeat1,
  [aux_sym__protocol_member_declarations_repeat1] = aux_sym__protocol_member_declarations_repeat1,
  [aux_sym_computed_property_repeat1] = aux_sym_computed_property_repeat1,
  [aux_sym_precedence_group_attributes_repeat1] = aux_sym_precedence_group_attributes_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym__attribute_argument_repeat1] = aux_sym__attribute_argument_repeat1,
  [aux_sym__attribute_argument_repeat2] = aux_sym__attribute_argument_repeat2,
  [aux_sym__tuple_pattern_repeat1] = aux_sym__tuple_pattern_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_parameter_modifiers_repeat1] = aux_sym_parameter_modifiers_repeat1,
  [alias_sym_fully_open_range] = alias_sym_fully_open_range,
  [alias_sym_interpolated_expression] = alias_sym_interpolated_expression,
  [alias_sym_protocol_function_declaration] = alias_sym_protocol_function_declaration,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_simple_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_simple_identifier_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = false,
  },
  [sym_real_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_oct_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_line_str_text_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__uni_character_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_str_interpolation_start] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym__escaped_identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym__immediate_quest] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_some] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDselector] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getter_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setter_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_custom_operator_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__await_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUNDfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileID] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfilePath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolumn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDdsohandle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDcolorLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDfileLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDimageLiteral] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_self] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDkeyPath] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_statement_label] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [sym_throw_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDavailable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typealias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protocol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_actor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indirect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_init] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_subscript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__modify] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prefix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_postfix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_precedencegroup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_associatedtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_property_behavior_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_convenience] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonisolated] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fileprivate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonmutating] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATescaping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATautoclosure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weak] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unowned_LPARENunsafe_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receiver] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegate] = {
    .visible = true,
    .named = false,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_diagnostic] = {
    .visible = true,
    .named = true,
  },
  [sym_multiline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_part] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_continuing_indicator] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_end_part] = {
    .visible = true,
    .named = true,
  },
  [sym__semi] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__dot_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__three_dot_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__open_ended_range_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__conjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__disjunction_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__nil_coalescing_operator_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__eq_eq_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__plus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym__minus_then_ws] = {
    .visible = true,
    .named = false,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym__throws_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__rethrows_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_default_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_where_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym__as_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_quest_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__as_bang_custom] = {
    .visible = true,
    .named = false,
  },
  [sym__async_keyword_custom] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang_line] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__basic_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_str_escaped_char] = {
    .visible = true,
    .named = true,
  },
  [sym__uni_character_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_str_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__multi_line_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation_contents] = {
    .visible = false,
    .named = true,
  },
  [sym_multi_line_str_text] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__possibly_implicitly_unwrapped_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_user_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_user_type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type_item] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_item_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_type] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_metatype] = {
    .visible = true,
    .named = true,
  },
  [sym__quest] = {
    .visible = false,
    .named = true,
  },
  [sym_opaque_type] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_composition_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_navigation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__navigable_type_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_open_start_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__range_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_open_end_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_coalescing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_check_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_navigation_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_value_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expr_hack_at_ternary_binary_suffix] = {
    .visible = false,
    .named = true,
  },
  [sym_expr_hack_at_ternary_binary_call] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_hack_at_ternary_binary_call_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__dictionary_literal_item] = {
    .visible = false,
    .named = true,
  },
  [sym__special_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__playground_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__lambda_type_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_capture_list] = {
    .visible = true,
    .named = true,
  },
  [sym_capture_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_self_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_super_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__else_options] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__if_condition_sequence_item] = {
    .visible = false,
    .named = true,
  },
  [sym__if_let_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_guard_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_key_path_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__key_path_component] = {
    .visible = false,
    .named = true,
  },
  [sym__key_path_postfixes] = {
    .visible = false,
    .named = true,
  },
  [sym__try_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_and_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equality_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__is_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_as_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__bitwise_binary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__postfix_unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_directly_assignable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_statements] = {
    .visible = true,
    .named = true,
  },
  [sym__local_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__top_level_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_control_transfer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__throw_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__optionally_valueful_control_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_availability_condition] = {
    .visible = true,
    .named = true,
  },
  [sym__availability_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__global_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__type_level_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__local_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__import_kind] = {
    .visible = false,
    .named = true,
  },
  [sym_protocol_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_property_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_property_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__single_modifierless_property_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_typealias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_typealias_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__bodyless_function_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__modifierless_function_declaration_no_body] = {
    .visible = false,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__modifierless_class_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__inheritance_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__annotated_inheritance_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraints] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__class_member_separator] = {
    .visible = false,
    .named = true,
  },
  [sym__class_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [sym__function_value_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__function_value_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_function_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__non_constructor_function_decl] = {
    .visible = false,
    .named = true,
  },
  [sym__referenceable_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__equal_sign] = {
    .visible = false,
    .named = true,
  },
  [sym__eq_eq] = {
    .visible = false,
    .named = true,
  },
  [sym__dot] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__three_dot_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__open_ended_range_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__conjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__disjunction_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__nil_coalescing_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__as] = {
    .visible = false,
    .named = true,
  },
  [sym__as_quest] = {
    .visible = false,
    .named = true,
  },
  [sym__as_bang] = {
    .visible = false,
    .named = true,
  },
  [sym__async_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__async_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_entry] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_entry_suffix] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_protocol_body] = {
    .visible = true,
    .named = true,
  },
  [sym__protocol_member_declarations] = {
    .visible = false,
    .named = true,
  },
  [sym__protocol_member_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_deinit_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_property] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_getter] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_modify] = {
    .visible = true,
    .named = true,
  },
  [sym_computed_setter] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modify_specifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__getter_effects] = {
    .visible = false,
    .named = false,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_precedence_group_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_associatedtype_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__universally_allowed_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__bound_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern_no_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__no_expr_pattern_already_bound] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern_with_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__direct_or_indirect_binding] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern_kind] = {
    .visible = false,
    .named = true,
  },
  [sym__possibly_async_binding_pattern_kind] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_kind_and_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__tuple_pattern_item] = {
    .visible = false,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__case_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__type_casting_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__binding_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__locally_permitted_modifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym__non_local_scope_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym__locally_permitted_modifier] = {
    .visible = false,
    .named = true,
  },
  [sym_type_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_member_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_function_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mutation_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_inheritance_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ownership_modifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_line_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpolation_contents_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_user_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_optional_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_composition_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_suffix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constructor_value_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__playground_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__lambda_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_capture_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_function_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_do_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__key_path_component_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_availability_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__availability_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_protocol_property_requirements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__modifierless_property_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inheritance_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_constraints_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_value_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_entry_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__protocol_member_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_computed_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_precedence_group_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_argument_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_fully_open_range] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interpolated_expression] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_protocol_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_body = 1,
  field_bound_identifier = 2,
  field_captures = 3,
  field_collection = 4,
  field_computed_value = 5,
  field_condition = 6,
  field_constrained_type = 7,
  field_constructed_type = 8,
  field_data_contents = 9,
  field_declaration_kind = 10,
  field_default_value = 11,
  field_element = 12,
  field_end = 13,
  field_error = 14,
  field_expr = 15,
  field_external_name = 16,
  field_if_false = 17,
  field_if_nil = 18,
  field_if_true = 19,
  field_inherits_from = 20,
  field_interpolation = 21,
  field_item = 22,
  field_key = 23,
  field_lhs = 24,
  field_must_equal = 25,
  field_must_inherit = 26,
  field_mutability = 27,
  field_name = 28,
  field_op = 29,
  field_operation = 30,
  field_operator = 31,
  field_params = 32,
  field_raw_value = 33,
  field_reference_specifier = 34,
  field_result = 35,
  field_return_type = 36,
  field_rhs = 37,
  field_start = 38,
  field_suffix = 39,
  field_target = 40,
  field_text = 41,
  field_type = 42,
  field_value = 43,
  field_wrapped = 44,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_bound_identifier] = "bound_identifier",
  [field_captures] = "captures",
  [field_collection] = "collection",
  [field_computed_value] = "computed_value",
  [field_condition] = "condition",
  [field_constrained_type] = "constrained_type",
  [field_constructed_type] = "constructed_type",
  [field_data_contents] = "data_contents",
  [field_declaration_kind] = "declaration_kind",
  [field_default_value] = "default_value",
  [field_element] = "element",
  [field_end] = "end",
  [field_error] = "error",
  [field_expr] = "expr",
  [field_external_name] = "external_name",
  [field_if_false] = "if_false",
  [field_if_nil] = "if_nil",
  [field_if_true] = "if_true",
  [field_inherits_from] = "inherits_from",
  [field_interpolation] = "interpolation",
  [field_item] = "item",
  [field_key] = "key",
  [field_lhs] = "lhs",
  [field_must_equal] = "must_equal",
  [field_must_inherit] = "must_inherit",
  [field_mutability] = "mutability",
  [field_name] = "name",
  [field_op] = "op",
  [field_operation] = "operation",
  [field_operator] = "operator",
  [field_params] = "params",
  [field_raw_value] = "raw_value",
  [field_reference_specifier] = "reference_specifier",
  [field_result] = "result",
  [field_return_type] = "return_type",
  [field_rhs] = "rhs",
  [field_start] = "start",
  [field_suffix] = "suffix",
  [field_target] = "target",
  [field_text] = "text",
  [field_type] = "type",
  [field_value] = "value",
  [field_wrapped] = "wrapped",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 4},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 3},
  [9] = {.index = 12, .length = 3},
  [11] = {.index = 15, .length = 1},
  [12] = {.index = 16, .length = 2},
  [13] = {.index = 18, .length = 1},
  [14] = {.index = 19, .length = 1},
  [15] = {.index = 20, .length = 4},
  [16] = {.index = 24, .length = 3},
  [17] = {.index = 27, .length = 1},
  [18] = {.index = 28, .length = 1},
  [19] = {.index = 29, .length = 1},
  [20] = {.index = 30, .length = 3},
  [21] = {.index = 33, .length = 1},
  [22] = {.index = 33, .length = 1},
  [23] = {.index = 34, .length = 1},
  [24] = {.index = 35, .length = 2},
  [25] = {.index = 37, .length = 2},
  [26] = {.index = 39, .length = 1},
  [27] = {.index = 40, .length = 1},
  [28] = {.index = 41, .length = 2},
  [29] = {.index = 43, .length = 4},
  [30] = {.index = 47, .length = 2},
  [31] = {.index = 49, .length = 1},
  [32] = {.index = 50, .length = 4},
  [33] = {.index = 54, .length = 3},
  [34] = {.index = 57, .length = 4},
  [35] = {.index = 61, .length = 2},
  [36] = {.index = 63, .length = 3},
  [37] = {.index = 66, .length = 3},
  [38] = {.index = 69, .length = 4},
  [39] = {.index = 73, .length = 1},
  [40] = {.index = 74, .length = 1},
  [41] = {.index = 75, .length = 1},
  [42] = {.index = 76, .length = 2},
  [43] = {.index = 78, .length = 1},
  [44] = {.index = 79, .length = 2},
  [45] = {.index = 81, .length = 2},
  [46] = {.index = 83, .length = 1},
  [47] = {.index = 84, .length = 1},
  [48] = {.index = 85, .length = 2},
  [49] = {.index = 87, .length = 2},
  [50] = {.index = 89, .length = 1},
  [51] = {.index = 90, .length = 1},
  [52] = {.index = 91, .length = 1},
  [53] = {.index = 92, .length = 4},
  [54] = {.index = 96, .length = 3},
  [55] = {.index = 99, .length = 4},
  [56] = {.index = 103, .length = 3},
  [57] = {.index = 106, .length = 1},
  [58] = {.index = 107, .length = 3},
  [59] = {.index = 107, .length = 3},
  [60] = {.index = 110, .length = 3},
  [61] = {.index = 113, .length = 3},
  [62] = {.index = 116, .length = 4},
  [63] = {.index = 120, .length = 3},
  [64] = {.index = 123, .length = 1},
  [65] = {.index = 124, .length = 2},
  [66] = {.index = 126, .length = 3},
  [67] = {.index = 129, .length = 2},
  [68] = {.index = 131, .length = 7},
  [69] = {.index = 138, .length = 4},
  [70] = {.index = 142, .length = 3},
  [71] = {.index = 145, .length = 1},
  [72] = {.index = 146, .length = 1},
  [73] = {.index = 147, .length = 1},
  [74] = {.index = 148, .length = 2},
  [75] = {.index = 150, .length = 1},
  [76] = {.index = 151, .length = 2},
  [77] = {.index = 153, .length = 3},
  [78] = {.index = 156, .length = 4},
  [79] = {.index = 160, .length = 3},
  [80] = {.index = 163, .length = 2},
  [81] = {.index = 165, .length = 3},
  [82] = {.index = 168, .length = 2},
  [83] = {.index = 170, .length = 2},
  [84] = {.index = 172, .length = 2},
  [85] = {.index = 174, .length = 4},
  [86] = {.index = 178, .length = 4},
  [87] = {.index = 182, .length = 3},
  [88] = {.index = 185, .length = 2},
  [89] = {.index = 187, .length = 2},
  [90] = {.index = 189, .length = 1},
  [91] = {.index = 190, .length = 1},
  [92] = {.index = 191, .length = 8},
  [93] = {.index = 199, .length = 8},
  [94] = {.index = 207, .length = 3},
  [95] = {.index = 210, .length = 4},
  [96] = {.index = 214, .length = 3},
  [97] = {.index = 217, .length = 1},
  [98] = {.index = 218, .length = 3},
  [99] = {.index = 9, .length = 3},
  [100] = {.index = 221, .length = 1},
  [101] = {.index = 218, .length = 3},
  [102] = {.index = 222, .length = 3},
  [103] = {.index = 225, .length = 3},
  [104] = {.index = 228, .length = 3},
  [105] = {.index = 231, .length = 2},
  [106] = {.index = 233, .length = 1},
  [108] = {.index = 234, .length = 4},
  [109] = {.index = 238, .length = 3},
  [110] = {.index = 241, .length = 6},
  [111] = {.index = 247, .length = 4},
  [112] = {.index = 251, .length = 4},
  [113] = {.index = 255, .length = 2},
  [114] = {.index = 255, .length = 2},
  [115] = {.index = 257, .length = 1},
  [116] = {.index = 258, .length = 2},
  [117] = {.index = 260, .length = 2},
  [118] = {.index = 262, .length = 3},
  [119] = {.index = 265, .length = 4},
  [120] = {.index = 269, .length = 3},
  [121] = {.index = 272, .length = 2},
  [122] = {.index = 274, .length = 3},
  [123] = {.index = 277, .length = 4},
  [124] = {.index = 281, .length = 2},
  [125] = {.index = 283, .length = 4},
  [126] = {.index = 287, .length = 3},
  [127] = {.index = 290, .length = 5},
  [128] = {.index = 295, .length = 4},
  [129] = {.index = 299, .length = 3},
  [130] = {.index = 302, .length = 3},
  [131] = {.index = 305, .length = 1},
  [132] = {.index = 43, .length = 4},
  [133] = {.index = 306, .length = 1},
  [134] = {.index = 307, .length = 2},
  [135] = {.index = 309, .length = 4},
  [136] = {.index = 302, .length = 3},
  [137] = {.index = 313, .length = 3},
  [138] = {.index = 316, .length = 3},
  [139] = {.index = 319, .length = 2},
  [140] = {.index = 321, .length = 3},
  [141] = {.index = 324, .length = 2},
  [142] = {.index = 326, .length = 2},
  [143] = {.index = 328, .length = 1},
  [144] = {.index = 329, .length = 1},
  [145] = {.index = 330, .length = 4},
  [146] = {.index = 334, .length = 4},
  [147] = {.index = 338, .length = 4},
  [148] = {.index = 342, .length = 4},
  [149] = {.index = 346, .length = 3},
  [150] = {.index = 349, .length = 3},
  [151] = {.index = 260, .length = 2},
  [152] = {.index = 352, .length = 4},
  [153] = {.index = 356, .length = 3},
  [154] = {.index = 359, .length = 2},
  [155] = {.index = 361, .length = 4},
  [156] = {.index = 365, .length = 5},
  [157] = {.index = 370, .length = 5},
  [158] = {.index = 375, .length = 8},
  [159] = {.index = 383, .length = 4},
  [160] = {.index = 387, .length = 3},
  [161] = {.index = 390, .length = 3},
  [162] = {.index = 393, .length = 3},
  [163] = {.index = 396, .length = 1},
  [164] = {.index = 397, .length = 3},
  [165] = {.index = 400, .length = 1},
  [166] = {.index = 401, .length = 4},
  [167] = {.index = 145, .length = 1},
  [168] = {.index = 405, .length = 4},
  [169] = {.index = 393, .length = 3},
  [170] = {.index = 409, .length = 3},
  [171] = {.index = 412, .length = 5},
  [172] = {.index = 417, .length = 1},
  [173] = {.index = 418, .length = 1},
  [174] = {.index = 419, .length = 4},
  [175] = {.index = 423, .length = 4},
  [176] = {.index = 427, .length = 4},
  [177] = {.index = 431, .length = 3},
  [178] = {.index = 434, .length = 2},
  [179] = {.index = 436, .length = 5},
  [180] = {.index = 441, .length = 5},
  [181] = {.index = 446, .length = 8},
  [182] = {.index = 454, .length = 3},
  [183] = {.index = 457, .length = 3},
  [184] = {.index = 460, .length = 1},
  [185] = {.index = 461, .length = 3},
  [186] = {.index = 464, .length = 1},
  [187] = {.index = 465, .length = 6},
  [188] = {.index = 471, .length = 6},
  [189] = {.index = 477, .length = 3},
  [190] = {.index = 480, .length = 4},
  [191] = {.index = 484, .length = 1},
  [192] = {.index = 461, .length = 3},
  [193] = {.index = 485, .length = 3},
  [194] = {.index = 488, .length = 5},
  [195] = {.index = 493, .length = 4},
  [196] = {.index = 497, .length = 5},
  [197] = {.index = 502, .length = 2},
  [198] = {.index = 504, .length = 5},
  [199] = {.index = 509, .length = 3},
  [200] = {.index = 512, .length = 1},
  [201] = {.index = 513, .length = 6},
  [202] = {.index = 519, .length = 3},
  [203] = {.index = 522, .length = 4},
  [204] = {.index = 526, .length = 3},
  [205] = {.index = 529, .length = 5},
  [206] = {.index = 534, .length = 3},
  [207] = {.index = 537, .length = 6},
  [208] = {.index = 543, .length = 3},
  [209] = {.index = 418, .length = 1},
  [210] = {.index = 546, .length = 1},
  [211] = {.index = 547, .length = 2},
  [212] = {.index = 549, .length = 2},
  [213] = {.index = 551, .length = 2},
  [214] = {.index = 553, .length = 2},
  [215] = {.index = 555, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_text, 0},
  [1] =
    {field_mutability, 0},
  [2] =
    {field_name, 0},
  [3] =
    {field_computed_value, 0, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [7] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [9] =
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [12] =
    {field_body, 0, .inherited = true},
    {field_declaration_kind, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [15] =
    {field_mutability, 0, .inherited = true},
  [16] =
    {field_interpolation, 1},
    {field_text, 0},
  [18] =
    {field_interpolation, 0, .inherited = true},
  [19] =
    {field_expr, 1},
  [20] =
    {field_body, 0, .inherited = true},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [24] =
    {field_bound_identifier, 0, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [27] =
    {field_bound_identifier, 0},
  [28] =
    {field_name, 0, .inherited = true},
  [29] =
    {field_bound_identifier, 0, .inherited = true},
  [30] =
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [33] =
    {field_name, 1},
  [34] =
    {field_constructed_type, 0},
  [35] =
    {field_suffix, 1},
    {field_target, 0},
  [37] =
    {field_operation, 1},
    {field_target, 0},
  [39] =
    {field_start, 0},
  [40] =
    {field_end, 1},
  [41] =
    {field_operation, 0},
    {field_target, 1},
  [43] =
    {field_body, 1},
    {field_default_value, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
  [47] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
  [49] =
    {field_mutability, 1, .inherited = true},
  [50] =
    {field_computed_value, 1, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [54] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [57] =
    {field_computed_value, 1, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [61] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [63] =
    {field_body, 1, .inherited = true},
    {field_declaration_kind, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [66] =
    {field_interpolation, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1},
  [69] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [73] =
    {field_value, 0},
  [74] =
    {field_interpolation, 0},
  [75] =
    {field_reference_specifier, 0, .inherited = true},
  [76] =
    {field_interpolation, 1, .inherited = true},
    {field_text, 1, .inherited = true},
  [78] =
    {field_value, 1},
  [79] =
    {field_name, 0, .inherited = true},
    {field_type, 0},
  [81] =
    {field_element, 1},
    {field_name, 1, .inherited = true},
  [83] =
    {field_wrapped, 0},
  [84] =
    {field_element, 1},
  [85] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [87] =
    {field_captures, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [89] =
    {field_captures, 0},
  [90] =
    {field_type, 0},
  [91] =
    {field_result, 1},
  [92] =
    {field_body, 1, .inherited = true},
    {field_default_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
  [96] =
    {field_bound_identifier, 1, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [99] =
    {field_bound_identifier, 1, .inherited = true},
    {field_condition, 1},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [103] =
    {field_bound_identifier, 1, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [106] =
    {field_name, 1, .inherited = true},
  [107] =
    {field_body, 2},
    {field_declaration_kind, 0},
    {field_name, 1},
  [110] =
    {field_end, 2},
    {field_op, 1},
    {field_start, 0},
  [113] =
    {field_lhs, 0},
    {field_op, 1},
    {field_rhs, 2},
  [116] =
    {field_name, 2, .inherited = true},
    {field_op, 1},
    {field_target, 0},
    {field_type, 2},
  [120] =
    {field_expr, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [123] =
    {field_suffix, 1},
  [124] =
    {field_if_nil, 2},
    {field_value, 0},
  [126] =
    {field_operator, 1},
    {field_result, 2},
    {field_target, 0},
  [129] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
  [131] =
    {field_computed_value, 1, .inherited = true},
    {field_computed_value, 2, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [138] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 1},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [142] =
    {field_default_value, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
  [145] =
    {field_name, 2},
  [146] =
    {field_reference_specifier, 0},
  [147] =
    {field_interpolation, 1, .inherited = true},
  [148] =
    {field_interpolation, 0},
    {field_interpolation, 1, .inherited = true},
  [150] =
    {field_reference_specifier, 1, .inherited = true},
  [151] =
    {field_reference_specifier, 0, .inherited = true},
    {field_reference_specifier, 1, .inherited = true},
  [153] =
    {field_name, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [156] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [160] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [163] =
    {field_name, 1, .inherited = true},
    {field_type, 1},
  [165] =
    {field_name, 2, .inherited = true},
    {field_params, 0},
    {field_return_type, 2},
  [168] =
    {field_key, 0},
    {field_value, 2},
  [170] =
    {field_element, 1},
    {field_element, 2, .inherited = true},
  [172] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [174] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [178] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [182] =
    {field_name, 0},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [185] =
    {field_captures, 0},
    {field_type, 1},
  [187] =
    {field_name, 2, .inherited = true},
    {field_return_type, 2},
  [189] =
    {field_captures, 1},
  [190] =
    {field_type, 1},
  [191] =
    {field_bound_identifier, 1, .inherited = true},
    {field_bound_identifier, 2, .inherited = true},
    {field_condition, 1},
    {field_condition, 2, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_mutability, 2, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [199] =
    {field_bound_identifier, 0, .inherited = true},
    {field_bound_identifier, 1, .inherited = true},
    {field_condition, 0, .inherited = true},
    {field_condition, 1, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [207] =
    {field_bound_identifier, 2, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [210] =
    {field_bound_identifier, 0, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [214] =
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [217] =
    {field_inherits_from, 0},
  [218] =
    {field_body, 3},
    {field_declaration_kind, 0},
    {field_name, 1},
  [221] =
    {field_body, 0, .inherited = true},
  [222] =
    {field_body, 3},
    {field_declaration_kind, 1},
    {field_name, 2},
  [225] =
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [228] =
    {field_default_value, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
  [231] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [233] =
    {field_default_value, 1, .inherited = true},
  [234] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [238] =
    {field_computed_value, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [241] =
    {field_computed_value, 0, .inherited = true},
    {field_computed_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [247] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 2},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [251] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [255] =
    {field_name, 0},
    {field_value, 2},
  [257] =
    {field_interpolation, 1},
  [258] =
    {field_interpolation, 0, .inherited = true},
    {field_interpolation, 1, .inherited = true},
  [260] =
    {field_name, 1},
    {field_value, 3},
  [262] =
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 2},
  [265] =
    {field_key, 1},
    {field_name, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_value, 3},
  [269] =
    {field_name, 3, .inherited = true},
    {field_params, 0},
    {field_return_type, 3},
  [272] =
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [274] =
    {field_name, 0},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [277] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_type, 3},
  [281] =
    {field_captures, 1},
    {field_type, 2},
  [283] =
    {field_bound_identifier, 1, .inherited = true},
    {field_error, 1},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [287] =
    {field_bound_identifier, 2, .inherited = true},
    {field_mutability, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [290] =
    {field_bound_identifier, 1, .inherited = true},
    {field_collection, 3},
    {field_item, 1},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [295] =
    {field_bound_identifier, 4, .inherited = true},
    {field_condition, 4},
    {field_mutability, 4, .inherited = true},
    {field_name, 4, .inherited = true},
  [299] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 4},
  [302] =
    {field_body, 4},
    {field_declaration_kind, 0},
    {field_name, 1},
  [305] =
    {field_body, 1},
  [306] =
    {field_body, 1, .inherited = true},
  [307] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [309] =
    {field_bound_identifier, 0, .inherited = true},
    {field_mutability, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [313] =
    {field_body, 4},
    {field_declaration_kind, 1},
    {field_name, 2},
  [316] =
    {field_default_value, 4},
    {field_name, 1},
    {field_name, 4, .inherited = true},
  [319] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [321] =
    {field_condition, 0},
    {field_if_false, 4},
    {field_if_true, 2},
  [324] =
    {field_default_value, 1, .inherited = true},
    {field_default_value, 2, .inherited = true},
  [326] =
    {field_default_value, 0, .inherited = true},
    {field_default_value, 1, .inherited = true},
  [328] =
    {field_default_value, 2},
  [329] =
    {field_name, 2, .inherited = true},
  [330] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [334] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [338] =
    {field_bound_identifier, 0, .inherited = true},
    {field_computed_value, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
  [342] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 3},
  [346] =
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [349] =
    {field_default_value, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
  [352] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [356] =
    {field_name, 4, .inherited = true},
    {field_params, 0},
    {field_return_type, 4},
  [359] =
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [361] =
    {field_external_name, 0},
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_type, 4},
  [365] =
    {field_bound_identifier, 2, .inherited = true},
    {field_collection, 4},
    {field_item, 2},
    {field_mutability, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [370] =
    {field_bound_identifier, 1, .inherited = true},
    {field_collection, 4},
    {field_item, 1},
    {field_mutability, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [375] =
    {field_bound_identifier, 4, .inherited = true},
    {field_bound_identifier, 5, .inherited = true},
    {field_condition, 4},
    {field_condition, 5, .inherited = true},
    {field_mutability, 4, .inherited = true},
    {field_mutability, 5, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
  [383] =
    {field_bound_identifier, 5, .inherited = true},
    {field_condition, 5},
    {field_mutability, 5, .inherited = true},
    {field_name, 5, .inherited = true},
  [387] =
    {field_constrained_type, 0},
    {field_inherits_from, 2},
    {field_name, 2, .inherited = true},
  [390] =
    {field_constrained_type, 0},
    {field_must_equal, 2},
    {field_name, 2, .inherited = true},
  [393] =
    {field_body, 5},
    {field_declaration_kind, 0},
    {field_name, 1},
  [396] =
    {field_body, 2},
  [397] =
    {field_data_contents, 2, .inherited = true},
    {field_name, 1},
    {field_raw_value, 2, .inherited = true},
  [400] =
    {field_data_contents, 0},
  [401] =
    {field_data_contents, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_raw_value, 2, .inherited = true},
  [405] =
    {field_bound_identifier, 1, .inherited = true},
    {field_mutability, 1, .inherited = true},
    {field_name, 1},
    {field_name, 1, .inherited = true},
  [409] =
    {field_body, 5},
    {field_declaration_kind, 1},
    {field_name, 2},
  [412] =
    {field_default_value, 5},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 5, .inherited = true},
  [417] =
    {field_default_value, 3},
  [418] =
    {field_name, 3, .inherited = true},
  [419] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [423] =
    {field_default_value, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [427] =
    {field_bound_identifier, 0, .inherited = true},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_value, 4},
  [431] =
    {field_default_value, 5},
    {field_name, 2},
    {field_name, 5, .inherited = true},
  [434] =
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [436] =
    {field_bound_identifier, 2, .inherited = true},
    {field_collection, 5},
    {field_item, 2},
    {field_mutability, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [441] =
    {field_bound_identifier, 3, .inherited = true},
    {field_collection, 5},
    {field_item, 3},
    {field_mutability, 3, .inherited = true},
    {field_name, 3, .inherited = true},
  [446] =
    {field_bound_identifier, 5, .inherited = true},
    {field_bound_identifier, 6, .inherited = true},
    {field_condition, 5},
    {field_condition, 6, .inherited = true},
    {field_mutability, 5, .inherited = true},
    {field_mutability, 6, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_name, 6, .inherited = true},
  [454] =
    {field_constrained_type, 1},
    {field_inherits_from, 3},
    {field_name, 3, .inherited = true},
  [457] =
    {field_constrained_type, 1},
    {field_must_equal, 3},
    {field_name, 3, .inherited = true},
  [460] =
    {field_default_value, 2, .inherited = true},
  [461] =
    {field_body, 6},
    {field_declaration_kind, 0},
    {field_name, 1},
  [464] =
    {field_raw_value, 1},
  [465] =
    {field_data_contents, 2, .inherited = true},
    {field_data_contents, 3, .inherited = true},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_raw_value, 2, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [471] =
    {field_data_contents, 0, .inherited = true},
    {field_data_contents, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_raw_value, 0, .inherited = true},
    {field_raw_value, 1, .inherited = true},
  [477] =
    {field_data_contents, 3, .inherited = true},
    {field_name, 2},
    {field_raw_value, 3, .inherited = true},
  [480] =
    {field_data_contents, 3, .inherited = true},
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_raw_value, 3, .inherited = true},
  [484] =
    {field_name, 3},
  [485] =
    {field_body, 6},
    {field_declaration_kind, 1},
    {field_name, 2},
  [488] =
    {field_default_value, 6},
    {field_must_inherit, 3},
    {field_name, 1},
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [493] =
    {field_default_value, 2, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [497] =
    {field_default_value, 6},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 6, .inherited = true},
  [502] =
    {field_name, 6, .inherited = true},
    {field_return_type, 6},
  [504] =
    {field_bound_identifier, 3, .inherited = true},
    {field_collection, 6},
    {field_item, 3},
    {field_mutability, 3, .inherited = true},
    {field_name, 3, .inherited = true},
  [509] =
    {field_default_value, 1, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_return_type, 3},
  [512] =
    {field_default_value, 3, .inherited = true},
  [513] =
    {field_data_contents, 3, .inherited = true},
    {field_data_contents, 4, .inherited = true},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_raw_value, 3, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [519] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 3},
    {field_raw_value, 4, .inherited = true},
  [522] =
    {field_data_contents, 4, .inherited = true},
    {field_name, 3},
    {field_name, 4, .inherited = true},
    {field_raw_value, 4, .inherited = true},
  [526] =
    {field_body, 7},
    {field_declaration_kind, 1},
    {field_name, 2},
  [529] =
    {field_default_value, 7},
    {field_must_inherit, 4},
    {field_name, 2},
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
  [534] =
    {field_default_value, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_return_type, 4},
  [537] =
    {field_data_contents, 4, .inherited = true},
    {field_data_contents, 5, .inherited = true},
    {field_name, 3},
    {field_name, 5, .inherited = true},
    {field_raw_value, 4, .inherited = true},
    {field_raw_value, 5, .inherited = true},
  [543] =
    {field_default_value, 3, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_return_type, 5},
  [546] =
    {field_name, 4, .inherited = true},
  [547] =
    {field_name, 3, .inherited = true},
    {field_name, 4, .inherited = true},
  [549] =
    {field_name, 1, .inherited = true},
    {field_name, 4, .inherited = true},
  [551] =
    {field_name, 4, .inherited = true},
    {field_name, 5, .inherited = true},
  [553] =
    {field_name, 3, .inherited = true},
    {field_name, 6, .inherited = true},
  [555] =
    {field_name, 4, .inherited = true},
    {field_name, 7, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_simple_identifier,
  },
  [5] = {
    [0] = alias_sym_type_identifier,
  },
  [10] = {
    [0] = alias_sym_fully_open_range,
  },
  [22] = {
    [1] = alias_sym_type_identifier,
  },
  [33] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [40] = {
    [0] = alias_sym_interpolated_expression,
  },
  [58] = {
    [1] = alias_sym_type_identifier,
  },
  [69] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [71] = {
    [2] = alias_sym_type_identifier,
  },
  [74] = {
    [0] = alias_sym_interpolated_expression,
  },
  [95] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [96] = {
    [1] = alias_sym_type_identifier,
  },
  [98] = {
    [1] = alias_sym_type_identifier,
  },
  [99] = {
    [0] = alias_sym_protocol_function_declaration,
  },
  [102] = {
    [2] = alias_sym_type_identifier,
  },
  [103] = {
    [1] = alias_sym_type_identifier,
  },
  [104] = {
    [1] = alias_sym_type_identifier,
  },
  [107] = {
    [1] = alias_sym_type_identifier,
  },
  [111] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [112] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [113] = {
    [0] = sym_simple_identifier,
  },
  [115] = {
    [1] = alias_sym_interpolated_expression,
  },
  [125] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [127] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [129] = {
    [1] = alias_sym_type_identifier,
  },
  [130] = {
    [1] = alias_sym_type_identifier,
  },
  [132] = {
    [0] = alias_sym_protocol_function_declaration,
    [1] = alias_sym_protocol_function_declaration,
  },
  [135] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [137] = {
    [2] = alias_sym_type_identifier,
  },
  [138] = {
    [1] = alias_sym_type_identifier,
  },
  [144] = {
    [0] = alias_sym_type_identifier,
  },
  [147] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [148] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [149] = {
    [2] = alias_sym_type_identifier,
  },
  [150] = {
    [2] = alias_sym_type_identifier,
  },
  [151] = {
    [1] = sym_simple_identifier,
  },
  [156] = {
    [2] = sym__binding_pattern_with_expr,
  },
  [157] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [162] = {
    [1] = alias_sym_type_identifier,
  },
  [168] = {
    [1] = sym__binding_pattern_with_expr,
  },
  [170] = {
    [2] = alias_sym_type_identifier,
  },
  [171] = {
    [1] = alias_sym_type_identifier,
  },
  [173] = {
    [1] = alias_sym_type_identifier,
  },
  [176] = {
    [0] = sym__binding_pattern_with_expr,
  },
  [177] = {
    [2] = alias_sym_type_identifier,
  },
  [179] = {
    [2] = sym__binding_pattern_with_expr,
  },
  [180] = {
    [3] = sym__binding_pattern_with_expr,
  },
  [185] = {
    [1] = alias_sym_type_identifier,
  },
  [193] = {
    [2] = alias_sym_type_identifier,
  },
  [194] = {
    [1] = alias_sym_type_identifier,
  },
  [196] = {
    [2] = alias_sym_type_identifier,
  },
  [198] = {
    [3] = sym__binding_pattern_with_expr,
  },
  [204] = {
    [2] = alias_sym_type_identifier,
  },
  [205] = {
    [2] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_simple_identifier, 2,
    sym_simple_identifier,
    alias_sym_type_identifier,
  sym_value_argument, 2,
    sym_value_argument,
    alias_sym_interpolated_expression,
  sym__bodyless_function_declaration, 2,
    sym__bodyless_function_declaration,
    alias_sym_protocol_function_declaration,
  sym_function_body, 2,
    sym_function_body,
    alias_sym_protocol_function_declaration,
  sym__three_dot_operator, 2,
    sym__three_dot_operator,
    alias_sym_fully_open_range,
  sym__binding_pattern_no_expr, 2,
    sym__binding_pattern_no_expr,
    sym__binding_pattern_with_expr,
  sym__no_expr_pattern_already_bound, 2,
    sym__no_expr_pattern_already_bound,
    sym__binding_pattern_with_expr,
  sym__binding_kind_and_pattern, 2,
    sym__binding_kind_and_pattern,
    sym__binding_pattern_with_expr,
  0,
};

static inline bool aux_sym_simple_identifier_token1_character_set_1(int32_t c) {
  return (c < 43259
    ? (c < 5998
      ? (c < 2949
        ? (c < 2185
          ? (c < 1376
            ? (c < 880
              ? (c < 216
                ? (c < 181
                  ? (c < 169
                    ? (c >= 'A' && c <= 'z')
                    : (c <= 170 || c == 174))
                  : (c <= 181 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))))
              : (c <= 884 || (c < 910
                ? (c < 902
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : (c <= 893 || c == 895))
                  : (c <= 902 || (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))))))
            : (c <= 1416 || (c < 1869
              ? (c < 1765
                ? (c < 1646
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : (c <= 1522 || (c >= 1568 && c <= 1610)))
                  : (c <= 1647 || (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)))
                : (c <= 1766 || (c < 1791
                  ? (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1810
                    ? c == 1808
                    : c <= 1839)))))
              : (c <= 1957 || (c < 2074
                ? (c < 2036
                  ? (c < 1994
                    ? c == 1969
                    : c <= 2026)
                  : (c <= 2037 || (c < 2048
                    ? c == 2042
                    : c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))))))))
          : (c <= 2190 || (c < 2616
            ? (c < 2493
              ? (c < 2437
                ? (c < 2384
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : (c <= 2361 || c == 2365))
                  : (c <= 2384 || (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))))
              : (c <= 2493 || (c < 2565
                ? (c < 2527
                  ? (c < 2524
                    ? c == 2510
                    : c <= 2525)
                  : (c <= 2529 || (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)))
                : (c <= 2570 || (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)))))))
            : (c <= 2617 || (c < 2809
              ? (c < 2730
                ? (c < 2693
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : (c <= 2654 || (c >= 2674 && c <= 2676)))
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))
                : (c <= 2736 || (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || (c < 2784
                    ? c == 2768
                    : c <= 2785)))))
              : (c <= 2809 || (c < 2869
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || (c < 2947
                    ? c == 2929
                    : c <= 2947)))))))))))
        : (c <= 2954 || (c < 3762
          ? (c < 3293
            ? (c < 3114
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))))
              : (c <= 3129 || (c < 3205
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)))))))
            : (c <= 3294 || (c < 3507
              ? (c < 3406
                ? (c < 3342
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : (c <= 3314 || (c >= 3332 && c <= 3340)))
                  : (c <= 3344 || (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)))
                : (c <= 3406 || (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))))
              : (c <= 3515 || (c < 3713
                ? (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || (c < 3648
                    ? c == 3634
                    : c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3760)))))))))
          : (c <= 3762 || (c < 4696
            ? (c < 4193
              ? (c < 3913
                ? (c < 3804
                  ? (c < 3776
                    ? c == 3773
                    : (c <= 3780 || c == 3782))
                  : (c <= 3807 || (c < 3904
                    ? c == 3840
                    : c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)))))
              : (c <= 4193 || (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4992
              ? (c < 4800
                ? (c < 4752
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : (c <= 4744 || (c >= 4746 && c <= 4749)))
                  : (c <= 4784 || (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)))
                : (c <= 4800 || (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)))))
              : (c <= 5007 || (c < 5792
                ? (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)))
                : (c <= 5866 || (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)))))))))))))
      : (c <= 6000 || (c < 9832
        ? (c < 8182
          ? (c < 7312
            ? (c < 6656
              ? (c < 6320
                ? (c < 6176
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : (c <= 6103 || c == 6108))
                  : (c <= 6264 || (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))))
              : (c <= 6678 || (c < 7086
                ? (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)))))))
            : (c <= 7354 || (c < 8027
              ? (c < 7680
                ? (c < 7413
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : (c <= 7404 || (c >= 7406 && c <= 7411)))
                  : (c <= 7414 || (c < 7424
                    ? c == 7418
                    : c <= 7615)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))))))
          : (c <= 8188 || (c < 9193
            ? (c < 8486
              ? (c < 8455
                ? (c < 8319
                  ? (c < 8265
                    ? c == 8252
                    : (c <= 8265 || c == 8305))
                  : (c <= 8319 || (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)))
                : (c <= 8455 || (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8484
                    ? c == 8482
                    : c <= 8484)))))
              : (c <= 8486 || (c < 8544
                ? (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))
                : (c <= 8584 || (c < 8986
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : c <= 8618)
                  : (c <= 8987 || (c < 9167
                    ? c == 9000
                    : c <= 9167)))))))
            : (c <= 9203 || (c < 9760
              ? (c < 9728
                ? (c < 9654
                  ? (c < 9410
                    ? (c >= 9208 && c <= 9210)
                    : (c <= 9410 || (c >= 9642 && c <= 9643)))
                  : (c <= 9654 || (c < 9723
                    ? c == 9664
                    : c <= 9726)))
                : (c <= 9732 || (c < 9748
                  ? (c < 9745
                    ? c == 9742
                    : c <= 9745)
                  : (c <= 9749 || (c < 9757
                    ? c == 9752
                    : c <= 9757)))))
              : (c <= 9760 || (c < 9792
                ? (c < 9770
                  ? (c < 9766
                    ? (c >= 9762 && c <= 9763)
                    : c <= 9766)
                  : (c <= 9770 || (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : c <= 9786)))
                : (c <= 9792 || (c < 9823
                  ? (c < 9800
                    ? c == 9794
                    : c <= 9811)
                  : (c <= 9824 || (c < 9829
                    ? c == 9827
                    : c <= 9830)))))))))))
        : (c <= 9832 || (c < 11520
          ? (c < 10004
            ? (c < 9934
              ? (c < 9895
                ? (c < 9881
                  ? (c < 9854
                    ? c == 9851
                    : (c <= 9855 || (c >= 9874 && c <= 9879)))
                  : (c <= 9881 || (c < 9888
                    ? (c >= 9883 && c <= 9884)
                    : c <= 9889)))
                : (c <= 9895 || (c < 9917
                  ? (c < 9904
                    ? (c >= 9898 && c <= 9899)
                    : c <= 9905)
                  : (c <= 9918 || (c < 9928
                    ? (c >= 9924 && c <= 9925)
                    : c <= 9928)))))
              : (c <= 9935 || (c < 9981
                ? (c < 9961
                  ? (c < 9939
                    ? c == 9937
                    : c <= 9940)
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9992
                  ? (c < 9989
                    ? c == 9986
                    : c <= 9989)
                  : (c <= 9997 || (c < 10002
                    ? c == 9999
                    : c <= 10002)))))))
            : (c <= 10004 || (c < 10133
              ? (c < 10055
                ? (c < 10024
                  ? (c < 10013
                    ? c == 10006
                    : (c <= 10013 || c == 10017))
                  : (c <= 10024 || (c < 10052
                    ? (c >= 10035 && c <= 10036)
                    : c <= 10052)))
                : (c <= 10055 || (c < 10067
                  ? (c < 10062
                    ? c == 10060
                    : c <= 10062)
                  : (c <= 10069 || (c < 10083
                    ? c == 10071
                    : c <= 10084)))))
              : (c <= 10135 || (c < 11035
                ? (c < 10175
                  ? (c < 10160
                    ? c == 10145
                    : c <= 10160)
                  : (c <= 10175 || (c < 11013
                    ? (c >= 10548 && c <= 10549)
                    : c <= 11015)))
                : (c <= 11036 || (c < 11264
                  ? (c < 11093
                    ? c == 11088
                    : c <= 11093)
                  : (c <= 11492 || (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)))))))))
          : (c <= 11557 || (c < 12784
            ? (c < 11736
              ? (c < 11688
                ? (c < 11631
                  ? (c < 11565
                    ? c == 11559
                    : (c <= 11565 || (c >= 11568 && c <= 11623)))
                  : (c <= 11631 || (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))))
              : (c <= 11742 || (c < 12445
                ? (c < 12336
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12349)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)))))))
            : (c <= 12799 || (c < 42786
              ? (c < 42512
                ? (c < 19968
                  ? (c < 12953
                    ? c == 12951
                    : (c <= 12953 || (c >= 13312 && c <= 19903)))
                  : (c <= 42124 || (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)))
                : (c <= 42527 || (c < 42623
                  ? (c < 42560
                    ? (c >= 42538 && c <= 42539)
                    : c <= 42606)
                  : (c <= 42653 || (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)))))
              : (c <= 42888 || (c < 43011
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)))))))))))))))
    : (c <= 43259 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43616
              ? (c < 43488
                ? (c < 43360
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : (c <= 43301 || (c >= 43312 && c <= 43334)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)))
                : (c <= 43492 || (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)))))
              : (c <= 43638 || (c < 43712
                ? (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_2(int32_t c) {
  return (c < 43250
    ? (c < 5984
      ? (c < 2947
        ? (c < 2160
          ? (c < 1369
            ? (c < 750
              ? (c < 192
                ? (c < 174
                  ? (c < 'b'
                    ? (c >= 'A' && c <= 'Z')
                    : (c <= 'z' || (c >= 169 && c <= 170)))
                  : (c <= 174 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))))
              : (c <= 750 || (c < 908
                ? (c < 895
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : (c <= 887 || (c >= 891 && c <= 893)))
                  : (c <= 895 || (c < 904
                    ? c == 902
                    : c <= 906)))
                : (c <= 908 || (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))))))
            : (c <= 1369 || (c < 1810
              ? (c < 1749
                ? (c < 1568
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1610 || (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1808)))))
              : (c <= 1839 || (c < 2048
                ? (c < 1994
                  ? (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)
                  : (c <= 2026 || (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)))
                : (c <= 2069 || (c < 2088
                  ? (c < 2084
                    ? c == 2074
                    : c <= 2084)
                  : (c <= 2088 || (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)))))))))
          : (c <= 2183 || (c < 2613
            ? (c < 2486
              ? (c < 2417
                ? (c < 2365
                  ? (c < 2208
                    ? (c >= 2185 && c <= 2190)
                    : (c <= 2249 || (c >= 2308 && c <= 2361)))
                  : (c <= 2365 || (c < 2392
                    ? c == 2384
                    : c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))))
              : (c <= 2489 || (c < 2556
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)))
                : (c <= 2556 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))))))
            : (c <= 2614 || (c < 2784
              ? (c < 2707
                ? (c < 2674
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : (c <= 2652 || c == 2654))
                  : (c <= 2676 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))
                : (c <= 2728 || (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))))
              : (c <= 2785 || (c < 2866
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)))))))))))
        : (c <= 2947 || (c < 3751
          ? (c < 3261
            ? (c < 3090
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : (c <= 2960 || (c >= 2962 && c <= 2965)))
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)))))
              : (c <= 3112 || (c < 3200
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))))
            : (c <= 3261 || (c < 3482
              ? (c < 3389
                ? (c < 3332
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : (c <= 3297 || (c >= 3313 && c <= 3314)))
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)))
                : (c <= 3389 || (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)))))
              : (c <= 3505 || (c < 3648
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)))
                : (c <= 3654 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))
          : (c <= 3760 || (c < 4688
            ? (c < 4186
              ? (c < 3904
                ? (c < 3782
                  ? (c < 3773
                    ? c == 3762
                    : (c <= 3773 || (c >= 3776 && c <= 3780)))
                  : (c <= 3782 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3911 || (c < 4096
                  ? (c < 3976
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3980)
                  : (c <= 4138 || (c < 4176
                    ? c == 4159
                    : c <= 4181)))))
              : (c <= 4189 || (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4698
                    ? c == 4696
                    : (c <= 4701 || (c >= 4704 && c <= 4744)))
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5761
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)))))))))))))
      : (c <= 5996 || (c < 9829
        ? (c < 8178
          ? (c < 7296
            ? (c < 6576
              ? (c < 6314
                ? (c < 6108
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : (c <= 6067 || c == 6103))
                  : (c <= 6108 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)))
                : (c <= 6314 || (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))))
              : (c <= 6601 || (c < 7043
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)))))))
            : (c <= 7304 || (c < 8025
              ? (c < 7424
                ? (c < 7406
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : (c <= 7359 || (c >= 7401 && c <= 7404)))
                  : (c <= 7411 || (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))
              : (c <= 8025 || (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))))))
          : (c <= 8180 || (c < 9167
            ? (c < 8484
              ? (c < 8450
                ? (c < 8305
                  ? (c < 8252
                    ? (c >= 8182 && c <= 8188)
                    : (c <= 8252 || c == 8265))
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8450 || (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))))
              : (c <= 8484 || (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 8617
                  ? (c < 8596
                    ? (c >= 8544 && c <= 8584)
                    : c <= 8601)
                  : (c <= 8618 || (c < 9000
                    ? (c >= 8986 && c <= 8987)
                    : c <= 9000)))))))
            : (c <= 9167 || (c < 9757
              ? (c < 9723
                ? (c < 9642
                  ? (c < 9208
                    ? (c >= 9193 && c <= 9203)
                    : (c <= 9210 || c == 9410))
                  : (c <= 9643 || (c < 9664
                    ? c == 9654
                    : c <= 9664)))
                : (c <= 9726 || (c < 9745
                  ? (c < 9742
                    ? (c >= 9728 && c <= 9732)
                    : c <= 9742)
                  : (c <= 9745 || (c < 9752
                    ? (c >= 9748 && c <= 9749)
                    : c <= 9752)))))
              : (c <= 9757 || (c < 9784
                ? (c < 9766
                  ? (c < 9762
                    ? c == 9760
                    : c <= 9763)
                  : (c <= 9766 || (c < 9774
                    ? c == 9770
                    : c <= 9775)))
                : (c <= 9786 || (c < 9800
                  ? (c < 9794
                    ? c == 9792
                    : c <= 9794)
                  : (c <= 9811 || (c < 9827
                    ? (c >= 9823 && c <= 9824)
                    : c <= 9827)))))))))))
        : (c <= 9830 || (c < 11506
          ? (c < 10002
            ? (c < 9928
              ? (c < 9888
                ? (c < 9874
                  ? (c < 9851
                    ? c == 9832
                    : (c <= 9851 || (c >= 9854 && c <= 9855)))
                  : (c <= 9879 || (c < 9883
                    ? c == 9881
                    : c <= 9884)))
                : (c <= 9889 || (c < 9904
                  ? (c < 9898
                    ? c == 9895
                    : c <= 9899)
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))
              : (c <= 9928 || (c < 9975
                ? (c < 9939
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : c <= 9937)
                  : (c <= 9940 || (c < 9968
                    ? (c >= 9961 && c <= 9962)
                    : c <= 9973)))
                : (c <= 9978 || (c < 9989
                  ? (c < 9986
                    ? c == 9981
                    : c <= 9986)
                  : (c <= 9989 || (c < 9999
                    ? (c >= 9992 && c <= 9997)
                    : c <= 9999)))))))
            : (c <= 10002 || (c < 10083
              ? (c < 10052
                ? (c < 10017
                  ? (c < 10006
                    ? c == 10004
                    : (c <= 10006 || c == 10013))
                  : (c <= 10017 || (c < 10035
                    ? c == 10024
                    : c <= 10036)))
                : (c <= 10052 || (c < 10062
                  ? (c < 10060
                    ? c == 10055
                    : c <= 10060)
                  : (c <= 10062 || (c < 10071
                    ? (c >= 10067 && c <= 10069)
                    : c <= 10071)))))
              : (c <= 10084 || (c < 11013
                ? (c < 10160
                  ? (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)
                  : (c <= 10160 || (c < 10548
                    ? c == 10175
                    : c <= 10549)))
                : (c <= 11015 || (c < 11093
                  ? (c < 11088
                    ? (c >= 11035 && c <= 11036)
                    : c <= 11088)
                  : (c <= 11093 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)))))))))
          : (c <= 11507 || (c < 12704
            ? (c < 11728
              ? (c < 11680
                ? (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11648
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))
              : (c <= 11734 || (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12336 && c <= 12341)
                    : c <= 12349)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)))))))
            : (c <= 12735 || (c < 42775
              ? (c < 42240
                ? (c < 13312
                  ? (c < 12951
                    ? (c >= 12784 && c <= 12799)
                    : (c <= 12951 || c == 12953))
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)))))
              : (c <= 42783 || (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)))))))))))))))
    : (c <= 43255 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43588
              ? (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43262 || (c >= 43274 && c <= 43301)))
                  : (c <= 43334 || (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)))
                : (c <= 43471 || (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))))
              : (c <= 43595 || (c < 43712
                ? (c < 43697
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : (c <= 43642 || (c >= 43646 && c <= 43695)))
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_3(int32_t c) {
  return (c < 43250
    ? (c < 5984
      ? (c < 2947
        ? (c < 2160
          ? (c < 1369
            ? (c < 750
              ? (c < 192
                ? (c < 174
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : (c <= 'z' || (c >= 169 && c <= 170)))
                  : (c <= 174 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))))
              : (c <= 750 || (c < 908
                ? (c < 895
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : (c <= 887 || (c >= 891 && c <= 893)))
                  : (c <= 895 || (c < 904
                    ? c == 902
                    : c <= 906)))
                : (c <= 908 || (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))))))
            : (c <= 1369 || (c < 1810
              ? (c < 1749
                ? (c < 1568
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1610 || (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1808)))))
              : (c <= 1839 || (c < 2048
                ? (c < 1994
                  ? (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)
                  : (c <= 2026 || (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)))
                : (c <= 2069 || (c < 2088
                  ? (c < 2084
                    ? c == 2074
                    : c <= 2084)
                  : (c <= 2088 || (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)))))))))
          : (c <= 2183 || (c < 2613
            ? (c < 2486
              ? (c < 2417
                ? (c < 2365
                  ? (c < 2208
                    ? (c >= 2185 && c <= 2190)
                    : (c <= 2249 || (c >= 2308 && c <= 2361)))
                  : (c <= 2365 || (c < 2392
                    ? c == 2384
                    : c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))))
              : (c <= 2489 || (c < 2556
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)))
                : (c <= 2556 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))))))
            : (c <= 2614 || (c < 2784
              ? (c < 2707
                ? (c < 2674
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : (c <= 2652 || c == 2654))
                  : (c <= 2676 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))
                : (c <= 2728 || (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))))
              : (c <= 2785 || (c < 2866
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)))))))))))
        : (c <= 2947 || (c < 3751
          ? (c < 3261
            ? (c < 3090
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : (c <= 2960 || (c >= 2962 && c <= 2965)))
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)))))
              : (c <= 3112 || (c < 3200
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))))
            : (c <= 3261 || (c < 3482
              ? (c < 3389
                ? (c < 3332
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : (c <= 3297 || (c >= 3313 && c <= 3314)))
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)))
                : (c <= 3389 || (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)))))
              : (c <= 3505 || (c < 3648
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)))
                : (c <= 3654 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))
          : (c <= 3760 || (c < 4688
            ? (c < 4186
              ? (c < 3904
                ? (c < 3782
                  ? (c < 3773
                    ? c == 3762
                    : (c <= 3773 || (c >= 3776 && c <= 3780)))
                  : (c <= 3782 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3911 || (c < 4096
                  ? (c < 3976
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3980)
                  : (c <= 4138 || (c < 4176
                    ? c == 4159
                    : c <= 4181)))))
              : (c <= 4189 || (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4698
                    ? c == 4696
                    : (c <= 4701 || (c >= 4704 && c <= 4744)))
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5761
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)))))))))))))
      : (c <= 5996 || (c < 9829
        ? (c < 8178
          ? (c < 7296
            ? (c < 6576
              ? (c < 6314
                ? (c < 6108
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : (c <= 6067 || c == 6103))
                  : (c <= 6108 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)))
                : (c <= 6314 || (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))))
              : (c <= 6601 || (c < 7043
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)))))))
            : (c <= 7304 || (c < 8025
              ? (c < 7424
                ? (c < 7406
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : (c <= 7359 || (c >= 7401 && c <= 7404)))
                  : (c <= 7411 || (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))
              : (c <= 8025 || (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))))))
          : (c <= 8180 || (c < 9167
            ? (c < 8484
              ? (c < 8450
                ? (c < 8305
                  ? (c < 8252
                    ? (c >= 8182 && c <= 8188)
                    : (c <= 8252 || c == 8265))
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8450 || (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))))
              : (c <= 8484 || (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 8617
                  ? (c < 8596
                    ? (c >= 8544 && c <= 8584)
                    : c <= 8601)
                  : (c <= 8618 || (c < 9000
                    ? (c >= 8986 && c <= 8987)
                    : c <= 9000)))))))
            : (c <= 9167 || (c < 9757
              ? (c < 9723
                ? (c < 9642
                  ? (c < 9208
                    ? (c >= 9193 && c <= 9203)
                    : (c <= 9210 || c == 9410))
                  : (c <= 9643 || (c < 9664
                    ? c == 9654
                    : c <= 9664)))
                : (c <= 9726 || (c < 9745
                  ? (c < 9742
                    ? (c >= 9728 && c <= 9732)
                    : c <= 9742)
                  : (c <= 9745 || (c < 9752
                    ? (c >= 9748 && c <= 9749)
                    : c <= 9752)))))
              : (c <= 9757 || (c < 9784
                ? (c < 9766
                  ? (c < 9762
                    ? c == 9760
                    : c <= 9763)
                  : (c <= 9766 || (c < 9774
                    ? c == 9770
                    : c <= 9775)))
                : (c <= 9786 || (c < 9800
                  ? (c < 9794
                    ? c == 9792
                    : c <= 9794)
                  : (c <= 9811 || (c < 9827
                    ? (c >= 9823 && c <= 9824)
                    : c <= 9827)))))))))))
        : (c <= 9830 || (c < 11506
          ? (c < 10002
            ? (c < 9928
              ? (c < 9888
                ? (c < 9874
                  ? (c < 9851
                    ? c == 9832
                    : (c <= 9851 || (c >= 9854 && c <= 9855)))
                  : (c <= 9879 || (c < 9883
                    ? c == 9881
                    : c <= 9884)))
                : (c <= 9889 || (c < 9904
                  ? (c < 9898
                    ? c == 9895
                    : c <= 9899)
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))
              : (c <= 9928 || (c < 9975
                ? (c < 9939
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : c <= 9937)
                  : (c <= 9940 || (c < 9968
                    ? (c >= 9961 && c <= 9962)
                    : c <= 9973)))
                : (c <= 9978 || (c < 9989
                  ? (c < 9986
                    ? c == 9981
                    : c <= 9986)
                  : (c <= 9989 || (c < 9999
                    ? (c >= 9992 && c <= 9997)
                    : c <= 9999)))))))
            : (c <= 10002 || (c < 10083
              ? (c < 10052
                ? (c < 10017
                  ? (c < 10006
                    ? c == 10004
                    : (c <= 10006 || c == 10013))
                  : (c <= 10017 || (c < 10035
                    ? c == 10024
                    : c <= 10036)))
                : (c <= 10052 || (c < 10062
                  ? (c < 10060
                    ? c == 10055
                    : c <= 10060)
                  : (c <= 10062 || (c < 10071
                    ? (c >= 10067 && c <= 10069)
                    : c <= 10071)))))
              : (c <= 10084 || (c < 11013
                ? (c < 10160
                  ? (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)
                  : (c <= 10160 || (c < 10548
                    ? c == 10175
                    : c <= 10549)))
                : (c <= 11015 || (c < 11093
                  ? (c < 11088
                    ? (c >= 11035 && c <= 11036)
                    : c <= 11088)
                  : (c <= 11093 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)))))))))
          : (c <= 11507 || (c < 12704
            ? (c < 11728
              ? (c < 11680
                ? (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11648
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))
              : (c <= 11734 || (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12336 && c <= 12341)
                    : c <= 12349)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)))))))
            : (c <= 12735 || (c < 42775
              ? (c < 42240
                ? (c < 13312
                  ? (c < 12951
                    ? (c >= 12784 && c <= 12799)
                    : (c <= 12951 || c == 12953))
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)))))
              : (c <= 42783 || (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)))))))))))))))
    : (c <= 43255 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43588
              ? (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43262 || (c >= 43274 && c <= 43301)))
                  : (c <= 43334 || (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)))
                : (c <= 43471 || (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))))
              : (c <= 43595 || (c < 43712
                ? (c < 43697
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : (c <= 43642 || (c >= 43646 && c <= 43695)))
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_4(int32_t c) {
  return (c < 43259
    ? (c < 5998
      ? (c < 2949
        ? (c < 2185
          ? (c < 1376
            ? (c < 886
              ? (c < 248
                ? (c < 186
                  ? (c < 174
                    ? (c >= 169 && c <= 170)
                    : (c <= 174 || c == 181))
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))
                : (c <= 705 || (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 880
                    ? c == 750
                    : c <= 884)))))
              : (c <= 887 || (c < 910
                ? (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))))))
            : (c <= 1416 || (c < 1869
              ? (c < 1765
                ? (c < 1646
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : (c <= 1522 || (c >= 1568 && c <= 1610)))
                  : (c <= 1647 || (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)))
                : (c <= 1766 || (c < 1791
                  ? (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1810
                    ? c == 1808
                    : c <= 1839)))))
              : (c <= 1957 || (c < 2074
                ? (c < 2036
                  ? (c < 1994
                    ? c == 1969
                    : c <= 2026)
                  : (c <= 2037 || (c < 2048
                    ? c == 2042
                    : c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))))))))
          : (c <= 2190 || (c < 2616
            ? (c < 2493
              ? (c < 2437
                ? (c < 2384
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : (c <= 2361 || c == 2365))
                  : (c <= 2384 || (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))))
              : (c <= 2493 || (c < 2565
                ? (c < 2527
                  ? (c < 2524
                    ? c == 2510
                    : c <= 2525)
                  : (c <= 2529 || (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)))
                : (c <= 2570 || (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)))))))
            : (c <= 2617 || (c < 2809
              ? (c < 2730
                ? (c < 2693
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : (c <= 2654 || (c >= 2674 && c <= 2676)))
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))
                : (c <= 2736 || (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || (c < 2784
                    ? c == 2768
                    : c <= 2785)))))
              : (c <= 2809 || (c < 2869
                ? (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))
                : (c <= 2873 || (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || (c < 2947
                    ? c == 2929
                    : c <= 2947)))))))))))
        : (c <= 2954 || (c < 3762
          ? (c < 3293
            ? (c < 3114
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))))
              : (c <= 3129 || (c < 3205
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)))))))
            : (c <= 3294 || (c < 3507
              ? (c < 3406
                ? (c < 3342
                  ? (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : (c <= 3314 || (c >= 3332 && c <= 3340)))
                  : (c <= 3344 || (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)))
                : (c <= 3406 || (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))))
              : (c <= 3515 || (c < 3713
                ? (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || (c < 3648
                    ? c == 3634
                    : c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3760)))))))))
          : (c <= 3762 || (c < 4696
            ? (c < 4193
              ? (c < 3913
                ? (c < 3804
                  ? (c < 3776
                    ? c == 3773
                    : (c <= 3780 || c == 3782))
                  : (c <= 3807 || (c < 3904
                    ? c == 3840
                    : c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)))))
              : (c <= 4193 || (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4992
              ? (c < 4800
                ? (c < 4752
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : (c <= 4744 || (c >= 4746 && c <= 4749)))
                  : (c <= 4784 || (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)))
                : (c <= 4800 || (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)))))
              : (c <= 5007 || (c < 5792
                ? (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)))
                : (c <= 5866 || (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c < 5984
                    ? (c >= 5952 && c <= 5969)
                    : c <= 5996)))))))))))))
      : (c <= 6000 || (c < 9832
        ? (c < 8182
          ? (c < 7312
            ? (c < 6656
              ? (c < 6320
                ? (c < 6176
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : (c <= 6103 || c == 6108))
                  : (c <= 6264 || (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))))
              : (c <= 6678 || (c < 7086
                ? (c < 6917
                  ? (c < 6823
                    ? (c >= 6688 && c <= 6740)
                    : c <= 6823)
                  : (c <= 6963 || (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)))))))
            : (c <= 7354 || (c < 8027
              ? (c < 7680
                ? (c < 7413
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : (c <= 7404 || (c >= 7406 && c <= 7411)))
                  : (c <= 7414 || (c < 7424
                    ? c == 7418
                    : c <= 7615)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))
              : (c <= 8027 || (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))))))
          : (c <= 8188 || (c < 9193
            ? (c < 8486
              ? (c < 8455
                ? (c < 8319
                  ? (c < 8265
                    ? c == 8252
                    : (c <= 8265 || c == 8305))
                  : (c <= 8319 || (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)))
                : (c <= 8455 || (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || (c < 8484
                    ? c == 8482
                    : c <= 8484)))))
              : (c <= 8486 || (c < 8544
                ? (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))
                : (c <= 8584 || (c < 8986
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : c <= 8618)
                  : (c <= 8987 || (c < 9167
                    ? c == 9000
                    : c <= 9167)))))))
            : (c <= 9203 || (c < 9760
              ? (c < 9728
                ? (c < 9654
                  ? (c < 9410
                    ? (c >= 9208 && c <= 9210)
                    : (c <= 9410 || (c >= 9642 && c <= 9643)))
                  : (c <= 9654 || (c < 9723
                    ? c == 9664
                    : c <= 9726)))
                : (c <= 9732 || (c < 9748
                  ? (c < 9745
                    ? c == 9742
                    : c <= 9745)
                  : (c <= 9749 || (c < 9757
                    ? c == 9752
                    : c <= 9757)))))
              : (c <= 9760 || (c < 9792
                ? (c < 9770
                  ? (c < 9766
                    ? (c >= 9762 && c <= 9763)
                    : c <= 9766)
                  : (c <= 9770 || (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : c <= 9786)))
                : (c <= 9792 || (c < 9823
                  ? (c < 9800
                    ? c == 9794
                    : c <= 9811)
                  : (c <= 9824 || (c < 9829
                    ? c == 9827
                    : c <= 9830)))))))))))
        : (c <= 9832 || (c < 11520
          ? (c < 10004
            ? (c < 9934
              ? (c < 9895
                ? (c < 9881
                  ? (c < 9854
                    ? c == 9851
                    : (c <= 9855 || (c >= 9874 && c <= 9879)))
                  : (c <= 9881 || (c < 9888
                    ? (c >= 9883 && c <= 9884)
                    : c <= 9889)))
                : (c <= 9895 || (c < 9917
                  ? (c < 9904
                    ? (c >= 9898 && c <= 9899)
                    : c <= 9905)
                  : (c <= 9918 || (c < 9928
                    ? (c >= 9924 && c <= 9925)
                    : c <= 9928)))))
              : (c <= 9935 || (c < 9981
                ? (c < 9961
                  ? (c < 9939
                    ? c == 9937
                    : c <= 9940)
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9992
                  ? (c < 9989
                    ? c == 9986
                    : c <= 9989)
                  : (c <= 9997 || (c < 10002
                    ? c == 9999
                    : c <= 10002)))))))
            : (c <= 10004 || (c < 10133
              ? (c < 10055
                ? (c < 10024
                  ? (c < 10013
                    ? c == 10006
                    : (c <= 10013 || c == 10017))
                  : (c <= 10024 || (c < 10052
                    ? (c >= 10035 && c <= 10036)
                    : c <= 10052)))
                : (c <= 10055 || (c < 10067
                  ? (c < 10062
                    ? c == 10060
                    : c <= 10062)
                  : (c <= 10069 || (c < 10083
                    ? c == 10071
                    : c <= 10084)))))
              : (c <= 10135 || (c < 11035
                ? (c < 10175
                  ? (c < 10160
                    ? c == 10145
                    : c <= 10160)
                  : (c <= 10175 || (c < 11013
                    ? (c >= 10548 && c <= 10549)
                    : c <= 11015)))
                : (c <= 11036 || (c < 11264
                  ? (c < 11093
                    ? c == 11088
                    : c <= 11093)
                  : (c <= 11492 || (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)))))))))
          : (c <= 11557 || (c < 12784
            ? (c < 11736
              ? (c < 11688
                ? (c < 11631
                  ? (c < 11565
                    ? c == 11559
                    : (c <= 11565 || (c >= 11568 && c <= 11623)))
                  : (c <= 11631 || (c < 11680
                    ? (c >= 11648 && c <= 11670)
                    : c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))))
              : (c <= 11742 || (c < 12445
                ? (c < 12336
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12349)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)))))))
            : (c <= 12799 || (c < 42786
              ? (c < 42512
                ? (c < 19968
                  ? (c < 12953
                    ? c == 12951
                    : (c <= 12953 || (c >= 13312 && c <= 19903)))
                  : (c <= 42124 || (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)))
                : (c <= 42527 || (c < 42623
                  ? (c < 42560
                    ? (c >= 42538 && c <= 42539)
                    : c <= 42606)
                  : (c <= 42653 || (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)))))
              : (c <= 42888 || (c < 43011
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c < 43250
                    ? (c >= 43138 && c <= 43187)
                    : c <= 43255)))))))))))))))
    : (c <= 43259 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43616
              ? (c < 43488
                ? (c < 43360
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : (c <= 43301 || (c >= 43312 && c <= 43334)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)))
                : (c <= 43492 || (c < 43520
                  ? (c < 43514
                    ? (c >= 43494 && c <= 43503)
                    : c <= 43518)
                  : (c <= 43560 || (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)))))
              : (c <= 43638 || (c < 43712
                ? (c < 43697
                  ? (c < 43646
                    ? c == 43642
                    : c <= 43695)
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_5(int32_t c) {
  return (c < 43250
    ? (c < 5984
      ? (c < 2947
        ? (c < 2160
          ? (c < 1369
            ? (c < 750
              ? (c < 192
                ? (c < 174
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : (c <= 'z' || (c >= 169 && c <= 170)))
                  : (c <= 174 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)))))
              : (c <= 750 || (c < 908
                ? (c < 895
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : (c <= 887 || (c >= 891 && c <= 893)))
                  : (c <= 895 || (c < 904
                    ? c == 902
                    : c <= 906)))
                : (c <= 908 || (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))))))
            : (c <= 1369 || (c < 1810
              ? (c < 1749
                ? (c < 1568
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1610 || (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)))
                : (c <= 1749 || (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || (c < 1808
                    ? c == 1791
                    : c <= 1808)))))
              : (c <= 1839 || (c < 2048
                ? (c < 1994
                  ? (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)
                  : (c <= 2026 || (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)))
                : (c <= 2069 || (c < 2088
                  ? (c < 2084
                    ? c == 2074
                    : c <= 2084)
                  : (c <= 2088 || (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)))))))))
          : (c <= 2183 || (c < 2613
            ? (c < 2486
              ? (c < 2417
                ? (c < 2365
                  ? (c < 2208
                    ? (c >= 2185 && c <= 2190)
                    : (c <= 2249 || (c >= 2308 && c <= 2361)))
                  : (c <= 2365 || (c < 2392
                    ? c == 2384
                    : c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)))))
              : (c <= 2489 || (c < 2556
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)))
                : (c <= 2556 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))))))
            : (c <= 2614 || (c < 2784
              ? (c < 2707
                ? (c < 2674
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : (c <= 2652 || c == 2654))
                  : (c <= 2676 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))
                : (c <= 2728 || (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))))
              : (c <= 2785 || (c < 2866
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))
                : (c <= 2867 || (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)))))))))))
        : (c <= 2947 || (c < 3751
          ? (c < 3261
            ? (c < 3090
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : (c <= 2960 || (c >= 2962 && c <= 2965)))
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)))))
              : (c <= 3112 || (c < 3200
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))))))
            : (c <= 3261 || (c < 3482
              ? (c < 3389
                ? (c < 3332
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : (c <= 3297 || (c >= 3313 && c <= 3314)))
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)))
                : (c <= 3389 || (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)))))
              : (c <= 3505 || (c < 3648
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)))
                : (c <= 3654 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))))))))
          : (c <= 3760 || (c < 4688
            ? (c < 4186
              ? (c < 3904
                ? (c < 3782
                  ? (c < 3773
                    ? c == 3762
                    : (c <= 3773 || (c >= 3776 && c <= 3780)))
                  : (c <= 3782 || (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)))
                : (c <= 3911 || (c < 4096
                  ? (c < 3976
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3980)
                  : (c <= 4138 || (c < 4176
                    ? c == 4159
                    : c <= 4181)))))
              : (c <= 4189 || (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4698
                    ? c == 4696
                    : (c <= 4701 || (c >= 4704 && c <= 4744)))
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5761
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)))))))))))))
      : (c <= 5996 || (c < 9829
        ? (c < 8178
          ? (c < 7296
            ? (c < 6576
              ? (c < 6314
                ? (c < 6108
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : (c <= 6067 || c == 6103))
                  : (c <= 6108 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)))
                : (c <= 6314 || (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))))
              : (c <= 6601 || (c < 7043
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)))))))
            : (c <= 7304 || (c < 8025
              ? (c < 7424
                ? (c < 7406
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : (c <= 7359 || (c >= 7401 && c <= 7404)))
                  : (c <= 7411 || (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))
              : (c <= 8025 || (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))))))
          : (c <= 8180 || (c < 9167
            ? (c < 8484
              ? (c < 8450
                ? (c < 8305
                  ? (c < 8252
                    ? (c >= 8182 && c <= 8188)
                    : (c <= 8252 || c == 8265))
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8450 || (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))))
              : (c <= 8484 || (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 8617
                  ? (c < 8596
                    ? (c >= 8544 && c <= 8584)
                    : c <= 8601)
                  : (c <= 8618 || (c < 9000
                    ? (c >= 8986 && c <= 8987)
                    : c <= 9000)))))))
            : (c <= 9167 || (c < 9757
              ? (c < 9723
                ? (c < 9642
                  ? (c < 9208
                    ? (c >= 9193 && c <= 9203)
                    : (c <= 9210 || c == 9410))
                  : (c <= 9643 || (c < 9664
                    ? c == 9654
                    : c <= 9664)))
                : (c <= 9726 || (c < 9745
                  ? (c < 9742
                    ? (c >= 9728 && c <= 9732)
                    : c <= 9742)
                  : (c <= 9745 || (c < 9752
                    ? (c >= 9748 && c <= 9749)
                    : c <= 9752)))))
              : (c <= 9757 || (c < 9784
                ? (c < 9766
                  ? (c < 9762
                    ? c == 9760
                    : c <= 9763)
                  : (c <= 9766 || (c < 9774
                    ? c == 9770
                    : c <= 9775)))
                : (c <= 9786 || (c < 9800
                  ? (c < 9794
                    ? c == 9792
                    : c <= 9794)
                  : (c <= 9811 || (c < 9827
                    ? (c >= 9823 && c <= 9824)
                    : c <= 9827)))))))))))
        : (c <= 9830 || (c < 11506
          ? (c < 10002
            ? (c < 9928
              ? (c < 9888
                ? (c < 9874
                  ? (c < 9851
                    ? c == 9832
                    : (c <= 9851 || (c >= 9854 && c <= 9855)))
                  : (c <= 9879 || (c < 9883
                    ? c == 9881
                    : c <= 9884)))
                : (c <= 9889 || (c < 9904
                  ? (c < 9898
                    ? c == 9895
                    : c <= 9899)
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))
              : (c <= 9928 || (c < 9975
                ? (c < 9939
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : c <= 9937)
                  : (c <= 9940 || (c < 9968
                    ? (c >= 9961 && c <= 9962)
                    : c <= 9973)))
                : (c <= 9978 || (c < 9989
                  ? (c < 9986
                    ? c == 9981
                    : c <= 9986)
                  : (c <= 9989 || (c < 9999
                    ? (c >= 9992 && c <= 9997)
                    : c <= 9999)))))))
            : (c <= 10002 || (c < 10083
              ? (c < 10052
                ? (c < 10017
                  ? (c < 10006
                    ? c == 10004
                    : (c <= 10006 || c == 10013))
                  : (c <= 10017 || (c < 10035
                    ? c == 10024
                    : c <= 10036)))
                : (c <= 10052 || (c < 10062
                  ? (c < 10060
                    ? c == 10055
                    : c <= 10060)
                  : (c <= 10062 || (c < 10071
                    ? (c >= 10067 && c <= 10069)
                    : c <= 10071)))))
              : (c <= 10084 || (c < 11013
                ? (c < 10160
                  ? (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)
                  : (c <= 10160 || (c < 10548
                    ? c == 10175
                    : c <= 10549)))
                : (c <= 11015 || (c < 11093
                  ? (c < 11088
                    ? (c >= 11035 && c <= 11036)
                    : c <= 11088)
                  : (c <= 11093 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)))))))))
          : (c <= 11507 || (c < 12704
            ? (c < 11728
              ? (c < 11680
                ? (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11648
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))
              : (c <= 11734 || (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12336 && c <= 12341)
                    : c <= 12349)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)))))))
            : (c <= 12735 || (c < 42775
              ? (c < 42240
                ? (c < 13312
                  ? (c < 12951
                    ? (c >= 12784 && c <= 12799)
                    : (c <= 12951 || c == 12953))
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)))))
              : (c <= 42783 || (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)))))))))))))))
    : (c <= 43255 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43588
              ? (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43262 || (c >= 43274 && c <= 43301)))
                  : (c <= 43334 || (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)))
                : (c <= 43471 || (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))))
              : (c <= 43595 || (c < 43712
                ? (c < 43697
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : (c <= 43642 || (c >= 43646 && c <= 43695)))
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_6(int32_t c) {
  return (c < 43232
    ? (c < 4808
      ? (c < 2887
        ? (c < 2200
          ? (c < 1162
            ? (c < 710
              ? (c < 174
                ? (c < 'A'
                  ? (c < '*'
                    ? c == '#'
                    : (c <= '*' || (c >= '0' && c <= '9')))
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : (c <= 'z' || (c >= 169 && c <= 170)))))
                : (c <= 174 || (c < 192
                  ? (c < 183
                    ? c == 181
                    : (c <= 183 || c == 186))
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 895
                ? (c < 768
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : (c <= 748 || c == 750))
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 931
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : (c <= 908 || (c >= 910 && c <= 929)))
                  : (c <= 1013 || (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)))))))
            : (c <= 1327 || (c < 1749
              ? (c < 1476
                ? (c < 1425
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : (c <= 1369 || (c >= 1376 && c <= 1416)))
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))
                : (c <= 1477 || (c < 1552
                  ? (c < 1488
                    ? c == 1479
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 2042
                ? (c < 1808
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : (c <= 1788 || c == 1791))
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2144
                  ? (c < 2048
                    ? c == 2045
                    : (c <= 2093 || (c >= 2112 && c <= 2139)))
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))))))))
          : (c <= 2273 || (c < 2631
            ? (c < 2527
              ? (c < 2482
                ? (c < 2437
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : (c <= 2415 || (c >= 2417 && c <= 2435)))
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : (c <= 2472 || (c >= 2474 && c <= 2480)))))
                : (c <= 2482 || (c < 2507
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : (c <= 2500 || (c >= 2503 && c <= 2504)))
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))
              : (c <= 2531 || (c < 2579
                ? (c < 2561
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : (c <= 2556 || c == 2558))
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2616
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : (c <= 2611 || (c >= 2613 && c <= 2614)))
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))))
            : (c <= 2632 || (c < 2759
              ? (c < 2693
                ? (c < 2654
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : (c <= 2641 || (c >= 2649 && c <= 2652)))
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2738
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : (c <= 2728 || (c >= 2730 && c <= 2736)))
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))
              : (c <= 2761 || (c < 2821
                ? (c < 2790
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : (c <= 2768 || (c >= 2784 && c <= 2787)))
                  : (c <= 2799 || (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)))
                : (c <= 2828 || (c < 2866
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : (c <= 2856 || (c >= 2858 && c <= 2864)))
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))))))))
        : (c <= 2888 || (c < 3450
          ? (c < 3146
            ? (c < 2984
              ? (c < 2949
                ? (c < 2911
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : (c <= 2903 || (c >= 2908 && c <= 2909)))
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : (c <= 2929 || (c >= 2946 && c <= 2947)))))
                : (c <= 2954 || (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))))
              : (c <= 2986 || (c < 3046
                ? (c < 3018
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : (c <= 3010 || (c >= 3014 && c <= 3016)))
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))
                : (c <= 3055 || (c < 3114
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : (c <= 3088 || (c >= 3090 && c <= 3112)))
                  : (c <= 3129 || (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)))))))
            : (c <= 3149 || (c < 3274
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : (c <= 3162 || c == 3165))
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3253
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : (c <= 3240 || (c >= 3242 && c <= 3251)))
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3342
                ? (c < 3302
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : (c <= 3294 || (c >= 3296 && c <= 3299)))
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3412
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : (c <= 3400 || (c >= 3402 && c <= 3406)))
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))))
          : (c <= 3455 || (c < 3872
            ? (c < 3664
              ? (c < 3535
                ? (c < 3507
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : (c <= 3478 || (c >= 3482 && c <= 3505)))
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : (c <= 3526 || c == 3530))))
                : (c <= 3540 || (c < 3570
                  ? (c < 3544
                    ? c == 3542
                    : (c <= 3551 || (c >= 3558 && c <= 3567)))
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3776
                ? (c < 3724
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : (c <= 3716 || (c >= 3718 && c <= 3722)))
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))
                : (c <= 3780 || (c < 3804
                  ? (c < 3784
                    ? c == 3782
                    : (c <= 3789 || (c >= 3792 && c <= 3801)))
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))))))
            : (c <= 3881 || (c < 4301
              ? (c < 3974
                ? (c < 3902
                  ? (c < 3895
                    ? c == 3893
                    : (c <= 3895 || c == 3897))
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4176
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : (c <= 4038 || (c >= 4096 && c <= 4169)))
                  : (c <= 4253 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))))
              : (c <= 4301 || (c < 4704
                ? (c < 4688
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : (c <= 4680 || (c >= 4682 && c <= 4685)))
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4792
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : (c <= 4784 || (c >= 4786 && c <= 4789)))
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))))))))))
      : (c <= 4822 || (c < 9742
        ? (c < 7424
          ? (c < 6400
            ? (c < 5919
              ? (c < 5112
                ? (c < 4957
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : (c <= 4885 || (c >= 4888 && c <= 4954)))
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : (c <= 5007 || (c >= 5024 && c <= 5109)))))
                : (c <= 5117 || (c < 5792
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : (c <= 5759 || (c >= 5761 && c <= 5786)))
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))
              : (c <= 5940 || (c < 6108
                ? (c < 6002
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : (c <= 5996 || (c >= 5998 && c <= 6000)))
                  : (c <= 6003 || (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)))
                : (c <= 6109 || (c < 6176
                  ? (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : (c <= 6157 || (c >= 6159 && c <= 6169)))
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))))
            : (c <= 6430 || (c < 6832
              ? (c < 6608
                ? (c < 6512
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : (c <= 6459 || (c >= 6470 && c <= 6509)))
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))
                : (c <= 6618 || (c < 6783
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : (c <= 6750 || (c >= 6752 && c <= 6780)))
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))))
              : (c <= 6845 || (c < 7232
                ? (c < 7019
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : (c <= 6988 || (c >= 6992 && c <= 7001)))
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))
                : (c <= 7241 || (c < 7357
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : (c <= 7304 || (c >= 7312 && c <= 7354)))
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))))))))
          : (c <= 7957 || (c < 8421
            ? (c < 8150
              ? (c < 8031
                ? (c < 8016
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : (c <= 8005 || (c >= 8008 && c <= 8013)))
                  : (c <= 8023 || (c < 8027
                    ? c == 8025
                    : (c <= 8027 || c == 8029))))
                : (c <= 8061 || (c < 8130
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : (c <= 8124 || c == 8126))
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8265
                ? (c < 8205
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : (c <= 8180 || (c >= 8182 && c <= 8188)))
                  : (c <= 8205 || (c < 8255
                    ? c == 8252
                    : c <= 8256)))
                : (c <= 8265 || (c < 8336
                  ? (c < 8305
                    ? c == 8276
                    : (c <= 8305 || c == 8319))
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))))))
            : (c <= 8432 || (c < 8544
              ? (c < 8484
                ? (c < 8469
                  ? (c < 8455
                    ? c == 8450
                    : (c <= 8455 || (c >= 8458 && c <= 8467)))
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))
                : (c <= 8484 || (c < 8508
                  ? (c < 8488
                    ? c == 8486
                    : (c <= 8488 || (c >= 8490 && c <= 8505)))
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 9208
                ? (c < 9000
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : (c <= 8618 || (c >= 8986 && c <= 8987)))
                  : (c <= 9000 || (c < 9193
                    ? c == 9167
                    : c <= 9203)))
                : (c <= 9210 || (c < 9664
                  ? (c < 9642
                    ? c == 9410
                    : (c <= 9643 || c == 9654))
                  : (c <= 9664 || (c < 9728
                    ? (c >= 9723 && c <= 9726)
                    : c <= 9732)))))))))))
        : (c <= 9742 || (c < 10160
          ? (c < 9928
            ? (c < 9827
              ? (c < 9770
                ? (c < 9757
                  ? (c < 9748
                    ? c == 9745
                    : (c <= 9749 || c == 9752))
                  : (c <= 9757 || (c < 9762
                    ? c == 9760
                    : (c <= 9763 || c == 9766))))
                : (c <= 9770 || (c < 9794
                  ? (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : (c <= 9786 || c == 9792))
                  : (c <= 9794 || (c < 9823
                    ? (c >= 9800 && c <= 9811)
                    : c <= 9824)))))
              : (c <= 9827 || (c < 9883
                ? (c < 9854
                  ? (c < 9832
                    ? (c >= 9829 && c <= 9830)
                    : (c <= 9832 || c == 9851))
                  : (c <= 9855 || (c < 9881
                    ? (c >= 9874 && c <= 9879)
                    : c <= 9881)))
                : (c <= 9884 || (c < 9904
                  ? (c < 9895
                    ? (c >= 9888 && c <= 9889)
                    : (c <= 9895 || (c >= 9898 && c <= 9899)))
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))))
            : (c <= 9928 || (c < 10006
              ? (c < 9981
                ? (c < 9961
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : (c <= 9937 || (c >= 9939 && c <= 9940)))
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9999
                  ? (c < 9989
                    ? c == 9986
                    : (c <= 9989 || (c >= 9992 && c <= 9997)))
                  : (c <= 9999 || (c < 10004
                    ? c == 10002
                    : c <= 10004)))))
              : (c <= 10006 || (c < 10060
                ? (c < 10035
                  ? (c < 10017
                    ? c == 10013
                    : (c <= 10017 || c == 10024))
                  : (c <= 10036 || (c < 10055
                    ? c == 10052
                    : c <= 10055)))
                : (c <= 10060 || (c < 10083
                  ? (c < 10067
                    ? c == 10062
                    : (c <= 10069 || c == 10071))
                  : (c <= 10084 || (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)))))))))
          : (c <= 10160 || (c < 12445
            ? (c < 11680
              ? (c < 11499
                ? (c < 11035
                  ? (c < 10548
                    ? c == 10175
                    : (c <= 10549 || (c >= 11013 && c <= 11015)))
                  : (c <= 11036 || (c < 11093
                    ? c == 11088
                    : (c <= 11093 || (c >= 11264 && c <= 11492)))))
                : (c <= 11507 || (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))))
              : (c <= 11686 || (c < 11736
                ? (c < 11712
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : (c <= 11702 || (c >= 11704 && c <= 11710)))
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))
                : (c <= 11742 || (c < 12344
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : (c <= 12295 || (c >= 12321 && c <= 12341)))
                  : (c <= 12349 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))))
            : (c <= 12447 || (c < 42560
              ? (c < 12951
                ? (c < 12593
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : (c <= 12543 || (c >= 12549 && c <= 12591)))
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 12951 || (c < 42192
                  ? (c < 13312
                    ? c == 12953
                    : (c <= 19903 || (c >= 19968 && c <= 42124)))
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))
              : (c <= 42607 || (c < 42963
                ? (c < 42786
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : (c <= 42737 || (c >= 42775 && c <= 42783)))
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43072
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : (c <= 43047 || c == 43052))
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))))))))))))
    : (c <= 43255 || (c < 72818
      ? (c < 67840
        ? (c < 65313
          ? (c < 63744
            ? (c < 43762
              ? (c < 43520
                ? (c < 43360
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43309 || (c >= 43312 && c <= 43347)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : (c <= 43481 || (c >= 43488 && c <= 43518)))))
                : (c <= 43574 || (c < 43642
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : (c <= 43609 || (c >= 43616 && c <= 43638)))
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))))
              : (c <= 43766 || (c < 43868
                ? (c < 43808
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : (c <= 43790 || (c >= 43793 && c <= 43798)))
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : (c <= 44013 || (c >= 44016 && c <= 44025)))
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))))))
            : (c <= 64109 || (c < 64914
              ? (c < 64318
                ? (c < 64285
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : (c <= 64262 || (c >= 64275 && c <= 64279)))
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))
                : (c <= 64318 || (c < 64467
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : (c <= 64324 || (c >= 64326 && c <= 64433)))
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))
              : (c <= 64967 || (c < 65139
                ? (c < 65075
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65038 || (c >= 65056 && c <= 65071)))
                  : (c <= 65076 || (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65149
                  ? (c < 65145
                    ? c == 65143
                    : (c <= 65145 || c == 65147))
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66736
            ? (c < 65856
              ? (c < 65536
                ? (c < 65474
                  ? (c < 65345
                    ? c == 65343
                    : (c <= 65370 || (c >= 65382 && c <= 65470)))
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : (c <= 65495 || (c >= 65498 && c <= 65500)))))
                : (c <= 65547 || (c < 65599
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : (c <= 65594 || (c >= 65596 && c <= 65597)))
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66384
                ? (c < 66272
                  ? (c < 66176
                    ? c == 66045
                    : (c <= 66204 || (c >= 66208 && c <= 66256)))
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66513
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : (c <= 66499 || (c >= 66504 && c <= 66511)))
                  : (c <= 66517 || (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)))))))
            : (c <= 66771 || (c < 67424
              ? (c < 66964
                ? (c < 66928
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : (c <= 66855 || (c >= 66864 && c <= 66915)))
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))
                : (c <= 66965 || (c < 67003
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : (c <= 66993 || (c >= 66995 && c <= 67001)))
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))))
              : (c <= 67431 || (c < 67639
                ? (c < 67584
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : (c <= 67504 || (c >= 67506 && c <= 67514)))
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))
                : (c <= 67640 || (c < 67712
                  ? (c < 67647
                    ? c == 67644
                    : (c <= 67669 || (c >= 67680 && c <= 67702)))
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))))))))
        : (c <= 67861 || (c < 70384
          ? (c < 69424
            ? (c < 68352
              ? (c < 68121
                ? (c < 68096
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : (c <= 68023 || (c >= 68030 && c <= 68031)))
                  : (c <= 68099 || (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : (c <= 68115 || (c >= 68117 && c <= 68119)))))
                : (c <= 68149 || (c < 68224
                  ? (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : (c <= 68159 || (c >= 68192 && c <= 68220)))
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))
              : (c <= 68405 || (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : (c <= 69289 || (c >= 69291 && c <= 69292)))
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))))
            : (c <= 69456 || (c < 70006
              ? (c < 69826
                ? (c < 69632
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : (c <= 69572 || (c >= 69600 && c <= 69622)))
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69942
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : (c <= 69881 || (c >= 69888 && c <= 69940)))
                  : (c <= 69951 || (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)))))
              : (c <= 70006 || (c < 70206
                ? (c < 70108
                  ? (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : (c <= 70092 || (c >= 70094 && c <= 70106)))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)))
                : (c <= 70206 || (c < 70287
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : (c <= 70280 || (c >= 70282 && c <= 70285)))
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))))))))
          : (c <= 70393 || (c < 71360
            ? (c < 70512
              ? (c < 70459
                ? (c < 70419
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : (c <= 70412 || (c >= 70415 && c <= 70416)))
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : (c <= 70451 || (c >= 70453 && c <= 70457)))))
                : (c <= 70468 || (c < 70487
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : (c <= 70477 || c == 70480))
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))))
              : (c <= 70516 || (c < 71040
                ? (c < 70784
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : (c <= 70745 || (c >= 70750 && c <= 70753)))
                  : (c <= 70853 || (c < 70864
                    ? c == 70855
                    : c <= 70873)))
                : (c <= 71093 || (c < 71236
                  ? (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : (c <= 71133 || (c >= 71168 && c <= 71232)))
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))))))
            : (c <= 71369 || (c < 72016
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : (c <= 71467 || (c >= 71472 && c <= 71481)))
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71960
                  ? (c < 71948
                    ? c == 71945
                    : (c <= 71955 || (c >= 71957 && c <= 71958)))
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72272
                ? (c < 72163
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : (c <= 72151 || (c >= 72154 && c <= 72161)))
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72714
                  ? (c < 72368
                    ? c == 72349
                    : (c <= 72440 || (c >= 72704 && c <= 72712)))
                  : (c <= 72758 || (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)))))))))))))
      : (c <= 72847 || (c < 123584
        ? (c < 113821
          ? (c < 92880
            ? (c < 73120
              ? (c < 73023
                ? (c < 72968
                  ? (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : (c <= 72886 || (c >= 72960 && c <= 72966)))
                  : (c <= 72969 || (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : (c <= 73018 || (c >= 73020 && c <= 73021)))))
                : (c <= 73031 || (c < 73066
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : (c <= 73061 || (c >= 73063 && c <= 73064)))
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))))
              : (c <= 73129 || (c < 77824
                ? (c < 74752
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : (c <= 73648 || (c >= 73728 && c <= 74649)))
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))
                : (c <= 78894 || (c < 92768
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : (c <= 92728 || (c >= 92736 && c <= 92766)))
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))))))
            : (c <= 92909 || (c < 94208
              ? (c < 93760
                ? (c < 93008
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : (c <= 92982 || (c >= 92992 && c <= 92995)))
                  : (c <= 93017 || (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)))
                : (c <= 93823 || (c < 94176
                  ? (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : (c <= 94087 || (c >= 94095 && c <= 94111)))
                  : (c <= 94177 || (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)))))
              : (c <= 100343 || (c < 110928
                ? (c < 110581
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : (c <= 101640 || (c >= 110576 && c <= 110579)))
                  : (c <= 110587 || (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)))
                : (c <= 110930 || (c < 113776
                  ? (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : (c <= 111355 || (c >= 113664 && c <= 113770)))
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))))))
          : (c <= 113822 || (c < 120514
            ? (c < 119982
              ? (c < 119362
                ? (c < 119149
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : (c <= 118598 || (c >= 119141 && c <= 119145)))
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : (c <= 119179 || (c >= 119210 && c <= 119213)))))
                : (c <= 119364 || (c < 119970
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : (c <= 119964 || (c >= 119966 && c <= 119967)))
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))))
              : (c <= 119993 || (c < 120094
                ? (c < 120071
                  ? (c < 119997
                    ? c == 119995
                    : (c <= 120003 || (c >= 120005 && c <= 120069)))
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))
                : (c <= 120121 || (c < 120138
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : (c <= 120132 || c == 120134))
                  : (c <= 120144 || (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)))))))
            : (c <= 120538 || (c < 121476
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120572
                    ? (c >= 120540 && c <= 120570)
                    : (c <= 120596 || (c >= 120598 && c <= 120628)))
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 121344
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : (c <= 120779 || (c >= 120782 && c <= 120831)))
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))))
              : (c <= 121476 || (c < 122915
                ? (c < 122880
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : (c <= 121519 || (c >= 122624 && c <= 122654)))
                  : (c <= 122886 || (c < 122907
                    ? (c >= 122888 && c <= 122904)
                    : c <= 122913)))
                : (c <= 122916 || (c < 123200
                  ? (c < 123136
                    ? (c >= 122918 && c <= 122922)
                    : (c <= 123180 || (c >= 123184 && c <= 123197)))
                  : (c <= 123209 || (c < 123536
                    ? c == 123214
                    : c <= 123566)))))))))))
        : (c <= 123641 || (c < 127897
          ? (c < 126559
            ? (c < 126516
              ? (c < 125264
                ? (c < 124912
                  ? (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : (c <= 124907 || (c >= 124909 && c <= 124910)))
                  : (c <= 124926 || (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : (c <= 125142 || (c >= 125184 && c <= 125259)))))
                : (c <= 125273 || (c < 126500
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : (c <= 126495 || (c >= 126497 && c <= 126498)))
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126541
                ? (c < 126535
                  ? (c < 126523
                    ? c == 126521
                    : (c <= 126523 || c == 126530))
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126553
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : (c <= 126548 || c == 126551))
                  : (c <= 126553 || (c < 126557
                    ? c == 126555
                    : c <= 126557)))))))
            : (c <= 126559 || (c < 127183
              ? (c < 126590
                ? (c < 126572
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : (c <= 126564 || (c >= 126567 && c <= 126570)))
                  : (c <= 126578 || (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)))
                : (c <= 126590 || (c < 126629
                  ? (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : (c <= 126619 || (c >= 126625 && c <= 126627)))
                  : (c <= 126633 || (c < 126980
                    ? (c >= 126635 && c <= 126651)
                    : c <= 126980)))))
              : (c <= 127183 || (c < 127514
                ? (c < 127377
                  ? (c < 127358
                    ? (c >= 127344 && c <= 127345)
                    : (c <= 127359 || c == 127374))
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))
                : (c <= 127514 || (c < 127744
                  ? (c < 127538
                    ? c == 127535
                    : (c <= 127546 || (c >= 127568 && c <= 127569)))
                  : (c <= 127777 || (c < 127894
                    ? (c >= 127780 && c <= 127891)
                    : c <= 127895)))))))))
          : (c <= 127899 || (c < 128733
            ? (c < 128433
              ? (c < 128371
                ? (c < 128255
                  ? (c < 127987
                    ? (c >= 127902 && c <= 127984)
                    : (c <= 127989 || (c >= 127991 && c <= 128253)))
                  : (c <= 128317 || (c < 128336
                    ? (c >= 128329 && c <= 128334)
                    : (c <= 128359 || (c >= 128367 && c <= 128368)))))
                : (c <= 128378 || (c < 128405
                  ? (c < 128394
                    ? c == 128391
                    : (c <= 128397 || c == 128400))
                  : (c <= 128406 || (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)))))
              : (c <= 128434 || (c < 128488
                ? (c < 128476
                  ? (c < 128450
                    ? c == 128444
                    : (c <= 128452 || (c >= 128465 && c <= 128467)))
                  : (c <= 128478 || (c < 128483
                    ? c == 128481
                    : c <= 128483)))
                : (c <= 128488 || (c < 128640
                  ? (c < 128499
                    ? c == 128495
                    : (c <= 128499 || (c >= 128506 && c <= 128591)))
                  : (c <= 128709 || (c < 128725
                    ? (c >= 128715 && c <= 128722)
                    : c <= 128727)))))))
            : (c <= 128741 || (c < 129712
              ? (c < 129292
                ? (c < 128755
                  ? (c < 128747
                    ? c == 128745
                    : (c <= 128748 || c == 128752))
                  : (c <= 128764 || (c < 129008
                    ? (c >= 128992 && c <= 129003)
                    : c <= 129008)))
                : (c <= 129338 || (c < 129656
                  ? (c < 129351
                    ? (c >= 129340 && c <= 129349)
                    : (c <= 129535 || (c >= 129648 && c <= 129652)))
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129776
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : (c <= 129753 || (c >= 129760 && c <= 129767)))
                  : (c <= 129782 || (c < 131072
                    ? (c >= 130032 && c <= 130041)
                    : c <= 173791)))
                : (c <= 177976 || (c < 194560
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : (c <= 183969 || (c >= 183984 && c <= 191456)))
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_7(int32_t c) {
  return (c < 43261
    ? (c < 4888
      ? (c < 2911
        ? (c < 2437
          ? (c < 1425
            ? (c < 768
              ? (c < 192
                ? (c < 174
                  ? (c < '*'
                    ? c == '#'
                    : (c <= '*' || (c >= 169 && c <= 170)))
                  : (c <= 174 || (c < 183
                    ? c == 181
                    : (c <= 183 || c == 186))))
                : (c <= 214 || (c < 736
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : (c <= 705 || (c >= 710 && c <= 721)))
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))))
              : (c <= 884 || (c < 931
                ? (c < 902
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : (c <= 893 || c == 895))
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))
                : (c <= 1013 || (c < 1329
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : (c <= 1159 || (c >= 1162 && c <= 1327)))
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))))))
            : (c <= 1469 || (c < 1808
              ? (c < 1552
                ? (c < 1479
                  ? (c < 1473
                    ? c == 1471
                    : (c <= 1474 || (c >= 1476 && c <= 1477)))
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))
                : (c <= 1562 || (c < 1759
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : (c <= 1747 || (c >= 1749 && c <= 1756)))
                  : (c <= 1768 || (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)))))
              : (c <= 1866 || (c < 2144
                ? (c < 2045
                  ? (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : (c <= 2037 || c == 2042))
                  : (c <= 2045 || (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)))
                : (c <= 2154 || (c < 2275
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : (c <= 2190 || (c >= 2200 && c <= 2273)))
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))))))))
          : (c <= 2444 || (c < 2654
            ? (c < 2561
              ? (c < 2507
                ? (c < 2482
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : (c <= 2472 || (c >= 2474 && c <= 2480)))
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : (c <= 2500 || (c >= 2503 && c <= 2504)))))
                : (c <= 2510 || (c < 2534
                  ? (c < 2524
                    ? c == 2519
                    : (c <= 2525 || (c >= 2527 && c <= 2531)))
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))))
              : (c <= 2563 || (c < 2616
                ? (c < 2602
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : (c <= 2576 || (c >= 2579 && c <= 2600)))
                  : (c <= 2608 || (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)))
                : (c <= 2617 || (c < 2635
                  ? (c < 2622
                    ? c == 2620
                    : (c <= 2626 || (c >= 2631 && c <= 2632)))
                  : (c <= 2637 || (c < 2649
                    ? c == 2641
                    : c <= 2652)))))))
            : (c <= 2654 || (c < 2790
              ? (c < 2738
                ? (c < 2703
                  ? (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : (c <= 2691 || (c >= 2693 && c <= 2701)))
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2763
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : (c <= 2757 || (c >= 2759 && c <= 2761)))
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))))
              : (c <= 2799 || (c < 2866
                ? (c < 2831
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : (c <= 2819 || (c >= 2821 && c <= 2828)))
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))
                : (c <= 2867 || (c < 2891
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : (c <= 2884 || (c >= 2887 && c <= 2888)))
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))))))))))
        : (c <= 2915 || (c < 3507
          ? (c < 3168
            ? (c < 3018
              ? (c < 2972
                ? (c < 2949
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : (c <= 2929 || (c >= 2946 && c <= 2947)))
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))))
                : (c <= 2972 || (c < 2990
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : (c <= 2980 || (c >= 2984 && c <= 2986)))
                  : (c <= 3001 || (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)))))
              : (c <= 3021 || (c < 3114
                ? (c < 3072
                  ? (c < 3031
                    ? c == 3024
                    : (c <= 3031 || (c >= 3046 && c <= 3055)))
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3157
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : (c <= 3144 || (c >= 3146 && c <= 3149)))
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))
            : (c <= 3171 || (c < 3302
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : (c <= 3203 || (c >= 3205 && c <= 3212)))
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3285
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : (c <= 3272 || (c >= 3274 && c <= 3277)))
                  : (c <= 3286 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)))))
              : (c <= 3311 || (c < 3412
                ? (c < 3346
                  ? (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : (c <= 3340 || (c >= 3342 && c <= 3344)))
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))
                : (c <= 3415 || (c < 3457
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : (c <= 3439 || (c >= 3450 && c <= 3455)))
                  : (c <= 3459 || (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)))))))))
          : (c <= 3515 || (c < 3897
            ? (c < 3718
              ? (c < 3558
                ? (c < 3535
                  ? (c < 3520
                    ? c == 3517
                    : (c <= 3526 || c == 3530))
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))
                : (c <= 3567 || (c < 3664
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : (c <= 3642 || (c >= 3648 && c <= 3662)))
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))))
              : (c <= 3722 || (c < 3792
                ? (c < 3776
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : (c <= 3749 || (c >= 3751 && c <= 3773)))
                  : (c <= 3780 || (c < 3784
                    ? c == 3782
                    : c <= 3789)))
                : (c <= 3801 || (c < 3872
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : (c <= 3840 || (c >= 3864 && c <= 3865)))
                  : (c <= 3881 || (c < 3895
                    ? c == 3893
                    : c <= 3895)))))))
            : (c <= 3897 || (c < 4682
              ? (c < 4096
                ? (c < 3974
                  ? (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : (c <= 3948 || (c >= 3953 && c <= 3972)))
                  : (c <= 3991 || (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)))
                : (c <= 4169 || (c < 4301
                  ? (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : (c <= 4293 || c == 4295))
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))
              : (c <= 4685 || (c < 4786
                ? (c < 4704
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : (c <= 4696 || (c >= 4698 && c <= 4701)))
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4808
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : (c <= 4800 || (c >= 4802 && c <= 4805)))
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))))))))))
      : (c <= 4954 || (c < 9752
        ? (c < 8008
          ? (c < 6470
            ? (c < 5998
              ? (c < 5761
                ? (c < 5024
                  ? (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : (c <= 4977 || (c >= 4992 && c <= 5007)))
                  : (c <= 5109 || (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : (c <= 5740 || (c >= 5743 && c <= 5759)))))
                : (c <= 5786 || (c < 5919
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : (c <= 5880 || (c >= 5888 && c <= 5909)))
                  : (c <= 5940 || (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)))))
              : (c <= 6000 || (c < 6159
                ? (c < 6108
                  ? (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : (c <= 6099 || c == 6103))
                  : (c <= 6109 || (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : c <= 6157)))
                : (c <= 6169 || (c < 6400
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : (c <= 6314 || (c >= 6320 && c <= 6389)))
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))))))
            : (c <= 6509 || (c < 6992
              ? (c < 6752
                ? (c < 6608
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : (c <= 6571 || (c >= 6576 && c <= 6601)))
                  : (c <= 6618 || (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)))
                : (c <= 6780 || (c < 6832
                  ? (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : (c <= 6809 || c == 6823))
                  : (c <= 6845 || (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : c <= 6988)))))
              : (c <= 7001 || (c < 7312
                ? (c < 7232
                  ? (c < 7040
                    ? (c >= 7019 && c <= 7027)
                    : (c <= 7155 || (c >= 7168 && c <= 7223)))
                  : (c <= 7241 || (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)))
                : (c <= 7354 || (c < 7424
                  ? (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : (c <= 7378 || (c >= 7380 && c <= 7418)))
                  : (c <= 7957 || (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)))))))))
          : (c <= 8013 || (c < 8458
            ? (c < 8182
              ? (c < 8126
                ? (c < 8029
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : (c <= 8025 || c == 8027))
                  : (c <= 8029 || (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : (c <= 8116 || (c >= 8118 && c <= 8124)))))
                : (c <= 8126 || (c < 8150
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : (c <= 8140 || (c >= 8144 && c <= 8147)))
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))
              : (c <= 8188 || (c < 8319
                ? (c < 8265
                  ? (c < 8252
                    ? c == 8205
                    : (c <= 8252 || (c >= 8255 && c <= 8256)))
                  : (c <= 8265 || (c < 8305
                    ? c == 8276
                    : c <= 8305)))
                : (c <= 8319 || (c < 8421
                  ? (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : (c <= 8412 || c == 8417))
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 8986
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : (c <= 8477 || c == 8482))
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8544
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : (c <= 8521 || c == 8526))
                  : (c <= 8584 || (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : c <= 8618)))))
              : (c <= 8987 || (c < 9654
                ? (c < 9208
                  ? (c < 9167
                    ? c == 9000
                    : (c <= 9167 || (c >= 9193 && c <= 9203)))
                  : (c <= 9210 || (c < 9642
                    ? c == 9410
                    : c <= 9643)))
                : (c <= 9654 || (c < 9742
                  ? (c < 9723
                    ? c == 9664
                    : (c <= 9726 || (c >= 9728 && c <= 9732)))
                  : (c <= 9742 || (c < 9748
                    ? c == 9745
                    : c <= 9749)))))))))))
        : (c <= 9752 || (c < 11013
          ? (c < 9939
            ? (c < 9851
              ? (c < 9792
                ? (c < 9766
                  ? (c < 9760
                    ? c == 9757
                    : (c <= 9760 || (c >= 9762 && c <= 9763)))
                  : (c <= 9766 || (c < 9774
                    ? c == 9770
                    : (c <= 9775 || (c >= 9784 && c <= 9786)))))
                : (c <= 9792 || (c < 9827
                  ? (c < 9800
                    ? c == 9794
                    : (c <= 9811 || (c >= 9823 && c <= 9824)))
                  : (c <= 9827 || (c < 9832
                    ? (c >= 9829 && c <= 9830)
                    : c <= 9832)))))
              : (c <= 9851 || (c < 9898
                ? (c < 9883
                  ? (c < 9874
                    ? (c >= 9854 && c <= 9855)
                    : (c <= 9879 || c == 9881))
                  : (c <= 9884 || (c < 9895
                    ? (c >= 9888 && c <= 9889)
                    : c <= 9895)))
                : (c <= 9899 || (c < 9928
                  ? (c < 9917
                    ? (c >= 9904 && c <= 9905)
                    : (c <= 9918 || (c >= 9924 && c <= 9925)))
                  : (c <= 9928 || (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : c <= 9937)))))))
            : (c <= 9940 || (c < 10024
              ? (c < 9992
                ? (c < 9981
                  ? (c < 9968
                    ? (c >= 9961 && c <= 9962)
                    : (c <= 9973 || (c >= 9975 && c <= 9978)))
                  : (c <= 9981 || (c < 9989
                    ? c == 9986
                    : c <= 9989)))
                : (c <= 9997 || (c < 10006
                  ? (c < 10002
                    ? c == 9999
                    : (c <= 10002 || c == 10004))
                  : (c <= 10006 || (c < 10017
                    ? c == 10013
                    : c <= 10017)))))
              : (c <= 10024 || (c < 10071
                ? (c < 10060
                  ? (c < 10052
                    ? (c >= 10035 && c <= 10036)
                    : (c <= 10052 || c == 10055))
                  : (c <= 10060 || (c < 10067
                    ? c == 10062
                    : c <= 10069)))
                : (c <= 10071 || (c < 10160
                  ? (c < 10133
                    ? (c >= 10083 && c <= 10084)
                    : (c <= 10135 || c == 10145))
                  : (c <= 10160 || (c < 10548
                    ? c == 10175
                    : c <= 10549)))))))))
          : (c <= 11015 || (c < 12540
            ? (c < 11696
              ? (c < 11559
                ? (c < 11264
                  ? (c < 11088
                    ? (c >= 11035 && c <= 11036)
                    : (c <= 11088 || c == 11093))
                  : (c <= 11492 || (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)))
                : (c <= 11559 || (c < 11647
                  ? (c < 11568
                    ? c == 11565
                    : (c <= 11623 || c == 11631))
                  : (c <= 11670 || (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)))))
              : (c <= 11702 || (c < 12293
                ? (c < 11728
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : (c <= 11718 || (c >= 11720 && c <= 11726)))
                  : (c <= 11734 || (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)))
                : (c <= 12295 || (c < 12441
                  ? (c < 12344
                    ? (c >= 12321 && c <= 12341)
                    : (c <= 12349 || (c >= 12353 && c <= 12438)))
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))))
            : (c <= 12543 || (c < 42623
              ? (c < 13312
                ? (c < 12784
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : (c <= 12686 || (c >= 12704 && c <= 12735)))
                  : (c <= 12799 || (c < 12953
                    ? c == 12951
                    : c <= 12953)))
                : (c <= 19903 || (c < 42512
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : (c <= 42237 || (c >= 42240 && c <= 42508)))
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))
              : (c <= 42737 || (c < 42994
                ? (c < 42960
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : (c <= 42888 || (c >= 42891 && c <= 42954)))
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43047 || (c < 43216
                  ? (c < 43072
                    ? c == 43052
                    : (c <= 43123 || (c >= 43136 && c <= 43205)))
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))))))))))))))
    : (c <= 43309 || (c < 72850
      ? (c < 67968
        ? (c < 65345
          ? (c < 64256
            ? (c < 43785
              ? (c < 43600
                ? (c < 43471
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : (c <= 43388 || (c >= 43392 && c <= 43456)))
                  : (c <= 43481 || (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : (c <= 43574 || (c >= 43584 && c <= 43597)))))
                : (c <= 43609 || (c < 43744
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : (c <= 43714 || (c >= 43739 && c <= 43741)))
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))))
              : (c <= 43790 || (c < 44012
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)))
                : (c <= 44013 || (c < 55243
                  ? (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : (c <= 55203 || (c >= 55216 && c <= 55238)))
                  : (c <= 55291 || (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)))))))
            : (c <= 64262 || (c < 65024
              ? (c < 64323
                ? (c < 64312
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : (c <= 64296 || (c >= 64298 && c <= 64310)))
                  : (c <= 64316 || (c < 64320
                    ? c == 64318
                    : c <= 64321)))
                : (c <= 64324 || (c < 64848
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : (c <= 64605 || (c >= 64612 && c <= 64829)))
                  : (c <= 64911 || (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)))))
              : (c <= 65038 || (c < 65145
                ? (c < 65137
                  ? (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : (c <= 65076 || (c >= 65101 && c <= 65103)))
                  : (c <= 65137 || (c < 65143
                    ? c == 65139
                    : c <= 65143)))
                : (c <= 65145 || (c < 65296
                  ? (c < 65149
                    ? c == 65147
                    : (c <= 65149 || (c >= 65151 && c <= 65276)))
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66816
            ? (c < 66176
              ? (c < 65576
                ? (c < 65490
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : (c <= 65479 || (c >= 65482 && c <= 65487)))
                  : (c <= 65495 || (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : (c <= 65547 || (c >= 65549 && c <= 65574)))))
                : (c <= 65594 || (c < 65664
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : (c <= 65613 || (c >= 65616 && c <= 65629)))
                  : (c <= 65786 || (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)))))
              : (c <= 66204 || (c < 66464
                ? (c < 66349
                  ? (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66272 || (c >= 66304 && c <= 66335)))
                  : (c <= 66378 || (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)))
                : (c <= 66499 || (c < 66720
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : (c <= 66517 || (c >= 66560 && c <= 66717)))
                  : (c <= 66729 || (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)))))))
            : (c <= 66855 || (c < 67463
              ? (c < 66979
                ? (c < 66956
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : (c <= 66938 || (c >= 66940 && c <= 66954)))
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67392
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : (c <= 67004 || (c >= 67072 && c <= 67382)))
                  : (c <= 67413 || (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)))))
              : (c <= 67504 || (c < 67647
                ? (c < 67594
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : (c <= 67589 || c == 67592))
                  : (c <= 67637 || (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)))
                : (c <= 67669 || (c < 67828
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : (c <= 67742 || (c >= 67808 && c <= 67826)))
                  : (c <= 67829 || (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)))))))))))
        : (c <= 68023 || (c < 70405
          ? (c < 69552
            ? (c < 68448
              ? (c < 68159
                ? (c < 68108
                  ? (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : (c <= 68099 || (c >= 68101 && c <= 68102)))
                  : (c <= 68115 || (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : (c <= 68149 || (c >= 68152 && c <= 68154)))))
                : (c <= 68159 || (c < 68297
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : (c <= 68252 || (c >= 68288 && c <= 68295)))
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))
              : (c <= 68466 || (c < 69248
                ? (c < 68800
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : (c <= 68680 || (c >= 68736 && c <= 68786)))
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69415
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : (c <= 69297 || (c >= 69376 && c <= 69404)))
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69456)
                    : c <= 69509)))))))
            : (c <= 69572 || (c < 70089
              ? (c < 69872
                ? (c < 69759
                  ? (c < 69632
                    ? (c >= 69600 && c <= 69622)
                    : (c <= 69702 || (c >= 69734 && c <= 69749)))
                  : (c <= 69818 || (c < 69840
                    ? c == 69826
                    : c <= 69864)))
                : (c <= 69881 || (c < 69968
                  ? (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : (c <= 69951 || (c >= 69956 && c <= 69959)))
                  : (c <= 70003 || (c < 70016
                    ? c == 70006
                    : c <= 70084)))))
              : (c <= 70092 || (c < 70280
                ? (c < 70163
                  ? (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : (c <= 70108 || (c >= 70144 && c <= 70161)))
                  : (c <= 70199 || (c < 70272
                    ? c == 70206
                    : c <= 70278)))
                : (c <= 70280 || (c < 70320
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : (c <= 70301 || (c >= 70303 && c <= 70312)))
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))))))))
          : (c <= 70412 || (c < 71424
            ? (c < 70656
              ? (c < 70471
                ? (c < 70450
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : (c <= 70440 || (c >= 70442 && c <= 70448)))
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))
                : (c <= 70472 || (c < 70493
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : (c <= 70480 || c == 70487))
                  : (c <= 70499 || (c < 70512
                    ? (c >= 70502 && c <= 70508)
                    : c <= 70516)))))
              : (c <= 70730 || (c < 71096
                ? (c < 70855
                  ? (c < 70750
                    ? (c >= 70736 && c <= 70745)
                    : (c <= 70753 || (c >= 70784 && c <= 70853)))
                  : (c <= 70855 || (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)))
                : (c <= 71104 || (c < 71248
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : (c <= 71232 || c == 71236))
                  : (c <= 71257 || (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)))))))
            : (c <= 71450 || (c < 72096
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71472
                    ? (c >= 71453 && c <= 71467)
                    : (c <= 71481 || (c >= 71488 && c <= 71494)))
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71991
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : (c <= 71958 || (c >= 71960 && c <= 71989)))
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72349
                ? (c < 72192
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : (c <= 72161 || (c >= 72163 && c <= 72164)))
                  : (c <= 72254 || (c < 72272
                    ? c == 72263
                    : c <= 72345)))
                : (c <= 72349 || (c < 72760
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : (c <= 72712 || (c >= 72714 && c <= 72758)))
                  : (c <= 72768 || (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)))))))))))))
      : (c <= 72871 || (c < 124896
        ? (c < 118528
          ? (c < 92912
            ? (c < 73440
              ? (c < 73040
                ? (c < 72971
                  ? (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : (c <= 72966 || (c >= 72968 && c <= 72969)))
                  : (c <= 73014 || (c < 73020
                    ? c == 73018
                    : (c <= 73021 || (c >= 73023 && c <= 73031)))))
                : (c <= 73049 || (c < 73104
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : (c <= 73064 || (c >= 73066 && c <= 73102)))
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))))
              : (c <= 73462 || (c < 82944
                ? (c < 74880
                  ? (c < 73728
                    ? c == 73648
                    : (c <= 74649 || (c >= 74752 && c <= 74862)))
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))
                : (c <= 83526 || (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92768 && c <= 92777)))
                  : (c <= 92862 || (c < 92880
                    ? (c >= 92864 && c <= 92873)
                    : c <= 92909)))))))
            : (c <= 92916 || (c < 100352
              ? (c < 93952
                ? (c < 93027
                  ? (c < 92992
                    ? (c >= 92928 && c <= 92982)
                    : (c <= 92995 || (c >= 93008 && c <= 93017)))
                  : (c <= 93047 || (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)))
                : (c <= 94026 || (c < 94179
                  ? (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : (c <= 94111 || (c >= 94176 && c <= 94177)))
                  : (c <= 94180 || (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)))))
              : (c <= 101589 || (c < 110948
                ? (c < 110589
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : (c <= 110579 || (c >= 110581 && c <= 110587)))
                  : (c <= 110590 || (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)))
                : (c <= 110951 || (c < 113792
                  ? (c < 113664
                    ? (c >= 110960 && c <= 111355)
                    : (c <= 113770 || (c >= 113776 && c <= 113788)))
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))))))
          : (c <= 118573 || (c < 120540
            ? (c < 119995
              ? (c < 119808
                ? (c < 119163
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : (c <= 119145 || (c >= 119149 && c <= 119154)))
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : (c <= 119213 || (c >= 119362 && c <= 119364)))))
                : (c <= 119892 || (c < 119973
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : (c <= 119967 || c == 119970))
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))))
              : (c <= 119995 || (c < 120123
                ? (c < 120077
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : (c <= 120069 || (c >= 120071 && c <= 120074)))
                  : (c <= 120084 || (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)))
                : (c <= 120126 || (c < 120146
                  ? (c < 120134
                    ? (c >= 120128 && c <= 120132)
                    : (c <= 120134 || (c >= 120138 && c <= 120144)))
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 121499
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 121403
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : (c <= 120831 || (c >= 121344 && c <= 121398)))
                  : (c <= 121452 || (c < 121476
                    ? c == 121461
                    : c <= 121476)))))
              : (c <= 121503 || (c < 122918
                ? (c < 122888
                  ? (c < 122624
                    ? (c >= 121505 && c <= 121519)
                    : (c <= 122654 || (c >= 122880 && c <= 122886)))
                  : (c <= 122904 || (c < 122915
                    ? (c >= 122907 && c <= 122913)
                    : c <= 122916)))
                : (c <= 122922 || (c < 123214
                  ? (c < 123184
                    ? (c >= 123136 && c <= 123180)
                    : (c <= 123197 || (c >= 123200 && c <= 123209)))
                  : (c <= 123214 || (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)))))))))))
        : (c <= 124902 || (c < 127902
          ? (c < 126561
            ? (c < 126521
              ? (c < 126464
                ? (c < 124928
                  ? (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : (c <= 124910 || (c >= 124912 && c <= 124926)))
                  : (c <= 125124 || (c < 125184
                    ? (c >= 125136 && c <= 125142)
                    : (c <= 125259 || (c >= 125264 && c <= 125273)))))
                : (c <= 126467 || (c < 126503
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : (c <= 126498 || c == 126500))
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126545
                ? (c < 126537
                  ? (c < 126530
                    ? c == 126523
                    : (c <= 126530 || c == 126535))
                  : (c <= 126537 || (c < 126541
                    ? c == 126539
                    : c <= 126543)))
                : (c <= 126546 || (c < 126555
                  ? (c < 126551
                    ? c == 126548
                    : (c <= 126551 || c == 126553))
                  : (c <= 126555 || (c < 126559
                    ? c == 126557
                    : c <= 126559)))))))
            : (c <= 126562 || (c < 127344
              ? (c < 126592
                ? (c < 126580
                  ? (c < 126567
                    ? c == 126564
                    : (c <= 126570 || (c >= 126572 && c <= 126578)))
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))
                : (c <= 126601 || (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))))
              : (c <= 127345 || (c < 127535
                ? (c < 127462
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : (c <= 127374 || (c >= 127377 && c <= 127386)))
                  : (c <= 127487 || (c < 127514
                    ? (c >= 127489 && c <= 127490)
                    : c <= 127514)))
                : (c <= 127535 || (c < 127780
                  ? (c < 127568
                    ? (c >= 127538 && c <= 127546)
                    : (c <= 127569 || (c >= 127744 && c <= 127777)))
                  : (c <= 127891 || (c < 127897
                    ? (c >= 127894 && c <= 127895)
                    : c <= 127899)))))))))
          : (c <= 127984 || (c < 128733
            ? (c < 128433
              ? (c < 128371
                ? (c < 128329
                  ? (c < 127991
                    ? (c >= 127987 && c <= 127989)
                    : (c <= 128253 || (c >= 128255 && c <= 128317)))
                  : (c <= 128334 || (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : c <= 128368)))
                : (c <= 128378 || (c < 128405
                  ? (c < 128394
                    ? c == 128391
                    : (c <= 128397 || c == 128400))
                  : (c <= 128406 || (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)))))
              : (c <= 128434 || (c < 128488
                ? (c < 128476
                  ? (c < 128450
                    ? c == 128444
                    : (c <= 128452 || (c >= 128465 && c <= 128467)))
                  : (c <= 128478 || (c < 128483
                    ? c == 128481
                    : c <= 128483)))
                : (c <= 128488 || (c < 128640
                  ? (c < 128499
                    ? c == 128495
                    : (c <= 128499 || (c >= 128506 && c <= 128591)))
                  : (c <= 128709 || (c < 128725
                    ? (c >= 128715 && c <= 128722)
                    : c <= 128727)))))))
            : (c <= 128741 || (c < 129712
              ? (c < 129292
                ? (c < 128755
                  ? (c < 128747
                    ? c == 128745
                    : (c <= 128748 || c == 128752))
                  : (c <= 128764 || (c < 129008
                    ? (c >= 128992 && c <= 129003)
                    : c <= 129008)))
                : (c <= 129338 || (c < 129656
                  ? (c < 129351
                    ? (c >= 129340 && c <= 129349)
                    : (c <= 129535 || (c >= 129648 && c <= 129652)))
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129776
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : (c <= 129753 || (c >= 129760 && c <= 129767)))
                  : (c <= 129782 || (c < 131072
                    ? (c >= 130032 && c <= 130041)
                    : c <= 173791)))
                : (c <= 177976 || (c < 194560
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : (c <= 183969 || (c >= 183984 && c <= 191456)))
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_8(int32_t c) {
  return (c < 43232
    ? (c < 4808
      ? (c < 2887
        ? (c < 2200
          ? (c < 1162
            ? (c < 710
              ? (c < 174
                ? (c < 'A'
                  ? (c < '*'
                    ? c == '#'
                    : (c <= '*' || (c >= '0' && c <= '9')))
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : (c <= 'z' || (c >= 169 && c <= 170)))))
                : (c <= 174 || (c < 192
                  ? (c < 183
                    ? c == 181
                    : (c <= 183 || c == 186))
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 895
                ? (c < 768
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : (c <= 748 || c == 750))
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 931
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : (c <= 908 || (c >= 910 && c <= 929)))
                  : (c <= 1013 || (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)))))))
            : (c <= 1327 || (c < 1749
              ? (c < 1476
                ? (c < 1425
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : (c <= 1369 || (c >= 1376 && c <= 1416)))
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))
                : (c <= 1477 || (c < 1552
                  ? (c < 1488
                    ? c == 1479
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 2042
                ? (c < 1808
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : (c <= 1788 || c == 1791))
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2144
                  ? (c < 2048
                    ? c == 2045
                    : (c <= 2093 || (c >= 2112 && c <= 2139)))
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))))))))
          : (c <= 2273 || (c < 2631
            ? (c < 2527
              ? (c < 2482
                ? (c < 2437
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : (c <= 2415 || (c >= 2417 && c <= 2435)))
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : (c <= 2472 || (c >= 2474 && c <= 2480)))))
                : (c <= 2482 || (c < 2507
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : (c <= 2500 || (c >= 2503 && c <= 2504)))
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))
              : (c <= 2531 || (c < 2579
                ? (c < 2561
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : (c <= 2556 || c == 2558))
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2616
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : (c <= 2611 || (c >= 2613 && c <= 2614)))
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))))
            : (c <= 2632 || (c < 2759
              ? (c < 2693
                ? (c < 2654
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : (c <= 2641 || (c >= 2649 && c <= 2652)))
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2738
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : (c <= 2728 || (c >= 2730 && c <= 2736)))
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))
              : (c <= 2761 || (c < 2821
                ? (c < 2790
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : (c <= 2768 || (c >= 2784 && c <= 2787)))
                  : (c <= 2799 || (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)))
                : (c <= 2828 || (c < 2866
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : (c <= 2856 || (c >= 2858 && c <= 2864)))
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))))))))
        : (c <= 2888 || (c < 3450
          ? (c < 3146
            ? (c < 2984
              ? (c < 2949
                ? (c < 2911
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : (c <= 2903 || (c >= 2908 && c <= 2909)))
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : (c <= 2929 || (c >= 2946 && c <= 2947)))))
                : (c <= 2954 || (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))))
              : (c <= 2986 || (c < 3046
                ? (c < 3018
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : (c <= 3010 || (c >= 3014 && c <= 3016)))
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))
                : (c <= 3055 || (c < 3114
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : (c <= 3088 || (c >= 3090 && c <= 3112)))
                  : (c <= 3129 || (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)))))))
            : (c <= 3149 || (c < 3274
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : (c <= 3162 || c == 3165))
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3253
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : (c <= 3240 || (c >= 3242 && c <= 3251)))
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3342
                ? (c < 3302
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : (c <= 3294 || (c >= 3296 && c <= 3299)))
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3412
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : (c <= 3400 || (c >= 3402 && c <= 3406)))
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))))
          : (c <= 3455 || (c < 3872
            ? (c < 3664
              ? (c < 3535
                ? (c < 3507
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : (c <= 3478 || (c >= 3482 && c <= 3505)))
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : (c <= 3526 || c == 3530))))
                : (c <= 3540 || (c < 3570
                  ? (c < 3544
                    ? c == 3542
                    : (c <= 3551 || (c >= 3558 && c <= 3567)))
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3776
                ? (c < 3724
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : (c <= 3716 || (c >= 3718 && c <= 3722)))
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))
                : (c <= 3780 || (c < 3804
                  ? (c < 3784
                    ? c == 3782
                    : (c <= 3789 || (c >= 3792 && c <= 3801)))
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))))))
            : (c <= 3881 || (c < 4301
              ? (c < 3974
                ? (c < 3902
                  ? (c < 3895
                    ? c == 3893
                    : (c <= 3895 || c == 3897))
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4176
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : (c <= 4038 || (c >= 4096 && c <= 4169)))
                  : (c <= 4253 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))))
              : (c <= 4301 || (c < 4704
                ? (c < 4688
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : (c <= 4680 || (c >= 4682 && c <= 4685)))
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4792
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : (c <= 4784 || (c >= 4786 && c <= 4789)))
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))))))))))
      : (c <= 4822 || (c < 9742
        ? (c < 7424
          ? (c < 6400
            ? (c < 5919
              ? (c < 5112
                ? (c < 4957
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : (c <= 4885 || (c >= 4888 && c <= 4954)))
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : (c <= 5007 || (c >= 5024 && c <= 5109)))))
                : (c <= 5117 || (c < 5792
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : (c <= 5759 || (c >= 5761 && c <= 5786)))
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))
              : (c <= 5940 || (c < 6108
                ? (c < 6002
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : (c <= 5996 || (c >= 5998 && c <= 6000)))
                  : (c <= 6003 || (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)))
                : (c <= 6109 || (c < 6176
                  ? (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : (c <= 6157 || (c >= 6159 && c <= 6169)))
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))))
            : (c <= 6430 || (c < 6832
              ? (c < 6608
                ? (c < 6512
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : (c <= 6459 || (c >= 6470 && c <= 6509)))
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))
                : (c <= 6618 || (c < 6783
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : (c <= 6750 || (c >= 6752 && c <= 6780)))
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))))
              : (c <= 6845 || (c < 7232
                ? (c < 7019
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : (c <= 6988 || (c >= 6992 && c <= 7001)))
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))
                : (c <= 7241 || (c < 7357
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : (c <= 7304 || (c >= 7312 && c <= 7354)))
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))))))))
          : (c <= 7957 || (c < 8421
            ? (c < 8150
              ? (c < 8031
                ? (c < 8016
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : (c <= 8005 || (c >= 8008 && c <= 8013)))
                  : (c <= 8023 || (c < 8027
                    ? c == 8025
                    : (c <= 8027 || c == 8029))))
                : (c <= 8061 || (c < 8130
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : (c <= 8124 || c == 8126))
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8265
                ? (c < 8205
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : (c <= 8180 || (c >= 8182 && c <= 8188)))
                  : (c <= 8205 || (c < 8255
                    ? c == 8252
                    : c <= 8256)))
                : (c <= 8265 || (c < 8336
                  ? (c < 8305
                    ? c == 8276
                    : (c <= 8305 || c == 8319))
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))))))
            : (c <= 8432 || (c < 8544
              ? (c < 8484
                ? (c < 8469
                  ? (c < 8455
                    ? c == 8450
                    : (c <= 8455 || (c >= 8458 && c <= 8467)))
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))
                : (c <= 8484 || (c < 8508
                  ? (c < 8488
                    ? c == 8486
                    : (c <= 8488 || (c >= 8490 && c <= 8505)))
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 9208
                ? (c < 9000
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : (c <= 8618 || (c >= 8986 && c <= 8987)))
                  : (c <= 9000 || (c < 9193
                    ? c == 9167
                    : c <= 9203)))
                : (c <= 9210 || (c < 9664
                  ? (c < 9642
                    ? c == 9410
                    : (c <= 9643 || c == 9654))
                  : (c <= 9664 || (c < 9728
                    ? (c >= 9723 && c <= 9726)
                    : c <= 9732)))))))))))
        : (c <= 9742 || (c < 10160
          ? (c < 9928
            ? (c < 9827
              ? (c < 9770
                ? (c < 9757
                  ? (c < 9748
                    ? c == 9745
                    : (c <= 9749 || c == 9752))
                  : (c <= 9757 || (c < 9762
                    ? c == 9760
                    : (c <= 9763 || c == 9766))))
                : (c <= 9770 || (c < 9794
                  ? (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : (c <= 9786 || c == 9792))
                  : (c <= 9794 || (c < 9823
                    ? (c >= 9800 && c <= 9811)
                    : c <= 9824)))))
              : (c <= 9827 || (c < 9883
                ? (c < 9854
                  ? (c < 9832
                    ? (c >= 9829 && c <= 9830)
                    : (c <= 9832 || c == 9851))
                  : (c <= 9855 || (c < 9881
                    ? (c >= 9874 && c <= 9879)
                    : c <= 9881)))
                : (c <= 9884 || (c < 9904
                  ? (c < 9895
                    ? (c >= 9888 && c <= 9889)
                    : (c <= 9895 || (c >= 9898 && c <= 9899)))
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))))
            : (c <= 9928 || (c < 10006
              ? (c < 9981
                ? (c < 9961
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : (c <= 9937 || (c >= 9939 && c <= 9940)))
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9999
                  ? (c < 9989
                    ? c == 9986
                    : (c <= 9989 || (c >= 9992 && c <= 9997)))
                  : (c <= 9999 || (c < 10004
                    ? c == 10002
                    : c <= 10004)))))
              : (c <= 10006 || (c < 10060
                ? (c < 10035
                  ? (c < 10017
                    ? c == 10013
                    : (c <= 10017 || c == 10024))
                  : (c <= 10036 || (c < 10055
                    ? c == 10052
                    : c <= 10055)))
                : (c <= 10060 || (c < 10083
                  ? (c < 10067
                    ? c == 10062
                    : (c <= 10069 || c == 10071))
                  : (c <= 10084 || (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)))))))))
          : (c <= 10160 || (c < 12445
            ? (c < 11680
              ? (c < 11499
                ? (c < 11035
                  ? (c < 10548
                    ? c == 10175
                    : (c <= 10549 || (c >= 11013 && c <= 11015)))
                  : (c <= 11036 || (c < 11093
                    ? c == 11088
                    : (c <= 11093 || (c >= 11264 && c <= 11492)))))
                : (c <= 11507 || (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))))
              : (c <= 11686 || (c < 11736
                ? (c < 11712
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : (c <= 11702 || (c >= 11704 && c <= 11710)))
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))
                : (c <= 11742 || (c < 12344
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : (c <= 12295 || (c >= 12321 && c <= 12341)))
                  : (c <= 12349 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))))
            : (c <= 12447 || (c < 42560
              ? (c < 12951
                ? (c < 12593
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : (c <= 12543 || (c >= 12549 && c <= 12591)))
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 12951 || (c < 42192
                  ? (c < 13312
                    ? c == 12953
                    : (c <= 19903 || (c >= 19968 && c <= 42124)))
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))
              : (c <= 42607 || (c < 42963
                ? (c < 42786
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : (c <= 42737 || (c >= 42775 && c <= 42783)))
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43072
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : (c <= 43047 || c == 43052))
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))))))))))))
    : (c <= 43255 || (c < 72818
      ? (c < 67840
        ? (c < 65313
          ? (c < 63744
            ? (c < 43762
              ? (c < 43520
                ? (c < 43360
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43309 || (c >= 43312 && c <= 43347)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : (c <= 43481 || (c >= 43488 && c <= 43518)))))
                : (c <= 43574 || (c < 43642
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : (c <= 43609 || (c >= 43616 && c <= 43638)))
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))))
              : (c <= 43766 || (c < 43868
                ? (c < 43808
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : (c <= 43790 || (c >= 43793 && c <= 43798)))
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : (c <= 44013 || (c >= 44016 && c <= 44025)))
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))))))
            : (c <= 64109 || (c < 64914
              ? (c < 64318
                ? (c < 64285
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : (c <= 64262 || (c >= 64275 && c <= 64279)))
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))
                : (c <= 64318 || (c < 64467
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : (c <= 64324 || (c >= 64326 && c <= 64433)))
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))
              : (c <= 64967 || (c < 65139
                ? (c < 65075
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65038 || (c >= 65056 && c <= 65071)))
                  : (c <= 65076 || (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65149
                  ? (c < 65145
                    ? c == 65143
                    : (c <= 65145 || c == 65147))
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66736
            ? (c < 65856
              ? (c < 65536
                ? (c < 65474
                  ? (c < 65345
                    ? c == 65343
                    : (c <= 65370 || (c >= 65382 && c <= 65470)))
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : (c <= 65495 || (c >= 65498 && c <= 65500)))))
                : (c <= 65547 || (c < 65599
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : (c <= 65594 || (c >= 65596 && c <= 65597)))
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66384
                ? (c < 66272
                  ? (c < 66176
                    ? c == 66045
                    : (c <= 66204 || (c >= 66208 && c <= 66256)))
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66513
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : (c <= 66499 || (c >= 66504 && c <= 66511)))
                  : (c <= 66517 || (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)))))))
            : (c <= 66771 || (c < 67424
              ? (c < 66964
                ? (c < 66928
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : (c <= 66855 || (c >= 66864 && c <= 66915)))
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))
                : (c <= 66965 || (c < 67003
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : (c <= 66993 || (c >= 66995 && c <= 67001)))
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))))
              : (c <= 67431 || (c < 67639
                ? (c < 67584
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : (c <= 67504 || (c >= 67506 && c <= 67514)))
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))
                : (c <= 67640 || (c < 67712
                  ? (c < 67647
                    ? c == 67644
                    : (c <= 67669 || (c >= 67680 && c <= 67702)))
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))))))))
        : (c <= 67861 || (c < 70384
          ? (c < 69424
            ? (c < 68352
              ? (c < 68121
                ? (c < 68096
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : (c <= 68023 || (c >= 68030 && c <= 68031)))
                  : (c <= 68099 || (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : (c <= 68115 || (c >= 68117 && c <= 68119)))))
                : (c <= 68149 || (c < 68224
                  ? (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : (c <= 68159 || (c >= 68192 && c <= 68220)))
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))
              : (c <= 68405 || (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : (c <= 69289 || (c >= 69291 && c <= 69292)))
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))))
            : (c <= 69456 || (c < 70006
              ? (c < 69826
                ? (c < 69632
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : (c <= 69572 || (c >= 69600 && c <= 69622)))
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69942
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : (c <= 69881 || (c >= 69888 && c <= 69940)))
                  : (c <= 69951 || (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)))))
              : (c <= 70006 || (c < 70206
                ? (c < 70108
                  ? (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : (c <= 70092 || (c >= 70094 && c <= 70106)))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)))
                : (c <= 70206 || (c < 70287
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : (c <= 70280 || (c >= 70282 && c <= 70285)))
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))))))))
          : (c <= 70393 || (c < 71360
            ? (c < 70512
              ? (c < 70459
                ? (c < 70419
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : (c <= 70412 || (c >= 70415 && c <= 70416)))
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : (c <= 70451 || (c >= 70453 && c <= 70457)))))
                : (c <= 70468 || (c < 70487
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : (c <= 70477 || c == 70480))
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))))
              : (c <= 70516 || (c < 71040
                ? (c < 70784
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : (c <= 70745 || (c >= 70750 && c <= 70753)))
                  : (c <= 70853 || (c < 70864
                    ? c == 70855
                    : c <= 70873)))
                : (c <= 71093 || (c < 71236
                  ? (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : (c <= 71133 || (c >= 71168 && c <= 71232)))
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))))))
            : (c <= 71369 || (c < 72016
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : (c <= 71467 || (c >= 71472 && c <= 71481)))
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71960
                  ? (c < 71948
                    ? c == 71945
                    : (c <= 71955 || (c >= 71957 && c <= 71958)))
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72272
                ? (c < 72163
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : (c <= 72151 || (c >= 72154 && c <= 72161)))
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72714
                  ? (c < 72368
                    ? c == 72349
                    : (c <= 72440 || (c >= 72704 && c <= 72712)))
                  : (c <= 72758 || (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)))))))))))))
      : (c <= 72847 || (c < 123584
        ? (c < 113821
          ? (c < 92880
            ? (c < 73120
              ? (c < 73023
                ? (c < 72968
                  ? (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : (c <= 72886 || (c >= 72960 && c <= 72966)))
                  : (c <= 72969 || (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : (c <= 73018 || (c >= 73020 && c <= 73021)))))
                : (c <= 73031 || (c < 73066
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : (c <= 73061 || (c >= 73063 && c <= 73064)))
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))))
              : (c <= 73129 || (c < 77824
                ? (c < 74752
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : (c <= 73648 || (c >= 73728 && c <= 74649)))
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))
                : (c <= 78894 || (c < 92768
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : (c <= 92728 || (c >= 92736 && c <= 92766)))
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))))))
            : (c <= 92909 || (c < 94208
              ? (c < 93760
                ? (c < 93008
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : (c <= 92982 || (c >= 92992 && c <= 92995)))
                  : (c <= 93017 || (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)))
                : (c <= 93823 || (c < 94176
                  ? (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : (c <= 94087 || (c >= 94095 && c <= 94111)))
                  : (c <= 94177 || (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)))))
              : (c <= 100343 || (c < 110928
                ? (c < 110581
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : (c <= 101640 || (c >= 110576 && c <= 110579)))
                  : (c <= 110587 || (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)))
                : (c <= 110930 || (c < 113776
                  ? (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : (c <= 111355 || (c >= 113664 && c <= 113770)))
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))))))
          : (c <= 113822 || (c < 120514
            ? (c < 119982
              ? (c < 119362
                ? (c < 119149
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : (c <= 118598 || (c >= 119141 && c <= 119145)))
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : (c <= 119179 || (c >= 119210 && c <= 119213)))))
                : (c <= 119364 || (c < 119970
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : (c <= 119964 || (c >= 119966 && c <= 119967)))
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))))
              : (c <= 119993 || (c < 120094
                ? (c < 120071
                  ? (c < 119997
                    ? c == 119995
                    : (c <= 120003 || (c >= 120005 && c <= 120069)))
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))
                : (c <= 120121 || (c < 120138
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : (c <= 120132 || c == 120134))
                  : (c <= 120144 || (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)))))))
            : (c <= 120538 || (c < 121476
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120572
                    ? (c >= 120540 && c <= 120570)
                    : (c <= 120596 || (c >= 120598 && c <= 120628)))
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 121344
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : (c <= 120779 || (c >= 120782 && c <= 120831)))
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))))
              : (c <= 121476 || (c < 122915
                ? (c < 122880
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : (c <= 121519 || (c >= 122624 && c <= 122654)))
                  : (c <= 122886 || (c < 122907
                    ? (c >= 122888 && c <= 122904)
                    : c <= 122913)))
                : (c <= 122916 || (c < 123200
                  ? (c < 123136
                    ? (c >= 122918 && c <= 122922)
                    : (c <= 123180 || (c >= 123184 && c <= 123197)))
                  : (c <= 123209 || (c < 123536
                    ? c == 123214
                    : c <= 123566)))))))))))
        : (c <= 123641 || (c < 127897
          ? (c < 126559
            ? (c < 126516
              ? (c < 125264
                ? (c < 124912
                  ? (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : (c <= 124907 || (c >= 124909 && c <= 124910)))
                  : (c <= 124926 || (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : (c <= 125142 || (c >= 125184 && c <= 125259)))))
                : (c <= 125273 || (c < 126500
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : (c <= 126495 || (c >= 126497 && c <= 126498)))
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126541
                ? (c < 126535
                  ? (c < 126523
                    ? c == 126521
                    : (c <= 126523 || c == 126530))
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126553
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : (c <= 126548 || c == 126551))
                  : (c <= 126553 || (c < 126557
                    ? c == 126555
                    : c <= 126557)))))))
            : (c <= 126559 || (c < 127183
              ? (c < 126590
                ? (c < 126572
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : (c <= 126564 || (c >= 126567 && c <= 126570)))
                  : (c <= 126578 || (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)))
                : (c <= 126590 || (c < 126629
                  ? (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : (c <= 126619 || (c >= 126625 && c <= 126627)))
                  : (c <= 126633 || (c < 126980
                    ? (c >= 126635 && c <= 126651)
                    : c <= 126980)))))
              : (c <= 127183 || (c < 127514
                ? (c < 127377
                  ? (c < 127358
                    ? (c >= 127344 && c <= 127345)
                    : (c <= 127359 || c == 127374))
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))
                : (c <= 127514 || (c < 127744
                  ? (c < 127538
                    ? c == 127535
                    : (c <= 127546 || (c >= 127568 && c <= 127569)))
                  : (c <= 127777 || (c < 127894
                    ? (c >= 127780 && c <= 127891)
                    : c <= 127895)))))))))
          : (c <= 127899 || (c < 128733
            ? (c < 128433
              ? (c < 128371
                ? (c < 128255
                  ? (c < 127987
                    ? (c >= 127902 && c <= 127984)
                    : (c <= 127989 || (c >= 127991 && c <= 128253)))
                  : (c <= 128317 || (c < 128336
                    ? (c >= 128329 && c <= 128334)
                    : (c <= 128359 || (c >= 128367 && c <= 128368)))))
                : (c <= 128378 || (c < 128405
                  ? (c < 128394
                    ? c == 128391
                    : (c <= 128397 || c == 128400))
                  : (c <= 128406 || (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)))))
              : (c <= 128434 || (c < 128488
                ? (c < 128476
                  ? (c < 128450
                    ? c == 128444
                    : (c <= 128452 || (c >= 128465 && c <= 128467)))
                  : (c <= 128478 || (c < 128483
                    ? c == 128481
                    : c <= 128483)))
                : (c <= 128488 || (c < 128640
                  ? (c < 128499
                    ? c == 128495
                    : (c <= 128499 || (c >= 128506 && c <= 128591)))
                  : (c <= 128709 || (c < 128725
                    ? (c >= 128715 && c <= 128722)
                    : c <= 128727)))))))
            : (c <= 128741 || (c < 129712
              ? (c < 129292
                ? (c < 128755
                  ? (c < 128747
                    ? c == 128745
                    : (c <= 128748 || c == 128752))
                  : (c <= 128764 || (c < 129008
                    ? (c >= 128992 && c <= 129003)
                    : c <= 129008)))
                : (c <= 129338 || (c < 129656
                  ? (c < 129351
                    ? (c >= 129340 && c <= 129349)
                    : (c <= 129535 || (c >= 129648 && c <= 129652)))
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129776
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : (c <= 129753 || (c >= 129760 && c <= 129767)))
                  : (c <= 129782 || (c < 131072
                    ? (c >= 130032 && c <= 130041)
                    : c <= 173791)))
                : (c <= 177976 || (c < 194560
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : (c <= 183969 || (c >= 183984 && c <= 191456)))
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_9(int32_t c) {
  return (c < 43232
    ? (c < 4808
      ? (c < 2887
        ? (c < 2200
          ? (c < 1162
            ? (c < 710
              ? (c < 174
                ? (c < 'A'
                  ? (c < '*'
                    ? c == '#'
                    : (c <= '*' || (c >= '0' && c <= '9')))
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : (c <= 'y' || (c >= 169 && c <= 170)))))
                : (c <= 174 || (c < 192
                  ? (c < 183
                    ? c == 181
                    : (c <= 183 || c == 186))
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 895
                ? (c < 768
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : (c <= 748 || c == 750))
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 931
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : (c <= 908 || (c >= 910 && c <= 929)))
                  : (c <= 1013 || (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)))))))
            : (c <= 1327 || (c < 1749
              ? (c < 1476
                ? (c < 1425
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : (c <= 1369 || (c >= 1376 && c <= 1416)))
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))
                : (c <= 1477 || (c < 1552
                  ? (c < 1488
                    ? c == 1479
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 2042
                ? (c < 1808
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : (c <= 1788 || c == 1791))
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2144
                  ? (c < 2048
                    ? c == 2045
                    : (c <= 2093 || (c >= 2112 && c <= 2139)))
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))))))))
          : (c <= 2273 || (c < 2631
            ? (c < 2527
              ? (c < 2482
                ? (c < 2437
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : (c <= 2415 || (c >= 2417 && c <= 2435)))
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : (c <= 2472 || (c >= 2474 && c <= 2480)))))
                : (c <= 2482 || (c < 2507
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : (c <= 2500 || (c >= 2503 && c <= 2504)))
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))
              : (c <= 2531 || (c < 2579
                ? (c < 2561
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : (c <= 2556 || c == 2558))
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2616
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : (c <= 2611 || (c >= 2613 && c <= 2614)))
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))))
            : (c <= 2632 || (c < 2759
              ? (c < 2693
                ? (c < 2654
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : (c <= 2641 || (c >= 2649 && c <= 2652)))
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2738
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : (c <= 2728 || (c >= 2730 && c <= 2736)))
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))
              : (c <= 2761 || (c < 2821
                ? (c < 2790
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : (c <= 2768 || (c >= 2784 && c <= 2787)))
                  : (c <= 2799 || (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)))
                : (c <= 2828 || (c < 2866
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : (c <= 2856 || (c >= 2858 && c <= 2864)))
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))))))))
        : (c <= 2888 || (c < 3450
          ? (c < 3146
            ? (c < 2984
              ? (c < 2949
                ? (c < 2911
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : (c <= 2903 || (c >= 2908 && c <= 2909)))
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : (c <= 2929 || (c >= 2946 && c <= 2947)))))
                : (c <= 2954 || (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))))
              : (c <= 2986 || (c < 3046
                ? (c < 3018
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : (c <= 3010 || (c >= 3014 && c <= 3016)))
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))
                : (c <= 3055 || (c < 3114
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : (c <= 3088 || (c >= 3090 && c <= 3112)))
                  : (c <= 3129 || (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)))))))
            : (c <= 3149 || (c < 3274
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : (c <= 3162 || c == 3165))
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3253
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : (c <= 3240 || (c >= 3242 && c <= 3251)))
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3342
                ? (c < 3302
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : (c <= 3294 || (c >= 3296 && c <= 3299)))
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3412
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : (c <= 3400 || (c >= 3402 && c <= 3406)))
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))))
          : (c <= 3455 || (c < 3872
            ? (c < 3664
              ? (c < 3535
                ? (c < 3507
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : (c <= 3478 || (c >= 3482 && c <= 3505)))
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : (c <= 3526 || c == 3530))))
                : (c <= 3540 || (c < 3570
                  ? (c < 3544
                    ? c == 3542
                    : (c <= 3551 || (c >= 3558 && c <= 3567)))
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3776
                ? (c < 3724
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : (c <= 3716 || (c >= 3718 && c <= 3722)))
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))
                : (c <= 3780 || (c < 3804
                  ? (c < 3784
                    ? c == 3782
                    : (c <= 3789 || (c >= 3792 && c <= 3801)))
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))))))
            : (c <= 3881 || (c < 4301
              ? (c < 3974
                ? (c < 3902
                  ? (c < 3895
                    ? c == 3893
                    : (c <= 3895 || c == 3897))
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4176
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : (c <= 4038 || (c >= 4096 && c <= 4169)))
                  : (c <= 4253 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))))
              : (c <= 4301 || (c < 4704
                ? (c < 4688
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : (c <= 4680 || (c >= 4682 && c <= 4685)))
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4792
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : (c <= 4784 || (c >= 4786 && c <= 4789)))
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))))))))))
      : (c <= 4822 || (c < 9742
        ? (c < 7424
          ? (c < 6400
            ? (c < 5919
              ? (c < 5112
                ? (c < 4957
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : (c <= 4885 || (c >= 4888 && c <= 4954)))
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : (c <= 5007 || (c >= 5024 && c <= 5109)))))
                : (c <= 5117 || (c < 5792
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : (c <= 5759 || (c >= 5761 && c <= 5786)))
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))
              : (c <= 5940 || (c < 6108
                ? (c < 6002
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : (c <= 5996 || (c >= 5998 && c <= 6000)))
                  : (c <= 6003 || (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)))
                : (c <= 6109 || (c < 6176
                  ? (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : (c <= 6157 || (c >= 6159 && c <= 6169)))
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))))
            : (c <= 6430 || (c < 6832
              ? (c < 6608
                ? (c < 6512
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : (c <= 6459 || (c >= 6470 && c <= 6509)))
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))
                : (c <= 6618 || (c < 6783
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : (c <= 6750 || (c >= 6752 && c <= 6780)))
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))))
              : (c <= 6845 || (c < 7232
                ? (c < 7019
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : (c <= 6988 || (c >= 6992 && c <= 7001)))
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))
                : (c <= 7241 || (c < 7357
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : (c <= 7304 || (c >= 7312 && c <= 7354)))
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))))))))
          : (c <= 7957 || (c < 8421
            ? (c < 8150
              ? (c < 8031
                ? (c < 8016
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : (c <= 8005 || (c >= 8008 && c <= 8013)))
                  : (c <= 8023 || (c < 8027
                    ? c == 8025
                    : (c <= 8027 || c == 8029))))
                : (c <= 8061 || (c < 8130
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : (c <= 8124 || c == 8126))
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8265
                ? (c < 8205
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : (c <= 8180 || (c >= 8182 && c <= 8188)))
                  : (c <= 8205 || (c < 8255
                    ? c == 8252
                    : c <= 8256)))
                : (c <= 8265 || (c < 8336
                  ? (c < 8305
                    ? c == 8276
                    : (c <= 8305 || c == 8319))
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))))))
            : (c <= 8432 || (c < 8544
              ? (c < 8484
                ? (c < 8469
                  ? (c < 8455
                    ? c == 8450
                    : (c <= 8455 || (c >= 8458 && c <= 8467)))
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))
                : (c <= 8484 || (c < 8508
                  ? (c < 8488
                    ? c == 8486
                    : (c <= 8488 || (c >= 8490 && c <= 8505)))
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 9208
                ? (c < 9000
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : (c <= 8618 || (c >= 8986 && c <= 8987)))
                  : (c <= 9000 || (c < 9193
                    ? c == 9167
                    : c <= 9203)))
                : (c <= 9210 || (c < 9664
                  ? (c < 9642
                    ? c == 9410
                    : (c <= 9643 || c == 9654))
                  : (c <= 9664 || (c < 9728
                    ? (c >= 9723 && c <= 9726)
                    : c <= 9732)))))))))))
        : (c <= 9742 || (c < 10160
          ? (c < 9928
            ? (c < 9827
              ? (c < 9770
                ? (c < 9757
                  ? (c < 9748
                    ? c == 9745
                    : (c <= 9749 || c == 9752))
                  : (c <= 9757 || (c < 9762
                    ? c == 9760
                    : (c <= 9763 || c == 9766))))
                : (c <= 9770 || (c < 9794
                  ? (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : (c <= 9786 || c == 9792))
                  : (c <= 9794 || (c < 9823
                    ? (c >= 9800 && c <= 9811)
                    : c <= 9824)))))
              : (c <= 9827 || (c < 9883
                ? (c < 9854
                  ? (c < 9832
                    ? (c >= 9829 && c <= 9830)
                    : (c <= 9832 || c == 9851))
                  : (c <= 9855 || (c < 9881
                    ? (c >= 9874 && c <= 9879)
                    : c <= 9881)))
                : (c <= 9884 || (c < 9904
                  ? (c < 9895
                    ? (c >= 9888 && c <= 9889)
                    : (c <= 9895 || (c >= 9898 && c <= 9899)))
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))))
            : (c <= 9928 || (c < 10006
              ? (c < 9981
                ? (c < 9961
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : (c <= 9937 || (c >= 9939 && c <= 9940)))
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9999
                  ? (c < 9989
                    ? c == 9986
                    : (c <= 9989 || (c >= 9992 && c <= 9997)))
                  : (c <= 9999 || (c < 10004
                    ? c == 10002
                    : c <= 10004)))))
              : (c <= 10006 || (c < 10060
                ? (c < 10035
                  ? (c < 10017
                    ? c == 10013
                    : (c <= 10017 || c == 10024))
                  : (c <= 10036 || (c < 10055
                    ? c == 10052
                    : c <= 10055)))
                : (c <= 10060 || (c < 10083
                  ? (c < 10067
                    ? c == 10062
                    : (c <= 10069 || c == 10071))
                  : (c <= 10084 || (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)))))))))
          : (c <= 10160 || (c < 12445
            ? (c < 11680
              ? (c < 11499
                ? (c < 11035
                  ? (c < 10548
                    ? c == 10175
                    : (c <= 10549 || (c >= 11013 && c <= 11015)))
                  : (c <= 11036 || (c < 11093
                    ? c == 11088
                    : (c <= 11093 || (c >= 11264 && c <= 11492)))))
                : (c <= 11507 || (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))))
              : (c <= 11686 || (c < 11736
                ? (c < 11712
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : (c <= 11702 || (c >= 11704 && c <= 11710)))
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))
                : (c <= 11742 || (c < 12344
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : (c <= 12295 || (c >= 12321 && c <= 12341)))
                  : (c <= 12349 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))))
            : (c <= 12447 || (c < 42560
              ? (c < 12951
                ? (c < 12593
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : (c <= 12543 || (c >= 12549 && c <= 12591)))
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 12951 || (c < 42192
                  ? (c < 13312
                    ? c == 12953
                    : (c <= 19903 || (c >= 19968 && c <= 42124)))
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))
              : (c <= 42607 || (c < 42963
                ? (c < 42786
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : (c <= 42737 || (c >= 42775 && c <= 42783)))
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43072
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : (c <= 43047 || c == 43052))
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))))))))))))
    : (c <= 43255 || (c < 72818
      ? (c < 67840
        ? (c < 65313
          ? (c < 63744
            ? (c < 43762
              ? (c < 43520
                ? (c < 43360
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43309 || (c >= 43312 && c <= 43347)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : (c <= 43481 || (c >= 43488 && c <= 43518)))))
                : (c <= 43574 || (c < 43642
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : (c <= 43609 || (c >= 43616 && c <= 43638)))
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))))
              : (c <= 43766 || (c < 43868
                ? (c < 43808
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : (c <= 43790 || (c >= 43793 && c <= 43798)))
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : (c <= 44013 || (c >= 44016 && c <= 44025)))
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))))))
            : (c <= 64109 || (c < 64914
              ? (c < 64318
                ? (c < 64285
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : (c <= 64262 || (c >= 64275 && c <= 64279)))
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))
                : (c <= 64318 || (c < 64467
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : (c <= 64324 || (c >= 64326 && c <= 64433)))
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))
              : (c <= 64967 || (c < 65139
                ? (c < 65075
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65038 || (c >= 65056 && c <= 65071)))
                  : (c <= 65076 || (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65149
                  ? (c < 65145
                    ? c == 65143
                    : (c <= 65145 || c == 65147))
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66736
            ? (c < 65856
              ? (c < 65536
                ? (c < 65474
                  ? (c < 65345
                    ? c == 65343
                    : (c <= 65370 || (c >= 65382 && c <= 65470)))
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : (c <= 65495 || (c >= 65498 && c <= 65500)))))
                : (c <= 65547 || (c < 65599
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : (c <= 65594 || (c >= 65596 && c <= 65597)))
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66384
                ? (c < 66272
                  ? (c < 66176
                    ? c == 66045
                    : (c <= 66204 || (c >= 66208 && c <= 66256)))
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66513
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : (c <= 66499 || (c >= 66504 && c <= 66511)))
                  : (c <= 66517 || (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)))))))
            : (c <= 66771 || (c < 67424
              ? (c < 66964
                ? (c < 66928
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : (c <= 66855 || (c >= 66864 && c <= 66915)))
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))
                : (c <= 66965 || (c < 67003
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : (c <= 66993 || (c >= 66995 && c <= 67001)))
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))))
              : (c <= 67431 || (c < 67639
                ? (c < 67584
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : (c <= 67504 || (c >= 67506 && c <= 67514)))
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))
                : (c <= 67640 || (c < 67712
                  ? (c < 67647
                    ? c == 67644
                    : (c <= 67669 || (c >= 67680 && c <= 67702)))
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))))))))
        : (c <= 67861 || (c < 70384
          ? (c < 69424
            ? (c < 68352
              ? (c < 68121
                ? (c < 68096
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : (c <= 68023 || (c >= 68030 && c <= 68031)))
                  : (c <= 68099 || (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : (c <= 68115 || (c >= 68117 && c <= 68119)))))
                : (c <= 68149 || (c < 68224
                  ? (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : (c <= 68159 || (c >= 68192 && c <= 68220)))
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))
              : (c <= 68405 || (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : (c <= 69289 || (c >= 69291 && c <= 69292)))
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))))
            : (c <= 69456 || (c < 70006
              ? (c < 69826
                ? (c < 69632
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : (c <= 69572 || (c >= 69600 && c <= 69622)))
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69942
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : (c <= 69881 || (c >= 69888 && c <= 69940)))
                  : (c <= 69951 || (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)))))
              : (c <= 70006 || (c < 70206
                ? (c < 70108
                  ? (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : (c <= 70092 || (c >= 70094 && c <= 70106)))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)))
                : (c <= 70206 || (c < 70287
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : (c <= 70280 || (c >= 70282 && c <= 70285)))
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))))))))
          : (c <= 70393 || (c < 71360
            ? (c < 70512
              ? (c < 70459
                ? (c < 70419
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : (c <= 70412 || (c >= 70415 && c <= 70416)))
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : (c <= 70451 || (c >= 70453 && c <= 70457)))))
                : (c <= 70468 || (c < 70487
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : (c <= 70477 || c == 70480))
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))))
              : (c <= 70516 || (c < 71040
                ? (c < 70784
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : (c <= 70745 || (c >= 70750 && c <= 70753)))
                  : (c <= 70853 || (c < 70864
                    ? c == 70855
                    : c <= 70873)))
                : (c <= 71093 || (c < 71236
                  ? (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : (c <= 71133 || (c >= 71168 && c <= 71232)))
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))))))
            : (c <= 71369 || (c < 72016
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : (c <= 71467 || (c >= 71472 && c <= 71481)))
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71960
                  ? (c < 71948
                    ? c == 71945
                    : (c <= 71955 || (c >= 71957 && c <= 71958)))
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72272
                ? (c < 72163
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : (c <= 72151 || (c >= 72154 && c <= 72161)))
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72714
                  ? (c < 72368
                    ? c == 72349
                    : (c <= 72440 || (c >= 72704 && c <= 72712)))
                  : (c <= 72758 || (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)))))))))))))
      : (c <= 72847 || (c < 123584
        ? (c < 113821
          ? (c < 92880
            ? (c < 73120
              ? (c < 73023
                ? (c < 72968
                  ? (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : (c <= 72886 || (c >= 72960 && c <= 72966)))
                  : (c <= 72969 || (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : (c <= 73018 || (c >= 73020 && c <= 73021)))))
                : (c <= 73031 || (c < 73066
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : (c <= 73061 || (c >= 73063 && c <= 73064)))
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))))
              : (c <= 73129 || (c < 77824
                ? (c < 74752
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : (c <= 73648 || (c >= 73728 && c <= 74649)))
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))
                : (c <= 78894 || (c < 92768
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : (c <= 92728 || (c >= 92736 && c <= 92766)))
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))))))
            : (c <= 92909 || (c < 94208
              ? (c < 93760
                ? (c < 93008
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : (c <= 92982 || (c >= 92992 && c <= 92995)))
                  : (c <= 93017 || (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)))
                : (c <= 93823 || (c < 94176
                  ? (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : (c <= 94087 || (c >= 94095 && c <= 94111)))
                  : (c <= 94177 || (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)))))
              : (c <= 100343 || (c < 110928
                ? (c < 110581
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : (c <= 101640 || (c >= 110576 && c <= 110579)))
                  : (c <= 110587 || (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)))
                : (c <= 110930 || (c < 113776
                  ? (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : (c <= 111355 || (c >= 113664 && c <= 113770)))
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))))))
          : (c <= 113822 || (c < 120514
            ? (c < 119982
              ? (c < 119362
                ? (c < 119149
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : (c <= 118598 || (c >= 119141 && c <= 119145)))
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : (c <= 119179 || (c >= 119210 && c <= 119213)))))
                : (c <= 119364 || (c < 119970
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : (c <= 119964 || (c >= 119966 && c <= 119967)))
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))))
              : (c <= 119993 || (c < 120094
                ? (c < 120071
                  ? (c < 119997
                    ? c == 119995
                    : (c <= 120003 || (c >= 120005 && c <= 120069)))
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))
                : (c <= 120121 || (c < 120138
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : (c <= 120132 || c == 120134))
                  : (c <= 120144 || (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)))))))
            : (c <= 120538 || (c < 121476
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120572
                    ? (c >= 120540 && c <= 120570)
                    : (c <= 120596 || (c >= 120598 && c <= 120628)))
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 121344
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : (c <= 120779 || (c >= 120782 && c <= 120831)))
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))))
              : (c <= 121476 || (c < 122915
                ? (c < 122880
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : (c <= 121519 || (c >= 122624 && c <= 122654)))
                  : (c <= 122886 || (c < 122907
                    ? (c >= 122888 && c <= 122904)
                    : c <= 122913)))
                : (c <= 122916 || (c < 123200
                  ? (c < 123136
                    ? (c >= 122918 && c <= 122922)
                    : (c <= 123180 || (c >= 123184 && c <= 123197)))
                  : (c <= 123209 || (c < 123536
                    ? c == 123214
                    : c <= 123566)))))))))))
        : (c <= 123641 || (c < 127897
          ? (c < 126559
            ? (c < 126516
              ? (c < 125264
                ? (c < 124912
                  ? (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : (c <= 124907 || (c >= 124909 && c <= 124910)))
                  : (c <= 124926 || (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : (c <= 125142 || (c >= 125184 && c <= 125259)))))
                : (c <= 125273 || (c < 126500
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : (c <= 126495 || (c >= 126497 && c <= 126498)))
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126541
                ? (c < 126535
                  ? (c < 126523
                    ? c == 126521
                    : (c <= 126523 || c == 126530))
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126553
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : (c <= 126548 || c == 126551))
                  : (c <= 126553 || (c < 126557
                    ? c == 126555
                    : c <= 126557)))))))
            : (c <= 126559 || (c < 127183
              ? (c < 126590
                ? (c < 126572
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : (c <= 126564 || (c >= 126567 && c <= 126570)))
                  : (c <= 126578 || (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)))
                : (c <= 126590 || (c < 126629
                  ? (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : (c <= 126619 || (c >= 126625 && c <= 126627)))
                  : (c <= 126633 || (c < 126980
                    ? (c >= 126635 && c <= 126651)
                    : c <= 126980)))))
              : (c <= 127183 || (c < 127514
                ? (c < 127377
                  ? (c < 127358
                    ? (c >= 127344 && c <= 127345)
                    : (c <= 127359 || c == 127374))
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))
                : (c <= 127514 || (c < 127744
                  ? (c < 127538
                    ? c == 127535
                    : (c <= 127546 || (c >= 127568 && c <= 127569)))
                  : (c <= 127777 || (c < 127894
                    ? (c >= 127780 && c <= 127891)
                    : c <= 127895)))))))))
          : (c <= 127899 || (c < 128733
            ? (c < 128433
              ? (c < 128371
                ? (c < 128255
                  ? (c < 127987
                    ? (c >= 127902 && c <= 127984)
                    : (c <= 127989 || (c >= 127991 && c <= 128253)))
                  : (c <= 128317 || (c < 128336
                    ? (c >= 128329 && c <= 128334)
                    : (c <= 128359 || (c >= 128367 && c <= 128368)))))
                : (c <= 128378 || (c < 128405
                  ? (c < 128394
                    ? c == 128391
                    : (c <= 128397 || c == 128400))
                  : (c <= 128406 || (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)))))
              : (c <= 128434 || (c < 128488
                ? (c < 128476
                  ? (c < 128450
                    ? c == 128444
                    : (c <= 128452 || (c >= 128465 && c <= 128467)))
                  : (c <= 128478 || (c < 128483
                    ? c == 128481
                    : c <= 128483)))
                : (c <= 128488 || (c < 128640
                  ? (c < 128499
                    ? c == 128495
                    : (c <= 128499 || (c >= 128506 && c <= 128591)))
                  : (c <= 128709 || (c < 128725
                    ? (c >= 128715 && c <= 128722)
                    : c <= 128727)))))))
            : (c <= 128741 || (c < 129712
              ? (c < 129292
                ? (c < 128755
                  ? (c < 128747
                    ? c == 128745
                    : (c <= 128748 || c == 128752))
                  : (c <= 128764 || (c < 129008
                    ? (c >= 128992 && c <= 129003)
                    : c <= 129008)))
                : (c <= 129338 || (c < 129656
                  ? (c < 129351
                    ? (c >= 129340 && c <= 129349)
                    : (c <= 129535 || (c >= 129648 && c <= 129652)))
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129776
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : (c <= 129753 || (c >= 129760 && c <= 129767)))
                  : (c <= 129782 || (c < 131072
                    ? (c >= 130032 && c <= 130041)
                    : c <= 173791)))
                : (c <= 177976 || (c < 194560
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : (c <= 183969 || (c >= 183984 && c <= 191456)))
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token1_character_set_10(int32_t c) {
  return (c < 43232
    ? (c < 4808
      ? (c < 2887
        ? (c < 2200
          ? (c < 1162
            ? (c < 710
              ? (c < 174
                ? (c < 'A'
                  ? (c < '*'
                    ? c == '#'
                    : (c <= '*' || (c >= '0' && c <= '9')))
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : (c <= 'z' || (c >= 169 && c <= 170)))))
                : (c <= 174 || (c < 192
                  ? (c < 183
                    ? c == 181
                    : (c <= 183 || c == 186))
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 895
                ? (c < 768
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : (c <= 748 || c == 750))
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 931
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : (c <= 908 || (c >= 910 && c <= 929)))
                  : (c <= 1013 || (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)))))))
            : (c <= 1327 || (c < 1749
              ? (c < 1476
                ? (c < 1425
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : (c <= 1369 || (c >= 1376 && c <= 1416)))
                  : (c <= 1469 || (c < 1473
                    ? c == 1471
                    : c <= 1474)))
                : (c <= 1477 || (c < 1552
                  ? (c < 1488
                    ? c == 1479
                    : (c <= 1514 || (c >= 1519 && c <= 1522)))
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 2042
                ? (c < 1808
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : (c <= 1788 || c == 1791))
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2144
                  ? (c < 2048
                    ? c == 2045
                    : (c <= 2093 || (c >= 2112 && c <= 2139)))
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))))))))
          : (c <= 2273 || (c < 2631
            ? (c < 2527
              ? (c < 2482
                ? (c < 2437
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : (c <= 2415 || (c >= 2417 && c <= 2435)))
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : (c <= 2472 || (c >= 2474 && c <= 2480)))))
                : (c <= 2482 || (c < 2507
                  ? (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : (c <= 2500 || (c >= 2503 && c <= 2504)))
                  : (c <= 2510 || (c < 2524
                    ? c == 2519
                    : c <= 2525)))))
              : (c <= 2531 || (c < 2579
                ? (c < 2561
                  ? (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : (c <= 2556 || c == 2558))
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))
                : (c <= 2600 || (c < 2616
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : (c <= 2611 || (c >= 2613 && c <= 2614)))
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))))
            : (c <= 2632 || (c < 2759
              ? (c < 2693
                ? (c < 2654
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : (c <= 2641 || (c >= 2649 && c <= 2652)))
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2738
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : (c <= 2728 || (c >= 2730 && c <= 2736)))
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))
              : (c <= 2761 || (c < 2821
                ? (c < 2790
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : (c <= 2768 || (c >= 2784 && c <= 2787)))
                  : (c <= 2799 || (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)))
                : (c <= 2828 || (c < 2866
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : (c <= 2856 || (c >= 2858 && c <= 2864)))
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))))))))
        : (c <= 2888 || (c < 3450
          ? (c < 3146
            ? (c < 2984
              ? (c < 2949
                ? (c < 2911
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : (c <= 2903 || (c >= 2908 && c <= 2909)))
                  : (c <= 2915 || (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : (c <= 2929 || (c >= 2946 && c <= 2947)))))
                : (c <= 2954 || (c < 2972
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : (c <= 2965 || (c >= 2969 && c <= 2970)))
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))))
              : (c <= 2986 || (c < 3046
                ? (c < 3018
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : (c <= 3010 || (c >= 3014 && c <= 3016)))
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))
                : (c <= 3055 || (c < 3114
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : (c <= 3088 || (c >= 3090 && c <= 3112)))
                  : (c <= 3129 || (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)))))))
            : (c <= 3149 || (c < 3274
              ? (c < 3205
                ? (c < 3168
                  ? (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : (c <= 3162 || c == 3165))
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))
                : (c <= 3212 || (c < 3253
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : (c <= 3240 || (c >= 3242 && c <= 3251)))
                  : (c <= 3257 || (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)))))
              : (c <= 3277 || (c < 3342
                ? (c < 3302
                  ? (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : (c <= 3294 || (c >= 3296 && c <= 3299)))
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3412
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : (c <= 3400 || (c >= 3402 && c <= 3406)))
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))))
          : (c <= 3455 || (c < 3872
            ? (c < 3664
              ? (c < 3535
                ? (c < 3507
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : (c <= 3478 || (c >= 3482 && c <= 3505)))
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : (c <= 3526 || c == 3530))))
                : (c <= 3540 || (c < 3570
                  ? (c < 3544
                    ? c == 3542
                    : (c <= 3551 || (c >= 3558 && c <= 3567)))
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3776
                ? (c < 3724
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : (c <= 3716 || (c >= 3718 && c <= 3722)))
                  : (c <= 3747 || (c < 3751
                    ? c == 3749
                    : c <= 3773)))
                : (c <= 3780 || (c < 3804
                  ? (c < 3784
                    ? c == 3782
                    : (c <= 3789 || (c >= 3792 && c <= 3801)))
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))))))
            : (c <= 3881 || (c < 4301
              ? (c < 3974
                ? (c < 3902
                  ? (c < 3895
                    ? c == 3893
                    : (c <= 3895 || c == 3897))
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))
                : (c <= 3991 || (c < 4176
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : (c <= 4038 || (c >= 4096 && c <= 4169)))
                  : (c <= 4253 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))))
              : (c <= 4301 || (c < 4704
                ? (c < 4688
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : (c <= 4680 || (c >= 4682 && c <= 4685)))
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))
                : (c <= 4744 || (c < 4792
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : (c <= 4784 || (c >= 4786 && c <= 4789)))
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))))))))))))
      : (c <= 4822 || (c < 9742
        ? (c < 7424
          ? (c < 6400
            ? (c < 5919
              ? (c < 5112
                ? (c < 4957
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : (c <= 4885 || (c >= 4888 && c <= 4954)))
                  : (c <= 4959 || (c < 4992
                    ? (c >= 4969 && c <= 4977)
                    : (c <= 5007 || (c >= 5024 && c <= 5109)))))
                : (c <= 5117 || (c < 5792
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : (c <= 5759 || (c >= 5761 && c <= 5786)))
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))
              : (c <= 5940 || (c < 6108
                ? (c < 6002
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : (c <= 5996 || (c >= 5998 && c <= 6000)))
                  : (c <= 6003 || (c < 6103
                    ? (c >= 6016 && c <= 6099)
                    : c <= 6103)))
                : (c <= 6109 || (c < 6176
                  ? (c < 6155
                    ? (c >= 6112 && c <= 6121)
                    : (c <= 6157 || (c >= 6159 && c <= 6169)))
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))))
            : (c <= 6430 || (c < 6832
              ? (c < 6608
                ? (c < 6512
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : (c <= 6459 || (c >= 6470 && c <= 6509)))
                  : (c <= 6516 || (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)))
                : (c <= 6618 || (c < 6783
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : (c <= 6750 || (c >= 6752 && c <= 6780)))
                  : (c <= 6793 || (c < 6823
                    ? (c >= 6800 && c <= 6809)
                    : c <= 6823)))))
              : (c <= 6845 || (c < 7232
                ? (c < 7019
                  ? (c < 6912
                    ? (c >= 6847 && c <= 6862)
                    : (c <= 6988 || (c >= 6992 && c <= 7001)))
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))
                : (c <= 7241 || (c < 7357
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : (c <= 7304 || (c >= 7312 && c <= 7354)))
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))))))))
          : (c <= 7957 || (c < 8421
            ? (c < 8150
              ? (c < 8031
                ? (c < 8016
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : (c <= 8005 || (c >= 8008 && c <= 8013)))
                  : (c <= 8023 || (c < 8027
                    ? c == 8025
                    : (c <= 8027 || c == 8029))))
                : (c <= 8061 || (c < 8130
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : (c <= 8124 || c == 8126))
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))))
              : (c <= 8155 || (c < 8265
                ? (c < 8205
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : (c <= 8180 || (c >= 8182 && c <= 8188)))
                  : (c <= 8205 || (c < 8255
                    ? c == 8252
                    : c <= 8256)))
                : (c <= 8265 || (c < 8336
                  ? (c < 8305
                    ? c == 8276
                    : (c <= 8305 || c == 8319))
                  : (c <= 8348 || (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)))))))
            : (c <= 8432 || (c < 8544
              ? (c < 8484
                ? (c < 8469
                  ? (c < 8455
                    ? c == 8450
                    : (c <= 8455 || (c >= 8458 && c <= 8467)))
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))
                : (c <= 8484 || (c < 8508
                  ? (c < 8488
                    ? c == 8486
                    : (c <= 8488 || (c >= 8490 && c <= 8505)))
                  : (c <= 8511 || (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)))))
              : (c <= 8584 || (c < 9208
                ? (c < 9000
                  ? (c < 8617
                    ? (c >= 8596 && c <= 8601)
                    : (c <= 8618 || (c >= 8986 && c <= 8987)))
                  : (c <= 9000 || (c < 9193
                    ? c == 9167
                    : c <= 9203)))
                : (c <= 9210 || (c < 9664
                  ? (c < 9642
                    ? c == 9410
                    : (c <= 9643 || c == 9654))
                  : (c <= 9664 || (c < 9728
                    ? (c >= 9723 && c <= 9726)
                    : c <= 9732)))))))))))
        : (c <= 9742 || (c < 10160
          ? (c < 9928
            ? (c < 9827
              ? (c < 9770
                ? (c < 9757
                  ? (c < 9748
                    ? c == 9745
                    : (c <= 9749 || c == 9752))
                  : (c <= 9757 || (c < 9762
                    ? c == 9760
                    : (c <= 9763 || c == 9766))))
                : (c <= 9770 || (c < 9794
                  ? (c < 9784
                    ? (c >= 9774 && c <= 9775)
                    : (c <= 9786 || c == 9792))
                  : (c <= 9794 || (c < 9823
                    ? (c >= 9800 && c <= 9811)
                    : c <= 9824)))))
              : (c <= 9827 || (c < 9883
                ? (c < 9854
                  ? (c < 9832
                    ? (c >= 9829 && c <= 9830)
                    : (c <= 9832 || c == 9851))
                  : (c <= 9855 || (c < 9881
                    ? (c >= 9874 && c <= 9879)
                    : c <= 9881)))
                : (c <= 9884 || (c < 9904
                  ? (c < 9895
                    ? (c >= 9888 && c <= 9889)
                    : (c <= 9895 || (c >= 9898 && c <= 9899)))
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))))
            : (c <= 9928 || (c < 10006
              ? (c < 9981
                ? (c < 9961
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : (c <= 9937 || (c >= 9939 && c <= 9940)))
                  : (c <= 9962 || (c < 9975
                    ? (c >= 9968 && c <= 9973)
                    : c <= 9978)))
                : (c <= 9981 || (c < 9999
                  ? (c < 9989
                    ? c == 9986
                    : (c <= 9989 || (c >= 9992 && c <= 9997)))
                  : (c <= 9999 || (c < 10004
                    ? c == 10002
                    : c <= 10004)))))
              : (c <= 10006 || (c < 10060
                ? (c < 10035
                  ? (c < 10017
                    ? c == 10013
                    : (c <= 10017 || c == 10024))
                  : (c <= 10036 || (c < 10055
                    ? c == 10052
                    : c <= 10055)))
                : (c <= 10060 || (c < 10083
                  ? (c < 10067
                    ? c == 10062
                    : (c <= 10069 || c == 10071))
                  : (c <= 10084 || (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)))))))))
          : (c <= 10160 || (c < 12445
            ? (c < 11680
              ? (c < 11499
                ? (c < 11035
                  ? (c < 10548
                    ? c == 10175
                    : (c <= 10549 || (c >= 11013 && c <= 11015)))
                  : (c <= 11036 || (c < 11093
                    ? c == 11088
                    : (c <= 11093 || (c >= 11264 && c <= 11492)))))
                : (c <= 11507 || (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))))
              : (c <= 11686 || (c < 11736
                ? (c < 11712
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : (c <= 11702 || (c >= 11704 && c <= 11710)))
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))
                : (c <= 11742 || (c < 12344
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : (c <= 12295 || (c >= 12321 && c <= 12341)))
                  : (c <= 12349 || (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)))))))
            : (c <= 12447 || (c < 42560
              ? (c < 12951
                ? (c < 12593
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : (c <= 12543 || (c >= 12549 && c <= 12591)))
                  : (c <= 12686 || (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)))
                : (c <= 12951 || (c < 42192
                  ? (c < 13312
                    ? c == 12953
                    : (c <= 19903 || (c >= 19968 && c <= 42124)))
                  : (c <= 42237 || (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)))))
              : (c <= 42607 || (c < 42963
                ? (c < 42786
                  ? (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : (c <= 42737 || (c >= 42775 && c <= 42783)))
                  : (c <= 42888 || (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)))
                : (c <= 42963 || (c < 43072
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : (c <= 43047 || c == 43052))
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))))))))))))
    : (c <= 43255 || (c < 72818
      ? (c < 67840
        ? (c < 65313
          ? (c < 63744
            ? (c < 43762
              ? (c < 43520
                ? (c < 43360
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43309 || (c >= 43312 && c <= 43347)))
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : (c <= 43481 || (c >= 43488 && c <= 43518)))))
                : (c <= 43574 || (c < 43642
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : (c <= 43609 || (c >= 43616 && c <= 43638)))
                  : (c <= 43714 || (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)))))
              : (c <= 43766 || (c < 43868
                ? (c < 43808
                  ? (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : (c <= 43790 || (c >= 43793 && c <= 43798)))
                  : (c <= 43814 || (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)))
                : (c <= 43881 || (c < 44032
                  ? (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : (c <= 44013 || (c >= 44016 && c <= 44025)))
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))))))
            : (c <= 64109 || (c < 64914
              ? (c < 64318
                ? (c < 64285
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : (c <= 64262 || (c >= 64275 && c <= 64279)))
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))
                : (c <= 64318 || (c < 64467
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : (c <= 64324 || (c >= 64326 && c <= 64433)))
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))
              : (c <= 64967 || (c < 65139
                ? (c < 65075
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65039 || (c >= 65056 && c <= 65071)))
                  : (c <= 65076 || (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65149
                  ? (c < 65145
                    ? c == 65143
                    : (c <= 65145 || c == 65147))
                  : (c <= 65149 || (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)))))))))
          : (c <= 65338 || (c < 66736
            ? (c < 65856
              ? (c < 65536
                ? (c < 65474
                  ? (c < 65345
                    ? c == 65343
                    : (c <= 65370 || (c >= 65382 && c <= 65470)))
                  : (c <= 65479 || (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : (c <= 65495 || (c >= 65498 && c <= 65500)))))
                : (c <= 65547 || (c < 65599
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : (c <= 65594 || (c >= 65596 && c <= 65597)))
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66384
                ? (c < 66272
                  ? (c < 66176
                    ? c == 66045
                    : (c <= 66204 || (c >= 66208 && c <= 66256)))
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66513
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : (c <= 66499 || (c >= 66504 && c <= 66511)))
                  : (c <= 66517 || (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)))))))
            : (c <= 66771 || (c < 67424
              ? (c < 66964
                ? (c < 66928
                  ? (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : (c <= 66855 || (c >= 66864 && c <= 66915)))
                  : (c <= 66938 || (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)))
                : (c <= 66965 || (c < 67003
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : (c <= 66993 || (c >= 66995 && c <= 67001)))
                  : (c <= 67004 || (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)))))
              : (c <= 67431 || (c < 67639
                ? (c < 67584
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : (c <= 67504 || (c >= 67506 && c <= 67514)))
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))
                : (c <= 67640 || (c < 67712
                  ? (c < 67647
                    ? c == 67644
                    : (c <= 67669 || (c >= 67680 && c <= 67702)))
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))))))))
        : (c <= 67861 || (c < 70384
          ? (c < 69424
            ? (c < 68352
              ? (c < 68121
                ? (c < 68096
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : (c <= 68023 || (c >= 68030 && c <= 68031)))
                  : (c <= 68099 || (c < 68108
                    ? (c >= 68101 && c <= 68102)
                    : (c <= 68115 || (c >= 68117 && c <= 68119)))))
                : (c <= 68149 || (c < 68224
                  ? (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : (c <= 68159 || (c >= 68192 && c <= 68220)))
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)))))
              : (c <= 68405 || (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68903 || (c < 69296
                  ? (c < 69248
                    ? (c >= 68912 && c <= 68921)
                    : (c <= 69289 || (c >= 69291 && c <= 69292)))
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))))
            : (c <= 69456 || (c < 70006
              ? (c < 69826
                ? (c < 69632
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : (c <= 69572 || (c >= 69600 && c <= 69622)))
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69942
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : (c <= 69881 || (c >= 69888 && c <= 69940)))
                  : (c <= 69951 || (c < 69968
                    ? (c >= 69956 && c <= 69959)
                    : c <= 70003)))))
              : (c <= 70006 || (c < 70206
                ? (c < 70108
                  ? (c < 70089
                    ? (c >= 70016 && c <= 70084)
                    : (c <= 70092 || (c >= 70094 && c <= 70106)))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)))
                : (c <= 70206 || (c < 70287
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : (c <= 70280 || (c >= 70282 && c <= 70285)))
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)))))))))
          : (c <= 70393 || (c < 71360
            ? (c < 70512
              ? (c < 70459
                ? (c < 70419
                  ? (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : (c <= 70412 || (c >= 70415 && c <= 70416)))
                  : (c <= 70440 || (c < 70450
                    ? (c >= 70442 && c <= 70448)
                    : (c <= 70451 || (c >= 70453 && c <= 70457)))))
                : (c <= 70468 || (c < 70487
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : (c <= 70477 || c == 70480))
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))))
              : (c <= 70516 || (c < 71040
                ? (c < 70784
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : (c <= 70745 || (c >= 70750 && c <= 70753)))
                  : (c <= 70853 || (c < 70864
                    ? c == 70855
                    : c <= 70873)))
                : (c <= 71093 || (c < 71236
                  ? (c < 71128
                    ? (c >= 71096 && c <= 71104)
                    : (c <= 71133 || (c >= 71168 && c <= 71232)))
                  : (c <= 71236 || (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)))))))
            : (c <= 71369 || (c < 72016
              ? (c < 71935
                ? (c < 71488
                  ? (c < 71453
                    ? (c >= 71424 && c <= 71450)
                    : (c <= 71467 || (c >= 71472 && c <= 71481)))
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71738)
                    : c <= 71913)))
                : (c <= 71942 || (c < 71960
                  ? (c < 71948
                    ? c == 71945
                    : (c <= 71955 || (c >= 71957 && c <= 71958)))
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72272
                ? (c < 72163
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : (c <= 72151 || (c >= 72154 && c <= 72161)))
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72714
                  ? (c < 72368
                    ? c == 72349
                    : (c <= 72440 || (c >= 72704 && c <= 72712)))
                  : (c <= 72758 || (c < 72784
                    ? (c >= 72760 && c <= 72768)
                    : c <= 72793)))))))))))))
      : (c <= 72847 || (c < 123584
        ? (c < 113821
          ? (c < 92880
            ? (c < 73120
              ? (c < 73023
                ? (c < 72968
                  ? (c < 72873
                    ? (c >= 72850 && c <= 72871)
                    : (c <= 72886 || (c >= 72960 && c <= 72966)))
                  : (c <= 72969 || (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : (c <= 73018 || (c >= 73020 && c <= 73021)))))
                : (c <= 73031 || (c < 73066
                  ? (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : (c <= 73061 || (c >= 73063 && c <= 73064)))
                  : (c <= 73102 || (c < 73107
                    ? (c >= 73104 && c <= 73105)
                    : c <= 73112)))))
              : (c <= 73129 || (c < 77824
                ? (c < 74752
                  ? (c < 73648
                    ? (c >= 73440 && c <= 73462)
                    : (c <= 73648 || (c >= 73728 && c <= 74649)))
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))
                : (c <= 78894 || (c < 92768
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : (c <= 92728 || (c >= 92736 && c <= 92766)))
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))))))
            : (c <= 92909 || (c < 94208
              ? (c < 93760
                ? (c < 93008
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : (c <= 92982 || (c >= 92992 && c <= 92995)))
                  : (c <= 93017 || (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)))
                : (c <= 93823 || (c < 94176
                  ? (c < 94031
                    ? (c >= 93952 && c <= 94026)
                    : (c <= 94087 || (c >= 94095 && c <= 94111)))
                  : (c <= 94177 || (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)))))
              : (c <= 100343 || (c < 110928
                ? (c < 110581
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : (c <= 101640 || (c >= 110576 && c <= 110579)))
                  : (c <= 110587 || (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)))
                : (c <= 110930 || (c < 113776
                  ? (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : (c <= 111355 || (c >= 113664 && c <= 113770)))
                  : (c <= 113788 || (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)))))))))
          : (c <= 113822 || (c < 120514
            ? (c < 119982
              ? (c < 119362
                ? (c < 119149
                  ? (c < 118576
                    ? (c >= 118528 && c <= 118573)
                    : (c <= 118598 || (c >= 119141 && c <= 119145)))
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : (c <= 119179 || (c >= 119210 && c <= 119213)))))
                : (c <= 119364 || (c < 119970
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : (c <= 119964 || (c >= 119966 && c <= 119967)))
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))))
              : (c <= 119993 || (c < 120094
                ? (c < 120071
                  ? (c < 119997
                    ? c == 119995
                    : (c <= 120003 || (c >= 120005 && c <= 120069)))
                  : (c <= 120074 || (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)))
                : (c <= 120121 || (c < 120138
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : (c <= 120132 || c == 120134))
                  : (c <= 120144 || (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)))))))
            : (c <= 120538 || (c < 121476
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120572
                    ? (c >= 120540 && c <= 120570)
                    : (c <= 120596 || (c >= 120598 && c <= 120628)))
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 121344
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : (c <= 120779 || (c >= 120782 && c <= 120831)))
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))))
              : (c <= 121476 || (c < 122915
                ? (c < 122880
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : (c <= 121519 || (c >= 122624 && c <= 122654)))
                  : (c <= 122886 || (c < 122907
                    ? (c >= 122888 && c <= 122904)
                    : c <= 122913)))
                : (c <= 122916 || (c < 123200
                  ? (c < 123136
                    ? (c >= 122918 && c <= 122922)
                    : (c <= 123180 || (c >= 123184 && c <= 123197)))
                  : (c <= 123209 || (c < 123536
                    ? c == 123214
                    : c <= 123566)))))))))))
        : (c <= 123641 || (c < 127897
          ? (c < 126559
            ? (c < 126516
              ? (c < 125264
                ? (c < 124912
                  ? (c < 124904
                    ? (c >= 124896 && c <= 124902)
                    : (c <= 124907 || (c >= 124909 && c <= 124910)))
                  : (c <= 124926 || (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : (c <= 125142 || (c >= 125184 && c <= 125259)))))
                : (c <= 125273 || (c < 126500
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : (c <= 126495 || (c >= 126497 && c <= 126498)))
                  : (c <= 126500 || (c < 126505
                    ? c == 126503
                    : c <= 126514)))))
              : (c <= 126519 || (c < 126541
                ? (c < 126535
                  ? (c < 126523
                    ? c == 126521
                    : (c <= 126523 || c == 126530))
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126553
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : (c <= 126548 || c == 126551))
                  : (c <= 126553 || (c < 126557
                    ? c == 126555
                    : c <= 126557)))))))
            : (c <= 126559 || (c < 127183
              ? (c < 126590
                ? (c < 126572
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : (c <= 126564 || (c >= 126567 && c <= 126570)))
                  : (c <= 126578 || (c < 126585
                    ? (c >= 126580 && c <= 126583)
                    : c <= 126588)))
                : (c <= 126590 || (c < 126629
                  ? (c < 126603
                    ? (c >= 126592 && c <= 126601)
                    : (c <= 126619 || (c >= 126625 && c <= 126627)))
                  : (c <= 126633 || (c < 126980
                    ? (c >= 126635 && c <= 126651)
                    : c <= 126980)))))
              : (c <= 127183 || (c < 127514
                ? (c < 127377
                  ? (c < 127358
                    ? (c >= 127344 && c <= 127345)
                    : (c <= 127359 || c == 127374))
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))
                : (c <= 127514 || (c < 127744
                  ? (c < 127538
                    ? c == 127535
                    : (c <= 127546 || (c >= 127568 && c <= 127569)))
                  : (c <= 127777 || (c < 127894
                    ? (c >= 127780 && c <= 127891)
                    : c <= 127895)))))))))
          : (c <= 127899 || (c < 128733
            ? (c < 128433
              ? (c < 128371
                ? (c < 128255
                  ? (c < 127987
                    ? (c >= 127902 && c <= 127984)
                    : (c <= 127989 || (c >= 127991 && c <= 128253)))
                  : (c <= 128317 || (c < 128336
                    ? (c >= 128329 && c <= 128334)
                    : (c <= 128359 || (c >= 128367 && c <= 128368)))))
                : (c <= 128378 || (c < 128405
                  ? (c < 128394
                    ? c == 128391
                    : (c <= 128397 || c == 128400))
                  : (c <= 128406 || (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)))))
              : (c <= 128434 || (c < 128488
                ? (c < 128476
                  ? (c < 128450
                    ? c == 128444
                    : (c <= 128452 || (c >= 128465 && c <= 128467)))
                  : (c <= 128478 || (c < 128483
                    ? c == 128481
                    : c <= 128483)))
                : (c <= 128488 || (c < 128640
                  ? (c < 128499
                    ? c == 128495
                    : (c <= 128499 || (c >= 128506 && c <= 128591)))
                  : (c <= 128709 || (c < 128725
                    ? (c >= 128715 && c <= 128722)
                    : c <= 128727)))))))
            : (c <= 128741 || (c < 129712
              ? (c < 129292
                ? (c < 128755
                  ? (c < 128747
                    ? c == 128745
                    : (c <= 128748 || c == 128752))
                  : (c <= 128764 || (c < 129008
                    ? (c >= 128992 && c <= 129003)
                    : c <= 129008)))
                : (c <= 129338 || (c < 129656
                  ? (c < 129351
                    ? (c >= 129340 && c <= 129349)
                    : (c <= 129535 || (c >= 129648 && c <= 129652)))
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129776
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : (c <= 129753 || (c >= 129760 && c <= 129767)))
                  : (c <= 129782 || (c < 131072
                    ? (c >= 130032 && c <= 130041)
                    : c <= 173791)))
                : (c <= 177976 || (c < 194560
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : (c <= 183969 || (c >= 183984 && c <= 191456)))
                  : (c <= 195101 || (c < 917760
                    ? (c >= 196608 && c <= 201546)
                    : c <= 917999)))))))))))))))));
}

static inline bool aux_sym_simple_identifier_token4_character_set_1(int32_t c) {
  return (c < 43250
    ? (c < 5952
      ? (c < 2929
        ? (c < 2144
          ? (c < 1329
            ? (c < 748
              ? (c < 186
                ? (c < 169
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : (c <= '_' || (c >= 'a' && c <= 'z')))
                  : (c <= 170 || (c < 181
                    ? c == 174
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)))))
              : (c <= 748 || (c < 904
                ? (c < 891
                  ? (c < 880
                    ? c == 750
                    : (c <= 884 || (c >= 886 && c <= 887)))
                  : (c <= 893 || (c < 902
                    ? c == 895
                    : c <= 902)))
                : (c <= 906 || (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)))))))
            : (c <= 1366 || (c < 1808
              ? (c < 1649
                ? (c < 1519
                  ? (c < 1376
                    ? c == 1369
                    : (c <= 1416 || (c >= 1488 && c <= 1514)))
                  : (c <= 1522 || (c < 1646
                    ? (c >= 1568 && c <= 1610)
                    : c <= 1647)))
                : (c <= 1747 || (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c < 1791
                    ? (c >= 1786 && c <= 1788)
                    : c <= 1791)))))
              : (c <= 1808 || (c < 2042
                ? (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)))
                : (c <= 2042 || (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || (c < 2112
                    ? c == 2088
                    : c <= 2136)))))))))
          : (c <= 2154 || (c < 2610
            ? (c < 2482
              ? (c < 2392
                ? (c < 2308
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : (c <= 2190 || (c >= 2208 && c <= 2249)))
                  : (c <= 2361 || (c < 2384
                    ? c == 2365
                    : c <= 2384)))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)))))
              : (c <= 2482 || (c < 2544
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))))))
            : (c <= 2611 || (c < 2768
              ? (c < 2703
                ? (c < 2654
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : (c <= 2617 || (c >= 2649 && c <= 2652)))
                  : (c <= 2654 || (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)))))
              : (c <= 2768 || (c < 2858
                ? (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))
                : (c <= 2864 || (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)))))))))))
        : (c <= 2929 || (c < 3749
          ? (c < 3253
            ? (c < 3086
              ? (c < 2974
                ? (c < 2962
                  ? (c < 2949
                    ? c == 2947
                    : (c <= 2954 || (c >= 2958 && c <= 2960)))
                  : (c <= 2965 || (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || (c < 3077
                    ? c == 3024
                    : c <= 3084)))))
              : (c <= 3088 || (c < 3168
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))))))
            : (c <= 3257 || (c < 3461
              ? (c < 3346
                ? (c < 3313
                  ? (c < 3293
                    ? c == 3261
                    : (c <= 3294 || (c >= 3296 && c <= 3297)))
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3386 || (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)))))
              : (c <= 3478 || (c < 3634
                ? (c < 3517
                  ? (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)
                  : (c <= 3517 || (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)))
                : (c <= 3634 || (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)))))))))
          : (c <= 3749 || (c < 4682
            ? (c < 4176
              ? (c < 3840
                ? (c < 3776
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : (c <= 3762 || c == 3773))
                  : (c <= 3780 || (c < 3804
                    ? c == 3782
                    : c <= 3807)))
                : (c <= 3840 || (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)))))
              : (c <= 4181 || (c < 4238
                ? (c < 4197
                  ? (c < 4193
                    ? (c >= 4186 && c <= 4189)
                    : c <= 4193)
                  : (c <= 4198 || (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)))
                : (c <= 4238 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)))))))
            : (c <= 4685 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : (c <= 4696 || (c >= 4698 && c <= 4701)))
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5743
                ? (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)))
                : (c <= 5759 || (c < 5870
                  ? (c < 5792
                    ? (c >= 5761 && c <= 5786)
                    : c <= 5866)
                  : (c <= 5880 || (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)))))))))))))
      : (c <= 5969 || (c < 9829
        ? (c < 8178
          ? (c < 7296
            ? (c < 6528
              ? (c < 6272
                ? (c < 6103
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : (c <= 6000 || (c >= 6016 && c <= 6067)))
                  : (c <= 6103 || (c < 6176
                    ? c == 6108
                    : c <= 6264)))
                : (c <= 6312 || (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)))))
              : (c <= 6571 || (c < 7043
                ? (c < 6823
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : (c <= 6678 || (c >= 6688 && c <= 6740)))
                  : (c <= 6823 || (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)))
                : (c <= 7072 || (c < 7168
                  ? (c < 7098
                    ? (c >= 7086 && c <= 7087)
                    : c <= 7141)
                  : (c <= 7203 || (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)))))))
            : (c <= 7304 || (c < 8025
              ? (c < 7424
                ? (c < 7406
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : (c <= 7359 || (c >= 7401 && c <= 7404)))
                  : (c <= 7411 || (c < 7418
                    ? (c >= 7413 && c <= 7414)
                    : c <= 7418)))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))
              : (c <= 8025 || (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))))))
          : (c <= 8180 || (c < 9167
            ? (c < 8484
              ? (c < 8450
                ? (c < 8305
                  ? (c < 8252
                    ? (c >= 8182 && c <= 8188)
                    : (c <= 8252 || c == 8265))
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8450 || (c < 8469
                  ? (c < 8458
                    ? c == 8455
                    : c <= 8467)
                  : (c <= 8469 || (c < 8482
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8482)))))
              : (c <= 8484 || (c < 8526
                ? (c < 8490
                  ? (c < 8488
                    ? c == 8486
                    : c <= 8488)
                  : (c <= 8505 || (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)))
                : (c <= 8526 || (c < 8617
                  ? (c < 8596
                    ? (c >= 8544 && c <= 8584)
                    : c <= 8601)
                  : (c <= 8618 || (c < 9000
                    ? (c >= 8986 && c <= 8987)
                    : c <= 9000)))))))
            : (c <= 9167 || (c < 9757
              ? (c < 9723
                ? (c < 9642
                  ? (c < 9208
                    ? (c >= 9193 && c <= 9203)
                    : (c <= 9210 || c == 9410))
                  : (c <= 9643 || (c < 9664
                    ? c == 9654
                    : c <= 9664)))
                : (c <= 9726 || (c < 9745
                  ? (c < 9742
                    ? (c >= 9728 && c <= 9732)
                    : c <= 9742)
                  : (c <= 9745 || (c < 9752
                    ? (c >= 9748 && c <= 9749)
                    : c <= 9752)))))
              : (c <= 9757 || (c < 9784
                ? (c < 9766
                  ? (c < 9762
                    ? c == 9760
                    : c <= 9763)
                  : (c <= 9766 || (c < 9774
                    ? c == 9770
                    : c <= 9775)))
                : (c <= 9786 || (c < 9800
                  ? (c < 9794
                    ? c == 9792
                    : c <= 9794)
                  : (c <= 9811 || (c < 9827
                    ? (c >= 9823 && c <= 9824)
                    : c <= 9827)))))))))))
        : (c <= 9830 || (c < 11506
          ? (c < 10002
            ? (c < 9928
              ? (c < 9888
                ? (c < 9874
                  ? (c < 9851
                    ? c == 9832
                    : (c <= 9851 || (c >= 9854 && c <= 9855)))
                  : (c <= 9879 || (c < 9883
                    ? c == 9881
                    : c <= 9884)))
                : (c <= 9889 || (c < 9904
                  ? (c < 9898
                    ? c == 9895
                    : c <= 9899)
                  : (c <= 9905 || (c < 9924
                    ? (c >= 9917 && c <= 9918)
                    : c <= 9925)))))
              : (c <= 9928 || (c < 9975
                ? (c < 9939
                  ? (c < 9937
                    ? (c >= 9934 && c <= 9935)
                    : c <= 9937)
                  : (c <= 9940 || (c < 9968
                    ? (c >= 9961 && c <= 9962)
                    : c <= 9973)))
                : (c <= 9978 || (c < 9989
                  ? (c < 9986
                    ? c == 9981
                    : c <= 9986)
                  : (c <= 9989 || (c < 9999
                    ? (c >= 9992 && c <= 9997)
                    : c <= 9999)))))))
            : (c <= 10002 || (c < 10083
              ? (c < 10052
                ? (c < 10017
                  ? (c < 10006
                    ? c == 10004
                    : (c <= 10006 || c == 10013))
                  : (c <= 10017 || (c < 10035
                    ? c == 10024
                    : c <= 10036)))
                : (c <= 10052 || (c < 10062
                  ? (c < 10060
                    ? c == 10055
                    : c <= 10060)
                  : (c <= 10062 || (c < 10071
                    ? (c >= 10067 && c <= 10069)
                    : c <= 10071)))))
              : (c <= 10084 || (c < 11013
                ? (c < 10160
                  ? (c < 10145
                    ? (c >= 10133 && c <= 10135)
                    : c <= 10145)
                  : (c <= 10160 || (c < 10548
                    ? c == 10175
                    : c <= 10549)))
                : (c <= 11015 || (c < 11093
                  ? (c < 11088
                    ? (c >= 11035 && c <= 11036)
                    : c <= 11088)
                  : (c <= 11093 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)))))))))
          : (c <= 11507 || (c < 12704
            ? (c < 11728
              ? (c < 11680
                ? (c < 11568
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : (c <= 11559 || c == 11565))
                  : (c <= 11623 || (c < 11648
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))
              : (c <= 11734 || (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12336 && c <= 12341)
                    : c <= 12349)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)))))))
            : (c <= 12735 || (c < 42775
              ? (c < 42240
                ? (c < 13312
                  ? (c < 12951
                    ? (c >= 12784 && c <= 12799)
                    : (c <= 12951 || c == 12953))
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)))))
              : (c <= 42783 || (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)))))))))))))))
    : (c <= 43255 || (c < 72203
      ? (c < 67456
        ? (c < 64914
          ? (c < 43785
            ? (c < 43588
              ? (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : (c <= 43262 || (c >= 43274 && c <= 43301)))
                  : (c <= 43334 || (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)))
                : (c <= 43471 || (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))))
              : (c <= 43595 || (c < 43712
                ? (c < 43697
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : (c <= 43642 || (c >= 43646 && c <= 43695)))
                  : (c <= 43697 || (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)))
                : (c <= 43712 || (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)))))))
            : (c <= 43790 || (c < 64275
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : (c <= 43814 || (c >= 43816 && c <= 43822)))
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)))))
              : (c <= 64279 || (c < 64320
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))
                : (c <= 64321 || (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))))))))
          : (c <= 64967 || (c < 66176
            ? (c < 65474
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : (c <= 65137 || c == 65139))
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c < 65440
                    ? (c >= 65382 && c <= 65437)
                    : c <= 65470)))))
              : (c <= 65479 || (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))))
            : (c <= 66204 || (c < 66864
              ? (c < 66504
                ? (c < 66384
                  ? (c < 66304
                    ? (c >= 66208 && c <= 66256)
                    : (c <= 66335 || (c >= 66349 && c <= 66378)))
                  : (c <= 66421 || (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)))
                : (c <= 66511 || (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))))
              : (c <= 66915 || (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))))))))))
        : (c <= 67461 || (c < 70006
          ? (c < 68352
            ? (c < 67840
              ? (c < 67644
                ? (c < 67592
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : (c <= 67514 || (c >= 67584 && c <= 67589)))
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))))
              : (c <= 67861 || (c < 68117
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68112
                    ? c == 68096
                    : c <= 68115)))
                : (c <= 68119 || (c < 68224
                  ? (c < 68192
                    ? (c >= 68121 && c <= 68149)
                    : c <= 68220)
                  : (c <= 68252 || (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)))))))
            : (c <= 68405 || (c < 69488
              ? (c < 68864
                ? (c < 68608
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : (c <= 68466 || (c >= 68480 && c <= 68497)))
                  : (c <= 68680 || (c < 68800
                    ? (c >= 68736 && c <= 68786)
                    : c <= 68850)))
                : (c <= 68899 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))))
              : (c <= 69505 || (c < 69763
                ? (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)))
                : (c <= 69807 || (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || (c < 69968
                    ? c == 69959
                    : c <= 70002)))))))))
          : (c <= 70006 || (c < 70784
            ? (c < 70405
              ? (c < 70272
                ? (c < 70108
                  ? (c < 70081
                    ? (c >= 70019 && c <= 70066)
                    : (c <= 70084 || c == 70106))
                  : (c <= 70108 || (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70366)))))
              : (c <= 70412 || (c < 70461
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)))))))
            : (c <= 70831 || (c < 71935
              ? (c < 71296
                ? (c < 71128
                  ? (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : (c <= 70855 || (c >= 71040 && c <= 71086)))
                  : (c <= 71131 || (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)))
                : (c <= 71338 || (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)))))
              : (c <= 71942 || (c < 72001
                ? (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c < 71999
                    ? (c >= 71960 && c <= 71983)
                    : c <= 71999)))
                : (c <= 72001 || (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || (c < 72192
                    ? c == 72163
                    : c <= 72192)))))))))))))
      : (c <= 72242 || (c < 126500
        ? (c < 113664
          ? (c < 82944
            ? (c < 73030
              ? (c < 72714
                ? (c < 72349
                  ? (c < 72272
                    ? c == 72250
                    : (c <= 72272 || (c >= 72284 && c <= 72329)))
                  : (c <= 72349 || (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)))
                : (c <= 72750 || (c < 72960
                  ? (c < 72818
                    ? c == 72768
                    : c <= 72847)
                  : (c <= 72966 || (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)))))
              : (c <= 73030 || (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))
            : (c <= 83526 || (c < 94176
              ? (c < 93027
                ? (c < 92880
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : (c <= 92766 || (c >= 92784 && c <= 92862)))
                  : (c <= 92909 || (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)))
                : (c <= 93047 || (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94099
                    ? c == 94032
                    : c <= 94111)))))
              : (c <= 94177 || (c < 110581
                ? (c < 100352
                  ? (c < 94208
                    ? c == 94179
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))
                : (c <= 110587 || (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))))))))
          : (c <= 113770 || (c < 120540
            ? (c < 120005
              ? (c < 119970
                ? (c < 119808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : (c <= 113800 || (c >= 113808 && c <= 113817)))
                  : (c <= 119892 || (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)))
                : (c <= 119970 || (c < 119982
                  ? (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)
                  : (c <= 119993 || (c < 119997
                    ? c == 119995
                    : c <= 120003)))))
              : (c <= 120069 || (c < 120128
                ? (c < 120086
                  ? (c < 120077
                    ? (c >= 120071 && c <= 120074)
                    : c <= 120084)
                  : (c <= 120092 || (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)))
                : (c <= 120132 || (c < 120146
                  ? (c < 120138
                    ? c == 120134
                    : c <= 120144)
                  : (c <= 120485 || (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)))))))
            : (c <= 120570 || (c < 123536
              ? (c < 120746
                ? (c < 120656
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : (c <= 120628 || (c >= 120630 && c <= 120654)))
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c < 123214
                    ? (c >= 123191 && c <= 123197)
                    : c <= 123214)))))
              : (c <= 123565 || (c < 124928
                ? (c < 124904
                  ? (c < 124896
                    ? (c >= 123584 && c <= 123627)
                    : c <= 124902)
                  : (c <= 124907 || (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)))
                : (c <= 125124 || (c < 126464
                  ? (c < 125259
                    ? (c >= 125184 && c <= 125251)
                    : c <= 125259)
                  : (c <= 126467 || (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)))))))))))
        : (c <= 126500 || (c < 128329
          ? (c < 126592
            ? (c < 126551
              ? (c < 126535
                ? (c < 126521
                  ? (c < 126505
                    ? c == 126503
                    : (c <= 126514 || (c >= 126516 && c <= 126519)))
                  : (c <= 126521 || (c < 126530
                    ? c == 126523
                    : c <= 126530)))
                : (c <= 126535 || (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)))))
              : (c <= 126551 || (c < 126564
                ? (c < 126557
                  ? (c < 126555
                    ? c == 126553
                    : c <= 126555)
                  : (c <= 126557 || (c < 126561
                    ? c == 126559
                    : c <= 126562)))
                : (c <= 126564 || (c < 126580
                  ? (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)
                  : (c <= 126583 || (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)))))))
            : (c <= 126601 || (c < 127514
              ? (c < 127344
                ? (c < 126635
                  ? (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : (c <= 126627 || (c >= 126629 && c <= 126633)))
                  : (c <= 126651 || (c < 127183
                    ? c == 126980
                    : c <= 127183)))
                : (c <= 127345 || (c < 127377
                  ? (c < 127374
                    ? (c >= 127358 && c <= 127359)
                    : c <= 127374)
                  : (c <= 127386 || (c < 127489
                    ? (c >= 127462 && c <= 127487)
                    : c <= 127490)))))
              : (c <= 127514 || (c < 127894
                ? (c < 127568
                  ? (c < 127538
                    ? c == 127535
                    : c <= 127546)
                  : (c <= 127569 || (c < 127780
                    ? (c >= 127744 && c <= 127777)
                    : c <= 127891)))
                : (c <= 127895 || (c < 127987
                  ? (c < 127902
                    ? (c >= 127897 && c <= 127899)
                    : c <= 127984)
                  : (c <= 127989 || (c < 128255
                    ? (c >= 127991 && c <= 128253)
                    : c <= 128317)))))))))
          : (c <= 128334 || (c < 128745
            ? (c < 128465
              ? (c < 128405
                ? (c < 128391
                  ? (c < 128367
                    ? (c >= 128336 && c <= 128359)
                    : (c <= 128368 || (c >= 128371 && c <= 128378)))
                  : (c <= 128391 || (c < 128400
                    ? (c >= 128394 && c <= 128397)
                    : c <= 128400)))
                : (c <= 128406 || (c < 128433
                  ? (c < 128424
                    ? (c >= 128420 && c <= 128421)
                    : c <= 128424)
                  : (c <= 128434 || (c < 128450
                    ? c == 128444
                    : c <= 128452)))))
              : (c <= 128467 || (c < 128499
                ? (c < 128483
                  ? (c < 128481
                    ? (c >= 128476 && c <= 128478)
                    : c <= 128481)
                  : (c <= 128483 || (c < 128495
                    ? c == 128488
                    : c <= 128495)))
                : (c <= 128499 || (c < 128715
                  ? (c < 128640
                    ? (c >= 128506 && c <= 128591)
                    : c <= 128709)
                  : (c <= 128722 || (c < 128733
                    ? (c >= 128725 && c <= 128727)
                    : c <= 128741)))))))
            : (c <= 128745 || (c < 129712
              ? (c < 129340
                ? (c < 128992
                  ? (c < 128752
                    ? (c >= 128747 && c <= 128748)
                    : (c <= 128752 || (c >= 128755 && c <= 128764)))
                  : (c <= 129003 || (c < 129292
                    ? c == 129008
                    : c <= 129338)))
                : (c <= 129349 || (c < 129656
                  ? (c < 129648
                    ? (c >= 129351 && c <= 129535)
                    : c <= 129652)
                  : (c <= 129660 || (c < 129680
                    ? (c >= 129664 && c <= 129670)
                    : c <= 129708)))))
              : (c <= 129722 || (c < 173824
                ? (c < 129760
                  ? (c < 129744
                    ? (c >= 129728 && c <= 129733)
                    : c <= 129753)
                  : (c <= 129767 || (c < 131072
                    ? (c >= 129776 && c <= 129782)
                    : c <= 173791)))
                : (c <= 177976 || (c < 183984
                  ? (c < 178208
                    ? (c >= 177984 && c <= 178205)
                    : c <= 183969)
                  : (c <= 191456 || (c < 196608
                    ? (c >= 194560 && c <= 195101)
                    : c <= 201546)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(1323);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '0') ADVANCE(1260);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == 'P') ADVANCE(464);
      if (lookahead == 'T') ADVANCE(574);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1309);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '_') ADVANCE(1536);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(152);
      if (lookahead == 'b') ADVANCE(467);
      if (lookahead == 'c') ADVANCE(106);
      if (lookahead == 'd') ADVANCE(191);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(101);
      if (lookahead == 'g') ADVANCE(224);
      if (lookahead == 'i') ADVANCE(264);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(290);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'p') ADVANCE(109);
      if (lookahead == 'r') ADVANCE(192);
      if (lookahead == 's') ADVANCE(193);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(226);
      if (lookahead == 'y') ADVANCE(295);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(594)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(1323);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(506);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(608);
      if (lookahead == 'a') ADVANCE(565);
      if (lookahead == 'c') ADVANCE(414);
      if (lookahead == 'd') ADVANCE(494);
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'f') ADVANCE(294);
      if (lookahead == 'i') ADVANCE(267);
      if (lookahead == 'k') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(298);
      if (lookahead == 's') ADVANCE(253);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(608);
      if (lookahead == 'c') ADVANCE(414);
      if (lookahead == 'd') ADVANCE(494);
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'f') ADVANCE(294);
      if (lookahead == 'i') ADVANCE(267);
      if (lookahead == 'k') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(298);
      if (lookahead == 's') ADVANCE(253);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1013);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1109);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'i') ADVANCE(1114);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1008);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1109);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1008);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1109);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1008);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(972);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(955);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1009);
      if (lookahead == 't') ADVANCE(1154);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(972);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(955);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1009);
      if (lookahead == 't') ADVANCE(1154);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(940);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1011);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(940);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1011);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(940);
      if (lookahead == 'i') ADVANCE(1097);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1048);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1011);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1109);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'i') ADVANCE(1114);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1008);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'b') ADVANCE(875);
      if (lookahead == 'c') ADVANCE(665);
      if (lookahead == 'd') ADVANCE(831);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(647);
      if (lookahead == 'g') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(741);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(913);
      if (lookahead == 'n') ADVANCE(757);
      if (lookahead == 'o') ADVANCE(848);
      if (lookahead == 'p') ADVANCE(834);
      if (lookahead == 'r') ADVANCE(709);
      if (lookahead == 's') ADVANCE(715);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == 'y') ADVANCE(777);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'b') ADVANCE(875);
      if (lookahead == 'c') ADVANCE(665);
      if (lookahead == 'd') ADVANCE(831);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(662);
      if (lookahead == 'g') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(740);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(913);
      if (lookahead == 'n') ADVANCE(757);
      if (lookahead == 'o') ADVANCE(848);
      if (lookahead == 'p') ADVANCE(834);
      if (lookahead == 'r') ADVANCE(709);
      if (lookahead == 's') ADVANCE(715);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == 'y') ADVANCE(777);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '_') ADVANCE(804);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'b') ADVANCE(875);
      if (lookahead == 'c') ADVANCE(794);
      if (lookahead == 'd') ADVANCE(832);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(648);
      if (lookahead == 'g') ADVANCE(734);
      if (lookahead == 'i') ADVANCE(742);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(913);
      if (lookahead == 'n') ADVANCE(758);
      if (lookahead == 'r') ADVANCE(712);
      if (lookahead == 's') ADVANCE(713);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == 'y') ADVANCE(777);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'b') ADVANCE(875);
      if (lookahead == 'c') ADVANCE(794);
      if (lookahead == 'd') ADVANCE(832);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(648);
      if (lookahead == 'g') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(742);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'n') ADVANCE(759);
      if (lookahead == 'r') ADVANCE(712);
      if (lookahead == 's') ADVANCE(716);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == 'y') ADVANCE(777);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'b') ADVANCE(875);
      if (lookahead == 'c') ADVANCE(794);
      if (lookahead == 'd') ADVANCE(832);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(648);
      if (lookahead == 'g') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(743);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'n') ADVANCE(759);
      if (lookahead == 'r') ADVANCE(712);
      if (lookahead == 's') ADVANCE(716);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == 'y') ADVANCE(777);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1013);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'g') ADVANCE(1025);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1001);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(100);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1013);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1105);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1105);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(957);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(957);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1129);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(957);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(957);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '?' ||
          lookahead == '\\') ADVANCE(586);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(506);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'i') ADVANCE(382);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'i') ADVANCE(382);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(1322);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '>') ADVANCE(1360);
      if (lookahead == '?') ADVANCE(1333);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == 'i') ADVANCE(381);
      if (lookahead == 'u') ADVANCE(1312);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 37:
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(1284);
      if (lookahead == '/') ADVANCE(1277);
      if (lookahead == '\\') ADVANCE(1310);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1276);
      if (lookahead != 0) ADVANCE(1308);
      END_STATE();
    case 38:
      if (lookahead == '"') ADVANCE(1315);
      END_STATE();
    case 39:
      if (lookahead == '"') ADVANCE(1271);
      if (lookahead == '#') ADVANCE(1284);
      if (lookahead == '/') ADVANCE(1277);
      if (lookahead == '\\') ADVANCE(1310);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1276);
      if (lookahead != 0) ADVANCE(1308);
      END_STATE();
    case 40:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1434);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '0') ADVANCE(1261);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '>') ADVANCE(1360);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 41:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1110);
      if (lookahead == 'i') ADVANCE(1114);
      if (lookahead == 's') ADVANCE(1131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1110);
      if (lookahead == 's') ADVANCE(1131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(974);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1107);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1010);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(974);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1069);
      if (lookahead == 'i') ADVANCE(1108);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 's') ADVANCE(1012);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1110);
      if (lookahead == 's') ADVANCE(1131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 46:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1106);
      if (lookahead == 's') ADVANCE(1014);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(46)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 47:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1110);
      if (lookahead == 'i') ADVANCE(1114);
      if (lookahead == 's') ADVANCE(1131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 48:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1232);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 't') ADVANCE(1163);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 49:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1232);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (aux_sym_simple_identifier_token1_character_set_2(lookahead)) ADVANCE(1246);
      END_STATE();
    case 50:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '_') ADVANCE(1537);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (aux_sym_simple_identifier_token1_character_set_5(lookahead)) ADVANCE(1246);
      END_STATE();
    case 51:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '?') ADVANCE(1331);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 's') ADVANCE(1014);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1106);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1093);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1130);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '{') ADVANCE(593);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 54:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(1081);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1093);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1130);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1192);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(54)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 55:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(973);
      if (lookahead == 'c') ADVANCE(1081);
      if (lookahead == 'd') ADVANCE(1033);
      if (lookahead == 'e') ADVANCE(1112);
      if (lookahead == 'f') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1093);
      if (lookahead == 'l') ADVANCE(941);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1130);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(938);
      if (lookahead == 'd') ADVANCE(1240);
      if (lookahead == 'f') ADVANCE(1045);
      if (lookahead == 'i') ADVANCE(1097);
      if (lookahead == 'l') ADVANCE(942);
      if (lookahead == 'm') ADVANCE(1218);
      if (lookahead == 'n') ADVANCE(1133);
      if (lookahead == 'o') ADVANCE(1145);
      if (lookahead == 'p') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(990);
      if (lookahead == 's') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(56)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'e') ADVANCE(1113);
      if (lookahead == 'f') ADVANCE(1227);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'p') ADVANCE(1167);
      if (lookahead == 's') ADVANCE(1205);
      if (lookahead == 't') ADVANCE(1242);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'f') ADVANCE(1227);
      if (lookahead == 'i') ADVANCE(1126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 59:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 't') ADVANCE(1165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 60:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'l') ADVANCE(1022);
      if (lookahead == 'v') ADVANCE(952);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 61:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 's') ADVANCE(1014);
      if (lookahead == 'u') ADVANCE(1098);
      if (lookahead == 'w') ADVANCE(1018);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (aux_sym_simple_identifier_token1_character_set_3(lookahead)) ADVANCE(1246);
      END_STATE();
    case 62:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '?') ADVANCE(1331);
      if (lookahead == 'i') ADVANCE(381);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      END_STATE();
    case 63:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '>') ADVANCE(1360);
      if (lookahead == '?') ADVANCE(1331);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == 'i') ADVANCE(381);
      if (lookahead == 'u') ADVANCE(1312);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      END_STATE();
    case 64:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '@') ADVANCE(1534);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'c') ADVANCE(345);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(324);
      if (lookahead == 'g') ADVANCE(248);
      if (lookahead == 'i') ADVANCE(383);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(434);
      if (lookahead == 's') ADVANCE(251);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      END_STATE();
    case 65:
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == '&' ||
          ('<' <= lookahead && lookahead <= '?') ||
          lookahead == '\\') ADVANCE(586);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(70);
      END_STATE();
    case 66:
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '(') ADVANCE(1317);
      END_STATE();
    case 67:
      if (lookahead == ')') ADVANCE(1597);
      END_STATE();
    case 68:
      if (lookahead == ')') ADVANCE(1598);
      END_STATE();
    case 69:
      if (lookahead == '.') ADVANCE(1351);
      if (lookahead == '<') ADVANCE(71);
      if (lookahead == '=') ADVANCE(1423);
      if (lookahead == '&' ||
          lookahead == '/' ||
          lookahead == '>' ||
          lookahead == '?') ADVANCE(1348);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1347);
      END_STATE();
    case 70:
      if (lookahead == '.') ADVANCE(1351);
      if (lookahead == '<') ADVANCE(71);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1348);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1347);
      END_STATE();
    case 71:
      if (lookahead == '.') ADVANCE(1352);
      if (lookahead == '<') ADVANCE(71);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1348);
      END_STATE();
    case 72:
      if (lookahead == '.') ADVANCE(1353);
      if (lookahead == '/') ADVANCE(641);
      if (lookahead == '<') ADVANCE(73);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1349);
      END_STATE();
    case 73:
      if (lookahead == '.') ADVANCE(1353);
      if (lookahead == '<') ADVANCE(73);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1349);
      END_STATE();
    case 74:
      if (lookahead == '/') ADVANCE(644);
      END_STATE();
    case 75:
      if (lookahead == '/') ADVANCE(644);
      if (lookahead == '=') ADVANCE(1417);
      END_STATE();
    case 76:
      if (lookahead == ':') ADVANCE(1345);
      END_STATE();
    case 77:
      if (lookahead == ':') ADVANCE(1346);
      END_STATE();
    case 78:
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1352);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1351);
      END_STATE();
    case 79:
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '&' ||
          lookahead == '/' ||
          ('=' <= lookahead && lookahead <= '?')) ADVANCE(1352);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1351);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1256);
      END_STATE();
    case 80:
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1352);
      END_STATE();
    case 81:
      if (lookahead == '<') ADVANCE(81);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1353);
      END_STATE();
    case 82:
      if (lookahead == '=') ADVANCE(1355);
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(586);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          lookahead == '>' ||
          lookahead == '?' ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1356);
      END_STATE();
    case 83:
      if (lookahead == '=') ADVANCE(1419);
      END_STATE();
    case 84:
      if (lookahead == '=') ADVANCE(1415);
      END_STATE();
    case 85:
      if (lookahead == '=') ADVANCE(1411);
      END_STATE();
    case 86:
      if (lookahead == '=') ADVANCE(1413);
      END_STATE();
    case 87:
      if (lookahead == 'D') ADVANCE(1367);
      END_STATE();
    case 88:
      if (lookahead == 'L') ADVANCE(436);
      END_STATE();
    case 89:
      if (lookahead == 'L') ADVANCE(327);
      END_STATE();
    case 90:
      if (lookahead == 'L') ADVANCE(329);
      END_STATE();
    case 91:
      if (lookahead == 'P') ADVANCE(131);
      END_STATE();
    case 92:
      if (lookahead == '_') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      END_STATE();
    case 93:
      if (lookahead == '_') ADVANCE(93);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1264);
      END_STATE();
    case 94:
      if (lookahead == '_') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1263);
      END_STATE();
    case 95:
      if (lookahead == '_') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1262);
      END_STATE();
    case 96:
      if (lookahead == '_') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      END_STATE();
    case 97:
      if (lookahead == '_') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1256);
      END_STATE();
    case 98:
      if (lookahead == '_') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1257);
      END_STATE();
    case 99:
      if (lookahead == '`') ADVANCE(1248);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(99);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(565);
      if (lookahead == 'c') ADVANCE(414);
      if (lookahead == 'd') ADVANCE(494);
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'f') ADVANCE(294);
      if (lookahead == 'i') ADVANCE(267);
      if (lookahead == 'k') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(298);
      if (lookahead == 's') ADVANCE(253);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 101:
      if (lookahead == 'a') ADVANCE(332);
      if (lookahead == 'i') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(454);
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 102:
      if (lookahead == 'a') ADVANCE(583);
      if (lookahead == 'e') ADVANCE(508);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(330);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(278);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(331);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(497);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 'o') ADVANCE(372);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(497);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 'o') ADVANCE(405);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(370);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(472);
      if (lookahead == 'o') ADVANCE(499);
      if (lookahead == 'r') ADVANCE(195);
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(451);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(363);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(271);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(455);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(498);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(470);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(364);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(465);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(337);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(539);
      if (lookahead == 'r') ADVANCE(559);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(493);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(339);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(340);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(540);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(342);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(393);
      END_STATE();
    case 126:
      if (lookahead == 'a') ADVANCE(343);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(344);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(514);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(356);
      if (lookahead == 'i') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(454);
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(356);
      if (lookahead == 'i') ADVANCE(347);
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(522);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(525);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(150);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(530);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(306);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(481);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(302);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(272);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(355);
      END_STATE();
    case 140:
      if (lookahead == 'a') ADVANCE(531);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(533);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(534);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(535);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(541);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(544);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(542);
      END_STATE();
    case 147:
      if (lookahead == 'b') ADVANCE(348);
      END_STATE();
    case 148:
      if (lookahead == 'b') ADVANCE(496);
      END_STATE();
    case 149:
      if (lookahead == 'b') ADVANCE(496);
      if (lookahead == 'p') ADVANCE(241);
      END_STATE();
    case 150:
      if (lookahead == 'b') ADVANCE(358);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(414);
      if (lookahead == 'd') ADVANCE(494);
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'f') ADVANCE(294);
      if (lookahead == 'i') ADVANCE(267);
      if (lookahead == 'k') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(298);
      if (lookahead == 's') ADVANCE(253);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(524);
      if (lookahead == 'n') ADVANCE(575);
      if (lookahead == 's') ADVANCE(495);
      if (lookahead == 'w') ADVANCE(135);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(524);
      if (lookahead == 's') ADVANCE(495);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(524);
      if (lookahead == 's') ADVANCE(580);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(1490);
      END_STATE();
    case 156:
      if (lookahead == 'c') ADVANCE(1341);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(1553);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(1574);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(1577);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(281);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(349);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(238);
      if (lookahead == 'p') ADVANCE(254);
      if (lookahead == 'q') ADVANCE(562);
      if (lookahead == 't') ADVANCE(560);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(110);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(328);
      END_STATE();
    case 165:
      if (lookahead == 'c') ADVANCE(537);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(515);
      END_STATE();
    case 167:
      if (lookahead == 'c') ADVANCE(227);
      if (lookahead == 'f') ADVANCE(291);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(516);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(235);
      END_STATE();
    case 171:
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(422);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(480);
      END_STATE();
    case 174:
      if (lookahead == 'c') ADVANCE(426);
      END_STATE();
    case 175:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(543);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(1393);
      END_STATE();
    case 178:
      if (lookahead == 'd') ADVANCE(1463);
      END_STATE();
    case 179:
      if (lookahead == 'd') ADVANCE(1594);
      END_STATE();
    case 180:
      if (lookahead == 'd') ADVANCE(1547);
      END_STATE();
    case 181:
      if (lookahead == 'd') ADVANCE(1550);
      END_STATE();
    case 182:
      if (lookahead == 'd') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(288);
      if (lookahead == 'i') ADVANCE(509);
      if (lookahead == 'o') ADVANCE(555);
      if (lookahead == 't') ADVANCE(239);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(316);
      if (lookahead == 'i') ADVANCE(509);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(292);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(297);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(545);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(209);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'd') ADVANCE(359);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(360);
      if (lookahead == 'i') ADVANCE(266);
      if (lookahead == 's') ADVANCE(413);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(301);
      if (lookahead == 'o') ADVANCE(1403);
      if (lookahead == 'y') ADVANCE(394);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(367);
      if (lookahead == 't') ADVANCE(119);
      if (lookahead == 'u') ADVANCE(149);
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(375);
      if (lookahead == 't') ADVANCE(303);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'i') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(452);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'i') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(547);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(1329);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(1397);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(1335);
      END_STATE();
    case 200:
      if (lookahead == 'e') ADVANCE(1265);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(1605);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(1366);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(1369);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(1268);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(1451);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(1556);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(1459);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(1603);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(1541);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(1465);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(1372);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(1544);
      END_STATE();
    case 213:
      if (lookahead == 'e') ADVANCE(1562);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(1590);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(1531);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(453);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 220:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 222:
      if (lookahead == 'e') ADVANCE(576);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(507);
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 225:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(103);
      if (lookahead == 'h') ADVANCE(321);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 233:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 235:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(398);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(489);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(404);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(457);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(460);
      END_STATE();
    case 244:
      if (lookahead == 'e') ADVANCE(466);
      END_STATE();
    case 245:
      if (lookahead == 'e') ADVANCE(334);
      if (lookahead == 't') ADVANCE(119);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(406);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(462);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(518);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(518);
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 250:
      if (lookahead == 'e') ADVANCE(519);
      if (lookahead == 't') ADVANCE(119);
      if (lookahead == 'u') ADVANCE(148);
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(519);
      if (lookahead == 't') ADVANCE(468);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(374);
      if (lookahead == 't') ADVANCE(303);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == 'o') ADVANCE(554);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(482);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(483);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(485);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(486);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'o') ADVANCE(1403);
      if (lookahead == 'y') ADVANCE(394);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'y') ADVANCE(394);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(409);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(1391);
      if (lookahead == 'm') ADVANCE(448);
      if (lookahead == 'n') ADVANCE(1381);
      if (lookahead == 's') ADVANCE(1428);
      END_STATE();
    case 265:
      if (lookahead == 'f') ADVANCE(1391);
      if (lookahead == 'm') ADVANCE(448);
      if (lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 266:
      if (lookahead == 'f') ADVANCE(1607);
      END_STATE();
    case 267:
      if (lookahead == 'f') ADVANCE(1607);
      if (lookahead == 'm') ADVANCE(104);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(1385);
      END_STATE();
    case 269:
      if (lookahead == 'f') ADVANCE(579);
      END_STATE();
    case 270:
      if (lookahead == 'f') ADVANCE(293);
      END_STATE();
    case 271:
      if (lookahead == 'f') ADVANCE(215);
      END_STATE();
    case 272:
      if (lookahead == 'f') ADVANCE(221);
      END_STATE();
    case 273:
      if (lookahead == 'g') ADVANCE(1608);
      END_STATE();
    case 274:
      if (lookahead == 'g') ADVANCE(1568);
      END_STATE();
    case 275:
      if (lookahead == 'g') ADVANCE(1589);
      END_STATE();
    case 276:
      if (lookahead == 'g') ADVANCE(1571);
      END_STATE();
    case 277:
      if (lookahead == 'g') ADVANCE(284);
      END_STATE();
    case 278:
      if (lookahead == 'g') ADVANCE(263);
      END_STATE();
    case 279:
      if (lookahead == 'g') ADVANCE(477);
      END_STATE();
    case 280:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 281:
      if (lookahead == 'h') ADVANCE(1395);
      END_STATE();
    case 282:
      if (lookahead == 'h') ADVANCE(1405);
      END_STATE();
    case 283:
      if (lookahead == 'h') ADVANCE(1368);
      END_STATE();
    case 284:
      if (lookahead == 'h') ADVANCE(1400);
      END_STATE();
    case 285:
      if (lookahead == 'h') ADVANCE(125);
      END_STATE();
    case 286:
      if (lookahead == 'h') ADVANCE(469);
      if (lookahead == 'r') ADVANCE(556);
      if (lookahead == 'y') ADVANCE(450);
      END_STATE();
    case 287:
      if (lookahead == 'h') ADVANCE(473);
      END_STATE();
    case 288:
      if (lookahead == 'i') ADVANCE(571);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(567);
      END_STATE();
    case 290:
      if (lookahead == 'i') ADVANCE(333);
      if (lookahead == 'o') ADVANCE(373);
      END_STATE();
    case 291:
      if (lookahead == 'i') ADVANCE(572);
      END_STATE();
    case 292:
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(573);
      END_STATE();
    case 294:
      if (lookahead == 'i') ADVANCE(352);
      if (lookahead == 'u') ADVANCE(387);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(230);
      END_STATE();
    case 296:
      if (lookahead == 'i') ADVANCE(445);
      END_STATE();
    case 297:
      if (lookahead == 'i') ADVANCE(269);
      END_STATE();
    case 298:
      if (lookahead == 'i') ADVANCE(400);
      END_STATE();
    case 299:
      if (lookahead == 'i') ADVANCE(503);
      if (lookahead == 'm') ADVANCE(563);
      END_STATE();
    case 300:
      if (lookahead == 'i') ADVANCE(408);
      END_STATE();
    case 301:
      if (lookahead == 'i') ADVANCE(408);
      if (lookahead == 'l') ADVANCE(219);
      END_STATE();
    case 302:
      if (lookahead == 'i') ADVANCE(353);
      END_STATE();
    case 303:
      if (lookahead == 'i') ADVANCE(439);
      END_STATE();
    case 304:
      if (lookahead == 'i') ADVANCE(526);
      END_STATE();
    case 305:
      if (lookahead == 'i') ADVANCE(430);
      END_STATE();
    case 306:
      if (lookahead == 'i') ADVANCE(510);
      END_STATE();
    case 307:
      if (lookahead == 'i') ADVANCE(392);
      END_STATE();
    case 308:
      if (lookahead == 'i') ADVANCE(157);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 310:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(512);
      END_STATE();
    case 312:
      if (lookahead == 'i') ADVANCE(388);
      END_STATE();
    case 313:
      if (lookahead == 'i') ADVANCE(389);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(391);
      END_STATE();
    case 315:
      if (lookahead == 'i') ADVANCE(395);
      END_STATE();
    case 316:
      if (lookahead == 'i') ADVANCE(484);
      END_STATE();
    case 317:
      if (lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 318:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 319:
      if (lookahead == 'i') ADVANCE(432);
      END_STATE();
    case 320:
      if (lookahead == 'i') ADVANCE(487);
      END_STATE();
    case 321:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(433);
      END_STATE();
    case 323:
      if (lookahead == 'i') ADVANCE(532);
      END_STATE();
    case 324:
      if (lookahead == 'i') ADVANCE(396);
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 325:
      if (lookahead == 'i') ADVANCE(568);
      END_STATE();
    case 326:
      if (lookahead == 'i') ADVANCE(262);
      END_STATE();
    case 327:
      if (lookahead == 'i') ADVANCE(546);
      END_STATE();
    case 328:
      if (lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 329:
      if (lookahead == 'i') ADVANCE(548);
      END_STATE();
    case 330:
      if (lookahead == 'k') ADVANCE(1591);
      END_STATE();
    case 331:
      if (lookahead == 'k') ADVANCE(1461);
      END_STATE();
    case 332:
      if (lookahead == 'l') ADVANCE(351);
      END_STATE();
    case 333:
      if (lookahead == 'l') ADVANCE(1253);
      END_STATE();
    case 334:
      if (lookahead == 'l') ADVANCE(268);
      END_STATE();
    case 335:
      if (lookahead == 'l') ADVANCE(268);
      if (lookahead == 't') ADVANCE(1515);
      END_STATE();
    case 336:
      if (lookahead == 'l') ADVANCE(427);
      END_STATE();
    case 337:
      if (lookahead == 'l') ADVANCE(1583);
      END_STATE();
    case 338:
      if (lookahead == 'l') ADVANCE(1330);
      END_STATE();
    case 339:
      if (lookahead == 'l') ADVANCE(1559);
      END_STATE();
    case 340:
      if (lookahead == 'l') ADVANCE(1580);
      END_STATE();
    case 341:
      if (lookahead == 'l') ADVANCE(1481);
      END_STATE();
    case 342:
      if (lookahead == 'l') ADVANCE(1374);
      END_STATE();
    case 343:
      if (lookahead == 'l') ADVANCE(1373);
      END_STATE();
    case 344:
      if (lookahead == 'l') ADVANCE(1375);
      END_STATE();
    case 345:
      if (lookahead == 'l') ADVANCE(114);
      END_STATE();
    case 346:
      if (lookahead == 'l') ADVANCE(178);
      END_STATE();
    case 347:
      if (lookahead == 'l') ADVANCE(223);
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 348:
      if (lookahead == 'l') ADVANCE(308);
      END_STATE();
    case 349:
      if (lookahead == 'l') ADVANCE(421);
      END_STATE();
    case 350:
      if (lookahead == 'l') ADVANCE(521);
      END_STATE();
    case 351:
      if (lookahead == 'l') ADVANCE(521);
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 352:
      if (lookahead == 'l') ADVANCE(202);
      END_STATE();
    case 353:
      if (lookahead == 'l') ADVANCE(133);
      END_STATE();
    case 354:
      if (lookahead == 'l') ADVANCE(234);
      END_STATE();
    case 355:
      if (lookahead == 'l') ADVANCE(317);
      END_STATE();
    case 356:
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 358:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 359:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 360:
      if (lookahead == 'l') ADVANCE(501);
      if (lookahead == 'n') ADVANCE(184);
      if (lookahead == 'r') ADVANCE(490);
      END_STATE();
    case 361:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 362:
      if (lookahead == 'm') ADVANCE(1478);
      END_STATE();
    case 363:
      if (lookahead == 'm') ADVANCE(1601);
      END_STATE();
    case 364:
      if (lookahead == 'm') ADVANCE(1602);
      END_STATE();
    case 365:
      if (lookahead == 'm') ADVANCE(448);
      if (lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 366:
      if (lookahead == 'm') ADVANCE(448);
      if (lookahead == 'n') ADVANCE(182);
      if (lookahead == 's') ADVANCE(1428);
      END_STATE();
    case 367:
      if (lookahead == 'm') ADVANCE(199);
      END_STATE();
    case 368:
      if (lookahead == 'm') ADVANCE(377);
      END_STATE();
    case 369:
      if (lookahead == 'm') ADVANCE(435);
      END_STATE();
    case 370:
      if (lookahead == 'm') ADVANCE(310);
      END_STATE();
    case 371:
      if (lookahead == 'm') ADVANCE(563);
      END_STATE();
    case 372:
      if (lookahead == 'n') ADVANCE(536);
      END_STATE();
    case 373:
      if (lookahead == 'n') ADVANCE(299);
      END_STATE();
    case 374:
      if (lookahead == 'n') ADVANCE(1565);
      END_STATE();
    case 375:
      if (lookahead == 'n') ADVANCE(1565);
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 376:
      if (lookahead == 'n') ADVANCE(1457);
      END_STATE();
    case 377:
      if (lookahead == 'n') ADVANCE(1370);
      END_STATE();
    case 378:
      if (lookahead == 'n') ADVANCE(1371);
      END_STATE();
    case 379:
      if (lookahead == 'n') ADVANCE(1496);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(1606);
      END_STATE();
    case 381:
      if (lookahead == 'n') ADVANCE(1378);
      END_STATE();
    case 382:
      if (lookahead == 'n') ADVANCE(1378);
      if (lookahead == 's') ADVANCE(1428);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 384:
      if (lookahead == 'n') ADVANCE(550);
      if (lookahead == 'x') ADVANCE(528);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(155);
      END_STATE();
    case 386:
      if (lookahead == 'n') ADVANCE(410);
      END_STATE();
    case 387:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 388:
      if (lookahead == 'n') ADVANCE(273);
      END_STATE();
    case 389:
      if (lookahead == 'n') ADVANCE(274);
      END_STATE();
    case 390:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 391:
      if (lookahead == 'n') ADVANCE(275);
      END_STATE();
    case 392:
      if (lookahead == 'n') ADVANCE(557);
      END_STATE();
    case 393:
      if (lookahead == 'n') ADVANCE(189);
      END_STATE();
    case 394:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(276);
      END_STATE();
    case 396:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 397:
      if (lookahead == 'n') ADVANCE(371);
      END_STATE();
    case 398:
      if (lookahead == 'n') ADVANCE(505);
      END_STATE();
    case 399:
      if (lookahead == 'n') ADVANCE(504);
      END_STATE();
    case 400:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 401:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 402:
      if (lookahead == 'n') ADVANCE(122);
      END_STATE();
    case 403:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 404:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 405:
      if (lookahead == 'n') ADVANCE(566);
      END_STATE();
    case 406:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 407:
      if (lookahead == 'n') ADVANCE(312);
      END_STATE();
    case 408:
      if (lookahead == 'n') ADVANCE(311);
      END_STATE();
    case 409:
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 410:
      if (lookahead == 'o') ADVANCE(570);
      END_STATE();
    case 411:
      if (lookahead == 'o') ADVANCE(285);
      END_STATE();
    case 412:
      if (lookahead == 'o') ADVANCE(569);
      END_STATE();
    case 413:
      if (lookahead == 'o') ADVANCE(554);
      END_STATE();
    case 414:
      if (lookahead == 'o') ADVANCE(336);
      END_STATE();
    case 415:
      if (lookahead == 'o') ADVANCE(499);
      if (lookahead == 'r') ADVANCE(196);
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 416:
      if (lookahead == 'o') ADVANCE(373);
      END_STATE();
    case 417:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 418:
      if (lookahead == 'o') ADVANCE(553);
      END_STATE();
    case 419:
      if (lookahead == 'o') ADVANCE(552);
      END_STATE();
    case 420:
      if (lookahead == 'o') ADVANCE(456);
      END_STATE();
    case 421:
      if (lookahead == 'o') ADVANCE(500);
      END_STATE();
    case 422:
      if (lookahead == 'o') ADVANCE(338);
      END_STATE();
    case 423:
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 424:
      if (lookahead == 'o') ADVANCE(479);
      END_STATE();
    case 425:
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 426:
      if (lookahead == 'o') ADVANCE(341);
      END_STATE();
    case 427:
      if (lookahead == 'o') ADVANCE(458);
      if (lookahead == 'u') ADVANCE(368);
      END_STATE();
    case 428:
      if (lookahead == 'o') ADVANCE(459);
      END_STATE();
    case 429:
      if (lookahead == 'o') ADVANCE(461);
      END_STATE();
    case 430:
      if (lookahead == 'o') ADVANCE(378);
      END_STATE();
    case 431:
      if (lookahead == 'o') ADVANCE(463);
      END_STATE();
    case 432:
      if (lookahead == 'o') ADVANCE(379);
      END_STATE();
    case 433:
      if (lookahead == 'o') ADVANCE(380);
      END_STATE();
    case 434:
      if (lookahead == 'o') ADVANCE(397);
      END_STATE();
    case 435:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 436:
      if (lookahead == 'o') ADVANCE(175);
      END_STATE();
    case 437:
      if (lookahead == 'o') ADVANCE(361);
      END_STATE();
    case 438:
      if (lookahead == 'o') ADVANCE(538);
      END_STATE();
    case 439:
      if (lookahead == 'o') ADVANCE(402);
      END_STATE();
    case 440:
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 441:
      if (lookahead == 'p') ADVANCE(194);
      if (lookahead == 'v') ADVANCE(232);
      END_STATE();
    case 442:
      if (lookahead == 'p') ADVANCE(1528);
      END_STATE();
    case 443:
      if (lookahead == 'p') ADVANCE(252);
      if (lookahead == 'v') ADVANCE(232);
      END_STATE();
    case 444:
      if (lookahead == 'p') ADVANCE(197);
      END_STATE();
    case 445:
      if (lookahead == 'p') ADVANCE(517);
      END_STATE();
    case 446:
      if (lookahead == 'p') ADVANCE(216);
      END_STATE();
    case 447:
      if (lookahead == 'p') ADVANCE(254);
      if (lookahead == 'q') ADVANCE(562);
      END_STATE();
    case 448:
      if (lookahead == 'p') ADVANCE(424);
      END_STATE();
    case 449:
      if (lookahead == 'p') ADVANCE(478);
      END_STATE();
    case 450:
      if (lookahead == 'p') ADVANCE(242);
      END_STATE();
    case 451:
      if (lookahead == 'p') ADVANCE(314);
      END_STATE();
    case 452:
      if (lookahead == 'p') ADVANCE(255);
      if (lookahead == 't') ADVANCE(440);
      END_STATE();
    case 453:
      if (lookahead == 'q') ADVANCE(562);
      END_STATE();
    case 454:
      if (lookahead == 'r') ADVANCE(1449);
      END_STATE();
    case 455:
      if (lookahead == 'r') ADVANCE(1487);
      END_STATE();
    case 456:
      if (lookahead == 'r') ADVANCE(1493);
      END_STATE();
    case 457:
      if (lookahead == 'r') ADVANCE(1388);
      END_STATE();
    case 458:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 459:
      if (lookahead == 'r') ADVANCE(1608);
      END_STATE();
    case 460:
      if (lookahead == 'r') ADVANCE(76);
      END_STATE();
    case 461:
      if (lookahead == 'r') ADVANCE(1527);
      END_STATE();
    case 462:
      if (lookahead == 'r') ADVANCE(1600);
      END_STATE();
    case 463:
      if (lookahead == 'r') ADVANCE(1344);
      END_STATE();
    case 464:
      if (lookahead == 'r') ADVANCE(438);
      END_STATE();
    case 465:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 466:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 467:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 468:
      if (lookahead == 'r') ADVANCE(559);
      END_STATE();
    case 469:
      if (lookahead == 'r') ADVANCE(412);
      END_STATE();
    case 470:
      if (lookahead == 'r') ADVANCE(407);
      END_STATE();
    case 471:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 472:
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 473:
      if (lookahead == 'r') ADVANCE(418);
      END_STATE();
    case 474:
      if (lookahead == 'r') ADVANCE(475);
      END_STATE();
    case 475:
      if (lookahead == 'r') ADVANCE(318);
      END_STATE();
    case 476:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 477:
      if (lookahead == 'r') ADVANCE(419);
      END_STATE();
    case 478:
      if (lookahead == 'r') ADVANCE(325);
      END_STATE();
    case 479:
      if (lookahead == 'r') ADVANCE(513);
      END_STATE();
    case 480:
      if (lookahead == 'r') ADVANCE(296);
      END_STATE();
    case 481:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 482:
      if (lookahead == 'r') ADVANCE(523);
      END_STATE();
    case 483:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 484:
      if (lookahead == 'r') ADVANCE(256);
      END_STATE();
    case 485:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 486:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 487:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 488:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 489:
      if (lookahead == 'r') ADVANCE(401);
      END_STATE();
    case 490:
      if (lookahead == 'r') ADVANCE(428);
      END_STATE();
    case 491:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 492:
      if (lookahead == 's') ADVANCE(1475);
      END_STATE();
    case 493:
      if (lookahead == 's') ADVANCE(1469);
      END_STATE();
    case 494:
      if (lookahead == 's') ADVANCE(411);
      END_STATE();
    case 495:
      if (lookahead == 's') ADVANCE(417);
      if (lookahead == 'y') ADVANCE(390);
      END_STATE();
    case 496:
      if (lookahead == 's') ADVANCE(173);
      END_STATE();
    case 497:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 498:
      if (lookahead == 's') ADVANCE(492);
      END_STATE();
    case 499:
      if (lookahead == 's') ADVANCE(520);
      END_STATE();
    case 500:
      if (lookahead == 's') ADVANCE(561);
      END_STATE();
    case 501:
      if (lookahead == 's') ADVANCE(201);
      END_STATE();
    case 502:
      if (lookahead == 's') ADVANCE(112);
      if (lookahead == 'u') ADVANCE(399);
      END_STATE();
    case 503:
      if (lookahead == 's') ADVANCE(437);
      END_STATE();
    case 504:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 505:
      if (lookahead == 's') ADVANCE(319);
      END_STATE();
    case 506:
      if (lookahead == 't') ADVANCE(119);
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 507:
      if (lookahead == 't') ADVANCE(1512);
      END_STATE();
    case 508:
      if (lookahead == 't') ADVANCE(1484);
      END_STATE();
    case 509:
      if (lookahead == 't') ADVANCE(1502);
      END_STATE();
    case 510:
      if (lookahead == 't') ADVANCE(1363);
      END_STATE();
    case 511:
      if (lookahead == 't') ADVANCE(1586);
      END_STATE();
    case 512:
      if (lookahead == 't') ADVANCE(1506);
      END_STATE();
    case 513:
      if (lookahead == 't') ADVANCE(1466);
      END_STATE();
    case 514:
      if (lookahead == 't') ADVANCE(1453);
      END_STATE();
    case 515:
      if (lookahead == 't') ADVANCE(1472);
      END_STATE();
    case 516:
      if (lookahead == 't') ADVANCE(1499);
      END_STATE();
    case 517:
      if (lookahead == 't') ADVANCE(1508);
      END_STATE();
    case 518:
      if (lookahead == 't') ADVANCE(1510);
      END_STATE();
    case 519:
      if (lookahead == 't') ADVANCE(1513);
      END_STATE();
    case 520:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 521:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 522:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 523:
      if (lookahead == 't') ADVANCE(578);
      END_STATE();
    case 524:
      if (lookahead == 't') ADVANCE(420);
      END_STATE();
    case 525:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 526:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 527:
      if (lookahead == 't') ADVANCE(423);
      END_STATE();
    case 528:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 529:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 530:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 531:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 532:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 533:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 534:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 535:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 536:
      if (lookahead == 't') ADVANCE(307);
      if (lookahead == 'v') ADVANCE(240);
      END_STATE();
    case 537:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 538:
      if (lookahead == 't') ADVANCE(425);
      END_STATE();
    case 539:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 540:
      if (lookahead == 't') ADVANCE(313);
      END_STATE();
    case 541:
      if (lookahead == 't') ADVANCE(429);
      END_STATE();
    case 542:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 543:
      if (lookahead == 't') ADVANCE(431);
      END_STATE();
    case 544:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 545:
      if (lookahead == 't') ADVANCE(582);
      END_STATE();
    case 546:
      if (lookahead == 't') ADVANCE(258);
      END_STATE();
    case 547:
      if (lookahead == 't') ADVANCE(440);
      END_STATE();
    case 548:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 549:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 550:
      if (lookahead == 'u') ADVANCE(362);
      END_STATE();
    case 551:
      if (lookahead == 'u') ADVANCE(529);
      END_STATE();
    case 552:
      if (lookahead == 'u') ADVANCE(442);
      END_STATE();
    case 553:
      if (lookahead == 'u') ADVANCE(277);
      END_STATE();
    case 554:
      if (lookahead == 'u') ADVANCE(471);
      END_STATE();
    case 555:
      if (lookahead == 'u') ADVANCE(511);
      END_STATE();
    case 556:
      if (lookahead == 'u') ADVANCE(200);
      if (lookahead == 'y') ADVANCE(1407);
      END_STATE();
    case 557:
      if (lookahead == 'u') ADVANCE(207);
      END_STATE();
    case 558:
      if (lookahead == 'u') ADVANCE(527);
      END_STATE();
    case 559:
      if (lookahead == 'u') ADVANCE(166);
      END_STATE();
    case 560:
      if (lookahead == 'u') ADVANCE(476);
      END_STATE();
    case 561:
      if (lookahead == 'u') ADVANCE(488);
      END_STATE();
    case 562:
      if (lookahead == 'u') ADVANCE(320);
      END_STATE();
    case 563:
      if (lookahead == 'u') ADVANCE(549);
      END_STATE();
    case 564:
      if (lookahead == 'v') ADVANCE(134);
      END_STATE();
    case 565:
      if (lookahead == 'v') ADVANCE(137);
      END_STATE();
    case 566:
      if (lookahead == 'v') ADVANCE(240);
      END_STATE();
    case 567:
      if (lookahead == 'v') ADVANCE(247);
      END_STATE();
    case 568:
      if (lookahead == 'v') ADVANCE(143);
      END_STATE();
    case 569:
      if (lookahead == 'w') ADVANCE(1455);
      END_STATE();
    case 570:
      if (lookahead == 'w') ADVANCE(403);
      END_STATE();
    case 571:
      if (lookahead == 'x') ADVANCE(1521);
      END_STATE();
    case 572:
      if (lookahead == 'x') ADVANCE(1518);
      END_STATE();
    case 573:
      if (lookahead == 'x') ADVANCE(1524);
      END_STATE();
    case 574:
      if (lookahead == 'y') ADVANCE(444);
      END_STATE();
    case 575:
      if (lookahead == 'y') ADVANCE(1337);
      END_STATE();
    case 576:
      if (lookahead == 'y') ADVANCE(91);
      END_STATE();
    case 577:
      if (lookahead == 'y') ADVANCE(1538);
      END_STATE();
    case 578:
      if (lookahead == 'y') ADVANCE(1599);
      END_STATE();
    case 579:
      if (lookahead == 'y') ADVANCE(1516);
      END_STATE();
    case 580:
      if (lookahead == 'y') ADVANCE(390);
      END_STATE();
    case 581:
      if (lookahead == 'y') ADVANCE(450);
      END_STATE();
    case 582:
      if (lookahead == 'y') ADVANCE(446);
      END_STATE();
    case 583:
      if (lookahead == 'z') ADVANCE(577);
      END_STATE();
    case 584:
      if (lookahead == '}') ADVANCE(1314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(584);
      END_STATE();
    case 585:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(591);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1257);
      END_STATE();
    case 586:
      if (lookahead == '.' ||
          lookahead == '<') ADVANCE(586);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1356);
      END_STATE();
    case 587:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1264);
      END_STATE();
    case 588:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1263);
      END_STATE();
    case 589:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_simple_identifier_token4_character_set_1(lookahead)) ADVANCE(1251);
      END_STATE();
    case 590:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1256);
      END_STATE();
    case 591:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1257);
      END_STATE();
    case 592:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1262);
      END_STATE();
    case 593:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(584);
      END_STATE();
    case 594:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '0') ADVANCE(1260);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == 'P') ADVANCE(464);
      if (lookahead == 'T') ADVANCE(574);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1309);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '_') ADVANCE(1536);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(152);
      if (lookahead == 'b') ADVANCE(467);
      if (lookahead == 'c') ADVANCE(106);
      if (lookahead == 'd') ADVANCE(191);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(101);
      if (lookahead == 'g') ADVANCE(224);
      if (lookahead == 'i') ADVANCE(264);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(290);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'p') ADVANCE(109);
      if (lookahead == 'r') ADVANCE(192);
      if (lookahead == 's') ADVANCE(193);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(226);
      if (lookahead == 'y') ADVANCE(295);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(594)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      END_STATE();
    case 595:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == '<') ADVANCE(1359);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1362);
      if (lookahead == '?') ADVANCE(586);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(673);
      if (lookahead == 'c') ADVANCE(793);
      if (lookahead == 'd') ADVANCE(831);
      if (lookahead == 'e') ADVANCE(817);
      if (lookahead == 'f') ADVANCE(647);
      if (lookahead == 'g') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(739);
      if (lookahead == 'l') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(913);
      if (lookahead == 'n') ADVANCE(757);
      if (lookahead == 'o') ADVANCE(848);
      if (lookahead == 'p') ADVANCE(833);
      if (lookahead == 'r') ADVANCE(699);
      if (lookahead == 's') ADVANCE(715);
      if (lookahead == 't') ADVANCE(754);
      if (lookahead == 'u') ADVANCE(807);
      if (lookahead == 'v') ADVANCE(654);
      if (lookahead == 'w') ADVANCE(719);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '^' ||
          lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(595)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_4(lookahead)) ADVANCE(1246);
      END_STATE();
    case 596:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1013);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(597)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 597:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(1272);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(79);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == '0') ADVANCE(1258);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(1311);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == 'f') ADVANCE(956);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == 'n') ADVANCE(1049);
      if (lookahead == 's') ADVANCE(1013);
      if (lookahead == 't') ADVANCE(1155);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(1443);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(597)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1259);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 598:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '0') ADVANCE(1261);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(599)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 599:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1439);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1435);
      if (lookahead == '+') ADVANCE(1430);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1432);
      if (lookahead == '.') ADVANCE(78);
      if (lookahead == '/') ADVANCE(1437);
      if (lookahead == '0') ADVANCE(1261);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(1422);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(599)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 600:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(601)
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 601:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '$') ADVANCE(589);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == '`') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(1176);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(601)
      if (aux_sym_simple_identifier_token1_character_set_1(lookahead)) ADVANCE(1246);
      END_STATE();
    case 602:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1334);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(603)
      END_STATE();
    case 603:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(1440);
      if (lookahead == '&') ADVANCE(1340);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(1436);
      if (lookahead == '+') ADVANCE(1431);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(1433);
      if (lookahead == '.') ADVANCE(1328);
      if (lookahead == '/') ADVANCE(1438);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1358);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(1361);
      if (lookahead == '?') ADVANCE(1332);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == '[') ADVANCE(1325);
      if (lookahead == '\\') ADVANCE(586);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '^') ADVANCE(1445);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(245);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '|') ADVANCE(1444);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '~') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(603)
      END_STATE();
    case 604:
      if (eof) ADVANCE(607);
      if (lookahead == '!') ADVANCE(1322);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(83);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(84);
      if (lookahead == '+') ADVANCE(85);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '0') ADVANCE(1261);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '=') ADVANCE(1421);
      if (lookahead == '>') ADVANCE(1360);
      if (lookahead == '?') ADVANCE(1333);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == 'P') ADVANCE(464);
      if (lookahead == 'T') ADVANCE(574);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(260);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == 'g') ADVANCE(249);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(218);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(226);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(605)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      END_STATE();
    case 605:
      if (eof) ADVANCE(607);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '%') ADVANCE(83);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == '*') ADVANCE(84);
      if (lookahead == '+') ADVANCE(85);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '0') ADVANCE(1261);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == ';') ADVANCE(1505);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '=') ADVANCE(1421);
      if (lookahead == '>') ADVANCE(1360);
      if (lookahead == '?') ADVANCE(1331);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == 'P') ADVANCE(464);
      if (lookahead == 'T') ADVANCE(574);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead == ']') ADVANCE(1326);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(260);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == 'g') ADVANCE(249);
      if (lookahead == 'i') ADVANCE(265);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(218);
      if (lookahead == 's') ADVANCE(250);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(226);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(605)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1261);
      END_STATE();
    case 606:
      if (eof) ADVANCE(607);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '&') ADVANCE(1339);
      if (lookahead == '(') ADVANCE(1324);
      if (lookahead == ')') ADVANCE(1316);
      if (lookahead == ',') ADVANCE(1319);
      if (lookahead == '.') ADVANCE(1327);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == ':') ADVANCE(1321);
      if (lookahead == '<') ADVANCE(1357);
      if (lookahead == '?') ADVANCE(1331);
      if (lookahead == '@') ADVANCE(1535);
      if (lookahead == 'a') ADVANCE(153);
      if (lookahead == 'c') ADVANCE(107);
      if (lookahead == 'd') ADVANCE(261);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(365);
      if (lookahead == 'l') ADVANCE(102);
      if (lookahead == 'm') ADVANCE(551);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'p') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(217);
      if (lookahead == 's') ADVANCE(506);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(225);
      if (lookahead == '{') ADVANCE(1376);
      if (lookahead == '}') ADVANCE(1377);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(606)
      END_STATE();
    case 607:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '#') ADVANCE(617);
      if (lookahead == '/') ADVANCE(610);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(609);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '/') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'L') ADVANCE(630);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(638);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'a') ADVANCE(634);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(612);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'c') ADVANCE(619);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'd') ADVANCE(622);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(625);
      if (lookahead == 'i') ADVANCE(620);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 'w') ADVANCE(613);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(622);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'e') ADVANCE(611);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'f') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'g') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(620);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(627);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'i') ADVANCE(631);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'l') ADVANCE(637);
      if (lookahead == 'n') ADVANCE(616);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(621);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'n') ADVANCE(623);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(639);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(614);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(626);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'o') ADVANCE(633);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(628);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(615);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'r') ADVANCE(632);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 's') ADVANCE(618);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 't') ADVANCE(624);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == 'u') ADVANCE(635);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(640);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '.') ADVANCE(1354);
      if (lookahead == '/') ADVANCE(641);
      if (lookahead == '<') ADVANCE(642);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1350);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(644);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '.') ADVANCE(1354);
      if (lookahead == '<') ADVANCE(642);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1350);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(644);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '<') ADVANCE(643);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('=' <= lookahead && lookahead <= '?') ||
          lookahead == '^' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(1354);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(644);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(644);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1345);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1346);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(795);
      if (lookahead == 'i') ADVANCE(796);
      if (lookahead == 'o') ADVANCE(858);
      if (lookahead == 'u') ADVANCE(809);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(795);
      if (lookahead == 'i') ADVANCE(821);
      if (lookahead == 'o') ADVANCE(858);
      if (lookahead == 'u') ADVANCE(809);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(936);
      if (lookahead == 'e') ADVANCE(885);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(879);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(805);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(784);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(859);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(860);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(788);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(907);
      if (lookahead == 'r') ADVANCE(914);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(877);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(789);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(790);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(890);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(792);
      if (lookahead == 'i') ADVANCE(796);
      if (lookahead == 'o') ADVANCE(858);
      if (lookahead == 'u') ADVANCE(809);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(771);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(903);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(884);
      if (lookahead == 'l') ADVANCE(651);
      if (lookahead == 'o') ADVANCE(814);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(800);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(902);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(904);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(908);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(905);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'a') ADVANCE(906);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'b') ADVANCE(797);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(894);
      if (lookahead == 's') ADVANCE(878);
      if (lookahead == 'w') ADVANCE(663);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(894);
      if (lookahead == 's') ADVANCE(934);
      if (lookahead == 'w') ADVANCE(663);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(1491);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(1342);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(752);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(1554);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(1575);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(1578);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(714);
      if (lookahead == 'f') ADVANCE(760);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(781);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(891);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(892);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(718);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(706);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'c') ADVANCE(845);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(1394);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(1595);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(1548);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(1551);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(1464);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(769);
      if (lookahead == 'f') ADVANCE(756);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == 'o') ADVANCE(918);
      if (lookahead == 't') ADVANCE(728);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(769);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(705);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(895);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(761);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'd') ADVANCE(733);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(851);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(681);
      if (lookahead == 'i') ADVANCE(924);
      if (lookahead == 'o') ADVANCE(899);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1266);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1269);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1452);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1557);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1542);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1545);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1563);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1532);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(850);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1398);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(1460);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(852);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(786);
      if (lookahead == 't') ADVANCE(863);
      if (lookahead == 'u') ADVANCE(857);
      if (lookahead == 'w') ADVANCE(768);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(698);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(787);
      if (lookahead == 't') ADVANCE(657);
      if (lookahead == 'u') ADVANCE(857);
      if (lookahead == 'w') ADVANCE(768);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(787);
      if (lookahead == 't') ADVANCE(863);
      if (lookahead == 'u') ADVANCE(857);
      if (lookahead == 'w') ADVANCE(768);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(689);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(751);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(650);
      if (lookahead == 'h') ADVANCE(764);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(856);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(690);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(867);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(696);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(691);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(811);
      if (lookahead == 't') ADVANCE(763);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(822);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(666);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(874);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(826);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(653);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(798);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(862);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(824);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(893);
      if (lookahead == 'u') ADVANCE(655);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(746);
      if (lookahead == 'i') ADVANCE(924);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(684);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(661);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(828);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1392);
      if (lookahead == 'm') ADVANCE(854);
      if (lookahead == 'n') ADVANCE(693);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1392);
      if (lookahead == 'n') ADVANCE(693);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1392);
      if (lookahead == 'n') ADVANCE(1379);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1392);
      if (lookahead == 'n') ADVANCE(694);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1392);
      if (lookahead == 'n') ADVANCE(1380);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(1386);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(933);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(760);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'f') ADVANCE(762);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'g') ADVANCE(1572);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'g') ADVANCE(753);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'g') ADVANCE(864);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'h') ADVANCE(1396);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'h') ADVANCE(1401);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'h') ADVANCE(873);
      if (lookahead == 'r') ADVANCE(917);
      if (lookahead == 'y') ADVANCE(855);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'h') ADVANCE(865);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(929);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(785);
      if (lookahead == 'o') ADVANCE(810);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(785);
      if (lookahead == 'o') ADVANCE(819);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(785);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(930);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(745);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(931);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(847);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(799);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(881);
      if (lookahead == 'm') ADVANCE(923);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(846);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(678);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(900);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(866);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(679);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(887);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(680);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(658);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(812);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(816);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(823);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(731);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(695);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(870);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(738);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(668);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'i') ADVANCE(926);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'k') ADVANCE(1592);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'k') ADVANCE(1462);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(1254);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(744);
      if (lookahead == 't') ADVANCE(1514);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(744);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(1584);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(1560);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(1581);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(1482);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(801);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(651);
      if (lookahead == 'o') ADVANCE(808);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(651);
      if (lookahead == 'o') ADVANCE(830);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(882);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(720);
      if (lookahead == 'n') ADVANCE(656);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(767);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(692);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(703);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(773);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(897);
      if (lookahead == 's') ADVANCE(702);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'l') ADVANCE(670);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'm') ADVANCE(1479);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'm') ADVANCE(843);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'm') ADVANCE(772);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'm') ADVANCE(923);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(835);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(925);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(675);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(765);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(1566);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(748);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(1497);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(909);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(1458);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(749);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(912);
      if (lookahead == 'x') ADVANCE(898);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(676);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(806);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(652);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(656);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(883);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(920);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(685);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(717);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(780);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(659);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(686);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(660);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'n') ADVANCE(910);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(1404);
      if (lookahead == 'y') ADVANCE(820);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(1404);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(880);
      if (lookahead == 'r') ADVANCE(700);
      if (lookahead == 'u') ADVANCE(672);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(880);
      if (lookahead == 'r') ADVANCE(735);
      if (lookahead == 'u') ADVANCE(672);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(928);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(682);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(927);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(916);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(861);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(687);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(802);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(869);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(697);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(915);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(791);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(813);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'o') ADVANCE(829);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(725);
      if (lookahead == 'v') ADVANCE(722);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(1529);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(737);
      if (lookahead == 'q') ADVANCE(922);
      if (lookahead == 't') ADVANCE(919);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(737);
      if (lookahead == 'q') ADVANCE(922);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(737);
      if (lookahead == 't') ADVANCE(919);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(708);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(842);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(727);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(871);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'p') ADVANCE(732);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(1450);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(1488);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(688);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(1494);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(1389);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(914);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(838);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(844);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(736);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(868);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(778);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(889);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(721);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(782);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(815);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(837);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(827);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'r') ADVANCE(730);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(1476);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(1470);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(836);
      if (lookahead == 'y') ADVANCE(818);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(876);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(896);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(841);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(702);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(766);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(710);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1485);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1503);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1364);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1587);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1454);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1473);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1500);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1511);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(839);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(935);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(747);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(755);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(840);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(677);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(667);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(774);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(704);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(723);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(724);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(707);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(770);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(775);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(776);
      if (lookahead == 'v') ADVANCE(729);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(776);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(669);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(803);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(901);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(683);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(750);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(849);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(701);
      if (lookahead == 'y') ADVANCE(1406);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(888);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(872);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(711);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(655);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(779);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'u') ADVANCE(911);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'v') ADVANCE(664);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'v') ADVANCE(729);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'v') ADVANCE(671);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'w') ADVANCE(1456);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'w') ADVANCE(825);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'x') ADVANCE(1522);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'x') ADVANCE(1519);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'x') ADVANCE(1525);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'y') ADVANCE(1539);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'y') ADVANCE(1517);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'y') ADVANCE(818);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'y') ADVANCE(853);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 'z') ADVANCE(932);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == ':') ADVANCE(1448);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(937);
      if (aux_sym_simple_identifier_token1_character_set_7(lookahead)) ADVANCE(1246);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1180);
      if (lookahead == 'l') ADVANCE(946);
      if (lookahead == 'o') ADVANCE(1099);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1180);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1073);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1244);
      if (lookahead == 'e') ADVANCE(1190);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1244);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1055);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1072);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1094);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1181);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1202);
      if (lookahead == 'r') ADVANCE(1226);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1202);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1075);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1076);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1204);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1157);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1077);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1177);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1089);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == 'u') ADVANCE(1117);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1089);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1087);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1203);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1088);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1206);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1215);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1207);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'a') ADVANCE(1211);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_8(lookahead)) ADVANCE(1246);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1086);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1183);
      if (lookahead == 'p') ADVANCE(1019);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'b') ADVANCE(1183);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1343);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1555);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1576);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1579);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1492);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1201);
      if (lookahead == 's') ADVANCE(1182);
      if (lookahead == 'w') ADVANCE(943);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1201);
      if (lookahead == 's') ADVANCE(1182);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1201);
      if (lookahead == 's') ADVANCE(1241);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1196);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1070);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1197);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(998);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1030);
      if (lookahead == 'f') ADVANCE(1052);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1017);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1137);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'c') ADVANCE(1172);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1596);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1549);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1552);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(997);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1199);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(1046);
      if (lookahead == 'i') ADVANCE(1193);
      if (lookahead == 'o') ADVANCE(1222);
      if (lookahead == 't') ADVANCE(1007);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'd') ADVANCE(1032);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1153);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1036);
      if (lookahead == 'i') ADVANCE(1229);
      if (lookahead == 'o') ADVANCE(1214);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1036);
      if (lookahead == 'i') ADVANCE(1229);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1399);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1267);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1270);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1558);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1543);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1546);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1564);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1336);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1079);
      if (lookahead == 'u') ADVANCE(1147);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(979);
      if (lookahead == 'i') ADVANCE(1229);
      if (lookahead == 'o') ADVANCE(1214);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1533);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1161);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1151);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(983);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1174);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 'o') ADVANCE(1095);
      if (lookahead == 'u') ADVANCE(1147);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 't') ADVANCE(947);
      if (lookahead == 'u') ADVANCE(965);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 't') ADVANCE(947);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 't') ADVANCE(948);
      if (lookahead == 'u') ADVANCE(1147);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 't') ADVANCE(1164);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 'u') ADVANCE(1147);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1080);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(984);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(985);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1041);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(944);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1156);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(987);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1102);
      if (lookahead == 't') ADVANCE(1050);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1190);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1123);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1158);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1217);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1160);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1115);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(959);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1119);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(989);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(977);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1125);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'e') ADVANCE(1065);
      if (lookahead == 'y') ADVANCE(1116);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1387);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1046);
      if (lookahead == 'o') ADVANCE(1222);
      if (lookahead == 't') ADVANCE(1007);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1052);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'f') ADVANCE(1054);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1570);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1573);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1042);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'g') ADVANCE(1166);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1402);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'h') ADVANCE(1162);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == 'u') ADVANCE(1117);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1234);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(986);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1074);
      if (lookahead == 'o') ADVANCE(1100);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1074);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1144);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(968);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1235);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(969);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1236);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1187);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1148);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(970);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1179);
      if (lookahead == 'm') ADVANCE(1228);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1169);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1103);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1193);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1111);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1194);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1027);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1124);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1142);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(954);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1173);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1118);
      if (lookahead == 'u') ADVANCE(1117);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(963);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'i') ADVANCE(1231);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'k') ADVANCE(1593);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1084);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1255);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1585);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1561);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1582);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1483);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1034);
      if (lookahead == 't') ADVANCE(1209);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1034);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(946);
      if (lookahead == 'o') ADVANCE(1099);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(946);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1005);
      if (lookahead == 'n') ADVANCE(949);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1188);
      if (lookahead == 's') ADVANCE(995);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1188);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1051);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1085);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1067);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(1184);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'l') ADVANCE(960);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1480);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1152);
      if (lookahead == 'n') ADVANCE(988);
      if (lookahead == 's') ADVANCE(1429);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1152);
      if (lookahead == 'n') ADVANCE(988);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1057);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'm') ADVANCE(1000);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1035);
      if (lookahead == 's') ADVANCE(1429);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1035);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1127);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1230);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1058);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(967);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1567);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1038);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1498);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1384);
      if (lookahead == 's') ADVANCE(1429);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1384);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1382);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1383);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1239);
      if (lookahead == 's') ADVANCE(1241);
      if (lookahead == 'w') ADVANCE(943);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1239);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1039);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1220);
      if (lookahead == 'x') ADVANCE(1210);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1220);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246);
      if (aux_sym_simple_identifier_token1_character_set_6(lookahead)) ADVANCE(1246);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(aux_sym_simple_identifier_token1);
      if (lookahead == 'n') ADVANCE(1143);
      if (lookahead == 65039) ADVANCE(1245);
      if ((127995 <= lookahead && lookahead <= 127999)) ADVANCE(1246