#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 541
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 132
#define ALIAS_COUNT 3
#define TOKEN_COUNT 70
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 15

enum {
  anon_sym_DQUOTE = 1,
  aux_sym_string_token1 = 2,
  anon_sym_PERCENT_LPAREN = 3,
  anon_sym_RPAREN = 4,
  aux_sym_raw_string_token1 = 5,
  aux_sym_raw_string_token2 = 6,
  aux_sym_comment_token1 = 7,
  anon_sym_SLASH_STAR = 8,
  anon_sym_STAR_SLASH = 9,
  sym_static_field = 10,
  sym_field = 11,
  sym_name = 12,
  sym_null = 13,
  aux_sym_number_token1 = 14,
  aux_sym_number_token2 = 15,
  aux_sym_number_token3 = 16,
  aux_sym_number_token4 = 17,
  anon_sym_true = 18,
  anon_sym_false = 19,
  anon_sym_return = 20,
  anon_sym_EQ = 21,
  anon_sym_BANG = 22,
  anon_sym_DASH = 23,
  anon_sym_TILDE = 24,
  anon_sym_PLUS = 25,
  anon_sym_EQ_EQ = 26,
  anon_sym_BANG_EQ = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT_EQ = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_SLASH = 32,
  anon_sym_STAR = 33,
  anon_sym_PERCENT = 34,
  anon_sym_GT_GT = 35,
  anon_sym_LT_LT = 36,
  anon_sym_AMP = 37,
  anon_sym_LT = 38,
  anon_sym_GT = 39,
  anon_sym_is = 40,
  anon_sym_LBRACE = 41,
  anon_sym_RBRACE = 42,
  anon_sym_COMMA = 43,
  anon_sym_var = 44,
  anon_sym_LPAREN = 45,
  anon_sym_PIPE = 46,
  anon_sym_class = 47,
  aux_sym_prefix_operator_definition_token1 = 48,
  anon_sym_LBRACK = 49,
  anon_sym_RBRACK = 50,
  anon_sym_construct = 51,
  anon_sym_static = 52,
  anon_sym_QMARK = 53,
  anon_sym_COLON = 54,
  anon_sym_DOT = 55,
  anon_sym_DOT_DOT = 56,
  anon_sym_DOT_DOT_DOT = 57,
  anon_sym_if = 58,
  anon_sym_else = 59,
  anon_sym_for = 60,
  anon_sym_in = 61,
  anon_sym_while = 62,
  sym_break_statement = 63,
  sym_continue_statement = 64,
  anon_sym_POUND = 65,
  anon_sym_POUND_BANG = 66,
  anon_sym_as = 67,
  sym_shebang = 68,
  anon_sym_import = 69,
  sym_source_file = 70,
  sym_string = 71,
  sym_raw_string = 72,
  sym_comment = 73,
  sym_number = 74,
  sym_boolean = 75,
  sym_return_statement = 76,
  sym_assignment = 77,
  sym_unary_expression = 78,
  sym_binary_expression = 79,
  sym_block = 80,
  sym_parameter = 81,
  sym_parameter_list = 82,
  sym_argument_list = 83,
  sym_variable_definition = 84,
  sym_call_expression = 85,
  sym_call_body = 86,
  sym_class_definition = 87,
  sym_class_body = 88,
  sym_getter_definition = 89,
  sym_setter_definition = 90,
  sym_prefix_operator_definition = 91,
  sym_subscript_operator_definition = 92,
  sym_subscript_setter_definition = 93,
  sym_infix_operator_definition = 94,
  sym_method_definition = 95,
  sym_constructor = 96,
  sym_static_method_definition = 97,
  sym_static_getter_definition = 98,
  sym_conditional = 99,
  sym_list = 100,
  sym_index_expression = 101,
  sym_subscript = 102,
  sym_range = 103,
  sym_if_statement = 104,
  sym_for_statement = 105,
  sym_while_statement = 106,
  sym_pair = 107,
  sym_map = 108,
  sym__any_attribute = 109,
  sym_attribute = 110,
  sym_runtime_attribute = 111,
  sym_attribute_value = 112,
  sym_rename = 113,
  sym__import_entry = 114,
  sym_import_statement = 115,
  sym__statement = 116,
  sym__expression = 117,
  aux_sym_source_file_repeat1 = 118,
  aux_sym_string_repeat1 = 119,
  aux_sym_string_repeat2 = 120,
  aux_sym_raw_string_repeat1 = 121,
  aux_sym_comment_repeat1 = 122,
  aux_sym_parameter_list_repeat1 = 123,
  aux_sym_argument_list_repeat1 = 124,
  aux_sym_class_definition_repeat1 = 125,
  aux_sym_class_body_repeat1 = 126,
  aux_sym_class_body_repeat2 = 127,
  aux_sym_map_repeat1 = 128,
  aux_sym_attribute_repeat1 = 129,
  aux_sym_runtime_attribute_repeat1 = 130,
  aux_sym_import_statement_repeat1 = 131,
  alias_sym_else_branch = 132,
  anon_alias_sym_getter = 133,
  anon_alias_sym_parameter = 134,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_PERCENT_LPAREN] = "%(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_raw_string_token1] = "raw_string_token1",
  [aux_sym_raw_string_token2] = "raw_string_token2",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SLASH_STAR] = "/*",
  [anon_sym_STAR_SLASH] = "*/",
  [sym_static_field] = "static_field",
  [sym_field] = "field",
  [sym_name] = "name",
  [sym_null] = "null",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [aux_sym_number_token3] = "number_token3",
  [aux_sym_number_token4] = "number_token4",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_return] = "return",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "operator",
  [anon_sym_DASH] = "operator",
  [anon_sym_TILDE] = "operator",
  [anon_sym_PLUS] = "operator",
  [anon_sym_EQ_EQ] = "operator",
  [anon_sym_BANG_EQ] = "operator",
  [anon_sym_LT_EQ] = "operator",
  [anon_sym_GT_EQ] = "operator",
  [anon_sym_AMP_AMP] = "operator",
  [anon_sym_PIPE_PIPE] = "operator",
  [anon_sym_SLASH] = "operator",
  [anon_sym_STAR] = "operator",
  [anon_sym_PERCENT] = "operator",
  [anon_sym_GT_GT] = "operator",
  [anon_sym_LT_LT] = "operator",
  [anon_sym_AMP] = "operator",
  [anon_sym_LT] = "operator",
  [anon_sym_GT] = "operator",
  [anon_sym_is] = "is",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COMMA] = ",",
  [anon_sym_var] = "var",
  [anon_sym_LPAREN] = "(",
  [anon_sym_PIPE] = "|",
  [anon_sym_class] = "class",
  [aux_sym_prefix_operator_definition_token1] = "operator",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_construct] = "construct",
  [anon_sym_static] = "static",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND_BANG] = "#!",
  [anon_sym_as] = "as",
  [sym_shebang] = "shebang",
  [anon_sym_import] = "import",
  [sym_source_file] = "source_file",
  [sym_string] = "string",
  [sym_raw_string] = "raw_string",
  [sym_comment] = "comment",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_return_statement] = "return_statement",
  [sym_assignment] = "assignment",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_block] = "block",
  [sym_parameter] = "parameter",
  [sym_parameter_list] = "parameter_list",
  [sym_argument_list] = "parameter_list",
  [sym_variable_definition] = "variable_definition",
  [sym_call_expression] = "call_expression",
  [sym_call_body] = "call_body",
  [sym_class_definition] = "class_definition",
  [sym_class_body] = "class_body",
  [sym_getter_definition] = "getter_definition",
  [sym_setter_definition] = "setter_definition",
  [sym_prefix_operator_definition] = "prefix_operator_definition",
  [sym_subscript_operator_definition] = "subscript_operator_definition",
  [sym_subscript_setter_definition] = "subscript_setter_definition",
  [sym_infix_operator_definition] = "infix_operator_definition",
  [sym_method_definition] = "method_definition",
  [sym_constructor] = "constructor",
  [sym_static_method_definition] = "static_method_definition",
  [sym_static_getter_definition] = "static_getter_definition",
  [sym_conditional] = "conditional",
  [sym_list] = "list",
  [sym_index_expression] = "index_expression",
  [sym_subscript] = "subscript",
  [sym_range] = "range",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_pair] = "pair",
  [sym_map] = "map",
  [sym__any_attribute] = "_any_attribute",
  [sym_attribute] = "attribute",
  [sym_runtime_attribute] = "runtime_attribute",
  [sym_attribute_value] = "attribute_value",
  [sym_rename] = "rename",
  [sym__import_entry] = "_import_entry",
  [sym_import_statement] = "import_statement",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_raw_string_repeat1] = "raw_string_repeat1",
  [aux_sym_comment_repeat1] = "comment_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_class_body_repeat2] = "class_body_repeat2",
  [aux_sym_map_repeat1] = "map_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_runtime_attribute_repeat1] = "runtime_attribute_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [alias_sym_else_branch] = "else_branch",
  [anon_alias_sym_getter] = "getter",
  [anon_alias_sym_parameter] = "parameter",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_PERCENT_LPAREN] = anon_sym_PERCENT_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_raw_string_token1] = aux_sym_raw_string_token1,
  [aux_sym_raw_string_token2] = aux_sym_raw_string_token2,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [anon_sym_STAR_SLASH] = anon_sym_STAR_SLASH,
  [sym_static_field] = sym_static_field,
  [sym_field] = sym_field,
  [sym_name] = sym_name,
  [sym_null] = sym_null,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [aux_sym_number_token3] = aux_sym_number_token3,
  [aux_sym_number_token4] = aux_sym_number_token4,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_BANG,
  [anon_sym_EQ_EQ] = anon_sym_BANG,
  [anon_sym_BANG_EQ] = anon_sym_BANG,
  [anon_sym_LT_EQ] = anon_sym_BANG,
  [anon_sym_GT_EQ] = anon_sym_BANG,
  [anon_sym_AMP_AMP] = anon_sym_BANG,
  [anon_sym_PIPE_PIPE] = anon_sym_BANG,
  [anon_sym_SLASH] = anon_sym_BANG,
  [anon_sym_STAR] = anon_sym_BANG,
  [anon_sym_PERCENT] = anon_sym_BANG,
  [anon_sym_GT_GT] = anon_sym_BANG,
  [anon_sym_LT_LT] = anon_sym_BANG,
  [anon_sym_AMP] = anon_sym_BANG,
  [anon_sym_LT] = anon_sym_BANG,
  [anon_sym_GT] = anon_sym_BANG,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_class] = anon_sym_class,
  [aux_sym_prefix_operator_definition_token1] = anon_sym_BANG,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_construct] = anon_sym_construct,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [anon_sym_as] = anon_sym_as,
  [sym_shebang] = sym_shebang,
  [anon_sym_import] = anon_sym_import,
  [sym_source_file] = sym_source_file,
  [sym_string] = sym_string,
  [sym_raw_string] = sym_raw_string,
  [sym_comment] = sym_comment,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_return_statement] = sym_return_statement,
  [sym_assignment] = sym_assignment,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_block] = sym_block,
  [sym_parameter] = sym_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym_argument_list] = sym_parameter_list,
  [sym_variable_definition] = sym_variable_definition,
  [sym_call_expression] = sym_call_expression,
  [sym_call_body] = sym_call_body,
  [sym_class_definition] = sym_class_definition,
  [sym_class_body] = sym_class_body,
  [sym_getter_definition] = sym_getter_definition,
  [sym_setter_definition] = sym_setter_definition,
  [sym_prefix_operator_definition] = sym_prefix_operator_definition,
  [sym_subscript_operator_definition] = sym_subscript_operator_definition,
  [sym_subscript_setter_definition] = sym_subscript_setter_definition,
  [sym_infix_operator_definition] = sym_infix_operator_definition,
  [sym_method_definition] = sym_method_definition,
  [sym_constructor] = sym_constructor,
  [sym_static_method_definition] = sym_static_method_definition,
  [sym_static_getter_definition] = sym_static_getter_definition,
  [sym_conditional] = sym_conditional,
  [sym_list] = sym_list,
  [sym_index_expression] = sym_index_expression,
  [sym_subscript] = sym_subscript,
  [sym_range] = sym_range,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_pair] = sym_pair,
  [sym_map] = sym_map,
  [sym__any_attribute] = sym__any_attribute,
  [sym_attribute] = sym_attribute,
  [sym_runtime_attribute] = sym_runtime_attribute,
  [sym_attribute_value] = sym_attribute_value,
  [sym_rename] = sym_rename,
  [sym__import_entry] = sym__import_entry,
  [sym_import_statement] = sym_import_statement,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_raw_string_repeat1] = aux_sym_raw_string_repeat1,
  [aux_sym_comment_repeat1] = aux_sym_comment_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_class_body_repeat2] = aux_sym_class_body_repeat2,
  [aux_sym_map_repeat1] = aux_sym_map_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_runtime_attribute_repeat1] = aux_sym_runtime_attribute_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [alias_sym_else_branch] = alias_sym_else_branch,
  [anon_alias_sym_getter] = anon_alias_sym_getter,
  [anon_alias_sym_parameter] = anon_alias_sym_parameter,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_static_field] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_prefix_operator_definition_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_construct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_body] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_setter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_static_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_static_getter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym__any_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_runtime_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_rename] = {
    .visible = true,
    .named = true,
  },
  [sym__import_entry] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_map_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_runtime_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_else_branch] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_getter] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_parameter] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_body = 1,
  field_function = 2,
  field_key = 3,
  field_left = 4,
  field_loop_variable = 5,
  field_name = 6,
  field_right = 7,
  field_value = 8,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_loop_variable] = "loop_variable",
  [field_name] = "name",
  [field_right] = "right",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 1},
  [12] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
  [14] = {.index = 11, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_function, 0},
  [1] =
    {field_left, 0},
    {field_right, 2},
  [3] =
    {field_body, 1},
  [4] =
    {field_name, 1},
  [5] =
    {field_key, 0},
    {field_value, 2},
  [7] =
    {field_body, 4},
  [8] =
    {field_body, 3},
  [9] =
    {field_loop_variable, 2},
  [10] =
    {field_body, 5},
  [11] =
    {field_body, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [1] = anon_sym_BANG,
  },
  [7] = {
    [0] = anon_alias_sym_parameter,
  },
  [8] = {
    [1] = anon_alias_sym_getter,
  },
  [11] = {
    [6] = alias_sym_else_branch,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_getter_definition, 2,
    sym_getter_definition,
    anon_alias_sym_getter,
  sym__statement, 2,
    sym__statement,
    alias_sym_else_branch,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 2,
  [7] = 7,
  [8] = 4,
  [9] = 4,
  [10] = 2,
  [11] = 11,
  [12] = 11,
  [13] = 13,
  [14] = 14,
  [15] = 13,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 17,
  [20] = 13,
  [21] = 11,
  [22] = 16,
  [23] = 23,
  [24] = 17,
  [25] = 16,
  [26] = 13,
  [27] = 17,
  [28] = 11,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 30,
  [34] = 34,
  [35] = 31,
  [36] = 34,
  [37] = 37,
  [38] = 38,
  [39] = 37,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 44,
  [47] = 47,
  [48] = 47,
  [49] = 45,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 43,
  [57] = 40,
  [58] = 58,
  [59] = 59,
  [60] = 58,
  [61] = 61,
  [62] = 62,
  [63] = 59,
  [64] = 54,
  [65] = 65,
  [66] = 55,
  [67] = 62,
  [68] = 54,
  [69] = 69,
  [70] = 70,
  [71] = 41,
  [72] = 65,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 53,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 75,
  [87] = 73,
  [88] = 50,
  [89] = 85,
  [90] = 61,
  [91] = 84,
  [92] = 69,
  [93] = 38,
  [94] = 70,
  [95] = 42,
  [96] = 83,
  [97] = 74,
  [98] = 82,
  [99] = 51,
  [100] = 80,
  [101] = 79,
  [102] = 78,
  [103] = 77,
  [104] = 76,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 52,
  [110] = 54,
  [111] = 111,
  [112] = 107,
  [113] = 106,
  [114] = 105,
  [115] = 37,
  [116] = 44,
  [117] = 45,
  [118] = 47,
  [119] = 83,
  [120] = 38,
  [121] = 41,
  [122] = 70,
  [123] = 69,
  [124] = 42,
  [125] = 65,
  [126] = 62,
  [127] = 59,
  [128] = 58,
  [129] = 50,
  [130] = 82,
  [131] = 40,
  [132] = 51,
  [133] = 43,
  [134] = 76,
  [135] = 55,
  [136] = 74,
  [137] = 61,
  [138] = 138,
  [139] = 73,
  [140] = 77,
  [141] = 75,
  [142] = 80,
  [143] = 78,
  [144] = 85,
  [145] = 84,
  [146] = 79,
  [147] = 41,
  [148] = 42,
  [149] = 40,
  [150] = 43,
  [151] = 37,
  [152] = 38,
  [153] = 153,
  [154] = 154,
  [155] = 44,
  [156] = 156,
  [157] = 47,
  [158] = 158,
  [159] = 45,
  [160] = 160,
  [161] = 161,
  [162] = 154,
  [163] = 163,
  [164] = 154,
  [165] = 156,
  [166] = 158,
  [167] = 167,
  [168] = 168,
  [169] = 168,
  [170] = 170,
  [171] = 168,
  [172] = 158,
  [173] = 158,
  [174] = 156,
  [175] = 156,
  [176] = 154,
  [177] = 168,
  [178] = 178,
  [179] = 179,
  [180] = 161,
  [181] = 181,
  [182] = 181,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 181,
  [187] = 187,
  [188] = 185,
  [189] = 185,
  [190] = 153,
  [191] = 170,
  [192] = 181,
  [193] = 185,
  [194] = 163,
  [195] = 195,
  [196] = 75,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 50,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 85,
  [207] = 195,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 212,
  [214] = 214,
  [215] = 204,
  [216] = 216,
  [217] = 84,
  [218] = 218,
  [219] = 211,
  [220] = 204,
  [221] = 216,
  [222] = 184,
  [223] = 183,
  [224] = 83,
  [225] = 225,
  [226] = 226,
  [227] = 82,
  [228] = 216,
  [229] = 225,
  [230] = 230,
  [231] = 231,
  [232] = 74,
  [233] = 61,
  [234] = 80,
  [235] = 214,
  [236] = 236,
  [237] = 210,
  [238] = 79,
  [239] = 211,
  [240] = 209,
  [241] = 73,
  [242] = 242,
  [243] = 210,
  [244] = 55,
  [245] = 78,
  [246] = 209,
  [247] = 218,
  [248] = 216,
  [249] = 197,
  [250] = 187,
  [251] = 58,
  [252] = 59,
  [253] = 62,
  [254] = 77,
  [255] = 65,
  [256] = 256,
  [257] = 38,
  [258] = 209,
  [259] = 259,
  [260] = 210,
  [261] = 204,
  [262] = 211,
  [263] = 42,
  [264] = 225,
  [265] = 69,
  [266] = 70,
  [267] = 267,
  [268] = 203,
  [269] = 225,
  [270] = 51,
  [271] = 199,
  [272] = 272,
  [273] = 76,
  [274] = 267,
  [275] = 275,
  [276] = 208,
  [277] = 200,
  [278] = 230,
  [279] = 231,
  [280] = 272,
  [281] = 226,
  [282] = 236,
  [283] = 38,
  [284] = 42,
  [285] = 259,
  [286] = 256,
  [287] = 242,
  [288] = 202,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 291,
  [293] = 291,
  [294] = 291,
  [295] = 295,
  [296] = 296,
  [297] = 296,
  [298] = 296,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 299,
  [303] = 301,
  [304] = 304,
  [305] = 305,
  [306] = 305,
  [307] = 305,
  [308] = 296,
  [309] = 300,
  [310] = 305,
  [311] = 311,
  [312] = 311,
  [313] = 313,
  [314] = 313,
  [315] = 315,
  [316] = 315,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 319,
  [321] = 319,
  [322] = 319,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 202,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 330,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 42,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 38,
  [348] = 348,
  [349] = 41,
  [350] = 40,
  [351] = 43,
  [352] = 352,
  [353] = 324,
  [354] = 354,
  [355] = 348,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 357,
  [360] = 358,
  [361] = 361,
  [362] = 358,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 358,
  [367] = 357,
  [368] = 357,
  [369] = 357,
  [370] = 370,
  [371] = 357,
  [372] = 357,
  [373] = 373,
  [374] = 374,
  [375] = 357,
  [376] = 376,
  [377] = 358,
  [378] = 378,
  [379] = 358,
  [380] = 358,
  [381] = 381,
  [382] = 358,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 364,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 346,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 402,
  [404] = 404,
  [405] = 401,
  [406] = 387,
  [407] = 352,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 385,
  [413] = 387,
  [414] = 414,
  [415] = 415,
  [416] = 383,
  [417] = 393,
  [418] = 401,
  [419] = 419,
  [420] = 399,
  [421] = 421,
  [422] = 402,
  [423] = 423,
  [424] = 345,
  [425] = 404,
  [426] = 426,
  [427] = 364,
  [428] = 402,
  [429] = 429,
  [430] = 399,
  [431] = 399,
  [432] = 401,
  [433] = 383,
  [434] = 383,
  [435] = 435,
  [436] = 387,
  [437] = 437,
  [438] = 438,
  [439] = 438,
  [440] = 440,
  [441] = 435,
  [442] = 390,
  [443] = 411,
  [444] = 444,
  [445] = 394,
  [446] = 43,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 450,
  [457] = 448,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 455,
  [469] = 348,
  [470] = 451,
  [471] = 449,
  [472] = 40,
  [473] = 42,
  [474] = 38,
  [475] = 475,
  [476] = 41,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 481,
  [487] = 487,
  [488] = 481,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 489,
  [493] = 493,
  [494] = 494,
  [495] = 481,
  [496] = 496,
  [497] = 491,
  [498] = 498,
  [499] = 483,
  [500] = 481,
  [501] = 490,
  [502] = 502,
  [503] = 481,
  [504] = 489,
  [505] = 485,
  [506] = 489,
  [507] = 490,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 490,
  [514] = 494,
  [515] = 515,
  [516] = 516,
  [517] = 515,
  [518] = 518,
  [519] = 518,
  [520] = 484,
  [521] = 508,
  [522] = 522,
  [523] = 496,
  [524] = 518,
  [525] = 508,
  [526] = 516,
  [527] = 510,
  [528] = 518,
  [529] = 508,
  [530] = 508,
  [531] = 522,
  [532] = 509,
  [533] = 508,
  [534] = 534,
  [535] = 534,
  [536] = 536,
  [537] = 537,
  [538] = 460,
  [539] = 458,
  [540] = 459,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(284);
      if (lookahead == '%') ADVANCE(240);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(238);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(97)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'b') ADVANCE(67);
      if (lookahead == 'c') ADVANCE(55);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(84);
      if (lookahead == 'r') ADVANCE(44);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(47);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(20)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(19)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(25)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(25)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(24)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '\r') SKIP(11)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(22)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '\r') ADVANCE(122);
      if (lookahead != 0) ADVANCE(122);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(16)
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '"') ADVANCE(131);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(29);
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(225);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == 'c') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(129);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '%') ADVANCE(27);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '%') ADVANCE(27);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(283);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '=') ADVANCE(221);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == 'c') ADVANCE(175);
      if (lookahead == 's') ADVANCE(197);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 26:
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '=') ADVANCE(221);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 27:
      if (lookahead == '(') ADVANCE(127);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(231);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 31:
      if (lookahead == '_') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(270);
      if (lookahead == 'm') ADVANCE(63);
      if (lookahead == 'n') ADVANCE(276);
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 47:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 51:
      if (lookahead == 'k') ADVANCE(279);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(77);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 63:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(251);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 71:
      if (lookahead == 's') ADVANCE(288);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 73:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 75:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 76:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(261);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 87:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 89:
      if (lookahead == '|') ADVANCE(235);
      END_STATE();
    case 90:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 92:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 93:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 94:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 95:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 96:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 97:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(96)
      END_STATE();
    case 98:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(114)
      END_STATE();
    case 99:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(114)
      if (lookahead == '\r') SKIP(98)
      END_STATE();
    case 100:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(115)
      END_STATE();
    case 101:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(115)
      if (lookahead == '\r') SKIP(100)
      END_STATE();
    case 102:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(112)
      END_STATE();
    case 103:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(112)
      if (lookahead == '\r') SKIP(102)
      END_STATE();
    case 104:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(113)
      END_STATE();
    case 105:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(113)
      if (lookahead == '\r') SKIP(104)
      END_STATE();
    case 106:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(116)
      END_STATE();
    case 107:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(116)
      if (lookahead == '\r') SKIP(106)
      END_STATE();
    case 108:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(117)
      END_STATE();
    case 109:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(117)
      if (lookahead == '\r') SKIP(108)
      END_STATE();
    case 110:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(118)
      END_STATE();
    case 111:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(118)
      if (lookahead == '\r') SKIP(110)
      END_STATE();
    case 112:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(103)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(112)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 113:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(105)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(113)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 114:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(284);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(99)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(114)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 115:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(101)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(254);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 116:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(107)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(116)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 117:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(109)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(117)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 118:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(111)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(118)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(21);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PERCENT_LPAREN);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_raw_string_token1);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '"') ADVANCE(21);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '"') ADVANCE(131);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '/') ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_STAR_SLASH);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_static_field);
      if (lookahead == '_') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_static_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_field);
      if (lookahead == '_') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(271);
      if (lookahead == 'm') ADVANCE(177);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(271);
      if (lookahead == 'm') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'h') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'k') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(292);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'x') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (lookahead == '.') ADVANCE(93);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_number_token3);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_number_token3);
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_number_token4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'f')) ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(231);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '/') ADVANCE(138);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '(') ADVANCE(127);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(234);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(242);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(241);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_is);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(235);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_class);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym_prefix_operator_definition_token1);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_construct);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_construct);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(268);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(269);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_break_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_continue_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(287);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_shebang);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 114},
  [2] = {.lex_state = 115},
  [3] = {.lex_state = 115},
  [4] = {.lex_state = 115},
  [5] = {.lex_state = 115},
  [6] = {.lex_state = 115},
  [7] = {.lex_state = 115},
  [8] = {.lex_state = 115},
  [9] = {.lex_state = 115},
  [10] = {.lex_state = 115},
  [11] = {.lex_state = 115},
  [12] = {.lex_state = 115},
  [13] = {.lex_state = 115},
  [14] = {.lex_state = 115},
  [15] = {.lex_state = 115},
  [16] = {.lex_state = 115},
  [17] = {.lex_state = 115},
  [18] = {.lex_state = 115},
  [19] = {.lex_state = 115},
  [20] = {.lex_state = 115},
  [21] = {.lex_state = 115},
  [22] = {.lex_state = 115},
  [23] = {.lex_state = 115},
  [24] = {.lex_state = 115},
  [25] = {.lex_state = 115},
  [26] = {.lex_state = 115},
  [27] = {.lex_state = 115},
  [28] = {.lex_state = 115},
  [29] = {.lex_state = 115},
  [30] = {.lex_state = 115},
  [31] = {.lex_state = 115},
  [32] = {.lex_state = 115},
  [33] = {.lex_state = 115},
  [34] = {.lex_state = 115},
  [35] = {.lex_state = 115},
  [36] = {.lex_state = 115},
  [37] = {.lex_state = 112},
  [38] = {.lex_state = 112},
  [39] = {.lex_state = 113},
  [40] = {.lex_state = 112},
  [41] = {.lex_state = 112},
  [42] = {.lex_state = 112},
  [43] = {.lex_state = 112},
  [44] = {.lex_state = 112},
  [45] = {.lex_state = 113},
  [46] = {.lex_state = 113},
  [47] = {.lex_state = 113},
  [48] = {.lex_state = 112},
  [49] = {.lex_state = 112},
  [50] = {.lex_state = 113},
  [51] = {.lex_state = 113},
  [52] = {.lex_state = 113},
  [53] = {.lex_state = 113},
  [54] = {.lex_state = 113},
  [55] = {.lex_state = 113},
  [56] = {.lex_state = 113},
  [57] = {.lex_state = 113},
  [58] = {.lex_state = 113},
  [59] = {.lex_state = 113},
  [60] = {.lex_state = 112},
  [61] = {.lex_state = 112},
  [62] = {.lex_state = 113},
  [63] = {.lex_state = 112},
  [64] = {.lex_state = 113},
  [65] = {.lex_state = 113},
  [66] = {.lex_state = 112},
  [67] = {.lex_state = 112},
  [68] = {.lex_state = 112},
  [69] = {.lex_state = 113},
  [70] = {.lex_state = 113},
  [71] = {.lex_state = 113},
  [72] = {.lex_state = 112},
  [73] = {.lex_state = 112},
  [74] = {.lex_state = 113},
  [75] = {.lex_state = 112},
  [76] = {.lex_state = 113},
  [77] = {.lex_state = 113},
  [78] = {.lex_state = 113},
  [79] = {.lex_state = 113},
  [80] = {.lex_state = 113},
  [81] = {.lex_state = 113},
  [82] = {.lex_state = 113},
  [83] = {.lex_state = 113},
  [84] = {.lex_state = 113},
  [85] = {.lex_state = 113},
  [86] = {.lex_state = 113},
  [87] = {.lex_state = 113},
  [88] = {.lex_state = 112},
  [89] = {.lex_state = 112},
  [90] = {.lex_state = 113},
  [91] = {.lex_state = 112},
  [92] = {.lex_state = 112},
  [93] = {.lex_state = 113},
  [94] = {.lex_state = 112},
  [95] = {.lex_state = 113},
  [96] = {.lex_state = 112},
  [97] = {.lex_state = 112},
  [98] = {.lex_state = 112},
  [99] = {.lex_state = 112},
  [100] = {.lex_state = 112},
  [101] = {.lex_state = 112},
  [102] = {.lex_state = 112},
  [103] = {.lex_state = 112},
  [104] = {.lex_state = 112},
  [105] = {.lex_state = 113},
  [106] = {.lex_state = 113},
  [107] = {.lex_state = 113},
  [108] = {.lex_state = 112},
  [109] = {.lex_state = 112},
  [110] = {.lex_state = 112},
  [111] = {.lex_state = 112},
  [112] = {.lex_state = 112},
  [113] = {.lex_state = 112},
  [114] = {.lex_state = 112},
  [115] = {.lex_state = 18},
  [116] = {.lex_state = 18},
  [117] = {.lex_state = 18},
  [118] = {.lex_state = 18},
  [119] = {.lex_state = 18},
  [120] = {.lex_state = 18},
  [121] = {.lex_state = 18},
  [122] = {.lex_state = 18},
  [123] = {.lex_state = 18},
  [124] = {.lex_state = 18},
  [125] = {.lex_state = 18},
  [126] = {.lex_state = 18},
  [127] = {.lex_state = 18},
  [128] = {.lex_state = 18},
  [129] = {.lex_state = 18},
  [130] = {.lex_state = 18},
  [131] = {.lex_state = 18},
  [132] = {.lex_state = 18},
  [133] = {.lex_state = 18},
  [134] = {.lex_state = 18},
  [135] = {.lex_state = 18},
  [136] = {.lex_state = 18},
  [137] = {.lex_state = 18},
  [138] = {.lex_state = 18},
  [139] = {.lex_state = 18},
  [140] = {.lex_state = 18},
  [141] = {.lex_state = 18},
  [142] = {.lex_state = 18},
  [143] = {.lex_state = 18},
  [144] = {.lex_state = 18},
  [145] = {.lex_state = 18},
  [146] = {.lex_state = 18},
  [147] = {.lex_state = 20},
  [148] = {.lex_state = 20},
  [149] = {.lex_state = 20},
  [150] = {.lex_state = 20},
  [151] = {.lex_state = 20},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 116},
  [154] = {.lex_state = 19},
  [155] = {.lex_state = 20},
  [156] = {.lex_state = 19},
  [157] = {.lex_state = 20},
  [158] = {.lex_state = 19},
  [159] = {.lex_state = 20},
  [160] = {.lex_state = 19},
  [161] = {.lex_state = 117},
  [162] = {.lex_state = 19},
  [163] = {.lex_state = 116},
  [164] = {.lex_state = 19},
  [165] = {.lex_state = 19},
  [166] = {.lex_state = 19},
  [167] = {.lex_state = 19},
  [168] = {.lex_state = 19},
  [169] = {.lex_state = 19},
  [170] = {.lex_state = 116},
  [171] = {.lex_state = 19},
  [172] = {.lex_state = 19},
  [173] = {.lex_state = 19},
  [174] = {.lex_state = 19},
  [175] = {.lex_state = 19},
  [176] = {.lex_state = 19},
  [177] = {.lex_state = 19},
  [178] = {.lex_state = 19},
  [179] = {.lex_state = 19},
  [180] = {.lex_state = 118},
  [181] = {.lex_state = 19},
  [182] = {.lex_state = 19},
  [183] = {.lex_state = 116},
  [184] = {.lex_state = 116},
  [185] = {.lex_state = 19},
  [186] = {.lex_state = 19},
  [187] = {.lex_state = 116},
  [188] = {.lex_state = 19},
  [189] = {.lex_state = 19},
  [190] = {.lex_state = 115},
  [191] = {.lex_state = 115},
  [192] = {.lex_state = 19},
  [193] = {.lex_state = 19},
  [194] = {.lex_state = 115},
  [195] = {.lex_state = 19},
  [196] = {.lex_state = 20},
  [197] = {.lex_state = 19},
  [198] = {.lex_state = 19},
  [199] = {.lex_state = 19},
  [200] = {.lex_state = 116},
  [201] = {.lex_state = 20},
  [202] = {.lex_state = 116},
  [203] = {.lex_state = 116},
  [204] = {.lex_state = 19},
  [205] = {.lex_state = 19},
  [206] = {.lex_state = 20},
  [207] = {.lex_state = 19},
  [208] = {.lex_state = 116},
  [209] = {.lex_state = 19},
  [210] = {.lex_state = 19},
  [211] = {.lex_state = 19},
  [212] = {.lex_state = 19},
  [213] = {.lex_state = 19},
  [214] = {.lex_state = 19},
  [215] = {.lex_state = 19},
  [216] = {.lex_state = 19},
  [217] = {.lex_state = 20},
  [218] = {.lex_state = 19},
  [219] = {.lex_state = 19},
  [220] = {.lex_state = 19},
  [221] = {.lex_state = 19},
  [222] = {.lex_state = 115},
  [223] = {.lex_state = 115},
  [224] = {.lex_state = 20},
  [225] = {.lex_state = 19},
  [226] = {.lex_state = 116},
  [227] = {.lex_state = 20},
  [228] = {.lex_state = 19},
  [229] = {.lex_state = 19},
  [230] = {.lex_state = 116},
  [231] = {.lex_state = 116},
  [232] = {.lex_state = 20},
  [233] = {.lex_state = 20},
  [234] = {.lex_state = 20},
  [235] = {.lex_state = 19},
  [236] = {.lex_state = 116},
  [237] = {.lex_state = 19},
  [238] = {.lex_state = 20},
  [239] = {.lex_state = 19},
  [240] = {.lex_state = 19},
  [241] = {.lex_state = 20},
  [242] = {.lex_state = 116},
  [243] = {.lex_state = 19},
  [244] = {.lex_state = 20},
  [245] = {.lex_state = 20},
  [246] = {.lex_state = 19},
  [247] = {.lex_state = 19},
  [248] = {.lex_state = 19},
  [249] = {.lex_state = 19},
  [250] = {.lex_state = 115},
  [251] = {.lex_state = 20},
  [252] = {.lex_state = 20},
  [253] = {.lex_state = 20},
  [254] = {.lex_state = 20},
  [255] = {.lex_state = 20},
  [256] = {.lex_state = 116},
  [257] = {.lex_state = 116},
  [258] = {.lex_state = 19},
  [259] = {.lex_state = 116},
  [260] = {.lex_state = 19},
  [261] = {.lex_state = 19},
  [262] = {.lex_state = 19},
  [263] = {.lex_state = 116},
  [264] = {.lex_state = 19},
  [265] = {.lex_state = 20},
  [266] = {.lex_state = 20},
  [267] = {.lex_state = 116},
  [268] = {.lex_state = 116},
  [269] = {.lex_state = 19},
  [270] = {.lex_state = 20},
  [271] = {.lex_state = 19},
  [272] = {.lex_state = 116},
  [273] = {.lex_state = 20},
  [274] = {.lex_state = 115},
  [275] = {.lex_state = 115},
  [276] = {.lex_state = 115},
  [277] = {.lex_state = 115},
  [278] = {.lex_state = 115},
  [279] = {.lex_state = 115},
  [280] = {.lex_state = 115},
  [281] = {.lex_state = 115},
  [282] = {.lex_state = 115},
  [283] = {.lex_state = 115},
  [284] = {.lex_state = 115},
  [285] = {.lex_state = 115},
  [286] = {.lex_state = 115},
  [287] = {.lex_state = 115},
  [288] = {.lex_state = 115},
  [289] = {.lex_state = 20},
  [290] = {.lex_state = 20},
  [291] = {.lex_state = 20},
  [292] = {.lex_state = 20},
  [293] = {.lex_state = 20},
  [294] = {.lex_state = 20},
  [295] = {.lex_state = 20},
  [296] = {.lex_state = 20},
  [297] = {.lex_state = 20},
  [298] = {.lex_state = 20},
  [299] = {.lex_state = 20},
  [300] = {.lex_state = 20},
  [301] = {.lex_state = 20},
  [302] = {.lex_state = 20},
  [303] = {.lex_state = 20},
  [304] = {.lex_state = 20},
  [305] = {.lex_state = 20},
  [306] = {.lex_state = 20},
  [307] = {.lex_state = 20},
  [308] = {.lex_state = 20},
  [309] = {.lex_state = 20},
  [310] = {.lex_state = 20},
  [311] = {.lex_state = 20},
  [312] = {.lex_state = 20},
  [313] = {.lex_state = 25},
  [314] = {.lex_state = 25},
  [315] = {.lex_state = 25},
  [316] = {.lex_state = 25},
  [317] = {.lex_state = 25},
  [318] = {.lex_state = 25},
  [319] = {.lex_state = 24},
  [320] = {.lex_state = 24},
  [321] = {.lex_state = 24},
  [322] = {.lex_state = 24},
  [323] = {.lex_state = 25},
  [324] = {.lex_state = 25},
  [325] = {.lex_state = 25},
  [326] = {.lex_state = 25},
  [327] = {.lex_state = 25},
  [328] = {.lex_state = 25},
  [329] = {.lex_state = 25},
  [330] = {.lex_state = 20},
  [331] = {.lex_state = 25},
  [332] = {.lex_state = 25},
  [333] = {.lex_state = 25},
  [334] = {.lex_state = 25},
  [335] = {.lex_state = 25},
  [336] = {.lex_state = 25},
  [337] = {.lex_state = 20},
  [338] = {.lex_state = 25},
  [339] = {.lex_state = 20},
  [340] = {.lex_state = 25},
  [341] = {.lex_state = 25},
  [342] = {.lex_state = 25},
  [343] = {.lex_state = 25},
  [344] = {.lex_state = 25},
  [345] = {.lex_state = 25},
  [346] = {.lex_state = 25},
  [347] = {.lex_state = 25},
  [348] = {.lex_state = 25},
  [349] = {.lex_state = 25},
  [350] = {.lex_state = 25},
  [351] = {.lex_state = 25},
  [352] = {.lex_state = 25},
  [353] = {.lex_state = 20},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 20},
  [356] = {.lex_state = 26},
  [357] = {.lex_state = 23},
  [358] = {.lex_state = 23},
  [359] = {.lex_state = 23},
  [360] = {.lex_state = 23},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 23},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 20},
  [365] = {.lex_state = 23},
  [366] = {.lex_state = 23},
  [367] = {.lex_state = 23},
  [368] = {.lex_state = 23},
  [369] = {.lex_state = 23},
  [370] = {.lex_state = 26},
  [371] = {.lex_state = 23},
  [372] = {.lex_state = 23},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 23},
  [376] = {.lex_state = 26},
  [377] = {.lex_state = 23},
  [378] = {.lex_state = 26},
  [379] = {.lex_state = 23},
  [380] = {.lex_state = 23},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 23},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 23},
  [385] = {.lex_state = 16},
  [386] = {.lex_state = 26},
  [387] = {.lex_state = 17},
  [388] = {.lex_state = 26},
  [389] = {.lex_state = 20},
  [390] = {.lex_state = 26},
  [391] = {.lex_state = 20},
  [392] = {.lex_state = 20},
  [393] = {.lex_state = 16},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 23},
  [396] = {.lex_state = 20},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 17},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 17},
  [406] = {.lex_state = 17},
  [407] = {.lex_state = 20},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 26},
  [410] = {.lex_state = 20},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 16},
  [413] = {.lex_state = 17},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 20},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 16},
  [418] = {.lex_state = 17},
  [419] = {.lex_state = 26},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 16},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 26},
  [424] = {.lex_state = 20},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 17},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 17},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 26},
  [436] = {.lex_state = 17},
  [437] = {.lex_state = 23},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 26},
  [442] = {.lex_state = 26},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 20},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 26},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 26},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 26},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 26},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 20},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 16},
  [459] = {.lex_state = 16},
  [460] = {.lex_state = 16},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 26},
  [463] = {.lex_state = 26},
  [464] = {.lex_state = 26},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 26},
  [467] = {.lex_state = 26},
  [468] = {.lex_state = 20},
  [469] = {.lex_state = 26},
  [470] = {.lex_state = 26},
  [471] = {.lex_state = 26},
  [472] = {.lex_state = 26},
  [473] = {.lex_state = 26},
  [474] = {.lex_state = 26},
  [475] = {.lex_state = 17},
  [476] = {.lex_state = 26},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 26},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 213},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 26},
  [484] = {.lex_state = 26},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 213},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 213},
  [489] = {.lex_state = 26},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 26},
  [492] = {.lex_state = 26},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 26},
  [495] = {.lex_state = 213},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 26},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 26},
  [500] = {.lex_state = 213},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 213},
  [504] = {.lex_state = 26},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 26},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 210},
  [509] = {.lex_state = 26},
  [510] = {.lex_state = 26},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 26},
  [515] = {.lex_state = 26},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 26},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 26},
  [521] = {.lex_state = 210},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 210},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 26},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 210},
  [530] = {.lex_state = 210},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 26},
  [533] = {.lex_state = 210},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {(TSStateId)(-1)},
  [539] = {(TSStateId)(-1)},
  [540] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_raw_string_token1] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_STAR_SLASH] = ACTIONS(1),
    [sym_static_field] = ACTIONS(1),
    [sym_field] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token4] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [aux_sym_prefix_operator_definition_token1] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_construct] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(512),
    [sym_string] = STATE(66),
    [sym_raw_string] = STATE(66),
    [sym_comment] = STATE(1),
    [sym_number] = STATE(66),
    [sym_boolean] = STATE(66),
    [sym_return_statement] = STATE(274),
    [sym_assignment] = STATE(274),
    [sym_unary_expression] = STATE(66),
    [sym_binary_expression] = STATE(66),
    [sym_block] = STATE(274),
    [sym_variable_definition] = STATE(274),
    [sym_call_expression] = STATE(66),
    [sym_class_definition] = STATE(274),
    [sym_conditional] = STATE(66),
    [sym_list] = STATE(66),
    [sym_index_expression] = STATE(37),
    [sym_subscript] = STATE(66),
    [sym_range] = STATE(66),
    [sym_if_statement] = STATE(274),
    [sym_for_statement] = STATE(274),
    [sym_while_statement] = STATE(274),
    [sym_map] = STATE(66),
    [sym__any_attribute] = STATE(389),
    [sym_attribute] = STATE(391),
    [sym_runtime_attribute] = STATE(391),
    [sym_import_statement] = STATE(274),
    [sym__statement] = STATE(275),
    [sym__expression] = STATE(108),
    [aux_sym_source_file_repeat1] = STATE(29),
    [aux_sym_class_definition_repeat1] = STATE(337),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [aux_sym_raw_string_token1] = ACTIONS(11),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [sym_static_field] = ACTIONS(13),
    [sym_field] = ACTIONS(13),
    [sym_name] = ACTIONS(15),
    [sym_null] = ACTIONS(17),
    [aux_sym_number_token1] = ACTIONS(19),
    [aux_sym_number_token4] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [anon_sym_return] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_class] = ACTIONS(35),
    [anon_sym_LBRACK] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [sym_break_statement] = ACTIONS(45),
    [sym_continue_statement] = ACTIONS(45),
    [anon_sym_POUND] = ACTIONS(47),
    [anon_sym_POUND_BANG] = ACTIONS(49),
    [sym_shebang] = ACTIONS(51),
    [anon_sym_import] = ACTIONS(53),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_RBRACE,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    STATE(2), 1,
      sym_comment,
    STATE(16), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(111), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(402), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [133] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_comment,
    STATE(25), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(111), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(422), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [266] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(61), 1,
      anon_sym_RBRACE,
    ACTIONS(63), 1,
      anon_sym_PIPE,
    STATE(4), 1,
      sym_comment,
    STATE(28), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [399] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(65), 1,
      anon_sym_RBRACE,
    ACTIONS(67), 1,
      anon_sym_PIPE,
    STATE(5), 1,
      sym_comment,
    STATE(21), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [532] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(69), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym_comment,
    STATE(16), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(111), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(422), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [665] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(76), 1,
      aux_sym_raw_string_token1,
    ACTIONS(82), 1,
      sym_name,
    ACTIONS(85), 1,
      sym_null,
    ACTIONS(88), 1,
      aux_sym_number_token1,
    ACTIONS(91), 1,
      aux_sym_number_token4,
    ACTIONS(97), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_DASH,
    ACTIONS(106), 1,
      anon_sym_LBRACE,
    ACTIONS(109), 1,
      anon_sym_var,
    ACTIONS(112), 1,
      anon_sym_class,
    ACTIONS(115), 1,
      anon_sym_LBRACK,
    ACTIONS(118), 1,
      anon_sym_if,
    ACTIONS(121), 1,
      anon_sym_for,
    ACTIONS(124), 1,
      anon_sym_while,
    ACTIONS(130), 1,
      anon_sym_POUND,
    ACTIONS(133), 1,
      anon_sym_POUND_BANG,
    ACTIONS(136), 1,
      anon_sym_import,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(71), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(79), 2,
      sym_static_field,
      sym_field,
    ACTIONS(94), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(100), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(127), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(7), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [794] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
    ACTIONS(141), 1,
      anon_sym_PIPE,
    STATE(8), 1,
      sym_comment,
    STATE(12), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [927] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
    ACTIONS(145), 1,
      anon_sym_PIPE,
    STATE(9), 1,
      sym_comment,
    STATE(11), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1060] = 36,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    STATE(10), 1,
      sym_comment,
    STATE(25), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(111), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(403), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1193] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(11), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1323] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(12), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1453] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(13), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1583] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(155), 1,
      ts_builtin_sym_end,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(14), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1713] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(157), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(15), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1843] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(159), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(16), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [1973] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(161), 1,
      anon_sym_RBRACE,
    STATE(17), 1,
      sym_comment,
    STATE(20), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2103] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(163), 1,
      anon_sym_RBRACE,
    STATE(18), 1,
      sym_comment,
    STATE(22), 1,
      aux_sym_source_file_repeat1,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2233] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(165), 1,
      anon_sym_RBRACE,
    STATE(15), 1,
      aux_sym_source_file_repeat1,
    STATE(19), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2363] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(167), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(20), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2493] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(169), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(21), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2623] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(171), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(22), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2753] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(173), 1,
      ts_builtin_sym_end,
    STATE(14), 1,
      aux_sym_source_file_repeat1,
    STATE(23), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [2883] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(175), 1,
      anon_sym_RBRACE,
    STATE(13), 1,
      aux_sym_source_file_repeat1,
    STATE(24), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3013] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(177), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(25), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3143] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(179), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(26), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3273] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(181), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      aux_sym_source_file_repeat1,
    STATE(27), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3403] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(183), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(28), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3533] = 35,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(173), 1,
      ts_builtin_sym_end,
    STATE(7), 1,
      aux_sym_source_file_repeat1,
    STATE(29), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(108), 1,
      sym__expression,
    STATE(275), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3663] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(201), 1,
      anon_sym_return,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(207), 1,
      anon_sym_LBRACE,
    ACTIONS(209), 1,
      anon_sym_var,
    ACTIONS(211), 1,
      anon_sym_class,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(215), 1,
      anon_sym_if,
    ACTIONS(217), 1,
      anon_sym_for,
    ACTIONS(219), 1,
      anon_sym_while,
    ACTIONS(223), 1,
      anon_sym_import,
    STATE(30), 1,
      sym_comment,
    STATE(39), 1,
      sym_index_expression,
    STATE(53), 1,
      sym__expression,
    STATE(268), 1,
      sym__statement,
    STATE(330), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(221), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(267), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3787] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(201), 1,
      anon_sym_return,
    ACTIONS(209), 1,
      anon_sym_var,
    ACTIONS(211), 1,
      anon_sym_class,
    ACTIONS(215), 1,
      anon_sym_if,
    ACTIONS(217), 1,
      anon_sym_for,
    ACTIONS(219), 1,
      anon_sym_while,
    ACTIONS(223), 1,
      anon_sym_import,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(245), 1,
      anon_sym_LBRACE,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    STATE(31), 1,
      sym_comment,
    STATE(151), 1,
      sym_index_expression,
    STATE(230), 1,
      sym__statement,
    STATE(312), 1,
      sym__expression,
    STATE(330), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(221), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(267), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [3911] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(249), 1,
      anon_sym_LBRACE,
    STATE(32), 1,
      sym_comment,
    STATE(151), 1,
      sym_index_expression,
    STATE(279), 1,
      sym__statement,
    STATE(311), 1,
      sym__expression,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [4035] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(201), 1,
      anon_sym_return,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(207), 1,
      anon_sym_LBRACE,
    ACTIONS(209), 1,
      anon_sym_var,
    ACTIONS(211), 1,
      anon_sym_class,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(215), 1,
      anon_sym_if,
    ACTIONS(217), 1,
      anon_sym_for,
    ACTIONS(219), 1,
      anon_sym_while,
    ACTIONS(223), 1,
      anon_sym_import,
    STATE(33), 1,
      sym_comment,
    STATE(39), 1,
      sym_index_expression,
    STATE(81), 1,
      sym__expression,
    STATE(203), 1,
      sym__statement,
    STATE(330), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(221), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(267), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [4159] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    STATE(34), 1,
      sym_comment,
    STATE(37), 1,
      sym_index_expression,
    STATE(109), 1,
      sym__expression,
    STATE(286), 1,
      sym__statement,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [4283] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(25), 1,
      anon_sym_return,
    ACTIONS(33), 1,
      anon_sym_var,
    ACTIONS(35), 1,
      anon_sym_class,
    ACTIONS(39), 1,
      anon_sym_if,
    ACTIONS(41), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(53), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(249), 1,
      anon_sym_LBRACE,
    STATE(35), 1,
      sym_comment,
    STATE(151), 1,
      sym_index_expression,
    STATE(278), 1,
      sym__statement,
    STATE(311), 1,
      sym__expression,
    STATE(337), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(45), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(274), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [4407] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(201), 1,
      anon_sym_return,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(207), 1,
      anon_sym_LBRACE,
    ACTIONS(209), 1,
      anon_sym_var,
    ACTIONS(211), 1,
      anon_sym_class,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(215), 1,
      anon_sym_if,
    ACTIONS(217), 1,
      anon_sym_for,
    ACTIONS(219), 1,
      anon_sym_while,
    ACTIONS(223), 1,
      anon_sym_import,
    STATE(36), 1,
      sym_comment,
    STATE(39), 1,
      sym_index_expression,
    STATE(52), 1,
      sym__expression,
    STATE(256), 1,
      sym__statement,
    STATE(330), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(221), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(267), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [4531] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(255), 1,
      anon_sym_LBRACE,
    ACTIONS(257), 1,
      anon_sym_LPAREN,
    STATE(37), 1,
      sym_comment,
    STATE(63), 1,
      sym_call_body,
    ACTIONS(251), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(253), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4603] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(38), 1,
      sym_comment,
    ACTIONS(259), 25,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(261), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4669] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_LPAREN,
    STATE(39), 1,
      sym_comment,
    STATE(59), 1,
      sym_call_body,
    ACTIONS(251), 21,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(253), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4741] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(40), 1,
      sym_comment,
    ACTIONS(267), 25,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(269), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4807] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(41), 1,
      sym_comment,
    ACTIONS(271), 25,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(273), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4873] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(42), 1,
      sym_comment,
    ACTIONS(275), 25,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(277), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4939] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(43), 1,
      sym_comment,
    ACTIONS(279), 25,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(281), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5005] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(255), 1,
      anon_sym_LBRACE,
    STATE(44), 1,
      sym_comment,
    STATE(100), 1,
      sym_call_body,
    ACTIONS(283), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(285), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5074] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(45), 1,
      sym_comment,
    STATE(85), 1,
      sym_call_body,
    ACTIONS(287), 21,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(289), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5143] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    STATE(46), 1,
      sym_comment,
    STATE(80), 1,
      sym_call_body,
    ACTIONS(283), 21,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(285), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5212] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(47), 1,
      sym_comment,
    ACTIONS(291), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(293), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5277] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(48), 1,
      sym_comment,
    ACTIONS(291), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(293), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5342] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(255), 1,
      anon_sym_LBRACE,
    STATE(49), 1,
      sym_comment,
    STATE(89), 1,
      sym_call_body,
    ACTIONS(287), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(289), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5411] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(50), 1,
      sym_comment,
    ACTIONS(295), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(297), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5475] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(51), 1,
      sym_comment,
    ACTIONS(299), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(301), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5539] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(307), 1,
      anon_sym_EQ,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(52), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(303), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(305), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5619] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(307), 1,
      anon_sym_EQ,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(53), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(323), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(325), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5699] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(54), 1,
      sym_comment,
    ACTIONS(327), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(329), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5763] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(55), 1,
      sym_comment,
    ACTIONS(251), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(253), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5827] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(56), 1,
      sym_comment,
    ACTIONS(279), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(281), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5891] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(57), 1,
      sym_comment,
    ACTIONS(267), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(269), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5955] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(58), 1,
      sym_comment,
    ACTIONS(331), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(333), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6019] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(59), 1,
      sym_comment,
    ACTIONS(335), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(337), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6083] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(60), 1,
      sym_comment,
    ACTIONS(331), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(333), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6147] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(61), 1,
      sym_comment,
    ACTIONS(339), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(341), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6211] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(62), 1,
      sym_comment,
    ACTIONS(343), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(345), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6275] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(63), 1,
      sym_comment,
    ACTIONS(335), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(337), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6339] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(64), 1,
      sym_comment,
    ACTIONS(347), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(329), 10,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(327), 13,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(349), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6407] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(65), 1,
      sym_comment,
    ACTIONS(351), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(353), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6471] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(66), 1,
      sym_comment,
    ACTIONS(251), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(253), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6535] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(67), 1,
      sym_comment,
    ACTIONS(343), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(345), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6599] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(68), 1,
      sym_comment,
    ACTIONS(327), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(329), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6663] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(69), 1,
      sym_comment,
    ACTIONS(355), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(357), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6727] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(70), 1,
      sym_comment,
    ACTIONS(359), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(361), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6791] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(71), 1,
      sym_comment,
    ACTIONS(271), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(273), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6855] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(72), 1,
      sym_comment,
    ACTIONS(351), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(353), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6919] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(73), 1,
      sym_comment,
    ACTIONS(363), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(365), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6983] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(74), 1,
      sym_comment,
    ACTIONS(327), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(329), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7047] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(367), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(369), 20,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7117] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(76), 1,
      sym_comment,
    ACTIONS(377), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(379), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7181] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(77), 1,
      sym_comment,
    ACTIONS(381), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(383), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7245] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    STATE(78), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(385), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(387), 21,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7315] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(79), 1,
      sym_comment,
    ACTIONS(389), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(391), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7379] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(80), 1,
      sym_comment,
    ACTIONS(287), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(289), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7443] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(307), 1,
      anon_sym_EQ,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(393), 1,
      anon_sym_else,
    STATE(81), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(323), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(325), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7525] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(82), 1,
      sym_comment,
    ACTIONS(395), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(397), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7589] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(83), 1,
      sym_comment,
    ACTIONS(399), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(401), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7653] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(84), 1,
      sym_comment,
    ACTIONS(403), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(405), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7717] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(85), 1,
      sym_comment,
    ACTIONS(407), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(409), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7781] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    STATE(86), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(367), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(369), 21,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7851] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(87), 1,
      sym_comment,
    ACTIONS(363), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(365), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7915] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(88), 1,
      sym_comment,
    ACTIONS(295), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(297), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7979] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(89), 1,
      sym_comment,
    ACTIONS(407), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(409), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8043] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(90), 1,
      sym_comment,
    ACTIONS(339), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(341), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8107] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(91), 1,
      sym_comment,
    ACTIONS(403), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(405), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8171] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(92), 1,
      sym_comment,
    ACTIONS(355), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(357), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8235] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(93), 1,
      sym_comment,
    ACTIONS(259), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(261), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8299] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(94), 1,
      sym_comment,
    ACTIONS(359), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(361), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8363] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(95), 1,
      sym_comment,
    ACTIONS(275), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(277), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8427] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(96), 1,
      sym_comment,
    ACTIONS(399), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(401), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8491] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(97), 1,
      sym_comment,
    ACTIONS(327), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(329), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8555] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(98), 1,
      sym_comment,
    ACTIONS(395), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(397), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8619] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(99), 1,
      sym_comment,
    ACTIONS(299), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(301), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8683] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(100), 1,
      sym_comment,
    ACTIONS(287), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(289), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8747] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(101), 1,
      sym_comment,
    ACTIONS(389), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(391), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8811] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    STATE(102), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(385), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(387), 20,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8881] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(103), 1,
      sym_comment,
    ACTIONS(381), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(383), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8945] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(104), 1,
      sym_comment,
    ACTIONS(377), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(379), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9009] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(105), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(411), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(413), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9086] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(106), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(415), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(417), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9163] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(313), 1,
      anon_sym_LBRACK,
    ACTIONS(315), 1,
      anon_sym_QMARK,
    ACTIONS(317), 1,
      anon_sym_DOT,
    ACTIONS(319), 1,
      anon_sym_DOT_DOT,
    ACTIONS(321), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(107), 1,
      sym_comment,
    ACTIONS(309), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(419), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(311), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(421), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9240] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(427), 1,
      anon_sym_EQ,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(108), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(423), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(425), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9319] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(427), 1,
      anon_sym_EQ,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(109), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(303), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(305), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9398] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(110), 1,
      sym_comment,
    ACTIONS(347), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(329), 10,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(327), 13,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(349), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9465] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(427), 1,
      anon_sym_EQ,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(437), 1,
      anon_sym_COLON,
    STATE(111), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(423), 8,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(425), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9546] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(112), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(419), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(421), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9622] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(113), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(415), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(417), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9698] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(375), 1,
      anon_sym_LBRACK,
    ACTIONS(429), 1,
      anon_sym_QMARK,
    ACTIONS(431), 1,
      anon_sym_DOT,
    ACTIONS(433), 1,
      anon_sym_DOT_DOT,
    ACTIONS(435), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(114), 1,
      sym_comment,
    ACTIONS(371), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(411), 9,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(373), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(413), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9774] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(439), 1,
      anon_sym_LBRACE,
    ACTIONS(441), 1,
      anon_sym_LPAREN,
    STATE(115), 1,
      sym_comment,
    STATE(127), 1,
      sym_call_body,
    ACTIONS(253), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(251), 19,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9832] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(439), 1,
      anon_sym_LBRACE,
    STATE(116), 1,
      sym_comment,
    STATE(142), 1,
      sym_call_body,
    ACTIONS(285), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(283), 19,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9887] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(439), 1,
      anon_sym_LBRACE,
    STATE(117), 1,
      sym_comment,
    STATE(144), 1,
      sym_call_body,
    ACTIONS(289), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(287), 19,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9942] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(118), 1,
      sym_comment,
    ACTIONS(293), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(291), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9993] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(119), 1,
      sym_comment,
    ACTIONS(401), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(399), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10043] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(120), 1,
      sym_comment,
    ACTIONS(261), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(259), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10093] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_comment,
    ACTIONS(273), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(271), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10143] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(122), 1,
      sym_comment,
    ACTIONS(361), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(359), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10193] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(123), 1,
      sym_comment,
    ACTIONS(357), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(355), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10243] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(124), 1,
      sym_comment,
    ACTIONS(277), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(275), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10293] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(125), 1,
      sym_comment,
    ACTIONS(353), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(351), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10343] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(126), 1,
      sym_comment,
    ACTIONS(345), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(343), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10393] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(127), 1,
      sym_comment,
    ACTIONS(337), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(335), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10443] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_comment,
    ACTIONS(333), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(331), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10493] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(129), 1,
      sym_comment,
    ACTIONS(297), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(295), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10543] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(130), 1,
      sym_comment,
    ACTIONS(397), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(395), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10593] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(131), 1,
      sym_comment,
    ACTIONS(269), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(267), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10643] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(132), 1,
      sym_comment,
    ACTIONS(301), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(299), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10693] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(133), 1,
      sym_comment,
    ACTIONS(281), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(279), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10743] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(134), 1,
      sym_comment,
    ACTIONS(379), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(377), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10793] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(135), 1,
      sym_comment,
    ACTIONS(253), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(251), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10843] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(136), 1,
      sym_comment,
    ACTIONS(329), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(327), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10893] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(137), 1,
      sym_comment,
    ACTIONS(341), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(339), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10943] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    ACTIONS(453), 1,
      anon_sym_QMARK,
    ACTIONS(455), 1,
      anon_sym_DOT,
    ACTIONS(457), 1,
      anon_sym_DOT_DOT,
    ACTIONS(459), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(138), 1,
      sym_comment,
    ACTIONS(443), 7,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(445), 7,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
    ACTIONS(447), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(449), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [11007] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(139), 1,
      sym_comment,
    ACTIONS(365), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(363), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11057] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(140), 1,
      sym_comment,
    ACTIONS(383), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(381), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11107] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    STATE(141), 1,
      sym_comment,
    ACTIONS(447), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(367), 9,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(369), 9,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(449), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [11163] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(142), 1,
      sym_comment,
    ACTIONS(289), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(287), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11213] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    STATE(143), 1,
      sym_comment,
    ACTIONS(447), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(385), 9,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(387), 9,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(449), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [11269] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(144), 1,
      sym_comment,
    ACTIONS(409), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(407), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11319] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(145), 1,
      sym_comment,
    ACTIONS(405), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(403), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11369] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(146), 1,
      sym_comment,
    ACTIONS(391), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(389), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11419] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(147), 1,
      sym_comment,
    ACTIONS(273), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(271), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11465] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(148), 1,
      sym_comment,
    ACTIONS(277), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(275), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11511] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(149), 1,
      sym_comment,
    ACTIONS(269), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(267), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11557] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(150), 1,
      sym_comment,
    ACTIONS(281), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(279), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11603] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    STATE(151), 1,
      sym_comment,
    STATE(252), 1,
      sym_call_body,
    ACTIONS(253), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(251), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11655] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(152), 1,
      sym_comment,
    ACTIONS(261), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(259), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11701] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(469), 1,
      anon_sym_COMMA,
    STATE(153), 1,
      sym_comment,
    STATE(163), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(465), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(467), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [11750] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(471), 1,
      anon_sym_RPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(154), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(501), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [11825] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    STATE(155), 1,
      sym_comment,
    STATE(234), 1,
      sym_call_body,
    ACTIONS(285), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(283), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11874] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(475), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(156), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [11949] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(157), 1,
      sym_comment,
    ACTIONS(293), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(291), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11994] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(477), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(158), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(428), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12069] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(461), 1,
      anon_sym_LBRACE,
    STATE(159), 1,
      sym_comment,
    STATE(206), 1,
      sym_call_body,
    ACTIONS(289), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(287), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [12118] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(481), 1,
      anon_sym_RPAREN,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(138), 1,
      sym__expression,
    STATE(160), 1,
      sym_comment,
    STATE(178), 1,
      aux_sym_string_repeat1,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12193] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(509), 1,
      anon_sym_as,
    STATE(161), 1,
      sym_comment,
    ACTIONS(505), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(507), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [12240] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      sym_index_expression,
    STATE(162), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(513), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12315] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(469), 1,
      anon_sym_COMMA,
    STATE(163), 1,
      sym_comment,
    STATE(170), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(513), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(515), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [12364] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(517), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      sym_index_expression,
    STATE(164), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(507), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12439] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(165), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12514] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(166), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(422), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12589] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      anon_sym_RPAREN,
    STATE(115), 1,
      sym_index_expression,
    STATE(138), 1,
      sym__expression,
    STATE(160), 1,
      aux_sym_string_repeat1,
    STATE(167), 1,
      sym_comment,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12664] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(525), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(168), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12739] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(169), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12814] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(533), 1,
      anon_sym_COMMA,
    STATE(170), 2,
      sym_comment,
      aux_sym_import_statement_repeat1,
    ACTIONS(529), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(531), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [12861] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(536), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(171), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [12936] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(538), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(172), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(403), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13011] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(540), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(173), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(402), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13086] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(542), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(174), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13161] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(544), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(175), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13236] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      sym_index_expression,
    STATE(176), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(490), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13311] = 20,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(548), 1,
      anon_sym_RBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(177), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13386] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(550), 1,
      anon_sym_DQUOTE,
    ACTIONS(553), 1,
      anon_sym_RPAREN,
    ACTIONS(555), 1,
      aux_sym_raw_string_token1,
    ACTIONS(561), 1,
      sym_name,
    ACTIONS(564), 1,
      sym_null,
    ACTIONS(567), 1,
      aux_sym_number_token1,
    ACTIONS(570), 1,
      aux_sym_number_token4,
    ACTIONS(579), 1,
      anon_sym_DASH,
    ACTIONS(582), 1,
      anon_sym_LBRACE,
    ACTIONS(585), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(138), 1,
      sym__expression,
    ACTIONS(558), 2,
      sym_static_field,
      sym_field,
    ACTIONS(573), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(576), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(178), 2,
      sym_comment,
      aux_sym_string_repeat1,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13459] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(179), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(452), 1,
      sym_pair,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13531] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(588), 1,
      anon_sym_as,
    STATE(180), 1,
      sym_comment,
    ACTIONS(505), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(507), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13577] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(590), 1,
      anon_sym_RBRACK,
    STATE(151), 1,
      sym_index_expression,
    STATE(181), 1,
      sym_comment,
    STATE(292), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13649] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(592), 1,
      anon_sym_RBRACK,
    STATE(151), 1,
      sym_index_expression,
    STATE(182), 1,
      sym_comment,
    STATE(291), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13721] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(183), 1,
      sym_comment,
    ACTIONS(529), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(531), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13765] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(184), 1,
      sym_comment,
    ACTIONS(594), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(596), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13809] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(185), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(524), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13881] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(598), 1,
      anon_sym_RBRACK,
    STATE(151), 1,
      sym_index_expression,
    STATE(186), 1,
      sym_comment,
    STATE(294), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [13953] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(187), 1,
      sym_comment,
    ACTIONS(505), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(507), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13997] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(188), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(518), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14069] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(189), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(519), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14141] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(600), 1,
      anon_sym_COMMA,
    STATE(190), 1,
      sym_comment,
    STATE(194), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(465), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(467), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14189] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(602), 1,
      anon_sym_COMMA,
    STATE(191), 2,
      sym_comment,
      aux_sym_import_statement_repeat1,
    ACTIONS(529), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(531), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14235] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    ACTIONS(605), 1,
      anon_sym_RBRACK,
    STATE(151), 1,
      sym_index_expression,
    STATE(192), 1,
      sym_comment,
    STATE(293), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14307] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(193), 1,
      sym_comment,
    STATE(289), 1,
      sym__expression,
    STATE(528), 1,
      sym_argument_list,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14379] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(600), 1,
      anon_sym_COMMA,
    STATE(191), 1,
      aux_sym_import_statement_repeat1,
    STATE(194), 1,
      sym_comment,
    ACTIONS(513), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(515), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14427] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(106), 1,
      sym__expression,
    STATE(195), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14496] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    STATE(196), 1,
      sym_comment,
    ACTIONS(369), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(367), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [14545] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(197), 1,
      sym_comment,
    STATE(309), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14614] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(198), 1,
      sym_comment,
    STATE(290), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14683] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(112), 1,
      sym__expression,
    STATE(199), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14752] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(200), 1,
      sym_comment,
    ACTIONS(617), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(619), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14795] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(201), 1,
      sym_comment,
    ACTIONS(297), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(295), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [14838] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(202), 1,
      sym_comment,
    ACTIONS(621), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(623), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14881] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(393), 1,
      anon_sym_else,
    STATE(203), 1,
      sym_comment,
    ACTIONS(323), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(325), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14926] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(103), 1,
      sym__expression,
    STATE(204), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [14995] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(205), 1,
      sym_comment,
    STATE(295), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15064] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(206), 1,
      sym_comment,
    ACTIONS(409), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(407), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [15107] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(113), 1,
      sym__expression,
    STATE(207), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15176] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(208), 1,
      sym_comment,
    ACTIONS(625), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(627), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [15219] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(196), 1,
      sym__expression,
    STATE(209), 1,
      sym_comment,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15288] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(210), 1,
      sym_comment,
    STATE(308), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15357] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(143), 1,
      sym__expression,
    STATE(211), 1,
      sym_comment,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15426] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(212), 1,
      sym_comment,
    STATE(303), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15495] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(213), 1,
      sym_comment,
    STATE(301), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15564] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(214), 1,
      sym_comment,
    STATE(299), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15633] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(140), 1,
      sym__expression,
    STATE(215), 1,
      sym_comment,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15702] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(67), 1,
      sym__expression,
    STATE(216), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15771] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(217), 1,
      sym_comment,
    ACTIONS(405), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(403), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [15814] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(114), 1,
      sym__expression,
    STATE(218), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15883] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(78), 1,
      sym__expression,
    STATE(219), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [15952] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(77), 1,
      sym__expression,
    STATE(220), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16021] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(126), 1,
      sym__expression,
    STATE(221), 1,
      sym_comment,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16090] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(222), 1,
      sym_comment,
    ACTIONS(594), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(596), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16133] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(223), 1,
      sym_comment,
    ACTIONS(529), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(531), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16176] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(224), 1,
      sym_comment,
    ACTIONS(401), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(399), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16219] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(225), 1,
      sym_comment,
    STATE(307), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16288] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(226), 1,
      sym_comment,
    ACTIONS(629), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(631), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16331] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(227), 1,
      sym_comment,
    ACTIONS(397), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(395), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16374] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(62), 1,
      sym__expression,
    STATE(228), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16443] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(229), 1,
      sym_comment,
    STATE(305), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16512] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(230), 1,
      sym_comment,
    ACTIONS(633), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(635), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16555] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(231), 1,
      sym_comment,
    ACTIONS(637), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(639), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16598] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(232), 1,
      sym_comment,
    ACTIONS(329), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(327), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16641] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(233), 1,
      sym_comment,
    ACTIONS(341), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(339), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16684] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(234), 1,
      sym_comment,
    ACTIONS(289), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(287), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16727] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(235), 1,
      sym_comment,
    STATE(302), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16796] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(236), 1,
      sym_comment,
    ACTIONS(641), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(643), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16839] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(237), 1,
      sym_comment,
    STATE(296), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [16908] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(238), 1,
      sym_comment,
    ACTIONS(391), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(389), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [16951] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(102), 1,
      sym__expression,
    STATE(239), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17020] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(86), 1,
      sym__expression,
    STATE(240), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17089] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(241), 1,
      sym_comment,
    ACTIONS(365), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(363), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17132] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(242), 1,
      sym_comment,
    ACTIONS(645), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(647), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17175] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(243), 1,
      sym_comment,
    STATE(298), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17244] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(244), 1,
      sym_comment,
    ACTIONS(253), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(251), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17287] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    STATE(245), 1,
      sym_comment,
    ACTIONS(387), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(385), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [17336] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(15), 1,
      sym_name,
    ACTIONS(17), 1,
      sym_null,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(29), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(615), 1,
      anon_sym_LBRACE,
    STATE(37), 1,
      sym_index_expression,
    STATE(75), 1,
      sym__expression,
    STATE(246), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(66), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17405] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(105), 1,
      sym__expression,
    STATE(247), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17474] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(248), 1,
      sym_comment,
    STATE(253), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17543] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(249), 1,
      sym_comment,
    STATE(300), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [17612] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(250), 1,
      sym_comment,
    ACTIONS(505), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(507), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17655] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(251), 1,
      sym_comment,
    ACTIONS(333), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(331), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17698] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(252), 1,
      sym_comment,
    ACTIONS(337), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(335), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17741] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(253), 1,
      sym_comment,
    ACTIONS(345), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(343), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17784] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(254), 1,
      sym_comment,
    ACTIONS(383), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(381), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17827] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(255), 1,
      sym_comment,
    ACTIONS(353), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(351), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [17870] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(256), 1,
      sym_comment,
    ACTIONS(303), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(305), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17913] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(257), 1,
      sym_comment,
    ACTIONS(259), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(261), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17956] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(479), 1,
      anon_sym_DQUOTE,
    ACTIONS(483), 1,
      aux_sym_raw_string_token1,
    ACTIONS(487), 1,
      sym_name,
    ACTIONS(489), 1,
      sym_null,
    ACTIONS(491), 1,
      aux_sym_number_token1,
    ACTIONS(493), 1,
      aux_sym_number_token4,
    ACTIONS(499), 1,
      anon_sym_DASH,
    ACTIONS(501), 1,
      anon_sym_LBRACE,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym_index_expression,
    STATE(141), 1,
      sym__expression,
    STATE(258), 1,
      sym_comment,
    ACTIONS(485), 2,
      sym_static_field,
      sym_field,
    ACTIONS(495), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(497), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(135), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18025] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(653), 1,
      anon_sym_for,
    STATE(259), 1,
      sym_comment,
    ACTIONS(649), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(651), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18070] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(260), 1,
      sym_comment,
    STATE(297), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18139] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(254), 1,
      sym__expression,
    STATE(261), 1,
      sym_comment,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18208] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(245), 1,
      sym__expression,
    STATE(262), 1,
      sym_comment,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18277] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(263), 1,
      sym_comment,
    ACTIONS(275), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(277), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18320] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(264), 1,
      sym_comment,
    STATE(306), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18389] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(265), 1,
      sym_comment,
    ACTIONS(357), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(355), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [18432] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(266), 1,
      sym_comment,
    ACTIONS(361), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(359), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [18475] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(267), 1,
      sym_comment,
    ACTIONS(655), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(657), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18518] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(268), 1,
      sym_comment,
    ACTIONS(323), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(325), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18561] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(225), 1,
      anon_sym_DQUOTE,
    ACTIONS(227), 1,
      aux_sym_raw_string_token1,
    ACTIONS(231), 1,
      sym_name,
    ACTIONS(233), 1,
      sym_null,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(243), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK,
    ACTIONS(473), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_index_expression,
    STATE(269), 1,
      sym_comment,
    STATE(310), 1,
      sym__expression,
    ACTIONS(229), 2,
      sym_static_field,
      sym_field,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(241), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(244), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18630] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(270), 1,
      sym_comment,
    ACTIONS(301), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(299), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [18673] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(185), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      aux_sym_raw_string_token1,
    ACTIONS(191), 1,
      sym_name,
    ACTIONS(193), 1,
      sym_null,
    ACTIONS(195), 1,
      aux_sym_number_token1,
    ACTIONS(197), 1,
      aux_sym_number_token4,
    ACTIONS(205), 1,
      anon_sym_DASH,
    ACTIONS(213), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_LBRACE,
    STATE(39), 1,
      sym_index_expression,
    STATE(107), 1,
      sym__expression,
    STATE(271), 1,
      sym_comment,
    ACTIONS(189), 2,
      sym_static_field,
      sym_field,
    ACTIONS(199), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(203), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(55), 12,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_subscript,
      sym_range,
      sym_map,
  [18742] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(272), 1,
      sym_comment,
    ACTIONS(659), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(661), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18785] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(273), 1,
      sym_comment,
    ACTIONS(379), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(377), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [18828] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(274), 1,
      sym_comment,
    ACTIONS(655), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(657), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18870] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(275), 1,
      sym_comment,
    ACTIONS(423), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(425), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18912] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(276), 1,
      sym_comment,
    ACTIONS(625), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(627), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18954] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(277), 1,
      sym_comment,
    ACTIONS(617), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(619), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18996] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(278), 1,
      sym_comment,
    ACTIONS(633), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(635), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19038] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(279), 1,
      sym_comment,
    ACTIONS(637), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(639), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19080] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(280), 1,
      sym_comment,
    ACTIONS(659), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(661), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19122] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(281), 1,
      sym_comment,
    ACTIONS(629), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(631), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19164] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(282), 1,
      sym_comment,
    ACTIONS(641), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(643), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19206] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(283), 1,
      sym_comment,
    ACTIONS(259), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(261), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19248] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(284), 1,
      sym_comment,
    ACTIONS(275), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(277), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19290] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(663), 1,
      anon_sym_for,
    STATE(285), 1,
      sym_comment,
    ACTIONS(649), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(651), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19334] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(286), 1,
      sym_comment,
    ACTIONS(303), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(305), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19376] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(287), 1,
      sym_comment,
    ACTIONS(645), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(647), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19418] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(288), 1,
      sym_comment,
    ACTIONS(621), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(623), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19460] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(665), 1,
      anon_sym_RPAREN,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(669), 1,
      anon_sym_PIPE,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(289), 1,
      sym_comment,
    STATE(381), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19518] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(681), 1,
      anon_sym_PIPE,
    STATE(290), 1,
      sym_comment,
    ACTIONS(679), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19572] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    STATE(291), 1,
      sym_comment,
    STATE(416), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19627] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(685), 1,
      anon_sym_RBRACK,
    STATE(292), 1,
      sym_comment,
    STATE(434), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19682] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(687), 1,
      anon_sym_RBRACK,
    STATE(293), 1,
      sym_comment,
    STATE(383), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19737] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(689), 1,
      anon_sym_RBRACK,
    STATE(294), 1,
      sym_comment,
    STATE(433), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19792] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(295), 1,
      sym_comment,
    ACTIONS(691), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19842] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(693), 1,
      anon_sym_COLON,
    STATE(296), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19891] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(695), 1,
      anon_sym_COLON,
    STATE(297), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19940] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(697), 1,
      anon_sym_COLON,
    STATE(298), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19989] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(699), 1,
      anon_sym_RPAREN,
    STATE(299), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20038] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(701), 1,
      anon_sym_RPAREN,
    STATE(300), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20087] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(703), 1,
      anon_sym_RPAREN,
    STATE(301), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20136] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(705), 1,
      anon_sym_RPAREN,
    STATE(302), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20185] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(707), 1,
      anon_sym_RPAREN,
    STATE(303), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20234] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(437), 1,
      anon_sym_COLON,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(304), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20283] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(709), 1,
      anon_sym_RBRACK,
    STATE(305), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20332] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(711), 1,
      anon_sym_RBRACK,
    STATE(306), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20381] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(713), 1,
      anon_sym_RBRACK,
    STATE(307), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20430] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(715), 1,
      anon_sym_COLON,
    STATE(308), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20479] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(717), 1,
      anon_sym_RPAREN,
    STATE(309), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20528] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(719), 1,
      anon_sym_RBRACK,
    STATE(310), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20577] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(427), 1,
      anon_sym_EQ,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(311), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20626] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(307), 1,
      anon_sym_EQ,
    ACTIONS(613), 1,
      anon_sym_LBRACK,
    ACTIONS(671), 1,
      anon_sym_QMARK,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(675), 1,
      anon_sym_DOT_DOT,
    ACTIONS(677), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(312), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(609), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20675] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      sym_name,
    ACTIONS(723), 1,
      anon_sym_RBRACE,
    ACTIONS(725), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(727), 1,
      anon_sym_LBRACK,
    ACTIONS(729), 1,
      anon_sym_construct,
    ACTIONS(731), 1,
      anon_sym_static,
    ACTIONS(733), 1,
      anon_sym_POUND,
    STATE(313), 1,
      sym_comment,
    STATE(317), 1,
      aux_sym_class_body_repeat2,
    STATE(318), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(338), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20727] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      sym_name,
    ACTIONS(725), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(727), 1,
      anon_sym_LBRACK,
    ACTIONS(729), 1,
      anon_sym_construct,
    ACTIONS(731), 1,
      anon_sym_static,
    ACTIONS(733), 1,
      anon_sym_POUND,
    ACTIONS(735), 1,
      anon_sym_RBRACE,
    STATE(314), 1,
      sym_comment,
    STATE(317), 1,
      aux_sym_class_body_repeat2,
    STATE(318), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(338), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20779] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      sym_name,
    ACTIONS(725), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(727), 1,
      anon_sym_LBRACK,
    ACTIONS(729), 1,
      anon_sym_construct,
    ACTIONS(731), 1,
      anon_sym_static,
    ACTIONS(733), 1,
      anon_sym_POUND,
    ACTIONS(737), 1,
      anon_sym_RBRACE,
    STATE(314), 1,
      aux_sym_class_body_repeat2,
    STATE(315), 1,
      sym_comment,
    STATE(318), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(338), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20831] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      sym_name,
    ACTIONS(725), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(727), 1,
      anon_sym_LBRACK,
    ACTIONS(729), 1,
      anon_sym_construct,
    ACTIONS(731), 1,
      anon_sym_static,
    ACTIONS(733), 1,
      anon_sym_POUND,
    ACTIONS(739), 1,
      anon_sym_RBRACE,
    STATE(313), 1,
      aux_sym_class_body_repeat2,
    STATE(316), 1,
      sym_comment,
    STATE(318), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(338), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20883] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(741), 1,
      sym_name,
    ACTIONS(744), 1,
      anon_sym_RBRACE,
    ACTIONS(746), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(749), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_construct,
    ACTIONS(755), 1,
      anon_sym_static,
    ACTIONS(758), 1,
      anon_sym_POUND,
    STATE(318), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(317), 2,
      sym_comment,
      aux_sym_class_body_repeat2,
    STATE(338), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20933] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      sym_name,
    ACTIONS(725), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(727), 1,
      anon_sym_LBRACK,
    ACTIONS(729), 1,
      anon_sym_construct,
    ACTIONS(731), 1,
      anon_sym_static,
    ACTIONS(733), 1,
      anon_sym_POUND,
    STATE(318), 1,
      sym_comment,
    STATE(323), 1,
      aux_sym_class_body_repeat1,
    STATE(344), 1,
      sym_attribute,
    STATE(342), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20979] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(19), 1,
      aux_sym_number_token1,
    ACTIONS(21), 1,
      aux_sym_number_token4,
    ACTIONS(761), 1,
      anon_sym_DQUOTE,
    ACTIONS(763), 1,
      sym_name,
    STATE(319), 1,
      sym_comment,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(355), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [21010] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(765), 1,
      anon_sym_DQUOTE,
    ACTIONS(767), 1,
      sym_name,
    ACTIONS(769), 1,
      aux_sym_number_token1,
    ACTIONS(771), 1,
      aux_sym_number_token4,
    STATE(320), 1,
      sym_comment,
    ACTIONS(773), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(348), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [21041] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(775), 1,
      anon_sym_DQUOTE,
    ACTIONS(777), 1,
      sym_name,
    ACTIONS(779), 1,
      aux_sym_number_token1,
    ACTIONS(781), 1,
      aux_sym_number_token4,
    STATE(321), 1,
      sym_comment,
    ACTIONS(783), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(469), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [21072] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(235), 1,
      aux_sym_number_token1,
    ACTIONS(237), 1,
      aux_sym_number_token4,
    ACTIONS(763), 1,
      sym_name,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    STATE(322), 1,
      sym_comment,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(355), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [21103] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(791), 1,
      anon_sym_POUND,
    STATE(344), 1,
      sym_attribute,
    ACTIONS(789), 2,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
    STATE(323), 2,
      sym_comment,
      aux_sym_class_body_repeat1,
    ACTIONS(787), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21129] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(796), 1,
      anon_sym_EQ,
    ACTIONS(798), 1,
      anon_sym_LPAREN,
    STATE(324), 1,
      sym_comment,
    ACTIONS(794), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(800), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21155] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(325), 1,
      sym_comment,
    ACTIONS(802), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(804), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21176] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(326), 1,
      sym_comment,
    ACTIONS(623), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(621), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21197] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(327), 1,
      sym_comment,
    ACTIONS(806), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(808), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21218] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(328), 1,
      sym_comment,
    ACTIONS(349), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(347), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21239] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(329), 1,
      sym_comment,
    ACTIONS(810), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(812), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21260] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(814), 1,
      anon_sym_class,
    STATE(330), 1,
      sym_comment,
    STATE(339), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21289] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(331), 1,
      sym_comment,
    ACTIONS(816), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(818), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21310] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(332), 1,
      sym_comment,
    ACTIONS(820), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(822), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21331] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(333), 1,
      sym_comment,
    ACTIONS(824), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(826), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21352] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(334), 1,
      sym_comment,
    ACTIONS(828), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(830), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21373] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(335), 1,
      sym_comment,
    ACTIONS(832), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(834), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21394] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(336), 1,
      sym_comment,
    ACTIONS(836), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(838), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21415] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(47), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_POUND_BANG,
    ACTIONS(840), 1,
      anon_sym_class,
    STATE(337), 1,
      sym_comment,
    STATE(339), 1,
      aux_sym_class_definition_repeat1,
    STATE(389), 1,
      sym__any_attribute,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21444] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(338), 1,
      sym_comment,
    ACTIONS(842), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(844), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21465] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(846), 1,
      anon_sym_class,
    ACTIONS(848), 1,
      anon_sym_POUND,
    ACTIONS(851), 1,
      anon_sym_POUND_BANG,
    STATE(389), 1,
      sym__any_attribute,
    STATE(339), 2,
      sym_comment,
      aux_sym_class_definition_repeat1,
    STATE(391), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21492] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(340), 1,
      sym_comment,
    ACTIONS(854), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(856), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21513] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(341), 1,
      sym_comment,
    ACTIONS(858), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(860), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21534] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(342), 1,
      sym_comment,
    ACTIONS(862), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(744), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21555] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(343), 1,
      sym_comment,
    ACTIONS(275), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(277), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21575] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(344), 1,
      sym_comment,
    ACTIONS(864), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(866), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21595] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(345), 1,
      sym_comment,
    ACTIONS(868), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(870), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21615] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(346), 1,
      sym_comment,
    ACTIONS(872), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(874), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21635] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(347), 1,
      sym_comment,
    ACTIONS(259), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(261), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21655] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(348), 1,
      sym_comment,
    ACTIONS(876), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(878), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21675] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(349), 1,
      sym_comment,
    ACTIONS(271), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(273), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21695] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(350), 1,
      sym_comment,
    ACTIONS(267), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(269), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21715] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(351), 1,
      sym_comment,
    ACTIONS(279), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(281), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21735] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(352), 1,
      sym_comment,
    ACTIONS(880), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(882), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21755] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(794), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_EQ,
    ACTIONS(886), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_comment,
    ACTIONS(800), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [21778] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(888), 1,
      anon_sym_COMMA,
    STATE(354), 2,
      sym_comment,
      aux_sym_argument_list_repeat1,
    ACTIONS(679), 3,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
  [21797] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(876), 1,
      anon_sym_POUND,
    STATE(355), 1,
      sym_comment,
    ACTIONS(878), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [21816] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      anon_sym_RPAREN,
    ACTIONS(893), 1,
      sym_name,
    STATE(356), 1,
      sym_comment,
    STATE(370), 1,
      aux_sym_runtime_attribute_repeat1,
    STATE(511), 1,
      sym_attribute_value,
  [21838] = 7,
    ACTIONS(895), 1,
      anon_sym_DQUOTE,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    STATE(357), 1,
      sym_comment,
    STATE(362), 1,
      aux_sym_string_repeat2,
  [21860] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(905), 1,
      anon_sym_DQUOTE,
    STATE(358), 1,
      sym_comment,
    STATE(365), 1,
      aux_sym_string_repeat2,
  [21882] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(907), 1,
      anon_sym_DQUOTE,
    STATE(358), 1,
      aux_sym_string_repeat2,
    STATE(359), 1,
      sym_comment,
  [21904] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(909), 1,
      anon_sym_DQUOTE,
    STATE(360), 1,
      sym_comment,
    STATE(365), 1,
      aux_sym_string_repeat2,
  [21926] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(913), 1,
      anon_sym_COMMA,
    ACTIONS(911), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(361), 2,
      sym_comment,
      aux_sym_parameter_list_repeat1,
  [21944] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_DQUOTE,
    STATE(362), 1,
      sym_comment,
    STATE(365), 1,
      aux_sym_string_repeat2,
  [21966] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(920), 1,
      anon_sym_COMMA,
    STATE(361), 1,
      aux_sym_parameter_list_repeat1,
    STATE(363), 1,
      sym_comment,
    ACTIONS(918), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [21986] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(794), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_EQ,
    STATE(364), 1,
      sym_comment,
    ACTIONS(800), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22006] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(922), 1,
      anon_sym_DQUOTE,
    ACTIONS(924), 1,
      aux_sym_string_token1,
    ACTIONS(927), 1,
      anon_sym_PERCENT_LPAREN,
    STATE(365), 2,
      sym_comment,
      aux_sym_string_repeat2,
  [22026] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(930), 1,
      anon_sym_DQUOTE,
    STATE(365), 1,
      aux_sym_string_repeat2,
    STATE(366), 1,
      sym_comment,
  [22048] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(932), 1,
      anon_sym_DQUOTE,
    STATE(366), 1,
      aux_sym_string_repeat2,
    STATE(367), 1,
      sym_comment,
  [22070] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(934), 1,
      anon_sym_DQUOTE,
    STATE(360), 1,
      aux_sym_string_repeat2,
    STATE(368), 1,
      sym_comment,
  [22092] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(936), 1,
      anon_sym_DQUOTE,
    STATE(369), 1,
      sym_comment,
    STATE(377), 1,
      aux_sym_string_repeat2,
  [22114] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(893), 1,
      sym_name,
    ACTIONS(938), 1,
      anon_sym_RPAREN,
    STATE(370), 1,
      sym_comment,
    STATE(378), 1,
      aux_sym_runtime_attribute_repeat1,
    STATE(511), 1,
      sym_attribute_value,
  [22136] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(940), 1,
      anon_sym_DQUOTE,
    STATE(371), 1,
      sym_comment,
    STATE(382), 1,
      aux_sym_string_repeat2,
  [22158] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(942), 1,
      anon_sym_DQUOTE,
    STATE(372), 1,
      sym_comment,
    STATE(379), 1,
      aux_sym_string_repeat2,
  [22180] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(920), 1,
      anon_sym_COMMA,
    STATE(363), 1,
      aux_sym_parameter_list_repeat1,
    STATE(373), 1,
      sym_comment,
    ACTIONS(944), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [22200] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(946), 1,
      anon_sym_EQ,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_LPAREN,
    STATE(331), 1,
      sym_block,
    STATE(374), 1,
      sym_comment,
  [22222] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(952), 1,
      anon_sym_DQUOTE,
    STATE(375), 1,
      sym_comment,
    STATE(380), 1,
      aux_sym_string_repeat2,
  [22244] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(954), 1,
      anon_sym_RPAREN,
    ACTIONS(956), 1,
      sym_name,
    STATE(373), 1,
      sym_parameter,
    STATE(376), 1,
      sym_comment,
    STATE(536), 1,
      sym_parameter_list,
  [22266] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(958), 1,
      anon_sym_DQUOTE,
    STATE(365), 1,
      aux_sym_string_repeat2,
    STATE(377), 1,
      sym_comment,
  [22288] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(960), 1,
      anon_sym_RPAREN,
    ACTIONS(962), 1,
      sym_name,
    STATE(511), 1,
      sym_attribute_value,
    STATE(378), 2,
      sym_comment,
      aux_sym_runtime_attribute_repeat1,
  [22308] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(965), 1,
      anon_sym_DQUOTE,
    STATE(365), 1,
      aux_sym_string_repeat2,
    STATE(379), 1,
      sym_comment,
  [22330] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(967), 1,
      anon_sym_DQUOTE,
    STATE(365), 1,
      aux_sym_string_repeat2,
    STATE(380), 1,
      sym_comment,
  [22352] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    STATE(354), 1,
      aux_sym_argument_list_repeat1,
    STATE(381), 1,
      sym_comment,
    ACTIONS(969), 2,
      anon_sym_RPAREN,
      anon_sym_PIPE,
  [22372] = 7,
    ACTIONS(897), 1,
      aux_sym_string_token1,
    ACTIONS(899), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      anon_sym_DQUOTE,
    STATE(365), 1,
      aux_sym_string_repeat2,
    STATE(382), 1,
      sym_comment,
  [22394] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(973), 1,
      anon_sym_RBRACK,
    STATE(354), 1,
      aux_sym_argument_list_repeat1,
    STATE(383), 1,
      sym_comment,
  [22413] = 5,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(975), 1,
      aux_sym_string_token1,
    STATE(384), 1,
      sym_comment,
    ACTIONS(922), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [22430] = 6,
    ACTIONS(977), 1,
      aux_sym_raw_string_token2,
    ACTIONS(979), 1,
      aux_sym_comment_token1,
    ACTIONS(981), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(983), 1,
      anon_sym_STAR_SLASH,
    STATE(385), 1,
      sym_comment,
    STATE(393), 1,
      aux_sym_comment_repeat1,
  [22449] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(985), 1,
      anon_sym_EQ,
    STATE(386), 1,
      sym_comment,
    ACTIONS(800), 2,
      anon_sym_RPAREN,
      sym_name,
  [22466] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(987), 1,
      aux_sym_raw_string_token1,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    STATE(387), 1,
      sym_comment,
    STATE(401), 1,
      aux_sym_raw_string_repeat1,
  [22485] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(991), 1,
      sym_name,
    ACTIONS(993), 1,
      anon_sym_LPAREN,
    STATE(388), 1,
      sym_comment,
    STATE(415), 1,
      sym_attribute_value,
  [22504] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(997), 1,
      anon_sym_POUND,
    STATE(389), 1,
      sym_comment,
    ACTIONS(995), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22521] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(999), 1,
      sym_name,
    STATE(223), 1,
      sym__import_entry,
    STATE(250), 1,
      sym_rename,
    STATE(390), 1,
      sym_comment,
  [22540] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1003), 1,
      anon_sym_POUND,
    STATE(391), 1,
      sym_comment,
    ACTIONS(1001), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22557] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1007), 1,
      anon_sym_POUND,
    STATE(392), 1,
      sym_comment,
    ACTIONS(1005), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22574] = 6,
    ACTIONS(979), 1,
      aux_sym_comment_token1,
    ACTIONS(981), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1009), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1011), 1,
      anon_sym_STAR_SLASH,
    STATE(393), 1,
      sym_comment,
    STATE(421), 1,
      aux_sym_comment_repeat1,
  [22593] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1013), 1,
      anon_sym_RPAREN,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    STATE(394), 1,
      sym_comment,
    STATE(408), 1,
      aux_sym_attribute_repeat1,
  [22612] = 5,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1019), 1,
      aux_sym_string_token1,
    STATE(395), 1,
      sym_comment,
    ACTIONS(1017), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [22629] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(872), 1,
      anon_sym_POUND,
    STATE(396), 1,
      sym_comment,
    ACTIONS(874), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22646] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_LPAREN,
    STATE(331), 1,
      sym_block,
    STATE(397), 1,
      sym_comment,
  [22665] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(398), 1,
      sym_comment,
    ACTIONS(911), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [22680] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(525), 1,
      anon_sym_RBRACE,
    ACTIONS(1021), 1,
      anon_sym_COMMA,
    STATE(399), 1,
      sym_comment,
    STATE(414), 1,
      aux_sym_map_repeat1,
  [22699] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(400), 1,
      sym_comment,
    ACTIONS(1023), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [22714] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1025), 1,
      aux_sym_raw_string_token1,
    STATE(401), 1,
      sym_comment,
    STATE(429), 1,
      aux_sym_raw_string_repeat1,
  [22733] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1027), 1,
      anon_sym_RBRACE,
    ACTIONS(1029), 1,
      anon_sym_COMMA,
    STATE(399), 1,
      aux_sym_map_repeat1,
    STATE(402), 1,
      sym_comment,
  [22752] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1031), 1,
      anon_sym_RBRACE,
    ACTIONS(1033), 1,
      anon_sym_COMMA,
    STATE(403), 1,
      sym_comment,
    STATE(430), 1,
      aux_sym_map_repeat1,
  [22771] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1035), 1,
      anon_sym_is,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    STATE(280), 1,
      sym_class_body,
    STATE(404), 1,
      sym_comment,
  [22790] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1039), 1,
      aux_sym_raw_string_token1,
    STATE(405), 1,
      sym_comment,
    STATE(429), 1,
      aux_sym_raw_string_repeat1,
  [22809] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1041), 1,
      aux_sym_raw_string_token1,
    STATE(405), 1,
      aux_sym_raw_string_repeat1,
    STATE(406), 1,
      sym_comment,
  [22828] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(880), 1,
      anon_sym_POUND,
    STATE(407), 1,
      sym_comment,
    ACTIONS(882), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22845] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1043), 1,
      anon_sym_RPAREN,
    ACTIONS(1045), 1,
      anon_sym_COMMA,
    STATE(408), 2,
      sym_comment,
      aux_sym_attribute_repeat1,
  [22862] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1048), 1,
      anon_sym_RPAREN,
    ACTIONS(1050), 1,
      sym_name,
    STATE(356), 1,
      sym_attribute_value,
    STATE(409), 1,
      sym_comment,
  [22881] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1054), 1,
      anon_sym_POUND,
    STATE(410), 1,
      sym_comment,
    ACTIONS(1052), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22898] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1056), 1,
      anon_sym_RPAREN,
    STATE(394), 1,
      aux_sym_attribute_repeat1,
    STATE(411), 1,
      sym_comment,
  [22917] = 6,
    ACTIONS(979), 1,
      aux_sym_comment_token1,
    ACTIONS(981), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1058), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1060), 1,
      anon_sym_STAR_SLASH,
    STATE(412), 1,
      sym_comment,
    STATE(417), 1,
      aux_sym_comment_repeat1,
  [22936] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1062), 1,
      aux_sym_raw_string_token1,
    STATE(413), 1,
      sym_comment,
    STATE(418), 1,
      aux_sym_raw_string_repeat1,
  [22955] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1064), 1,
      anon_sym_RBRACE,
    ACTIONS(1066), 1,
      anon_sym_COMMA,
    STATE(414), 2,
      sym_comment,
      aux_sym_map_repeat1,
  [22972] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1071), 1,
      anon_sym_POUND,
    STATE(415), 1,
      sym_comment,
    ACTIONS(1069), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22989] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(1073), 1,
      anon_sym_RBRACK,
    STATE(354), 1,
      aux_sym_argument_list_repeat1,
    STATE(416), 1,
      sym_comment,
  [23008] = 6,
    ACTIONS(979), 1,
      aux_sym_comment_token1,
    ACTIONS(981), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1009), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1075), 1,
      anon_sym_STAR_SLASH,
    STATE(417), 1,
      sym_comment,
    STATE(421), 1,
      aux_sym_comment_repeat1,
  [23027] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1077), 1,
      aux_sym_raw_string_token1,
    STATE(418), 1,
      sym_comment,
    STATE(429), 1,
      aux_sym_raw_string_repeat1,
  [23046] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1079), 1,
      sym_name,
    STATE(340), 1,
      sym_getter_definition,
    STATE(341), 1,
      sym_method_definition,
    STATE(419), 1,
      sym_comment,
  [23065] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
    ACTIONS(1081), 1,
      anon_sym_COMMA,
    STATE(414), 1,
      aux_sym_map_repeat1,
    STATE(420), 1,
      sym_comment,
  [23084] = 5,
    ACTIONS(1083), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1086), 1,
      aux_sym_comment_token1,
    ACTIONS(1089), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1092), 1,
      anon_sym_STAR_SLASH,
    STATE(421), 2,
      sym_comment,
      aux_sym_comment_repeat1,
  [23101] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1094), 1,
      anon_sym_RBRACE,
    ACTIONS(1096), 1,
      anon_sym_COMMA,
    STATE(422), 1,
      sym_comment,
    STATE(431), 1,
      aux_sym_map_repeat1,
  [23120] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      sym_name,
    STATE(373), 1,
      sym_parameter,
    STATE(423), 1,
      sym_comment,
    STATE(480), 1,
      sym_parameter_list,
  [23139] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(868), 1,
      anon_sym_POUND,
    STATE(424), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [23156] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1098), 1,
      anon_sym_is,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    STATE(272), 1,
      sym_class_body,
    STATE(425), 1,
      sym_comment,
  [23175] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(1102), 1,
      anon_sym_LPAREN,
    STATE(327), 1,
      sym_block,
    STATE(426), 1,
      sym_comment,
  [23194] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1104), 1,
      anon_sym_EQ,
    STATE(427), 1,
      sym_comment,
    ACTIONS(800), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23211] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1106), 1,
      anon_sym_RBRACE,
    ACTIONS(1108), 1,
      anon_sym_COMMA,
    STATE(420), 1,
      aux_sym_map_repeat1,
    STATE(428), 1,
      sym_comment,
  [23230] = 5,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1110), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1112), 1,
      aux_sym_raw_string_token2,
    STATE(429), 2,
      sym_comment,
      aux_sym_raw_string_repeat1,
  [23247] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(548), 1,
      anon_sym_RBRACE,
    ACTIONS(1115), 1,
      anon_sym_COMMA,
    STATE(414), 1,
      aux_sym_map_repeat1,
    STATE(430), 1,
      sym_comment,
  [23266] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(536), 1,
      anon_sym_RBRACE,
    ACTIONS(1117), 1,
      anon_sym_COMMA,
    STATE(414), 1,
      aux_sym_map_repeat1,
    STATE(431), 1,
      sym_comment,
  [23285] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1119), 1,
      aux_sym_raw_string_token1,
    STATE(429), 1,
      aux_sym_raw_string_repeat1,
    STATE(432), 1,
      sym_comment,
  [23304] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(1121), 1,
      anon_sym_RBRACK,
    STATE(354), 1,
      aux_sym_argument_list_repeat1,
    STATE(433), 1,
      sym_comment,
  [23323] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(667), 1,
      anon_sym_COMMA,
    ACTIONS(1123), 1,
      anon_sym_RBRACK,
    STATE(354), 1,
      aux_sym_argument_list_repeat1,
    STATE(434), 1,
      sym_comment,
  [23342] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1125), 1,
      sym_name,
    STATE(153), 1,
      sym__import_entry,
    STATE(187), 1,
      sym_rename,
    STATE(435), 1,
      sym_comment,
  [23361] = 6,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1127), 1,
      aux_sym_raw_string_token1,
    STATE(432), 1,
      aux_sym_raw_string_repeat1,
    STATE(436), 1,
      sym_comment,
  [23380] = 5,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1131), 1,
      aux_sym_string_token1,
    STATE(437), 1,
      sym_comment,
    ACTIONS(1129), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [23397] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    ACTIONS(1133), 1,
      anon_sym_is,
    STATE(208), 1,
      sym_class_body,
    STATE(438), 1,
      sym_comment,
  [23416] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    ACTIONS(1135), 1,
      anon_sym_is,
    STATE(276), 1,
      sym_class_body,
    STATE(439), 1,
      sym_comment,
  [23435] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    STATE(333), 1,
      sym_block,
    STATE(440), 1,
      sym_comment,
  [23454] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(999), 1,
      sym_name,
    STATE(190), 1,
      sym__import_entry,
    STATE(250), 1,
      sym_rename,
    STATE(441), 1,
      sym_comment,
  [23473] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1125), 1,
      sym_name,
    STATE(183), 1,
      sym__import_entry,
    STATE(187), 1,
      sym_rename,
    STATE(442), 1,
      sym_comment,
  [23492] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1139), 1,
      anon_sym_RPAREN,
    STATE(443), 1,
      sym_comment,
    STATE(445), 1,
      aux_sym_attribute_repeat1,
  [23511] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1143), 1,
      anon_sym_POUND,
    STATE(444), 1,
      sym_comment,
    ACTIONS(1141), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [23528] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    ACTIONS(1145), 1,
      anon_sym_RPAREN,
    STATE(408), 1,
      aux_sym_attribute_repeat1,
    STATE(445), 1,
      sym_comment,
  [23547] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(446), 1,
      sym_comment,
    ACTIONS(279), 2,
      anon_sym_RPAREN,
      sym_name,
  [23561] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    STATE(332), 1,
      sym_block,
    STATE(447), 1,
      sym_comment,
  [23577] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    STATE(236), 1,
      sym_class_body,
    STATE(448), 1,
      sym_comment,
  [23593] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1147), 1,
      sym_name,
    STATE(407), 1,
      sym_attribute_value,
    STATE(449), 1,
      sym_comment,
  [23609] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1100), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym_class_body,
    STATE(450), 1,
      sym_comment,
  [23625] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(893), 1,
      sym_name,
    STATE(443), 1,
      sym_attribute_value,
    STATE(451), 1,
      sym_comment,
  [23641] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(452), 1,
      sym_comment,
    ACTIONS(1064), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [23655] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      sym_name,
    STATE(453), 1,
      sym_comment,
    STATE(482), 1,
      sym_parameter,
  [23671] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(454), 1,
      sym_comment,
    ACTIONS(1043), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23685] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1149), 1,
      anon_sym_DQUOTE,
    STATE(285), 1,
      sym_string,
    STATE(455), 1,
      sym_comment,
  [23701] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    STATE(277), 1,
      sym_class_body,
    STATE(456), 1,
      sym_comment,
  [23717] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    STATE(282), 1,
      sym_class_body,
    STATE(457), 1,
      sym_comment,
  [23733] = 2,
    STATE(458), 1,
      sym_comment,
    ACTIONS(1151), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23743] = 2,
    STATE(459), 1,
      sym_comment,
    ACTIONS(1153), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23753] = 2,
    STATE(460), 1,
      sym_comment,
    ACTIONS(1155), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23763] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    STATE(336), 1,
      sym_block,
    STATE(461), 1,
      sym_comment,
  [23779] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      sym_name,
    STATE(398), 1,
      sym_parameter,
    STATE(462), 1,
      sym_comment,
  [23795] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      sym_name,
    STATE(463), 1,
      sym_comment,
    STATE(502), 1,
      sym_parameter,
  [23811] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1157), 1,
      sym_name,
    STATE(329), 1,
      sym_method_definition,
    STATE(464), 1,
      sym_comment,
  [23827] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    STATE(325), 1,
      sym_block,
    STATE(465), 1,
      sym_comment,
  [23843] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(466), 1,
      sym_comment,
    ACTIONS(960), 2,
      anon_sym_RPAREN,
      sym_name,
  [23857] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(893), 1,
      sym_name,
    STATE(454), 1,
      sym_attribute_value,
    STATE(467), 1,
      sym_comment,
  [23873] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1159), 1,
      anon_sym_DQUOTE,
    STATE(259), 1,
      sym_string,
    STATE(468), 1,
      sym_comment,
  [23889] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(469), 1,
      sym_comment,
    ACTIONS(878), 2,
      anon_sym_RPAREN,
      sym_name,
  [23903] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(893), 1,
      sym_name,
    STATE(411), 1,
      sym_attribute_value,
    STATE(470), 1,
      sym_comment,
  [23919] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1161), 1,
      sym_name,
    STATE(352), 1,
      sym_attribute_value,
    STATE(471), 1,
      sym_comment,
  [23935] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(472), 1,
      sym_comment,
    ACTIONS(267), 2,
      anon_sym_RPAREN,
      sym_name,
  [23949] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(473), 1,
      sym_comment,
    ACTIONS(275), 2,
      anon_sym_RPAREN,
      sym_name,
  [23963] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(474), 1,
      sym_comment,
    ACTIONS(259), 2,
      anon_sym_RPAREN,
      sym_name,
  [23977] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    STATE(475), 1,
      sym_comment,
    ACTIONS(1163), 2,
      aux_sym_raw_string_token1,
      aux_sym_raw_string_token2,
  [23991] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(476), 1,
      sym_comment,
    ACTIONS(271), 2,
      anon_sym_RPAREN,
      sym_name,
  [24005] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    STATE(334), 1,
      sym_block,
    STATE(477), 1,
      sym_comment,
  [24021] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(956), 1,
      sym_name,
    STATE(478), 1,
      sym_comment,
    STATE(537), 1,
      sym_parameter,
  [24037] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    STATE(335), 1,
      sym_block,
    STATE(479), 1,
      sym_comment,
  [24053] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1165), 1,
      anon_sym_RBRACK,
    STATE(480), 1,
      sym_comment,
  [24066] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1167), 1,
      aux_sym_number_token3,
    STATE(481), 1,
      sym_comment,
  [24079] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1169), 1,
      anon_sym_RPAREN,
    STATE(482), 1,
      sym_comment,
  [24092] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1171), 1,
      sym_name,
    STATE(483), 1,
      sym_comment,
  [24105] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1173), 1,
      sym_name,
    STATE(484), 1,
      sym_comment,
  [24118] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1175), 1,
      anon_sym_EQ,
    STATE(485), 1,
      sym_comment,
  [24131] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1177), 1,
      aux_sym_number_token3,
    STATE(486), 1,
      sym_comment,
  [24144] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1179), 1,
      anon_sym_LPAREN,
    STATE(487), 1,
      sym_comment,
  [24157] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1181), 1,
      aux_sym_number_token3,
    STATE(488), 1,
      sym_comment,
  [24170] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1183), 1,
      sym_name,
    STATE(489), 1,
      sym_comment,
  [24183] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1185), 1,
      anon_sym_RPAREN,
    STATE(490), 1,
      sym_comment,
  [24196] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1187), 1,
      sym_name,
    STATE(491), 1,
      sym_comment,
  [24209] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1189), 1,
      sym_name,
    STATE(492), 1,
      sym_comment,
  [24222] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(950), 1,
      anon_sym_LPAREN,
    STATE(493), 1,
      sym_comment,
  [24235] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1191), 1,
      sym_name,
    STATE(494), 1,
      sym_comment,
  [24248] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1193), 1,
      aux_sym_number_token3,
    STATE(495), 1,
      sym_comment,
  [24261] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1195), 1,
      anon_sym_LPAREN,
    STATE(496), 1,
      sym_comment,
  [24274] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1197), 1,
      sym_name,
    STATE(497), 1,
      sym_comment,
  [24287] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1199), 1,
      anon_sym_LPAREN,
    STATE(498), 1,
      sym_comment,
  [24300] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1201), 1,
      sym_name,
    STATE(499), 1,
      sym_comment,
  [24313] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1203), 1,
      aux_sym_number_token3,
    STATE(500), 1,
      sym_comment,
  [24326] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1205), 1,
      anon_sym_RPAREN,
    STATE(501), 1,
      sym_comment,
  [24339] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1207), 1,
      anon_sym_RPAREN,
    STATE(502), 1,
      sym_comment,
  [24352] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1209), 1,
      aux_sym_number_token3,
    STATE(503), 1,
      sym_comment,
  [24365] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1211), 1,
      sym_name,
    STATE(504), 1,
      sym_comment,
  [24378] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1213), 1,
      anon_sym_EQ,
    STATE(505), 1,
      sym_comment,
  [24391] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1215), 1,
      sym_name,
    STATE(506), 1,
      sym_comment,
  [24404] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1217), 1,
      anon_sym_RPAREN,
    STATE(507), 1,
      sym_comment,
  [24417] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1219), 1,
      aux_sym_number_token2,
    STATE(508), 1,
      sym_comment,
  [24430] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1221), 1,
      sym_name,
    STATE(509), 1,
      sym_comment,
  [24443] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1223), 1,
      sym_name,
    STATE(510), 1,
      sym_comment,
  [24456] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1225), 1,
      anon_sym_COMMA,
    STATE(511), 1,
      sym_comment,
  [24469] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1227), 1,
      ts_builtin_sym_end,
    STATE(512), 1,
      sym_comment,
  [24482] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1229), 1,
      anon_sym_RPAREN,
    STATE(513), 1,
      sym_comment,
  [24495] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1231), 1,
      sym_name,
    STATE(514), 1,
      sym_comment,
  [24508] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1233), 1,
      sym_name,
    STATE(515), 1,
      sym_comment,
  [24521] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1235), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      sym_comment,
  [24534] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1237), 1,
      sym_name,
    STATE(517), 1,
      sym_comment,
  [24547] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1239), 1,
      anon_sym_PIPE,
    STATE(518), 1,
      sym_comment,
  [24560] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1241), 1,
      anon_sym_PIPE,
    STATE(519), 1,
      sym_comment,
  [24573] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1243), 1,
      sym_name,
    STATE(520), 1,
      sym_comment,
  [24586] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1245), 1,
      aux_sym_number_token2,
    STATE(521), 1,
      sym_comment,
  [24599] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1247), 1,
      anon_sym_LPAREN,
    STATE(522), 1,
      sym_comment,
  [24612] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1249), 1,
      anon_sym_LPAREN,
    STATE(523), 1,
      sym_comment,
  [24625] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1251), 1,
      anon_sym_PIPE,
    STATE(524), 1,
      sym_comment,
  [24638] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1253), 1,
      aux_sym_number_token2,
    STATE(525), 1,
      sym_comment,
  [24651] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1255), 1,
      anon_sym_LPAREN,
    STATE(526), 1,
      sym_comment,
  [24664] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1257), 1,
      sym_name,
    STATE(527), 1,
      sym_comment,
  [24677] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1259), 1,
      anon_sym_PIPE,
    STATE(528), 1,
      sym_comment,
  [24690] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1261), 1,
      aux_sym_number_token2,
    STATE(529), 1,
      sym_comment,
  [24703] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1263), 1,
      aux_sym_number_token2,
    STATE(530), 1,
      sym_comment,
  [24716] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1265), 1,
      anon_sym_LPAREN,
    STATE(531), 1,
      sym_comment,
  [24729] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1267), 1,
      sym_name,
    STATE(532), 1,
      sym_comment,
  [24742] = 4,
    ACTIONS(901), 1,
      aux_sym_comment_token1,
    ACTIONS(903), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1269), 1,
      aux_sym_number_token2,
    STATE(533), 1,
      sym_comment,
  [24755] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1271), 1,
      anon_sym_in,
    STATE(534), 1,
      sym_comment,
  [24768] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1273), 1,
      anon_sym_in,
    STATE(535), 1,
      sym_comment,
  [24781] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1275), 1,
      anon_sym_RPAREN,
    STATE(536), 1,
      sym_comment,
  [24794] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1277), 1,
      anon_sym_RPAREN,
    STATE(537), 1,
      sym_comment,
  [24807] = 1,
    ACTIONS(1279), 1,
      ts_builtin_sym_end,
  [24811] = 1,
    ACTIONS(1281), 1,
      ts_builtin_sym_end,
  [24815] = 1,
    ACTIONS(1283), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 133,
  [SMALL_STATE(4)] = 266,
  [SMALL_STATE(5)] = 399,
  [SMALL_STATE(6)] = 532,
  [SMALL_STATE(7)] = 665,
  [SMALL_STATE(8)] = 794,
  [SMALL_STATE(9)] = 927,
  [SMALL_STATE(10)] = 1060,
  [SMALL_STATE(11)] = 1193,
  [SMALL_STATE(12)] = 1323,
  [SMALL_STATE(13)] = 1453,
  [SMALL_STATE(14)] = 1583,
  [SMALL_STATE(15)] = 1713,
  [SMALL_STATE(16)] = 1843,
  [SMALL_STATE(17)] = 1973,
  [SMALL_STATE(18)] = 2103,
  [SMALL_STATE(19)] = 2233,
  [SMALL_STATE(20)] = 2363,
  [SMALL_STATE(21)] = 2493,
  [SMALL_STATE(22)] = 2623,
  [SMALL_STATE(23)] = 2753,
  [SMALL_STATE(24)] = 2883,
  [SMALL_STATE(25)] = 3013,
  [SMALL_STATE(26)] = 3143,
  [SMALL_STATE(27)] = 3273,
  [SMALL_STATE(28)] = 3403,
  [SMALL_STATE(29)] = 3533,
  [SMALL_STATE(30)] = 3663,
  [SMALL_STATE(31)] = 3787,
  [SMALL_STATE(32)] = 3911,
  [SMALL_STATE(33)] = 4035,
  [SMALL_STATE(34)] = 4159,
  [SMALL_STATE(35)] = 4283,
  [SMALL_STATE(36)] = 4407,
  [SMALL_STATE(37)] = 4531,
  [SMALL_STATE(38)] = 4603,
  [SMALL_STATE(39)] = 4669,
  [SMALL_STATE(40)] = 4741,
  [SMALL_STATE(41)] = 4807,
  [SMALL_STATE(42)] = 4873,
  [SMALL_STATE(43)] = 4939,
  [SMALL_STATE(44)] = 5005,
  [SMALL_STATE(45)] = 5074,
  [SMALL_STATE(46)] = 5143,
  [SMALL_STATE(47)] = 5212,
  [SMALL_STATE(48)] = 5277,
  [SMALL_STATE(49)] = 5342,
  [SMALL_STATE(50)] = 5411,
  [SMALL_STATE(51)] = 5475,
  [SMALL_STATE(52)] = 5539,
  [SMALL_STATE(53)] = 5619,
  [SMALL_STATE(54)] = 5699,
  [SMALL_STATE(55)] = 5763,
  [SMALL_STATE(56)] = 5827,
  [SMALL_STATE(57)] = 5891,
  [SMALL_STATE(58)] = 5955,
  [SMALL_STATE(59)] = 6019,
  [SMALL_STATE(60)] = 6083,
  [SMALL_STATE(61)] = 6147,
  [SMALL_STATE(62)] = 6211,
  [SMALL_STATE(63)] = 6275,
  [SMALL_STATE(64)] = 6339,
  [SMALL_STATE(65)] = 6407,
  [SMALL_STATE(66)] = 6471,
  [SMALL_STATE(67)] = 6535,
  [SMALL_STATE(68)] = 6599,
  [SMALL_STATE(69)] = 6663,
  [SMALL_STATE(70)] = 6727,
  [SMALL_STATE(71)] = 6791,
  [SMALL_STATE(72)] = 6855,
  [SMALL_STATE(73)] = 6919,
  [SMALL_STATE(74)] = 6983,
  [SMALL_STATE(75)] = 7047,
  [SMALL_STATE(76)] = 7117,
  [SMALL_STATE(77)] = 7181,
  [SMALL_STATE(78)] = 7245,
  [SMALL_STATE(79)] = 7315,
  [SMALL_STATE(80)] = 7379,
  [SMALL_STATE(81)] = 7443,
  [SMALL_STATE(82)] = 7525,
  [SMALL_STATE(83)] = 7589,
  [SMALL_STATE(84)] = 7653,
  [SMALL_STATE(85)] = 7717,
  [SMALL_STATE(86)] = 7781,
  [SMALL_STATE(87)] = 7851,
  [SMALL_STATE(88)] = 7915,
  [SMALL_STATE(89)] = 7979,
  [SMALL_STATE(90)] = 8043,
  [SMALL_STATE(91)] = 8107,
  [SMALL_STATE(92)] = 8171,
  [SMALL_STATE(93)] = 8235,
  [SMALL_STATE(94)] = 8299,
  [SMALL_STATE(95)] = 8363,
  [SMALL_STATE(96)] = 8427,
  [SMALL_STATE(97)] = 8491,
  [SMALL_STATE(98)] = 8555,
  [SMALL_STATE(99)] = 8619,
  [SMALL_STATE(100)] = 8683,
  [SMALL_STATE(101)] = 8747,
  [SMALL_STATE(102)] = 8811,
  [SMALL_STATE(103)] = 8881,
  [SMALL_STATE(104)] = 8945,
  [SMALL_STATE(105)] = 9009,
  [SMALL_STATE(106)] = 9086,
  [SMALL_STATE(107)] = 9163,
  [SMALL_STATE(108)] = 9240,
  [SMALL_STATE(109)] = 9319,
  [SMALL_STATE(110)] = 9398,
  [SMALL_STATE(111)] = 9465,
  [SMALL_STATE(112)] = 9546,
  [SMALL_STATE(113)] = 9622,
  [SMALL_STATE(114)] = 9698,
  [SMALL_STATE(115)] = 9774,
  [SMALL_STATE(116)] = 9832,
  [SMALL_STATE(117)] = 9887,
  [SMALL_STATE(118)] = 9942,
  [SMALL_STATE(119)] = 9993,
  [SMALL_STATE(120)] = 10043,
  [SMALL_STATE(121)] = 10093,
  [SMALL_STATE(122)] = 10143,
  [SMALL_STATE(123)] = 10193,
  [SMALL_STATE(124)] = 10243,
  [SMALL_STATE(125)] = 10293,
  [SMALL_STATE(126)] = 10343,
  [SMALL_STATE(127)] = 10393,
  [SMALL_STATE(128)] = 10443,
  [SMALL_STATE(129)] = 10493,
  [SMALL_STATE(130)] = 10543,
  [SMALL_STATE(131)] = 10593,
  [SMALL_STATE(132)] = 10643,
  [SMALL_STATE(133)] = 10693,
  [SMALL_STATE(134)] = 10743,
  [SMALL_STATE(135)] = 10793,
  [SMALL_STATE(136)] = 10843,
  [SMALL_STATE(137)] = 10893,
  [SMALL_STATE(138)] = 10943,
  [SMALL_STATE(139)] = 11007,
  [SMALL_STATE(140)] = 11057,
  [SMALL_STATE(141)] = 11107,
  [SMALL_STATE(142)] = 11163,
  [SMALL_STATE(143)] = 11213,
  [SMALL_STATE(144)] = 11269,
  [SMALL_STATE(145)] = 11319,
  [SMALL_STATE(146)] = 11369,
  [SMALL_STATE(147)] = 11419,
  [SMALL_STATE(148)] = 11465,
  [SMALL_STATE(149)] = 11511,
  [SMALL_STATE(150)] = 11557,
  [SMALL_STATE(151)] = 11603,
  [SMALL_STATE(152)] = 11655,
  [SMALL_STATE(153)] = 11701,
  [SMALL_STATE(154)] = 11750,
  [SMALL_STATE(155)] = 11825,
  [SMALL_STATE(156)] = 11874,
  [SMALL_STATE(157)] = 11949,
  [SMALL_STATE(158)] = 11994,
  [SMALL_STATE(159)] = 12069,
  [SMALL_STATE(160)] = 12118,
  [SMALL_STATE(161)] = 12193,
  [SMALL_STATE(162)] = 12240,
  [SMALL_STATE(163)] = 12315,
  [SMALL_STATE(164)] = 12364,
  [SMALL_STATE(165)] = 12439,
  [SMALL_STATE(166)] = 12514,
  [SMALL_STATE(167)] = 12589,
  [SMALL_STATE(168)] = 12664,
  [SMALL_STATE(169)] = 12739,
  [SMALL_STATE(170)] = 12814,
  [SMALL_STATE(171)] = 12861,
  [SMALL_STATE(172)] = 12936,
  [SMALL_STATE(173)] = 13011,
  [SMALL_STATE(174)] = 13086,
  [SMALL_STATE(175)] = 13161,
  [SMALL_STATE(176)] = 13236,
  [SMALL_STATE(177)] = 13311,
  [SMALL_STATE(178)] = 13386,
  [SMALL_STATE(179)] = 13459,
  [SMALL_STATE(180)] = 13531,
  [SMALL_STATE(181)] = 13577,
  [SMALL_STATE(182)] = 13649,
  [SMALL_STATE(183)] = 13721,
  [SMALL_STATE(184)] = 13765,
  [SMALL_STATE(185)] = 13809,
  [SMALL_STATE(186)] = 13881,
  [SMALL_STATE(187)] = 13953,
  [SMALL_STATE(188)] = 13997,
  [SMALL_STATE(189)] = 14069,
  [SMALL_STATE(190)] = 14141,
  [SMALL_STATE(191)] = 14189,
  [SMALL_STATE(192)] = 14235,
  [SMALL_STATE(193)] = 14307,
  [SMALL_STATE(194)] = 14379,
  [SMALL_STATE(195)] = 14427,
  [SMALL_STATE(196)] = 14496,
  [SMALL_STATE(197)] = 14545,
  [SMALL_STATE(198)] = 14614,
  [SMALL_STATE(199)] = 14683,
  [SMALL_STATE(200)] = 14752,
  [SMALL_STATE(201)] = 14795,
  [SMALL_STATE(202)] = 14838,
  [SMALL_STATE(203)] = 14881,
  [SMALL_STATE(204)] = 14926,
  [SMALL_STATE(205)] = 14995,
  [SMALL_STATE(206)] = 15064,
  [SMALL_STATE(207)] = 15107,
  [SMALL_STATE(208)] = 15176,
  [SMALL_STATE(209)] = 15219,
  [SMALL_STATE(210)] = 15288,
  [SMALL_STATE(211)] = 15357,
  [SMALL_STATE(212)] = 15426,
  [SMALL_STATE(213)] = 15495,
  [SMALL_STATE(214)] = 15564,
  [SMALL_STATE(215)] = 15633,
  [SMALL_STATE(216)] = 15702,
  [SMALL_STATE(217)] = 15771,
  [SMALL_STATE(218)] = 15814,
  [SMALL_STATE(219)] = 15883,
  [SMALL_STATE(220)] = 15952,
  [SMALL_STATE(221)] = 16021,
  [SMALL_STATE(222)] = 16090,
  [SMALL_STATE(223)] = 16133,
  [SMALL_STATE(224)] = 16176,
  [SMALL_STATE(225)] = 16219,
  [SMALL_STATE(226)] = 16288,
  [SMALL_STATE(227)] = 16331,
  [SMALL_STATE(228)] = 16374,
  [SMALL_STATE(229)] = 16443,
  [SMALL_STATE(230)] = 16512,
  [SMALL_STATE(231)] = 16555,
  [SMALL_STATE(232)] = 16598,
  [SMALL_STATE(233)] = 16641,
  [SMALL_STATE(234)] = 16684,
  [SMALL_STATE(235)] = 16727,
  [SMALL_STATE(236)] = 16796,
  [SMALL_STATE(237)] = 16839,
  [SMALL_STATE(238)] = 16908,
  [SMALL_STATE(239)] = 16951,
  [SMALL_STATE(240)] = 17020,
  [SMALL_STATE(241)] = 17089,
  [SMALL_STATE(242)] = 17132,
  [SMALL_STATE(243)] = 17175,
  [SMALL_STATE(244)] = 17244,
  [SMALL_STATE(245)] = 17287,
  [SMALL_STATE(246)] = 17336,
  [SMALL_STATE(247)] = 17405,
  [SMALL_STATE(248)] = 17474,
  [SMALL_STATE(249)] = 17543,
  [SMALL_STATE(250)] = 17612,
  [SMALL_STATE(251)] = 17655,
  [SMALL_STATE(252)] = 17698,
  [SMALL_STATE(253)] = 17741,
  [SMALL_STATE(254)] = 17784,
  [SMALL_STATE(255)] = 17827,
  [SMALL_STATE(256)] = 17870,
  [SMALL_STATE(257)] = 17913,
  [SMALL_STATE(258)] = 17956,
  [SMALL_STATE(259)] = 18025,
  [SMALL_STATE(260)] = 18070,
  [SMALL_STATE(261)] = 18139,
  [SMALL_STATE(262)] = 18208,
  [SMALL_STATE(263)] = 18277,
  [SMALL_STATE(264)] = 18320,
  [SMALL_STATE(265)] = 18389,
  [SMALL_STATE(266)] = 18432,
  [SMALL_STATE(267)] = 18475,
  [SMALL_STATE(268)] = 18518,
  [SMALL_STATE(269)] = 18561,
  [SMALL_STATE(270)] = 18630,
  [SMALL_STATE(271)] = 18673,
  [SMALL_STATE(272)] = 18742,
  [SMALL_STATE(273)] = 18785,
  [SMALL_STATE(274)] = 18828,
  [SMALL_STATE(275)] = 18870,
  [SMALL_STATE(276)] = 18912,
  [SMALL_STATE(277)] = 18954,
  [SMALL_STATE(278)] = 18996,
  [SMALL_STATE(279)] = 19038,
  [SMALL_STATE(280)] = 19080,
  [SMALL_STATE(281)] = 19122,
  [SMALL_STATE(282)] = 19164,
  [SMALL_STATE(283)] = 19206,
  [SMALL_STATE(284)] = 19248,
  [SMALL_STATE(285)] = 19290,
  [SMALL_STATE(286)] = 19334,
  [SMALL_STATE(287)] = 19376,
  [SMALL_STATE(288)] = 19418,
  [SMALL_STATE(289)] = 19460,
  [SMALL_STATE(290)] = 19518,
  [SMALL_STATE(291)] = 19572,
  [SMALL_STATE(292)] = 19627,
  [SMALL_STATE(293)] = 19682,
  [SMALL_STATE(294)] = 19737,
  [SMALL_STATE(295)] = 19792,
  [SMALL_STATE(296)] = 19842,
  [SMALL_STATE(297)] = 19891,
  [SMALL_STATE(298)] = 19940,
  [SMALL_STATE(299)] = 19989,
  [SMALL_STATE(300)] = 20038,
  [SMALL_STATE(301)] = 20087,
  [SMALL_STATE(302)] = 20136,
  [SMALL_STATE(303)] = 20185,
  [SMALL_STATE(304)] = 20234,
  [SMALL_STATE(305)] = 20283,
  [SMALL_STATE(306)] = 20332,
  [SMALL_STATE(307)] = 20381,
  [SMALL_STATE(308)] = 20430,
  [SMALL_STATE(309)] = 20479,
  [SMALL_STATE(310)] = 20528,
  [SMALL_STATE(311)] = 20577,
  [SMALL_STATE(312)] = 20626,
  [SMALL_STATE(313)] = 20675,
  [SMALL_STATE(314)] = 20727,
  [SMALL_STATE(315)] = 20779,
  [SMALL_STATE(316)] = 20831,
  [SMALL_STATE(317)] = 20883,
  [SMALL_STATE(318)] = 20933,
  [SMALL_STATE(319)] = 20979,
  [SMALL_STATE(320)] = 21010,
  [SMALL_STATE(321)] = 21041,
  [SMALL_STATE(322)] = 21072,
  [SMALL_STATE(323)] = 21103,
  [SMALL_STATE(324)] = 21129,
  [SMALL_STATE(325)] = 21155,
  [SMALL_STATE(326)] = 21176,
  [SMALL_STATE(327)] = 21197,
  [SMALL_STATE(328)] = 21218,
  [SMALL_STATE(329)] = 21239,
  [SMALL_STATE(330)] = 21260,
  [SMALL_STATE(331)] = 21289,
  [SMALL_STATE(332)] = 21310,
  [SMALL_STATE(333)] = 21331,
  [SMALL_STATE(334)] = 21352,
  [SMALL_STATE(335)] = 21373,
  [SMALL_STATE(336)] = 21394,
  [SMALL_STATE(337)] = 21415,
  [SMALL_STATE(338)] = 21444,
  [SMALL_STATE(339)] = 21465,
  [SMALL_STATE(340)] = 21492,
  [SMALL_STATE(341)] = 21513,
  [SMALL_STATE(342)] = 21534,
  [SMALL_STATE(343)] = 21555,
  [SMALL_STATE(344)] = 21575,
  [SMALL_STATE(345)] = 21595,
  [SMALL_STATE(346)] = 21615,
  [SMALL_STATE(347)] = 21635,
  [SMALL_STATE(348)] = 21655,
  [SMALL_STATE(349)] = 21675,
  [SMALL_STATE(350)] = 21695,
  [SMALL_STATE(351)] = 21715,
  [SMALL_STATE(352)] = 21735,
  [SMALL_STATE(353)] = 21755,
  [SMALL_STATE(354)] = 21778,
  [SMALL_STATE(355)] = 21797,
  [SMALL_STATE(356)] = 21816,
  [SMALL_STATE(357)] = 21838,
  [SMALL_STATE(358)] = 21860,
  [SMALL_STATE(359)] = 21882,
  [SMALL_STATE(360)] = 21904,
  [SMALL_STATE(361)] = 21926,
  [SMALL_STATE(362)] = 21944,
  [SMALL_STATE(363)] = 21966,
  [SMALL_STATE(364)] = 21986,
  [SMALL_STATE(365)] = 22006,
  [SMALL_STATE(366)] = 22026,
  [SMALL_STATE(367)] = 22048,
  [SMALL_STATE(368)] = 22070,
  [SMALL_STATE(369)] = 22092,
  [SMALL_STATE(370)] = 22114,
  [SMALL_STATE(371)] = 22136,
  [SMALL_STATE(372)] = 22158,
  [SMALL_STATE(373)] = 22180,
  [SMALL_STATE(374)] = 22200,
  [SMALL_STATE(375)] = 22222,
  [SMALL_STATE(376)] = 22244,
  [SMALL_STATE(377)] = 22266,
  [SMALL_STATE(378)] = 22288,
  [SMALL_STATE(379)] = 22308,
  [SMALL_STATE(380)] = 22330,
  [SMALL_STATE(381)] = 22352,
  [SMALL_STATE(382)] = 22372,
  [SMALL_STATE(383)] = 22394,
  [SMALL_STATE(384)] = 22413,
  [SMALL_STATE(385)] = 22430,
  [SMALL_STATE(386)] = 22449,
  [SMALL_STATE(387)] = 22466,
  [SMALL_STATE(388)] = 22485,
  [SMALL_STATE(389)] = 22504,
  [SMALL_STATE(390)] = 22521,
  [SMALL_STATE(391)] = 22540,
  [SMALL_STATE(392)] = 22557,
  [SMALL_STATE(393)] = 22574,
  [SMALL_STATE(394)] = 22593,
  [SMALL_STATE(395)] = 22612,
  [SMALL_STATE(396)] = 22629,
  [SMALL_STATE(397)] = 22646,
  [SMALL_STATE(398)] = 22665,
  [SMALL_STATE(399)] = 22680,
  [SMALL_STATE(400)] = 22699,
  [SMALL_STATE(401)] = 22714,
  [SMALL_STATE(402)] = 22733,
  [SMALL_STATE(403)] = 22752,
  [SMALL_STATE(404)] = 22771,
  [SMALL_STATE(405)] = 22790,
  [SMALL_STATE(406)] = 22809,
  [SMALL_STATE(407)] = 22828,
  [SMALL_STATE(408)] = 22845,
  [SMALL_STATE(409)] = 22862,
  [SMALL_STATE(410)] = 22881,
  [SMALL_STATE(411)] = 22898,
  [SMALL_STATE(412)] = 22917,
  [SMALL_STATE(413)] = 22936,
  [SMALL_STATE(414)] = 22955,
  [SMALL_STATE(415)] = 22972,
  [SMALL_STATE(416)] = 22989,
  [SMALL_STATE(417)] = 23008,
  [SMALL_STATE(418)] = 23027,
  [SMALL_STATE(419)] = 23046,
  [SMALL_STATE(420)] = 23065,
  [SMALL_STATE(421)] = 23084,
  [SMALL_STATE(422)] = 23101,
  [SMALL_STATE(423)] = 23120,
  [SMALL_STATE(424)] = 23139,
  [SMALL_STATE(425)] = 23156,
  [SMALL_STATE(426)] = 23175,
  [SMALL_STATE(427)] = 23194,
  [SMALL_STATE(428)] = 23211,
  [SMALL_STATE(429)] = 23230,
  [SMALL_STATE(430)] = 23247,
  [SMALL_STATE(431)] = 23266,
  [SMALL_STATE(432)] = 23285,
  [SMALL_STATE(433)] = 23304,
  [SMALL_STATE(434)] = 23323,
  [SMALL_STATE(435)] = 23342,
  [SMALL_STATE(436)] = 23361,
  [SMALL_STATE(437)] = 23380,
  [SMALL_STATE(438)] = 23397,
  [SMALL_STATE(439)] = 23416,
  [SMALL_STATE(440)] = 23435,
  [SMALL_STATE(441)] = 23454,
  [SMALL_STATE(442)] = 23473,
  [SMALL_STATE(443)] = 23492,
  [SMALL_STATE(444)] = 23511,
  [SMALL_STATE(445)] = 23528,
  [SMALL_STATE(446)] = 23547,
  [SMALL_STATE(447)] = 23561,
  [SMALL_STATE(448)] = 23577,
  [SMALL_STATE(449)] = 23593,
  [SMALL_STATE(450)] = 23609,
  [SMALL_STATE(451)] = 23625,
  [SMALL_STATE(452)] = 23641,
  [SMALL_STATE(453)] = 23655,
  [SMALL_STATE(454)] = 23671,
  [SMALL_STATE(455)] = 23685,
  [SMALL_STATE(456)] = 23701,
  [SMALL_STATE(457)] = 23717,
  [SMALL_STATE(458)] = 23733,
  [SMALL_STATE(459)] = 23743,
  [SMALL_STATE(460)] = 23753,
  [SMALL_STATE(461)] = 23763,
  [SMALL_STATE(462)] = 23779,
  [SMALL_STATE(463)] = 23795,
  [SMALL_STATE(464)] = 23811,
  [SMALL_STATE(465)] = 23827,
  [SMALL_STATE(466)] = 23843,
  [SMALL_STATE(467)] = 23857,
  [SMALL_STATE(468)] = 23873,
  [SMALL_STATE(469)] = 23889,
  [SMALL_STATE(470)] = 23903,
  [SMALL_STATE(471)] = 23919,
  [SMALL_STATE(472)] = 23935,
  [SMALL_STATE(473)] = 23949,
  [SMALL_STATE(474)] = 23963,
  [SMALL_STATE(475)] = 23977,
  [SMALL_STATE(476)] = 23991,
  [SMALL_STATE(477)] = 24005,
  [SMALL_STATE(478)] = 24021,
  [SMALL_STATE(479)] = 24037,
  [SMALL_STATE(480)] = 24053,
  [SMALL_STATE(481)] = 24066,
  [SMALL_STATE(482)] = 24079,
  [SMALL_STATE(483)] = 24092,
  [SMALL_STATE(484)] = 24105,
  [SMALL_STATE(485)] = 24118,
  [SMALL_STATE(486)] = 24131,
  [SMALL_STATE(487)] = 24144,
  [SMALL_STATE(488)] = 24157,
  [SMALL_STATE(489)] = 24170,
  [SMALL_STATE(490)] = 24183,
  [SMALL_STATE(491)] = 24196,
  [SMALL_STATE(492)] = 24209,
  [SMALL_STATE(493)] = 24222,
  [SMALL_STATE(494)] = 24235,
  [SMALL_STATE(495)] = 24248,
  [SMALL_STATE(496)] = 24261,
  [SMALL_STATE(497)] = 24274,
  [SMALL_STATE(498)] = 24287,
  [SMALL_STATE(499)] = 24300,
  [SMALL_STATE(500)] = 24313,
  [SMALL_STATE(501)] = 24326,
  [SMALL_STATE(502)] = 24339,
  [SMALL_STATE(503)] = 24352,
  [SMALL_STATE(504)] = 24365,
  [SMALL_STATE(505)] = 24378,
  [SMALL_STATE(506)] = 24391,
  [SMALL_STATE(507)] = 24404,
  [SMALL_STATE(508)] = 24417,
  [SMALL_STATE(509)] = 24430,
  [SMALL_STATE(510)] = 24443,
  [SMALL_STATE(511)] = 24456,
  [SMALL_STATE(512)] = 24469,
  [SMALL_STATE(513)] = 24482,
  [SMALL_STATE(514)] = 24495,
  [SMALL_STATE(515)] = 24508,
  [SMALL_STATE(516)] = 24521,
  [SMALL_STATE(517)] = 24534,
  [SMALL_STATE(518)] = 24547,
  [SMALL_STATE(519)] = 24560,
  [SMALL_STATE(520)] = 24573,
  [SMALL_STATE(521)] = 24586,
  [SMALL_STATE(522)] = 24599,
  [SMALL_STATE(523)] = 24612,
  [SMALL_STATE(524)] = 24625,
  [SMALL_STATE(525)] = 24638,
  [SMALL_STATE(526)] = 24651,
  [SMALL_STATE(527)] = 24664,
  [SMALL_STATE(528)] = 24677,
  [SMALL_STATE(529)] = 24690,
  [SMALL_STATE(530)] = 24703,
  [SMALL_STATE(531)] = 24716,
  [SMALL_STATE(532)] = 24729,
  [SMALL_STATE(533)] = 24742,
  [SMALL_STATE(534)] = 24755,
  [SMALL_STATE(535)] = 24768,
  [SMALL_STATE(536)] = 24781,
  [SMALL_STATE(537)] = 24794,
  [SMALL_STATE(538)] = 24807,
  [SMALL_STATE(539)] = 24811,
  [SMALL_STATE(540)] = 24815,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(526),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(368),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(387),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(66),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(37),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(66),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(533),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(43),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(40),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(218),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(216),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(216),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(10),
  [109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(532),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(527),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(181),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(526),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(523),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(522),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(274),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(449),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(388),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(455),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(496),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(531),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(508),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 3),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 3),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 3, .production_id = 1),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 3, .production_id = 1),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 4, .production_id = 1),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 4, .production_id = 1),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 3),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 3),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 5),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 5),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 3),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 2),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 2),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 2),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 2),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, .production_id = 1),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, .production_id = 1),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 6, .production_id = 9),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 6, .production_id = 9),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 3),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 3),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 2),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 2),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 5),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 5),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 5),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 5),
  [371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 3),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 3),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 3),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 3, .production_id = 4),
  [391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 3, .production_id = 4),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 4),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 4),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 5, .production_id = 1),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 5, .production_id = 1),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 2),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 3, .production_id = 2),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition, 4, .production_id = 5),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_definition, 4, .production_id = 5),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 4),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__import_entry, 1),
  [507] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__import_entry, 1),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(491),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 5),
  [515] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 5),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [533] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(442),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [550] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(357),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2),
  [555] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(436),
  [558] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(135),
  [561] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(115),
  [564] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(135),
  [567] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(521),
  [570] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(133),
  [573] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(131),
  [576] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(221),
  [579] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(221),
  [582] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(158),
  [585] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(182),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(497),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rename, 3),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rename, 3),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [602] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(390),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 5),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 5),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3),
  [623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 4),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 4),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_body, 2),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_body, 2),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 7, .production_id = 12),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 12),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 11),
  [639] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 11),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 6),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 6),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_body, 3),
  [647] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_body, 3),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 2),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 2),
  [653] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 3),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 3),
  [663] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [681] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 3),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [741] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(374),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2),
  [746] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(426),
  [749] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(423),
  [752] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(464),
  [755] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(419),
  [758] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(471),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [767] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(530),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [773] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [777] = {.entry = {.count = 1, .reusable = false}}, SHIFT(469),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [783] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [787] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat1, 2),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 2),
  [791] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 2), SHIFT_REPEAT(471),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_value, 1),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 1),
  [802] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setter_definition, 6, .production_id = 13),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setter_definition, 6, .production_id = 13),
  [806] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prefix_operator_definition, 2, .production_id = 4),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_prefix_operator_definition, 2, .production_id = 4),
  [810] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constructor, 2),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constructor, 2),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [816] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_getter_definition, 2, .production_id = 4),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_getter_definition, 2, .production_id = 4),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_definition, 4, .production_id = 10),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_definition, 4, .production_id = 10),
  [824] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_operator_definition, 4, .production_id = 10),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_operator_definition, 4, .production_id = 10),
  [828] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_definition, 5, .production_id = 9),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_definition, 5, .production_id = 9),
  [832] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_operator_definition, 5, .production_id = 9),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_operator_definition, 5, .production_id = 9),
  [836] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_setter_definition, 8, .production_id = 14),
  [838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_setter_definition, 8, .production_id = 14),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 1),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 1),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 2),
  [848] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_definition_repeat1, 2), SHIFT_REPEAT(449),
  [851] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 2), SHIFT_REPEAT(388),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_static_getter_definition, 2, .production_id = 8),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_static_getter_definition, 2, .production_id = 8),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_static_method_definition, 2),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_static_method_definition, 2),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2),
  [864] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat1, 1),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 1),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 6),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 6),
  [872] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 5),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 5),
  [876] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_value, 3, .production_id = 6),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 3, .production_id = 6),
  [880] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [888] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2), SHIFT_REPEAT(198),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(538),
  [903] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [907] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [909] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [913] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(462),
  [916] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [922] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2),
  [924] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(395),
  [927] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(167),
  [930] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [932] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [936] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 1),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_runtime_attribute_repeat1, 2),
  [962] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_runtime_attribute_repeat1, 2), SHIFT_REPEAT(427),
  [965] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [967] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [971] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2),
  [977] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [979] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [981] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [983] = {.entry = {.count = 1, .reusable = false}}, SHIFT(540),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [987] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [989] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 1),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_definition_repeat1, 1),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__any_attribute, 1),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__any_attribute, 1),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 5),
  [1007] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 5),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [1011] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1017] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 1),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 1),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, .production_id = 7),
  [1025] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1039] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [1045] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(467),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 4),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 4),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1058] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [1060] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [1062] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_map_repeat1, 2),
  [1066] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_repeat1, 2), SHIFT_REPEAT(179),
  [1069] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 2),
  [1071] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 2),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [1077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1083] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(421),
  [1086] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(460),
  [1089] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(412),
  [1092] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2),
  [1112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2), SHIFT_REPEAT(475),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [1129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 3),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 3),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 3),
  [1143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 3),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 3),
  [1153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 2),
  [1155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 1),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1227] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
  [1281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3),
  [1283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wren(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
