/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as p,customElement as C}from"lit/decorators.js";import{PseudoButtonLitElement as k}from"@typo3/backend/element/pseudo-button.js";import{SeverityEnum as E}from"@typo3/backend/enum/severity.js";import h from"@typo3/backend/modal.js";import{lll as y}from"@typo3/core/lit-helper.js";import w from"@typo3/core/ajax/ajax-request.js";import S from"@typo3/backend/notification.js";var m=function(a,t,l,e){var r=arguments.length,o=r<3?t:e===null?e=Object.getOwnPropertyDescriptor(t,l):e,c;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")o=Reflect.decorate(a,t,l,e);else for(var d=a.length-1;d>=0;d--)(c=a[d])&&(o=(r<3?c(o):r>3?c(t,l,o):c(t,l))||o);return r>3&&o&&Object.defineProperty(t,l,o),o},n,f;(function(a){a.columnsSelector=".t3js-column-selector",a.columnsContainerSelector=".t3js-column-selector-container",a.columnsFilterSelector='input[name="columns-filter"]',a.columnsSelectorActionsSelector=".t3js-column-selector-actions"})(f||(f={}));var g;(function(a){a.toggle="select-toggle",a.all="select-all",a.none="select-none"})(g||(g={}));let u=n=class extends k{constructor(){super(...arguments),this.modalTitle="Show columns",this.buttonOk=y("button.ok")||"Update",this.buttonClose=y("button.close")||"Close",this.errorMessage="Could not update columns"}static toggleSelectorActions(t,l,e,r=!1){l.classList.add("disabled");for(let o=0;o<t.length;o++)if(!t[o].disabled&&!t[o].checked&&(r||!n.isColumnHidden(t[o]))){l.classList.remove("disabled");break}e.classList.add("disabled");for(let o=0;o<t.length;o++)if(!t[o].disabled&&t[o].checked&&(r||!n.isColumnHidden(t[o]))){e.classList.remove("disabled");break}}static isColumnHidden(t){return t.closest(f.columnsContainerSelector)?.classList.contains("hidden")}static filterColumns(t,l){l.forEach(e=>{const r=e.closest(f.columnsContainerSelector);if(!e.disabled&&r!==null){const o=r.querySelector(".form-check-label")?.textContent;o&&o.length&&r.classList.toggle("hidden",t.value!==""&&!RegExp(t.value,"i").test(o.trim().replace(/\[\]/g,"").replace(/\s+/g," ")))}})}buttonActivated(){this.showColumnSelectorModal()}showColumnSelectorModal(){if(!this.modalUrl||!this.modalTarget)return;const t=h.advanced({content:this.modalUrl,title:this.modalTitle,severity:E.notice,size:h.sizes.medium,type:h.types.ajax,buttons:[{text:this.buttonClose,active:!0,btnClass:"btn-default",name:"cancel",trigger:(l,e)=>e.hideModal()},{text:this.buttonOk,btnClass:"btn-primary",name:"update",trigger:(l,e)=>this.processSelection(e)}],ajaxCallback:()=>this.handleModalContentLoaded(t)})}processSelection(t){const l=t.querySelector("form");if(l===null){this.abortSelection();return}new w(TYPO3.settings.ajaxUrls.show_columns).post(new FormData(l)).then(async e=>{const r=await e.resolve();r.success===!0?(this.ownerDocument.location.href=this.modalTarget,this.ownerDocument.location.reload()):S.error(r.message||"No update was performed"),h.dismiss()}).catch(()=>{this.abortSelection()})}handleModalContentLoaded(t){const l=t.querySelector("form");if(l===null)return;l.addEventListener("submit",s=>{s.preventDefault()});const e=t.querySelectorAll(f.columnsSelector),r=t.querySelector(f.columnsFilterSelector),o=t.querySelector(f.columnsSelectorActionsSelector),c=o.querySelector('button[data-action="'+g.all+'"]'),d=o.querySelector('button[data-action="'+g.none+'"]');!e.length||r===null||c===null||d===null||(n.toggleSelectorActions(e,c,d,!0),e.forEach(s=>{s.addEventListener("change",()=>{n.toggleSelectorActions(e,c,d)})}),r.addEventListener("keydown",s=>{const b=s.target;s.code==="Escape"&&(s.stopImmediatePropagation(),b.value="")}),r.addEventListener("keyup",s=>{n.filterColumns(s.target,e),n.toggleSelectorActions(e,c,d)}),r.addEventListener("search",s=>{n.filterColumns(s.target,e),n.toggleSelectorActions(e,c,d)}),o.querySelectorAll("button[data-action]").forEach(s=>{s.addEventListener("click",b=>{b.preventDefault();const v=b.currentTarget;if(v.dataset.action){switch(v.dataset.action){case g.toggle:e.forEach(i=>{!i.disabled&&!n.isColumnHidden(i)&&(i.checked=!i.checked)});break;case g.all:e.forEach(i=>{!i.disabled&&!n.isColumnHidden(i)&&(i.checked=!0)});break;case g.none:e.forEach(i=>{!i.disabled&&!n.isColumnHidden(i)&&(i.checked=!1)});break;default:S.warning("Unknown selector action")}n.toggleSelectorActions(e,c,d)}})}))}abortSelection(){S.error(this.errorMessage),h.dismiss()}};m([p({type:String,attribute:"data-url"})],u.prototype,"modalUrl",void 0),m([p({type:String,attribute:"data-target"})],u.prototype,"modalTarget",void 0),m([p({type:String,attribute:"data-title"})],u.prototype,"modalTitle",void 0),m([p({type:String,attribute:"data-button-ok"})],u.prototype,"buttonOk",void 0),m([p({type:String,attribute:"data-button-close"})],u.prototype,"buttonClose",void 0),m([p({type:String,attribute:"data-error-message"})],u.prototype,"errorMessage",void 0),u=n=m([C("typo3-backend-column-selector-button")],u);export{u as ColumnSelectorButton};
