/*
 * Decompiled with CFR 0.152.
 */
package cycinf.reasoning;

import cycinf.constraints.Constraint;
import cycinf.infstats.DirTracker;
import cycinf.reasoning.RConstraint;
import cycinf.reasoning.RContext1;
import cycinf.reasoning.RNode;
import cycinf.util.Markable;
import cycinf.util.SourceLocation;
import cycinf.util.SourceSearch;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLocationNode
extends RNode<RLocationNode>
implements Markable {
    final SourceLocation location;
    final IFile file;
    final SourceSearch loc2;
    private IMarker marker = null;
    private static Map<IMarker, RLocationNode> constraintMarkerCache = new HashMap();
    private static final String markerType = "cycinf.ConstraintMarker";

    public final SourceLocation getLocation() {
        return this.location;
    }

    public final IFile getFile() {
        return this.file;
    }

    public final SourceSearch getLoc2() {
        return this.loc2;
    }

    RLocationNode(RContext1<?, RLocationNode> role, SourceLocation location) {
        super(role);
        this.registerThis((RNode)this);
        this.location = location;
        this.nodeDesc = location.toString();
        this.file = this.getLocation().findFileInDir(this.getContext().getOwningInfstats().getDir());
        this.loc2 = SourceSearch.justFindLocation((DirTracker)this.getContext().getOwningInfstats().getDir(), (SourceLocation)location);
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void mark() throws CoreException {
        if (this.marker == null) {
            this.marker = this.getLocation().findFileInDir(this.getOwningInfstats().getDir()).createMarker(markerType);
            this.marker.setAttribute("lineNumber", this.getLocation().getLine());
            this.marker.setAttribute("message", (Object)("Mentioned by constraint " + ((Constraint)((RConstraint)this.findConstraintTop().getNode()).getBack()).toString()));
            this.marker.setAttribute("priority", 1);
            this.marker.setAttribute("severity", 0);
            this.marker.setAttribute("charStart", this.loc2.getStartPos());
            this.marker.setAttribute("charEnd", this.loc2.getEndPos());
            constraintMarkerCache.put(this.marker, this);
        }
    }

    public void unmark() throws CoreException {
        if (this.marker != null) {
            constraintMarkerCache.remove(this.marker);
            this.marker.delete();
            this.marker = null;
        }
    }

    public static RLocationNode lookupMarker(IMarker m) {
        return (RLocationNode)constraintMarkerCache.get(m);
    }
}

