/*
 * Decompiled with CFR 0.152.
 */
package cycinf.util;

import cycinf.cvars.usedtype.GlobalVariable;
import cycinf.cvars.usedtype.Identifier;
import cycinf.cvars.usedtype.LocalVariable;
import cycinf.cvars.usedtype.UsedType;
import cycinf.cvars.usedtype.UsedTypeLayer;
import cycinf.infstats.DirTracker;
import cycinf.util.FileUtils;
import cycinf.util.SourceLocation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SourceSearch {
    private int startPos;
    private int endPos;
    private boolean confident;
    private static final String patternForAnyIdentifier = "(?<!\\w)\\w+(?!\\w)";
    private static final String ignorable = "(?:\\s|`(?<!\\w)\\w+(?!\\w))*";
    private static final int CONSIDER_RANGE = 256;

    public final int getStartPos() {
        return this.startPos;
    }

    public final int getEndPos() {
        return this.endPos;
    }

    public final boolean isConfident() {
        return this.confident;
    }

    private SourceSearch() {
    }

    private SourceSearch(int startPos, int endPos, boolean confident) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.confident = confident;
    }

    public static SourceSearch justFindLocation(DirTracker dir, SourceLocation loc) {
        try {
            int pos = loc.locateInString(FileUtils.readFile((IFile)loc.findFileInDir(dir)));
            return new SourceSearch(pos, pos + 1, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SourceSearch(0, 0, false);
        }
    }

    public static SourceSearch findUsedTypeLayer(DirTracker dir, SourceLocation sl, UsedTypeLayer utl) {
        try {
            return SourceSearch.findPointer((SourceLocation)sl, (String)FileUtils.readFile((IFile)sl.findFileInDir(dir)), (UsedTypeLayer)utl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SourceSearch(0, 0, false);
        }
    }

    private static String patternForIdentifier(Identifier i) {
        return "(?<!\\w)" + Pattern.quote(i.getName()) + "(?!\\w)";
    }

    static SourceSearch findPointer(SourceLocation sl, String source, UsedTypeLayer utl) {
        int pos1 = sl.locateInString(source);
        SourceSearch ss = new SourceSearch(pos1, pos1, false);
        UsedType ut = utl.getType();
        if (ut instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)ut;
            ss = SourceSearch.findIdentifierPointerNear((int)pos1, (String)source, (Identifier)lv.getLocalName(), (int)utl.getDepth());
        } else if (ut instanceof GlobalVariable) {
            GlobalVariable gv = (GlobalVariable)ut;
            ss = SourceSearch.findIdentifierPointerNear((int)pos1, (String)source, (Identifier)gv.getName(), (int)utl.getDepth());
        }
        if (!(ss.isConfident() || sl.getCharPos() == -1 || source.charAt(pos1) != '*' && source.charAt(pos1) != '?' && source.charAt(pos1) != '@')) {
            ss.startPos = pos1;
            ss.endPos = pos1 + 1;
            ss.confident = true;
        }
        return ss;
    }

    private static SourceSearch findIdentifierPointerNear(int pos1, String source, Identifier identifier, int depth) {
        String patternStr = "([\\*\\@\\?])(?:\\s|`(?<!\\w)\\w+(?!\\w))*(?:[\\*\\@\\?](?:\\s|`(?<!\\w)\\w+(?!\\w))*){" + depth + "}" + SourceSearch.patternForIdentifier((Identifier)identifier);
        Pattern thePattern = Pattern.compile(patternStr);
        return SourceSearch.findPatternMatchNear((int)pos1, (String)source, (Pattern)thePattern, (int)1);
    }

    static SourceSearch findPatternMatchNear(int pos1, String source, Pattern pat, int group) {
        int startConsider = Math.max(0, pos1 - 256);
        int endConsider = Math.min(source.length(), pos1 + 256);
        Matcher theMatcher = pat.matcher(source);
        theMatcher.region(startConsider, endConsider);
        theMatcher.useTransparentBounds(true);
        int bestMatchStart = -1;
        int bestMatchEnd = -1;
        while (theMatcher.find()) {
            int matchStart = theMatcher.start(group);
            if (bestMatchStart != -1 && Math.abs(matchStart - pos1) >= Math.abs(bestMatchStart - pos1)) continue;
            bestMatchStart = matchStart;
            bestMatchEnd = theMatcher.end(group);
        }
        SourceSearch ss = new SourceSearch();
        if (bestMatchStart == -1) {
            ss.startPos = pos1;
            ss.endPos = pos1;
            ss.confident = false;
        } else {
            ss.startPos = bestMatchStart;
            ss.endPos = bestMatchEnd;
            ss.confident = true;
        }
        return ss;
    }
}

