/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import io.github.eb4j.dsl.DslArticle;
import io.github.eb4j.dsl.DslDictionary;
import io.github.eb4j.dsl.DslResult;
import io.github.eb4j.dsl.data.LanguageCode;
import io.github.eb4j.dsl.data.LanguageName;
import io.github.eb4j.dsl.visitor.DslVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.util.Preferences;

public class LingvoDSL
implements IDictionaryFactory {
    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener(new LingvoDSLApplicationEventListener());
    }

    public static void unloadPlugins() {
    }

    @Override
    public final boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".dsl") || file.getPath().endsWith(".dsl.dz");
    }

    @Override
    public final IDictionary loadDict(File file) throws Exception {
        Path dictPath = Paths.get(file.toURI());
        Path indexPath = Paths.get(dictPath + ".idx", new String[0]);
        return new LingvoDSLDict(dictPath, indexPath, false);
    }

    public static class HtmlVisitor
    extends DslVisitor<String> {
        private static final String[] IMAGE_EXTS = new String[]{"png", "jpg", "PNG", "JPG"};
        private static final LanguageCode LANG_CODE = new LanguageCode();
        private static final LanguageName LANG_NAME = new LanguageName();
        private final boolean condensedView;
        private final File basePath;
        private StringBuilder sb;
        private boolean delayText;
        private String previousText;
        private boolean inDetails;

        public HtmlVisitor(String dirPath, boolean condensedView) throws IOException {
            File dir = new File(dirPath);
            if (!dir.isDirectory()) {
                throw new IOException("Directory not found!");
            }
            this.basePath = dir;
            this.delayText = false;
            this.inDetails = false;
            this.condensedView = condensedView;
        }

        public void start() {
            this.sb = new StringBuilder();
        }

        public void finish() {
        }

        public void visit(DslArticle.Tag tag) {
            if (this.inDetails && this.condensedView) {
                return;
            }
            if (tag.isTagName("b")) {
                this.sb.append("<strong>");
            } else if (tag.isTagName("br")) {
                this.sb.append("<br/>");
            } else if (tag.isTagName("u")) {
                this.sb.append("<span style='text-decoration:underline'>");
            } else if (tag.isTagName("i")) {
                this.sb.append("<span style='font-style: italic'>");
            } else if (tag.isTagName("sup")) {
                this.sb.append("<sup>");
            } else if (tag.isTagName("sub")) {
                this.sb.append("<sub>");
            } else if (tag.isTagName("c")) {
                if (tag.hasAttribute()) {
                    this.sb.append("<span style=\"color: ").append(tag.getAttribute().getValue()).append("\">");
                } else {
                    this.sb.append("<span style=\"color: green\">");
                }
            } else if (tag.isTagName("'")) {
                this.sb.append("<span style=\"color: red\">");
            } else if (tag.isTagName("url") || tag.isTagName("s") || tag.isTagName("video")) {
                this.delayText = true;
            } else if (tag.isTagName("lang")) {
                if (tag.hasAttribute() && tag.getAttribute().getKey().equals("id")) {
                    int i = Integer.parseInt(tag.getAttribute().getValue());
                    if (LANG_CODE.containsKey((Object)i)) {
                        this.sb.append("<span class=\"lang_").append((String)LANG_CODE.get((Object)i)).append("\">");
                        return;
                    }
                } else if (tag.hasAttribute() && tag.getAttribute().getKey().equals("name") && LANG_NAME.containsKey((Object)tag.getAttribute().getValue())) {
                    this.sb.append("<span class=\"lang_").append((String)LANG_NAME.get((Object)tag.getAttribute().getValue())).append("\">");
                    return;
                }
                this.sb.append("<span>");
            } else if (tag.isTagName("*")) {
                this.inDetails = true;
                if (!this.condensedView) {
                    this.sb.append("<span class=\"details\">");
                }
            } else if (this.condensedView) {
                if (tag.isTagName("m")) {
                    this.sb.append("<span>");
                } else if (tag.isTagName("m1")) {
                    this.sb.append("<span class=\"paragraph-start\">\u00b6</span><span>");
                } else if (tag.isTagName("m2")) {
                    this.sb.append("<span class=\"paragraph-start\">\u204b</span><span>");
                } else if (tag.isTagName("m3") || tag.isTagName("m4") || tag.isTagName("m5") || tag.isTagName("m6") || tag.isTagName("m7") || tag.isTagName("m8") || tag.isTagName("m9")) {
                    this.sb.append("<span class=\"paragraph-start\">\u00a7</span><span>");
                }
            } else if (tag.isTagName("m")) {
                this.sb.append("<div>");
            } else if (tag.isTagName("m1")) {
                this.sb.append("<div style=\"text-indent: 30px\">");
            } else if (tag.isTagName("m2")) {
                this.sb.append("<div style=\"text-indent: 60px\">");
            } else if (tag.isTagName("m3")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m4")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m5")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m6")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m7")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m8")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            } else if (tag.isTagName("m9")) {
                this.sb.append("<div style=\"text-indent: 90px\">");
            }
        }

        private String getMediaUrl() {
            return new File(this.basePath, this.previousText).toURI().toString();
        }

        private boolean isMediaImage() {
            String ext = FilenameUtils.getExtension((String)this.previousText);
            for (String e : IMAGE_EXTS) {
                if (!e.equals(ext)) continue;
                return true;
            }
            return false;
        }

        public void visit(DslArticle.EndTag endTag) {
            if (endTag.isTagName("*")) {
                this.inDetails = false;
                if (!this.condensedView) {
                    this.sb.append("</span>");
                }
                return;
            }
            if (this.inDetails && this.condensedView) {
                return;
            }
            if (this.delayText) {
                if (this.previousText == null) {
                    return;
                }
                if (endTag.isTagName("video")) {
                    this.sb.append("<a href=\"").append(this.getMediaUrl()).append("\">").append(this.previousText).append("</a>");
                } else if (endTag.isTagName("s")) {
                    if (this.isMediaImage()) {
                        this.sb.append("<img src=\"").append(this.getMediaUrl()).append("\" />");
                    } else {
                        this.sb.append("<a href=\"").append(this.getMediaUrl()).append("\" >").append(this.previousText).append("</a>");
                    }
                } else if (endTag.isTagName("url")) {
                    this.sb.append("<a href=\"").append(this.previousText).append("\">").append(this.previousText).append("</a>");
                }
                this.delayText = false;
                this.previousText = null;
            }
            if (endTag.isTagName("b")) {
                this.sb.append("</strong>");
            } else if (endTag.isTagName("u") || endTag.isTagName("i") || endTag.isTagName("c") || endTag.isTagName("'") || endTag.isTagName("lang")) {
                this.sb.append("</span>");
            } else if (endTag.isTagName("t")) {
                this.sb.append("&nbsp;");
            } else if (endTag.isTagName("sup")) {
                this.sb.append("</sup>");
            } else if (endTag.isTagName("sub")) {
                this.sb.append("</sub>");
            } else if (endTag.isTagName("m")) {
                if (this.condensedView) {
                    this.sb.append("</span>&nbsp;");
                } else {
                    this.sb.append("</div>");
                }
            }
        }

        public String getObject() {
            if (this.sb == null) {
                throw new RuntimeException();
            }
            return this.sb.toString();
        }

        public void visit(DslArticle.Text t) {
            if (this.inDetails && this.condensedView) {
                return;
            }
            this.previousText = t.getText();
            if (!this.delayText) {
                this.sb.append(t);
            }
        }

        public void visit(DslArticle.Attribute a) {
        }

        public void visit(DslArticle.Newline n) {
            if (this.inDetails && this.condensedView) {
                return;
            }
            this.sb.append("\n");
        }
    }

    static class LingvoDSLDict
    implements IDictionary {
        protected final DslDictionary data;
        private final HtmlVisitor htmlVisitor;

        LingvoDSLDict(Path dictPath, Path indexPath, boolean validateIndexAbsPath) throws Exception {
            this.data = DslDictionary.loadDictionary((Path)dictPath, (Path)indexPath, (boolean)validateIndexAbsPath);
            this.htmlVisitor = new HtmlVisitor(dictPath.getParent().toString(), Preferences.isPreferenceDefault("dictionary_condensed_view", false));
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws IOException {
            return this.readEntries(word, this.data.lookup(word));
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) throws IOException {
            return this.readEntries(word, this.data.lookupPredictive(word));
        }

        private List<DictionaryEntry> readEntries(String word, DslResult dslResult) {
            ArrayList<DictionaryEntry> list = new ArrayList<DictionaryEntry>();
            for (Map.Entry e : dslResult.getEntries((DslVisitor)this.htmlVisitor)) {
                DictionaryEntry dictionaryEntry = new DictionaryEntry(word, (String)e.getKey(), (String)e.getValue());
                list.add(dictionaryEntry);
            }
            return list;
        }
    }

    static class LingvoDSLApplicationEventListener
    implements IApplicationEventListener {
        LingvoDSLApplicationEventListener() {
        }

        @Override
        public void onApplicationStartup() {
            Core.getDictionaries().addDictionaryFactory(new LingvoDSL());
        }

        @Override
        public void onApplicationShutdown() {
        }
    }
}

