/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.pdf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;

public class PdfFilter
extends AbstractFilter {
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("^\\s*?$");

    @Override
    public String getFileFormatName() {
        return OStrings.getString("PDFFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.pdf", null, null, "${nameOnly}.txt")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public BufferedReader createReader(File infile, String encoding) throws IOException, TranslationException {
        BufferedReader bufferedReader;
        block8: {
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setLineSeparator("\n");
            stripper.setSortByPosition(true);
            PDDocument document = PDDocument.load((File)infile);
            try {
                String text = stripper.getText(document);
                bufferedReader = new BufferedReader(new StringReader(text));
                if (document == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidPasswordException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, OStrings.getString("PDFFILTER_ENCRYPTED_FILE"), infile);
                    throw new TranslationException(ex);
                }
            }
            document.close();
        }
        return bufferedReader;
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) {
        StringBuilder sb = new StringBuilder();
        String s = "";
        try {
            while ((s = in.readLine()) != null) {
                Matcher m = LINEBREAK_PATTERN.matcher(s);
                if (m.find()) {
                    out.write(this.processEntry(sb.toString()));
                    sb.setLength(0);
                    out.write("\n\n");
                    continue;
                }
                sb.append(s);
                sb.append(" ");
            }
            if (sb.length() > 0) {
                out.write(this.processEntry(sb.toString()));
                sb.setLength(0);
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

