/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.omegat.gui.dialogs.FileCollisionDialog;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class LogDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private JPanel buttonPanel;
    private JPanel innerButtonPanel;
    private JTextPane logTextPane;
    private JButton okButton;
    private JButton saveAsButton;
    private JScrollPane scroll;

    public LogDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setTitle(OStrings.getString("LOGDIALOG_TITLE") + " " + Log.getLogFileName());
        StaticUIUtils.setEscapeClosable(this);
        this.setSize(600, 400);
        this.setLocationRelativeTo(parent);
        Font currFont = this.logTextPane.getFont();
        this.logTextPane.setFont(new Font("Monospaced", currFont.getStyle(), currFont.getSize()));
        final File logLocation = new File(Log.getLogFilePath());
        new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                String string;
                FileInputStream fis = new FileInputStream(logLocation);
                try {
                    string = IOUtils.toString((InputStream)fis, (Charset)StandardCharsets.UTF_8);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
                fis.close();
                return string;
            }

            @Override
            protected void done() {
                try {
                    LogDialog.this.logTextPane.setText((String)this.get());
                }
                catch (Exception e) {
                    Log.log(e);
                }
                OSXIntegration.setProxyIcon(LogDialog.this.getRootPane(), logLocation);
            }
        }.execute();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.logTextPane = new JTextPane();
        this.buttonPanel = new JPanel();
        this.innerButtonPanel = new JPanel();
        this.saveAsButton = new JButton();
        this.okButton = new JButton();
        this.setTitle(OStrings.getString("LOGDIALOG_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogDialog.this.closeDialog(evt);
            }
        });
        this.logTextPane.setEditable(false);
        this.scroll.setViewportView(this.logTextPane);
        this.getContentPane().add((Component)this.scroll, "Center");
        this.buttonPanel.setLayout(new BorderLayout());
        this.innerButtonPanel.setLayout(new BoxLayout(this.innerButtonPanel, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.saveAsButton, (String)OStrings.getString("BUTTON_SAVE_AS"));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogDialog.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.innerButtonPanel.add(this.saveAsButton);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.innerButtonPanel.add(this.okButton);
        this.buttonPanel.add((Component)this.innerButtonPanel, "East");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        String curDir = Preferences.getPreferenceDefault("current_folder", System.getProperty("user.home"));
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File(curDir, Log.getLogFileName()));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        File outFile = chooser.getSelectedFile();
        if (outFile.exists() && !FileCollisionDialog.promptToReplace(this, outFile.getName())) {
            return;
        }
        try {
            FileUtils.copyFile((File)new File(Log.getLogFilePath()), (File)chooser.getSelectedFile());
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        Preferences.setPreference("current_folder", outFile.getParent());
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

