/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.TranslationUndoManager;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.gui.editor.ViewParagraph;
import org.omegat.gui.editor.autocompleter.AutoCompleter;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Java8Compat;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIDesignManager;

public class EditorTextArea3
extends JEditorPane {
    private static final KeyStroke KEYSTROKE_CONTEXT_MENU = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorContextMenu");
    private static final KeyStroke KEYSTROKE_NEXT = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorNextSegment");
    private static final KeyStroke KEYSTROKE_PREV = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorPrevSegment");
    private static final KeyStroke KEYSTROKE_NEXT_NOT_TAB = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorNextSegmentNotTab");
    private static final KeyStroke KEYSTROKE_PREV_NOT_TAB = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorPrevSegmentNotTab");
    private static final KeyStroke KEYSTROKE_INSERT_LF = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorInsertLineBreak");
    private static final KeyStroke KEYSTROKE_SELECT_ALL = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorSelectAll");
    private static final KeyStroke KEYSTROKE_DELETE_PREV_TOKEN = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorDeletePrevToken");
    private static final KeyStroke KEYSTROKE_DELETE_NEXT_TOKEN = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorDeleteNextToken");
    private static final KeyStroke KEYSTROKE_FIRST_SEG = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorFirstSegment");
    private static final KeyStroke KEYSTROKE_LAST_SEG = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorLastSegment");
    private static final KeyStroke KEYSTROKE_SKIP_NEXT_TOKEN = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorSkipNextToken");
    private static final KeyStroke KEYSTROKE_SKIP_PREV_TOKEN = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorSkipPrevToken");
    private static final KeyStroke KEYSTROKE_SKIP_NEXT_TOKEN_SEL = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorSkipNextTokenWithSelection");
    private static final KeyStroke KEYSTROKE_SKIP_PREV_TOKEN_SEL = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorSkipPrevTokenWithSelection");
    private static final KeyStroke KEYSTROKE_TOGGLE_CURSOR_LOCK = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorToggleCursorLock");
    private static final KeyStroke KEYSTROKE_TOGGLE_OVERTYPE = PropertiesShortcuts.getEditorShortcuts().getKeyStroke("editorToggleOvertype");
    protected final TranslationUndoManager undoManager = new TranslationUndoManager(this);
    protected final EditorController controller;
    protected final List<PopupMenuConstructorInfo> popupConstructors = new ArrayList<PopupMenuConstructorInfo>();
    protected String currentWord;
    protected AutoCompleter autoCompleter = new AutoCompleter(this);
    protected boolean lockCursorToInputArea = true;
    protected boolean overtypeMode = false;
    protected final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            EditorTextArea3.this.autoCompleter.setVisible(false);
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int mousepos = Java8Compat.viewToModel(EditorTextArea3.this, e.getPoint());
                boolean changed = EditorTextArea3.this.controller.goToSegmentAtLocation(EditorTextArea3.this.getCaretPosition());
                if (!changed && EditorTextArea3.this.selectTag(mousepos)) {
                    e.consume();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        private void doPopup(Point p) {
            int mousepos = Java8Compat.viewToModel(EditorTextArea3.this, p);
            JPopupMenu popup = EditorTextArea3.this.makePopupMenu(mousepos);
            if (popup.getComponentCount() > 0) {
                popup.show(EditorTextArea3.this, p.x, p.y);
            }
        }
    };
    public static final ViewFactory FACTORY3 = new ViewFactory(){

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new ViewLabel(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ViewParagraph(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new ViewLabel(elem);
        }
    };

    public EditorTextArea3(EditorController controller) {
        this.controller = controller;
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return FACTORY3;
            }

            @Override
            protected void createInputAttributes(Element element, MutableAttributeSet set) {
                set.removeAttributes(set);
                EditorController c = EditorTextArea3.this.controller;
                try {
                    c.m_docSegList[c.displayedEntryIndex].createInputAttributes(element, set);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.addMouseListener(this.mouseListener);
        OvertypeCaret c = new OvertypeCaret();
        c.setBlinkRate(this.getCaret().getBlinkRate());
        this.setCaret(c);
        this.addCaretListener(e -> {
            try {
                int start = EditorUtils.getWordStart(this, e.getMark());
                int end = EditorUtils.getWordEnd(this, e.getMark());
                if (end - start <= 0) {
                    return;
                }
                String newWord = this.getText(start, end - start);
                if (!newWord.equals(this.currentWord)) {
                    this.currentWord = newWord;
                    CoreEvents.fireEditorNewWord(newWord);
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        });
        this.setToolTipText("");
        this.setDragEnabled(true);
        this.setForeground(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.setCaretColor(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.updateLockInsertMessage();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Document3 doc = this.getOmDocument();
        if (doc != null) {
            doc.setFont(font);
        }
    }

    public Document3 getOmDocument() {
        try {
            return (Document3)this.getDocument();
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public boolean isInActiveTranslation(int position) {
        return position >= this.getOmDocument().getTranslationStart() && position <= this.getOmDocument().getTranslationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPopupMenu makePopupMenu(int pos) {
        PopupMenuConstructorInfo[] cons;
        List<PopupMenuConstructorInfo> list = this.popupConstructors;
        synchronized (list) {
            cons = this.popupConstructors.toArray(new PopupMenuConstructorInfo[this.popupConstructors.size()]);
        }
        int ae = this.controller.displayedEntryIndex;
        SegmentBuilder sb = this.controller.m_docSegList[ae];
        boolean isInActiveEntry = sb.isActive() ? pos >= sb.getStartPosition() && pos <= sb.getEndPosition() : false;
        JPopupMenu popup = new JPopupMenu();
        for (PopupMenuConstructorInfo c : cons) {
            c.constructor.addItems(popup, this, pos, isInActiveEntry, this.isInActiveTranslation(pos), sb);
        }
        UIDesignManager.removeUnusedMenuSeparators(popup);
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        List<PopupMenuConstructorInfo> list = this.popupConstructors;
        synchronized (list) {
            this.popupConstructors.add(new PopupMenuConstructorInfo(priority, constructor));
            Collections.sort(this.popupConstructors, (o1, o2) -> o1.priority - o2.priority);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyEvent = e.getID();
        if (keyEvent == 402) {
            super.processKeyEvent(e);
            return;
        }
        if (keyEvent == 400) {
            super.processKeyEvent(e);
            return;
        }
        boolean processed = false;
        Document3 doc = this.getOmDocument();
        KeyStroke s = KeyStroke.getKeyStrokeForEvent(e);
        if (this.autoCompleter.processKeys(e)) {
            processed = true;
        } else if (s.equals(KEYSTROKE_CONTEXT_MENU)) {
            JPopupMenu popup = this.makePopupMenu(this.getCaretPosition());
            if (popup.getComponentCount() > 0) {
                popup.show(this, (int)this.getCaret().getMagicCaretPosition().getX(), (int)this.getCaret().getMagicCaretPosition().getY());
                processed = true;
            }
        } else if (s.equals(KEYSTROKE_NEXT)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            }
        } else if (s.equals(KEYSTROKE_PREV)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (s.equals(KEYSTROKE_NEXT_NOT_TAB)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            } else {
                Core.getMainWindow().showTimedStatusMessageRB("ETA_WARNING_TAB_ADVANCE", new Object[0]);
                processed = true;
            }
        } else if (s.equals(KEYSTROKE_PREV_NOT_TAB)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (s.equals(KEYSTROKE_INSERT_LF)) {
            KeyEvent ke = new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 0, 10, '\n');
            super.processKeyEvent(ke);
            processed = true;
        } else if (s.equals(KEYSTROKE_SELECT_ALL)) {
            this.setSelectionStart(doc.getTranslationStart());
            this.setSelectionEnd(doc.getTranslationEnd());
            processed = true;
        } else if (s.equals(KEYSTROKE_DELETE_PREV_TOKEN)) {
            try {
                processed = this.wholeTagDelete(false);
                if (!processed) {
                    int offset = this.getCaretPosition();
                    int prevWord = Utilities.getPreviousWord(this, offset);
                    int c = Math.max(prevWord, doc.getTranslationStart());
                    this.setSelectionStart(c);
                    this.setSelectionEnd(offset);
                    this.replaceSelection("");
                    processed = true;
                }
            }
            catch (BadLocationException offset) {}
        } else if (s.equals(KEYSTROKE_DELETE_NEXT_TOKEN)) {
            try {
                processed = this.wholeTagDelete(true);
                if (!processed) {
                    int offset = this.getCaretPosition();
                    int nextWord = Utilities.getNextWord(this, offset);
                    int c = Math.min(nextWord, doc.getTranslationEnd());
                    this.setSelectionStart(offset);
                    this.setSelectionEnd(c);
                    this.replaceSelection("");
                    processed = true;
                }
            }
            catch (BadLocationException offset) {}
        } else if (s.equals(KEYSTROKE_FIRST_SEG)) {
            int segNum = this.controller.m_docSegList[0].segmentNumberInProject;
            this.controller.gotoEntry(segNum);
            processed = true;
        } else if (s.equals(KEYSTROKE_LAST_SEG)) {
            int lastSegIndex = this.controller.m_docSegList.length - 1;
            int segNum = this.controller.m_docSegList[lastSegIndex].segmentNumberInProject;
            this.controller.gotoEntry(segNum);
            processed = true;
        } else if (s.equals(KEYSTROKE_SKIP_PREV_TOKEN)) {
            processed = this.moveCursorOverTag(false, false);
        } else if (s.equals(KEYSTROKE_SKIP_PREV_TOKEN_SEL)) {
            processed = this.moveCursorOverTag(true, false);
        } else if (s.equals(KEYSTROKE_SKIP_NEXT_TOKEN)) {
            processed = this.moveCursorOverTag(false, true);
        } else if (s.equals(KEYSTROKE_SKIP_NEXT_TOKEN_SEL)) {
            processed = this.moveCursorOverTag(true, true);
        } else if (s.equals(KEYSTROKE_TOGGLE_CURSOR_LOCK)) {
            boolean lockEnabled;
            this.lockCursorToInputArea = lockEnabled = !this.lockCursorToInputArea;
            this.updateLockInsertMessage();
        } else if (s.equals(KEYSTROKE_TOGGLE_OVERTYPE)) {
            processed = this.switchOvertypeMode();
            this.updateLockInsertMessage();
        }
        if (processed) {
            e.consume();
        } else {
            if ((e.getModifiersEx() & 0x380) == 0 && e.getKeyCode() != 16 && !this.isNavigationKey(e.getKeyCode())) {
                this.checkAndFixCaret(true);
            }
            super.processKeyEvent(e);
        }
        if (!processed && e.getKeyChar() != '\u0000' && this.isNavigationKey(e.getKeyCode())) {
            this.checkAndFixCaret(false);
            this.autoCompleter.updatePopup(true);
        }
    }

    private void updateLockInsertMessage() {
        String lock = OStrings.getString("MW_STATUS_CURSOR_LOCK_" + (this.lockCursorToInputArea ? "ON" : "OFF"));
        String ins = OStrings.getString("MW_STATUS_CURSOR_OVERTYPE_" + (this.overtypeMode ? "ON" : "OFF"));
        String lockTip = OStrings.getString("MW_STATUS_TIP_CURSOR_LOCK_" + (this.lockCursorToInputArea ? "ON" : "OFF"));
        String insTip = OStrings.getString("MW_STATUS_TIP_CURSOR_OVERTYPE_" + (this.overtypeMode ? "ON" : "OFF"));
        Core.getMainWindow().showLockInsertMessage(lock + " | " + ins, lockTip + " | " + insTip);
    }

    private boolean switchOvertypeMode() {
        boolean switchOvertypeMode;
        this.overtypeMode = switchOvertypeMode = !this.overtypeMode;
        if (this.overtypeMode) {
            this.setCaretColor(Styles.EditorColor.COLOR_BACKGROUND.getColor());
            this.putClientProperty("caretWidth", this.getCaretWidth());
            try {
                OvertypeCaret caret = (OvertypeCaret)this.getCaret();
                Rectangle r = Java8Compat.modelToView(this, caret.getDot());
                caret.damage(r);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            this.setCaretColor(Styles.EditorColor.COLOR_FOREGROUND.getColor());
            this.putClientProperty("caretWidth", 1);
        }
        return true;
    }

    private boolean isNavigationKey(int keycode) {
        switch (keycode) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                return true;
            }
        }
        return false;
    }

    boolean moveCursorOverTag(boolean withShift, boolean checkTagStart) {
        Document3 doc = this.getOmDocument();
        int caret = this.getCaretPosition();
        int start = doc.getTranslationStart();
        int end = doc.getTranslationEnd();
        if (caret < start || caret > end) {
            return false;
        }
        if (caret == start && !checkTagStart || caret == end && checkTagStart) {
            return false;
        }
        SourceTextEntry ste = doc.controller.getCurrentEntry();
        String text = doc.extractTranslation();
        int off = caret - start;
        if (ste != null) {
            for (ProtectedPart pp : ste.getProtectedParts()) {
                if (checkTagStart) {
                    if (!StringUtil.isSubstringAfter(text, off, pp.getTextInSourceSegment())) continue;
                    int pos = off + start + pp.getTextInSourceSegment().length();
                    if (withShift) {
                        this.getCaret().moveDot(pos);
                    } else {
                        this.getCaret().setDot(pos);
                    }
                    return true;
                }
                if (!StringUtil.isSubstringBefore(text, off, pp.getTextInSourceSegment())) continue;
                int pos = off + start - pp.getTextInSourceSegment().length();
                if (withShift) {
                    this.getCaret().moveDot(pos);
                } else {
                    this.getCaret().setDot(pos);
                }
                return true;
            }
        }
        return false;
    }

    boolean wholeTagDelete(boolean checkTagStart) throws BadLocationException {
        Document3 doc = this.getOmDocument();
        SourceTextEntry ste = doc.controller.getCurrentEntry();
        String text = doc.extractTranslation();
        int off = this.getCaretPosition() - doc.getTranslationStart();
        if (ste != null) {
            for (ProtectedPart pp : ste.getProtectedParts()) {
                if (checkTagStart) {
                    if (!StringUtil.isSubstringAfter(text, off, pp.getTextInSourceSegment())) continue;
                    int pos = off + doc.getTranslationStart();
                    doc.remove(pos, pp.getTextInSourceSegment().length());
                    return true;
                }
                if (!StringUtil.isSubstringBefore(text, off, pp.getTextInSourceSegment())) continue;
                int pos = off + doc.getTranslationStart() - pp.getTextInSourceSegment().length();
                doc.remove(pos, pp.getTextInSourceSegment().length());
                return true;
            }
        }
        return false;
    }

    boolean selectTag(int pos) {
        int s = this.controller.getSegmentIndexAtLocation(pos);
        if (s < 0) {
            return false;
        }
        SegmentBuilder segment = this.controller.m_docSegList[s];
        if (pos < segment.getStartPosition() || pos >= segment.getEndPosition()) {
            return false;
        }
        SourceTextEntry ste = this.getOmDocument().controller.getCurrentEntry();
        if (ste != null) {
            try {
                String text = this.getOmDocument().getText(segment.getStartPosition(), segment.getEndPosition() - segment.getStartPosition());
                int off = pos - segment.getStartPosition();
                if (off < 0 || off >= text.length()) {
                    return false;
                }
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    int p = -1;
                    while ((p = text.indexOf(pp.getTextInSourceSegment(), p + 1)) >= 0) {
                        if (p > off || off >= p + pp.getTextInSourceSegment().length()) continue;
                        this.select(p += segment.getStartPosition(), p + pp.getTextInSourceSegment().length());
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    void checkAndFixCaret() {
        this.checkAndFixCaret(true);
    }

    void checkAndFixCaret(boolean force) {
        if (!force && !this.lockCursorToInputArea) {
            return;
        }
        Document3 doc = this.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        int spos = this.getSelectionStart();
        int epos = this.getSelectionEnd();
        int start = doc.getTranslationStart();
        int end = doc.getTranslationEnd();
        if (spos != epos) {
            if (spos < start) {
                this.fixSelectionStart(start);
            } else if (spos > end) {
                this.fixSelectionStart(end);
            }
            if (epos > end) {
                this.fixSelectionEnd(end);
            } else if (epos < start) {
                this.fixSelectionStart(start);
            }
        } else if (spos < start) {
            this.setCaretPosition(start);
        } else if (spos > end) {
            this.setCaretPosition(end);
        }
    }

    private void fixSelectionStart(int start) {
        if (this.getCaretPosition() <= start) {
            this.setCaretPosition(this.getSelectionEnd());
            this.moveCaretPosition(start);
        } else {
            this.setSelectionStart(start);
        }
    }

    private void fixSelectionEnd(int end) {
        this.setSelectionEnd(end);
    }

    @Override
    public void paste() {
        this.checkAndFixCaret();
        super.paste();
    }

    @Override
    public void cut() {
        this.checkAndFixCaret();
        super.cut();
    }

    @Override
    public String getSelectedText() {
        String st = super.getSelectedText();
        return st != null ? EditorUtils.removeDirectionChars(st) : null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int pos = Java8Compat.viewToModel(this, event.getPoint());
        int s = this.controller.getSegmentIndexAtLocation(pos);
        return s < 0 ? null : this.controller.markerController.getToolTips(s, pos);
    }

    @Override
    public void replaceSelection(String content) {
        if (this.isEditable() && this.overtypeMode && this.getSelectionStart() == this.getSelectionEnd() && this.getCaretPosition() < this.getOmDocument().getTranslationEnd()) {
            int pos = this.getCaretPosition();
            int lastPos = Math.min(this.getDocument().getLength(), pos + content.length());
            this.select(pos, lastPos);
        }
        super.replaceSelection(content);
    }

    private int getCaretWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int carWidth = 1;
        try {
            carWidth = fm.stringWidth(this.getText(this.getCaretPosition(), 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return carWidth;
    }

    private class OvertypeCaret
    extends DefaultCaret {
        private OvertypeCaret() {
        }

        @Override
        public void paint(Graphics g) {
            if (EditorTextArea3.this.overtypeMode) {
                int caretWidth = EditorTextArea3.this.getCaretWidth();
                EditorTextArea3.this.putClientProperty("caretWidth", caretWidth);
                g.setXORMode(Styles.EditorColor.COLOR_FOREGROUND.getColor());
                g.translate(caretWidth / 2, 0);
                super.paint(g);
            } else {
                super.paint(g);
            }
        }

        @Override
        protected synchronized void damage(Rectangle r) {
            if (EditorTextArea3.this.overtypeMode) {
                if (r != null) {
                    int damageWidth = EditorTextArea3.this.getCaretWidth();
                    this.x = r.x - 4 - damageWidth / 2;
                    this.y = r.y;
                    this.width = 9 + 3 * damageWidth / 2;
                    this.height = r.height;
                    this.repaint();
                }
            } else {
                super.damage(r);
            }
        }
    }

    private static class PopupMenuConstructorInfo {
        final int priority;
        final IPopupMenuConstructor constructor;

        PopupMenuConstructorInfo(int priority, IPopupMenuConstructor constructor) {
            this.priority = priority;
            this.constructor = constructor;
        }
    }
}

