/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.bits.BitUtils;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.HashMap;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.MurmurHash;
import java.io.Serializable;
import java.util.Iterator;

final class ImplicitWordHashMap
implements Serializable,
HashMap {
    private static final long serialVersionUID = 1L;
    @Annotations.PrintMemoryCount
    final CustomWidthArray keys;
    @Annotations.PrintMemoryCount
    private final long[] wordRanges;
    private final HashNgramMap<?> ngramMap;
    private long numFilled = 0L;
    private static final int EMPTY_KEY = 0;
    private final int numWords;
    private final int ngramOrder;
    private final int totalNumWords;
    private final int maxNgramOrder;
    private final boolean fitsInInt;
    private final int numSuffixBits;

    public ImplicitWordHashMap(LongArray numNgramsForEachWord, long[] wordRanges, int ngramOrder, int maxNgramOrder, long numNgramsForPreviousOrder, int totalNumWords, HashNgramMap<?> ngramMap, boolean fitsInInt, boolean storeWords) {
        this.ngramOrder = ngramOrder;
        this.ngramMap = ngramMap;
        assert (ngramOrder >= 1);
        this.maxNgramOrder = maxNgramOrder;
        this.totalNumWords = totalNumWords;
        this.numWords = (int)numNgramsForEachWord.size();
        this.fitsInInt = fitsInInt;
        this.wordRanges = storeWords ? null : wordRanges;
        long totalNumNgrams = this.setWordRanges(numNgramsForEachWord, this.numWords);
        this.numSuffixBits = CustomWidthArray.numBitsNeeded(numNgramsForPreviousOrder + 1L);
        int numBitsHere = this.numSuffixBits + (storeWords ? CustomWidthArray.numBitsNeeded(totalNumWords) : 0);
        this.keys = new CustomWidthArray(totalNumNgrams, numBitsHere, numBitsHere + ngramMap.getValues().numValueBits(ngramOrder));
        this.keys.fill(0L, totalNumNgrams);
        this.numFilled = 0L;
    }

    @Override
    public long put(long key) {
        long i = this.linearSearch(key, true);
        if (this.keys.get(i) == 0L) {
            ++this.numFilled;
        }
        this.setKey(i, key);
        return i;
    }

    private long setWordRanges(LongArray numNgramsForEachWord, long numWords) {
        long currStart = 0L;
        int w = 0;
        while ((long)w < numWords) {
            if (this.wordRanges != null) {
                this.setWordRangeStart(w, currStart);
                currStart += this.ngramMap.getRangeSizeForWord(numNgramsForEachWord, w);
            } else {
                currStart += numNgramsForEachWord.get(w);
            }
            ++w;
        }
        return this.wordRanges == null ? Math.round((double)currStart * 1.0 / this.ngramMap.getLoadFactor()) : currStart;
    }

    private void setKey(long index, long putKey) {
        long contextOffset;
        long l = contextOffset = this.wordRanges == null ? this.shrinkKey(putKey) : this.ngramMap.contextOffsetOf(putKey);
        assert (contextOffset >= 0L);
        this.keys.set(index, contextOffset + 1L);
    }

    private final long shrinkKey(long key) {
        int word = this.ngramMap.wordOf(key);
        long suffixIndex = this.ngramMap.contextOffsetOf(key);
        return (long)word << this.numSuffixBits | suffixIndex;
    }

    private final long expandKey(long key) {
        int word = (int)(key >>> this.numSuffixBits);
        long suffixIndex = key & (1L << this.numSuffixBits) - 1L;
        return this.ngramMap.combineToKey(word, suffixIndex);
    }

    @Override
    public final long getOffset(long key) {
        return this.linearSearch(key, false);
    }

    private long linearSearch(long key, boolean returnFirstEmptyIndex) {
        long contextOffsetOf;
        int word = this.ngramMap.wordOf(key);
        if (word >= this.numWords) {
            return -1L;
        }
        long rangeStart = this.wordRangeStart(word);
        long rangeEnd = this.wordRangeEnd(word);
        long numHashPositions = rangeEnd - rangeStart;
        if (numHashPositions == 0L) {
            return -1L;
        }
        long startIndex = this.hash(key, numHashPositions, rangeStart);
        long l = contextOffsetOf = this.wordRanges == null ? this.shrinkKey(key) : this.ngramMap.contextOffsetOf(key);
        assert (contextOffsetOf >= 0L);
        assert (word >= 0);
        assert (startIndex >= rangeStart);
        assert (startIndex < rangeEnd);
        long index = this.keys.linearSearch(contextOffsetOf + 1L, rangeStart, rangeEnd, startIndex, 0L, returnFirstEmptyIndex);
        return index;
    }

    @Override
    public long getCapacity() {
        return this.keys.size();
    }

    @Override
    public double getLoadFactor() {
        return (double)this.numFilled / (double)this.getCapacity();
    }

    private long hash(long key, long numHashPositions, long startOfRange) {
        long hash = BitUtils.abs(MurmurHash.hashOneLong(key, -1756908916));
        return (hash %= numHashPositions) + startOfRange;
    }

    long getNextOffset(long offset) {
        return this.keys.get(offset) - 1L;
    }

    int getWordForContext(long contextOffset) {
        int binarySearch = this.binarySearch(contextOffset);
        int n = binarySearch = binarySearch >= 0 ? binarySearch : -binarySearch - 2;
        while (binarySearch < this.numWords - 1 && this.wordRangeStart(binarySearch) == this.wordRangeEnd(binarySearch)) {
            ++binarySearch;
        }
        return binarySearch;
    }

    private int binarySearch(long key) {
        int low = 0;
        int high = this.numWords - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.wordRangeStart(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public long getKey(long contextOffset) {
        return this.wordRanges == null ? this.expandKey(this.getNextOffset(contextOffset)) : this.ngramMap.combineToKey(this.getWordForContext(contextOffset), this.getNextOffset(contextOffset));
    }

    @Override
    public boolean isEmptyKey(long key) {
        return key == 0L;
    }

    @Override
    public long size() {
        return this.numFilled;
    }

    @Override
    public Iterable<Long> keys() {
        return Iterators.able(new KeyIterator(this.keys));
    }

    @Override
    public boolean hasContexts(int word) {
        if (word >= this.numWords) {
            return false;
        }
        long rangeStart = this.wordRangeStart(word);
        long rangeEnd = this.wordRangeEnd(word);
        return rangeEnd - rangeStart > 0L;
    }

    private final long wordRangeStart(int w) {
        return this.wordRanges == null ? 0L : this.wordRangeAt(w * this.maxNgramOrder + this.ngramOrder - 1);
    }

    private final long wordRangeEnd(int w) {
        return this.wordRanges == null || w == this.numWords - 1 ? this.getCapacity() : this.wordRangeAt((w + 1) * this.maxNgramOrder + this.ngramOrder - 1);
    }

    private long wordRangeAt(int logicalIndex) {
        if (this.fitsInInt) {
            return logicalIndex % 2 == 0 ? (long)BitUtils.getLowInt(this.wordRanges[logicalIndex / 2]) : (long)BitUtils.getHighInt(this.wordRanges[logicalIndex >> 1]);
        }
        return this.wordRanges[logicalIndex];
    }

    private void setWordRangeStart(int w, long currStart) {
        int logicalIndex = w * this.maxNgramOrder + this.ngramOrder - 1;
        if (this.fitsInInt) {
            this.wordRanges[logicalIndex / 2] = logicalIndex % 2 == 0 ? BitUtils.setLowInt(this.wordRanges[logicalIndex / 2], (int)currStart) : BitUtils.setHighInt(this.wordRanges[logicalIndex / 2], (int)currStart);
        } else {
            this.wordRanges[logicalIndex] = currStart;
        }
    }

    public static class KeyIterator
    implements Iterator<Long> {
        private final CustomWidthArray keys;
        private long next;
        private final long end;

        public KeyIterator(CustomWidthArray keys) {
            this.keys = keys;
            this.end = keys.size();
            this.next = -1L;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.end > 0L && this.next < this.end;
        }

        @Override
        public Long next() {
            long nextIndex = this.nextIndex();
            return nextIndex;
        }

        long nextIndex() {
            long curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && this.keys != null && this.keys.get(this.next) == 0L);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

