/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.concurrent.ConcurrentHashMap;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FuncallableStandardObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class EMFCache
extends LispObject {
    ConcurrentHashMap<CacheEntry, LispObject> cache = new ConcurrentHashMap();
    EqlSpecialization[] eqlSpecializations = new EqlSpecialization[0];
    private static final Primitive _MAKE_EMF_CACHE = new pf__make_emf_cache();
    private static final Primitive _REINIT_EMF_CACHE = new pf__reinit_emf_cache();
    private static final Primitive CACHE_EMF = new pf_cache_emf();
    private static final Primitive GET_CACHED_EMF = new pf_get_cached_emf();

    void clearCache() {
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public String printObject() {
        return this.unreadableString("EMF-CACHE");
    }

    static final FuncallableStandardObject checkStandardGenericFunction(LispObject obj) {
        if (obj instanceof FuncallableStandardObject) {
            return (FuncallableStandardObject)obj;
        }
        return (FuncallableStandardObject)Lisp.type_error(obj, Symbol.STANDARD_GENERIC_FUNCTION);
    }

    LispObject getArgSpecialization(LispObject arg) {
        for (EqlSpecialization eqlSpecialization : this.eqlSpecializations) {
            if (!eqlSpecialization.eqlTo.eql(arg)) continue;
            return eqlSpecialization;
        }
        return arg.classOf();
    }

    private static class EqlSpecialization
    extends LispObject {
        public LispObject eqlTo;

        public EqlSpecialization(LispObject eqlTo) {
            this.eqlTo = eqlTo;
        }
    }

    @DocString(name="%make-emf-cache")
    private static final class pf__make_emf_cache
    extends Primitive {
        pf__make_emf_cache() {
            super("%make-emf-cache", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return new EMFCache();
        }
    }

    @DocString(name="%reinit-emf-cache", args="generic-function eql-specilizer-objects-list")
    private static final class pf__reinit_emf_cache
    extends Primitive {
        pf__reinit_emf_cache() {
            super("%reinit-emf-cache", Lisp.PACKAGE_SYS, true, "generic-function eql-specializer-objects-list");
        }

        @Override
        public LispObject execute(LispObject generic_function, LispObject eql_specializers) {
            FuncallableStandardObject gf = EMFCache.checkStandardGenericFunction(generic_function);
            EMFCache cache = gf.cache;
            cache.clearCache();
            cache.eqlSpecializations = new EqlSpecialization[eql_specializers.length()];
            for (int i = 0; i < cache.eqlSpecializations.length; ++i) {
                cache.eqlSpecializations[i] = new EqlSpecialization(eql_specializers.car());
                eql_specializers = eql_specializers.cdr();
            }
            return Lisp.T;
        }
    }

    @DocString(name="cache-emf", args="generic-function args emf")
    private static final class pf_cache_emf
    extends Primitive {
        pf_cache_emf() {
            super("cache-emf", Lisp.PACKAGE_SYS, true, "generic-function args emf");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            FuncallableStandardObject gf = EMFCache.checkStandardGenericFunction(first);
            EMFCache cache = gf.cache;
            LispObject args = second;
            int numberOfRequiredArgs = gf.getInstanceSlotValue(Symbol.REQUIRED_ARGS).length();
            LispObject[] array = new LispObject[numberOfRequiredArgs];
            int i = numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = cache.getArgSpecialization(args.car());
                args = args.cdr();
            }
            CacheEntry specializations = new CacheEntry(array);
            ConcurrentHashMap<CacheEntry, LispObject> ht = cache.cache;
            ht.put(specializations, third);
            return third;
        }
    }

    @DocString(name="get-cached-emf", args="generic-function args")
    private static final class pf_get_cached_emf
    extends Primitive {
        pf_get_cached_emf() {
            super("get-cached-emf", Lisp.PACKAGE_SYS, true, "generic-function args");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            FuncallableStandardObject gf = EMFCache.checkStandardGenericFunction(first);
            EMFCache cache = gf.cache;
            LispObject args = second;
            int numberOfRequiredArgs = gf.getInstanceSlotValue(Symbol.REQUIRED_ARGS).length();
            LispObject[] array = new LispObject[numberOfRequiredArgs];
            int i = numberOfRequiredArgs;
            while (i-- > 0) {
                array[i] = cache.getArgSpecialization(args.car());
                args = args.cdr();
            }
            ConcurrentHashMap<CacheEntry, LispObject> ht = cache.cache;
            CacheEntry specializations = new CacheEntry(array);
            LispObject emf = ht.get(specializations);
            return emf != null ? emf : Lisp.NIL;
        }
    }

    private static class CacheEntry {
        final LispObject[] array;

        CacheEntry(LispObject[] array) {
            this.array = array;
        }

        public int hashCode() {
            int result = 0;
            int i = this.array.length;
            while (i-- > 0) {
                result ^= this.array[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheEntry)) {
                return false;
            }
            CacheEntry otherEntry = (CacheEntry)object;
            if (otherEntry.array.length != this.array.length) {
                return false;
            }
            LispObject[] otherArray = otherEntry.array;
            int i = this.array.length;
            while (i-- > 0) {
                if (this.array[i] == otherArray[i]) continue;
                return false;
            }
            return true;
        }
    }
}

