/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.util.DiskOptimizationStrategy;

public class SsdDiskOptimizationStrategy
implements DiskOptimizationStrategy {
    private final double diskOptimizationPageCrossChance;

    public SsdDiskOptimizationStrategy(double diskOptimizationPageCrossChance) {
        this.diskOptimizationPageCrossChance = diskOptimizationPageCrossChance;
    }

    @Override
    public int bufferSize(long recordSize) {
        double pageCrossProbability = (double)(recordSize % 4096L) / 4096.0;
        if (pageCrossProbability - this.diskOptimizationPageCrossChance > -1.0E-16) {
            recordSize += 4096L;
        }
        return this.roundBufferSize(recordSize);
    }
}

