/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.igoweb.util.swing.AutolinkTextPane;

public class TextLog
extends JScrollPane {
    private final DefaultStyledDocument doc;
    private final AutolinkTextPane textPane = new AutolinkTextPane();
    private final LinkedList<Position> messageBreaks;
    private final int maxMessages;
    private boolean viewAdjustAllowed = true;
    private int childScrollingCount = 0;
    private final SimpleAttributeSet[] attributes;

    public TextLog(SimpleAttributeSet[] attributes, int maxMessages) {
        super(22, 31);
        if (attributes == null) {
            attributes = new SimpleAttributeSet[]{TextLog.getBasicAttributeSet(false)};
        }
        this.attributes = attributes;
        this.maxMessages = maxMessages;
        this.setViewport(new ChatViewport());
        this.setViewportView(this.textPane);
        this.textPane.setEditable(false);
        this.textPane.setBackground(UIManager.getColor("org.igoweb.outputBg"));
        this.textPane.setParagraphAttributes(attributes[0], true);
        int fontH = UIManager.getInt("org.igoweb.fontH");
        this.setPreferredSize(new Dimension(fontH * 5, fontH * 2));
        this.doc = (DefaultStyledDocument)this.textPane.getDocument();
        this.messageBreaks = maxMessages == 0 ? null : new LinkedList();
        this.getVerticalScrollBar().setUnitIncrement(fontH);
        this.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (TextLog.this.childScrollingCount == 0) {
                    BoundedRangeModel model = TextLog.this.getVerticalScrollBar().getModel();
                    TextLog.this.viewAdjustAllowed = model.getValue() >= model.getMaximum() - model.getExtent();
                }
            }
        });
    }

    public void clear() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException excep) {
            throw new RuntimeException(excep.toString());
        }
        if (this.messageBreaks != null) {
            this.messageBreaks.clear();
        }
    }

    public void append(String message) {
        this.append(message, 0, true);
    }

    public void append(String message, int format, boolean autoNewline) {
        try {
            Position pos;
            if (this.messageBreaks != null && this.messageBreaks.size() >= this.maxMessages && (pos = this.messageBreaks.removeFirst()).getOffset() > 0) {
                this.doc.remove(0, pos.getOffset());
            }
            int messageOffset = this.doc.getLength();
            if (autoNewline && messageOffset > 0 && !this.doc.getText(messageOffset - 1, 1).equals("\n")) {
                this.doc.insertString(messageOffset, "\n", this.attributes[0]);
                messageOffset = this.doc.getLength();
            }
            this.textPane.getCaret().setDot(this.doc.getLength());
            this.doc.insertString(messageOffset, message, this.attributes[format]);
            if (this.messageBreaks != null) {
                this.messageBreaks.addLast(this.doc.createPosition(messageOffset));
            }
        }
        catch (BadLocationException excep) {
            throw new RuntimeException(excep.toString());
        }
    }

    public boolean isEmpty() {
        return this.doc.getLength() == 0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextLog.this.getVerticalScrollBar().setValue(TextLog.this.getVerticalScrollBar().getMaximum());
            }
        });
    }

    protected DefaultStyledDocument getDocument() {
        return this.doc;
    }

    protected AutolinkTextPane getTextPane() {
        return this.textPane;
    }

    public static SimpleAttributeSet getBasicAttributeSet(boolean indentAfterFirst) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs, "SansSerif");
        StyleConstants.setFontSize(attrs, UIManager.getFont("Label.font").getSize());
        if (indentAfterFirst) {
            try {
                int bugfixVers;
                int minorVers;
                int majorVers;
                block6: {
                    String javaVers = System.getProperty("java.version");
                    StringTokenizer versTok = new StringTokenizer(javaVers, ".");
                    majorVers = Integer.parseInt(versTok.nextToken());
                    minorVers = Integer.parseInt(versTok.nextToken());
                    String nvt = versTok.nextToken();
                    try {
                        bugfixVers = Integer.parseInt(nvt);
                    }
                    catch (Exception excep) {
                        bugfixVers = nvt.charAt(0) - 48;
                        if (bugfixVers <= 9) break block6;
                        bugfixVers = -1;
                    }
                }
                if (majorVers > 1 || majorVers == 1 && (minorVers > 4 || minorVers == 4 && bugfixVers > 0)) {
                    int size = UIManager.getInt("org.igoweb.fontH");
                    StyleConstants.setLeftIndent(attrs, size);
                    StyleConstants.setFirstLineIndent(attrs, -size);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attrs;
    }

    private class ChatViewport
    extends JViewport {
        @Override
        public void scrollRectToVisible(Rectangle contentRect) {
            if (TextLog.this.viewAdjustAllowed) {
                ++TextLog.this.childScrollingCount;
                try {
                    super.scrollRectToVisible(contentRect);
                }
                finally {
                    --TextLog.this.childScrollingCount;
                }
            }
        }

        @Override
        public void setViewSize(Dimension newSize) {
            ++TextLog.this.childScrollingCount;
            try {
                super.setViewSize(newSize);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void doLayout() {
            ++TextLog.this.childScrollingCount;
            try {
                super.doLayout();
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void resize(int w, int h) {
            ++TextLog.this.childScrollingCount;
            try {
                super.resize(w, h);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void resize(Dimension d) {
            ++TextLog.this.childScrollingCount;
            try {
                super.resize(d);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void setSize(Dimension d) {
            ++TextLog.this.childScrollingCount;
            try {
                super.setSize(d);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void setSize(int w, int h) {
            ++TextLog.this.childScrollingCount;
            try {
                super.setSize(w, h);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBounds(int x, int y, int w, int h) {
            ++TextLog.this.childScrollingCount;
            try {
                super.setBounds(x, y, w, h);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        @Override
        public void setBounds(Rectangle r) {
            ++TextLog.this.childScrollingCount;
            try {
                super.setBounds(r);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reshape(int x, int y, int w, int h) {
            ++TextLog.this.childScrollingCount;
            try {
                super.reshape(x, y, w, h);
            }
            finally {
                --TextLog.this.childScrollingCount;
            }
        }
    }
}

