/*****
 NAME
	cwidget.h - header file for CWidget class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(CWIDGET_H_INCLUDED)
#define CWIDGET_H_INCLUDED

#include <coconut/cobject.h>
#include <coconut/gtk/pwidget.h>

@interface CWidget : CObject <PWidget>
{
	widget_t	widget_type ;
	GtkWidget *	widget_ptr ;

	signal_t	clicked_event ;

	/* This object is not accessed by this class except releasing.
	   This object will be released when this class is released */
	id		user_object ;
}

+ (gfloat) alignToFloat: (align_t) dir ;
+ (align_t) floatToAlign: (gfloat) align ;

+ (align_t) justificationToAlign: (justification_t) just ;

- initWidget: (widget_t) type widget: (GtkWidget *) widget ;

@end

#define	WidgetObj2GtkWidget(wid) [(wid) widgetPtr]

#define	GtkWidget2WidgetObj(wid) \
  ((id <PWidget>) gtk_object_get_user_data(GTK_OBJECT(wid)))

#endif /* CWIDGET_H_INCLUDED */

