/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;
import org.apache.poi.ss.usermodel.DateUtil;

public class Days360
extends NumericFunction.TwoArg {
    protected double evaluate(double d0, double d1) throws EvaluationException {
        Calendar startingDate = this.getStartingDate(d0);
        Calendar endingDate = this.getEndingDateAccordingToStartingDate(d1, startingDate);
        long startingDay = startingDate.get(2) * 30 + startingDate.get(5);
        long endingDay = (endingDate.get(1) - startingDate.get(1)) * 360 + endingDate.get(2) * 30 + endingDate.get(5);
        return endingDay - startingDay;
    }

    private Calendar getDate(double date) {
        GregorianCalendar processedDate = new GregorianCalendar();
        processedDate.setTime(DateUtil.getJavaDate(date, false));
        return processedDate;
    }

    private Calendar getStartingDate(double date) {
        Calendar startingDate = this.getDate(date);
        if (this.isLastDayOfMonth(startingDate)) {
            startingDate.set(5, 30);
        }
        return startingDate;
    }

    private Calendar getEndingDateAccordingToStartingDate(double date, Calendar startingDate) {
        Calendar endingDate = this.getDate(date);
        endingDate.setTime(DateUtil.getJavaDate(date, false));
        if (this.isLastDayOfMonth(endingDate) && startingDate.get(5) < 30) {
            endingDate = this.getFirstDayOfNextMonth(endingDate);
        }
        return endingDate;
    }

    private boolean isLastDayOfMonth(Calendar date) {
        Calendar clone = (Calendar)date.clone();
        clone.add(2, 1);
        clone.add(5, -1);
        int lastDayOfMonth = clone.get(5);
        return date.get(5) == lastDayOfMonth;
    }

    private Calendar getFirstDayOfNextMonth(Calendar date) {
        Calendar newDate = (Calendar)date.clone();
        if (date.get(2) < 11) {
            newDate.set(2, date.get(2) + 1);
        } else {
            newDate.set(2, 1);
            newDate.set(1, date.get(1) + 1);
        }
        newDate.set(5, 1);
        return newDate;
    }
}

