/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.TextFormat;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Cursors;

public class RestSqlQueryAction
extends BaseRestHandler {
    public RestSqlQueryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/sql", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/sql", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        XContentType xContentType;
        SqlQueryRequest sqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            sqlRequest = SqlQueryRequest.fromXContent((XContentParser)parser);
        }
        String accept = request.param("format");
        if (accept == null && "*/*".equals(accept = request.header("Accept"))) {
            accept = null;
        }
        if (accept == null) {
            accept = request.header("Content-Type");
        }
        assert (accept != null) : "The Content-Type header is required";
        XContentType xContentType2 = xContentType = accept == null ? XContentType.JSON : XContentType.fromMediaTypeOrFormat((String)accept);
        if (xContentType != null) {
            return channel -> client.execute((Action)SqlQueryAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new RestResponseListener<SqlQueryResponse>(channel){

                public RestResponse buildResponse(SqlQueryResponse response) throws Exception {
                    XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());
                    response.toXContent(builder, (ToXContent.Params)request);
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
        }
        final TextFormat textFormat = TextFormat.fromMediaTypeOrFormat(accept);
        final long startNanos = System.nanoTime();
        return channel -> client.execute((Action)SqlQueryAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new RestResponseListener<SqlQueryResponse>(channel){

            public RestResponse buildResponse(SqlQueryResponse response) throws Exception {
                Cursor cursor = Cursors.decodeFromString(sqlRequest.cursor());
                String data = textFormat.format(cursor, request, response);
                BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, textFormat.contentType(request), data.getBytes(StandardCharsets.UTF_8));
                Cursor responseCursor = textFormat.wrapCursor(cursor, response);
                if (responseCursor != Cursor.EMPTY) {
                    restResponse.addHeader("Cursor", Cursors.encodeToString(Version.CURRENT, responseCursor));
                }
                restResponse.addHeader("Took-nanos", Long.toString(System.nanoTime() - startNanos));
                return restResponse;
            }
        });
    }

    public String getName() {
        return "xpack_sql_query_action";
    }
}

