/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class UpdateJobProcessNotifier {
    private static final Logger logger = LogManager.getLogger(UpdateJobProcessNotifier.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final LinkedBlockingQueue<UpdateHolder> orderedJobUpdates = new LinkedBlockingQueue(1000);
    private volatile Scheduler.Cancellable cancellable;

    public UpdateJobProcessNotifier(Client client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStart() {
                UpdateJobProcessNotifier.this.start();
            }

            public void beforeStop() {
                UpdateJobProcessNotifier.this.stop();
            }
        });
    }

    boolean submitJobUpdate(UpdateParams update, ActionListener<Boolean> listener) {
        return this.orderedJobUpdates.offer(new UpdateHolder(update, listener));
    }

    private void start() {
        this.cancellable = this.threadPool.scheduleWithFixedDelay(this::processNextUpdate, TimeValue.timeValueSeconds((long)1L), "generic");
    }

    private void stop() {
        this.orderedJobUpdates.clear();
        Scheduler.Cancellable cancellable = this.cancellable;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    private void processNextUpdate() {
        ArrayList updates = new ArrayList(this.orderedJobUpdates.size());
        try {
            this.orderedJobUpdates.drainTo(updates);
            this.executeProcessUpdates(new VolatileCursorIterator<UpdateHolder>(updates));
        }
        catch (Exception e) {
            logger.error("Error while processing next job update", (Throwable)e);
        }
    }

    void executeProcessUpdates(final Iterator<UpdateHolder> updatesIterator) {
        if (!updatesIterator.hasNext()) {
            return;
        }
        final UpdateHolder updateHolder = updatesIterator.next();
        final UpdateParams update = updateHolder.update;
        if (update.isJobUpdate() && !this.clusterService.localNode().isMasterNode()) {
            assert (this.clusterService.localNode().isMasterNode());
            logger.error("Job update was submitted to non-master node [" + this.clusterService.getNodeName() + "]; update for job [" + update.getJobId() + "] will be ignored");
            this.executeProcessUpdates(updatesIterator);
            return;
        }
        UpdateProcessAction.Request request = new UpdateProcessAction.Request(update.getJobId(), update.getModelPlotConfig(), update.getDetectorUpdates(), update.getFilter(), update.isUpdateScheduledEvents());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateProcessAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<UpdateProcessAction.Response>(){

            public void onResponse(UpdateProcessAction.Response response) {
                if (response.isUpdated()) {
                    logger.info("Successfully updated remote job [{}]", (Object)update.getJobId());
                    updateHolder.listener.onResponse((Object)true);
                } else {
                    String msg = "Failed to update remote job [" + update.getJobId() + "]";
                    logger.error(msg);
                    updateHolder.listener.onFailure((Exception)ExceptionsHelper.serverError((String)msg));
                }
                UpdateJobProcessNotifier.this.executeProcessUpdates(updatesIterator);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    logger.debug("Remote job [{}] not updated as it has been deleted", (Object)update.getJobId());
                } else if (e.getMessage().contains("because job [" + update.getJobId() + "] is not open") && e instanceof ElasticsearchStatusException) {
                    logger.debug("Remote job [{}] not updated as it is no longer open", (Object)update.getJobId());
                } else {
                    logger.error("Failed to update remote job [" + update.getJobId() + "]", (Throwable)e);
                }
                updateHolder.listener.onFailure(e);
                UpdateJobProcessNotifier.this.executeProcessUpdates(updatesIterator);
            }
        });
    }

    private static class UpdateHolder {
        private final UpdateParams update;
        private final ActionListener<Boolean> listener;

        private UpdateHolder(UpdateParams update, ActionListener<Boolean> listener) {
            this.update = update;
            this.listener = listener;
        }
    }
}

