/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;

public class FIPS140SecureSettingsBootstrapCheck
implements BootstrapCheck {
    private final boolean fipsModeEnabled;
    private final Environment environment;

    FIPS140SecureSettingsBootstrapCheck(Settings settings, Environment environment) {
        this.fipsModeEnabled = (Boolean)XPackSettings.FIPS_MODE_ENABLED.get(settings);
        this.environment = environment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (!this.fipsModeEnabled) return BootstrapCheck.BootstrapCheckResult.success();
        try (KeyStoreWrapper secureSettings = KeyStoreWrapper.load((Path)this.environment.configFile());){
            if (secureSettings == null) return BootstrapCheck.BootstrapCheckResult.success();
            if (secureSettings.getFormatVersion() >= 3) return BootstrapCheck.BootstrapCheckResult.success();
            BootstrapCheck.BootstrapCheckResult bootstrapCheckResult = BootstrapCheck.BootstrapCheckResult.failure((String)"Secure settings store is not of the appropriate version. Please use bin/elasticsearch-keystore create to generate a new secure settings store and migrate the secure settings there.");
            return bootstrapCheckResult;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean alwaysEnforce() {
        return this.fipsModeEnabled;
    }
}

