/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserResponse;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportDeleteUserAction
extends HandledTransportAction<DeleteUserRequest, DeleteUserResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;

    @Inject
    public TransportDeleteUserAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteUserRequest::new);
        this.settings = settings;
        this.usersStore = usersStore;
    }

    protected void doExecute(DeleteUserRequest request, final ActionListener<DeleteUserResponse> listener) {
        String username = request.username();
        if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
            if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
                listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be deleted"));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is reserved and cannot be deleted"));
            return;
        }
        if ("_system".equals(username) || "_xpack".equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        this.usersStore.deleteUser(request, new ActionListener<Boolean>(){

            public void onResponse(Boolean found) {
                listener.onResponse((Object)new DeleteUserResponse(found.booleanValue()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

