/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class CopyExecutionStateStep
extends ClusterStateActionStep {
    public static final String NAME = "copy-execution-state";
    private static final Logger logger = LogManager.getLogger(CopyExecutionStateStep.class);
    private String shrunkIndexPrefix;

    public CopyExecutionStateStep(Step.StepKey key, Step.StepKey nextStepKey, String shrunkIndexPrefix) {
        super(key, nextStepKey);
        this.shrunkIndexPrefix = shrunkIndexPrefix;
    }

    String getShrunkIndexPrefix() {
        return this.shrunkIndexPrefix;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        String indexName = indexMetaData.getIndex().getName();
        String targetIndexName = this.shrunkIndexPrefix + indexName;
        IndexMetaData targetIndexMetaData = clusterState.metaData().index(targetIndexName);
        if (targetIndexMetaData == null) {
            logger.warn("[{}] index [{}] unable to copy execution state to target index [{}] as target index does not exist", (Object)this.getKey().getAction(), (Object)index.getName(), (Object)targetIndexName);
            throw new IllegalStateException("unable to copy execution state from [" + index.getName() + "] to [" + targetIndexName + "] as target index does not exist");
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetaData);
        String phase = lifecycleState.getPhase();
        String action = lifecycleState.getAction();
        long lifecycleDate = lifecycleState.getLifecycleDate();
        LifecycleExecutionState.Builder relevantTargetCustomData = LifecycleExecutionState.builder();
        relevantTargetCustomData.setIndexCreationDate(lifecycleDate);
        relevantTargetCustomData.setPhase(phase);
        relevantTargetCustomData.setAction(action);
        relevantTargetCustomData.setStep("is-shrunken-index");
        MetaData.Builder newMetaData = MetaData.builder((MetaData)clusterState.getMetaData()).put(IndexMetaData.builder((IndexMetaData)targetIndexMetaData).putCustom("ilm", relevantTargetCustomData.build().asMap()));
        return ClusterState.builder((ClusterState)clusterState).metaData(newMetaData).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyExecutionStateStep that = (CopyExecutionStateStep)o;
        return Objects.equals(this.shrunkIndexPrefix, that.shrunkIndexPrefix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shrunkIndexPrefix);
    }
}

