.TH FBEDGE 1 25-Jun-90
.CM 3
.SH NAME
fbedge \- compute the derivative of an image (edge detection)
.SH SYNOPSIS
.nf
fbedge [ -t<threshhold> ] [ -<type> ] < bitmap > bitmap
.fi
.SH DESCRIPTION
.PP
Computes a halftoned image composed of edges in the original.  Edge
detection is done by digital Laplacian.
.SO OPTIONS
.TP
.B -t<num>
.I threshhold
argument, specifies a threshhold for detecting edges.  Pixels with
first derivatives greater than the threshhold will be black, and others
will be white.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
To produce an image of regions in a grayscale image where the first
derivative is greater than 10, and output the result as a Sun
rasterfile:
.sp
    % fbedge -t10 -S < foo.gray > foo.1bit
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Gary Sherwin & Michael Mauldin.
Permission is granted to use this file in whole or in part for
any purpose, educational, recreational or commercial, provided
that this copyright notice is retained unchanged.  This software
is available to all free of charge by anonymous FTP and in the
UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
