/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;

public class TileImprovementStyle {
    private static final Map<String, TileImprovementStyle> cache = new HashMap<String, TileImprovementStyle>();
    private final String style;
    private final String mask;

    private TileImprovementStyle(String style) {
        char c;
        this.style = style;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < style.length() && Character.digit(c = style.charAt(i), 36) >= 0; ++i) {
            sb.append(c == '0' ? "0" : "1");
        }
        this.mask = sb.toString();
    }

    public String getString() {
        return this.style;
    }

    public String getMask() {
        return this.mask;
    }

    public static String decodeOldStyle(String input, int pad) {
        if (pad <= 0) {
            return null;
        }
        boolean isZero = true;
        StringBuilder sb = new StringBuilder();
        try {
            int value = Integer.parseInt(input);
            for (int index = 0; index < 4; ++index) {
                int magnitude = value % 3;
                isZero &= magnitude == 0;
                sb.append(Integer.toString(magnitude, 36));
                value /= 3;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (isZero) {
            return null;
        }
        while (sb.length() < pad) {
            sb.append("0");
        }
        return sb.toString();
    }

    public static TileImprovementStyle getInstance(String key) {
        if (key == null || key.isEmpty() || "0".equals(key)) {
            return null;
        }
        TileImprovementStyle result = cache.get(key);
        if (result == null) {
            result = new TileImprovementStyle(key);
            cache.put(key, result);
            if (!result.getString().equals(key)) {
                cache.put(result.getString(), result);
            }
        }
        return result;
    }

    public String toString() {
        return this.style;
    }
}

