/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MinMaxCalculator {
    public static final Log LOG = LogFactory.getLog(MinMaxCalculator.class);

    public static double compute(double[] values, double[] labels) {
        return MinMaxCalculator.compute(values, labels, 1);
    }

    public static double compute(double[] values, double[] labels, int k) {
        DoubleArrayList positiveLabelValues = new DoubleArrayList();
        DoubleArrayList negativeLabelValues = new DoubleArrayList();
        int index = 0;
        for (double label : labels) {
            DoubleArrayList list = label == 0.0 ? negativeLabelValues : positiveLabelValues;
            list.add(values[index]);
            ++index;
        }
        Collections.sort(positiveLabelValues);
        Collections.sort(negativeLabelValues);
        double[] negativeValues = negativeLabelValues.toDoubleArray();
        double[] positiveValues = positiveLabelValues.toDoubleArray();
        double minL0 = MinMaxCalculator.minOverSortedArray(negativeValues, k);
        double maxL0 = MinMaxCalculator.maxOverSortedArray(negativeValues, k);
        double minL1 = MinMaxCalculator.minOverSortedArray(positiveValues, k);
        double maxL1 = MinMaxCalculator.maxOverSortedArray(positiveValues, k);
        double numerator = Math.abs(maxL1 - minL0);
        double denominator = Math.abs(minL1 - maxL0);
        if (denominator == 0.0) {
            if (numerator == denominator) {
                return 1.0;
            }
            LOG.warn((Object)("Cannot evaluate min/max statistics, zero denominator for numerator= " + numerator));
        }
        return numerator / denominator;
    }

    private static double maxOverSortedArray(double[] negativeValues) {
        return MinMaxCalculator.maxOverSortedArray(negativeValues, 1);
    }

    private static double minOverSortedArray(double[] negativeValues) {
        return MinMaxCalculator.minOverSortedArray(negativeValues, 1);
    }

    private static double maxOverSortedArray(double[] array, int k) {
        double sum = 0.0;
        int count = 0;
        if (k > array.length) {
            k = array.length;
        }
        for (int i = array.length - k; i < array.length; ++i) {
            sum += array[i];
            ++count;
        }
        assert (count == k);
        return sum / (double)count;
    }

    private static double minOverSortedArray(double[] array, int k) {
        double sum = 0.0;
        int count = 0;
        if (k > array.length) {
            k = array.length;
        }
        for (int i = 0; i < k; ++i) {
            sum += array[i];
            ++count;
        }
        assert (count == k);
        return sum / (double)count;
    }

    public static void main(String[] args) {
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] labels = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        System.out.println("min/max " + MinMaxCalculator.compute(values, labels, 1));
    }
}

