/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.shuffleboth;

import free.chess.Position;
import free.chess.variants.BothSidesCastlingVariant;

public class ShuffleBoth
extends BothSidesCastlingVariant {
    private static final ShuffleBoth INSTANCE = new ShuffleBoth();

    public static ShuffleBoth getInstance() {
        return INSTANCE;
    }

    private ShuffleBoth() {
        super("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Shuffle both");
    }

    public void init(Position position) {
        this.checkPosition(position);
        position.setFEN(ShuffleBoth.createRandomInitialFEN());
    }

    private static String createRandomInitialFEN() {
        String string = ShuffleBoth.createRandomPieceRow();
        String string2 = ShuffleBoth.createRandomPieceRow().toLowerCase();
        return string2 + "/pppppppp/8/8/8/8/PPPPPPPP/" + string + " w KQkq - 0 1";
    }

    private static String createRandomPieceRow() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("R------R");
        stringBuffer.setCharAt(ShuffleBoth.randomBoolean() ? 3 : 4, 'K');
        while ((n = ShuffleBoth.randomInt(6) + 1) % 2 != 0 || stringBuffer.charAt(n) != '-') {
        }
        stringBuffer.setCharAt(n, 'B');
        while ((n = ShuffleBoth.randomInt(6) + 1) % 2 != 1 || stringBuffer.charAt(n) != '-') {
        }
        stringBuffer.setCharAt(n, 'B');
        while (stringBuffer.charAt(n = ShuffleBoth.randomInt(6) + 1) != '-') {
        }
        stringBuffer.setCharAt(n, 'Q');
        for (n = 1; n < 7; ++n) {
            if (stringBuffer.charAt(n) != '-') continue;
            stringBuffer.setCharAt(n, 'N');
        }
        return stringBuffer.toString();
    }

    private static boolean randomBoolean() {
        return (Double.doubleToLongBits(Math.random()) & 0x1000000L) == 0L;
    }

    private static int randomInt(int n) {
        return (int)(Math.random() * (double)n);
    }
}

