/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Function;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;

public enum HttpHeaderValue {
    CLOSE("close"),
    CHUNKED("chunked"),
    GZIP("gzip"),
    IDENTITY("identity"),
    KEEP_ALIVE("keep-alive"),
    CONTINUE("100-continue"),
    PROCESSING("102-processing"),
    TE("TE"),
    BYTES("bytes"),
    NO_CACHE("no-cache"),
    UPGRADE("Upgrade");

    public static final Index<HttpHeaderValue> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private static final EnumSet<HttpHeader> __known;

    private HttpHeaderValue(String s2) {
        this._string = s2;
        this._buffer = BufferUtil.toBuffer(s2);
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public boolean is(String s2) {
        return this._string.equalsIgnoreCase(s2);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    public static boolean hasKnownValues(HttpHeader header) {
        if (header == null) {
            return false;
        }
        return __known.contains((Object)header);
    }

    public static boolean parseCsvIndex(String value2, Function<HttpHeaderValue, Boolean> found) {
        return HttpHeaderValue.parseCsvIndex(value2, found, null);
    }

    public static boolean parseCsvIndex(String value2, Function<HttpHeaderValue, Boolean> found, Function<String, Boolean> unknown) {
        if (StringUtil.isBlank(value2)) {
            return true;
        }
        int next = 0;
        block4: while (next < value2.length()) {
            HttpHeaderValue token = CACHE.getBest(value2, next, value2.length() - next);
            if (token != null) {
                int i = next + token.toString().length();
                block5: while (true) {
                    if (i >= value2.length()) {
                        return found.apply(token);
                    }
                    switch (value2.charAt(i)) {
                        case ',': {
                            if (!found.apply(token).booleanValue()) {
                                return false;
                            }
                            next = i + 1;
                            continue block4;
                        }
                        case ' ': {
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++i;
                }
            }
            if (' ' == value2.charAt(next)) {
                ++next;
                continue;
            }
            int comma = value2.indexOf(44, next);
            if (comma == next) {
                ++next;
                continue;
            }
            if (comma > next) {
                if (unknown == null) {
                    next = comma + 1;
                    continue;
                }
                String v = value2.substring(next, comma).trim();
                if (StringUtil.isBlank(v) || unknown.apply(v).booleanValue()) {
                    next = comma + 1;
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    static {
        CACHE = new Index.Builder().caseSensitive(false).withAll(HttpHeaderValue.values(), HttpHeaderValue::toString).build();
        __known = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.CONTENT_ENCODING);
    }
}

