/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.DataSize;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/CongestionWindowPushbackController;", "", "<init>", "()V", "updateOutstandingData", "", "outstandingBytes", "", "updatePacingQueue", "pacingBytes", "updateTargetBitrate", "", "bitrateBps", "setDataWindow", "dataWindow", "Lorg/jitsi/nlj/util/DataSize;", "addPacing", "", "minPushbackTargetBitrateBps", "currentDataWindow", "encodingRateRatio", "", "jitsi-media-transform"})
public final class CongestionWindowPushbackController {
    private final boolean addPacing;
    private final int minPushbackTargetBitrateBps;
    @Nullable
    private DataSize currentDataWindow;
    private long outstandingBytes;
    private long pacingBytes;
    private double encodingRateRatio = 1.0;

    public CongestionWindowPushbackController() {
        this.minPushbackTargetBitrateBps = 30000;
    }

    public final void updateOutstandingData(long outstandingBytes) {
        this.outstandingBytes = outstandingBytes;
    }

    public final void updatePacingQueue(long pacingBytes) {
        this.pacingBytes = pacingBytes;
    }

    public final int updateTargetBitrate(int bitrateBps) {
        if (this.currentDataWindow == null || Intrinsics.areEqual(this.currentDataWindow, DataSize.Companion.getZERO())) {
            return bitrateBps;
        }
        long totalBytes = this.outstandingBytes;
        if (this.addPacing) {
            totalBytes += this.pacingBytes;
        }
        DataSize dataSize = this.currentDataWindow;
        Intrinsics.checkNotNull(dataSize);
        long fillRatio = totalBytes / (long)dataSize.getBytes();
        if ((double)fillRatio > 1.5) {
            this.encodingRateRatio *= 0.9;
        } else if ((double)fillRatio > 1.0) {
            this.encodingRateRatio *= 0.95;
        } else if ((double)fillRatio < 0.1) {
            this.encodingRateRatio = 1.0;
        } else {
            this.encodingRateRatio *= 1.05;
            this.encodingRateRatio = Math.min(this.encodingRateRatio, 1.0);
        }
        int adjustedTargetBitrateBps = (int)((double)bitrateBps * this.encodingRateRatio);
        return adjustedTargetBitrateBps < this.minPushbackTargetBitrateBps ? Math.min(bitrateBps, this.minPushbackTargetBitrateBps) : adjustedTargetBitrateBps;
    }

    public final void setDataWindow(@NotNull DataSize dataWindow) {
        Intrinsics.checkNotNullParameter(dataWindow, "dataWindow");
        this.currentDataWindow = dataWindow;
    }
}

