/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.opensolaris.opengrok.Info;

public final class FileLogFormatter
extends Formatter {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSSZ");
    private static final String lineSeparator = System.getProperty("line.separator");

    private String ts(Date date) {
        return this.formatter.format(date);
    }

    private String classNameOnly(String name) {
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append("[#|");
        sb.append(this.ts(new Date(record.getMillis())));
        sb.append(" |");
        String loglevel = record.getLevel().getName();
        sb.append(loglevel);
        sb.append("|");
        sb.append("V");
        sb.append(Info.getVersion());
        sb.append("|OG|");
        sb.append("T=");
        sb.append(record.getThreadID());
        sb.append("| ");
        sb.append(this.classNameOnly(record.getSourceClassName()));
        sb.append('.');
        sb.append(this.formatMessage(record));
        sb.append(": ");
        sb.append(record.getMessage());
        Throwable thrown = record.getThrown();
        if (null != thrown && record.getLevel().intValue() < Level.CONFIG.intValue()) {
            sb.append(lineSeparator);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            thrown.printStackTrace(new PrintStream(ba, true));
            sb.append(ba.toString());
        }
        sb.append(" |#]");
        sb.append(lineSeparator);
        return sb.toString();
    }
}

