/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.CompatibleAnalyser;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.index.IndexDatabase;
import org.opensolaris.opengrok.search.SearchEngine;

public class DirectoryHistoryReader {
    private final Map<Date, Map<String, Map<String, SortedSet<String>>>> hash = new LinkedHashMap<Date, Map<String, Map<String, SortedSet<String>>>>();
    Iterator<Date> diter;
    Date idate;
    Iterator<String> aiter;
    String iauthor;
    Iterator<String> citer;
    String icomment;
    HistoryEntry currentEntry;
    History history;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryHistoryReader(String path) throws IOException {
        int hitsPerPage = RuntimeEnvironment.getInstance().getHitsPerPage();
        int cachePages = RuntimeEnvironment.getInstance().getCachePages();
        IndexReader ireader = null;
        try {
            String src_root = RuntimeEnvironment.getInstance().getSourceRootPath();
            ireader = IndexDatabase.getIndexReader(path);
            if (ireader == null) {
                throw new IOException("Could not locate index database");
            }
            IndexSearcher searcher = new IndexSearcher(ireader);
            SortField sfield = new SortField("date", SortField.Type.STRING, true);
            Sort sort = new Sort(sfield);
            QueryParser qparser = new QueryParser(SearchEngine.LUCENE_VERSION, "path", (Analyzer)new CompatibleAnalyser());
            ScoreDoc[] hits = null;
            try {
                Query query = qparser.parse(path);
                TopFieldDocs fdocs = searcher.search(query, null, hitsPerPage * cachePages, sort);
                fdocs = searcher.search(query, null, fdocs.totalHits, sort);
                hits = fdocs.scoreDocs;
            }
            catch (ParseException e) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while parsing search query", e);
            }
            if (hits != null) {
                for (int i = 0; i < 40 && i < hits.length; ++i) {
                    Date cdate;
                    int docId = hits[i].doc;
                    Document doc = searcher.doc(docId);
                    String rpath = doc.get("path");
                    if (!rpath.startsWith(path)) continue;
                    try {
                        cdate = DateTools.stringToDate((String)doc.get("date"));
                    }
                    catch (java.text.ParseException ex) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Could not get date for " + path, ex);
                        cdate = new Date();
                    }
                    int ls = rpath.lastIndexOf(47);
                    if (ls == -1) continue;
                    String rparent = rpath.substring(0, ls);
                    String rbase = rpath.substring(ls + 1);
                    History hist = null;
                    try {
                        File f = new File(src_root + rparent, rbase);
                        hist = HistoryGuru.getInstance().getHistory(f);
                    }
                    catch (HistoryException e) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while getting history reader", e);
                    }
                    if (hist == null) {
                        this.put(cdate, "-", "", rpath);
                        continue;
                    }
                    this.readFromHistory(hist, rpath);
                }
            }
            ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
            while (this.next()) {
                entries.add(this.currentEntry);
            }
            this.history = new History(entries);
        }
        finally {
            if (ireader != null) {
                try {
                    ireader.close();
                }
                catch (Exception ex) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while closing reader", ex);
                }
            }
        }
    }

    public History getHistory() {
        return this.history;
    }

    private void put(Date date, String author, String comment, String path) {
        SortedSet<String> fls;
        Map<String, SortedSet<String>> cf;
        long time = date.getTime();
        date.setTime(time - time % 3600000L);
        Map<String, Map<String, SortedSet<String>>> ac = this.hash.get(date);
        if (ac == null) {
            ac = new HashMap<String, Map<String, SortedSet<String>>>();
            this.hash.put(date, ac);
        }
        if ((cf = ac.get(author)) == null) {
            cf = new HashMap<String, SortedSet<String>>();
            ac.put(author, cf);
        }
        if ((fls = cf.get(comment)) == null) {
            fls = new TreeSet<String>();
            cf.put(comment, fls);
        }
        fls.add(path);
    }

    private boolean next() throws IOException {
        if (this.diter == null) {
            this.diter = this.hash.keySet().iterator();
        }
        if (this.citer == null || !this.citer.hasNext()) {
            if (this.aiter == null || !this.aiter.hasNext()) {
                if (this.diter.hasNext()) {
                    this.idate = this.diter.next();
                    this.aiter = this.hash.get(this.idate).keySet().iterator();
                } else {
                    return false;
                }
            }
            this.iauthor = this.aiter.next();
            this.citer = this.hash.get(this.idate).get(this.iauthor).keySet().iterator();
        }
        this.icomment = this.citer.next();
        this.currentEntry = new HistoryEntry(null, this.idate, this.iauthor, null, this.icomment, true);
        return true;
    }

    private void readFromHistory(History hist, String rpath) {
        for (HistoryEntry entry : hist.getHistoryEntries()) {
            if (!entry.isActive()) continue;
            String comment = entry.getMessage();
            String cauthor = entry.getAuthor();
            Date cdate = entry.getDate();
            this.put(cdate, cauthor, comment, rpath);
            break;
        }
    }
}

