require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_PARAM_H_)) {
    eval 'sub _AARCH64_PARAM_H_ () {1;}' unless defined(&_AARCH64_PARAM_H_);
    if(defined(&__aarch64__)) {
	if(defined(&_KERNEL_OPT)) {
	    require './aarch64/opt_cputypes.ph';
	    require './aarch64/opt_param.ph';
	}
	if(defined(&_KERNEL)) {
	    unless(defined(&MACHINE_ARCH)) {
		if(defined(&__AARCH64EB__)) {
		    eval 'sub _MACHINE_ARCH () { &aarch64eb;}' unless defined(&_MACHINE_ARCH);
		    eval 'sub MACHINE_ARCH () {"aarch64eb";}' unless defined(&MACHINE_ARCH);
		    eval 'sub _MACHINE32_ARCH () { &earmv7hfeb;}' unless defined(&_MACHINE32_ARCH);
		    eval 'sub MACHINE32_ARCH () {"earmv7hfeb";}' unless defined(&MACHINE32_ARCH);
		} else {
		    eval 'sub _MACHINE_ARCH () { &aarch64;}' unless defined(&_MACHINE_ARCH);
		    eval 'sub MACHINE_ARCH () {"aarch64";}' unless defined(&MACHINE_ARCH);
		    eval 'sub _MACHINE32_ARCH () { &earmv7hf;}' unless defined(&_MACHINE32_ARCH);
		    eval 'sub MACHINE32_ARCH () {"earmv7hf";}' unless defined(&MACHINE32_ARCH);
		}
	    }
	} else {
	    undef(&_MACHINE) if defined(&_MACHINE);
	    undef(&MACHINE) if defined(&MACHINE);
	    undef(&_MACHINE_ARCH) if defined(&_MACHINE_ARCH);
	    undef(&MACHINE_ARCH) if defined(&MACHINE_ARCH);
	    undef(&_MACHINE32_ARCH) if defined(&_MACHINE32_ARCH);
	    undef(&MACHINE32_ARCH) if defined(&MACHINE32_ARCH);
	    eval 'sub _MACHINE () { &aarch64;}' unless defined(&_MACHINE);
	    eval 'sub MACHINE () {"aarch64";}' unless defined(&MACHINE);
	    if(defined(&__AARCH64EB__)) {
		eval 'sub _MACHINE_ARCH () { &aarch64eb;}' unless defined(&_MACHINE_ARCH);
		eval 'sub MACHINE_ARCH () {"aarch64eb";}' unless defined(&MACHINE_ARCH);
		eval 'sub _MACHINE32_ARCH () { &earmv7hfeb;}' unless defined(&_MACHINE32_ARCH);
		eval 'sub MACHINE32_ARCH () {"earmv7hfeb";}' unless defined(&MACHINE32_ARCH);
	    } else {
		eval 'sub _MACHINE_ARCH () { &aarch64;}' unless defined(&_MACHINE_ARCH);
		eval 'sub MACHINE_ARCH () {"aarch64";}' unless defined(&MACHINE_ARCH);
		eval 'sub _MACHINE32_ARCH () { &earmv7hf;}' unless defined(&_MACHINE32_ARCH);
		eval 'sub MACHINE32_ARCH () {"earmv7hf";}' unless defined(&MACHINE32_ARCH);
	    }
	}
	eval 'sub MID_MACHINE () { &MID_AARCH64;}' unless defined(&MID_MACHINE);
	eval 'sub STACK_ALIGNBYTES () {(16- 1);}' unless defined(&STACK_ALIGNBYTES);
	eval 'sub ALIGNBYTES32 () {(8- 1);}' unless defined(&ALIGNBYTES32);
	eval 'sub ALIGN32 {
	    my($p) = @_;
    	    eval q(((( &uintptr_t)($p) +  &ALIGNBYTES32) & ~ &ALIGNBYTES32));
	}' unless defined(&ALIGN32);
	eval 'sub NKMEMPAGES_MIN_DEFAULT () {((128 * 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
	eval 'sub NKMEMPAGES_MAX_UNLIMITED () {1;}' unless defined(&NKMEMPAGES_MAX_UNLIMITED);
	if(defined(&AARCH64_PAGE_SHIFT)) {
	    if((1<< (defined(&AARCH64_PAGE_SHIFT) ? &AARCH64_PAGE_SHIFT : undef)) & ~0x141000) {
		die("AARCH64_PAGE_SHIFT\ contains\ an\ unsupported\ value\.");
	    }
	    eval 'sub PGSHIFT () { &AARCH64_PAGE_SHIFT;}' unless defined(&PGSHIFT);
	} else {
	    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
	}
	eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
	eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
	if((defined(&PGSHIFT) ? &PGSHIFT : undef) > 12) {
	    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
	} else {
	    eval 'sub MSIZE () {512;}' unless defined(&MSIZE);
	}
	unless(defined(&MCLSHIFT)) {
	    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
	}
	eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
	unless(defined(&NFS_RSIZE)) {
	    eval 'sub NFS_RSIZE () {32768;}' unless defined(&NFS_RSIZE);
	}
	unless(defined(&NFS_WSIZE)) {
	    eval 'sub NFS_WSIZE () {32768;}' unless defined(&NFS_WSIZE);
	}
	unless(defined(&MSGBUFSIZE)) {
	    eval 'sub MSGBUFSIZE () {65536;}' unless defined(&MSGBUFSIZE);
	}
	eval 'sub COHERENCY_UNIT () {128;}' unless defined(&COHERENCY_UNIT);
	eval 'sub CACHE_LINE_SIZE () {128;}' unless defined(&CACHE_LINE_SIZE);
	eval 'sub MAXCPUS () {256;}' unless defined(&MAXCPUS);
	if(defined(&_KERNEL)) {
	    unless(defined(&__HIDE_DELAY)) {
		eval 'sub DELAY {
		    my($x) = @_;
    		    eval q( &delay($x));
		}' unless defined(&DELAY);
	    }
	    if(defined(&COMPAT_16)) {
		eval 'sub COMPAT_ZERODEV {
		    my($x) = @_;
    		    eval q(($x ==  &makedev(0,  &_DEV_ZERO_oARM)));
		}' unless defined(&COMPAT_ZERODEV);
	    }
	}
	eval 'sub aarch64_btop {
	    my($x) = @_;
    	    eval q((($x) >>  &PGSHIFT));
	}' unless defined(&aarch64_btop);
	eval 'sub aarch64_ptob {
	    my($x) = @_;
    	    eval q((($x) <<  &PGSHIFT));
	}' unless defined(&aarch64_ptob);
	eval 'sub aarch64_trunc_page {
	    my($x) = @_;
    	    eval q((($x) & ~ &PGSHIFT));
	}' unless defined(&aarch64_trunc_page);
	eval 'sub aarch64_round_page {
	    my($x) = @_;
    	    eval q((((($x)) +  &PGOFSET) & ~ &PGOFSET));
	}' unless defined(&aarch64_round_page);
	eval 'sub arm_btop {
	    my($x) = @_;
    	    eval q( &aarch64_btop($x));
	}' unless defined(&arm_btop);
	eval 'sub arm_ptob {
	    my($x) = @_;
    	    eval q( &aarch64_ptob($x));
	}' unless defined(&arm_ptob);
    }
 elsif(defined(&__arm__)) {
	require 'arm/param.ph';
    }
}
1;
