require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_SLJITARCH_H)) {
    eval 'sub _AARCH64_SLJITARCH_H () {1;}' unless defined(&_AARCH64_SLJITARCH_H);
    unless(defined(&__aarch64__)) {
	require 'arm/sljit_machdep.ph';
    } else {
	require 'sys/cdefs.ph';
	if(defined(&_KERNEL)) {
	    require 'machine/types.ph';
	    require 'arm/cpufunc.ph';
	} else {
	    require 'stddef.ph';
	    require 'stdint.ph';
	    require 'aarch64/sysarch.ph';
	}
	eval 'sub SLJIT_CONFIG_ARM_64 () {1;}' unless defined(&SLJIT_CONFIG_ARM_64);
	if(defined(&_HARDKERNEL)) {
	    eval 'sub SLJIT_CACHE_FLUSH {
	        my($from, $to) = @_;
    		eval q( &cpu_icache_sync_range(( &vaddr_t)($from), ( &vsize_t)(($to) - ($from))));
	    }' unless defined(&SLJIT_CACHE_FLUSH);
	} else {
	    eval 'sub SLJIT_CACHE_FLUSH {
	        my($from, $to) = @_;
    		eval q(( &void) &__builtin___clear_cache(, ($to)));
	    }' unless defined(&SLJIT_CACHE_FLUSH);
	}
    }
}
1;
