/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.progress.ProgressVisibilityManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecorator;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecoratorRenderer;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountsPanel;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b*\u0002\u0016\u001d\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020 J\r\u0010\"\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010#J\r\u0010$\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000eH\u0002J\"\u0010)\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130*J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0002J\u001e\u0010/\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0013012\b\u00102\u001a\u0004\u0018\u00010\u0013J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0006\u00105\u001a\u00020 J&\u00106\u001a\u00020 2\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00122\b\u00102\u001a\u0004\u0018\u00010\u0013J\u0010\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u0019H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "accountList", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "accountListModel", "Lcom/intellij/ui/CollectionListModel;", "currentTokensMap", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "errorLinkHandler", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "errorLinkHandlerInstalled", "", "newTokensMap", "", "progressManager", "org/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "addAccount", "", "clearNewTokens", "createLinkActivationListener", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createLinkActivationListener$1;", "createListProgressManager", "()Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountsPanel$createListProgressManager$1;", "dispose", "editAccount", "decorator", "getAccounts", "Lkotlin/Pair;", "isAccountUnique", "login", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "isModified", "accounts", "", "defaultAccount", "loadAccountDetails", "accountData", "loadExistingAccountsDetails", "setAccounts", "setLinkHandlerEnabled", "enabled", "intellij.vcs.github"})
public final class GithubAccountsPanel
extends BorderLayoutPanel
implements Disposable {
    private final CollectionListModel<GithubAccountDecorator> accountListModel;
    private final JBList<GithubAccountDecorator> accountList;
    private final createListProgressManager.1 progressManager;
    private final createLinkActivationListener.1 errorLinkHandler;
    private boolean errorLinkHandlerInstalled;
    private Map<GithubAccount, String> currentTokensMap;
    private final Map<GithubAccount, String> newTokensMap;
    private final Project project;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;

    private final void addAccount() {
        GithubLoginDialog dialog2 = new GithubLoginDialog(this.executorFactory, this.project, (Component)((Object)this), (Function2)new Function2<String, GithubServerPath, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return GithubAccountsPanel.access$isAccountUnique((GithubAccountsPanel)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAccountsPanel.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }, null, null, 48, null);
        if (dialog2.showAndGet()) {
            GithubAccount githubAccount = GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer());
            Map<GithubAccount, String> map2 = this.newTokensMap;
            String string = dialog2.getToken();
            map2.put(githubAccount, string);
            GithubAccountDecorator accountData = new GithubAccountDecorator(githubAccount, false);
            this.accountListModel.add((Object)accountData);
            this.loadAccountDetails(accountData);
        }
    }

    private final void editAccount(GithubAccountDecorator decorator) {
        Object object = new GithubLoginDialog(this.executorFactory, this.project, (Component)((Object)this), null, null, null, 56, null);
        GithubLoginDialog $receiver = object;
        String string = decorator.getAccount().getServer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decorator.account.server.toString()");
        $receiver.withServer(string, false);
        GithubLoginDialog.withCredentials$default($receiver, decorator.getAccount().getName(), null, 2, null);
        GithubLoginDialog dialog2 = object;
        if (dialog2.showAndGet()) {
            decorator.getAccount().setName(dialog2.getLogin());
            object = this.newTokensMap;
            GithubAccount githubAccount = decorator.getAccount();
            String string2 = dialog2.getToken();
            object.put(githubAccount, string2);
            this.loadAccountDetails(decorator);
        }
    }

    private final boolean isAccountUnique(String login2, GithubServerPath server) {
        boolean bl;
        block3: {
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"accountListModel.items");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getAccount().getName(), (Object)login2) && Intrinsics.areEqual((Object)it.getAccount().getServer(), (Object)server))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final createLinkActivationListener.1 createLinkActivationListener() {
        return new MouseAdapter(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Point point = e.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                GithubAccountDecorator decorator = this.findDecoratorWithLoginLinkAt(point);
                if (decorator != null) {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getPredefinedCursor(12));
                } else {
                    UIUtil.setCursor((Component)((Component)GithubAccountsPanel.access$getAccountList$p(this.this$0)), (Cursor)Cursor.getDefaultCursor());
                }
                boolean hasChanges = false;
                for (GithubAccountDecorator item : GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getItems()) {
                    boolean isLinkPointedAt = Intrinsics.areEqual((Object)item, (Object)decorator);
                    hasChanges = hasChanges || isLinkPointedAt != item.getErrorLinkPointedAt();
                    item.setErrorLinkPointedAt(isLinkPointedAt);
                }
                if (hasChanges) {
                    GithubAccountsPanel.access$getAccountListModel$p(this.this$0).allContentsChanged();
                }
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    Point point = e.getPoint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                    GithubAccountDecorator githubAccountDecorator = this.findDecoratorWithLoginLinkAt(point);
                    if (githubAccountDecorator == null) break block0;
                    GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                    GithubAccountsPanel githubAccountsPanel = this.this$0;
                    GithubAccountDecorator p1 = githubAccountDecorator2;
                    GithubAccountsPanel.access$editAccount(githubAccountsPanel, p1);
                }
            }

            private final GithubAccountDecorator findDecoratorWithLoginLinkAt(Point point) {
                GithubAccountDecorator decorator;
                int idx = GithubAccountsPanel.access$getAccountList$p(this.this$0).locationToIndex(point);
                if (idx < 0) {
                    return null;
                }
                Rectangle cellBounds = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellBounds(idx, idx);
                if (!cellBounds.contains(point)) {
                    return null;
                }
                GithubAccountDecorator githubAccountDecorator = decorator = (GithubAccountDecorator)GithubAccountsPanel.access$getAccountListModel$p(this.this$0).getElementAt(idx);
                if ((githubAccountDecorator != null ? githubAccountDecorator.getLoadingError() : null) == null) {
                    return null;
                }
                Component rendererComponent = GithubAccountsPanel.access$getAccountList$p(this.this$0).getCellRenderer().getListCellRendererComponent((JList)GithubAccountsPanel.access$getAccountList$p(this.this$0), decorator, idx, true, true);
                rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                UIUtil.layoutRecursively((Component)rendererComponent);
                int rendererRelativeX = point.x - cellBounds.x;
                int rendererRelativeY = point.y - cellBounds.y;
                Component childComponent = UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
                if (!(childComponent instanceof SimpleColoredComponent)) {
                    return null;
                }
                Container container = ((SimpleColoredComponent)childComponent).getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)container, (String)"childComponent.parent");
                int childRelativeX = rendererRelativeX - container.getX() - ((SimpleColoredComponent)childComponent).getX();
                return Intrinsics.areEqual((Object)((SimpleColoredComponent)childComponent).getFragmentTagAt(childRelativeX), (Object)"EDIT_LINK") ? decorator : null;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final void setLinkHandlerEnabled(boolean enabled) {
        if (enabled) {
            if (!this.errorLinkHandlerInstalled) {
                this.accountList.addMouseListener((MouseListener)this.errorLinkHandler);
                this.accountList.addMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
                this.errorLinkHandlerInstalled = true;
            }
        } else if (this.errorLinkHandlerInstalled) {
            this.accountList.removeMouseListener((MouseListener)this.errorLinkHandler);
            this.accountList.removeMouseMotionListener((MouseMotionListener)this.errorLinkHandler);
            this.errorLinkHandlerInstalled = false;
        }
    }

    public final void loadExistingAccountsDetails() {
        Iterator iterator = this.accountListModel.getItems().iterator();
        while (iterator.hasNext()) {
            GithubAccountDecorator accountData;
            GithubAccountDecorator githubAccountDecorator = accountData = (GithubAccountDecorator)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)githubAccountDecorator, (String)"accountData");
            this.loadAccountDetails(githubAccountDecorator);
        }
    }

    private final void loadAccountDetails(GithubAccountDecorator accountData) {
        String token2;
        GithubAccount account = accountData.getAccount();
        String string = this.newTokensMap.get(account);
        if (string == null) {
            string = token2 = this.currentTokensMap.get(account);
        }
        if (token2 == null) {
            GithubAccountDecorator githubAccountDecorator = accountData;
            CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
            GithubAccountDecorator $receiver = githubAccountDecorator;
            $receiver.setLoadingError("Missing access token");
            $receiver.setShowLoginLink(true);
            GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
            collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            return;
        }
        int pictureSize = JBUI.scale((int)40);
        JBUI.ScaleContext scaleContext = JBUI.ScaleContext.create((Component)((Component)this.accountList));
        Intrinsics.checkExpressionValueIsNotNull((Object)scaleContext, (String)"JBUI.ScaleContext.create(accountList)");
        JBUI.ScaleContext scaleContext2 = scaleContext;
        this.progressManager.run(new Task.Backgroundable(this, token2, account, pictureSize, scaleContext2, accountData, this.project, "Not Visible"){
            @NotNull
            public Pair<? extends GithubUserDetailed, ? extends Image> data;
            final /* synthetic */ GithubAccountsPanel this$0;
            final /* synthetic */ String $token;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ int $pictureSize;
            final /* synthetic */ JBUI.ScaleContext $scaleContext;
            final /* synthetic */ GithubAccountDecorator $accountData;

            @NotNull
            public final Pair<GithubUserDetailed, Image> getData() {
                Pair<? extends GithubUserDetailed, ? extends Image> pair = this.data;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                return pair;
            }

            public final void setData(@NotNull Pair<? extends GithubUserDetailed, ? extends Image> pair) {
                Intrinsics.checkParameterIsNotNull(pair, (String)"<set-?>");
                this.data = pair;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubApiRequestExecutor.WithTokenAuth executor = GithubAccountsPanel.access$getExecutorFactory$p(this.this$0).create(this.$token);
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                GithubAuthenticatedUser details = executor.execute(indicator, GithubApiRequests.CurrentUser.get(githubServerPath));
                Image image2 = (Image)((CompletableFuture)GithubAccountsPanel.access$getAvatarLoader$p(this.this$0).requestAvatar(executor, details).thenCompose(new Function<T, CompletionStage<U>>(this){
                    final /* synthetic */ loadAccountDetails.2 this$0;

                    public final CompletionStage<Image> apply(@Nullable Image it) {
                        return it != null ? (CompletionStage)GithubAccountsPanel.access$getImageResizer$p(this.this$0.this$0).requestImageResize(it, this.this$0.$pictureSize, this.this$0.$scaleContext) : (CompletionStage)CompletableFuture.completedFuture(null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })).join();
                this.data = TuplesKt.to((Object)details, (Object)image2);
            }

            public void onSuccess() {
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                GithubAccountDecorator $receiver = githubAccountDecorator;
                Pair<? extends GithubUserDetailed, ? extends Image> pair = this.data;
                if (pair == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                $receiver.setFullName(((GithubUserDetailed)pair.getFirst()).getName());
                Pair<? extends GithubUserDetailed, ? extends Image> pair2 = this.data;
                if (pair2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                }
                $receiver.setProfilePicture((Image)pair2.getSecond());
                $receiver.setLoadingError(null);
                $receiver.setShowLoginLink(false);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                CollectionListModel collectionListModel = GithubAccountsPanel.access$getAccountListModel$p(this.this$0);
                GithubAccountDecorator $receiver = githubAccountDecorator;
                $receiver.setLoadingError(String.valueOf(error.getMessage()));
                $receiver.setShowLoginLink(error instanceof GithubAuthenticationException);
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                collectionListModel.contentsChanged((Object)githubAccountDecorator2);
            }
            {
                this.this$0 = $outer;
                this.$token = $captured_local_variable$1;
                this.$account = $captured_local_variable$2;
                this.$pictureSize = $captured_local_variable$3;
                this.$scaleContext = $captured_local_variable$4;
                this.$accountData = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7);
            }
        });
    }

    private final createListProgressManager.1 createListProgressManager() {
        return new ProgressVisibilityManager(this){
            final /* synthetic */ GithubAccountsPanel this$0;

            protected void setProgressVisible(boolean visible) {
                GithubAccountsPanel.access$getAccountList$p(this.this$0).setPaintBusy(visible);
            }

            @NotNull
            protected ModalityState getModalityState() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.any()");
                return modalityState;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccounts(@NotNull Map<GithubAccount, String> accounts, @Nullable GithubAccount defaultAccount) {
        Collection<GithubAccountDecorator> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        this.accountListModel.removeAll();
        Iterable iterable = accounts.keySet();
        int n = 0;
        CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv$iv;
            collection = destination$iv$iv;
            GithubAccountDecorator githubAccountDecorator = new GithubAccountDecorator((GithubAccount)it, Intrinsics.areEqual((Object)it, (Object)defaultAccount));
            collection.add(githubAccountDecorator);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.addAll(n, (List)collection);
        this.currentTokensMap = accounts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<GithubAccount, String>, GithubAccount> getAccounts() {
        Object v2;
        Map map2;
        block2: {
            void $receiver$iv$iv;
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"accountListModel.items");
            Iterable $receiver$iv = list2;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Iterable iterable = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                Map map3 = destination$iv$iv;
                GithubAccountDecorator it = (GithubAccountDecorator)element$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getAccount(), (Object)this.newTokensMap.get(it.getAccount()));
                map3.put(pair.getFirst(), pair.getSecond());
            }
            List list3 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"accountListModel.items");
            Iterable iterable2 = list3;
            map2 = destination$iv$iv;
            Iterable iterable3 = iterable2;
            for (Object e : iterable3) {
                GithubAccountDecorator it = (GithubAccountDecorator)e;
                if (!it.getProjectDefault()) continue;
                v2 = e;
                break block2;
            }
            v2 = null;
        }
        Object var14_12 = v2;
        GithubAccountDecorator githubAccountDecorator = var14_12;
        return TuplesKt.to((Object)map2, (Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null));
    }

    public final void clearNewTokens() {
        this.newTokensMap.clear();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object v1;
        Iterable iterable;
        Map<GithubAccount, String> map2;
        block2: {
            Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"accountListModel.items");
            map2 = list2;
            iterable = map2;
            for (Object t : iterable) {
                GithubAccountDecorator it = (GithubAccountDecorator)t;
                if (!it.getProjectDefault()) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        GithubAccountDecorator githubAccountDecorator = v1;
        if (Intrinsics.areEqual((Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null), (Object)defaultAccount) ^ true) return true;
        List list3 = this.accountListModel.getItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"accountListModel.items");
        iterable = $receiver$iv = (Iterable)list3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GithubAccountDecorator $i$a$1$find = (GithubAccountDecorator)item$iv$iv;
            Collection collection = destination$iv$iv;
            GithubAccount githubAccount = it.getAccount();
            collection.add(githubAccount);
        }
        if (Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), accounts) ^ true) return true;
        map2 = this.newTokensMap;
        if (map2.isEmpty()) return false;
        return true;
    }

    public void dispose() {
    }

    public GithubAccountsPanel(@NotNull Project project, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        StatusText statusText;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkParameterIsNotNull((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkParameterIsNotNull((Object)imageResizer, (String)"imageResizer");
        this.project = project;
        this.executorFactory = executorFactory;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        CollectionListModel collectionListModel = new CollectionListModel((Object[])new GithubAccountDecorator[0]);
        GithubAccountsPanel githubAccountsPanel = this;
        CollectionListModel $receiver = collectionListModel;
        $receiver.addListDataListener(new ListDataListener($receiver, this){
            final /* synthetic */ CollectionListModel receiver$0;
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.receiver$0 = $receiver;
                this.this$0 = githubAccountsPanel;
            }

            public void contentsChanged(@Nullable ListDataEvent e) {
                boolean bl;
                GithubAccountsPanel githubAccountsPanel;
                block3: {
                    List list2 = this.receiver$0.getItems();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"items");
                    Iterable $receiver$iv = list2;
                    githubAccountsPanel = this.this$0;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                            if (!(it.getLoadingError() != null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl2 = bl;
                GithubAccountsPanel.access$setLinkHandlerEnabled(githubAccountsPanel, bl2);
            }

            public void intervalRemoved(@Nullable ListDataEvent e) {
            }

            public void intervalAdded(@Nullable ListDataEvent e) {
            }
        });
        githubAccountsPanel.accountListModel = object = collectionListModel;
        collectionListModel = new JBList((ListModel)this.accountListModel);
        githubAccountsPanel = this;
        $receiver = collectionListModel;
        $receiver.setCellRenderer((ListCellRenderer)new GithubAccountDecoratorRenderer());
        $receiver.setSelectionMode(0);
        StatusText $receiver2 = statusText = $receiver.getEmptyText();
        $receiver2.appendText("No GitHub accounts added.");
        $receiver2.appendSecondaryText("Add account", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GithubAccountsPanel this$0;
            {
                this.this$0 = githubAccountsPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                GithubAccountsPanel.access$addAccount(this.this$0);
            }
        });
        $receiver2.appendSecondaryText(" (" + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getNew()) + ')', StatusText.DEFAULT_ATTRIBUTES, null);
        githubAccountsPanel.accountList = object = collectionListModel;
        this.progressManager = this.createListProgressManager();
        this.errorLinkHandler = this.createLinkActivationListener();
        githubAccountsPanel = this;
        githubAccountsPanel.currentTokensMap = object = MapsKt.emptyMap();
        githubAccountsPanel = this;
        githubAccountsPanel.newTokensMap = object = (Map)new LinkedHashMap();
        this.addToCenter(ToolbarDecorator.createDecorator((JList)((JList)this.accountList)).disableUpDownActions().setPanelBorder(IdeBorderFactory.createBorder((int)10)).setAddAction(new AnActionButtonRunnable(){

            public final void run(AnActionButton it) {
                this.addAccount();
            }
        }).addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton("Set default", AllIcons.Actions.Checked){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault()) {
                    return;
                }
                for (GithubAccountDecorator accountData : accountListModel.getItems()) {
                    if (Intrinsics.areEqual((Object)accountData, (Object)((GithubAccountDecorator)accountList.getSelectedValue()))) {
                        accountData.setProjectDefault(true);
                        accountListModel.contentsChanged((Object)accountData);
                        continue;
                    }
                    if (!accountData.getProjectDefault()) continue;
                    accountData.setProjectDefault(false);
                    accountListModel.contentsChanged((Object)accountData);
                }
            }

            public void updateButton(@NotNull AnActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.setEnabled(this.isEnabled() && !((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault());
            }
        }).createPanel());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.progressManager));
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GithubAccountsPanel $this, @NotNull String login2, @NotNull GithubServerPath server) {
        return $this.isAccountUnique(login2, server);
    }

    public static final /* synthetic */ void access$editAccount(GithubAccountsPanel $this, @NotNull GithubAccountDecorator decorator) {
        $this.editAccount(decorator);
    }

    @NotNull
    public static final /* synthetic */ GithubApiRequestExecutor.Factory access$getExecutorFactory$p(GithubAccountsPanel $this) {
        return $this.executorFactory;
    }

    @NotNull
    public static final /* synthetic */ CachingGithubUserAvatarLoader access$getAvatarLoader$p(GithubAccountsPanel $this) {
        return $this.avatarLoader;
    }

    @NotNull
    public static final /* synthetic */ GithubImageResizer access$getImageResizer$p(GithubAccountsPanel $this) {
        return $this.imageResizer;
    }

    public static final /* synthetic */ void access$setLinkHandlerEnabled(GithubAccountsPanel $this, boolean enabled) {
        $this.setLinkHandlerEnabled(enabled);
    }
}

