/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.ui;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterConfigFileView {
    private static final String EMPTY_ERROR_TEXT = " ";
    private final FileType myConfigFileType;
    private final JPanel myComponent;
    private final JRadioButton mySearchRadioButton;
    private final JRadioButton myConfigRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myConfigFileField;
    private final List<Pair<JRadioButton, JComponent>> myRadioButtonWithContentList;
    private final JLabel myConfigFileErrorLabel;
    private NotNullProducer<List<VirtualFile>> myAdditionalConfigFilesProducer;

    public JSLinterConfigFileView(@NotNull Project project, @NotNull JSLinterConfigFileTexts texts, @Nullable FileType configFileType) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(0);
        }
        if (texts == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(1);
        }
        this.myConfigFileType = configFileType;
        this.mySearchRadioButton = new JBRadioButton(texts.getSearchOptionTitle());
        JEditorPane searchDescriptionEditor = JSLinterUtil.createHtmlViewer(texts.getSearchOptionDescription(), UIUtil.getTitledBorderFont());
        this.myConfigRadioButton = new JBRadioButton("\u001bConfiguration file:");
        this.myConfigFileField = this.createCustomConfigField(project, texts.getConfigFileBrowseDialogTitle());
        this.myConfigFileErrorLabel = new JLabel(EMPTY_ERROR_TEXT);
        this.myConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mySearchRadioButton);
        buttonGroup.add(this.myConfigRadioButton);
        this.myRadioButtonWithContentList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)this.mySearchRadioButton, (Object)searchDescriptionEditor), Pair.create((Object)this.myConfigRadioButton, (Object)this.myConfigFileField)});
        this.selectOption(this.mySearchRadioButton, true);
        ((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSLinterConfigFileView.this.updateCustomErrorMessage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView$1", "textChanged"));
            }
        });
        this.myComponent = this.createResultPanel(this.myRadioButtonWithContentList, texts.getFooterHtmlDescription());
    }

    public void setAdditionalConfigFilesProducer(@NotNull NotNullProducer<List<VirtualFile>> additionalConfigFilesProducer) {
        if (additionalConfigFilesProducer == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(2);
        }
        this.myAdditionalConfigFilesProducer = additionalConfigFilesProducer;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (enabled) {
            this.selectOption(this.mySearchRadioButton, this.mySearchRadioButton.isSelected());
        }
        this.updateCustomErrorMessage();
    }

    private void selectOption(@NotNull JRadioButton radioButton, boolean selected) {
        if (radioButton == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(4);
        }
        radioButton.setSelected(selected);
        for (Pair<JRadioButton, JComponent> pair : this.myRadioButtonWithContentList) {
            boolean enable = ((JRadioButton)pair.getFirst()).isSelected();
            UIUtil.setEnabled((Component)((Component)pair.getSecond()), (boolean)enable, (boolean)true);
            if (!enable) continue;
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)pair.getSecond(), true));
        }
        this.updateCustomErrorMessage();
    }

    public boolean isCustomConfigFileUsed() {
        return this.myConfigRadioButton.isSelected();
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = this.myConfigFileField.getText().trim();
        if (string == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setCustomConfigFileUsed(boolean customConfigFileUsed) {
        this.selectOption(this.myConfigRadioButton, customConfigFileUsed);
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(6);
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myConfigFileField.getChildComponent();
        history.setText(customConfigFilePath);
        history.addCurrentTextToHistory();
    }

    private void updateCustomErrorMessage() {
        if (this.myConfigRadioButton.isSelected() && this.myConfigRadioButton.isEnabled()) {
            String errorMessage = JSLinterConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + errorMessage + "</font>"));
                this.myConfigFileErrorLabel.setText(html);
            } else {
                this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
            }
        } else {
            this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
        }
    }

    @Nullable
    private static String formatErrorMessage(@NotNull String path) {
        if (path == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(7);
        }
        if (path.trim().isEmpty()) {
            return "Empty path";
        }
        File file2 = new File(path);
        if (!file2.isAbsolute() || !file2.isFile()) {
            return "No such file";
        }
        return null;
    }

    @NotNull
    private JPanel createResultPanel(@NotNull List<Pair<JRadioButton, JComponent>> contentByRadioButton, @Nullable String footerHtmlDescription) {
        if (contentByRadioButton == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(8);
        }
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            final JRadioButton jRadioButton = (JRadioButton)pair.getFirst();
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JSLinterConfigFileView.this.selectOption(jRadioButton, jRadioButton.isSelected());
                }
            });
        }
        ArrayList components = ContainerUtil.newArrayList();
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            JRadioButton radioButton;
            if (!components.isEmpty()) {
                components.add(Box.createVerticalStrut(JBUI.scale((int)8)));
            }
            if ((radioButton = (JRadioButton)pair.getFirst()) == this.myConfigRadioButton) {
                components.add(this.createCustomConfigFilePanel());
                continue;
            }
            components.add(radioButton);
            int leftMargin = radioButton.getInsets().left + radioButton.getMargin().left + JSLinterUtil.getRadioIconWidth() + radioButton.getIconTextGap();
            JPanel wrap = JSLinterConfigFileView.wrapWithHorizontallyStretchingPanel((Component)pair.getSecond());
            wrap.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            components.add(wrap);
        }
        if (footerHtmlDescription != null) {
            components.add(JSLinterUtil.createHtmlViewer(footerHtmlDescription, UIUtil.getTitledBorderFont()));
        }
        JPanel jPanel = JSLinterConfigFileView.createVerticalPanelFrom(components);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Configuration file", (boolean)true));
        JPanel jPanel2 = jPanel;
        if (jPanel2 == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(9);
        }
        return jPanel2;
    }

    @NotNull
    private JPanel createCustomConfigFilePanel() {
        JPanel configFileErrorPanel = SwingHelper.wrapWithoutStretch((JComponent)this.myConfigFileErrorLabel);
        configFileErrorPanel.setBorder(BorderFactory.createEmptyBorder(0, JBUI.scale((int)4), 0, 0));
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myConfigRadioButton, (JComponent)this.myConfigFileField).addComponentToRightColumn((JComponent)configFileErrorPanel, 0).getPanel();
        if (jPanel == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    private static JPanel wrapWithHorizontallyStretchingPanel(@NotNull Component component) {
        if (component == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(11);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(component, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    private static JPanel createVerticalPanelFrom(@NotNull List<Component> components) {
        if (components == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(12);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int i = 0;
        for (Component component : components) {
            panel.add(component, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++i;
        }
        return panel;
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createCustomConfigField(@NotNull Project project, String selectFileText) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(13);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)selectFileText, (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            if (project == null) {
                JSLinterConfigFileView.$$$reportNull$$$0(17);
            }
            List<VirtualFile> files = this.listConfigFilesInContentScope(project);
            List filePaths = ContainerUtil.map(files, file2 -> FileUtil.toSystemDependentName((String)file2.getPath()));
            Collections.sort(filePaths);
            return filePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(14);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(15);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        if (this.myConfigFileType != null) {
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Collection configs = FileTypeIndex.getFiles((FileType)this.myConfigFileType, (GlobalSearchScope)scope);
            for (VirtualFile config2 : configs) {
                if (config2 == null || !config2.isValid() || config2.isDirectory() || JSLibraryUtil.isProbableLibraryFile(config2, project)) continue;
                result2.add(config2);
            }
        }
        if (this.myAdditionalConfigFilesProducer != null) {
            List files = (List)this.myAdditionalConfigFilesProducer.produce();
            result2.addAll(files);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSLinterConfigFileView.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public void setPreferredWidthToComponents() {
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigFileField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalConfigFilesProducer";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customConfigFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentByRadioButton";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigFilePanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigField";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listConfigFilesInContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalConfigFilesProducer";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCustomConfigFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createResultPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithHorizontallyStretchingPanel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVerticalPanelFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCustomConfigField";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listConfigFilesInContentScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createCustomConfigField$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

