/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.BaseJSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsPsiUtils {
    private JsPsiUtils() {
    }

    @Nullable
    public static PsiElement getMethodNameLeafElement(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression referenceExpression;
        if (callExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(0);
        }
        return (referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null ? referenceExpression.getReferenceNameElement() : null;
    }

    private static String getStringValue(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(1);
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            return StringUtil.unquoteString((String)literalExpression.getText(), (char)'`');
        }
        String text = StringUtil.unquoteString((String)StringUtil.notNullize((String)literalExpression.getText()));
        return JsPsiUtils.unescapeBackslashes(text);
    }

    @NotNull
    public static String unescapeBackslashes(@NotNull String str) {
        if (str == null) {
            JsPsiUtils.$$$reportNull$$$0(2);
        }
        if (!StringUtil.containsChar((String)str, (char)'\\')) {
            String string = str;
            if (string == null) {
                JsPsiUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean backslash = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (backslash) {
                if (ch == 'u') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 4)) {
                        i += 4;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else if (ch == 'x') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 2)) {
                        i += 2;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else {
                    JsPsiUtils.appendEscapedChar(result, ch);
                }
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            JsPsiUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void appendEscapedChar(@NotNull StringBuilder result, char ch) {
        if (result == null) {
            JsPsiUtils.$$$reportNull$$$0(5);
        }
        if (ch == '0') {
            result.append('\u0000');
        } else if (ch == '\'') {
            result.append('\'');
        } else if (ch == '\"') {
            result.append('\"');
        } else if (ch == '\\') {
            result.append('\\');
        } else if (ch == 'n') {
            result.append('\n');
        } else if (ch == 'r') {
            result.append('\r');
        } else if (ch == 'v') {
            result.append('v');
        } else if (ch == 't') {
            result.append('\t');
        } else if (ch == 'b') {
            int l = result.length();
            if (l > 0) {
                result.setLength(l - 1);
            }
        } else if (ch == 'f') {
            result.append('\f');
        } else {
            result.append(ch);
        }
    }

    private static boolean appendCodePoint(@NotNull StringBuilder result, @NotNull String str, int from, int cnt) {
        if (result == null) {
            JsPsiUtils.$$$reportNull$$$0(6);
        }
        if (str == null) {
            JsPsiUtils.$$$reportNull$$$0(7);
        }
        if (from + cnt <= str.length()) {
            String s = str.substring(from, from + cnt);
            try {
                int code = Integer.parseInt(s, 16);
                result.append((char)code);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static String extractStringValue(@Nullable JSExpression jsExpression) {
        JSExpression initializer;
        JSReferenceExpression jsReferenceExpression;
        IElementType operationType;
        if (jsExpression == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)jsExpression, JSLiteralExpression.class);
        if (jsLiteralExpression != null && jsLiteralExpression.isQuotedLiteral()) {
            return JsPsiUtils.getStringValue(jsLiteralExpression);
        }
        JSBinaryExpression jsBinaryExpression = (JSBinaryExpression)ObjectUtils.tryCast((Object)jsExpression, JSBinaryExpression.class);
        if (jsBinaryExpression != null && (operationType = jsBinaryExpression.getOperationSign()) == BaseJSTokenTypes.PLUS) {
            String lOperand = JsPsiUtils.extractStringValue(jsBinaryExpression.getLOperand());
            String rOperand = JsPsiUtils.extractStringValue(jsBinaryExpression.getROperand());
            if (lOperand != null && rOperand != null) {
                return lOperand + rOperand;
            }
        }
        if ((jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsExpression, JSReferenceExpression.class)) != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractStringValue(initializer);
        }
        return null;
    }

    @Nullable
    private static JSExpression extractInitExpression(@NotNull JSReferenceExpression jsReferenceExpression) {
        JSElement scopeElement;
        if (jsReferenceExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(8);
        }
        if ((scopeElement = JsPsiUtils.getNearestContainingScopeElement((JSElement)jsReferenceExpression)) == null) {
            return null;
        }
        String refName = jsReferenceExpression.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return null;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(scopeElement);
        int maxOffset = jsReferenceExpression.getTextRange().getStartOffset();
        JSExpression lastExpr = null;
        for (JSStatement statement : statements) {
            JSReferenceExpression refExpr;
            JSDefinitionExpression defExpr;
            JSAssignmentExpression assignmentExpr;
            JSExpressionStatement exprStmt;
            if (statement.getTextRange().getEndOffset() > maxOffset) break;
            JSVarStatement varStmt = (JSVarStatement)ObjectUtils.tryCast((Object)statement, JSVarStatement.class);
            if (varStmt != null) {
                JSVariable[] vars;
                for (JSVariable var : vars = (JSVariable[])ObjectUtils.notNull((Object)varStmt.getVariables(), (Object)JSVariable.EMPTY_ARRAY)) {
                    if (!refName.equals(var.getQualifiedName())) continue;
                    lastExpr = var.getInitializer();
                }
            }
            if ((exprStmt = (JSExpressionStatement)ObjectUtils.tryCast((Object)statement, JSExpressionStatement.class)) == null || (assignmentExpr = (JSAssignmentExpression)ObjectUtils.tryCast((Object)exprStmt.getExpression(), JSAssignmentExpression.class)) == null || (defExpr = (JSDefinitionExpression)ObjectUtils.tryCast((Object)assignmentExpr.getLOperand(), JSDefinitionExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)defExpr.getExpression(), JSReferenceExpression.class)) == null || refExpr.getQualifier() != null || !refName.equals(refExpr.getReferenceName())) continue;
            lastExpr = assignmentExpr.getROperand();
        }
        return lastExpr;
    }

    @Nullable
    public static JSObjectLiteralExpression extractObjectLiteralExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSObjectLiteralExpression jsObjectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)expression, JSObjectLiteralExpression.class);
        if (jsObjectLiteralExpression != null) {
            return jsObjectLiteralExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractObjectLiteralExpression(initializer);
        }
        return null;
    }

    @Nullable
    public static String extractNumberLiteral(@Nullable JSExpression jsExpression) {
        JSExpression initializer;
        if (jsExpression == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)jsExpression, JSLiteralExpression.class);
        if (jsLiteralExpression != null && jsLiteralExpression.isNumericLiteral()) {
            return jsLiteralExpression.getText();
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsExpression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractNumberLiteral(initializer);
        }
        return null;
    }

    @Nullable
    public static JSFunctionExpression extractFunctionExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSFunctionExpression jsFunctionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
        if (jsFunctionExpression != null) {
            return jsFunctionExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractFunctionExpression(initializer);
        }
        return null;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(9);
        }
        ArrayList statements = Lists.newArrayList();
        for (PsiElement child : jsFile.getChildren()) {
            JSElement element = (JSElement)ObjectUtils.tryCast((Object)child, JSElement.class);
            if (element == null) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder(element, statements);
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFunctionExpression funcExpr) {
        if (funcExpr == null) {
            JsPsiUtils.$$$reportNull$$$0(11);
        }
        ArrayList statements = Lists.newArrayList();
        for (JSSourceElement sourceElement : funcExpr.getBody()) {
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)sourceElement, statements);
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void collectJsStatementsInExecutionOrder(@NotNull JSElement statement, @NotNull List<JSStatement> statements) {
        if (statement == null) {
            JsPsiUtils.$$$reportNull$$$0(13);
        }
        if (statements == null) {
            JsPsiUtils.$$$reportNull$$$0(14);
        }
        JSFunction function = null;
        if (statement instanceof JSExpressionStatement) {
            JSCallExpression callExpression;
            JSExpression expressionOfStatement = ((JSExpressionStatement)statement).getExpression();
            if (expressionOfStatement == null) {
                return;
            }
            if (expressionOfStatement instanceof JSCallExpression) {
                callExpression = (JSCallExpression)expressionOfStatement;
                JSParenthesizedExpression parenthesizedExpression = JsPsiUtils.getParenthesizedExpression(callExpression);
                if (parenthesizedExpression != null) {
                    function = (JSFunction)ObjectUtils.tryCast((Object)parenthesizedExpression.getInnerExpression(), JSFunction.class);
                } else if (JSAmdPsiUtil.isDefineCall((JSCallExpression)callExpression)) {
                    JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer((JSCallExpression)callExpression);
                    function = (JSFunction)ObjectUtils.tryCast((Object)moduleInitializer, JSFunction.class);
                }
            } else if (expressionOfStatement instanceof JSParenthesizedExpression && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)((JSParenthesizedExpression)expressionOfStatement).getInnerExpression(), JSCallExpression.class)) != null) {
                function = (JSFunction)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSFunction.class);
            }
        }
        if (function == null) {
            function = (JSFunction)ObjectUtils.tryCast((Object)statement, JSFunction.class);
        }
        if (function != null) {
            JSSourceElement[] sourceElements;
            for (JSSourceElement jSSourceElement : sourceElements = function.getBody()) {
                if (!(jSSourceElement instanceof JSStatement)) continue;
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)jSSourceElement, statements);
            }
        } else if (statement instanceof JSBlockStatement) {
            JSStatement[] childStatements = ((JSBlockStatement)statement).getStatements();
            for (JSSourceElement jSSourceElement : childStatements) {
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)jSSourceElement, statements);
            }
        } else if (statement instanceof JSStatement) {
            statements.add((JSStatement)statement);
        } else if (statement instanceof TypeScriptImplicitModule) {
            TypeScriptModule module = ((TypeScriptImplicitModule)statement).getRealModule();
            if (module != null) {
                JsPsiUtils.collectStatementsInsideModule(module, statements);
            }
        } else if (statement instanceof TypeScriptModule) {
            JsPsiUtils.collectStatementsInsideModule((TypeScriptModule)statement, statements);
        }
    }

    private static void collectStatementsInsideModule(@NotNull TypeScriptModule<?> tsm, @NotNull List<JSStatement> statements) {
        if (tsm == null) {
            JsPsiUtils.$$$reportNull$$$0(15);
        }
        if (statements == null) {
            JsPsiUtils.$$$reportNull$$$0(16);
        }
        for (PsiElement element : tsm.getChildren()) {
            if (!(element instanceof JSElement)) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, statements);
        }
    }

    private static JSParenthesizedExpression getParenthesizedExpression(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
        if (referenceExpression != null && "call".equals(referenceExpression.getReferenceName())) {
            return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSParenthesizedExpression.class);
        }
        return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)methodExpression, JSParenthesizedExpression.class);
    }

    public static boolean isStringElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractStringValue(jsExpression) != null;
    }

    public static boolean isObjectElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractObjectLiteralExpression(jsExpression) != null;
    }

    public static boolean isFunctionExpressionElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractFunctionExpression(jsExpression) != null;
    }

    public static boolean isNumberElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractNumberLiteral(jsExpression) != null;
    }

    @Nullable
    public static JSCallExpression toCallExpressionFromStatement(@NotNull JSStatement statement) {
        if (statement == null) {
            JsPsiUtils.$$$reportNull$$$0(17);
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class);
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)returnStatement.getExpression(), JSCallExpression.class);
        }
        return null;
    }

    @NotNull
    public static JSProperty[] getProperties(@NotNull JSObjectLiteralExpression objectLiteralExpression) {
        if (objectLiteralExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(18);
        }
        JSProperty[] properties = objectLiteralExpression.getProperties();
        int cnt = 0;
        for (JSProperty property : properties) {
            if (property == null) continue;
            ++cnt;
        }
        if (cnt < properties.length) {
            JSProperty[] a = new JSProperty[cnt];
            int id = 0;
            for (JSProperty property : properties) {
                if (property == null) continue;
                a[id] = property;
                ++id;
            }
            if (a == null) {
                JsPsiUtils.$$$reportNull$$$0(19);
            }
            return a;
        }
        if (properties == null) {
            JsPsiUtils.$$$reportNull$$$0(20);
        }
        return properties;
    }

    public static boolean containsOffsetStrictly(@NotNull TextRange textRange, int offset) {
        if (textRange == null) {
            JsPsiUtils.$$$reportNull$$$0(21);
        }
        return textRange.getStartOffset() < offset && offset < textRange.getEndOffset();
    }

    @NotNull
    public static JSExpression[] getArguments(@Nullable JSArgumentList argumentList) {
        JSExpression[] expressions = null;
        if (argumentList != null) {
            expressions = argumentList.getArguments();
        }
        if (expressions == null) {
            expressions = JSExpression.EMPTY_ARRAY;
        }
        if (expressions == null) {
            JsPsiUtils.$$$reportNull$$$0(22);
        }
        return expressions;
    }

    @NotNull
    public static JSExpression[] getArguments(@NotNull JSCallExpression jsCallExpression) {
        if (jsCallExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(23);
        }
        JSExpression[] jSExpressionArray = JsPsiUtils.getArguments(jsCallExpression.getArgumentList());
        if (jSExpressionArray == null) {
            JsPsiUtils.$$$reportNull$$$0(24);
        }
        return jSExpressionArray;
    }

    @Nullable
    public static PsiElement getPropertyNamePsiElement(@NotNull JSProperty property) {
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(25);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)property.getFirstChild(), LeafPsiElement.class);
    }

    @Nullable
    public static String getPropertyName(@NotNull JSProperty property) {
        PsiElement testMethodNameDeclaration;
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(26);
        }
        if ((testMethodNameDeclaration = JsPsiUtils.getPropertyNamePsiElement(property)) == null) {
            return null;
        }
        return StringUtil.unquoteString((String)testMethodNameDeclaration.getText());
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type) {
        if (type == null) {
            JsPsiUtils.$$$reportNull$$$0(27);
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            return node.getElementType() == type;
        }
        return false;
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type1, @NotNull IElementType type2, @NotNull IElementType type3) {
        if (type1 == null) {
            JsPsiUtils.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            JsPsiUtils.$$$reportNull$$$0(29);
        }
        if (type3 == null) {
            JsPsiUtils.$$$reportNull$$$0(30);
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            IElementType type = node.getElementType();
            return type == type1 || type == type2 || type == type3;
        }
        return false;
    }

    @Nullable
    public static PsiElement getFunctionLeftBrace(@Nullable JSFunction function) {
        JSSourceElement[] jsSourceElements;
        if (function == null) {
            return null;
        }
        for (JSSourceElement jsSourceElement : jsSourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)function.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
            if (!(jsSourceElement instanceof JSBlockStatement)) continue;
            JSBlockStatement jsBlockStatement = (JSBlockStatement)jsSourceElement;
            return jsBlockStatement.getFirstChild();
        }
        return null;
    }

    @Nullable
    public static Document getDocument(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(31);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrderNextTo(@NotNull JSStatement stmt) {
        JSElement nearestScopeElement;
        if (stmt == null) {
            JsPsiUtils.$$$reportNull$$$0(32);
        }
        if ((nearestScopeElement = JsPsiUtils.getNearestContainingScopeElement((JSElement)stmt)) == null) {
            List<JSStatement> list = Collections.emptyList();
            if (list == null) {
                JsPsiUtils.$$$reportNull$$$0(33);
            }
            return list;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(nearestScopeElement);
        int minStartOffset = stmt.getTextRange().getEndOffset();
        Iterator<JSStatement> it = statements.iterator();
        while (it.hasNext()) {
            JSStatement statement = it.next();
            if (minStartOffset <= statement.getTextRange().getStartOffset()) continue;
            it.remove();
        }
        List<JSStatement> list = statements;
        if (list == null) {
            JsPsiUtils.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    private static JSElement getNearestContainingScopeElement(@NotNull JSElement element) {
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(35);
        }
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof JSFunction) {
                return (JSFunction)parent;
            }
            if (parent instanceof PsiFile) {
                return (JSElement)ObjectUtils.tryCast((Object)parent, JSFile.class);
            }
            PsiElement newParent = parent.getParent();
            if (newParent == parent) break;
            parent = newParent;
        }
        return null;
    }

    @NotNull
    private static List<JSStatement> getTopLevelStatementsOf(@NotNull JSElement parent) {
        if (parent == null) {
            JsPsiUtils.$$$reportNull$$$0(36);
        }
        JSSourceElement[] elements = JSSourceElement.EMPTY_ARRAY;
        if (parent instanceof JSFile) {
            JSFile jsFile = (JSFile)parent;
            elements = jsFile.getStatements();
        } else if (parent instanceof JSFunction) {
            JSFunction f = (JSFunction)parent;
            elements = f.getBody();
        }
        ArrayList<JSStatement> out = new ArrayList<JSStatement>();
        for (JSSourceElement element : elements) {
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, out);
        }
        ArrayList<JSStatement> arrayList = out;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    public static <K> K getVerifiedHierarchyHead(PsiElement psiElement, Class<?>[] hierarchyClasses, Class<K> headHierarchyClass) {
        for (Class<?> clazz : hierarchyClasses) {
            if (!clazz.isInstance(psiElement)) {
                return null;
            }
            psiElement = psiElement.getParent();
        }
        return (K)ObjectUtils.tryCast((Object)psiElement, headHierarchyClass);
    }

    @NotNull
    public static String wrapWithMostFrequentQuote(@NotNull JSFile jsFile, String stringLiteralValue) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(38);
        }
        QuoteCountingVisitor visitor = new QuoteCountingVisitor();
        visitor.visitFile((PsiFile)jsFile);
        char quoteChar = visitor.mySingleQuotes == visitor.myDoubleQuotes ? (char)'\'' : (visitor.mySingleQuotes < visitor.myDoubleQuotes ? (char)'\"' : '\'');
        String string = quoteChar + stringLiteralValue + quoteChar;
        if (string == null) {
            JsPsiUtils.$$$reportNull$$$0(39);
        }
        return string;
    }

    public static boolean mightContainGlobalCall(@NotNull PsiFile file, @NotNull String globalName, boolean globalAsQualifier) {
        if (file == null) {
            JsPsiUtils.$$$reportNull$$$0(40);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(41);
        }
        CharSequence contents = file.getViewProvider().getContents();
        int ind = StringUtil.indexOf((CharSequence)contents, (CharSequence)globalName);
        while (ind >= 0) {
            char prevChar;
            char c = prevChar = ind > 0 ? (char)contents.charAt(ind - 1) : (char)' ';
            if (prevChar != '.' && prevChar != '_' && !Character.isLetterOrDigit(prevChar)) {
                char nextChar;
                int nextCharInd = ind + globalName.length();
                char c2 = nextChar = nextCharInd < contents.length() ? (char)contents.charAt(nextCharInd) : (char)'(';
                if (nextChar == '(' || Character.isWhitespace(nextChar)) {
                    return true;
                }
                if (globalAsQualifier && nextChar == '.') {
                    return true;
                }
            }
            ind = StringUtil.indexOf((CharSequence)contents, (CharSequence)globalName, (int)(ind + globalName.length() + 1));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsReferenceExpression";
                break;
            }
            case 9: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcExpr";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsm";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteralExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCallExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type3";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackslashes";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "listStatementsInExecutionOrder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "listStatementsInExecutionOrderNextTo";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStatementsOf";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithMostFrequentQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameLeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackslashes";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 37: 
            case 39: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedChar";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendCodePoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractInitExpression";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listStatementsInExecutionOrder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectJsStatementsInExecutionOrder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectStatementsInsideModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toCallExpressionFromStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsOffsetStrictly";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamePsiElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isElementOfType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "listStatementsInExecutionOrderNextTo";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNearestContainingScopeElement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStatementsOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMostFrequentQuote";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "mightContainGlobalCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QuoteCountingVisitor
    extends JSRecursiveElementVisitor {
        private int myDoubleQuotes = 0;
        private int mySingleQuotes = 0;

        private QuoteCountingVisitor() {
        }

        public void visitJSLiteralExpression(JSLiteralExpression expr) {
            if (expr.isQuotedLiteral()) {
                CharSequence seq;
                LeafPsiElement firstChild = (LeafPsiElement)ObjectUtils.tryCast((Object)expr.getFirstChild(), LeafPsiElement.class);
                CharSequence charSequence = seq = firstChild != null ? firstChild.getChars() : expr.getText();
                if (StringUtil.startsWithChar((CharSequence)seq, (char)'\"')) {
                    ++this.myDoubleQuotes;
                } else {
                    ++this.mySingleQuotes;
                }
            }
        }
    }
}

