/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.model.DataType;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatter {
    private static final int MIN_IMAGE_BYTES = 100;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private final Map<FormatterKey, Formatter> myFormatCache = ContainerUtil.newConcurrentMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors());
    private Formatter myDateFormat;
    private Formatter myTimeFormat;
    private Formatter myShortZonedTimeFormat;
    private Formatter myShortZonedTimestampFormat;
    private NumberFormatter myNumberFormat;
    private NumberFormatter myBigIntFormat;
    private static final MyMap<Object> ourToObject = new MyMap();
    private final MyMap<String> myToString = new MyMap();

    public ObjectFormatter() {
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return o;
            }
        });
        this.myToString.register(Object[].class, new Converter<Object[], String>(){

            @Override
            public String convert(Object[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(o, column2, dbms, forDisplay);
            }
        });
        this.myToString.register(long[].class, new Converter<long[], String>(){

            @Override
            public String convert(long[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, forDisplay);
            }
        });
        this.myToString.register(int[].class, new Converter<int[], String>(){

            @Override
            public String convert(int[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, forDisplay);
            }
        });
        this.myToString.register(double[].class, new Converter<double[], String>(){

            @Override
            public String convert(double[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column2, dbms, forDisplay);
            }
        });
        this.myToString.register(byte[].class, new Converter<byte[], String>(){

            @Override
            public String convert(byte[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (forDisplay && ObjectFormatter.isOracleGUID(o, column2, dbms)) {
                    return DialectUtils.toHexString(o);
                }
                return ObjectFormatter.this.bytesToStringImpl(o, o.length, dbms, forDisplay);
            }
        });
        this.myToString.register(BitString.class, new Converter<BitString, String>(){

            @Override
            public String convert(BitString o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column2);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                String text2 = new String(o);
                return ObjectFormatter.charToStringImpl(text2, text2.length(), forDisplay);
            }
        });
        this.myToString.register(Clob.class, new Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Clob o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.charToStringImpl(trimmed > 0 ? o.getSubString(1L, trimmed) : "", length, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, new Converter<LobInfo.ClobInfo, String>(){

            @Override
            public String convert(LobInfo.ClobInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column2, dbms, o.length);
                }
                return ObjectFormatter.charToStringImpl(o.data, o.length, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, new Converter<LobInfo.FileClobInfo, String>(){

            @Override
            public String convert(LobInfo.FileClobInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Blob.class, new Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Blob o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), length, dbms, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, String>(){

            @Override
            public String convert(LobInfo.BlobInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column2, dbms, o.length);
                }
                return ObjectFormatter.this.bytesToStringImpl(o.data, o.length, dbms, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, new Converter<LobInfo.FileBlobInfo, String>(){

            @Override
            public String convert(LobInfo.FileBlobInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getTimestampFormat(column2, dbms), o, dbms, column2);
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getTimeFormat().format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                Formatter format = column2 == null || column2.clazz == null ? ObjectFormatter.this.getDateFormat(column2, dbms) : (column2.clazz.endsWith("Timestamp") ? ObjectFormatter.this.getTimestampFormat(column2, dbms) : (column2.clazz.endsWith("Time") ? ObjectFormatter.this.getTimeFormat() : ObjectFormatter.this.getDateFormat(column2, dbms)));
                return ObjectFormatter.dateToString(format, o, dbms, column2);
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getBigIntFormat().format(o);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getDecimalFormat(column2).format(o);
            }
        });
        this.myToString.register(ImageInfo.class, new Converter<ImageInfo, String>(){

            @Override
            public String convert(ImageInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (!forDisplay && o.bytes != null) {
                    return ObjectFormatter.this.bytesToStringImpl(o.bytes, o.size, dbms, false);
                }
                return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
            }
        });
        this.myToString.register(TextInfo.class, new Converter<TextInfo, String>(){

            @Override
            public String convert(TextInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return forDisplay ? o.text : ObjectFormatter.bytesToString(o.bytes, dbms, false);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.isHstore(column2) ? ObjectFormatter.hstoreToString(o, forDisplay) : null;
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (forDisplay) {
                    return String.valueOf(o);
                }
                if (dbms.isTransactSql()) {
                    return o != false ? "1" : "0";
                }
                return String.valueOf(o);
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, new Converter<TimeZonedTimestamp, String>(){

            @Override
            public String convert(TimeZonedTimestamp o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getShortZonedTimestampFormat(column2, dbms), o, dbms, column2);
            }
        });
        this.myToString.register(TimeZonedTime.class, new Converter<TimeZonedTime, String>(){

            @Override
            public String convert(TimeZonedTime o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getShortZonedTimeFormat(column2, dbms).format(o);
            }
        });
        this.myToString.register(ZonedValue.class, new Converter<ZonedValue, String>(){

            @Override
            public String convert(ZonedValue o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (forDisplay) {
                    Object object = ObjectFormatter.objectToObject(o, column2, Dbms.UNKNOWN);
                    return ObjectFormatter.this.objectToString(object, column2, dbms, true);
                }
                return o.getStringRepresentation();
            }
        });
    }

    private static boolean isOracleGUID(byte[] o, DataConsumer.Column column2, Dbms dbms) {
        return dbms.isOracle() && o != null && o.length == 16 && "RAW".equals(column2.typeName);
    }

    public static boolean isHstore(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(0);
        }
        return "hstore".equals(column2.typeName) && "java.util.Map".equals(column2.clazz);
    }

    public static boolean isJson(@NotNull DataConsumer.Column column2, Dbms family) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(1);
        }
        return (family.isMysql() || family.isPostgres()) && StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"json", "jsonb"});
    }

    public static boolean isPostgresArray(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(2);
        }
        return column2.type == 2003;
    }

    public static boolean isBinaryTextColumn(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(3);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column2.typeName);
    }

    public static boolean isPostgresRangeType(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(4);
        }
        return StringUtil.findIgnoreCase((String)column2.typeName, (String[])new String[]{"int4range", "int8range", "numrange", "tsrange", "tstzrange", "daterange"});
    }

    private static String hstoreToString(Map<String, String> hstore, boolean forDisplay) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first) {
                sb.append(',');
                sb.append(forDisplay ? (char)'\n' : ' ');
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), !forDisplay, false);
            sb.append(" => ");
            ObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), !forDisplay, false);
            first = false;
        }
        return sb.toString();
    }

    public static void appendHstoreValue(StringBuilder sb, String value, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value) : value);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    private static String dateToString(@NotNull Formatter formatter, @NotNull Object value, @Nullable Dbms dbms, @Nullable DataConsumer.Column column2) {
        String boundaryString;
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(5);
        }
        if (value == null) {
            ObjectFormatter.$$$reportNull$$$0(6);
        }
        return (boundaryString = BoundaryValueResolver.getInfinityString(dbms, column2, value)) == null ? formatter.format(value) : boundaryString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String charToStringImpl(@NotNull String text2, long wholeLength, boolean bl) {
        void forDisplay;
        if (text2 == null) {
            ObjectFormatter.$$$reportNull$$$0(7);
        }
        String string = forDisplay == false || (long)text2.length() == wholeLength ? text2 : ObjectFormatter.valueToString(text2, text2.length(), wholeLength);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String bytesToStringImpl(@NotNull byte[] o, long wholeLength, Dbms dbms, boolean bl) {
        void forDisplay;
        String stringValue;
        if (o == null) {
            ObjectFormatter.$$$reportNull$$$0(9);
        }
        boolean truncated = wholeLength != (long)o.length;
        boolean wholeValueLoaded = !truncated && o.length < DatabaseSettings.getSettings().getMaxLobLength();
        String string = stringValue = wholeValueLoaded || forDisplay != false ? ObjectFormatter.tryDecodeString(o, CharsetToolkit.UTF8_CHARSET) : null;
        if (wholeValueLoaded && stringValue != null) {
            String string2 = stringValue;
            if (string2 == null) {
                ObjectFormatter.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (forDisplay != false) {
            stringValue = stringValue != null ? stringValue : ObjectFormatter.bytesToString(o, dbms, true);
            String string3 = ObjectFormatter.valueToString(stringValue, o.length, wholeLength);
            if (string3 == null) {
                ObjectFormatter.$$$reportNull$$$0(11);
            }
            return string3;
        }
        String string4 = ObjectFormatter.bytesToString(o, dbms, false);
        if (string4 == null) {
            ObjectFormatter.$$$reportNull$$$0(12);
        }
        return string4;
    }

    private static String getValueNotLoadedString(DataConsumer.Column column2, Dbms dbms, long wholeValueSize) {
        DataType dataType = column2.asDataType();
        String type = dbms != null ? DbImplUtil.getDatabaseDialect(dbms).getTypeName(dataType) : StringUtil.notNullize((String)column2.typeName, (String)"unknown");
        return "(" + StringUtil.toUpperCase((String)type) + "):" + ExtractorsUtil.getPresentableSize(wholeValueSize);
    }

    private static String valueToString(String value, long loadedLength, long wholeLength) {
        boolean truncated = wholeLength != loadedLength;
        CharOut out = CharOut.Util.newSink();
        out.append(ExtractorsUtil.getPresentableSize(wholeLength));
        if (!truncated) {
            out.append("\n").append(value);
        } else {
            out.append(" (").append(ExtractorsUtil.getPresentableSize(loadedLength)).append(" loaded)\n").append(value).append("...");
        }
        return out.toString();
    }

    @Nullable
    public static Object objectToObject(@Nullable Object o, DataConsumer.Column column2, Dbms dbms) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)ourToObject.get(o.getClass());
        Object result2 = converter != null ? (Object)converter.convert(o, column2, dbms, false) : null;
        return result2 != null ? result2 : ObjectFormatter.objectToObject(String.valueOf(o), column2, dbms);
    }

    public static void convertRows(@NotNull List<DataConsumer.Row> rows, @Nullable List<DataConsumer.Column> columns, @NotNull Dbms dbms) {
        if (rows == null) {
            ObjectFormatter.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(14);
        }
        if (columns == null) {
            return;
        }
        for (DataConsumer.Row row : rows) {
            if (row == null || row.values.length != columns.size()) continue;
            for (int i2 = 0; i2 < row.values.length; ++i2) {
                row.values[i2] = ObjectFormatter.objectToObject(row.values[i2], columns.get(i2), dbms);
            }
        }
    }

    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result2 = converter != null ? (String)converter.convert(o, column2, dbms, forDisplay) : null;
        result2 = result2 != null ? result2 : this.objectToString(String.valueOf(o), column2, dbms, forDisplay);
        return (String)ObjectUtils.assertNotNull((Object)result2);
    }

    @Nullable
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
        Object value;
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(15);
        }
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(16);
        }
        return (value = column2.getValue(row)) == ReservedCellValue.NULL ? null : this.objectToString(value, column2, dbms, forDisplay);
    }

    @NotNull
    public String getPlainValue(@NotNull DataConsumer.Column column2, @NotNull DataConsumer.Row row, Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(17);
        }
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(18);
        }
        String string = this.getPlainValue(column2.getValue(row), column2, dbms);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getPlainValue(@Nullable Object object, @NotNull DataConsumer.Column column2, Dbms dbms) {
        String literal;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(20);
        }
        String string = (literal = this.objectToString(object, column2, dbms, true)) == null ? "null" : literal;
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static Object tryDetectObject(@NotNull byte[] bytes) {
        ImageInfo image;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(22);
        }
        if ((image = ObjectFormatter.tryDetectImage(bytes)) != null) {
            return image;
        }
        TextInfo text2 = ObjectFormatter.tryDetectString(bytes);
        if (text2 != null) {
            return text2;
        }
        return null;
    }

    @Nullable
    public static TextInfo tryDetectString(@NotNull byte[] bytes) {
        String guessed;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(23);
        }
        return (guessed = LoadTextUtil.getTextFromBytesOrNull((byte[])bytes, (int)0, (int)bytes.length)) == null ? null : new TextInfo(guessed, bytes);
    }

    @Nullable
    private static String tryDecodeString(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (charset == null) {
            ObjectFormatter.$$$reportNull$$$0(24);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(25);
        }
        CharsetDecoder d2 = charset.newDecoder();
        d2.onMalformedInput(CodingErrorAction.REPORT);
        d2.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            CharBuffer buf = d2.decode(ByteBuffer.wrap(bytes));
            boolean bad = false;
            int len = buf.length();
            for (int i2 = 0; !bad && i2 < len; ++i2) {
                char c2 = buf.charAt(i2);
                bad = c2 < ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t';
            }
            if (!bad) {
                return buf.toString();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ImageInfo tryDetectImage(final @NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(26);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    @Nullable
    private static BufferedImage readImage(@NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(27);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T extractImageData(@NotNull byte[] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            ObjectFormatter.$$$reportNull$$$0(28);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(29);
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> readers = stream != null ? ImageIO.getImageReaders(stream) : ContainerUtil.emptyIterator();
            ImageReader reader = readers.hasNext() ? readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Formatter getTimeFormat() {
        this.initFormats();
        return this.myTimeFormat;
    }

    public Formatter getZonedTimeFormat(DataConsumer.Column column2, Dbms dbms) {
        FormatterKey key2 = new FormatterKey(column2, TimeZonedTime.class);
        Formatter format = this.myFormatCache.get(key2);
        if (format != null) {
            return format;
        }
        CompositeFormatter result2 = FormatterCreator.newZonedTimeFormat(ObjectFormatter.calculateScale(column2, dbms));
        this.myFormatCache.putIfAbsent(key2, result2);
        return result2;
    }

    public Formatter getShortZonedTimeFormat(DataConsumer.Column column2, Dbms dbms) {
        if (this.myShortZonedTimeFormat == null) {
            int scale = ObjectFormatter.calculateScale(column2, dbms);
            this.myShortZonedTimeFormat = FormatterCreator.newShortZonedTimeFormat(scale);
        }
        return this.myShortZonedTimeFormat;
    }

    public Formatter getShortZonedTimestampFormat(DataConsumer.Column column2, Dbms dbms) {
        if (this.myShortZonedTimestampFormat == null) {
            int scale = ObjectFormatter.calculateScale(column2, dbms);
            this.myShortZonedTimestampFormat = FormatterCreator.newShortEraZonedTimestampFormat(scale);
        }
        return this.myShortZonedTimestampFormat;
    }

    public Formatter getTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        FormatterKey key2;
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(30);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(31);
        }
        if ((format = this.myFormatCache.get(key2 = new FormatterKey(column2, Timestamp.class))) != null) {
            return format;
        }
        Formatter result2 = ObjectFormatter.newTimestampFormat(column2, dbms);
        this.myFormatCache.putIfAbsent(key2, result2);
        return result2;
    }

    public CompositeFormatter getZonedTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        FormatterKey key2;
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(32);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(33);
        }
        if ((format = this.myFormatCache.get(key2 = new FormatterKey(column2, TimeZonedTimestamp.class))) instanceof CompositeFormatter) {
            return (CompositeFormatter)format;
        }
        CompositeFormatter result2 = FormatterCreator.newZonedTimestampFormat(dbms, column2, ObjectFormatter.calculateScale(column2, dbms));
        this.myFormatCache.putIfAbsent(key2, result2);
        return result2;
    }

    public Formatter getDateFormat(@Nullable DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(34);
        }
        if (this.myDateFormat != null) {
            return this.myDateFormat;
        }
        this.myDateFormat = ObjectFormatter.newDateFormat(column2, dbms);
        return this.myDateFormat;
    }

    @NotNull
    private <T> String arrayToString(T[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
        if (o.length == 0) {
            String string = forDisplay ? "{}" : "";
            if (string == null) {
                ObjectFormatter.$$$reportNull$$$0(35);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int len = Math.min(o.length, forDisplay ? 100 : o.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(this.objectToString(o[i2], column2, dbms, true));
        }
        if (len < o.length) {
            sb.append(",...");
        }
        sb.append("}");
        String string = sb.toString();
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static Formatter newTimestampFormat(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(37);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(38);
        }
        Formatter formatter = FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraTimestampFormat(dbms, column2, ObjectFormatter.calculateScale(column2, dbms)) : FormatterCreator.newTimestampFormat(ObjectFormatter.calculateScale(column2, dbms));
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(39);
        }
        return formatter;
    }

    @NotNull
    private static Formatter newDateFormat(@Nullable DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(40);
        }
        Formatter formatter = FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraDateFormatter(dbms, column2) : FormatterCreator.newDateFormatter();
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(41);
        }
        return formatter;
    }

    @NotNull
    private static String bitsToString(@NotNull BitString string, @NotNull DataConsumer.Column column2) {
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(42);
        }
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(43);
        }
        long length = string.getLength();
        byte[] bytes = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while ((long)j < length) {
            byte b2 = bytes[j / 8];
            sb.append((b2 & 128 >>> j % 8) != 0 ? (char)'1' : '0');
            ++j;
        }
        while (sb.length() > column2.precision && sb.length() > 0 && sb.charAt(0) == '0') {
            sb.delete(0, 1);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            ObjectFormatter.$$$reportNull$$$0(44);
        }
        return string2;
    }

    private static int calculateScale(@NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(45);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(46);
        }
        int scale = column2.scale;
        if (dbms.isMysql() && column2.type == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)column2.typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)column2.typeName))) {
            scale = column2.precision - 20;
        }
        if (dbms.isSqlite()) {
            scale = 3;
        }
        return Math.min(9, Math.max(0, scale));
    }

    public NumberFormatter getDecimalFormat(@NotNull DataConsumer.Column column2) {
        FormatterKey key2;
        Formatter format;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(47);
        }
        if ((format = this.myFormatCache.get(key2 = new FormatterKey(column2, Number.class))) instanceof NumberFormatter) {
            return (NumberFormatter)format;
        }
        NumberFormatter result2 = ObjectFormatter.isFloat(column2) ? FormatterCreator.newFloatFormat() : FormatterCreator.newDecimalFormat();
        int fractionDigits = column2.scale;
        result2.setParseBigDecimal(BigDecimal.class.getName().equals(column2.clazz));
        result2.setMinimumFractionDigits(ObjectFormatter.isFloatingPoint(column2) || ObjectFormatter.isH2DecimalWithUnspecifiedPrecision(column2) ? 0 : fractionDigits);
        result2.setMaximumFractionDigits(340);
        this.myFormatCache.putIfAbsent(key2, result2);
        return result2;
    }

    @Nullable
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)o).data;
        }
        if (o instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)o).data;
        }
        if (o instanceof TextInfo) {
            return ((TextInfo)o).bytes;
        }
        if (o instanceof ImageInfo) {
            return ((ImageInfo)o).bytes;
        }
        return o;
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable Object value) {
        return value instanceof Boolean ? (Boolean)value : (value instanceof Number ? Boolean.valueOf(((Number)value).intValue() == 1) : (value instanceof String ? ObjectFormatter.parseBoolean((String)value) : null));
    }

    @Nullable
    private static Boolean parseBoolean(@NotNull String value) {
        if (value == null) {
            ObjectFormatter.$$$reportNull$$$0(48);
        }
        return StringUtil.findIgnoreCase((String)value, (String[])new String[]{"1", "true"}) ? Boolean.TRUE : (StringUtil.findIgnoreCase((String)value, (String[])new String[]{"0", "false"}) ? Boolean.FALSE : null);
    }

    public static boolean isFloatingPoint(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(49);
        }
        return ObjectFormatter.isFloat(column2) || ObjectFormatter.isDouble(column2);
    }

    public static boolean isBooleanColumn(@NotNull DataConsumer.Column column2) {
        int type;
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(50);
        }
        return (type = ExtractorsUtil.guessJdbcType(column2)) == 16 || (ObjectFormatter.isBit(column2.typeName, type) || "java.lang.Boolean".equals(column2.clazz)) && column2.precision <= 1;
    }

    public static boolean isNumericColumn(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(51);
        }
        int type = ExtractorsUtil.guessJdbcType(column2);
        return ArrayUtil.contains((Object)type, (Object[])new Integer[]{4, 5, -6, -5, 7, 6, 8, 3, 2}) || ObjectFormatter.isFloatingPoint(column2);
    }

    public static boolean isBitString(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            ObjectFormatter.$$$reportNull$$$0(52);
        }
        return c2.precision > 1 && ObjectFormatter.isBit(c2.typeName, c2.type);
    }

    private static boolean isBit(@Nullable String typeName, int jdbcType) {
        return jdbcType == -7 || typeName != null && StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"bit", "bit varying", "varbit"});
    }

    private static boolean isFloat(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(53);
        }
        return Float.class.getName().equals(column2.clazz) || "oracle.sql.BINARY_FLOAT".equals(column2.clazz);
    }

    private static boolean isDouble(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(54);
        }
        return Double.class.getName().equals(column2.clazz) || "oracle.sql.BINARY_DOUBLE".equals(column2.clazz);
    }

    private static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ObjectFormatter.$$$reportNull$$$0(55);
        }
        return "DECIMAL".equals(column2.typeName) && 65535 == column2.precision && Short.MAX_VALUE == column2.scale;
    }

    @NotNull
    private static String bytesToString(@NotNull byte[] bytes, Dbms dbms, boolean forDisplay) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(56);
        }
        if (forDisplay) {
            String string = DialectUtils.toPresentableHexString(bytes);
            if (string == null) {
                ObjectFormatter.$$$reportNull$$$0(57);
            }
            return string;
        }
        String string = DbImplUtil.getDatabaseDialect(dbms).getBinaryLiteralString(bytes);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(58);
        }
        return string;
    }

    private void initFormats() {
        if (this.myTimeFormat != null) {
            return;
        }
        this.myTimeFormat = FormatterCreator.newTimeFormat();
        this.myNumberFormat = FormatterCreator.newDecimalFormat();
        this.myNumberFormat.setParseIntegerOnly(true);
        this.myBigIntFormat = FormatterCreator.newDecimalFormat();
        this.myBigIntFormat.setParseIntegerOnly(true);
        this.myBigIntFormat.setParseBigDecimal(true);
    }

    @NotNull
    public Formatter getNumberFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myNumberFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(59);
        }
        return numberFormatter;
    }

    @NotNull
    public Formatter getBigIntFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myBigIntFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(60);
        }
        return numberFormatter;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    static {
        Converter<Object, Object> identity = new Converter<Object, Object>(){

            @Override
            public Object convert(Object o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return o;
            }
        };
        ourToObject.put(Object[].class, identity);
        ourToObject.put(long[].class, identity);
        ourToObject.put(int[].class, identity);
        ourToObject.put(double[].class, identity);
        ourToObject.put(TimeZonedValue.class, identity);
        ourToObject.put(LobInfo.ClobInfo.class, identity);
        ourToObject.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, Object>(){

            @Override
            public Object convert(LobInfo.BlobInfo o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = ObjectFormatter.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        ourToObject.put(Boolean.class, identity);
        ourToObject.put(Number.class, identity);
        ourToObject.put(Timestamp.class, identity);
        ourToObject.put(Time.class, identity);
        ourToObject.register(ZonedValue.class, new Converter<ZonedValue, Object>(){

            @Override
            public Object convert(ZonedValue o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                String stringValue = o.getStringRepresentation();
                int scale = ObjectFormatter.calculateScale(column2, dbms);
                ParsePosition position = new ParsePosition(0);
                return ObjectUtils.notNull((Object)(DbImplUtil.isZonedTimeColumn(column2, dbms) ? FormatterCreator.newZonedTimeFormat(scale).parse(stringValue, position) : FormatterCreator.newZonedTimestampFormat(dbms, column2, scale).parse(stringValue, position)), (Object)stringValue);
            }
        });
        ourToObject.register(BitString.class, new Converter<BitString, Object>(){

            @Override
            public Object convert(BitString o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column2);
            }
        });
        ourToObject.register(Date.class, new Converter<Date, Object>(){

            @Override
            public Object convert(Date o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (column2 != null && column2.clazz != null && column2.clazz.endsWith("Timestamp")) {
                    return new Timestamp(o.getTime());
                }
                if (column2 != null && column2.clazz != null && column2.clazz.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        ourToObject.register(byte[].class, new Converter<byte[], Object>(){

            @Override
            public Object convert(byte[] o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                Object detectedObject = ObjectFormatter.tryDetectObject(o);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Clob.class, new Converter<Clob, Object>(){

            @Override
            public Object convert(Clob o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(Blob.class, new Converter<Blob, Object>(){

            @Override
            public Object convert(Blob o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(String.class, new Converter<String, Object>(){

            @Override
            public Object convert(String o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return LobInfo.fromString((String)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Map.class, new Converter<Map, Object>(){

            @Override
            public Object convert(Map o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.isHstore(column2) ? o : null;
            }
        });
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            ourToObject.register(ReservedCellValue.class, new Converter<ReservedCellValue, Object>(){

                @Override
                public Object convert(ReservedCellValue o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                    return o;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 6: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 14: 
            case 31: 
            case 33: 
            case 34: 
            case 38: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExtractor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "charToStringImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToStringImpl";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainValue";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormat";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "bitsToString";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIntFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHstore";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresRangeType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "charToStringImpl";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertRows";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPlainValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectObject";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectString";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tryDecodeString";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectImage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractImageData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTimestampFormat";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimestampFormat";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newTimestampFormat";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormat";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "bitsToString";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "calculateScale";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getDecimalFormat";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isFloatingPoint";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanColumn";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isNumericColumn";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isBitString";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isDouble";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isH2DecimalWithUnspecifiedPrecision";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FormatterKey {
        private final DataConsumer.Column myColumn;
        private final Class<?> myClass;

        FormatterKey(@NotNull DataConsumer.Column column2, @NotNull Class<?> aClass) {
            if (column2 == null) {
                FormatterKey.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                FormatterKey.$$$reportNull$$$0(1);
            }
            this.myColumn = column2;
            this.myClass = aClass;
        }

        public int hashCode() {
            return this.myClass.hashCode() + this.myColumn.hashCode() * 31;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof FormatterKey)) {
                return false;
            }
            FormatterKey key2 = (FormatterKey)obj2;
            return this.myClass.equals(key2.myClass) && this.myColumn.equals(key2.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$FormatterKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextInfo {
        public final String text;
        public final byte[] bytes;

        public TextInfo(@NotNull String text2, @NotNull byte[] bytes) {
            if (text2 == null) {
                TextInfo.$$$reportNull$$$0(0);
            }
            if (bytes == null) {
                TextInfo.$$$reportNull$$$0(1);
            }
            this.text = text2;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextInfo info = (TextInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.bytes);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$TextInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImageInfo {
        public final String format;
        public final int width;
        public final int height;
        public final int size;
        public final byte[] bytes;

        public ImageInfo(@NotNull String format, int width, int height, int size, @Nullable byte[] bytes) {
            if (format == null) {
                ImageInfo.$$$reportNull$$$0(0);
            }
            this.format = format;
            this.width = width;
            this.height = height;
            this.size = size;
            this.bytes = bytes;
        }

        @Nullable
        public BufferedImage createImage() {
            return this.bytes != null ? ObjectFormatter.readImage(this.bytes) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo info = (ImageInfo)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            if (this.size != info.size) {
                return false;
            }
            if (!this.format.equals(info.format)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result2 = this.format.hashCode();
            result2 = 31 * result2 + this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.size;
            result2 = 31 * result2 + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter$ImageInfo", "<init>"));
        }
    }

    private static abstract class ImageDataExtractor<T> {
        private ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }

    private static class MyMap<T>
    extends ConcurrentClassMap<Converter<Object, T>> {
        private MyMap() {
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/ObjectFormatter$MyMap", "register"));
        }
    }

    static interface Converter<X, V> {
        public V convert(X var1, DataConsumer.Column var2, Dbms var3, boolean var4);
    }
}

