/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import b.h.la;
import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SingleNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Matcher {
    static final Logger LOG;
    private static final ThreadLocal<Set<String>> c;
    final Project project;
    final DumbService myDumbService;
    final MatchContext matchContext;
    private boolean a;
    private final GlobalMatchingVisitor d = new GlobalMatchingVisitor();
    ProgressIndicator progress;
    private final TaskScheduler b = new TaskScheduler();
    int totalFilesToScan;
    int scannedFilesCount;
    private static final long e;

    public Matcher(Project project) {
        this(project, null);
    }

    public Matcher(Project project, MatchOptions matchOptions) {
        this.project = project;
        this.matchContext = new MatchContext();
        this.matchContext.setMatcher(this.d);
        if (matchOptions != null) {
            this.matchContext.setOptions(matchOptions);
            this.matchContext.setPattern(PatternCompiler.compilePattern(project, matchOptions, false));
        }
        this.myDumbService = DumbService.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matcher buildMatcher(Project project, FileType fileType, String constraint) {
        long l2 = e ^ 0xA7CDA8B6575L;
        if (StringUtil.isQuotedString((String)constraint)) {
            MatchOptions matchOptions = new MatchOptions();
            matchOptions.setFileType(fileType);
            matchOptions.fillSearchCriteria(StringUtil.unquoteString((String)constraint));
            return new Matcher(project, matchOptions);
        }
        Set<String> set = c.get();
        if (!set.add(constraint)) {
            throw new MalformedPatternException("Pattern recursively references itself");
        }
        try {
            Configuration configuration = ConfigurationManager.getInstance(project).findConfigurationByName(constraint);
            if (configuration == null) {
                throw new MalformedPatternException("Configuration '" + constraint + "' not found");
            }
            Matcher matcher = new Matcher(project, configuration.getMatchOptions());
            return matcher;
        }
        finally {
            set.remove(constraint);
            if (set.isEmpty()) {
                c.remove();
            }
        }
    }

    public static void validate(Project project, MatchOptions options) {
        PatternCompiler.compilePattern(project, options, true);
    }

    public static boolean checkIfShouldAttemptToMatch(MatchContext context, NodeIterator matchedNodes) {
        CompiledPattern compiledPattern = context.getPattern();
        NodeIterator nodeIterator = compiledPattern.getNodes();
        try {
            while (true) {
                PsiElement psiElement;
                if ((psiElement = nodeIterator.current()) == null) {
                    boolean bl2 = true;
                    return bl2;
                }
                PsiElement psiElement2 = matchedNodes.current();
                if (psiElement2 == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                MatchingHandler matchingHandler = compiledPattern.getHandler(psiElement);
                if (matchingHandler == null || !matchingHandler.canMatch(psiElement, psiElement2, context)) {
                    boolean bl4 = false;
                    return bl4;
                }
                matchedNodes.advance();
                nodeIterator.advance();
            }
        }
        finally {
            nodeIterator.reset();
            matchedNodes.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMatchesInElement(MatchContext context, Configuration configuration, NodeIterator matchedNodes, PairProcessor<MatchResult, Configuration> processor) {
        try {
            this.a(context, configuration, matchedNodes.current(), processor);
            context.setShouldRecursivelyMatch(false);
            this.d.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
            context.getOptions().setScope(null);
        }
    }

    public boolean matchNode(@NotNull PsiElement element) {
        MatchOptions matchOptions;
        CollectingMatchResultSink collectingMatchResultSink;
        CompiledPattern compiledPattern;
        if (element == null) {
            Matcher.a(0);
        }
        if ((compiledPattern = this.a(collectingMatchResultSink = new CollectingMatchResultSink(), matchOptions = this.matchContext.getOptions())) == null) {
            return false;
        }
        this.matchContext.setShouldRecursivelyMatch(false);
        this.d.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
        return !collectingMatchResultSink.getMatches().isEmpty();
    }

    public void clearContext() {
        this.matchContext.clear();
    }

    private void a(MatchContext matchContext, final Configuration configuration, PsiElement psiElement, final PairProcessor<MatchResult, Configuration> pairProcessor) {
        if (psiElement == null) {
            return;
        }
        this.matchContext.clear();
        this.matchContext.setMatcher(this.d);
        MatchOptions matchOptions = matchContext.getOptions();
        this.matchContext.setOptions(matchOptions);
        this.matchContext.setPattern(matchContext.getPattern());
        this.matchContext.setShouldRecursivelyMatch(matchContext.shouldRecursivelyMatch());
        this.d.setMatchContext(this.matchContext);
        this.matchContext.setSink(new DuplicateFilteringResultSink(new DefaultMatchResultSink(){

            @Override
            public void newMatch(MatchResult result) {
                pairProcessor.process((Object)result, (Object)configuration);
            }
        }));
    }

    public void precompileOptions(List<Configuration> configurations, Map<Configuration, MatchContext> out) {
        long l2 = e ^ 0x7965C7BB9FB2L;
        for (Configuration configuration : configurations) {
            if (out.containsKey(configuration)) continue;
            MatchContext matchContext = new MatchContext();
            matchContext.setMatcher(this.d);
            MatchOptions matchOptions = configuration.getMatchOptions();
            matchContext.setOptions(matchOptions);
            try {
                matchContext.setPattern(PatternCompiler.compilePattern(this.project, matchOptions, false));
                out.put(configuration, matchContext);
            }
            catch (StructuralSearchException structuralSearchException) {
                LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + '\"', (Throwable)structuralSearchException);
                out.put(configuration, null);
            }
        }
    }

    public void findMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        CompiledPattern compiledPattern = this.a(sink, options);
        if (compiledPattern == null) {
            return;
        }
        this.matchContext.getSink().setMatchingProcess(this.b);
        this.b.init();
        this.progress = this.matchContext.getSink().getProgressIndicator();
        if (this.a) {
            PsiElement[] psiElementArray = ((LocalSearchScope)options.getScope()).getScope();
            PsiElement psiElement = psiElementArray[0].getParent();
            if (this.matchContext.getPattern().getStrategy().continueMatching(psiElement != null ? psiElement : psiElementArray[0])) {
                this.d.matchContext(new SsrFilteringNodeIterator(new ArrayBackedNodeIterator(psiElementArray)));
            } else {
                LanguageFileType languageFileType = (LanguageFileType)this.matchContext.getOptions().getFileType();
                Language language = languageFileType.getLanguage();
                for (PsiElement psiElement2 : psiElementArray) {
                    this.match(psiElement2, language);
                }
            }
            this.matchContext.getSink().matchingFinished();
            return;
        }
        if (!this.a(options, compiledPattern)) {
            return;
        }
        if (this.b.getTaskQueueEndAction() == null) {
            this.b.setTaskQueueEndAction(() -> this.matchContext.getSink().matchingFinished());
        }
        this.b.executeNext();
    }

    private boolean a(MatchOptions matchOptions, CompiledPattern compiledPattern) {
        boolean bl2;
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl3 = bl2 = searchScope != null;
        if (!bl2) {
            searchScope = matchOptions.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
            ContentIterator contentIterator = virtualFile -> {
                if (!virtualFile.isDirectory() && globalSearchScope.contains(virtualFile) && virtualFile.getFileType() != FileTypes.UNKNOWN) {
                    ++this.totalFilesToScan;
                    this.b.addOneTask(new MatchOneVirtualFile(virtualFile));
                }
                return true;
            };
            ReadAction.run(() -> FileBasedIndex.getInstance().iterateIndexableFiles(contentIterator, this.project, this.progress));
            this.progress.setText2("");
        } else {
            PsiElement[] psiElementArray = ((LocalSearchScope)searchScope).getScope();
            this.totalFilesToScan = psiElementArray.length;
            for (int i10 = 0; i10 < psiElementArray.length; ++i10) {
                PsiElement psiElement = psiElementArray[i10];
                if (psiElement == null) continue;
                this.b.addOneTask(new MatchOnePsiFile(psiElement));
                if (!bl2) continue;
                psiElementArray[i10] = null;
            }
        }
        return true;
    }

    private CompiledPattern a(MatchResultSink matchResultSink, MatchOptions matchOptions) {
        this.matchContext.clear();
        this.matchContext.setSink(new DuplicateFilteringResultSink(matchResultSink));
        this.matchContext.setOptions(matchOptions);
        this.matchContext.setMatcher(this.d);
        this.matchContext.setPattern(PatternCompiler.compilePattern(this.project, matchOptions, false));
        this.d.setMatchContext(this.matchContext);
        return this.matchContext.getPattern();
    }

    public List<MatchResult> testFindMatches(String source, MatchOptions options, boolean fileContext, FileType sourceFileType, String sourceExtension, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        try {
            PsiElement[] psiElementArray = MatcherImplUtil.createSourceTreeFromText(source, fileContext ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceExtension, this.project, physicalSourceFile);
            options.setScope((SearchScope)new LocalSearchScope(psiElementArray));
            this.testFindMatches(collectingMatchResultSink, options);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            MalformedPatternException malformedPatternException = new MalformedPatternException();
            malformedPatternException.initCause(incorrectOperationException);
            throw malformedPatternException;
        }
        finally {
            options.setScope(null);
        }
        return collectingMatchResultSink.getMatches();
    }

    public List<MatchResult> testFindMatches(String source, MatchOptions options, boolean fileContext) throws MalformedPatternException, UnsupportedPatternException {
        return this.testFindMatches(source, options, fileContext, options.getFileType(), null, false);
    }

    public void testFindMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        this.a = true;
        try {
            this.findMatches(sink, options);
        }
        finally {
            this.a = false;
        }
    }

    void match(@NotNull PsiElement element, Language language) {
        if (element == null) {
            Matcher.a(1);
        }
        MatchingStrategy matchingStrategy = this.matchContext.getPattern().getStrategy();
        Language language2 = element.getLanguage();
        if (matchingStrategy.continueMatching(element) && language2.isKindOf(language)) {
            this.d.matchContext(SingleNodeIterator.newSingleNodeIterator(element));
            return;
        }
        for (PsiElement psiElement = element.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            this.match(psiElement, language);
        }
        if (element instanceof PsiLanguageInjectionHost) {
            InjectedLanguageManager.getInstance((Project)this.project).enumerate(element, (psiFile, list2) -> this.match((PsiElement)psiFile, language));
        }
    }

    @NotNull
    public List<MatchResult> matchByDownUp(PsiElement element) throws MalformedPatternException, UnsupportedPatternException {
        long l2 = e ^ 0x6C0DFBEDBD0FL;
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        MatchOptions matchOptions = this.matchContext.getOptions();
        CompiledPattern compiledPattern = this.a(collectingMatchResultSink, matchOptions);
        this.matchContext.setShouldRecursivelyMatch(false);
        PsiElement psiElement = compiledPattern.getTargetNode();
        PsiElement psiElement2 = null;
        if (psiElement == null) {
            psiElement = compiledPattern.getNodes().current();
            if (psiElement != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                element = element.getParent();
                if (element == null) {
                    List<MatchResult> list2 = Collections.emptyList();
                    if (list2 == null) {
                        Matcher.a(2);
                    }
                    return list2;
                }
                while (element.getClass() != psiElement.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    List<MatchResult> list3 = Collections.emptyList();
                    if (list3 == null) {
                        Matcher.a(3);
                    }
                    return list3;
                }
                psiElement2 = element;
            }
        } else {
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (structuralSearchProfile == null) {
                List<MatchResult> list4 = Collections.emptyList();
                if (list4 == null) {
                    Matcher.a(4);
                }
                return list4;
            }
            psiElement = structuralSearchProfile.extendMatchedByDownUp(psiElement);
            MatchingHandler matchingHandler = null;
            while (element.getClass() == psiElement.getClass() || compiledPattern.isTypedVar(psiElement) && compiledPattern.getHandler(psiElement).canMatch(psiElement, element, this.matchContext)) {
                matchingHandler = compiledPattern.getHandler(psiElement);
                matchingHandler.setPinnedElement(element);
                psiElement2 = element;
                if (matchingHandler instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                psiElement = psiElement.getParent();
                if (!matchOptions.isLooseMatching()) continue;
                element = structuralSearchProfile.updateCurrentNode(element);
                psiElement = structuralSearchProfile.updateCurrentNode(psiElement);
            }
            if (!(matchingHandler instanceof TopLevelMatchingHandler)) {
                List<MatchResult> list5 = Collections.emptyList();
                if (list5 == null) {
                    Matcher.a(5);
                }
                return list5;
            }
        }
        assert (psiElement != null) : "Could not match down up when no target node";
        this.d.matchContext(SingleNodeIterator.newSingleNodeIterator(psiElement2));
        this.matchContext.getSink().matchingFinished();
        List<MatchResult> list6 = collectingMatchResultSink.getMatches();
        if (list6 == null) {
            Matcher.a(6);
        }
        return list6;
    }

    static {
        e = la.a(3370286432436448286L, 2617391531688527897L, MethodHandles.lookup().lookupClass()).a(221928356110344L);
        long l2 = e ^ 0x57C51B148FE3L;
        LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.MatcherImpl");
        c = ThreadLocal.withInitial(() -> new HashSet());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x1590C4F7D8D5L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/Matcher";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/Matcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "matchByDownUp";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            List<PsiElement> list2 = this.getPsiElementsToProcess();
            if (Matcher.this.progress != null) {
                Matcher.this.progress.setFraction((double)Matcher.this.scannedFilesCount / (double)Matcher.this.totalFilesToScan);
            }
            ++Matcher.this.scannedFilesCount;
            if (list2.isEmpty()) {
                return;
            }
            LanguageFileType languageFileType = (LanguageFileType)Matcher.this.matchContext.getOptions().getFileType();
            Language language = languageFileType.getLanguage();
            for (PsiElement psiElement : list2) {
                if (psiElement instanceof PsiFile) {
                    Matcher.this.matchContext.getSink().processFile((PsiFile)psiElement);
                }
                Matcher.this.myDumbService.runReadActionInSmartMode(() -> {
                    if (!psiElement.isValid()) {
                        return;
                    }
                    StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(psiElement.getLanguage());
                    if (structuralSearchProfile == null) {
                        return;
                    }
                    Matcher.this.match(structuralSearchProfile.extendMatchOnePsiFile(psiElement), language);
                });
            }
        }

        @NotNull
        protected abstract List<PsiElement> getPsiElementsToProcess();
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile a;
        private static final long b = la.a(-2168755232321886469L, 3764121467040703242L, MethodHandles.lookup().lookupClass()).a(234313828630287L);

        MatchOneVirtualFile(VirtualFile file) {
            this.a = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            List list2 = (List)ReadAction.compute(() -> {
                if (!this.a.isValid()) {
                    return Collections.emptyList();
                }
                PsiFile psiFile = PsiManager.getInstance((Project)Matcher.this.project).findFile(this.a);
                if (psiFile == null) {
                    return Collections.emptyList();
                }
                FileViewProvider fileViewProvider = psiFile.getViewProvider();
                SmartList smartList = new SmartList();
                for (Language language : fileViewProvider.getLanguages()) {
                    smartList.add(fileViewProvider.getPsi(language));
                }
                return smartList;
            });
            if (list2 == null) {
                MatchOneVirtualFile.a(0);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x344CFC8D233EL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOneVirtualFile", "getPsiElementsToProcess"));
        }
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement a;
        private static final long b = la.a(-1844668598256718499L, 723405429674656470L, MethodHandles.lookup().lookupClass()).a(68142041784487L);

        MatchOnePsiFile(PsiElement file) {
            this.a = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement psiElement = this.a;
            this.a = null;
            SmartList smartList = new SmartList((Object)psiElement);
            if (smartList == null) {
                MatchOnePsiFile.a(0);
            }
            return smartList;
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x4E9129545452L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOnePsiFile", "getPsiElementsToProcess"));
        }
    }

    class TaskScheduler
    implements MatchingProcess {
        private ArrayList<Runnable> a = new ArrayList();
        private boolean c;
        private Runnable b;
        private boolean d;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.c = true;
        }

        @Override
        public void pause() {
            this.d = true;
        }

        @Override
        public void resume() {
            if (!this.d) {
                return;
            }
            this.d = false;
            this.executeNext();
        }

        @Override
        public boolean isSuspended() {
            return this.d;
        }

        @Override
        public boolean isEnded() {
            return this.c;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.b = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.b;
        }

        void addOneTask(Runnable runnable) {
            this.a.add(runnable);
        }

        void executeNext() {
            while (!this.d && !this.c) {
                if (this.a.isEmpty()) {
                    this.c = true;
                    break;
                }
                Runnable runnable = this.a.remove(this.a.size() - 1);
                try {
                    runnable.run();
                }
                catch (ProcessCanceledException | StructuralSearchException throwable) {
                    this.c = true;
                    this.a();
                    throw throwable;
                }
                catch (Throwable throwable) {
                    LOG.error(throwable);
                }
            }
            if (this.c) {
                this.a();
            }
        }

        void init() {
            this.c = false;
            this.d = false;
            PsiManager.getInstance((Project)Matcher.this.project).startBatchFilesProcessingMode();
        }

        private void a() {
            if (this.a != null) {
                this.b.run();
                if (!Matcher.this.project.isDisposed()) {
                    PsiManager.getInstance((Project)Matcher.this.project).finishBatchFilesProcessingMode();
                }
                this.a = null;
            }
        }
    }
}

