/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import b.h.la;
import com.intellij.psi.PsiElement;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.g;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public class RubyConstantNamingConventionInspection
extends ConventionInspection {
    private static final int f = 3;
    private static final int d = 30;
    private static final String e = "Class.new";
    private static final String c = "Struct.new";
    private static final long j = la.a(-947238202182354908L, -2342310317143750213L, MethodHandles.lookup().lookupClass()).a(266791465215944L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.CONST_UPPERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        return RubyMotionUtil.getInstance().getRubyMotionConstantRegex();
    }

    @Override
    protected int getDefaultMinLength() {
        return 3;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = j ^ 0xD4B6FE7E43CL;
        if ("Constant naming convention" == null) {
            RubyConstantNamingConventionInspection.d(0);
        }
        return "Constant naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = j ^ 0x252241CEB35FL;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Constant name '#ref' is too short" == null) {
                RubyConstantNamingConventionInspection.d(1);
            }
            return "Constant name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Constant name '#ref' is too long" == null) {
                RubyConstantNamingConventionInspection.d(2);
            }
            return "Constant name '#ref' is too long";
        }
        String string2 = "Constant name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyConstantNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = j ^ 0x6BD60C5EEE11L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyConstantNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private static final long b = la.a(7168441514908630064L, 7194593316123549173L, MethodHandles.lookup().lookupClass()).a(219621489711225L);

        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRConstant(RConstant rConstant) {
            RPsiElement rPsiElement;
            long l2 = b ^ 0x56EF463B6F8DL;
            if (!UsageAnalyzer.isDeclaration((RPsiElement)rConstant)) {
                return;
            }
            String string = rConstant.getName();
            if (RubyConstantNamingConventionInspection.this.isValid(string, (PsiElement)rConstant)) {
                return;
            }
            String string2 = rConstant.getType().getPresentableName();
            if ("Class".equals(string2) || "Struct".equals(string2)) {
                return;
            }
            PsiElement psiElement = rConstant.getParent();
            if (psiElement instanceof RAssignmentExpression && (rPsiElement = ((RAssignmentExpression)psiElement).getValue()) != null) {
                String string3 = rPsiElement.getText();
                if (rPsiElement instanceof RCall) {
                    string3 = ((RCall)rPsiElement).getCommand();
                } else if (rPsiElement instanceof RDoBlockCall) {
                    string3 = ((RDoBlockCall)rPsiElement).getCall().getText();
                }
                if (RubyConstantNamingConventionInspection.e.equals(string3) || RubyConstantNamingConventionInspection.c.equals(string3)) {
                    return;
                }
            }
            this.registerConstantError(rConstant, string);
        }

        /* synthetic */ NamingConventionsVisitor(g x1) {
            this();
        }
    }
}

