/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import gnu.trove.TObjectIntHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FileRequireCache;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RStubBasedPsiElementBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RequireArgumentsEvaluator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.a;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RPossibleCallImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RCodeBlockStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RFileUtil {
    private static final Logger c;
    @NonNls
    public static final String RB_FILE_SUFFIX;
    @NonNls
    public static final String SO_FILE_SUFFIX = ".so";
    @NonNls
    public static final String DLL_FILE_SUFFIX = ".dll";
    @NonNls
    public static final String BUNDLE_FILE_SUFFIX = ".bundle";
    @NonNls
    public static final String FILE_EXPAND_PATH = "File.expand_path";
    @NonNls
    public static final String FILE_ABSOLUTE_PATH = "File.absolute_path";
    @NonNls
    public static final String FILE_JOIN = "File.join";
    @NonNls
    public static final String FILE_DIRNAME = "File.dirname(__FILE__)";
    private static final boolean d;
    private static final int a = 5;
    private static final Key<Trinity<String, String, List<String>>> b;
    private static final long e;

    private RFileUtil() {
    }

    @NotNull
    public static TObjectIntHashMap<VirtualFile> createMapByLoadpath(@NotNull Collection<? extends VirtualFile> loadPath) {
        if (loadPath == null) {
            RFileUtil.a(0);
        }
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        int n2 = 1;
        for (VirtualFile virtualFile : loadPath) {
            tObjectIntHashMap.put((Object)virtualFile, n2++);
        }
        TObjectIntHashMap tObjectIntHashMap2 = tObjectIntHashMap;
        if (tObjectIntHashMap2 == null) {
            RFileUtil.a(1);
        }
        return tObjectIntHashMap2;
    }

    public static RFileUtil getInstance() {
        return SingletonHolder.a;
    }

    @NotNull
    public static Collection<? extends VirtualFile> getFilesByRPsiElement(@NotNull RFile file, boolean relativeToDirectory, @NotNull RPsiElement requirement, @Nullable String pathPrefix) {
        if (file == null) {
            RFileUtil.a(2);
        }
        if (requirement == null) {
            RFileUtil.a(3);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        Collection<? extends VirtualFile> collection = RFileUtil.findFilesForName(file.getProject(), RFileUtil.createMapByLoadpath(file.getLoadPath()), RFileUtil.appendPrefix(RFileUtil.evaluateRequirement(virtualFile, (PsiElement)requirement), pathPrefix), virtualFile, relativeToDirectory, null);
        if (collection == null) {
            RFileUtil.a(4);
        }
        return collection;
    }

    @Nullable
    public static String evaluateRequirement(@Nullable VirtualFile file, @Nullable PsiElement requirement) {
        String string;
        long l2 = e ^ 0x7340BA04A02L;
        try {
            string = RequireArgumentsEvaluator.evaluateRequireArg(file, requirement);
        }
        catch (StackOverflowError stackOverflowError) {
            String string2 = "SOE during requirement evaluation. Diagnostic info:\n";
            if (file != null) {
                string2 = string2 + "File: " + file.getPath() + "\n";
            }
            if (requirement != null) {
                string2 = string2 + "Require argument:\n" + requirement.getText();
            }
            c.error(string2, (Throwable)stackOverflowError);
            return null;
        }
        return string;
    }

    @Contract(value="!null, !null -> !null")
    public static String appendPrefix(@Nullable String name, @Nullable String prefix) {
        if (name != null && prefix != null) {
            return prefix + name;
        }
        return name;
    }

    @NotNull
    public static Collection<? extends VirtualFile> findFilesForName(Project project, TObjectIntHashMap<VirtualFile> loadPath, @Nullable String name, @Nullable VirtualFile file, boolean relativeToDirectory, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        VirtualFile virtualFile;
        long l2 = e ^ 0x9BB62BEF0A6L;
        if (name == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                RFileUtil.a(5);
            }
            return set;
        }
        LinkedHashSet<VirtualFile> linkedHashSet = new LinkedHashSet<VirtualFile>();
        VirtualFile virtualFile2 = virtualFile = file != null ? file.getParent() : null;
        if (relativeToDirectory) {
            if (name.indexOf(47) == 0) {
                name = name.substring(1);
            }
            RFileUtil.a(virtualFile, name, linkedHashSet);
        } else {
            if (name.startsWith("../")) {
                RFileUtil.a(virtualFile, name.substring("../".length()), linkedHashSet);
            }
            if (!RFileUtil.b(name, linkedHashSet, (VirtualFileSystem)(file != null ? file.getFileSystem() : LocalFileSystem.getInstance()))) {
                if (virtualFile != null && !virtualFile.equals(project.getBaseDir())) {
                    RFileUtil.a(virtualFile, name, linkedHashSet);
                }
                if (file != null && !name.contains("../")) {
                    String string = name;
                    linkedHashSet.addAll(FileRequireCache.getInstance(project).findFilesUnderLoadPath(loadPath, name, (Computable<Collection<VirtualFile>>)((Computable)() -> RFileUtil.b(project, loadPath, string, filesToProbeCache))));
                }
            }
        }
        LinkedHashSet<VirtualFile> linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            RFileUtil.a(6);
        }
        return linkedHashSet2;
    }

    @NotNull
    private static List<VirtualFile> b(@NotNull Project project, @NotNull TObjectIntHashMap<VirtualFile> tObjectIntHashMap, @NotNull String string, @Nullable Map<String, Collection<VirtualFile>> map) {
        String string2;
        if (project == null) {
            RFileUtil.a(7);
        }
        if (tObjectIntHashMap == null) {
            RFileUtil.a(8);
        }
        if (string == null) {
            RFileUtil.a(9);
        }
        if ((string2 = VfsUtil.extractFileName((String)string)) == null) {
            string2 = string;
        }
        String string3 = string.substring(0, string.length() - string2.length());
        Collection<VirtualFile> collection = RFileUtil.a(project, string2, map);
        List list2 = StringUtil.split((String)PathUtil.getCanonicalPath((String)string3), (String)"/");
        List list3 = (List)((StreamEx)((StreamEx)StreamEx.of(collection).map(virtualFile -> {
            int n2;
            VirtualFile virtualFile2;
            if (tObjectIntHashMap == null) {
                RFileUtil.a(28);
            }
            if ((virtualFile2 = VirtualFileUtil.getAncestorByRelativePath(virtualFile.getParent(), list2)) != null && (n2 = tObjectIntHashMap.get((Object)virtualFile2)) > 0) {
                return Pair.create((Object)n2, (Object)virtualFile);
            }
            return null;
        }).filter(Objects::nonNull)).sorted(Comparator.comparingInt(pair -> (Integer)pair.first))).collapse((pair, pair2) -> ((Integer)pair.first).equals(pair2.first)).map(pair -> (VirtualFile)pair.getSecond()).collect(Collectors.toList());
        if (list3 == null) {
            RFileUtil.a(10);
        }
        return list3;
    }

    @NotNull
    private static Collection<VirtualFile> a(@NotNull Project project, @NotNull String string, @Nullable Map<String, Collection<VirtualFile>> map) {
        long l2 = e ^ 0x243F782853A3L;
        if (project == null) {
            RFileUtil.a(11);
        }
        if (string == null) {
            RFileUtil.a(12);
        }
        if (map != null && map.containsKey(string)) {
            Collection<VirtualFile> collection = map.get(string);
            if (collection == null) {
                RFileUtil.a(13);
            }
            return collection;
        }
        boolean bl2 = string.endsWith(RB_FILE_SUFFIX) || string.endsWith(SO_FILE_SUFFIX) || string.endsWith(DLL_FILE_SUFFIX) || string.endsWith(BUNDLE_FILE_SUFFIX);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        if (!bl2) {
            arrayList.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)(string + RB_FILE_SUFFIX), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        }
        arrayList.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)string, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        if (!bl2 && RFileUtil.a() != null) {
            arrayList.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)(string + RFileUtil.a()), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        }
        if (map != null && arrayList.size() > 5) {
            map.put(string, arrayList);
        }
        ArrayList<VirtualFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RFileUtil.a(14);
        }
        return arrayList2;
    }

    @Nullable
    private static String a() {
        long l2 = e ^ 0x622A694141BDL;
        if (SystemInfo.isMac) {
            return BUNDLE_FILE_SUFFIX;
        }
        if (SystemInfo.isLinux) {
            return SO_FILE_SUFFIX;
        }
        if (SystemInfo.isWindows) {
            return DLL_FILE_SUFFIX;
        }
        return null;
    }

    private static void a(VirtualFile virtualFile, String string, Collection<? super VirtualFile> collection) {
        VirtualFile virtualFile2 = RFileUtil.findFileRelativeTo(virtualFile, string);
        if (virtualFile2 != null) {
            collection.add((VirtualFile)virtualFile2);
        }
    }

    @Nullable
    public static VirtualFile findFileRelativeTo(@Nullable VirtualFile parent, @NotNull String name) {
        long l2 = e ^ 0xC3986C69729L;
        if (name == null) {
            RFileUtil.a(15);
        }
        if (parent == null || !parent.isValid() || !parent.isDirectory() || name.isEmpty()) {
            return null;
        }
        int n2 = name.lastIndexOf(47);
        if (n2 != -1) {
            return RFileUtil.findFileRelativeTo(parent.findFileByRelativePath(name.substring(0, n2)), name.substring(n2 + 1));
        }
        if (name.endsWith(RB_FILE_SUFFIX) || name.endsWith(SO_FILE_SUFFIX) || name.endsWith(DLL_FILE_SUFFIX) || name.endsWith(BUNDLE_FILE_SUFFIX)) {
            return parent.findChild(name);
        }
        VirtualFile virtualFile = parent.findChild(name + RB_FILE_SUFFIX);
        virtualFile = virtualFile == null ? parent.findChild(name) : virtualFile;
        virtualFile = virtualFile == null && SystemInfo.isLinux ? parent.findChild(name + SO_FILE_SUFFIX) : virtualFile;
        virtualFile = virtualFile == null && SystemInfo.isWindows ? parent.findChild(name + DLL_FILE_SUFFIX) : virtualFile;
        virtualFile = virtualFile == null && SystemInfo.isMac ? parent.findChild(name + BUNDLE_FILE_SUFFIX) : virtualFile;
        return virtualFile;
    }

    private static boolean b(String string, Collection<? super VirtualFile> collection, VirtualFileSystem virtualFileSystem) {
        long l2 = e ^ 0x40A4BC496FF0L;
        if (virtualFileSystem instanceof JarFileSystem) {
            return false;
        }
        if (string.endsWith(RB_FILE_SUFFIX) || string.endsWith(SO_FILE_SUFFIX) || string.endsWith(DLL_FILE_SUFFIX) || string.endsWith(BUNDLE_FILE_SUFFIX)) {
            return RFileUtil.a(string, collection, virtualFileSystem);
        }
        if (!(RFileUtil.a(string + RB_FILE_SUFFIX, collection, virtualFileSystem) || RFileUtil.a(string, collection, virtualFileSystem) || SystemInfo.isLinux && RFileUtil.a(string + SO_FILE_SUFFIX, collection, virtualFileSystem) || SystemInfo.isWindows && RFileUtil.a(string + DLL_FILE_SUFFIX, collection, virtualFileSystem))) {
            return SystemInfo.isMac && RFileUtil.a(string + BUNDLE_FILE_SUFFIX, collection, virtualFileSystem);
        }
        return true;
    }

    private static boolean a(String string, Collection<? super VirtualFile> collection, VirtualFileSystem virtualFileSystem) {
        VirtualFile virtualFile = virtualFileSystem.findFileByPath(string);
        if (virtualFile != null && !virtualFile.isDirectory()) {
            collection.add((VirtualFile)virtualFile);
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getAvailableRequiresUrls(@NotNull RFile rFile, @NotNull VirtualFile file, boolean relativeToDirectory, boolean requireRelative) {
        long l2 = e ^ 0x5AD3C47D151BL;
        if (rFile == null) {
            RFileUtil.a(16);
        }
        if (file == null) {
            RFileUtil.a(17);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Project project = rFile.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getParent();
        if (!relativeToDirectory) {
            for (VirtualFile virtualFile2 : rFile.getLoadPath()) {
                if (virtualFile2 != null) {
                    arrayList.addAll(RubyVirtualFileScanner.getRelativeUrls(virtualFile2));
                    continue;
                }
                c.error("Null value as a loadpath found for file: " + rFile.getVirtualFile().getPath());
            }
            if (virtualFile != null) {
                arrayList.addAll(RubyVirtualFileScanner.getRelativeUrlsInProject(projectFileIndex, virtualFile));
            }
        } else if (virtualFile != null) {
            for (String string : RubyVirtualFileScanner.getRelativeUrlsInProject(projectFileIndex, virtualFile)) {
                arrayList.add(requireRelative ? string : '/' + string);
            }
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RFileUtil.a(18);
        }
        return arrayList2;
    }

    @Nullable
    public static String getFileName(@NotNull String arg) {
        if (arg == null) {
            RFileUtil.a(19);
        }
        Pair<String, TextRange> pair = RFileUtil.getNameRange(arg);
        return (String)Pair.getFirst(pair);
    }

    @Nullable
    public static Pair<String, TextRange> getNameRange(@NotNull String arg) {
        TextRange textRange;
        long l2 = e ^ 0x6D924C94D1A4L;
        if (arg == null) {
            RFileUtil.a(20);
        }
        int n2 = 0;
        int n3 = arg.length();
        if (arg.startsWith("%q") || arg.startsWith("%Q")) {
            if (arg.length() > 2) {
                char c10 = arg.charAt(2);
                n2 = 3;
                if (arg.endsWith(String.valueOf(TextUtil.getCloseDelim(c10)))) {
                    --n3;
                }
            }
        } else {
            if (arg.startsWith("\"")) {
                ++n2;
            }
            if (arg.endsWith("\"")) {
                --n3;
            }
            if (arg.startsWith("'")) {
                ++n2;
            }
            if (arg.endsWith("'")) {
                --n3;
            }
        }
        if (n2 >= n3) {
            return null;
        }
        arg = arg.substring(n2, n3);
        TextRange textRange2 = textRange = new TextRange(n2, n3);
        while (true) {
            int n4;
            int n5;
            if ((n5 = arg.lastIndexOf(47)) != -1) {
                arg = arg.substring(n5 + 1);
                textRange = new TextRange(textRange.getStartOffset() + n5 + 1, textRange.getEndOffset());
            }
            if ((n5 = arg.lastIndexOf(92)) != -1) {
                arg = arg.substring(n5 + 1);
                textRange = new TextRange(textRange.getStartOffset() + n5 + 1, textRange.getEndOffset());
            }
            if ((n4 = arg.lastIndexOf(46)) != -1) {
                arg = arg.substring(0, n4);
                textRange = new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + n4);
            }
            if (textRange == textRange2) {
                return Pair.create((Object)arg, (Object)textRange);
            }
            textRange2 = textRange;
        }
    }

    @Nullable
    public PsiElement rename(@NotNull RPsiElement fullCall, @NotNull TextRange textRange, @NotNull String newElementName) {
        if (fullCall == null) {
            RFileUtil.a(21);
        }
        if (textRange == null) {
            RFileUtil.a(22);
        }
        if (newElementName == null) {
            RFileUtil.a(23);
        }
        newElementName = StringUtil.trimEnd((String)newElementName, (String)RB_FILE_SUFFIX);
        String string = fullCall.getText();
        String string2 = textRange.substring(string);
        Pair<String, TextRange> pair = RFileUtil.getNameRange(string2);
        if (pair == null) {
            return null;
        }
        String string3 = ((TextRange)pair.second).replace(string2, newElementName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string, 0, textRange.getStartOffset());
        stringBuilder.append(string3);
        stringBuilder.append(string.substring(textRange.getEndOffset()));
        String string4 = stringBuilder.toString();
        RPsiElement rPsiElement = RubyElementFactory.createElementFromText((PsiElement)fullCall, string4);
        assert (string4.equals(rPsiElement.getText()));
        RubyPsiUtil.replaceInParent((PsiElement)fullCall, (PsiElement)rPsiElement);
        return rPsiElement;
    }

    @Nullable
    public static String getRequirePath(@NotNull VirtualFile file, @NotNull RCall call) {
        if (file == null) {
            RFileUtil.a(24);
        }
        if (call == null) {
            RFileUtil.a(25);
        }
        Trinity trinity = (Trinity)call.getUserData(b);
        String string = file.getPath();
        List list2 = (List)call.getData(new RubyCallType[0]);
        if (trinity != null && string.equals(trinity.first) && list2.equals(trinity.third)) {
            return (String)trinity.second;
        }
        String string2 = RFileUtil.evaluateRequirePath(file, call);
        if (string2 != null) {
            call.putUserData(b, (Object)Trinity.create((Object)string, (Object)string2, (Object)list2));
        }
        return string2;
    }

    @Nullable
    public static String evaluateRequirePath(@NotNull VirtualFile file, @NotNull RCall call) {
        int n2;
        if (file == null) {
            RFileUtil.a(26);
        }
        if (call == null) {
            RFileUtil.a(27);
        }
        RPossibleCallStub rPossibleCallStub = (RPossibleCallStub)((RPossibleCallImpl)call).getStub();
        boolean bl2 = call.getCallType() == RubyCallTypes.AUTOLOAD_CALL;
        int n3 = n2 = bl2 ? 1 : 0;
        if (rPossibleCallStub != null) {
            Project project = call.getProject();
            List list2 = (List)call.getData(new RubyCallType[0]);
            int n4 = list2.size();
            if (n2 < n4) {
                String string = (String)list2.get(n2);
                if (string == null) {
                    return null;
                }
                return RFileUtil.a(file, call, bl2, n2, project, string);
            }
            if (bl2) {
                return RFileUtil.a((RPossibleCallStub<? extends RCall>)rPossibleCallStub, list2);
            }
            return null;
        }
        return RFileUtil.a(file, call.getArguments(), n2, bl2);
    }

    @Nullable
    private static String a(VirtualFile virtualFile, RCall rCall, boolean bl2, int n2, Project project, String string) {
        long l2 = e ^ 0x49895F770459L;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            if (string.contains("#{") && (d || ProjectRootManager.getInstance((Project)project).getFileIndex().isInSourceContent(virtualFile))) {
                return RFileUtil.a(virtualFile, RFileUtil.a(rCall), n2, bl2);
            }
            if (string.indexOf(43) < 0) {
                return string.substring(1, string.length() - 1);
            }
        } else if (string.length() > 1 && string.startsWith("'") && string.endsWith("'") && string.indexOf(43) < 0) {
            return string.substring(1, string.length() - 1);
        }
        if (rCall.getCommand().contains(".") || rCall.getCommand().contains("::")) {
            return null;
        }
        if (string.contains("\n")) {
            return null;
        }
        if (!(string.contains("+") || string.contains("#{") || string.contains("File") || string.contains("FILE"))) {
            return null;
        }
        String string2 = "require(" + string + ")";
        List<RPsiElement> list2 = RubyElementFactory.getNotEmptyTopLevelElements(project, string2, LanguageLevel.DEFAULT);
        String string3 = RFileUtil.evaluateRequirement(virtualFile, (PsiElement)((RCall)list2.get(0)).getArguments().get(0));
        if (c.isDebugEnabled()) {
            c.info("Failed to evaluate full require for: " + virtualFile.getPath() + ", " + rCall.getCommand() + " " + string);
        }
        return string3;
    }

    private static List<RPsiElement> a(Object object) {
        if (object instanceof RCall) {
            return ((RCall)object).getArguments();
        }
        if (object instanceof RBlockCall) {
            return RFileUtil.a(((RBlockCall)object).getCall());
        }
        if (object instanceof StubElement) {
            return RFileUtil.a(((StubElement)object).getPsi());
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String a(RPossibleCallStub<? extends RCall> rPossibleCallStub, List<String> list2) {
        List list3;
        RBlockCall rBlockCall;
        if (list2.size() < 1) {
            return null;
        }
        String string = list2.get(0);
        String string2 = string.charAt(0) == ':' ? string.substring(1) : string;
        RContainer rContainer = (RContainer)rPossibleCallStub.getParentStubOfType(RModule.class);
        rContainer = rContainer == null ? (RContainer)rPossibleCallStub.getParentStubOfType(RClass.class) : rContainer;
        String string3 = rContainer != null ? rContainer.getFQN().getFullPath() : null;
        String string4 = null;
        StubElement stubElement = rPossibleCallStub.getParentStub();
        if (stubElement instanceof RCodeBlockStub) {
            rBlockCall = ((RCodeBlock)((RCodeBlockStub)stubElement).getPsi()).getBlockCall();
            StubElement stubElement2 = stubElement = rBlockCall != null ? ((RStubBasedPsiElementBase)rBlockCall).getStub() : null;
        }
        if (stubElement instanceof RBlockCallStub && (rBlockCall = ((RBlockCallStub)stubElement).getCallData()).getCallType() == RubyCallTypes.AUTOLOAD_UNDER_CALL && (list3 = (List)rBlockCall.getData(RubyCallTypes.AUTOLOAD_UNDER_CALL, new RubyCallType[0])).size() == 1) {
            string4 = (String)list3.get(0);
        }
        return RFileUtil.a(string3, string4, string2);
    }

    @Nullable
    private static String a(VirtualFile virtualFile, List<? extends RPsiElement> list2) {
        RPossibleCall rPossibleCall;
        if (list2.size() < 1) {
            return null;
        }
        RPsiElement rPsiElement = list2.get(0);
        String string = RubyPsiUtil.getElementText((PsiElement)rPsiElement);
        RContainer rContainer = RubyPsiUtil.getContainingRClassOrModule((PsiElement)rPsiElement);
        RBlockCall rBlockCall = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RBlockCall.class);
        String string2 = null;
        if (rBlockCall != null && (rPossibleCall = rBlockCall.getCall()) instanceof RCall) {
            RCall rCall = (RCall)rPossibleCall;
            List list3 = rCall.getArguments();
            if (rCall.getCallType() == RubyCallTypes.AUTOLOAD_UNDER_CALL && list3.size() == 1) {
                RPsiElement rPsiElement2 = (RPsiElement)list3.get(0);
                string2 = RequireArgumentsEvaluator.isSimpleString((PsiElement)rPsiElement2) ? RubyPsiUtil.getElementText((PsiElement)rPsiElement2) : RFileUtil.evaluateRequirement(virtualFile, (PsiElement)rPsiElement2);
            }
        }
        rPossibleCall = rContainer != null ? rContainer.getFQN().getFullPath() : null;
        return RFileUtil.a(new String[]{rPossibleCall, string2, string});
    }

    private static String a(String ... stringArray) {
        long l2 = e ^ 0x61A220CE108CL;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("::");
            }
            stringBuilder.append(string);
        }
        return NamingConventions.toUnderscoreCase(stringBuilder.toString());
    }

    @Nullable
    private static String a(VirtualFile virtualFile, List<? extends RPsiElement> list2, int n2, boolean bl2) {
        if (n2 < list2.size()) {
            return RFileUtil.evaluateRequirement(virtualFile, (PsiElement)list2.get(n2));
        }
        if (bl2 && list2.size() > 0) {
            return RFileUtil.a(virtualFile, list2);
        }
        return null;
    }

    /* synthetic */ RFileUtil(a x0) {
        this();
    }

    static {
        e = la.a(5967789879922896680L, 4373848373954851036L, MethodHandles.lookup().lookupClass()).a(268947561032060L);
        long l2 = e ^ 0x3295BA85D3E0L;
        c = Logger.getInstance(RFileUtil.class);
        RB_FILE_SUFFIX = "." + RubyFileType.RUBY.getDefaultExtension();
        d = RubyVMOptions.evaluateAllRequires();
        b = Key.create((String)"ruby.file.require.path.key");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x552B2031D5ADL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RFileUtil";
                break;
            }
            case 2: 
            case 17: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCall";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RFileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapByLoadpath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByRPsiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesForName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnderLoadPathReverse";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToProbe";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableRequiresUrls";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMapByLoadpath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByRPsiElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findUnderLoadPathReverse";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToProbe";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFileRelativeTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableRequiresUrls";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNameRange";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRequirePath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "evaluateRequirePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findUnderLoadPathReverse$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingletonHolder {
        private static final RFileUtil a = new RFileUtil(null);

        private SingletonHolder() {
        }
    }
}

